﻿//wczytanie danych do ćwiczeń z pliku SQL
//Przed wczytaniem musi być utworzona baza danych
1. Windows Menu Start -> uruchomić wiersz poleceń (cmd)
2. W wierszu poleceń przejść do katalogu z plikiem 'tabela_klienci.sql'
3. Połączyć się z postgres:
psql -U postgres -d kurs_sql

4. Wczytać dane z pliku:
\ir tabela_klienci.sql

########################################################################
//wykonanie selekcji
SELECT * FROM klienci WHERE miasto='Warszawa';

//Wykonanie selekcji
SELECT imie,nazwisko FROM klienci;

//Jednoczesna projekcja i selekcja
SELECT imie,naswisko FROM klienci WHERE miasto='Warszawa';

//Ćwiczenia we własnym zakresie
//Wykorzystanie operatorów >,<,<>,>=,<=,AND,OR,LIKE
2. Znaleźć osoby o imieniu 'Marek'
3. Znaleźć osoby o imieniu 'Marek' z Warszawy
4. Znaleźć osoby z Warszawy i Olsztyna
5. Znaleźć osoby w wieku lat 33
6. Znaleźć osoby starsze niż 65 lat
6. Znaleźć osoby starsze niż 65 lat z Olsztyna
7. Znależć osoby w wieku pomiędzy 33-55 lat (dwa sposoby: użyć >,< oraz BETWEEN 33 AND 55)
8. Znaleźć osoby, których imię zaczyna się na 'A'
9. Znaleźć osoby, których imię zaczyna się na 'A' i składa się tylko  4 znaków
10. Znaleźć osoby, których imię zaczyna się na 'C' starsze niż 50 lat
11. Znaleźć osoby, których imie kończy się na 'ski'
12. Znaleźć osoby mieszkające na ul. Miejskiej w Warszawie
13. Znaleźć osoby, których numer telefonu składa się z 9 znaków
14. Znaleźć osoby w wieku 22,33,55,66 lat (na dwa sposoby)

15. Znajdź kobiety w wieku emerytalnym
select imie,nazwisko,wiek from klienci WHERE imie LIKE '%a' and wiek>=62;

16. Wybierz wszystkie miasta (unikalnie - użyć DISTINCT)
17. Wybierz wszystkie imiona w porządku alfabetycznym (ORDER BY)
18. Wybierz osoby (imie,nazwisko,wiek) w kolejności według wieku rosnąco (ORDER BY wiek ASC)
19. Wybierz osoby (imie,nazwisko,wiek) w kolejności według wieku malejąco (ORDER BY wiek DESC)
20. Wybierz osoby (imie,nazwisko,wiek) w kolejności według imienia i wieku 
21. Wybierz osoby o imionach Jerzy, Barbara, Joanna, Ryszard w kolejności według nazwiska


########################################################################
//Operacje na zbiorach

//UNION - złączenie (bez duplikatów) - przeanalizować działąnie rozbijając na dwie kwerendy
SELECT imie from klienci where wiek=33 UNION SELECT imie from klienci WHERE wiek=24;

//UNION ALL (z duplikatami)
SELECT imie from klienci where wiek=33 UNION ALL SELECT imie from klienci WHERE wiek=24;

//INTERSECT - Aby znaleźć przecięcie zbiorów:
SELECT imie from klienci where wiek=24 INTERSECT SELECT imie from klienci where wiek=33

//To samo przecięcie znajdziemy używając podzapytania:
SELECT imie from klienci AS k  where wiek=24 AND EXISTS (SELECT imie from klienci WHERE imie=k.imie AND wiek=33);


//EXCEPT - różnica zbiorów
SELECT imie from klienci where wiek=33 EXCEPT SELECT imie from klienci WHERE wiek=24;

//Ta sama różnica z użyciem podzapytania
SELECT imie from klienci AS k  where wiek=33 AND NOT EXISTS (SELECT imie from klienci WHERE imie=k.imie AND wiek=24);


########################################################################
//Funkcje agregujące i grupowanie

//Ile rekordów jest w tabeli?
SELECT COUNT(*) from klienci;

//Albo z atrybutem
SELECT COUNT(imie) from klienci;

//Ile miast jest w tabeli?
SELECT COUNT(DISTINCT miasto) from klienci;

//Ile jest imion w tabeli?
SELECT COUNT(DISTINCT imie) from klienci;

//Przećwiczyć inne funkcje: SUM(), MAX(), MIN(), AVG()

//Ilu jest ludzi w wieku starszym niż 65 lat?
SELECT COUNT(*) FROM klienci WHERE wiek>65;

//Ile razy każda z nazw miasta występuje w tabeli, czyli - ilu mamy klientów z każdego miasta?
select miasto,count(*) from klienci GROUP BY miasto;
SELECT COUNT(miasto),miasto FROM klienci GROUP BY miasto;

//Ile razy imię występuje w danym mieście
SELECT COUNT(*),imie,miasto FROM klienci GROUP BY imie,miasto;

//Ilu klientów mamy w poszczególnym wieku? Ilu w wybranej grupie wiekowej?
select wiek,count(*) from klienci GROUP BY wiek;
select wiek,count(*) from klienci WHERE wiek>20 AND wiek<30 GROUP BY wiek;

//Ilu mamy klientów w poszczególnym wieku, lecz starszych niż 50 lat?
select wiek,count(*) from klienci GROUP BY wiek HAVING wiek>50;


//czy w numerach PESEL występują duplikaty? (nie powinno być)
select count(PESEL) FROM klienci;
select count(DISTINCT PESEL) FROM klienci;

//Ile jest duplikatów nueru PESEL?:
select count(PESEL)-count(distinct PESEL) from klienci;

//W tabeli występuje duplikat numeru PESEL - który to rekord?
select PESEL,count(*) from klienci GROUP BY PESEL;
select PESEL,count(*) from klienci GROUP BY PESEL HAVING count(*)>1;
select PESEL from klienci GROUP BY PESEL HAVING count(*)>1;

//Jakie są dane osoby, której PESEL występuje dwukrotnie?
SELECT imie,nazwisko,adres,telefon FROM klienci WHERE PESEL IN (select PESEL from klienci GROUP BY PESEL HAVING count(*)>1);

//Czy w bazie występują osoby mieszkające w Olsztynie, mające ten sam numer telefonu? Wyświetl ich dane.
SELECT imie,nazwisko,adres,telefon 
FROM klienci 
WHERE telefon IN (select telefon from klienci GROUP BY telefon HAVING count(*)>1) AND miasto='Olsztyn' ORDER BY telefon;

//Obllicz średni wiek klientów z Olsztyna
SELECT miasto,AVG(wiek) FROM klienci GROUP BY miasto;

//Wybierz klientów starszych od wieku średniego w bazie:
SELECT miasto,imie,wiek from klienci WHERE wiek > (SELECT AVG(wiek) FROM klienci);

//Oblicz różnicę pomiędzy wiekiem klienta a średnią:
SELECT miasto,imie,wiek,wiek-(SELECT AVG(wiek) FROM klienci) from klienci;

//Ilu klientów ma na imie "Jan"?
SELECT count(*) from klienci WHERE imie='Jan';


########################################################################
//operacje na stringach i konwersja typów (omówione we wstępie teoretycznym)

//Wybierz rok urodzenia na podstawie wartości numeru PESEL, funkcja LEFT
SELECT LEFT(PESEL,2) FROM klienci;

Jest też RIGHT() i SUBSTR()
Więcej o przetwarzaniu stringów: https://www.postgresql.org/docs/9.1/static/funkcjas-string.html

//Wytworzenie roku z użyciem konkatenacji (||)
SELECT '19'||LEFT(PESEL,2) FROM klienci;

//Wytworzenie całej daty urodzenia
//jako string
SELECT '19'||LEFT(PESEL,2)||'-'||SUBSTR(PESEL,3,2)||'-'||SUBSTR(PESEL,5,2) FROM klienci;

//przekonwertowanie na typ DATE:
SELECT CAST('19'||LEFT(PESEL,2)||'-'||SUBSTR(PESEL,3,2)||'-'||SUBSTR(PESEL,5,2) as DATE) as data FROM klienci;


########################################################################
//Tworzenie i manipulacja strukturą bazy danych (Tabele)

//Najprostszy przykład:
CREATE TABLE firma (nazwa varchar(20), siedziba varchar(20));

//Najprostsze wstawienie danych
INSERT INTO firma VALUES('Compaq','Olsztyn');

//Kolejne wstawienie
INSERT INTO firma(siedziba) VALUES('Warszawa');

INSERT INTO firma(siedziba,nazwa) VALUES('Szczecin','Sony');

//Usuwanie danych:
DELETE FROM firma WHERE nazwa='Compaq';

//Aktualizacja danych w tabeli
UPDATE firma SET nazwa='Panasonic' WHERE siedziba='Warszawa';


//Zmiana struktury tabeli
ALTER TABLE firma ADD adres varchar(20);

//Usunięcie dodanej kolumny
ALTER TABLE firma DROP COLUMN adres;

//Dodanie kilku kolumn na raz
ALTER TABLE firma ADD adres varchar(20), ADD value int;

//Proszę wykonać kilka operacji wstawiania i aktualizacji danych w tabeli firma

//usunięcie tabeli
DROP TABLE firma;

//Bardziej rozbudowany przykład - z określeniem klucza

CREATE TABLE firma (nazwa char(20) PRIMARY KEY, siedziba char(20));

//Lub też:

CREATE TABLE firma (nazwa char(20), siedziba char(20), PRIMARY KEY(nazwa));

//Tabela z kluczem wielowartościowym:
CREATE TABLE firma (nazwa char(20), siedziba char(20), PRIMARY KEY(nazwa,siedziba));


########################################################################
//Zlączenia, relacje, zależności od klucza

//stworzenie dwóch tabel powiązanych relacją dzialki() i budynki()
CREATE TABLE dzialki(ID_dzialki serial PRIMARY KEY, numer varchar(20), powierzchnia real, rodzaj char(10));
CREATE TABLE budynki(ID_budynku serial PRIMARY KEY, adres char(20), kondygnacje int, funkcja char(5), ID_dzialki int, FOREIGN KEY(ID_dzialki) REFERENCES dzialki(ID_dzialki));

//wstawienie danych do tabel
//dzialki
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2234', 123.43, 'B');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('4434', 1235.43, 'B');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2534', 4433.43, 'B');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2237', 6644.43, 'B');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2238', 7766.43, 'B');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2239', 14554.43, 'R');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2240/1', 8888.43, 'B');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2240/2', 7876.43, 'B');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2266', 43256.43, 'R');
INSERT INTO dzialki(numer,powierzchnia,rodzaj) VALUES('2277', 789.43, 'R');

//budynki
INSERT INTO budynki(adres,kondygnacje,funkcja,ID_dzialki) VALUES('3',2,'m',1);
INSERT INTO budynki(adres,kondygnacje,funkcja,ID_dzialki) VALUES('5',2,'m',3);
INSERT INTO budynki(adres,kondygnacje,funkcja,ID_dzialki) VALUES('9',2,'k',5);
INSERT INTO budynki(adres,kondygnacje,funkcja,ID_dzialki) VALUES('12',2,'h',6);

//Ze względu na zależność od klucza, poniższe wstawienie nie powinno się udać (wartość klucza nie istnieje w tabeli referencyjnej)
INSERT INTO budynki(adres,kondygnacje,funkcja,ID_dzialki) VALUES('12',2,'h',100);


//wyberanie danych z obu tabel na raz
select * from dzialki join budynki on dzialki.ID_dzialki=budynki.ID_dzialki;


//####### Dodatkowo ### 
//Stworzenie trzech powiązanych tabel firma(), produkt(), wytwarzany_przez()

CREATE TABLE firma (fnazwa char(20), siedziba char(20), PRIMARY KEY(fnazwa));

CREATE TABLE produkt (pnazwa char(20) PRIMARY KEY, kategoria char(20), cena real);

CREATE TABLE wytwarzany_przez (fnazwa char(20), pnazwa char(20), wytwarzany_od date, PRIMARY KEY(fnazwa,pnazwa), FOREIGN KEY(fnazwa) REFERENCES firma(fnazwa), FOREIGN KEY(pnazwa) REFERENCES produkt(pnazwa));


//Wstawienie danych:

INSERT INTO firma VALUES ('Sony','Olsztyn');
INSERT INTO firma VALUES ('Stomil','Olsztyn');
INSERT INTO firma VALUES ('Panasonic','Krakow');

INSERT INTO produkt VALUES ('Walkman', 'odtwarzacze', 200);
INSERT INTO produkt VALUES ('Deck', 'audio', 3000);
INSERT INTO produkt VALUES ('Deck2', 'audio', 2000);
INSERT INTO produkt VALUES ('Tyre A', 'auto czesci', 400);
INSERT INTO produkt VALUES ('Tyre FX', 'auto czesci', 800);

//To nie powinno zadziałać - z powodu ograniczenia na kluczu:
INSERT INTO wytwarzany_przez VALUES ('Brak', 'Brak','2012-12-12');

//To powinno zadziałać:
INSERT INTO wytwarzany_przez VALUES ('Stomil', 'Tyre A','2012-12-12');

//To również nie powinno zadziałać - również z powodu zależności i powiązań z innymi tabelami:
drop table firma;

//Wybranie danych ze wszystkich tabel - złączenie trzech tabel (przykład):
select * from firma JOIN wytwarzany_przez ON firma.fnazwa = wytwarzany_przez.fnazwa JOIN produkt on wytwarzany_przez.pnazwa=produkt.pnazwa;

########################################################################
//Zapytania hierarchiczne, wyrażenie WITH

//zobrazujmy hierarchię pracowników (przypiszmy poziomy organizacyjne poszczególnym pracownikom)
//poniższe dostępne również w pliku tabela_pracownicy.sql
//Można ją wczytać poleceniem:
\ir tabela_pracownicy.sql


CREATE TABLE pracownicy (
pracownik_id serial PRIMARY KEY,
imie_nazwisko VARCHAR NOT NULL,
kierownik_id INT
);

INSERT INTO pracownicy (
pracownik_id,
imie_nazwisko,
kierownik_id
)
VALUES
(1, 'Janusz Wieyski', NULL),
(2, 'Megan Lock', 1),
(3, 'Sandra Klusek', 1),
(4, 'Zenobiusz Frycz', 1),
(5, 'Tomasz Akwinowicz', 1),
(6, 'Barbara Tuk', 2),
(7, 'Ryszard Gaweda', 2),
(8, 'Maksymilian Bicz', 2),
(9, 'Beniamin Franek', 2),
(10, 'Karolina Duda', 3),
(11, 'Nikolas Kaczka', 3),
(12, 'Aleksandra Kwas', 3),
(13, 'Dominik Pierwszy', 3),
(14, 'Leonard Gray', 4),
(15, 'Eryk Drazkiewicz', 4),
(16, 'Pawel Lisicki', 7),
(17, 'Radzimir Warzyszczykiewicz', 7),
(18, 'Franciszek Turski', 8),
(19, 'Nikodem Ferguson', 8),
(20, 'Krzysztof Rozsadek', 8);


WITH RECURSIVE podwladni AS (
SELECT
pracownik_id,
kierownik_id,
imie_nazwisko,
0 AS Poziom_Org
FROM
pracownicy
WHERE
kierownik_id is NULL
UNION
SELECT
pr.pracownik_id,
pr.kierownik_id,
pr.imie_nazwisko,
Poziom_Org + 1
FROM
pracownicy pr
INNER JOIN podwladni po ON po.pracownik_id = pr.kierownik_id
) SELECT * FROM podwladni;


########################################################################
//Widoki - tworzenie i usuwanie widoków

//Utworzenie widoku na tabeli budynki
CREATE VIEW moj_widok AS SELECT adres,funkcja from budynki;

//wybranie danych z widoku
SELECT * FROM moj_widok;

//Wstawienie danych do widoku
INSERT INTO moj_widok VALUES('12/12','ko');

//Widok koresponduje z tabelą. Zmiany wprowadzone w widoku są widoczne w tabeli.
//Sprawdźmy:
SELECT * FROM budynki;

########################################################################
//Indeksy

//Utworzenie indeksu w tabeli budynki na polu adres.
CREATE INDEX adres_idx ON budynki(adres);

//lub
CREATE UNIQUE INDEX adres_idx ON budynki(adres);

//sprawdzenie czy został utworzony
\d budynki

//Usunięcie indeksu
DROP INDEX adres_idx;


########################################################################
//Transakcje
BEGIN;
INSERT INTO budynki(adres,kondygnacje,funkcja,ID_dzialki) VALUES('TTTT',777,'mmmm',1);

SELECT * FROM budynki

//Zatwierdzenie wprowadzonej zmiany
COMMIT

//Cofnięcie zmiany (musi nastąpić przez COMMIT, lub zamiast)
ROLLBACK

### POSTGIS ############################################################
########################################################################
https://postgis.net/docs/manual-1.5/ch04.html
//OPERACJE NA DANYCH PRZESTRZENNYCH

//Na początek należy utworzyć bazę w oparciu o rozszerzenie POSTGIS
//Po zainstalowaniu POSTGIS w POSTGREQSL powinna być dostępna przykładowa baza danych przestrzennych o nazwie podobnej do:
postgis_23_sample

//należy utworzyć na jej podstawie (jako template) własną bazę danych przestrzennych z użyciem programu pgAdmin
//Można też utworzyć ją ręcznie, pamiętając o doinstalowaniu rozszerzeń (Extensions) postgis.

//Zakładamy, że na tą chwilę utworzona jest baza danych przestrzennych o nazwie np. postgis_kurs

//Stworzenie tabeli z geometrią punktową
 CREATE TABLE przystanek (
fid serial NOT NULL PRIMARY KEY,
geometry GEOMETRY
);

//Wstawienie danych
INSERT INTO przystanek(geometry) VALUES (ST_PointFromText('POINT(10 10)'));

//Wyświetlenie danych
SELECT fid,ST_AsText(geometry) FROM przystanek;

//Wprowadzone dane są widoczne w pgAdmin
//Można tam również uzyskać podgląd graficzny wprowadzonej geometrii (Geometry Viewer)

CREATE TABLE budynek ( 
  fid serial NOT NULL PRIMARY KEY, 
   adres CHARACTER VARYING(64),  
   obrys GEOMETRY);
   
INSERT INTO budynek(adres,obrys) VALUES ('Zielona 12',ST_PolyFromText('POLYGON( ( 50 31, 54 31, 54 29, 50 29, 50 31) )'));

CREATE TABLE rzeka ( 
  fid serial NOT NULL PRIMARY KEY, 
   nazwa CHARACTER VARYING(64),  
   geom GEOMETRY);
   
INSERT INTO rzeka(nazwa,geom) VALUES ('Wisla',ST_LineFromText('LINESTRING( 38 48, 44 41, 41 36, 44 31, 52 18 )'));   
   

//Przykładowe analizy przestrzenne
-- //from OGC Simple Features - part2 SQL option

SELECT ST_Dimension(obrys)  FROM budynek;
SELECT ST_GeometryType(obrys)  FROM budynek;
SELECT ST_AsText(ST_Envelope(geom)) FROM rzeka;
SELECT ST_X(geometry)  FROM przystanek;
SELECT ST_Y(geometry)  FROM przystanek;
SELECT ST_AsText(ST_StartPoint(geom)) FROM rzeka;
SELECT ST_AsText(ST_EndPoint(geom)) FROM rzeka;
SELECT ST_Length(geom) FROM rzeka;
SELECT ST_NumPoints(geom) FROM rzeka;
SELECT ST_AsText(ST_PointN(geom, 1)) FROM rzeka; 
SELECT ST_AsText(ST_Centroid(obrys)) FROM budynek;
SELECT ST_Area(obrys) FROM budynek;
SELECT ST_Contains(obrys, ST_PointFromText('POINT(52 30)')) FROM budynek;
SELECT ST_Equals(obrys,  ST_PolyFromText('POLYGON( ( 67 13, 67 18, 59 18, 59 13, 67 13) )',1)) FROM budynek;
SELECT ST_Disjoint(obrys, geom) FROM budynek, rzeka;
SELECT ST_Within(geometry,obrys) FROM przystanek,budynek;
SELECT ST_Overlaps(geom, obrys) FROM rzeka, budynek;
SELECT ST_Crosses(geom, obrys) FROM rzeka, budynek;
SELECT ST_Intersects(geom, obrys) FROM rzeka, budynek;

//Ponadto:
Intersection() 
Difference()
SymDifference()
Buffer()
ConvexHull()

########################################################################
//Załadowanie danych SHP do POSTGIS (PostGIS shapefile import/export manager)
//Załadowanie (import) warstw:
   gminy.shp
   zbiornik_wodny_wroclawski.shp
   
//Połączenie z QGIS
//dodawanie warstw w QGIS najlepiej:
menu główne: Bazy danych --> Zarządzanie bazami --> zarządzanie bazami

//połączeniami zarządza się (jak nie jest na wierzchu):
Widok->panele->panel przeglądarki 

//W panelu przeglądarki - prawym na PostGIS -> nowe połączenie...  

########################################################################
//Zapytania w PGADMIN
//Prawym na tabelę -> Query tool
//zbiorniki o powierzchni większej niż....
SELECT geom FROM zbiornik_wodny_wroclawski WHERE ST_Area(geom)>10000;
SELECT max(ST_Area(geom));

//największy zbiornik
SELECT geom FROM zbiornik_wodny_wroclawski WHERE ST_Area(geom) in (SELECT max(ST_Area(geom)) FROM zbiornik_wodny_wroclawski);

//największa gmina
-- analogicznie do zadania ze zbiornikami - samodzielnie

//zapis wyniku do oddzielnej tabeli
SELECT * INTO najwiekszy_zbiornik FROM zbiornik_wodny_wroclawski WHERE ST_Area(geom) in (SELECT max(ST_Area(geom)) FROM zbiornik_wodny_wroclawski);

//w której gminie jest największy zbiornik?
SELECT gminy.geom,jpt_nazwa_ FROM gminy,najwiekszy_zbiornik WHERE ST_Contains(gminy.geom,najwiekszy_zbiornik.geom)=true;

//Operatory w postgis - przykład
SELECT najwiekszy_zbiornik.geom && gminy.geom, jpt_nazwa_ FROM najwiekszy_zbiornik,gminy; 

//eksport danych z tabeli najwiekszy_zbiornik do SHP
Wykorzystać PostGIS shapefile import/export manager
Eksportowana tabela powinna mieć choć jedną kolumnę niegeometryczną (opisową)  
   

   
########################################################################
//Indeksy na danych przestrzennych
//Postgis domyślnie zakłada indeksy na wartościach geometrycznych tworzonych tabel
//W przypadku braku indeksu można go stworzyć ręcznie
  
//index GIST na danych przestrzennych

CREATE INDEX idx_towns_geom
ON towns
USING gist(geom);


//index b-tree na zwykłych danych

CREATE INDEX idx_towns_town
ON towns
USING btree(town);

##########################################################################
//rastry
//raster z tabeli gminy
SELECT 1 AS rid,ST_AsRaster((SELECT ST_Collect(geom) FROM gminy),1000,1000) INTO raster_gminy2;

//raster w konsoli z pliku cea.tif (trzeba być konsolą w katalogu gdzie znajduje się raster)
//wygenerowanie pliku SQL
raster2pgsql -s 4326 -I -M cea.tif -F -t 100x100 public.cea_raster > raster.sql

//logowanie do postgres
psql -U postgres -d postgis_kurs

//ładowanie kwerendy SQL
\ir raster.sql

//Została utworzona tabela z kafelkowanym rastrem
//Wczytanie w QGIS:
1. Menu: Bazy danych -> Zarządzanie bazami -> Zarządzanie bazami
2. Wybrać bazę, odszukać tabelę, kliknąć prawym na tabeli -> Dodaj do obszaru mapy


//### Funkcje zarządzające danymi rastrowymi i operatory rastrowe
//Tabela rastrowa
CREATE TABLE myRasterTable(rid serial primary key, rast raster);

//Wstawienie danych rastrowych
INSERT INTO myRasterTable(rid,rast)
VALUES(3, ST_MakeEmptyRaster( 100, 100, 0.0005, 0.0005, 1, 1, 0, 0, 4326) );

//Stworzenie kolejnej tabel na bazie istniejących danych rastrowych
INSERT INTO myRasterTable(rid,rast)
SELECT 4, ST_MakeEmptyRaster(rast)
  FROM myRasterTable WHERE rid = 3;

  
//Wyświetlenie zawartości tabeli rastrowej
SELECT rid, (md).*
  FROM (SELECT rid, ST_MetaData(rast) As md
              FROM myRasterTable
              WHERE rid IN(3,4)) As foo;

