<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:fn="http://www.w3.org/2004/10/xpath-functions" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:gco="http://www.isotc211.org/2005/gco" xmlns="urn:x-inspire:specification:gmlas:CadastralParcels:3.0" xmlns:cp="urn:x-inspire:specification:gmlas:CadastralParcels:3.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:base="urn:x-inspire:specification:gmlas:BaseTypes:3.2" xmlns:gn="urn:x-inspire:specification:gmlas:GeographicalNames:3.0" xmlns:au="urn:x-inspire:specification:gmlas:AdministrativeUnits:3.0" xmlns:gmd="http://www.isotc211.org/2005/gmd" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:param name="counter"/>
	<!-- in case root=SpatialDataSet: change gml:FeatureCollection to base:SpatialDataSet-->
	<xsl:variable name="NativenessValue">
		<xsl:text>urn:x inspire:def:codeList:INSPIRE:NativenessValue</xsl:text>
	</xsl:variable>
	<xsl:variable name="NameStatusValue">
		<xsl:text>urn:x inspire:def:codeList:INSPIRE:NameStatusValue</xsl:text>
	</xsl:variable>
	<xsl:variable name="CadastralZoningLevelValue">
		<xsl:text>urn:x inspire:def:codeList:INSPIRE:CadastralZoningLevelValue</xsl:text>
	</xsl:variable>
	<xsl:variable name="GrammaticalNumberValue">
		<xsl:text>urn:x inspire:def:codeList:INSPIRE:GrammaticalNumberValue</xsl:text>
	</xsl:variable>
	<xsl:variable name="GrammaticalGenderValue">
		<xsl:text>urn:x inspire:def:codeList:INSPIRE:GrammaticalGenderValue</xsl:text>
	</xsl:variable>
	<xsl:template match="cp:FeatureCollection">
		<xsl:variable name="root32" select="local-name(/*)"/>
		<!--xsl:element name="gml:{$root32}"-->
		<xsl:element name="base:SpatialDataSet" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="document('')/xsl:stylesheet/namespace::*[local-name()='xlink' or local-name()='gmd'  or local-name()='xsi' or local-name()='gml'  or local-name()='gn' or local-name()='au' or local-name()='gco' or local-name()='base' or local-name()='cp']"/>
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@srsName">
		<xsl:choose>
			<xsl:when test="contains(.,'2180')">
				<xsl:attribute name="srsName"><xsl:text>urn:ogc:def:crs:EPSG::2180</xsl:text></xsl:attribute>
			</xsl:when>
			<xsl:when test="contains(.,'4258')">
				<xsl:attribute name="srsName"><xsl:text>urn:ogc:def:crs:EPSG::4258</xsl:text></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|node()"/>
	</xsl:template>
	<!-- change xsi:schemaLocation value -->
	<xsl:template match="cp:FeatureCollection/@xsi:schemaLocation">
		<xsl:variable name="schemaLocationValue" select="."/>
		<xsl:attribute name="xsi:schemaLocation"><xsl:text>urn:x-inspire:specification:gmlas:CadastralParcels:3.0 http://geoportal.gov.pl/INSPIRE/schemas/CadastralParcels.xsd</xsl:text></xsl:attribute>
		<xsl:apply-templates select="@*|node()"/>
	</xsl:template>
	<xsl:template match="cp:FeatureCollection/@numberOfFeatures">
		<xsl:apply-templates select="@*|node()"/>
	</xsl:template>
	<!--xsl:template match="cp:FeatureCollection/@cp:numberOfFeatures" /-->
	<!-- element gml:boundedBy -->
	<xsl:template name="inspireId">
		<xsl:variable name="localIdValue" select="."/>
		<xsl:element name="cp:inspireId" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
			<xsl:element name="base:Identifier" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
				<xsl:element name="base:localId" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
					<xsl:value-of select="$localIdValue"/>
				</xsl:element>
				<xsl:element name="base:namespace" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
					<xsl:value-of select="following-sibling::*[local-name()='namespace']"/>
				</xsl:element>
				<xsl:if test="following-sibling::*[local-name()='versionId'] or following-sibling::*[local-name()='V_versionId']">
					<xsl:variable name="versionId" select="following-sibling::*[local-name()='versionId']"/>
					<xsl:variable name="v_versionId" select="following-sibling::*[local-name()='V_versionId']"/>
					<xsl:element name="base:versionId" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
						<xsl:if test="$versionId!=' '">
							<xsl:value-of select="$versionId"/>
						</xsl:if>
						<xsl:if test="$v_versionId!=' '">
							<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
							<xsl:attribute name="nilReason"><xsl:value-of select="$v_versionId"/></xsl:attribute>
						</xsl:if>
					</xsl:element>
				</xsl:if>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="gml:boundedBy">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
		<xsl:element name="base:identifier" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
			<xsl:element name="base:Identifier" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
				<xsl:element name="base:localId" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
					<xsl:text>CP</xsl:text>
				</xsl:element>
				<xsl:element name="base:namespace" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
					<xsl:text>PL.ZIPRLN.0.LPIS.1.6</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:element name="base:metadata" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
			<xsl:attribute name="xlink:href" namespace="http://www.w3.org/1999/xlink"><xsl:text>http://sdi.geoportal.gov.pl/csw/service.svc/get?request=GetRecordById&amp;service=CSW&amp;version=2.0.2&amp;outputformat=text/xml&amp;outputschema=http://www.isotc211.org/2005/gmd&amp;elementsetname=full&amp;Id=184c8b53-7e8c-43c1-9278-adffb6b29056</xsl:text></xsl:attribute>
		</xsl:element>
	</xsl:template>
	<!-- change gml:featureMember to base:member in case root=base:SpatialDataSet -->
	<xsl:template match="gml:featureMember">
		<xsl:element name="base:member" namespace="urn:x-inspire:specification:gmlas:BaseTypes:3.2">
			<xsl:copy-of select="document('')/xsl:stylesheet/namespace::*[local-name()='xlink' or local-name()='gmd'  or local-name()='xsi' or local-name()='gml' or local-name()='gn' or local-name()='au' or local-name()='gco' or local-name()='base' or local-name()='cp']"/>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
		
	<xsl:template match="cp:CP_CadastralParcel">
		<xsl:variable name="inspire_localId" select="descendant::*[local-name()='localId']"/>
		<xsl:variable name="inspire_namespace" select="descendant::*[local-name()='namespace']"/>
		<xsl:element name="cp:CadastralParcel" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
			<xsl:attribute name="gml:id" namespace="http://www.opengis.net/gml/3.2"><xsl:value-of select="$inspire_namespace"/><xsl:text>_</xsl:text><xsl:value-of select="$inspire_localId"/></xsl:attribute>
			<xsl:element name="gml:identifier" namespace="http://www.opengis.net/gml/3.2">
				<xsl:attribute name="codeSpace"><xsl:text>http://inspire.jrc.ec.europa.eu/ids</xsl:text></xsl:attribute>
				<xsl:text>http://geoportal.gov.pl/INSPIRE/dane/</xsl:text>
				<xsl:value-of select="$inspire_namespace"/>
				<xsl:text>/</xsl:text>
				<xsl:value-of select="$inspire_localId"/>
			</xsl:element>
			<xsl:apply-templates select="*|node()"/>
		</xsl:element>
	</xsl:template>
		
	<xsl:template match="cp:CP_CadastralZoning">
		<xsl:variable name="inspire_localId" select="descendant::*[local-name()='localId']"/>
		<xsl:variable name="inspire_namespace" select="descendant::*[local-name()='namespace']"/>
		<xsl:element name="cp:CadastralZoning" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
			<xsl:attribute name="gml:id" namespace="http://www.opengis.net/gml/3.2"><xsl:value-of select="$inspire_namespace"/><xsl:text>_</xsl:text><xsl:value-of select="$inspire_localId"/></xsl:attribute>
			<xsl:element name="gml:identifier" namespace="http://www.opengis.net/gml/3.2">
				<xsl:attribute name="codeSpace"><xsl:text>http://inspire.jrc.ec.europa.eu/ids</xsl:text></xsl:attribute>
				<xsl:text>http://geoportal.gov.pl/INSPIRE/dane/</xsl:text>
				<xsl:value-of select="$inspire_namespace"/>
				<xsl:text>/</xsl:text>
				<xsl:value-of select="$inspire_localId"/>
			</xsl:element>
			<xsl:apply-templates select="*|node()"/>
		</xsl:element>
	</xsl:template>
		
	<xsl:template match="cp:CP_CadastralBoundary">
		<xsl:variable name="inspire_localId" select="descendant::*[local-name()='localId']"/>
		<xsl:variable name="inspire_namespace" select="descendant::*[local-name()='namespace']"/>
		<xsl:element name="cp:CadastralBoundary" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
			<xsl:attribute name="gml:id" namespace="http://www.opengis.net/gml/3.2"><xsl:value-of select="$inspire_namespace"/><xsl:text>_</xsl:text><xsl:value-of select="$inspire_localId"/></xsl:attribute>
			<xsl:element name="gml:identifier" namespace="http://www.opengis.net/gml/3.2">
				<xsl:attribute name="codeSpace"><xsl:text>http://inspire.jrc.ec.europa.eu/ids</xsl:text></xsl:attribute>
				<xsl:text>http://geoportal.gov.pl/INSPIRE/dane/</xsl:text>
				<xsl:value-of select="$inspire_namespace"/>
				<xsl:text>/</xsl:text>
				<xsl:value-of select="$inspire_localId"/>
			</xsl:element>
			<xsl:apply-templates select="*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<!-- add gml:id to gml:Polygon node -->
	<xsl:template match="gml:Polygon">
		<xsl:variable name="inspire_localId">
			<xsl:if test="local-name()='localId'">
				<xsl:value-of select="."/>
			</xsl:if>
			<xsl:if test="preceding::*[local-name()='localId']">
				<xsl:value-of select="preceding::*[local-name()='localId']"/>
			</xsl:if>
		</xsl:variable>
		<xsl:element name="gml:Polygon" namespace="http://www.opengis.net/gml/3.2">
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="gml:CompositeSurface">
		<xsl:variable name="inspire_localId">
			<xsl:if test="local-name()='localId'">
				<xsl:value-of select="."/>
			</xsl:if>
			<xsl:if test="preceding::*[local-name()='localId']">
				<xsl:value-of select="preceding::*[local-name()='localId']"/>
			</xsl:if>
		</xsl:variable>
		<xsl:element name="gml:MultiSurface" namespace="http://www.opengis.net/gml/3.2">
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="gml:CompositeCurve">
		<xsl:variable name="inspire_localId">
			<xsl:if test="local-name()='localId'">
				<xsl:value-of select="."/>
			</xsl:if>
			<xsl:if test="preceding::*[local-name()='localId']">
				<xsl:value-of select="preceding::*[local-name()='localId']"/>
			</xsl:if>
		</xsl:variable>
		<xsl:element name="gml:CompositeCurve">
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="gml:posList" mode="gmlPos">
		<xsl:element name="gml:LineStringSegment" namespace="http://www.opengis.net/gml/3.2">
			<xsl:element name="gml:posList">
				<xsl:copy-of select="@*"/>
				<xsl:apply-templates select="@*|node()"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="gml:MultiCurve">
		<xsl:element name="gml:Curve" namespace="http://www.opengis.net/gml/3.2">
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:element name="gml:segments" namespace="http://www.opengis.net/gml/3.2">
				<xsl:apply-templates select="node()" mode="gmlPos"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="gml:MultiSurface">
		<xsl:element name="gml:MultiSurface" namespace="http://www.opengis.net/gml/3.2">
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<!-- add gml:id to gml:Line node -->
	<xsl:template match="gml:Line">
		<xsl:variable name="inspire_localId">
			<xsl:if test="local-name()='localId'">
				<xsl:value-of select="."/>
			</xsl:if>
			<xsl:if test="preceding::*[local-name()='localId']">
				<xsl:value-of select="preceding::*[local-name()='localId']"/>
			</xsl:if>
		</xsl:variable>
		<xsl:element name="gml:Line" namespace="http://www.opengis.net/gml/3.2">
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="gml:LineString">
		<xsl:element name="gml:LineString" namespace="http://www.opengis.net/gml/3.2">
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="gml:Point">
		<xsl:element name="gml:Point" namespace="http://www.opengis.net/gml/3.2">
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<!-- Template containing other transformation -->
	<xsl:template match="@*|node()">
		<xsl:variable name="newName">
			<xsl:choose>
				<xsl:when test="contains(name(),':')">
					<xsl:value-of select="substring-after(name(),':')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="name()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			
			<xsl:when test="contains(name(),'CP_CadastralParcel')">
				<xsl:variable name="inspire_localId" select="descendant::*[local-name()='localId']"/>
				<xsl:variable name="inspire_namespace" select="descendant::*[local-name()='namespace']"/>
				<xsl:element name="cp:CadastralParcel" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:attribute name="gml:id" namespace="http://www.opengis.net/gml/3.2"><xsl:value-of select="$inspire_namespace"/><xsl:text>_</xsl:text><xsl:value-of select="$inspire_localId"/></xsl:attribute>
						<xsl:element name="gml:identifier" namespace="http://www.opengis.net/gml/3.2">
							<xsl:attribute name="codeSpace"><xsl:text>http://inspire.jrc.ec.europa.eu/ids</xsl:text></xsl:attribute>
							<xsl:text>http://geoportal.gov.pl/INSPIRE/dane/</xsl:text>
							<xsl:value-of select="$inspire_namespace"/>
							<xsl:text>/</xsl:text>
							<xsl:value-of select="$inspire_localId"/>
						</xsl:element>
						<xsl:apply-templates select="*|node()"/>
				</xsl:element>
			</xsl:when>
				
			<xsl:when test="contains(name(),'CP_CadastralZoning')">
				<xsl:variable name="inspire_localId" select="descendant::*[local-name()='localId']"/>
				<xsl:variable name="inspire_namespace" select="descendant::*[local-name()='namespace']"/>
				<xsl:element name="cp:CadastralZoning" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:attribute name="gml:id" namespace="http://www.opengis.net/gml/3.2"><xsl:value-of select="$inspire_namespace"/><xsl:text>_</xsl:text><xsl:value-of select="$inspire_localId"/></xsl:attribute>
					<xsl:element name="gml:identifier" namespace="http://www.opengis.net/gml/3.2">
						<xsl:attribute name="codeSpace"><xsl:text>http://inspire.jrc.ec.europa.eu/ids</xsl:text></xsl:attribute>
						<xsl:text>http://geoportal.gov.pl/INSPIRE/dane/</xsl:text>
						<xsl:value-of select="$inspire_namespace"/>
						<xsl:text>/</xsl:text>
						<xsl:value-of select="$inspire_localId"/>
					</xsl:element>
					<xsl:apply-templates select="*|node()"/>
				</xsl:element>
			</xsl:when>
				
			<xsl:when test="local-name()='areaValue'">
				<xsl:element name="cp:areaValue" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:attribute name="uom">
						<xsl:value-of select="following-sibling::*[local-name()='uom']"/>
					</xsl:attribute>
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:when>
				
			<!-- transformation for geometry
				add nessecary elements and moves geometry element to other position  -->
			<xsl:when test="contains(name(),'localId') and following-sibling::*[local-name()='geometry']">
					
				<xsl:for-each select="following-sibling::*[local-name()='geometry']">
					<xsl:choose>
						<xsl:when test="child::*[local-name()='CompositeCurve']">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:apply-templates select="gml:CompositeCurve"/>
							</xsl:element>
						</xsl:when>
						<xsl:when test="child::*[local-name()='MultiCurve']">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:apply-templates select="gml:MultiCurve"/>
							</xsl:element>
						</xsl:when>
						<xsl:when test="child::*[local-name()='CompositeSurface']">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:apply-templates select="gml:CompositeSurface"/>
							</xsl:element>
						</xsl:when>
						<xsl:when test="child::*[local-name()='MultiSurface']">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:apply-templates select="gml:MultiSurface"/>
							</xsl:element>
						</xsl:when>
						<xsl:when test="child::*[local-name()='Polygon'] and not(ancestor::*[local-name()='CompositeSurface'] or ancestor::*[local-name()='MultiSurface'] )">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:element name="gml:MultiSurface" namespace="http://www.opengis.net/gml/3.2">
									<xsl:attribute name="gml:id"><xsl:text>id</xsl:text><xsl:value-of select="$counter"/><xsl:number count="*" format="1" level="any"/></xsl:attribute>
									<xsl:element name="gml:surfaceMember" namespace="http://www.opengis.net/gml/3.2">
										<xsl:apply-templates select="gml:Polygon"/>
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:when>
						<xsl:when test="child::*[local-name()='Line']">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:apply-templates select="gml:Line"/>
							</xsl:element>
						</xsl:when>
						<xsl:when test="child::*[local-name()='Polygon'] and ancestor::*[local-name()='CompositeSurface'] or ancestor::*[local-name()='MultiSurface']">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:apply-templates select="gml:Polygon"/>
							</xsl:element>
						</xsl:when>
						<xsl:when test="child::*[local-name()='LineString'] ">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:apply-templates select="gml:LineString"/>
							</xsl:element>
						</xsl:when>
						<xsl:when test="child::*[local-name()='Point']">
							<xsl:element name="cp:geometry" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
								<xsl:apply-templates select="gml:Point"/>
							</xsl:element>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
					
				<xsl:if test="local-name()='localId'">
					<xsl:call-template name="inspireId"/>
				</xsl:if>	
			</xsl:when>				
				
			<xsl:when test="local-name()='label'">
				<xsl:element name="cp:label" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:when>
				
			<xsl:when test="local-name()='nationalCadastralReference'">
				<xsl:element name="cp:nationalCadastralReference" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:when>
				
			<xsl:when test="local-name()='nationalCadastalZoningReference'">
				<xsl:element name="cp:nationalCadastalZoningReference" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:when>
				
			<xsl:when test="local-name()='uom'"/>
			<!-- check if element contains word 'v_' in name 
				if true: get element value, and get element name without voidable word-->
			<xsl:when test="contains(local-name(),'V_')">
				<xsl:variable name="tempVar" select="local-name(.)"/>
				<xsl:variable name="myVal">
					<xsl:call-template name="string-replace">
						<xsl:with-param name="text" select="$tempVar"/>
						<xsl:with-param name="replace" select="'V_'"/>
						<xsl:with-param name="by" select="''"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="contains(local-name(),'versionId') and preceding-sibling::*[local-name()='localId']"/>
					<xsl:when test="contains(local-name(),'estimatedAccuracy')">
						<xsl:element name="cp:{$myVal}" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
							<xsl:attribute name="uom"><xsl:text>m</xsl:text></xsl:attribute>
							<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
							<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
						</xsl:element>
					</xsl:when>
					<xsl:when test="contains(local-name(),'levelName') and not(preceding-sibling::*[local-name()='levelName'] or following-sibling::*[local-name()='levelName'])">
						<xsl:element name="cp:{$myVal}" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
							<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
							<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
						</xsl:element>
					</xsl:when>
					<xsl:when test="contains(local-name(),'levelName') and (preceding-sibling::*[local-name()='levelName'] or following-sibling::*[local-name()='levelName'])"/>
					<xsl:otherwise>
						<!-- create new element without voidable word and add nilReason attribute -->
						<xsl:element name="cp:{$myVal}" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
							<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
							<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
				
			<xsl:when test="local-name()='geometry'"/>
			<xsl:when test="local-name()='beginLifespanVersion'">
				<xsl:element name="cp:beginLifespanVersion" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:value-of select="."/>
					<xsl:text>+01:00</xsl:text>
				</xsl:element>
			</xsl:when>
			<xsl:when test="local-name()='endLifespanVersion'">
				<xsl:element name="cp:endLifespanVersion" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:value-of select="."/>
					<xsl:text>+01:00</xsl:text>
				</xsl:element>
			</xsl:when>
			<xsl:when test="local-name()='validFrom'">
				<xsl:element name="cp:validFrom" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:value-of select="."/>
					<xsl:text>+01:00</xsl:text>
				</xsl:element>
			</xsl:when>
			<xsl:when test="local-name()='validTo'">
				<xsl:element name="cp:validTo" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:value-of select="."/>
					<xsl:text>+01:00</xsl:text>
				</xsl:element>
			</xsl:when>
			<!-- 
							if current node is versionId or namespace do nothing - do not copy
				 -->
			<xsl:when test="local-name()='versionId' or local-name()='namespace' or local-name()='V_versionId'"/>
			<!---**************    modification of levelName  ***************-->
			<xsl:when test="local-name()='levelName'">
				<xsl:variable name="levelNameValue" select="."/>
				<xsl:element name="cp:levelName" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:element name="gmd:LocalisedCharacterString" namespace="http://www.isotc211.org/2005/gmd">
						<xsl:attribute name="locale"><xsl:text>http://www.geoportal.gov.pl/dictionary/langDefinition.xml#pl-PL</xsl:text></xsl:attribute>
						<xsl:value-of select="$levelNameValue"/>
					</xsl:element>
				</xsl:element>
			</xsl:when>
			<!---**************    modification of level  ***************-->
			<xsl:when test="local-name()='level'">
				<xsl:element name="cp:level" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:attribute name="codeSpace"><xsl:value-of select="$CadastralZoningLevelValue"/></xsl:attribute>
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:when>
			<!---**************    modification of name (GeographicalName)  ***************-->
			<xsl:when test="local-name()='nameSpelText'">
				<xsl:variable name="nameText" select="."/>
				<xsl:variable name="nameScript" select="preceding-sibling::*[local-name()='nameSpelScript'] | following-sibling::*[local-name()='nameSpelScript'] "/>
				<xsl:variable name="name_vScript" select="preceding-sibling::*[local-name()='nameSpelVScript'] | following-sibling::*[local-name()='nameSpelVScript'] "/>
				<xsl:variable name="nameSpelTrans" select="preceding-sibling::*[local-name()='nameSpelTrans'] | following-sibling::*[local-name()='nameSpelTrans'] "/>
				<xsl:variable name="nameSpel_vTrans" select="preceding-sibling::*[local-name()='nameSpelVTrans'] | following-sibling::*[local-name()='nameSpelVTrans'] "/>
				<xsl:variable name="nameLang" select="preceding-sibling::*[local-name()='nameGeoLanguage'] | following-sibling::*[local-name()='nameGeoLanguage'] "/>
				<xsl:variable name="name_vLang" select="preceding-sibling::*[local-name()='nameGeoVLanguage'] | following-sibling::*[local-name()='nameGeoVLanguage'] "/>
				<xsl:variable name="nameNativeness" select="preceding-sibling::*[local-name()='nameGeoNativeness'] | following-sibling::*[local-name()='nameGeoNativeness'] "/>
				<xsl:variable name="name_vNativeness" select="preceding-sibling::*[local-name()='nameGeoVNativeness'] | following-sibling::*[local-name()='nameGeoVNativeness'] "/>
				<xsl:variable name="nameNameStatus" select="preceding-sibling::*[local-name()='nameGeoNamestatus'] | following-sibling::*[local-name()='nameGeoNamestatus'] "/>
				<xsl:variable name="name_vNameStatus" select="preceding-sibling::*[local-name()='nameGeoVNamestatus'] | following-sibling::*[local-name()='nameGeoVNamestatus'] "/>
				<xsl:variable name="nameSourceOfName" select="preceding-sibling::*[local-name()='nameGeoSourceOfName'] | following-sibling::*[local-name()='nameGeoSourceOfName'] "/>
				<xsl:variable name="name_vSourceOfName" select="preceding-sibling::*[local-name()='nameGeoVSourceOfName'] | following-sibling::*[local-name()='nameGeoVSourceOfName'] "/>
				<xsl:variable name="namePronunciationIPA" select="preceding-sibling::*[local-name()='nameGeoPronunciationipa'] | following-sibling::*[local-name()='nameGeoPronunciationipa'] "/>
				<xsl:variable name="name_vPronunciationIPA" select="preceding-sibling::*[local-name()='nameGeoVPronunciationipa'] | following-sibling::*[local-name()='nameGeoVPronunciationipa'] "/>
				<xsl:variable name="namePronunciationsound" select="preceding-sibling::*[local-name()='nameGeoPronunciationsound'] | following-sibling::*[local-name()='nameGeoPronunciationsound'] "/>
				<xsl:variable name="name_vPronunciationsound" select="preceding-sibling::*[local-name()='nameGeoVPronunciationsound'] | following-sibling::*[local-name()='nameGeoVPronunciationsound'] "/>
				<xsl:variable name="name_vPronunciation" select="preceding-sibling::*[local-name()='nameGeoVPronunciation'] | following-sibling::*[local-name()='nameGeoVPronunciation'] "/>
				<xsl:variable name="nameGramGender" select="preceding-sibling::*[local-name()='nameGeoGrammaticalgender'] | following-sibling::*[local-name()='nameGeoGrammaticalgender'] "/>
				<xsl:variable name="name_vGramGender" select="preceding-sibling::*[local-name()='nameGeoVGrammaticalgender'] | following-sibling::*[local-name()='nameGeoVGrammaticalgender'] "/>
				<xsl:variable name="nameGramNumber" select="preceding-sibling::*[local-name()='nameGeoGrammaticalnumber'] | following-sibling::*[local-name()='nameGeoGrammaticalnumber'] "/>
				<xsl:variable name="name_vGramNumber" select="preceding-sibling::*[local-name()='nameGeoVGrammaticalnumber'] | following-sibling::*[local-name()='nameGeoVGrammaticalnumber'] "/>
				<xsl:element name="cp:name" namespace="urn:x-inspire:specification:gmlas:CadastralParcels:3.0">
					<xsl:element name="gn:GeographicalName" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
						<xsl:element name="gn:language" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
							<xsl:choose>
								<xsl:when test="$nameLang!=' '">
									<xsl:value-of select="$nameLang"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
									<xsl:attribute name="nilReason"><xsl:value-of select="$name_vLang"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:element>
						<xsl:element name="gn:nativeness" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
							<xsl:choose>
								<xsl:when test="$nameNativeness!=' '">
									<xsl:attribute name="codeSpace"><xsl:value-of select="$NativenessValue"/></xsl:attribute>
									<xsl:value-of select="$nameNativeness"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
									<xsl:attribute name="nilReason"><xsl:value-of select="$name_vNativeness"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:element>
						<xsl:element name="gn:nameStatus" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
							<xsl:choose>
								<xsl:when test="$nameNameStatus!=' '">
									<xsl:attribute name="codeSpace"><xsl:value-of select="$NameStatusValue"/></xsl:attribute>
									<xsl:value-of select="$nameNameStatus"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
									<xsl:attribute name="nilReason"><xsl:value-of select="$name_vNameStatus"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:element>
						<xsl:element name="gn:sourceOfName" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
							<xsl:choose>
								<xsl:when test="$nameSourceOfName!=' '">
									<xsl:value-of select="$nameSourceOfName"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
									<xsl:attribute name="nilReason"><xsl:value-of select="$name_vSourceOfName"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:element>
						<xsl:element name="gn:pronunciation" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
							<xsl:choose>
								<xsl:when test="$namePronunciationIPA!=' ' or $namePronunciationsound!=' ' or $name_vPronunciationIPA!=' ' or $name_vPronunciationsound!=' '">
									<xsl:element name="gn:PronunciationOfName" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
										<xsl:choose>
											<xsl:when test="$namePronunciationsound!=' '">
												<xsl:element name="gn:pronunciationSoundLink" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
													<xsl:value-of select="$namePronunciationsound"/>
												</xsl:element>
											</xsl:when>
											<xsl:when test="$name_vPronunciationsound!=' '">
												<xsl:element name="gn:pronunciationSoundLink" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
													<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
													<xsl:attribute name="nilReason"><xsl:value-of select="$name_vPronunciationsound"/></xsl:attribute>
												</xsl:element>
											</xsl:when>
											<xsl:when test="$namePronunciationIPA!=' '">
												<xsl:element name="gn:pronunciationIPA" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
													<xsl:value-of select="$namePronunciationIPA"/>
												</xsl:element>
											</xsl:when>
											<xsl:when test="$name_vPronunciationIPA!=' '">
												<xsl:element name="gn:pronunciationIPA" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
													<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
													<xsl:attribute name="nilReason"><xsl:value-of select="$namePronunciationIPA"/></xsl:attribute>
												</xsl:element>
											</xsl:when>
										</xsl:choose>
									</xsl:element>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
									<xsl:attribute name="nilReason"><xsl:value-of select="$name_vPronunciation"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:element>
						<xsl:element name="gn:spelling" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
							<xsl:element name="gn:SpellingOfName" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
								<xsl:element name="gn:text" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
									<xsl:value-of select="$nameText"/>
								</xsl:element>
								<xsl:element name="gn:script" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
									<xsl:choose>
										<xsl:when test="$nameScript!=' '">
											<xsl:value-of select="$nameScript"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
											<xsl:attribute name="nilReason"><xsl:value-of select="$name_vScript"/></xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:element>
								<xsl:if test="$nameSpelTrans!=' '">
									<xsl:element name="gn:transliterationScheme" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
										<xsl:choose>
											<xsl:when test="$nameSpelTrans!=' '">
												<xsl:value-of select="$nameSpelTrans"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="$nameSpel_vTrans!=' '">
														<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
														<xsl:attribute name="nilReason"><xsl:value-of select="$nameSpel_vTrans"/></xsl:attribute>
													</xsl:when>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:element>
								</xsl:if>
							</xsl:element>
						</xsl:element>
						<xsl:if test="$nameGramGender!=' '">
							<xsl:element name="gn:grammaticalGender" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
								<xsl:attribute name="codeSpace"><xsl:value-of select="$GrammaticalGenderValue"/></xsl:attribute>
								<xsl:value-of select="$nameGramGender"/>
							</xsl:element>
						</xsl:if>
						<xsl:if test="$name_vGramGender!=' '">
							<xsl:element name="gn:grammaticalGender" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
								<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
								<xsl:attribute name="nilReason"><xsl:value-of select="$name_vGramGender"/></xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="$nameGramNumber!=' '">
							<xsl:element name="gn:grammaticalNumber" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
								<xsl:attribute name="codeSpace"><xsl:value-of select="$GrammaticalNumberValue"/></xsl:attribute>
								<xsl:value-of select="$nameGramNumber"/>
							</xsl:element>
						</xsl:if>
						<xsl:if test="$name_vGramNumber!=' '">
							<xsl:element name="gn:grammaticalNumber" namespace="urn:x-inspire:specification:gmlas:GeographicalNames:3.0">
								<xsl:attribute name="xsi:nil" namespace="http://www.w3.org/2001/XMLSchema-instance">true</xsl:attribute>
								<xsl:attribute name="nilReason"><xsl:value-of select="$name_vGramNumber"/></xsl:attribute>
							</xsl:element>
						</xsl:if>
					</xsl:element>
				</xsl:element>
			</xsl:when>
			<xsl:when test="local-name()='nameSpelText' or local-name()='nameSpelScript' or local-name()='nameSpelVScript' or local-name()='nameSpelTrans' or local-name()='nameSpelVTrans' or local-name()='nameGeoLanguage'  or local-name()='nameGeoVLanguage' or local-name()='nameGeoNativeness' or local-name()='nameGeoVNativeness' or local-name()='nameGeoNamestatus' or local-name()='nameGeoVNamestatus' or local-name()='nameGeoSourceOfName' or local-name()='nameGeoVSourceOfName' or local-name()='nameGeoPronunciationipa' or local-name()='nameGeoVPronunciationipa' or local-name()='nameGeoPronunciationsound' or local-name()='nameGeoVPronunciationsound' or local-name()='nameGeoVPronunciation' or local-name()='nameGeoGrammaticalgender' or local-name()='nameGeoVGrammaticalgender' or local-name()='nameGeoGrammaticalnumber' or local-name()='nameGeoVGrammaticalnumber'">
			</xsl:when>
			<!---**************    modification of association role (xlink)  ***************-->
			<xsl:when test="local-name()='basicPropertyUnit' or local-name()='administrativeUnit' or local-name()='zoning' or local-name()='upperLevelUnit' or local-name()='parcel'">
				<xsl:variable name="associationValue" select="."/>
				<xsl:variable name="associationName" select="name()"/>
				<xsl:if test="contains($associationValue, ',')">
					<xsl:call-template name="parseString">
						<xsl:with-param name="list" select="$associationValue"/>
						<xsl:with-param name="elName" select="$associationName"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="not(contains($associationValue, ','))">
					<xsl:element name="{$associationName}">
						<xsl:attribute name="xlink:href" namespace="http://www.w3.org/1999/xlink"><xsl:value-of select="$associationValue"/></xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="parseString">
		<xsl:param name="list"/>
		<xsl:param name="elName"/>
		<xsl:if test="contains($list, ',')">
			<xsl:element name="{$elName}">
				<xsl:attribute name="xlink:href" namespace="http://www.w3.org/1999/xlink"><xsl:value-of select="substring-before($list, ',')"/></xsl:attribute>
			</xsl:element>
			<xsl:call-template name="parseString">
				<xsl:with-param name="list" select="substring-after($list, ',')"/>
				<xsl:with-param name="elName" select="$elName"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="not(contains($list, ','))">
			<xsl:element name="{$elName}">
				<xsl:attribute name="xlink:href" namespace="http://www.w3.org/1999/xlink"><xsl:value-of select="$list"/></xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template name="string-replace">
		<xsl:param name="text"/>
		<xsl:param name="replace"/>
		<xsl:param name="by"/>
		<xsl:choose>
			<xsl:when test="contains($text, $replace)">
				<xsl:value-of select="substring-before($text, $replace)"/>
				<xsl:value-of select="$by"/>
				<xsl:call-template name="string-replace">
					<xsl:with-param name="text" select="substring-after($text, $replace)"/>
					<xsl:with-param name="replace" select="$replace"/>
					<xsl:with-param name="by" select="$by"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
