<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>

	<xsl:variable name="allResults" select="document(/list/entry/@name)//Result" />

	<xsl:template match="/">
		<xsl:variable name="name" select="'TestOne'" />
		
		<h2>Totals</h2>
		<table border="1" cellSpacing="0" cellPadding="5" >
			<tr bgcolor="#9acd32">
				<th>Test Name</th>
				<th>Total Passed</th>
				<th>Total Failed</th>
			</tr>
			<tr>
				<td><xsl:value-of select="$name"/></td>
				<td><xsl:value-of select="count($allResults[@testName = $name] [@outcome = 'Passed'])"/></td>
				<td><xsl:value-of select="count($allResults[@testName = $name] [@outcome = 'Failed'])"/></td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>