<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>

	<xsl:template match="/">
		<xsl:for-each select="/list/entry">
			<xsl:apply-templates select="document(@name)/container/build/*[local-name()='Tests']" />
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="*[local-name()='Results']">
		<xsl:variable name="name" select="'TestOne'" />
		<xsl:variable name="totalPassed" select="*[local-name()='Result'][@testName = 'TestOne'][@outcome = 'Passed']" />
		<xsl:variable name="totalFailed" select="*[local-name()='Result'][@testName = 'TestOne'][@outcome = 'Failed']" />

		<h2>Totals</h2>
		<table border="1" cellSpacing="0" cellPadding="5" >
			<tr bgcolor="#9acd32">
				<th>Test Name</th>
				<th>Total Passed</th>
				<th>Total Failed</th>
			</tr>
			<tr>
				<td><xsl:value-of select="$name"/></td>
				<td><xsl:value-of select="count($totalPassed)"/></td>
				<td><xsl:value-of select="count($totalFailed)"/></td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>