<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:bt="urn:gugik:specyfikacje:gmlas:modelPodstawowy:1.0" xmlns:gmd="http://www.isotc211.org/2005/gmd" xmlns:gco="http://isotc211.org/2005/gco" xmlns:ot="urn:gugik:specyfikacje:gmlas:bazaDanychObiektowTopograficznych10k:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:gugik:specyfikacje:gmlas:bazaDanychObiektowTopograficznych10k:1.0 OT_BDOT10k_BDOO.xsd">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<gml:FeatureCollection>
			<xsl:apply-templates select="//ot:OT_PTWP_A"/>
			<xsl:apply-templates select="//ot:OT_Ciek"/>
		</gml:FeatureCollection>
	</xsl:template>

	<!-- OT_PTWP_A -->
	<xsl:template match="ot:OT_PTWP_A">
		<gml:featureMember>
			<ot:OT_PTWP_A>
				<xsl:attribute name="gml:id">OT_PTWP_A.<xsl:apply-templates select="ot:ID1"/></xsl:attribute>
				<xsl:apply-templates select="ot:idIIP_BT_I"/>
				<xsl:apply-templates select="ot:czyObiektB"/>
				<xsl:apply-templates select="ot:x_kod"/>
				<xsl:apply-templates select="ot:x_skrKarto"/>
				<xsl:apply-templates select="ot:x_skrKart1"/>
				<xsl:apply-templates select="ot:x_katDoklG"/>
				<xsl:apply-templates select="ot:x_doklGeom"/>
				<xsl:apply-templates select="ot:x_zrodloDa"/>
				<xsl:apply-templates select="ot:x_zrodloD1"/>
				<xsl:apply-templates select="ot:x_katIstni"/>
				<xsl:apply-templates select="ot:x_katIstn1"/>
				<xsl:apply-templates select="ot:x_rodzajRe"/>
				<xsl:apply-templates select="ot:x_uwagi"/>
				<xsl:apply-templates select="ot:x_uzytkown"/>
				<xsl:apply-templates select="ot:x_aktualno"/>
				<xsl:apply-templates select="ot:x_aktualn1"/>
				<xsl:apply-templates select="ot:x_cyklZyci"/>
				<xsl:apply-templates select="ot:x_dataUtwo"/>
				<xsl:apply-templates select="ot:x_informDo"/>
				<xsl:apply-templates select="ot:x_kodKarto"/>
				<xsl:apply-templates select="ot:x_kodKart2"/>
				<xsl:apply-templates select="ot:x_kodKart3"/>
				<xsl:apply-templates select="ot:x_kodKart4"/>
				<xsl:apply-templates select="ot:x_kodKart5"/>
				<xsl:apply-templates select="ot:x_kodKart6"/>
				<xsl:apply-templates select="ot:x_kodKart7"/>
				<xsl:apply-templates select="ot:x_kodKart9"/>
				<xsl:apply-templates select="ot:x_kodKa_13"/>
				<ot:geometria>
					<xsl:attribute name="gml:id">ID_020<xsl:value-of select="ot:ID1"/></xsl:attribute>
					<xsl:attribute name="srsName">EPSG:2180</xsl:attribute>
					<xsl:attribute name="srsDimension">2</xsl:attribute>
					<gml:exterior>
						<gml:LinearRing>
							<gml:posList>
								<xsl:value-of select="ot:Geometry/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList"/>
								<xsl:value-of select="ot:Geometry/gml:MultiSurface/gml:surfaceMember/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList"/>
							</gml:posList>
						</gml:LinearRing>
					</gml:exterior>
					<xsl:for-each select="ot:Geometry/gml:Polygon/gml:interior">
						<gml:interior>
							<gml:LinearRing>
								<gml:posList>
									<xsl:value-of select="gml:LinearRing/gml:posList"/>
								</gml:posList>
							</gml:LinearRing>
						</gml:interior>
					</xsl:for-each>
				</ot:geometria>
				<ot:PRNG>
					<xsl:if test="ot:PRNG != ''">
						<xsl:apply-templates select="ot:PRNG"/>
					</xsl:if>
				</ot:PRNG>
				<xsl:if test="ot:idMPHP != ''">
					<ot:idMPHP>
						<xsl:value-of select="ot:idMPHP"/>
					</ot:idMPHP>
				</xsl:if>
				<xsl:if test="ot:poziomWody != ''">
					<ot:poziomWody>
						<xsl:value-of select="ot:poziomWody"/>
					</ot:poziomWody>
				</xsl:if>
				<ot:rodzaj>
					<xsl:if test="ot:rodzaj ='wodyMorskie'">Pm</xsl:if>
					<xsl:if test="ot:rodzaj ='wodyPlynace'">Pp</xsl:if>
					<xsl:if test="ot:rodzaj ='wodyStojace'">Ps</xsl:if>
				</ot:rodzaj>
				<ot:katIstnienia>
					<xsl:attribute name="nilReason"><xsl:value-of select="ot:x_katIstn1"/></xsl:attribute>
					<xsl:attribute name="xsi:nil">true</xsl:attribute>
				</ot:katIstnienia>
				<xsl:if test="ot:zbiornikWo != ''">
					<ot:zbiornikWodny1>
						<xsl:attribute name="xlink:href"><xsl:value-of select="ot:zbiornikWo"/></xsl:attribute>
					</ot:zbiornikWodny1>
				</xsl:if>
				<xsl:if test="ot:ciek2 != ''">
					<ot:ciek2>
						<xsl:attribute name="xlink:href"><xsl:value-of select="ot:ciek2"/></xsl:attribute>
					</ot:ciek2>
				</xsl:if>
			</ot:OT_PTWP_A>
		</gml:featureMember>
	</xsl:template>

	<!-- OT_Ciek -->
	<xsl:template match="ot:OT_Ciek">
		<gml:featureMember>
			<ot:OT_Ciek>
				<xsl:attribute name="gml:id">OT_Ciek.<xsl:apply-templates select="ot:ID1"/></xsl:attribute>
				<ot:idPRNG>
					<xsl:value-of select="ot:idPRNG"/>
				</ot:idPRNG>
				<ot:nazwa>
					<xsl:value-of select="ot:nazwa"/>
				</ot:nazwa>
				<ot:dlugosc>
					<xsl:attribute name="uom">m</xsl:attribute>
					<xsl:value-of select="ot:dlugosc"/>
				</ot:dlugosc>
				<ot:PRNG>
					<bt:BT_ReferencjaDoObiektu>
						<bt:idIIP>
							<bt:BT_Identyfikator>
								<bt:lokalnyId>
									<xsl:value-of select="ot:PRNG"/>
								</bt:lokalnyId>
								<bt:przestrzenNazw>
									<xsl:value-of select="ot:PRNG_przes"/>
								</bt:przestrzenNazw>
							</bt:BT_Identyfikator>
						</bt:idIIP>
					</bt:BT_ReferencjaDoObiektu>
				</ot:PRNG>
			</ot:OT_Ciek>
		</gml:featureMember>
	</xsl:template>

	<xsl:template match="ot:idIIP_BT_I">
		<ot:idIIP>
			<bt:BT_Identyfikator>
				<bt:lokalnyId>
					<xsl:value-of select="."/>
				</bt:lokalnyId>
				<bt:przestrzenNazw>
					<xsl:value-of select="../ot:idIIP_BT_1"/>
				</bt:przestrzenNazw>
				<bt:wersjaId>
					<xsl:value-of select="../ot:idIIP_BT_2"/>
				</bt:wersjaId>
			</bt:BT_Identyfikator>
		</ot:idIIP>
	</xsl:template>
	<xsl:template match="ot:czyObiektB">
		<ot:czyObiektBDOO>
			<xsl:if test=". = 0">false</xsl:if>
			<xsl:if test=". = 1">true</xsl:if>
		</ot:czyObiektBDOO>
	</xsl:template>
	<xsl:template match="ot:x_kod">
		<ot:x_kod>
			<xsl:value-of select="."/>
		</ot:x_kod>
	</xsl:template>
	<xsl:template match="ot:x_skrKarto">
		<ot:x_skrKarto>
			<xsl:if test=". = 'ambasada'">amb.</xsl:if>
			<xsl:if test=". = 'bank'">B</xsl:if>
			<xsl:if test=". = 'brod'">b.</xsl:if>
			<xsl:if test=". = 'bazaTransportowa'">b. tran.</xsl:if>
			<xsl:if test=". = 'basenKapielowy'">bas. kąp.</xsl:if>
			<xsl:if test=". = 'budowa'">bud.</xsl:if>
			<xsl:if test=". = 'biurowiec'">biur.</xsl:if>
			<xsl:if test=". = 'ogrodBotaniczny'">bot..</xsl:if>
			<xsl:if test=". = 'centrumHandlowe'">c. han.</xsl:if>
			<xsl:if test=". = 'plantacjaChmielu'">chm.</xsl:if>
			<xsl:if test=". = 'domDziecka'">d. dz.</xsl:if>
			<xsl:if test=". = 'domHandlowy'">d. h.</xsl:if>
			<xsl:if test=". = 'domKultury'">d. k.</xsl:if>
			<xsl:if test=". = 'domOpieki'">d. op.</xsl:if>
			<xsl:if test=". = 'domParafialny'">d. paraf.</xsl:if>
			<xsl:if test=". = 'domStudenta'">d. s.</xsl:if>
			<xsl:if test=". = 'domWychowawczy'">d. wych.</xsl:if>
			<xsl:if test=". = 'domWypoczynkowy'">d. wyp.</xsl:if>
			<xsl:if test=". = 'dworzecAutobusowy'">dw. aut.</xsl:if>
			<xsl:if test=". = 'elektrownia'">el.</xsl:if>
			<xsl:if test=". = 'elektrocieplownia'">elc.</xsl:if>
			<xsl:if test=". = 'elewator'">elw.</xsl:if>
			<xsl:if test=". = 'twierdzaLubForteca'">for.</xsl:if>
			<xsl:if test=". = 'garaz'">gar.</xsl:if>
			<xsl:if test=". = 'gazowniaZbiornikGazu'">gaz.</xsl:if>
			<xsl:if test=". = 'hotel'">H</xsl:if>
			<xsl:if test=". = 'halaTargowa'">h. targ.</xsl:if>
			<xsl:if test=". = 'halaSportowa'">h. sport.</xsl:if>
			<xsl:if test=". = 'halda'">hał.</xsl:if>
			<xsl:if test=". = 'budynekFermHodowlanych'">hod.</xsl:if>
			<xsl:if test=". = 'internat'">int.</xsl:if>
			<xsl:if test=". = 'kino'">K</xsl:if>
			<xsl:if test=". = 'kemping'">kemp.</xsl:if>
			<xsl:if test=". = 'klasztor'">kl.</xsl:if>
			<xsl:if test=". = 'kamieniolom'">kłm.</xsl:if>
			<xsl:if test=". = 'kopalnia'">kop.</xsl:if>
			<xsl:if test=". = 'domkiLetniskowe'">letn.</xsl:if>
			<xsl:if test=". = 'ladowisko'">ląd.</xsl:if>
			<xsl:if test=". = 'lotnisko'">lotn.</xsl:if>
			<xsl:if test=". = 'muzeum'">M</xsl:if>
			<xsl:if test=". = 'magazyny'">mag.</xsl:if>
			<xsl:if test=". = 'przemyslMetalurgiczny'">metalurg.</xsl:if>
			<xsl:if test=". = 'szybNaftowy'">nft.</xsl:if>
			<xsl:if test=". = 'nieczynny'">niecz.</xsl:if>
			<xsl:if test=". = 'obserwatoriumAstronomiczne'">obs. astr.</xsl:if>
			<xsl:if test=". = 'oczyszczalanieSciekow'">oczyszcz.</xsl:if>
			<xsl:if test=". = 'osadnik'">osad.</xsl:if>
			<xsl:if test=". = 'terenOsrodkaWyp'">ośr. wyp.</xsl:if>
			<xsl:if test=". = 'policja'">P</xsl:if>
			<xsl:if test=". = 'parking'">p.</xsl:if>
			<xsl:if test=". = 'przystanekKolejowy'">p. kol.</xsl:if>
			<xsl:if test=". = 'kopalniePiaskuPiaskownia'">piask.</xsl:if>
			<xsl:if test=". = 'placSportowy'">pl. sport.</xsl:if>
			<xsl:if test=". = 'plebania'">pleb.</xsl:if>
			<xsl:if test=". = 'placowkaOperatoraPocztowego'">pocz.</xsl:if>
			<xsl:if test=". = 'pogotowieRatunkowe'">pog. rat.</xsl:if>
			<xsl:if test=". = 'przepompownia'">pomp.</xsl:if>
			<xsl:if test=". = 'portWodnyPrzystan'">port</xsl:if>
			<xsl:if test=". = 'dworzecLotniczy'">port lot.</xsl:if>
			<xsl:if test=". = 'prom'">pr.</xsl:if>
			<xsl:if test=". = 'przedszkole'">przedszk.</xsl:if>
			<xsl:if test=". = 'przewozLodziami'">pw.</xsl:if>
			<xsl:if test=". = 'ruinyZabytkowe'">r. zab.</xsl:if>
			<xsl:if test=". = 'rafineria'">rafin.</xsl:if>
			<xsl:if test=". = 'remizaStrazacka'">rem.</xsl:if>
			<xsl:if test=". = 'restauracja'">rest.</xsl:if>
			<xsl:if test=". = 'rampa'">rmp.</xsl:if>
			<xsl:if test=". = 'sad'">S</xsl:if>
			<xsl:if test=". = 'sanatorium'">san.</xsl:if>
			<xsl:if test=". = 'schronisko'">schr.</xsl:if>
			<xsl:if test=". = 'silos'">sil.</xsl:if>
			<xsl:if test=". = 'stadnina'">stadn.</xsl:if>
			<xsl:if test=". = 'starostwoPowiatowe'">SP</xsl:if>
			<xsl:if test=". = 'stacjaKolejowa'">st.</xsl:if>
			<xsl:if test=". = 'szkola'">szk.</xsl:if>
			<xsl:if test=". = 'szpital'">szpit.</xsl:if>
			<xsl:if test=". = 'teatr'">T</xsl:if>
			<xsl:if test=". = 'targowiskoBazar'">targ.</xsl:if>
			<xsl:if test=". = 'urzadGminy'">UG</xsl:if>
			<xsl:if test=". = 'urzadMiasta'">UM</xsl:if>
			<xsl:if test=". = 'urzadMiastaIGminy'">UMG</xsl:if>
			<xsl:if test=". = 'urzadMarszalkowski'">UMr.</xsl:if>
			<xsl:if test=". = 'zakladUtylizacyjny'">utyliz.</xsl:if>
			<xsl:if test=". = 'urzadWojewodzki'">UW</xsl:if>
			<xsl:if test=". = 'wiezaCisnien'">w. ciśn.</xsl:if>
			<xsl:if test=". = 'wierzaObserwacyjna'">w. obs.</xsl:if>
			<xsl:if test=". = 'zakladWodociagowy'">wdc.</xsl:if>
			<xsl:if test=". = 'plantacjaWikliny'">wikl.</xsl:if>
			<xsl:if test=". = 'zajezdaniaAutobusowaLubTramwajowa'">zaj.</xsl:if>
			<xsl:if test=". = 'zakladKarny'">z. kar.</xsl:if>
			<xsl:if test=". = 'osrodekZdrowia'">zdr.</xsl:if>
			<xsl:if test=". = 'zrodloMineralne'">źr. min.</xsl:if>
			<xsl:if test=". = 'ogrodZoologiczny'">ZOO</xsl:if>
			<xsl:if test=". = 'zlobek'">żłb.</xsl:if>
			<xsl:if test=". = 'miejsceWydobyciaZwiru'">żw.</xsl:if>
			<xsl:if test=". = 'domWeselny'">d. wes.</xsl:if>
			<xsl:if test=". = 'kapielisko'">kąp.</xsl:if>
			<xsl:if test=". = 'kortTenisowy'">kort</xsl:if>
			<xsl:if test=". = 'przystanPromowa'">p. prom.</xsl:if>
			<xsl:if test=". = 'poleGolfowe'">p. golf.</xsl:if>
			<xsl:if test=". = 'radiostacja'">rdst.</xsl:if>
			<xsl:if test=". = 'MiejsceWydobyciaGliny'">gl.</xsl:if>
			<xsl:if test=". = 'nadlesnictwo'">nadl.</xsl:if>
		</ot:x_skrKarto>
	</xsl:template>
	<xsl:template match="ot:x_skrKart1">
		<ot:x_skrKarto>
			<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
			<xsl:attribute name="xsi:nil">true</xsl:attribute>
		</ot:x_skrKarto>
	</xsl:template>
	<xsl:template match="ot:x_katDoklG">
		<ot:x_katDoklGeom>
			<xsl:if test=". = 'dokladny'">Dok</xsl:if>
			<xsl:if test=". = 'przyblizony'">Prz</xsl:if>
			<xsl:if test=". = 'niepewny'">Npw</xsl:if>
		</ot:x_katDoklGeom>
	</xsl:template>
	<xsl:template match="ot:x_doklGeom">
		<ot:x_doklGeom>
			<xsl:attribute name="uom">m</xsl:attribute>
			<xsl:value-of select="."/>
		</ot:x_doklGeom>
	</xsl:template>
	<xsl:template match="ot:x_zrodloDa">
		<ot:x_zrodloDanychG>
			<xsl:if test=". = 'bazaDanychGeodezyjnychGrawimetrycznych'">GEOS</xsl:if>
			<xsl:if test=". = 'ewidencjaGruntowIBudynkow'">EGiB</xsl:if>
			<xsl:if test=". = 'geodezyjnaEwidencjaSieciUzbrojeniaTerenu'">GESUT</xsl:if>
			<xsl:if test=". = 'bazaDanychPanstwowegoRejestruGranic'">PRG</xsl:if>
			<xsl:if test=". = 'panstwowyRejestrNazwGeograficznych'">PRNG</xsl:if>
			<xsl:if test=". = 'ewidencjaMiejscowosciUlicAdresow'">EMUiA</xsl:if>
			<xsl:if test=". = 'rejestrCenWartosciNieruchomosci'">RCiWN</xsl:if>
			<xsl:if test=". = 'bazaDanychOgolnogeograficznych'">BDO</xsl:if>
			<xsl:if test=". = 'ortofotomapa'">Ort</xsl:if>
			<xsl:if test=". = 'mapaZasadnicza'">Mz</xsl:if>
			<xsl:if test=". = 'mapaTopograficzna10k'">Mtp10</xsl:if>
			<xsl:if test=". = 'mapaTopograficzna50k'">Mtp50</xsl:if>
			<xsl:if test=". = 'vmapLevel2PierwszejEdycji'">VMAPL2_v1</xsl:if>
			<xsl:if test=". = 'vmapLevel2DrugiejEdycji'">VMAPL2_v2</xsl:if>
			<xsl:if test=". = 'bazaDanchTopograficznych'">TBD</xsl:if>
			<xsl:if test=". = 'bazaDanychCLC'">CORINE</xsl:if>
			<xsl:if test=". = 'centralnyRejestrFormOchronyPrzyrody'">CRFOP</xsl:if>
			<xsl:if test=". = 'bankDanychDrogowych'">BDD</xsl:if>
			<xsl:if test=". = 'bazaDanychWgInstrK1'">BDOT500</xsl:if>
			<xsl:if test=". = 'krajowySystemObszarowChronionych'">KSOCH</xsl:if>
			<xsl:if test=". = 'lesnaMapaNumeryczna'">LMN</xsl:if>
			<xsl:if test=". = 'mapaPodzialuHydrograficznegoPolski'">MPHP</xsl:if>
			<xsl:if test=". = 'bazaDanychPKP'">PKP</xsl:if>
			<xsl:if test=". = 'rejestrZabytkow'">RZAB</xsl:if>
			<xsl:if test=". = 'krajowyRejestrUrzedowyPodzialuTerytorialnegoKraju'">TERYT</xsl:if>
			<xsl:if test=". = 'pomiarStereoskopowy'">Str</xsl:if>
			<xsl:if test=". = 'pomiarTerenowy'">Trn</xsl:if>
		</ot:x_zrodloDanychG>
	</xsl:template>
	<xsl:template match="ot:x_zrodloD1">
		<ot:x_zrodloDanychA>
			<xsl:if test=". = 'bazaDanychGeodezyjnychGrawimetrycznych'">GEOS</xsl:if>
			<xsl:if test=". = 'ewidencjaGruntowIBudynkow'">EGiB</xsl:if>
			<xsl:if test=". = 'geodezyjnaEwidencjaSieciUzbrojeniaTerenu'">GESUT</xsl:if>
			<xsl:if test=". = 'bazaDanychPanstwowegoRejestruGranic'">PRG</xsl:if>
			<xsl:if test=". = 'panstwowyRejestrNazwGeograficznych'">PRNG</xsl:if>
			<xsl:if test=". = 'ewidencjaMiejscowosciUlicAdresow'">EMUiA</xsl:if>
			<xsl:if test=". = 'rejestrCenWartosciNieruchomosci'">RCiWN</xsl:if>
			<xsl:if test=". = 'bazaDanychOgolnogeograficznych'">BDO</xsl:if>
			<xsl:if test=". = 'ortofotomapa'">Ort</xsl:if>
			<xsl:if test=". = 'mapaZasadnicza'">Mz</xsl:if>
			<xsl:if test=". = 'mapaTopograficzna10k'">Mtp10</xsl:if>
			<xsl:if test=". = 'mapaTopograficzna50k'">Mtp50</xsl:if>
			<xsl:if test=". = 'vmapLevel2PierwszejEdycji'">VMAPL2_v1</xsl:if>
			<xsl:if test=". = 'vmapLevel2DrugiejEdycji'">VMAPL2_v2</xsl:if>
			<xsl:if test=". = 'bazaDanchTopograficznych'">TBD</xsl:if>
			<xsl:if test=". = 'bazaDanychCLC'">CORINE</xsl:if>
			<xsl:if test=". = 'centralnyRejestrFormOchronyPrzyrody'">CRFOP</xsl:if>
			<xsl:if test=". = 'bankDanychDrogowych'">BDD</xsl:if>
			<xsl:if test=". = 'bazaDanychWgInstrK1'">BDOT500</xsl:if>
			<xsl:if test=". = 'krajowySystemObszarowChronionych'">KSOCH</xsl:if>
			<xsl:if test=". = 'lesnaMapaNumeryczna'">LMN</xsl:if>
			<xsl:if test=". = 'mapaPodzialuHydrograficznegoPolski'">MPHP</xsl:if>
			<xsl:if test=". = 'bazaDanychPKP'">PKP</xsl:if>
			<xsl:if test=". = 'rejestrZabytkow'">RZAB</xsl:if>
			<xsl:if test=". = 'krajowyRejestrUrzedowyPodzialuTerytorialnegoKraju'">TERYT</xsl:if>
			<xsl:if test=". = 'pomiarStereoskopowy'">Str</xsl:if>
			<xsl:if test=". = 'pomiarTerenowy'">Trn</xsl:if>
		</ot:x_zrodloDanychA>
	</xsl:template>
	<xsl:template match="ot:x_katIstni">
		<ot:x_katIstnienia>
			<xsl:if test=". = 'eksploatowany'">Eks</xsl:if>
			<xsl:if test=". = 'wBudowie'">Bud</xsl:if>
			<xsl:if test=". = 'zniszczony'">Zns</xsl:if>
			<xsl:if test=". = 'tymczasowy'">Tmc</xsl:if>
			<xsl:if test=". = 'nieczynny'">Ncn</xsl:if>
		</ot:x_katIstnienia>
	</xsl:template>
	<xsl:template match="ot:x_katIstn1">
		<ot:x_katIstnienia>
			<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
			<xsl:attribute name="xsi:nil">true</xsl:attribute>
		</ot:x_katIstnienia>
	</xsl:template>
	<xsl:template match="ot:x_rodzajRe">
		<ot:x_rodzajReprGeom>
			<xsl:if test=". = 'srodekGeometryczny'">SG</xsl:if>
			<xsl:if test=". = 'miejsceCharakterystyczne'">MC</xsl:if>
			<xsl:if test=". = 'punktUmowny'">PU</xsl:if>
			<xsl:if test=". = 'osGeometryczna'">OG</xsl:if>
			<xsl:if test=". = 'osInterpolowana'">OI</xsl:if>
			<xsl:if test=". = 'liniaUmowna'">LU</xsl:if>
			<xsl:if test=". = 'sztucznyLacznik'">SL</xsl:if>
			<xsl:if test=". = 'krawedz'">KR</xsl:if>
			<xsl:if test=". = 'zarysPodstawy'">ZP</xsl:if>
			<xsl:if test=". = 'zasiegUmowny'">ZU</xsl:if>
			<xsl:if test=". = 'maksymalnyZasieg'">MA</xsl:if>
			<xsl:if test=". = 'minimalnyZasieg'">MI</xsl:if>
			<xsl:if test=". = 'sredniZasieg'">SZ</xsl:if>
		</ot:x_rodzajReprGeom>
	</xsl:template>
	<xsl:template match="ot:x_uwagi">
		<ot:x_uwagi>
			<xsl:value-of select="."/>
		</ot:x_uwagi>
	</xsl:template>
	<xsl:template match="ot:x_uzytkown">
		<ot:x_uzytkownik>
			<xsl:attribute name="xlink:href"><xsl:value-of select="."></xsl:value-of></xsl:attribute>
		</ot:x_uzytkownik>
	</xsl:template>
	<xsl:template match="ot:x_aktualno">
		<ot:x_aktualnoscG>
			<xsl:value-of select="substring-before(., 'T')"/>
		</ot:x_aktualnoscG>
	</xsl:template>
	<xsl:template match="ot:x_aktualn1">
		<ot:x_aktualnoscA>
			<xsl:value-of select="substring-before(., 'T')"/>
		</ot:x_aktualnoscA>
	</xsl:template>
	<xsl:template match="ot:x_cyklZyci">
		<ot:x_cyklZycia>
			<bt:BT_CyklZyciaInfo>
				<bt:poczatekWersjiObiektu>
					<xsl:value-of select="."/>
				</bt:poczatekWersjiObiektu>
				<xsl:if test="../ot:x_cyklZyc1 != '' ">
					<bt:koniecWersjiObiektu>
						<xsl:value-of select="../ot:cyklZyc1"/>
					</bt:koniecWersjiObiektu>
				</xsl:if>
			</bt:BT_CyklZyciaInfo>
		</ot:x_cyklZycia>
	</xsl:template>
	<xsl:template match="ot:x_dataUtwo">
		<ot:x_dataUtworzenia>
			<xsl:value-of select="substring-before(., 'T')"/>
		</ot:x_dataUtworzenia>
	</xsl:template>
	<xsl:template match="ot:x_informDo">
		<ot:x_informDodatkowa>
			<xsl:value-of select="."/>
		</ot:x_informDodatkowa>
	</xsl:template>
	<xsl:template match="ot:x_kodKarto">
		<ot:x_kodKarto10k>
			<xsl:value-of select="."/>
		</ot:x_kodKarto10k>
	</xsl:template>
	<xsl:template match="ot:x_kodKart2">
		<ot:x_kodKarto25k>
			<xsl:value-of select="."/>
		</ot:x_kodKarto25k>
	</xsl:template>
	<xsl:template match="ot:x_kodKart3">
		<ot:x_kodKarto25k>
			<xsl:if test=". = 'inapplicable'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'missing'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'template'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'unknown'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'withheld'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
		</ot:x_kodKarto25k>
	</xsl:template>
	<xsl:template match="ot:x_kodKart4">
		<ot:x_kodKarto50k>
			<xsl:value-of select="."/>
		</ot:x_kodKarto50k>
	</xsl:template>
	<xsl:template match="ot:x_kodKart5">
		<ot:x_kodKarto50k>
			<xsl:if test=". = 'inapplicable'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'missing'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'template'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'unknown'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'withheld'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
		</ot:x_kodKarto50k>
	</xsl:template>
	<xsl:template match="ot:x_kodKart6">
		<ot:x_kodKarto100k>
			<xsl:value-of select="."/>
		</ot:x_kodKarto100k>
	</xsl:template>
	<xsl:template match="ot:x_kodKart7">
		<ot:x_kodKarto100k>
			<xsl:if test=". = 'inapplicable'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'missing'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'template'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'unknown'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'withheld'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
		</ot:x_kodKarto100k>
	</xsl:template>
	<xsl:template match="ot:x_kodKart9">
		<ot:x_kodKarto250k>
			<xsl:if test=". = 'inapplicable'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'missing'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'template'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'unknown'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'withheld'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
		</ot:x_kodKarto250k>
	</xsl:template>
	<xsl:template match="ot:x_kodKa_13">
		<ot:x_kodKarto500k>
			<xsl:if test=". = 'inapplicable'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'missing'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'template'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'unknown'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'withheld'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
		</ot:x_kodKarto500k>
		<ot:x_kodKarto1000k>
			<xsl:if test=". = 'inapplicable'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'missing'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'template'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'unknown'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
			<xsl:if test=". = 'withheld'">
				<xsl:attribute name="nilReason"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="xsi:nil">true</xsl:attribute>
			</xsl:if>
		</ot:x_kodKarto1000k>
	</xsl:template>
	<xsl:template match="ot:PRNG">
		<bt:BT_ReferencjaDoObiektu>
			<bt:idIIP>
				<bt:BT_Identyfikator>
					<bt:lokalnyId>
						<xsl:value-of select="."/>
					</bt:lokalnyId>
					<bt:przestrzenNazw>
						<xsl:value-of select="../ot:PRNG_przes"/>
					</bt:przestrzenNazw>
				</bt:BT_Identyfikator>
			</bt:idIIP>
		</bt:BT_ReferencjaDoObiektu>
	</xsl:template>

</xsl:stylesheet>
