<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:fn="http://www.w3.org/2004/10/xpath-functions" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
xmlns:xlink="http://www.w3.org/1999/xlink" 
xmlns:gml="http://www.opengis.net/gml/3.2" 
xmlns:col="urn:org.geotools.xml.example.collection" 
xmlns:ex="urn:org.geotools.xml.example"
xmlns:nz-core="http://inspire.ec.europa.eu/schemas/nz-core/4.0" 
xmlns:base="http://inspire.ec.europa.eu/schemas/base/3.3" 
xmlns:base2="http://inspire.ec.europa.eu/schemas/base2/2.0">	
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
		
	<!-- FEATURE COLLECTION -->
	<!-- change col:FeatureCollection to gml:FeatureCollection-->
	<xsl:template match="col:FeatureCollection">
		<xsl:element name="gml:FeatureCollection">
			<!-- copy of prefixes and namespaces -->
			<xsl:copy-of select="document('')/xsl:stylesheet/namespace::*[local-name()='xsi' or local-name()='xlink' or local-name()='gml' or local-name()='nz-core' or local-name()='base' or local-name()='base2']"/>
				
			<!-- change xsi:schemaLocation value -->
			<xsl:attribute name="xsi:schemaLocation">
				<xsl:text>http://inspire.ec.europa.eu/schemas/nz-core/4.0 NaturalRiskZonesCore.xsd</xsl:text>
			</xsl:attribute>
				
			<xsl:attribute name="gml:id">
				<xsl:text>idFeatureCollection_</xsl:text>
				<xsl:number count="*" format="1" level="any"/>
			</xsl:attribute>
					
				<!-- TEMPLATE FOR OTHER ELEMENTS -->	
				<xsl:apply-templates select="node()"/>
				
		</xsl:element>
	</xsl:template>
	
	<xsl:template match="node()">
		<xsl:element name="gml:featureMember">
			<xsl:element name="nz-core:ObservedEvent">
				<xsl:attribute name="gml:id">
					<xsl:value-of select="descendant::*[local-name()='fireid']"/>
				</xsl:attribute>
				<xsl:element name="nz-core:beginLifeSpanVersion">
					<xsl:value-of select="descendant::*[local-name()='dateal']"/>
				</xsl:element>
				<xsl:element name="nz-core:inspireId">
					<xsl:element name="base:Identifier">
						<xsl:element name="base:localId">
							<xsl:value-of select="descendant::*[local-name()='codecom']"/>
						</xsl:element>
						<xsl:element name="base:namespace">
							<xsl:text>psp2018</xsl:text>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:element name="nz-core:nameOfEvent">
					<xsl:text>fire</xsl:text>
				</xsl:element>
				<xsl:element name="nz-core:typeOfHazard">
					<xsl:element name="nz-core:NaturalHazardClassification">
						<xsl:element name="nz-core:hazardCategory">
							<xsl:attribute name="xlink:href">
								<xsl:text>http://inspire.ec.europa.eu/codelist/RiskOrHazardCategoryValue/social</xsl:text>
							</xsl:attribute>
						</xsl:element>
						<xsl:element name="nz-core:specificHazardType">
							<xsl:attribute name="nilReason">
								<xsl:text>unknown</xsl:text>
							</xsl:attribute>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:element name="nz-core:validFrom">
					<xsl:value-of select="descendant::*[local-name()='datein']"/>
				</xsl:element>
				<xsl:element name="nz-core:validTo">
					<xsl:value-of select="descendant::*[local-name()='dateex']"/>
				</xsl:element>
				<xsl:element name="nz-core:geometry">
					<xsl:element name="gml:Point">
						<xsl:attribute name="srsName">
							<xsl:text>EPSG:4326</xsl:text>
						</xsl:attribute>
						<xsl:element name="gml:coordinates">
							<xsl:attribute name="decimal">
								<xsl:text>.</xsl:text>
							</xsl:attribute>
							<xsl:attribute name="cs">
								<xsl:text>,</xsl:text>
							</xsl:attribute>
							<xsl:attribute name="ts">
								<xsl:text> </xsl:text>
							</xsl:attribute>
							<xsl:value-of select="descendant::*[local-name()='pnt']"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:element name="nz-core:magnitudeOrIntensity">
					<xsl:element name="nz-core:LevelOrIntensity">
						<xsl:element name="nz-core:qualitativeValue">
							<xsl:value-of select="descendant::*[local-name()='baonw']"/>
						</xsl:element>
						<xsl:element name="nz-core:quantitativeValue">
							<xsl:attribute name="uom">
								<xsl:text>m2</xsl:text>
							</xsl:attribute>
							<xsl:value-of select="descendant::*[local-name()='baagr']"/>
						</xsl:element>
						<xsl:element name="nz-core:assessmentMethod">
							<xsl:attribute name="nilReason">
								<xsl:text>unknown</xsl:text>
							</xsl:attribute>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>				
		</xsl:element>						
	</xsl:template>
		
</xsl:stylesheet>
