# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AnalizaZasieguDockWidget
                                 A QGIS plugin
 Analiza zasięgu dla wskazanego punktu
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-08-16
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Autor
        email                : adres@example.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal, Qt
# Import klas QGIS API
from qgis.core import (QgsMapLayerProxyModel, QgsFieldProxyModel, QgsWkbTypes,
    QgsRasterLayer, QgsRaster)
from qgis.gui import QgsRubberBand
from qgis.utils import iface
from qgis import processing

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'analiza_zasiegu_dockwidget_base.ui'))


class AnalizaZasieguDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(AnalizaZasieguDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.NMT.setFilters( QgsMapLayerProxyModel.RasterLayer )
        self.Punkty.setFilters( QgsMapLayerProxyModel.PointLayer )
 
        self.Wysokosc.setFilters( QgsFieldProxyModel.Numeric )
        self.Wysokosc.setField( 'Wysokosc' )
 
        self.PoleZasiegu.setFilters( QgsFieldProxyModel.String )
        self.PoleZasiegu.setField( 'W_zasiegu' )

        # Ustawienie tekstu jeśli nie wybrano punktu
        self.Punkt_X.setSpecialValueText('Brak')
        self.Punkt_Y.setSpecialValueText('Brak')

        # Kliknięcie przycisku Usuń punkt
        self.UsunPunkt.clicked.connect( self.usunieciePunktu )

        # Znacznik wskazanego punktu
        self.znacznik = QgsRubberBand( iface.mapCanvas(),
                                        QgsWkbTypes.PointGeometry )
        self.znacznik.setColor( Qt.red )
        self.znacznik.setIcon( QgsRubberBand.ICON_CROSS )
        self.znacznik.setIconSize( 10 )

        # Rozpoczęcie analizy
        self.Oblicz.clicked.connect( self.analizaZasiegu )

        # Plik stylu rastar z całkowitym zasięgiem
        self.plik_stylu = os.path.join( 
                    os.path.dirname(__file__), 'zasieg.qml' )

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def wybraniePunktu(self, punkt, przycisk):
        """ Funkcja wywołana po kliknięciu
        na mapie przez użytkownika """
        # Usunięcie informacje o wcześniej wybranym punkcie
        self.usunieciePunktu()
        # Dodanie znacznika mapy
        self.znacznik.addPoint( punkt )

        # Ustawienie współrzędnych w polach
        self.Punkt_X.setValue( punkt.x() )
        self.Punkt_Y.setValue( punkt.y() )
    
    def usunieciePunktu(self):
        """ Usunięcie danych wybranego punktu """
        # Czyszczenie współrzędnych
        self.Punkt_X.setValue( 0 )
        self.Punkt_Y.setValue( 0 )

        # Wyczyszczenie znacznika mapy
        self.znacznik.reset(QgsWkbTypes.PointGeometry)

    def analizaZasiegu(self):
        """ Wykonanie analizy zasięgu """
        punkt = self.znacznik.getPoint(0)
        if punkt is None:
            # Brak wybranego punktu analizy
            return
        wektor = self.Punkty.currentLayer()

        # Pobranie informacji o polu do zapisu informacji
        pole_zapisu = self.PoleZasiegu.currentField()
        indeks_pola_zapisu = wektor.fields().indexFromName( pole_zapisu )

        # Lista ze stworzonymi rastrami
        lista_zasiegow = []

        # Iteracja po obiektach warstwy punktowej
        for obiekt in wektor.getFeatures():
            plik_zasiegu = self.analizujPunkt( obiekt )
            lista_zasiegow.append( plik_zasiegu )

            # Obiekt reprezentujący utworzony raster
            raster_zasiegu = QgsRasterLayer( plik_zasiegu )
            # Identyfikacja wartości rastra w punkcie
            wynik = raster_zasiegu.dataProvider().identify(
                        punkt,
                        QgsRaster.IdentifyFormatValue ).results()
            # Czy kanał 1 rastra zawiera informacje
            if wynik[1]:
                w_zasiegu = 'Tak'
            else:
                w_zasiegu = 'Nie'
            wektor.dataProvider().changeAttributeValues(
                        { obiekt.id(): {indeks_pola_zapisu: w_zasiegu}})

        # Odświeżenie warstwy punktowej
        wektor.reload()

        # Dodanie warstwy z całkowitym zasięgiem
        if self.DodajRaster.isChecked():
            self.oblicz_zasieg( lista_zasiegow )
    
    def analizujPunkt(self, obiekt):
        result = processing.run('gdal:viewshed', {
            'INPUT': self.NMT.currentLayer(),
            'BAND': 1,
            'OBSERVER': obiekt.geometry(),
            'OBSERVER_HEIGHT': obiekt[self.Wysokosc.currentField()],
            'TARGET_HEIGHT': 1,
            'MAX_DISTANCE': self.Zasieg.value(),
            'OUTPUT': 'TEMPORARY_OUTPUT'
        })
        return result['OUTPUT']
    
    def oblicz_zasieg(self, lista_zasiegow):
        """ Obliczenie całkowitego zasięgu """
        result = processing.run('native:rasterlogicalor', {
            'INPUT': lista_zasiegow,
            'REF_LAYER': self.NMT.currentLayer(),
            'NODATA_AS_FALSE': True,
            'OUTPUT':'TEMPORARY_OUTPUT'
        })
        # Dodanie rastra do mapy
        raster = iface.addRasterLayer( result['OUTPUT'] )
        # Ustawienie stylu z pliku QML
        raster.loadNamedStyle( self.plik_stylu )
