CREATE TABLE bookings (
    bookid integer NOT NULL,
    facid integer NOT NULL,
    memid integer NOT NULL,
    starttime timestamp without time zone NOT NULL,
    slots integer NOT NULL
);

CREATE TABLE facilities (
    facid integer NOT NULL,
    name character varying(100) NOT NULL,
    membercost numeric NOT NULL,
    guestcost numeric NOT NULL,
    initialoutlay numeric NOT NULL,
    monthlymaintenance numeric NOT NULL
);

CREATE TABLE members (
    memid integer NOT NULL,
    surname character varying(200) NOT NULL,
    firstname character varying(200) NOT NULL,
    address character varying(300) NOT NULL,
    zipcode integer NOT NULL,
    telephone character varying(20) NOT NULL,
    recommendedby integer,
    joindate timestamp without time zone NOT NULL
);

INSERT INTO bookings (bookid, facid, memid, starttime, slots) VALUES
(0, 3, 1, '2012-07-03 11:00:00', 2),
(1, 4, 1, '2012-07-03 08:00:00', 2),
(2, 6, 0, '2012-07-03 18:00:00', 2),
(3, 7, 1, '2012-07-03 19:00:00', 2),
(4, 8, 1, '2012-07-03 10:00:00', 1),
(5, 8, 1, '2012-07-03 15:00:00', 1),
(6, 0, 2, '2012-07-04 09:00:00', 3),
(7, 0, 2, '2012-07-04 15:00:00', 3),
(8, 4, 3, '2012-07-04 13:30:00', 2),
(9, 4, 0, '2012-07-04 15:00:00', 2),
(10, 4, 0, '2012-07-04 17:30:00', 2),
(11, 6, 0, '2012-07-04 12:30:00', 2),
(12, 6, 0, '2012-07-04 14:00:00', 2),
(13, 6, 1, '2012-07-04 15:30:00', 2),
(14, 7, 2, '2012-07-04 14:00:00', 2),
(15, 8, 2, '2012-07-04 12:00:00', 1),
(16, 8, 3, '2012-07-04 18:00:00', 1),
(17, 1, 0, '2012-07-05 17:30:00', 3),
(18, 2, 1, '2012-07-05 09:30:00', 3),
(19, 3, 3, '2012-07-05 09:00:00', 2),
(20, 3, 1, '2012-07-05 19:00:00', 2),
(21, 4, 3, '2012-07-05 18:30:00', 2),
(22, 6, 0, '2012-07-05 13:00:00', 2),
(23, 6, 1, '2012-07-05 14:30:00', 2),
(24, 7, 2, '2012-07-05 18:30:00', 2),
(25, 8, 3, '2012-07-05 12:30:00', 1),
(26, 0, 0, '2012-07-06 08:00:00', 3),
(27, 0, 0, '2012-07-06 14:00:00', 3),
(28, 0, 2, '2012-07-06 15:30:00', 3),
(29, 2, 1, '2012-07-06 17:00:00', 3),
(30, 3, 1, '2012-07-06 11:00:00', 2),
(31, 4, 3, '2012-07-06 12:00:00', 2),
(32, 6, 1, '2012-07-06 14:00:00', 2),
(33, 7, 2, '2012-07-06 08:30:00', 2),
(34, 7, 2, '2012-07-06 13:30:00', 2),
(35, 8, 3, '2012-07-06 15:30:00', 1),
(36, 0, 2, '2012-07-07 08:30:00', 3),
(37, 0, 0, '2012-07-07 12:30:00', 3),
(38, 0, 2, '2012-07-07 14:30:00', 3),
(39, 1, 3, '2012-07-07 08:30:00', 3),
(40, 2, 1, '2012-07-07 09:00:00', 3),
(41, 2, 1, '2012-07-07 11:30:00', 3),
(42, 2, 1, '2012-07-07 16:00:00', 3),
(43, 3, 2, '2012-07-07 12:30:00', 2),
(44, 4, 3, '2012-07-07 11:30:00', 2),
(45, 4, 3, '2012-07-07 14:00:00', 2),
(46, 4, 0, '2012-07-07 17:30:00', 2),
(47, 6, 0, '2012-07-07 08:30:00', 2),
(48, 6, 1, '2012-07-07 10:30:00', 2),
(49, 6, 1, '2012-07-07 14:30:00', 2),
(50, 6, 0, '2012-07-07 16:00:00', 2),
(51, 7, 2, '2012-07-07 11:30:00', 2),
(52, 8, 3, '2012-07-07 16:00:00', 1),
(53, 8, 3, '2012-07-07 17:30:00', 2),
(54, 0, 3, '2012-07-08 13:00:00', 3),
(55, 0, 2, '2012-07-08 17:30:00', 3),
(56, 1, 1, '2012-07-08 15:00:00', 3),
(57, 1, 1, '2012-07-08 17:30:00', 3),
(58, 3, 1, '2012-07-08 11:30:00', 2),
(59, 3, 3, '2012-07-08 18:30:00', 2),
(60, 3, 1, '2012-07-08 19:30:00', 2),
(61, 4, 0, '2012-07-08 11:00:00', 2),
(62, 4, 2, '2012-07-08 16:30:00', 2),
(63, 4, 0, '2012-07-08 18:00:00', 2),
(64, 4, 0, '2012-07-08 19:30:00', 2),
(65, 6, 0, '2012-07-08 14:00:00', 2),
(66, 6, 0, '2012-07-08 18:30:00', 2),
(67, 7, 2, '2012-07-08 11:00:00', 2),
(68, 7, 1, '2012-07-08 16:30:00', 2),
(69, 8, 3, '2012-07-08 10:00:00', 1),
(70, 8, 3, '2012-07-08 16:30:00', 1),
(71, 0, 2, '2012-07-09 12:30:00', 3),
(72, 0, 2, '2012-07-09 15:30:00', 3),
(73, 0, 2, '2012-07-09 19:00:00', 3),
(74, 1, 0, '2012-07-09 13:00:00', 3),
(75, 1, 1, '2012-07-09 19:00:00', 3),
(76, 2, 1, '2012-07-09 09:00:00', 6),
(77, 2, 0, '2012-07-09 19:00:00', 3),
(78, 3, 3, '2012-07-09 17:00:00', 2),
(79, 3, 3, '2012-07-09 18:30:00', 2),
(80, 4, 2, '2012-07-09 11:00:00', 2),
(81, 4, 3, '2012-07-09 14:30:00', 2),
(82, 6, 0, '2012-07-09 14:30:00', 2),
(83, 7, 1, '2012-07-09 15:30:00', 2),
(84, 7, 0, '2012-07-09 18:30:00', 4),
(85, 8, 3, '2012-07-09 09:30:00', 1),
(86, 8, 3, '2012-07-09 16:30:00', 1),
(87, 8, 3, '2012-07-09 20:00:00', 1),
(88, 0, 0, '2012-07-10 11:30:00', 3),
(89, 0, 0, '2012-07-10 16:00:00', 3),
(90, 3, 2, '2012-07-10 08:00:00', 2),
(91, 3, 1, '2012-07-10 11:00:00', 2),
(92, 3, 3, '2012-07-10 15:30:00', 2),
(93, 3, 2, '2012-07-10 16:30:00', 2),
(94, 3, 1, '2012-07-10 18:00:00', 2),
(95, 4, 0, '2012-07-10 10:00:00', 2),
(96, 4, 4, '2012-07-10 11:30:00', 2),
(97, 4, 0, '2012-07-10 15:00:00', 2),
(98, 4, 3, '2012-07-10 17:00:00', 4),
(99, 5, 0, '2012-07-10 08:30:00', 2),
(100, 6, 0, '2012-07-10 14:30:00', 2),
(101, 6, 0, '2012-07-10 19:00:00', 2),
(102, 7, 4, '2012-07-10 08:30:00', 2),
(103, 7, 2, '2012-07-10 17:30:00', 2),
(104, 8, 0, '2012-07-10 11:30:00', 1),
(105, 8, 3, '2012-07-10 12:00:00', 1),
(106, 8, 3, '2012-07-10 19:30:00', 1),
(107, 0, 4, '2012-07-11 08:00:00', 3),
(108, 0, 2, '2012-07-11 10:00:00', 3),
(109, 0, 0, '2012-07-11 12:00:00', 3),
(110, 0, 0, '2012-07-11 14:00:00', 3),
(111, 0, 2, '2012-07-11 15:30:00', 3),
(112, 0, 2, '2012-07-11 18:30:00', 3),
(113, 1, 0, '2012-07-11 12:30:00', 3),
(114, 1, 0, '2012-07-11 16:00:00', 3),
(115, 4, 1, '2012-07-11 08:00:00', 2),
(116, 4, 0, '2012-07-11 09:00:00', 2),
(117, 4, 3, '2012-07-11 11:00:00', 2),
(118, 4, 0, '2012-07-11 15:00:00', 2),
(119, 5, 4, '2012-07-11 17:00:00', 2),
(120, 6, 0, '2012-07-11 14:00:00', 2),
(121, 6, 0, '2012-07-11 19:30:00', 2),
(122, 7, 0, '2012-07-11 08:00:00', 2),
(123, 7, 0, '2012-07-11 14:00:00', 2),
(124, 7, 0, '2012-07-11 16:30:00', 2),
(125, 8, 4, '2012-07-11 11:00:00', 1),
(126, 8, 3, '2012-07-11 13:00:00', 1),
(127, 0, 0, '2012-07-12 13:30:00', 3),
(128, 0, 2, '2012-07-12 16:30:00', 3),
(129, 1, 1, '2012-07-12 11:30:00', 3),
(130, 2, 1, '2012-07-12 09:00:00', 3),
(131, 2, 1, '2012-07-12 18:30:00', 3),
(132, 3, 3, '2012-07-12 18:00:00', 2),
(133, 4, 1, '2012-07-12 16:00:00', 2),
(134, 6, 0, '2012-07-12 12:00:00', 4),
(135, 7, 2, '2012-07-12 08:00:00', 2),
(136, 7, 4, '2012-07-12 13:30:00', 2),
(137, 7, 4, '2012-07-12 16:00:00', 2),
(138, 8, 3, '2012-07-12 16:30:00', 1),
(139, 0, 2, '2012-07-13 10:30:00', 3),
(140, 0, 4, '2012-07-13 14:00:00', 3),
(141, 0, 3, '2012-07-13 17:00:00', 3),
(142, 1, 1, '2012-07-13 15:00:00', 3),
(143, 2, 1, '2012-07-13 09:00:00', 3),
(144, 2, 0, '2012-07-13 15:00:00', 3),
(145, 2, 1, '2012-07-13 16:30:00', 3),
(146, 4, 0, '2012-07-13 11:00:00', 2),
(147, 4, 0, '2012-07-13 13:30:00', 2),
(148, 4, 0, '2012-07-13 15:00:00', 2),
(149, 4, 3, '2012-07-13 16:00:00', 2),
(150, 4, 4, '2012-07-13 17:30:00', 2),
(151, 6, 0, '2012-07-13 09:30:00', 2),
(152, 7, 0, '2012-07-13 08:00:00', 2),
(153, 7, 1, '2012-07-13 11:00:00', 2),
(154, 7, 4, '2012-07-13 12:30:00', 2),
(155, 8, 0, '2012-07-13 15:30:00', 1),
(156, 8, 2, '2012-07-13 18:30:00', 1),
(157, 0, 2, '2012-07-14 08:30:00', 3),
(158, 0, 4, '2012-07-14 11:30:00', 3),
(159, 0, 3, '2012-07-14 15:00:00', 3),
(160, 1, 3, '2012-07-14 10:30:00', 3),
(161, 1, 3, '2012-07-14 12:30:00', 3),
(162, 1, 0, '2012-07-14 14:30:00', 3),
(163, 2, 1, '2012-07-14 08:30:00', 3),
(164, 3, 2, '2012-07-14 16:00:00', 2),
(165, 4, 3, '2012-07-14 08:00:00', 2),
(166, 4, 1, '2012-07-14 14:30:00', 2),
(167, 6, 0, '2012-07-14 09:30:00', 2),
(168, 6, 1, '2012-07-14 12:30:00', 2),
(169, 6, 0, '2012-07-14 15:00:00', 2),
(170, 7, 2, '2012-07-14 12:30:00', 2),
(171, 7, 2, '2012-07-14 15:00:00', 2),
(172, 7, 4, '2012-07-14 16:30:00', 2),
(173, 7, 1, '2012-07-14 19:00:00', 2),
(174, 8, 3, '2012-07-14 09:00:00', 1),
(175, 8, 1, '2012-07-14 17:00:00', 1),
(176, 0, 2, '2012-07-15 08:00:00', 3),
(177, 0, 0, '2012-07-15 16:00:00', 3),
(178, 0, 2, '2012-07-15 19:00:00', 3),
(179, 1, 0, '2012-07-15 10:00:00', 3),
(180, 1, 0, '2012-07-15 12:00:00', 3),
(181, 1, 3, '2012-07-15 15:30:00', 3),
(182, 2, 1, '2012-07-15 13:00:00', 3),
(183, 3, 1, '2012-07-15 17:30:00', 2),
(184, 4, 3, '2012-07-15 11:30:00', 2),
(185, 4, 0, '2012-07-15 15:00:00', 2),
(186, 4, 3, '2012-07-15 17:30:00', 2),
(187, 7, 4, '2012-07-15 14:30:00', 2),
(188, 7, 4, '2012-07-15 17:00:00', 2),
(189, 8, 4, '2012-07-15 10:00:00', 1),
(190, 8, 2, '2012-07-15 12:00:00', 1),
(191, 8, 3, '2012-07-15 12:30:00', 1),
(192, 8, 3, '2012-07-15 13:30:00', 1),
(193, 0, 5, '2012-07-16 11:00:00', 3),
(194, 0, 5, '2012-07-16 19:00:00', 3),
(195, 1, 1, '2012-07-16 08:00:00', 3),
(196, 1, 0, '2012-07-16 12:30:00', 3),
(197, 2, 1, '2012-07-16 16:30:00', 3),
(198, 4, 3, '2012-07-16 09:00:00', 2),
(199, 4, 1, '2012-07-16 11:00:00', 2),
(200, 4, 3, '2012-07-16 12:00:00', 2),
(201, 4, 3, '2012-07-16 17:30:00', 2),
(202, 6, 0, '2012-07-16 18:30:00', 2),
(203, 7, 4, '2012-07-16 08:00:00', 2),
(204, 7, 2, '2012-07-16 11:30:00', 2),
(205, 7, 4, '2012-07-16 12:30:00', 2),
(206, 7, 5, '2012-07-16 14:00:00', 2),
(207, 8, 4, '2012-07-16 12:00:00', 1),
(208, 8, 1, '2012-07-16 15:00:00', 1),
(209, 8, 4, '2012-07-16 18:00:00', 1),
(210, 8, 3, '2012-07-16 19:30:00', 1),
(211, 0, 5, '2012-07-17 12:30:00', 3),
(212, 0, 5, '2012-07-17 18:00:00', 3),
(213, 1, 1, '2012-07-17 10:00:00', 3),
(214, 1, 4, '2012-07-17 14:30:00', 3),
(215, 2, 5, '2012-07-17 10:30:00', 3),
(216, 2, 1, '2012-07-17 12:30:00', 3),
(217, 2, 1, '2012-07-17 15:30:00', 3),
(218, 2, 2, '2012-07-17 19:00:00', 3),
(219, 3, 1, '2012-07-17 14:00:00', 2),
(220, 3, 2, '2012-07-17 15:00:00', 2),
(221, 4, 0, '2012-07-17 09:00:00', 2),
(222, 4, 3, '2012-07-17 10:30:00', 2),
(223, 4, 3, '2012-07-17 12:00:00', 2),
(224, 4, 5, '2012-07-17 16:00:00', 2),
(225, 4, 3, '2012-07-17 18:30:00', 2),
(226, 5, 0, '2012-07-17 13:30:00', 2),
(227, 6, 4, '2012-07-17 12:00:00', 2),
(228, 6, 0, '2012-07-17 14:00:00', 2),
(229, 7, 4, '2012-07-17 08:00:00', 2),
(230, 7, 5, '2012-07-17 14:00:00', 2),
(231, 7, 4, '2012-07-17 16:00:00', 2),
(232, 8, 3, '2012-07-17 08:30:00', 1),
(233, 8, 2, '2012-07-17 11:00:00', 1),
(234, 8, 3, '2012-07-17 11:30:00', 1),
(235, 8, 3, '2012-07-17 14:30:00', 1),
(236, 8, 0, '2012-07-17 15:00:00', 1),
(237, 8, 3, '2012-07-17 15:30:00', 1),
(238, 8, 3, '2012-07-17 18:00:00', 1),
(239, 8, 3, '2012-07-17 20:00:00', 1),
(240, 0, 5, '2012-07-18 13:00:00', 3),
(241, 0, 5, '2012-07-18 17:30:00', 3),
(242, 1, 0, '2012-07-18 14:00:00', 3),
(243, 1, 0, '2012-07-18 16:30:00', 3),
(244, 2, 1, '2012-07-18 14:00:00', 3),
(245, 3, 2, '2012-07-18 11:30:00', 2),
(246, 3, 3, '2012-07-18 19:00:00', 2),
(247, 4, 1, '2012-07-18 08:30:00', 2),
(248, 4, 4, '2012-07-18 10:00:00', 2),
(249, 4, 5, '2012-07-18 19:00:00', 2),
(250, 5, 0, '2012-07-18 14:30:00', 2),
(251, 6, 0, '2012-07-18 10:30:00', 2),
(252, 6, 0, '2012-07-18 13:00:00', 2),
(253, 6, 0, '2012-07-18 15:00:00', 2),
(254, 6, 1, '2012-07-18 19:30:00', 2),
(255, 7, 4, '2012-07-18 08:30:00', 2),
(256, 7, 4, '2012-07-18 11:00:00', 2),
(257, 8, 3, '2012-07-18 11:00:00', 1),
(258, 8, 0, '2012-07-18 13:00:00', 1),
(259, 8, 3, '2012-07-18 14:30:00', 1),
(260, 8, 4, '2012-07-18 16:00:00', 1),
(261, 8, 3, '2012-07-18 16:30:00', 1),
(262, 8, 4, '2012-07-18 20:00:00', 1),
(263, 0, 2, '2012-07-19 08:30:00', 3),
(264, 0, 4, '2012-07-19 10:30:00', 3),
(265, 0, 5, '2012-07-19 12:00:00', 3),
(266, 0, 0, '2012-07-19 13:30:00', 3),
(267, 0, 5, '2012-07-19 16:30:00', 3),
(268, 1, 1, '2012-07-19 11:30:00', 3),
(269, 1, 0, '2012-07-19 15:00:00', 3),
(270, 1, 0, '2012-07-19 18:30:00', 3),
(271, 2, 1, '2012-07-19 09:30:00', 3),
(272, 2, 0, '2012-07-19 11:30:00', 3),
(273, 2, 1, '2012-07-19 14:30:00', 3),
(274, 2, 2, '2012-07-19 16:00:00', 3),
(275, 3, 3, '2012-07-19 08:30:00', 2),
(276, 3, 3, '2012-07-19 17:00:00', 2),
(277, 3, 3, '2012-07-19 18:30:00', 2),
(278, 4, 3, '2012-07-19 12:00:00', 2),
(279, 4, 5, '2012-07-19 14:30:00', 2),
(280, 4, 0, '2012-07-19 16:30:00', 2),
(281, 4, 1, '2012-07-19 18:30:00', 2),
(282, 4, 0, '2012-07-19 19:30:00', 2),
(283, 5, 0, '2012-07-19 08:30:00', 2),
(284, 6, 4, '2012-07-19 12:30:00', 2),
(285, 6, 2, '2012-07-19 14:00:00', 2),
(286, 6, 0, '2012-07-19 15:00:00', 2),
(287, 6, 0, '2012-07-19 16:30:00', 2),
(288, 7, 2, '2012-07-19 13:00:00', 2),
(289, 7, 0, '2012-07-19 14:00:00', 2),
(290, 7, 0, '2012-07-19 16:30:00', 2),
(291, 7, 4, '2012-07-19 17:30:00', 4),
(292, 8, 3, '2012-07-19 11:00:00', 1),
(293, 8, 1, '2012-07-19 13:30:00', 1),
(294, 8, 3, '2012-07-19 14:30:00', 1),
(295, 8, 3, '2012-07-19 18:00:00', 1),
(296, 8, 3, '2012-07-19 20:00:00', 1),
(297, 0, 3, '2012-07-20 08:00:00', 3),
(298, 0, 5, '2012-07-20 12:00:00', 3),
(299, 0, 5, '2012-07-20 14:00:00', 3),
(300, 0, 5, '2012-07-20 17:30:00', 3),
(301, 0, 0, '2012-07-20 19:00:00', 3),
(302, 1, 2, '2012-07-20 08:30:00', 3),
(303, 1, 3, '2012-07-20 12:00:00', 3),
(304, 1, 4, '2012-07-20 13:30:00', 3),
(305, 2, 1, '2012-07-20 14:30:00', 3),
(306, 3, 3, '2012-07-20 15:00:00', 2),
(307, 3, 1, '2012-07-20 17:30:00', 2),
(308, 4, 5, '2012-07-20 08:00:00', 2),
(309, 4, 0, '2012-07-20 13:00:00', 2),
(310, 4, 1, '2012-07-20 16:30:00', 2),
(311, 4, 0, '2012-07-20 17:30:00', 2),
(312, 4, 3, '2012-07-20 18:30:00', 2),
(313, 6, 0, '2012-07-20 11:00:00', 2),
(314, 6, 4, '2012-07-20 12:30:00', 2),
(315, 6, 2, '2012-07-20 15:00:00', 2),
(316, 6, 0, '2012-07-20 16:00:00', 4),
(317, 7, 2, '2012-07-20 12:30:00', 2),
(318, 7, 2, '2012-07-20 16:00:00', 2),
(319, 7, 4, '2012-07-20 19:30:00', 2),
(320, 8, 1, '2012-07-20 09:00:00', 1),
(321, 8, 2, '2012-07-20 12:00:00', 1),
(322, 8, 3, '2012-07-20 19:30:00', 1),
(323, 0, 0, '2012-07-21 08:00:00', 3),
(324, 0, 5, '2012-07-21 11:00:00', 3),
(325, 0, 5, '2012-07-21 13:30:00', 3),
(326, 0, 4, '2012-07-21 15:30:00', 3),
(327, 1, 1, '2012-07-21 09:30:00', 3),
(328, 1, 0, '2012-07-21 11:00:00', 3),
(329, 2, 0, '2012-07-21 10:30:00', 3),
(330, 2, 1, '2012-07-21 13:30:00', 3),
(331, 3, 2, '2012-07-21 08:00:00', 2),
(332, 4, 0, '2012-07-21 09:00:00', 2),
(333, 4, 3, '2012-07-21 10:30:00', 2),
(334, 4, 0, '2012-07-21 14:00:00', 4),
(335, 4, 3, '2012-07-21 16:00:00', 2),
(336, 4, 1, '2012-07-21 17:00:00', 2),
(337, 4, 0, '2012-07-21 19:00:00', 2),
(338, 6, 4, '2012-07-21 08:00:00', 2),
(339, 6, 0, '2012-07-21 09:30:00', 2),
(340, 6, 0, '2012-07-21 12:00:00', 2),
(341, 8, 3, '2012-07-21 09:30:00', 1),
(342, 8, 3, '2012-07-21 11:30:00', 1),
(343, 8, 3, '2012-07-21 18:00:00', 2),
(344, 8, 3, '2012-07-21 19:30:00', 1),
(345, 0, 5, '2012-07-22 10:00:00', 3),
(346, 0, 0, '2012-07-22 16:00:00', 3),
(347, 0, 2, '2012-07-22 18:00:00', 3),
(348, 1, 0, '2012-07-22 08:30:00', 3),
(349, 1, 0, '2012-07-22 10:30:00', 3),
(350, 1, 5, '2012-07-22 18:30:00', 3),
(351, 2, 1, '2012-07-22 08:30:00', 3),
(352, 2, 1, '2012-07-22 13:30:00', 3),
(353, 2, 1, '2012-07-22 16:30:00', 3),
(354, 3, 3, '2012-07-22 11:30:00', 2),
(355, 3, 2, '2012-07-22 14:00:00', 2),
(356, 4, 4, '2012-07-22 08:00:00', 2),
(357, 4, 3, '2012-07-22 10:30:00', 2),
(358, 4, 0, '2012-07-22 12:00:00', 2),
(359, 4, 5, '2012-07-22 13:00:00', 2),
(360, 4, 0, '2012-07-22 16:30:00', 2),
(361, 4, 1, '2012-07-22 18:00:00', 2),
(362, 4, 3, '2012-07-22 19:30:00', 2),
(363, 6, 4, '2012-07-22 10:30:00', 4),
(364, 6, 0, '2012-07-22 14:30:00', 2),
(365, 6, 0, '2012-07-22 16:30:00', 2),
(366, 7, 2, '2012-07-22 10:30:00', 2),
(367, 7, 2, '2012-07-22 12:00:00', 2),
(368, 8, 3, '2012-07-22 16:00:00', 1),
(369, 8, 3, '2012-07-22 17:00:00', 1),
(370, 8, 2, '2012-07-22 17:30:00', 1),
(371, 0, 0, '2012-07-23 09:30:00', 3),
(372, 0, 0, '2012-07-23 12:00:00', 3),
(373, 0, 5, '2012-07-23 17:00:00', 3),
(374, 1, 1, '2012-07-23 10:00:00', 3),
(375, 1, 4, '2012-07-23 12:30:00', 3),
(376, 1, 4, '2012-07-23 15:30:00', 3),
(377, 1, 0, '2012-07-23 17:00:00', 3),
(378, 1, 4, '2012-07-23 19:00:00', 3),
(379, 2, 1, '2012-07-23 08:00:00', 3),
(380, 2, 5, '2012-07-23 11:30:00', 3),
(381, 2, 1, '2012-07-23 13:00:00', 3),
(382, 2, 1, '2012-07-23 15:00:00', 3),
(383, 3, 2, '2012-07-23 09:30:00', 2),
(384, 3, 2, '2012-07-23 19:00:00', 2),
(385, 4, 4, '2012-07-23 10:00:00', 2),
(386, 4, 0, '2012-07-23 16:30:00', 2),
(387, 4, 3, '2012-07-23 19:00:00', 2),
(388, 5, 3, '2012-07-23 13:00:00', 2),
(389, 6, 0, '2012-07-23 13:30:00', 2),
(390, 6, 0, '2012-07-23 15:00:00', 4),
(391, 6, 0, '2012-07-23 19:00:00', 2),
(392, 7, 5, '2012-07-23 16:00:00', 2),
(393, 7, 4, '2012-07-23 18:00:00', 2),
(394, 8, 3, '2012-07-23 08:30:00', 3),
(395, 8, 3, '2012-07-23 11:00:00', 1),
(396, 8, 3, '2012-07-23 14:00:00', 2),
(397, 8, 2, '2012-07-23 15:00:00', 1),
(398, 0, 0, '2012-07-24 11:00:00', 3),
(399, 0, 4, '2012-07-24 13:00:00', 3),
(400, 0, 5, '2012-07-24 14:30:00', 3),
(401, 1, 4, '2012-07-24 11:00:00', 3),
(402, 1, 0, '2012-07-24 16:00:00', 6),
(403, 1, 1, '2012-07-24 19:00:00', 3),
(404, 2, 1, '2012-07-24 09:00:00', 3),
(405, 2, 2, '2012-07-24 12:30:00', 3),
(406, 3, 3, '2012-07-24 09:00:00', 2),
(407, 3, 3, '2012-07-24 17:30:00', 2),
(408, 4, 0, '2012-07-24 08:30:00', 2),
(409, 4, 5, '2012-07-24 09:30:00', 2),
(410, 4, 0, '2012-07-24 11:30:00', 2),
(411, 4, 1, '2012-07-24 14:30:00', 2),
(412, 4, 0, '2012-07-24 15:30:00', 2),
(413, 4, 0, '2012-07-24 17:30:00', 2),
(414, 4, 0, '2012-07-24 19:30:00', 2),
(415, 5, 5, '2012-07-24 16:30:00', 2),
(416, 6, 0, '2012-07-24 09:30:00', 2),
(417, 6, 0, '2012-07-24 14:30:00', 2),
(418, 7, 4, '2012-07-24 09:30:00', 2),
(419, 7, 5, '2012-07-24 11:30:00', 2),
(420, 7, 2, '2012-07-24 16:30:00', 2),
(421, 7, 4, '2012-07-24 18:00:00', 2),
(422, 7, 2, '2012-07-24 19:30:00', 2),
(423, 8, 3, '2012-07-24 08:30:00', 1),
(424, 8, 3, '2012-07-24 10:30:00', 2),
(425, 8, 3, '2012-07-24 12:00:00', 1),
(426, 8, 3, '2012-07-24 14:00:00', 1),
(427, 8, 0, '2012-07-24 15:00:00', 1),
(428, 8, 4, '2012-07-24 16:30:00', 1),
(429, 8, 0, '2012-07-24 20:00:00', 1),
(430, 0, 5, '2012-07-25 08:00:00', 3),
(431, 0, 0, '2012-07-25 12:30:00', 3),
(432, 0, 0, '2012-07-25 16:30:00', 3),
(433, 1, 1, '2012-07-25 08:00:00', 3),
(434, 1, 0, '2012-07-25 10:30:00', 3),
(435, 1, 4, '2012-07-25 15:00:00', 3),
(436, 2, 1, '2012-07-25 13:30:00', 3),
(437, 2, 1, '2012-07-25 17:30:00', 3),
(438, 3, 2, '2012-07-25 10:00:00', 2),
(439, 3, 3, '2012-07-25 14:00:00', 4),
(440, 3, 3, '2012-07-25 17:00:00', 2),
(441, 3, 2, '2012-07-25 18:30:00', 2),
(442, 4, 3, '2012-07-25 08:30:00', 2),
(443, 4, 0, '2012-07-25 09:30:00', 4),
(444, 4, 3, '2012-07-25 11:30:00', 4),
(445, 4, 5, '2012-07-25 13:30:00', 4),
(446, 4, 3, '2012-07-25 16:00:00', 2),
(447, 4, 3, '2012-07-25 18:00:00', 2),
(448, 4, 3, '2012-07-25 19:30:00', 2),
(449, 5, 0, '2012-07-25 18:30:00', 2),
(450, 6, 4, '2012-07-25 08:30:00', 2),
(451, 6, 1, '2012-07-25 09:30:00', 2),
(452, 6, 0, '2012-07-25 12:00:00', 2),
(453, 6, 0, '2012-07-25 13:30:00', 2),
(454, 6, 0, '2012-07-25 16:30:00', 4),
(455, 6, 5, '2012-07-25 19:00:00', 2),
(456, 7, 5, '2012-07-25 10:30:00', 2),
(457, 7, 2, '2012-07-25 14:00:00', 2),
(458, 7, 2, '2012-07-25 16:00:00', 2),
(459, 8, 3, '2012-07-25 08:00:00', 1),
(460, 8, 3, '2012-07-25 10:00:00', 1),
(461, 8, 4, '2012-07-25 14:30:00', 1),
(462, 8, 1, '2012-07-25 16:00:00', 1),
(463, 8, 2, '2012-07-25 20:00:00', 1),
(464, 0, 4, '2012-07-26 09:00:00', 3),
(465, 0, 0, '2012-07-26 11:30:00', 3),
(466, 0, 4, '2012-07-26 18:00:00', 3),
(467, 1, 8, '2012-07-26 08:00:00', 3),
(468, 1, 8, '2012-07-26 11:30:00', 3),
(469, 1, 8, '2012-07-26 13:30:00', 3),
(470, 1, 1, '2012-07-26 15:00:00', 3),
(471, 1, 0, '2012-07-26 16:30:00', 3),
(472, 1, 6, '2012-07-26 19:00:00', 3),
(473, 2, 1, '2012-07-26 08:30:00', 3),
(474, 2, 2, '2012-07-26 11:00:00', 6),
(475, 2, 7, '2012-07-26 14:00:00', 3),
(476, 2, 2, '2012-07-26 17:00:00', 3),
(477, 2, 3, '2012-07-26 19:00:00', 3),
(478, 3, 0, '2012-07-26 09:00:00', 2),
(479, 3, 0, '2012-07-26 13:30:00', 2),
(480, 3, 3, '2012-07-26 16:00:00', 2),
(481, 4, 3, '2012-07-26 08:00:00', 2),
(482, 4, 6, '2012-07-26 09:00:00', 2),
(483, 4, 0, '2012-07-26 12:00:00', 2),
(484, 4, 5, '2012-07-26 13:30:00', 2),
(485, 4, 6, '2012-07-26 16:00:00', 2),
(486, 4, 7, '2012-07-26 17:30:00', 2),
(487, 6, 0, '2012-07-26 10:00:00', 4),
(488, 6, 0, '2012-07-26 13:00:00', 2),
(489, 6, 0, '2012-07-26 19:00:00', 2),
(490, 7, 7, '2012-07-26 09:30:00', 2),
(491, 7, 6, '2012-07-26 11:00:00', 2),
(492, 7, 5, '2012-07-26 12:30:00', 2),
(493, 7, 4, '2012-07-26 13:30:00', 2),
(494, 7, 5, '2012-07-26 17:00:00', 2),
(495, 8, 3, '2012-07-26 12:00:00', 1),
(496, 8, 3, '2012-07-26 13:30:00', 1),
(497, 8, 2, '2012-07-26 15:00:00', 1),
(498, 8, 1, '2012-07-26 16:30:00', 1),
(499, 8, 3, '2012-07-26 17:00:00', 1),
(500, 0, 4, '2012-07-27 08:00:00', 3),
(501, 0, 5, '2012-07-27 11:00:00', 3),
(502, 0, 6, '2012-07-27 14:00:00', 3),
(503, 0, 6, '2012-07-27 17:30:00', 3),
(504, 1, 0, '2012-07-27 10:00:00', 3),
(505, 1, 7, '2012-07-27 11:30:00', 3),
(506, 1, 0, '2012-07-27 13:00:00', 3),
(507, 1, 0, '2012-07-27 15:00:00', 3),
(508, 1, 0, '2012-07-27 18:00:00', 3),
(509, 2, 1, '2012-07-27 12:00:00', 6),
(510, 3, 0, '2012-07-27 10:30:00', 2),
(511, 3, 2, '2012-07-27 14:00:00', 2),
(512, 3, 3, '2012-07-27 19:00:00', 2),
(513, 4, 1, '2012-07-27 10:00:00', 4),
(514, 4, 6, '2012-07-27 12:30:00', 2),
(515, 4, 0, '2012-07-27 14:00:00', 4),
(516, 4, 0, '2012-07-27 16:30:00', 2),
(517, 4, 1, '2012-07-27 17:30:00', 2),
(518, 4, 0, '2012-07-27 18:30:00', 2),
(519, 5, 7, '2012-07-27 18:00:00', 2),
(520, 6, 0, '2012-07-27 09:00:00', 2),
(521, 6, 5, '2012-07-27 14:00:00', 2),
(522, 6, 8, '2012-07-27 16:30:00', 2),
(523, 7, 2, '2012-07-27 18:00:00', 2),
(524, 7, 4, '2012-07-27 19:00:00', 2),
(525, 8, 3, '2012-07-27 09:00:00', 1),
(526, 8, 3, '2012-07-27 12:30:00', 1),
(527, 8, 3, '2012-07-27 16:00:00', 1),
(528, 8, 6, '2012-07-27 16:30:00', 1),
(529, 8, 0, '2012-07-27 18:30:00', 1),
(530, 0, 7, '2012-07-28 08:00:00', 9),
(531, 0, 4, '2012-07-28 13:00:00', 3),
(532, 0, 5, '2012-07-28 15:00:00', 3),
(533, 0, 2, '2012-07-28 19:00:00', 3),
(534, 1, 1, '2012-07-28 08:00:00', 3),
(535, 1, 0, '2012-07-28 10:00:00', 3),
(536, 1, 0, '2012-07-28 16:00:00', 3),
(537, 1, 7, '2012-07-28 17:30:00', 3),
(538, 2, 1, '2012-07-28 10:00:00', 3),
(539, 2, 1, '2012-07-28 14:00:00', 3),
(540, 2, 1, '2012-07-28 17:00:00', 3),
(541, 2, 5, '2012-07-28 18:30:00', 3),
(542, 3, 3, '2012-07-28 08:30:00', 2),
(543, 3, 3, '2012-07-28 15:30:00', 2),
(544, 4, 0, '2012-07-28 09:00:00', 2),
(545, 4, 3, '2012-07-28 10:30:00', 4),
(546, 4, 0, '2012-07-28 12:30:00', 2),
(547, 4, 8, '2012-07-28 16:00:00', 2),
(548, 4, 0, '2012-07-28 19:00:00', 2),
(549, 5, 0, '2012-07-28 18:00:00', 2),
(550, 6, 0, '2012-07-28 17:00:00', 2),
(551, 6, 0, '2012-07-28 18:30:00', 2),
(552, 7, 2, '2012-07-28 09:00:00', 2),
(553, 7, 5, '2012-07-28 10:00:00', 2),
(554, 7, 6, '2012-07-28 12:30:00', 2),
(555, 7, 8, '2012-07-28 17:00:00', 4),
(556, 8, 2, '2012-07-28 16:00:00', 1),
(557, 8, 3, '2012-07-28 16:30:00', 1),
(558, 8, 4, '2012-07-28 19:00:00', 1),
(559, 0, 7, '2012-07-29 09:30:00', 3),
(560, 0, 2, '2012-07-29 11:00:00', 3),
(561, 0, 6, '2012-07-29 13:00:00', 3),
(562, 0, 5, '2012-07-29 15:00:00', 3),
(563, 0, 0, '2012-07-29 17:00:00', 3),
(564, 1, 8, '2012-07-29 09:30:00', 3),
(565, 1, 0, '2012-07-29 15:00:00', 3),
(566, 1, 8, '2012-07-29 16:30:00', 3),
(567, 2, 1, '2012-07-29 08:30:00', 3),
(568, 2, 1, '2012-07-29 12:00:00', 6),
(569, 2, 1, '2012-07-29 15:30:00', 3),
(570, 4, 3, '2012-07-29 08:00:00', 2),
(571, 4, 0, '2012-07-29 09:00:00', 2),
(572, 4, 3, '2012-07-29 10:30:00', 2),
(573, 4, 8, '2012-07-29 11:30:00', 4),
(574, 4, 8, '2012-07-29 15:00:00', 2),
(575, 4, 0, '2012-07-29 18:30:00', 2),
(576, 6, 0, '2012-07-29 09:00:00', 2),
(577, 6, 0, '2012-07-29 10:30:00', 2),
(578, 6, 6, '2012-07-29 17:30:00', 4),
(579, 7, 4, '2012-07-29 16:00:00', 2),
(580, 7, 8, '2012-07-29 18:30:00', 2),
(581, 8, 3, '2012-07-29 12:30:00', 1),
(582, 8, 7, '2012-07-29 13:00:00', 1),
(583, 8, 3, '2012-07-29 15:30:00', 1),
(584, 8, 3, '2012-07-29 18:00:00', 1),
(585, 0, 5, '2012-07-30 14:00:00', 3),
(586, 0, 6, '2012-07-30 15:30:00', 3),
(587, 0, 7, '2012-07-30 19:00:00', 3),
(588, 1, 8, '2012-07-30 08:30:00', 3),
(589, 1, 7, '2012-07-30 11:00:00', 3),
(590, 1, 2, '2012-07-30 13:30:00', 3),
(591, 1, 1, '2012-07-30 15:30:00', 3),
(592, 2, 5, '2012-07-30 10:00:00', 3),
(593, 2, 8, '2012-07-30 11:30:00', 3),
(594, 2, 7, '2012-07-30 15:00:00', 3),
(595, 2, 0, '2012-07-30 17:30:00', 3),
(596, 3, 3, '2012-07-30 11:30:00', 2),
(597, 3, 4, '2012-07-30 16:30:00', 2),
(598, 4, 0, '2012-07-30 08:00:00', 2),
(599, 4, 0, '2012-07-30 10:30:00', 2),
(600, 4, 0, '2012-07-30 12:00:00', 2),
(601, 4, 7, '2012-07-30 18:00:00', 2),
(602, 4, 3, '2012-07-30 19:30:00', 2),
(603, 5, 0, '2012-07-30 12:30:00', 2),
(604, 5, 0, '2012-07-30 14:00:00', 2),
(605, 6, 0, '2012-07-30 08:30:00', 2),
(606, 6, 0, '2012-07-30 12:00:00', 2),
(607, 6, 0, '2012-07-30 14:30:00', 2),
(608, 6, 0, '2012-07-30 17:30:00', 2),
(609, 7, 7, '2012-07-30 08:00:00', 2),
(610, 7, 6, '2012-07-30 09:30:00', 2),
(611, 7, 8, '2012-07-30 14:30:00', 2),
(612, 7, 5, '2012-07-30 16:30:00', 2),
(613, 7, 4, '2012-07-30 18:00:00', 2),
(614, 7, 6, '2012-07-30 19:00:00', 2),
(615, 8, 3, '2012-07-30 08:30:00', 1),
(616, 8, 2, '2012-07-30 09:00:00', 1),
(617, 8, 2, '2012-07-30 11:00:00', 1),
(618, 8, 2, '2012-07-30 12:30:00', 1),
(619, 8, 3, '2012-07-30 15:00:00', 2),
(620, 8, 5, '2012-07-30 16:00:00', 1),
(621, 8, 2, '2012-07-30 16:30:00', 1),
(622, 8, 3, '2012-07-30 18:30:00', 1),
(623, 8, 1, '2012-07-30 19:30:00', 1),
(624, 0, 7, '2012-07-31 09:30:00', 3),
(625, 0, 0, '2012-07-31 11:00:00', 3),
(626, 0, 0, '2012-07-31 15:00:00', 3),
(627, 0, 5, '2012-07-31 17:00:00', 3),
(628, 0, 0, '2012-07-31 18:30:00', 3),
(629, 1, 0, '2012-07-31 08:00:00', 3),
(630, 1, 7, '2012-07-31 13:00:00', 3),
(631, 2, 1, '2012-07-31 16:30:00', 3),
(632, 3, 3, '2012-07-31 08:30:00', 2),
(633, 3, 1, '2012-07-31 13:00:00', 2),
(634, 3, 1, '2012-07-31 15:30:00', 2),
(635, 4, 8, '2012-07-31 09:30:00', 2),
(636, 4, 0, '2012-07-31 11:00:00', 2),
(637, 4, 3, '2012-07-31 12:00:00', 2),
(638, 4, 2, '2012-07-31 13:00:00', 2),
(639, 4, 3, '2012-07-31 14:00:00', 2),
(640, 4, 0, '2012-07-31 15:00:00', 2),
(641, 4, 6, '2012-07-31 17:00:00', 2),
(642, 4, 7, '2012-07-31 18:30:00', 2),
(643, 4, 0, '2012-07-31 19:30:00', 2),
(644, 6, 0, '2012-07-31 09:00:00', 2),
(645, 6, 5, '2012-07-31 10:00:00', 2),
(646, 6, 6, '2012-07-31 11:00:00', 2),
(647, 6, 0, '2012-07-31 14:30:00', 2),
(648, 6, 6, '2012-07-31 16:00:00', 2),
(649, 7, 4, '2012-07-31 18:30:00', 2),
(650, 8, 3, '2012-07-31 10:00:00', 1),
(651, 8, 3, '2012-07-31 11:30:00', 1),
(652, 8, 5, '2012-07-31 12:00:00', 1),
(653, 8, 7, '2012-07-31 12:30:00', 1),
(654, 8, 8, '2012-07-31 13:30:00', 1),
(655, 8, 6, '2012-07-31 14:00:00', 1),
(656, 8, 4, '2012-07-31 17:00:00', 1),
(657, 8, 2, '2012-07-31 17:30:00', 1),
(658, 0, 5, '2012-08-01 15:30:00', 3),
(659, 0, 5, '2012-08-01 18:00:00', 3),
(660, 1, 8, '2012-08-01 09:00:00', 9),
(661, 1, 8, '2012-08-01 17:30:00', 3),
(662, 2, 1, '2012-08-01 09:30:00', 6),
(663, 2, 1, '2012-08-01 14:30:00', 3),
(664, 2, 1, '2012-08-01 16:30:00', 3),
(665, 3, 7, '2012-08-01 13:00:00', 2),
(666, 4, 5, '2012-08-01 08:00:00', 2),
(667, 4, 6, '2012-08-01 09:00:00', 2),
(668, 4, 0, '2012-08-01 10:30:00', 6),
(669, 4, 3, '2012-08-01 13:30:00', 4),
(670, 4, 3, '2012-08-01 19:30:00', 2),
(671, 5, 7, '2012-08-01 08:30:00', 2),
(672, 5, 0, '2012-08-01 14:30:00', 2),
(673, 6, 0, '2012-08-01 09:30:00', 2),
(674, 6, 0, '2012-08-01 11:00:00', 4),
(675, 6, 6, '2012-08-01 14:30:00', 2),
(676, 6, 0, '2012-08-01 18:00:00', 2),
(677, 7, 4, '2012-08-01 12:30:00', 2),
(678, 7, 2, '2012-08-01 16:00:00', 2),
(679, 7, 5, '2012-08-01 17:00:00', 2),
(680, 8, 3, '2012-08-01 08:30:00', 2),
(681, 8, 2, '2012-08-01 09:30:00', 1),
(682, 8, 3, '2012-08-01 10:30:00', 1),
(683, 8, 3, '2012-08-01 11:30:00', 1),
(684, 8, 8, '2012-08-01 13:30:00', 1),
(685, 8, 8, '2012-08-01 15:00:00', 1),
(686, 8, 3, '2012-08-01 17:00:00', 1),
(687, 0, 8, '2012-08-02 08:00:00', 3),
(688, 0, 5, '2012-08-02 13:00:00', 3),
(689, 0, 7, '2012-08-02 15:30:00', 3),
(690, 0, 5, '2012-08-02 18:30:00', 3),
(691, 1, 8, '2012-08-02 09:30:00', 3),
(692, 1, 8, '2012-08-02 12:00:00', 3),
(693, 1, 0, '2012-08-02 13:30:00', 3),
(694, 1, 5, '2012-08-02 15:30:00', 3),
(695, 1, 0, '2012-08-02 18:00:00', 3),
(696, 2, 1, '2012-08-02 09:30:00', 3),
(697, 2, 0, '2012-08-02 11:30:00', 3),
(698, 2, 3, '2012-08-02 14:00:00', 3),
(699, 2, 1, '2012-08-02 19:00:00', 3),
(700, 3, 3, '2012-08-02 10:00:00', 2),
(701, 3, 2, '2012-08-02 15:00:00', 2),
(702, 3, 3, '2012-08-02 17:00:00', 2),
(703, 3, 6, '2012-08-02 18:00:00', 2),
(704, 3, 4, '2012-08-02 19:30:00', 2),
(705, 4, 4, '2012-08-02 10:00:00', 2),
(706, 4, 7, '2012-08-02 11:30:00', 2),
(707, 4, 5, '2012-08-02 14:30:00', 2),
(708, 4, 8, '2012-08-02 15:30:00', 2),
(709, 4, 8, '2012-08-02 17:00:00', 2),
(710, 4, 3, '2012-08-02 18:30:00', 2),
(711, 4, 0, '2012-08-02 19:30:00', 2),
(712, 6, 4, '2012-08-02 09:00:00', 2),
(713, 6, 0, '2012-08-02 10:00:00', 2),
(714, 6, 0, '2012-08-02 11:30:00', 2),
(715, 6, 6, '2012-08-02 12:30:00', 2),
(716, 6, 8, '2012-08-02 14:00:00', 2),
(717, 6, 0, '2012-08-02 17:00:00', 4),
(718, 6, 2, '2012-08-02 19:30:00', 2),
(719, 7, 7, '2012-08-02 08:00:00', 2),
(720, 7, 5, '2012-08-02 11:00:00', 2),
(721, 7, 6, '2012-08-02 14:00:00', 2),
(722, 7, 4, '2012-08-02 16:00:00', 2),
(723, 7, 0, '2012-08-02 18:00:00', 2),
(724, 8, 3, '2012-08-02 08:30:00', 1),
(725, 8, 3, '2012-08-02 13:00:00', 1),
(726, 8, 7, '2012-08-02 15:00:00', 1),
(727, 8, 3, '2012-08-02 16:30:00', 1),
(728, 8, 7, '2012-08-02 17:00:00', 1),
(729, 8, 3, '2012-08-02 19:30:00', 1),
(730, 0, 5, '2012-08-03 11:30:00', 3),
(731, 0, 0, '2012-08-03 16:00:00', 3),
(732, 0, 6, '2012-08-03 18:30:00', 3),
(733, 1, 8, '2012-08-03 10:30:00', 3),
(734, 1, 0, '2012-08-03 13:00:00', 6),
(735, 1, 7, '2012-08-03 16:30:00', 3),
(736, 1, 8, '2012-08-03 19:00:00', 3),
(737, 2, 8, '2012-08-03 08:30:00', 3),
(738, 2, 1, '2012-08-03 11:00:00', 3),
(739, 3, 6, '2012-08-03 08:00:00', 2),
(740, 3, 2, '2012-08-03 10:00:00', 2),
(741, 3, 6, '2012-08-03 12:00:00', 2),
(742, 3, 6, '2012-08-03 16:30:00', 2),
(743, 3, 2, '2012-08-03 18:30:00', 2),
(744, 4, 0, '2012-08-03 09:30:00', 2),
(745, 4, 7, '2012-08-03 10:30:00', 2),
(746, 4, 0, '2012-08-03 11:30:00', 2),
(747, 4, 0, '2012-08-03 13:00:00', 2),
(748, 4, 1, '2012-08-03 14:30:00', 2),
(749, 4, 3, '2012-08-03 15:30:00', 4),
(750, 4, 3, '2012-08-03 18:30:00', 2),
(751, 6, 0, '2012-08-03 09:00:00', 2),
(752, 6, 0, '2012-08-03 10:30:00', 2),
(753, 6, 4, '2012-08-03 12:00:00', 2),
(754, 6, 0, '2012-08-03 15:30:00', 2),
(755, 6, 1, '2012-08-03 16:30:00', 2),
(756, 6, 0, '2012-08-03 19:00:00', 2),
(757, 7, 6, '2012-08-03 09:00:00', 2),
(758, 7, 6, '2012-08-03 10:30:00', 2),
(759, 7, 2, '2012-08-03 13:30:00', 2),
(760, 7, 5, '2012-08-03 17:30:00', 2),
(761, 8, 8, '2012-08-03 12:00:00', 1),
(762, 8, 3, '2012-08-03 12:30:00', 1),
(763, 8, 6, '2012-08-03 14:00:00', 1),
(764, 8, 3, '2012-08-03 15:00:00', 1),
(765, 8, 6, '2012-08-03 15:30:00', 1),
(766, 8, 8, '2012-08-03 16:00:00', 1),
(767, 8, 0, '2012-08-03 19:00:00', 1),
(768, 8, 3, '2012-08-03 19:30:00', 1),
(769, 0, 6, '2012-08-04 15:00:00', 3),
(770, 1, 9, '2012-08-04 09:30:00', 3),
(771, 1, 0, '2012-08-04 11:30:00', 3),
(772, 1, 8, '2012-08-04 16:00:00', 3),
(773, 1, 0, '2012-08-04 18:30:00', 3),
(774, 2, 1, '2012-08-04 08:00:00', 3),
(775, 2, 2, '2012-08-04 09:30:00', 3),
(776, 2, 1, '2012-08-04 11:00:00', 3),
(777, 2, 2, '2012-08-04 16:30:00', 3),
(778, 2, 9, '2012-08-04 18:30:00', 3),
(779, 3, 6, '2012-08-04 11:30:00', 2),
(780, 3, 1, '2012-08-04 15:00:00', 2),
(781, 3, 3, '2012-08-04 18:00:00', 2),
(782, 3, 4, '2012-08-04 19:00:00', 2),
(783, 4, 8, '2012-08-04 08:30:00', 2),
(784, 4, 7, '2012-08-04 10:00:00', 2),
(785, 4, 0, '2012-08-04 13:30:00', 2),
(786, 4, 5, '2012-08-04 14:30:00', 2),
(787, 4, 0, '2012-08-04 17:00:00', 2),
(788, 4, 5, '2012-08-04 19:30:00', 2),
(789, 5, 0, '2012-08-04 12:30:00', 2),
(790, 6, 6, '2012-08-04 08:30:00', 2),
(791, 6, 5, '2012-08-04 09:30:00', 2),
(792, 6, 6, '2012-08-04 12:30:00', 2),
(793, 6, 0, '2012-08-04 16:00:00', 2),
(794, 6, 0, '2012-08-04 17:30:00', 2),
(795, 7, 5, '2012-08-04 08:00:00', 2),
(796, 7, 9, '2012-08-04 11:00:00', 2),
(797, 7, 7, '2012-08-04 15:00:00', 2),
(798, 7, 5, '2012-08-04 18:30:00', 2),
(799, 8, 3, '2012-08-04 08:00:00', 1),
(800, 8, 3, '2012-08-04 11:00:00', 2),
(801, 8, 3, '2012-08-04 13:00:00', 1),
(802, 8, 3, '2012-08-04 16:30:00', 1),
(803, 8, 6, '2012-08-04 18:00:00', 1),
(804, 8, 7, '2012-08-04 18:30:00', 1),
(805, 8, 3, '2012-08-04 19:00:00', 1),
(806, 0, 2, '2012-08-05 08:00:00', 3),
(807, 0, 5, '2012-08-05 09:30:00', 3),
(808, 0, 7, '2012-08-05 15:00:00', 3),
(809, 0, 7, '2012-08-05 17:30:00', 3),
(810, 1, 0, '2012-08-05 08:00:00', 3),
(811, 1, 7, '2012-08-05 09:30:00', 3),
(812, 1, 9, '2012-08-05 11:00:00', 3),
(813, 1, 9, '2012-08-05 15:30:00', 3),
(814, 1, 1, '2012-08-05 18:00:00', 3),
(815, 2, 1, '2012-08-05 10:00:00', 3),
(816, 2, 5, '2012-08-05 11:30:00', 3),
(817, 2, 2, '2012-08-05 15:00:00', 3),
(818, 2, 8, '2012-08-05 17:00:00', 3),
(819, 3, 3, '2012-08-05 09:30:00', 2),
(820, 3, 4, '2012-08-05 14:30:00', 2),
(821, 3, 3, '2012-08-05 15:30:00', 2),
(822, 4, 0, '2012-08-05 08:30:00', 2),
(823, 4, 0, '2012-08-05 10:00:00', 2),
(824, 4, 0, '2012-08-05 11:30:00', 2),
(825, 4, 4, '2012-08-05 16:00:00', 2),
(826, 4, 8, '2012-08-05 19:00:00', 2),
(827, 6, 0, '2012-08-05 10:00:00', 4),
(828, 6, 6, '2012-08-05 13:00:00', 2),
(829, 6, 0, '2012-08-05 15:30:00', 2),
(830, 7, 2, '2012-08-05 10:30:00', 2),
(831, 7, 8, '2012-08-05 15:30:00', 2),
(832, 7, 2, '2012-08-05 19:30:00', 2),
(833, 8, 0, '2012-08-05 08:30:00', 1),
(834, 8, 3, '2012-08-05 13:00:00', 1),
(835, 8, 0, '2012-08-05 14:00:00', 1),
(836, 8, 3, '2012-08-05 16:30:00', 1),
(837, 8, 3, '2012-08-05 17:30:00', 1),
(838, 8, 3, '2012-08-05 19:30:00', 2),
(839, 0, 7, '2012-08-06 09:00:00', 3),
(840, 0, 0, '2012-08-06 10:30:00', 3),
(841, 0, 2, '2012-08-06 12:00:00', 3),
(842, 0, 0, '2012-08-06 13:30:00', 3),
(843, 0, 7, '2012-08-06 15:00:00', 3),
(844, 0, 5, '2012-08-06 16:30:00', 3),
(845, 0, 7, '2012-08-06 18:00:00', 3),
(846, 1, 8, '2012-08-06 08:00:00', 3),
(847, 1, 3, '2012-08-06 10:00:00', 3),
(848, 1, 0, '2012-08-06 11:30:00', 3),
(849, 1, 9, '2012-08-06 14:30:00', 3),
(850, 1, 9, '2012-08-06 17:30:00', 3),
(851, 2, 1, '2012-08-06 08:30:00', 3),
(852, 2, 5, '2012-08-06 10:30:00', 3),
(853, 2, 8, '2012-08-06 12:00:00', 3),
(854, 2, 8, '2012-08-06 14:00:00', 3),
(855, 3, 3, '2012-08-06 08:30:00', 2),
(856, 3, 6, '2012-08-06 15:00:00', 2),
(857, 3, 6, '2012-08-06 17:00:00', 2),
(858, 4, 0, '2012-08-06 08:00:00', 4),
(859, 4, 0, '2012-08-06 12:00:00', 2),
(860, 4, 7, '2012-08-06 13:30:00', 2),
(861, 4, 0, '2012-08-06 16:30:00', 2),
(862, 4, 6, '2012-08-06 18:30:00', 2),
(863, 5, 0, '2012-08-06 11:00:00', 2),
(864, 6, 6, '2012-08-06 09:00:00', 2),
(865, 6, 0, '2012-08-06 10:00:00', 2),
(866, 6, 6, '2012-08-06 13:00:00', 2),
(867, 6, 0, '2012-08-06 14:00:00', 2),
(868, 6, 5, '2012-08-06 15:00:00', 2),
(869, 7, 8, '2012-08-06 09:30:00', 2),
(870, 7, 2, '2012-08-06 11:00:00', 2),
(871, 7, 5, '2012-08-06 12:00:00', 4),
(872, 7, 4, '2012-08-06 17:30:00', 2),
(873, 7, 2, '2012-08-06 19:00:00', 2),
(874, 8, 3, '2012-08-06 08:00:00', 1),
(875, 8, 4, '2012-08-06 09:00:00', 1),
(876, 8, 3, '2012-08-06 09:30:00', 1),
(877, 8, 6, '2012-08-06 12:00:00', 1),
(878, 8, 1, '2012-08-06 18:00:00', 1),
(879, 8, 8, '2012-08-06 18:30:00', 1),
(880, 8, 3, '2012-08-06 19:00:00', 1),
(881, 0, 10, '2012-08-07 09:00:00', 3),
(882, 1, 0, '2012-08-07 08:00:00', 3),
(883, 1, 8, '2012-08-07 09:30:00', 3),
(884, 1, 7, '2012-08-07 17:00:00', 3),
(885, 2, 1, '2012-08-07 09:00:00', 6),
(886, 2, 1, '2012-08-07 13:00:00', 3),
(887, 2, 10, '2012-08-07 15:00:00', 3),
(888, 2, 2, '2012-08-07 18:00:00', 3),
(889, 3, 6, '2012-08-07 08:30:00', 2),
(890, 3, 6, '2012-08-07 10:00:00', 2),
(891, 3, 3, '2012-08-07 11:00:00', 2),
(892, 3, 3, '2012-08-07 12:30:00', 2),
(893, 3, 3, '2012-08-07 14:30:00', 2),
(894, 4, 0, '2012-08-07 08:30:00', 2),
(895, 4, 8, '2012-08-07 12:00:00', 2),
(896, 4, 8, '2012-08-07 13:30:00', 2),
(897, 4, 0, '2012-08-07 15:30:00', 2),
(898, 4, 6, '2012-08-07 18:30:00', 2),
(899, 6, 1, '2012-08-07 08:00:00', 2),
(900, 6, 0, '2012-08-07 14:00:00', 2),
(901, 6, 0, '2012-08-07 15:30:00', 2),
(902, 6, 0, '2012-08-07 18:00:00', 2),
(903, 7, 10, '2012-08-07 12:30:00', 2),
(904, 7, 4, '2012-08-07 15:00:00', 2),
(905, 7, 9, '2012-08-07 18:30:00', 2),
(906, 8, 3, '2012-08-07 08:30:00', 2),
(907, 8, 2, '2012-08-07 10:00:00', 1),
(908, 8, 3, '2012-08-07 10:30:00', 1),
(909, 8, 0, '2012-08-07 11:00:00', 1),
(910, 8, 3, '2012-08-07 12:00:00', 1),
(911, 8, 2, '2012-08-07 12:30:00', 1),
(912, 8, 2, '2012-08-07 14:30:00', 1),
(913, 8, 0, '2012-08-07 16:30:00', 1),
(914, 8, 3, '2012-08-07 17:00:00', 2),
(915, 8, 8, '2012-08-07 19:30:00', 1),
(916, 0, 10, '2012-08-08 09:00:00', 3),
(917, 0, 6, '2012-08-08 12:30:00', 3),
(918, 0, 5, '2012-08-08 14:00:00', 3),
(919, 0, 6, '2012-08-08 16:30:00', 3),
(920, 1, 0, '2012-08-08 08:30:00', 6),
(921, 1, 10, '2012-08-08 11:30:00', 3),
(922, 1, 10, '2012-08-08 14:00:00', 3),
(923, 1, 9, '2012-08-08 19:00:00', 3),
(924, 2, 5, '2012-08-08 08:00:00', 3),
(925, 2, 9, '2012-08-08 09:30:00', 3),
(926, 2, 7, '2012-08-08 11:00:00', 3),
(927, 2, 1, '2012-08-08 14:00:00', 3),
(928, 2, 5, '2012-08-08 17:30:00', 3),
(929, 2, 1, '2012-08-08 19:00:00', 3),
(930, 3, 10, '2012-08-08 08:00:00', 2),
(931, 3, 6, '2012-08-08 10:00:00', 2),
(932, 3, 0, '2012-08-08 12:00:00', 2),
(933, 3, 10, '2012-08-08 15:30:00', 2),
(934, 3, 2, '2012-08-08 19:00:00', 2),
(935, 4, 6, '2012-08-08 08:00:00', 2),
(936, 4, 8, '2012-08-08 11:00:00', 2),
(937, 4, 9, '2012-08-08 12:30:00', 4),
(938, 4, 0, '2012-08-08 15:00:00', 2),
(939, 4, 0, '2012-08-08 16:30:00', 2),
(940, 4, 3, '2012-08-08 17:30:00', 2),
(941, 5, 0, '2012-08-08 08:00:00', 2),
(942, 6, 0, '2012-08-08 09:00:00', 2),
(943, 6, 0, '2012-08-08 11:00:00', 2),
(944, 6, 8, '2012-08-08 12:30:00', 2),
(945, 6, 6, '2012-08-08 15:00:00', 2),
(946, 6, 10, '2012-08-08 17:30:00', 2),
(947, 6, 0, '2012-08-08 19:00:00', 2),
(948, 7, 8, '2012-08-08 08:00:00', 2),
(949, 7, 9, '2012-08-08 11:00:00', 2),
(950, 7, 7, '2012-08-08 12:30:00', 2),
(951, 7, 4, '2012-08-08 14:00:00', 2),
(952, 7, 9, '2012-08-08 15:30:00', 2),
(953, 7, 10, '2012-08-08 18:30:00', 2),
(954, 8, 4, '2012-08-08 08:00:00', 1),
(955, 8, 2, '2012-08-08 09:00:00', 1),
(956, 8, 3, '2012-08-08 10:00:00', 1),
(957, 8, 3, '2012-08-08 11:00:00', 1),
(958, 8, 3, '2012-08-08 12:00:00', 1),
(959, 8, 2, '2012-08-08 13:00:00', 1),
(960, 8, 7, '2012-08-08 16:00:00', 1),
(961, 8, 1, '2012-08-08 16:30:00', 1),
(962, 8, 3, '2012-08-08 17:00:00', 1),
(963, 8, 2, '2012-08-08 17:30:00', 1),
(964, 8, 1, '2012-08-08 18:30:00', 1),
(965, 0, 6, '2012-08-09 09:30:00', 3),
(966, 0, 7, '2012-08-09 16:00:00', 3),
(967, 0, 10, '2012-08-09 17:30:00', 3),
(968, 1, 10, '2012-08-09 08:00:00', 3),
(969, 1, 0, '2012-08-09 10:00:00', 3),
(970, 1, 8, '2012-08-09 14:00:00', 3),
(971, 1, 0, '2012-08-09 17:00:00', 3),
(972, 2, 2, '2012-08-09 09:00:00', 3),
(973, 2, 1, '2012-08-09 11:00:00', 3),
(974, 2, 9, '2012-08-09 13:00:00', 3),
(975, 2, 1, '2012-08-09 14:30:00', 3),
(976, 2, 1, '2012-08-09 16:30:00', 3),
(977, 3, 10, '2012-08-09 10:00:00', 2),
(978, 3, 7, '2012-08-09 13:30:00', 2),
(979, 3, 6, '2012-08-09 14:30:00', 2),
(980, 3, 2, '2012-08-09 18:00:00', 2),
(981, 4, 0, '2012-08-09 09:00:00', 4),
(982, 4, 0, '2012-08-09 12:00:00', 4),
(983, 4, 10, '2012-08-09 16:30:00', 2),
(984, 4, 9, '2012-08-09 17:30:00', 2),
(985, 4, 8, '2012-08-09 18:30:00', 2),
(986, 4, 10, '2012-08-09 19:30:00', 2),
(987, 6, 6, '2012-08-09 11:30:00', 2),
(988, 6, 6, '2012-08-09 18:30:00', 2),
(989, 7, 8, '2012-08-09 08:00:00', 2),
(990, 7, 8, '2012-08-09 10:30:00', 2),
(991, 7, 0, '2012-08-09 12:30:00', 2),
(992, 7, 6, '2012-08-09 16:00:00', 2),
(993, 7, 2, '2012-08-09 17:00:00', 2),
(994, 7, 4, '2012-08-09 18:30:00', 2),
(995, 8, 4, '2012-08-09 10:00:00', 1),
(996, 8, 2, '2012-08-09 11:30:00', 1),
(997, 8, 6, '2012-08-09 13:00:00', 1),
(998, 8, 3, '2012-08-09 15:00:00', 1),
(999, 8, 5, '2012-08-09 15:30:00', 1),
(1000, 8, 3, '2012-08-09 17:30:00', 1),
(1001, 0, 3, '2012-08-10 08:00:00', 3),
(1002, 0, 2, '2012-08-10 09:30:00', 3),
(1003, 0, 5, '2012-08-10 11:30:00', 3),
(1004, 0, 2, '2012-08-10 13:00:00', 3),
(1005, 0, 8, '2012-08-10 16:30:00', 3),
(1006, 1, 10, '2012-08-10 08:30:00', 6),
(1007, 1, 8, '2012-08-10 12:00:00', 3),
(1008, 1, 9, '2012-08-10 14:00:00', 3),
(1009, 1, 0, '2012-08-10 16:00:00', 3),
(1010, 1, 10, '2012-08-10 18:30:00', 3),
(1011, 2, 1, '2012-08-10 08:00:00', 3),
(1012, 2, 8, '2012-08-10 09:30:00', 3),
(1013, 2, 7, '2012-08-10 17:30:00', 3),
(1014, 2, 0, '2012-08-10 19:00:00', 3),
(1015, 3, 2, '2012-08-10 08:00:00', 2),
(1016, 3, 7, '2012-08-10 10:30:00', 2),
(1017, 3, 10, '2012-08-10 11:30:00', 2),
(1018, 3, 4, '2012-08-10 14:30:00', 2),
(1019, 3, 3, '2012-08-10 18:00:00', 4),
(1020, 4, 6, '2012-08-10 08:30:00', 2),
(1021, 4, 5, '2012-08-10 10:00:00', 2),
(1022, 4, 6, '2012-08-10 12:00:00', 2),
(1023, 4, 0, '2012-08-10 13:00:00', 2),
(1024, 4, 8, '2012-08-10 14:00:00', 2),
(1025, 4, 1, '2012-08-10 15:30:00', 2),
(1026, 4, 3, '2012-08-10 16:30:00', 2),
(1027, 4, 9, '2012-08-10 19:00:00', 2),
(1028, 5, 0, '2012-08-10 13:30:00', 2),
(1029, 6, 0, '2012-08-10 09:00:00', 2),
(1030, 6, 0, '2012-08-10 11:00:00', 2),
(1031, 6, 0, '2012-08-10 12:30:00', 2),
(1032, 6, 0, '2012-08-10 15:00:00', 2),
(1033, 6, 10, '2012-08-10 16:30:00', 2),
(1034, 6, 0, '2012-08-10 18:00:00', 2),
(1035, 7, 4, '2012-08-10 09:30:00', 2),
(1036, 7, 4, '2012-08-10 11:00:00', 2),
(1037, 7, 9, '2012-08-10 13:00:00', 2),
(1038, 7, 6, '2012-08-10 15:00:00', 2),
(1039, 7, 5, '2012-08-10 16:30:00', 4),
(1040, 7, 6, '2012-08-10 18:30:00', 2),
(1041, 7, 7, '2012-08-10 19:30:00', 2),
(1042, 8, 8, '2012-08-10 09:00:00', 1),
(1043, 8, 7, '2012-08-10 10:00:00', 1),
(1044, 8, 3, '2012-08-10 11:30:00', 1),
(1045, 8, 3, '2012-08-10 12:30:00', 1),
(1046, 8, 7, '2012-08-10 14:00:00', 1),
(1047, 8, 2, '2012-08-10 14:30:00', 1),
(1048, 8, 2, '2012-08-10 15:30:00', 2),
(1049, 8, 7, '2012-08-10 17:00:00', 1),
(1050, 8, 4, '2012-08-10 17:30:00', 1),
(1051, 8, 3, '2012-08-10 20:00:00', 1),
(1052, 0, 0, '2012-08-11 08:00:00', 3),
(1053, 0, 5, '2012-08-11 10:00:00', 3),
(1054, 0, 0, '2012-08-11 12:00:00', 3),
(1055, 0, 4, '2012-08-11 13:30:00', 3),
(1056, 0, 0, '2012-08-11 15:00:00', 3),
(1057, 0, 12, '2012-08-11 16:30:00', 3),
(1058, 0, 4, '2012-08-11 18:30:00', 3),
(1059, 1, 11, '2012-08-11 08:00:00', 3),
(1060, 1, 0, '2012-08-11 10:00:00', 3),
(1061, 1, 0, '2012-08-11 12:30:00', 3),
(1062, 1, 0, '2012-08-11 14:30:00', 3),
(1063, 1, 8, '2012-08-11 16:00:00', 3),
(1064, 1, 0, '2012-08-11 17:30:00', 3),
(1065, 2, 1, '2012-08-11 09:00:00', 3),
(1066, 2, 7, '2012-08-11 11:00:00', 3),
(1067, 2, 1, '2012-08-11 18:00:00', 3),
(1068, 3, 11, '2012-08-11 12:00:00', 2),
(1069, 3, 6, '2012-08-11 14:00:00', 2),
(1070, 3, 7, '2012-08-11 17:30:00', 2),
(1071, 3, 13, '2012-08-11 19:00:00', 2),
(1072, 4, 0, '2012-08-11 10:00:00', 2),
(1073, 4, 14, '2012-08-11 11:00:00', 2),
(1074, 4, 0, '2012-08-11 12:30:00', 2),
(1075, 4, 8, '2012-08-11 14:00:00', 2),
(1076, 4, 6, '2012-08-11 16:30:00', 2),
(1077, 4, 8, '2012-08-11 18:00:00', 2),
(1078, 4, 9, '2012-08-11 19:00:00', 2),
(1079, 5, 12, '2012-08-11 19:30:00', 2),
(1080, 6, 13, '2012-08-11 08:00:00', 2),
(1081, 6, 0, '2012-08-11 09:00:00', 2),
(1082, 6, 0, '2012-08-11 14:00:00', 2),
(1083, 6, 6, '2012-08-11 15:00:00', 2),
(1084, 6, 6, '2012-08-11 17:30:00', 4),
(1085, 7, 2, '2012-08-11 08:30:00', 2),
(1086, 7, 8, '2012-08-11 11:30:00', 2),
(1087, 7, 4, '2012-08-11 15:00:00', 2),
(1088, 7, 2, '2012-08-11 16:00:00', 2),
(1089, 7, 8, '2012-08-11 19:00:00', 2),
(1090, 8, 3, '2012-08-11 08:00:00', 2),
(1091, 8, 1, '2012-08-11 11:30:00', 1),
(1092, 8, 3, '2012-08-11 12:00:00', 1),
(1093, 8, 3, '2012-08-11 13:30:00', 3),
(1094, 8, 3, '2012-08-11 16:00:00', 1),
(1095, 8, 2, '2012-08-11 17:00:00', 1),
(1096, 8, 3, '2012-08-11 17:30:00', 1),
(1097, 8, 2, '2012-08-11 18:00:00', 1),
(1098, 8, 14, '2012-08-11 19:00:00', 1),
(1099, 0, 0, '2012-08-12 08:00:00', 3),
(1100, 0, 7, '2012-08-12 10:30:00', 3),
(1101, 0, 14, '2012-08-12 13:00:00', 3),
(1102, 0, 0, '2012-08-12 14:30:00', 3),
(1103, 0, 6, '2012-08-12 16:00:00', 3),
(1104, 0, 0, '2012-08-12 17:30:00', 6),
(1105, 1, 0, '2012-08-12 10:30:00', 3),
(1106, 1, 9, '2012-08-12 13:30:00', 3),
(1107, 1, 8, '2012-08-12 19:00:00', 3),
(1108, 2, 1, '2012-08-12 11:30:00', 3),
(1109, 2, 2, '2012-08-12 13:00:00', 3),
(1110, 2, 0, '2012-08-12 14:30:00', 3),
(1111, 3, 6, '2012-08-12 08:00:00', 2),
(1112, 3, 10, '2012-08-12 09:30:00', 4),
(1113, 3, 11, '2012-08-12 14:30:00', 2),
(1114, 3, 3, '2012-08-12 17:00:00', 2),
(1115, 3, 5, '2012-08-12 19:00:00', 2),
(1116, 4, 0, '2012-08-12 09:30:00', 2),
(1117, 4, 0, '2012-08-12 12:00:00', 2),
(1118, 4, 6, '2012-08-12 13:00:00', 2),
(1119, 4, 7, '2012-08-12 16:30:00', 2),
(1120, 4, 6, '2012-08-12 18:00:00', 2),
(1121, 5, 0, '2012-08-12 09:30:00', 2),
(1122, 5, 0, '2012-08-12 12:30:00', 2),
(1123, 6, 0, '2012-08-12 09:00:00', 4),
(1124, 6, 13, '2012-08-12 13:00:00', 2),
(1125, 6, 0, '2012-08-12 14:30:00', 2),
(1126, 6, 10, '2012-08-12 17:00:00', 2),
(1127, 7, 8, '2012-08-12 11:00:00', 2),
(1128, 7, 2, '2012-08-12 12:00:00', 2),
(1129, 7, 13, '2012-08-12 14:00:00', 2),
(1130, 7, 5, '2012-08-12 15:00:00', 2),
(1131, 8, 9, '2012-08-12 08:00:00', 1),
(1132, 8, 11, '2012-08-12 10:30:00', 1),
(1133, 8, 3, '2012-08-12 12:00:00', 1),
(1134, 8, 8, '2012-08-12 12:30:00', 1),
(1135, 8, 0, '2012-08-12 13:30:00', 1),
(1136, 8, 0, '2012-08-12 14:30:00', 1),
(1137, 8, 3, '2012-08-12 19:00:00', 1),
(1138, 0, 4, '2012-08-13 08:30:00', 3),
(1139, 0, 0, '2012-08-13 11:00:00', 3),
(1140, 0, 6, '2012-08-13 15:30:00', 3),
(1141, 0, 0, '2012-08-13 18:00:00', 3),
(1142, 1, 12, '2012-08-13 08:30:00', 3),
(1143, 1, 6, '2012-08-13 11:00:00', 3),
(1144, 1, 10, '2012-08-13 12:30:00', 6),
(1145, 1, 11, '2012-08-13 15:30:00', 3),
(1146, 1, 0, '2012-08-13 17:00:00', 3),
(1147, 1, 11, '2012-08-13 19:00:00', 3),
(1148, 2, 1, '2012-08-13 08:00:00', 3),
(1149, 2, 1, '2012-08-13 11:00:00', 3),
(1150, 2, 11, '2012-08-13 13:00:00', 3),
(1151, 2, 2, '2012-08-13 14:30:00', 3),
(1152, 2, 1, '2012-08-13 17:00:00', 3),
(1153, 2, 5, '2012-08-13 19:00:00', 3),
(1154, 3, 3, '2012-08-13 08:00:00', 2),
(1155, 3, 10, '2012-08-13 11:00:00', 2),
(1156, 3, 9, '2012-08-13 12:00:00', 2),
(1157, 3, 3, '2012-08-13 13:00:00', 2),
(1158, 3, 10, '2012-08-13 15:30:00', 2),
(1159, 3, 6, '2012-08-13 17:30:00', 2),
(1160, 4, 7, '2012-08-13 08:00:00', 2),
(1161, 4, 10, '2012-08-13 09:00:00', 2),
(1162, 4, 0, '2012-08-13 10:30:00', 4),
(1163, 4, 0, '2012-08-13 14:00:00', 2),
(1164, 4, 8, '2012-08-13 15:00:00', 2),
(1165, 4, 3, '2012-08-13 16:00:00', 2),
(1166, 4, 10, '2012-08-13 19:00:00', 2),
(1167, 6, 0, '2012-08-13 08:00:00', 2),
(1168, 6, 5, '2012-08-13 12:00:00', 2),
(1169, 6, 6, '2012-08-13 13:00:00', 2),
(1170, 6, 0, '2012-08-13 17:30:00', 6),
(1171, 7, 6, '2012-08-13 08:00:00', 2),
(1172, 7, 14, '2012-08-13 09:00:00', 2),
(1173, 7, 7, '2012-08-13 10:00:00', 2),
(1174, 7, 13, '2012-08-13 13:00:00', 2),
(1175, 7, 8, '2012-08-13 14:00:00', 2),
(1176, 7, 9, '2012-08-13 17:00:00', 2),
(1177, 7, 11, '2012-08-13 18:00:00', 2),
(1178, 7, 4, '2012-08-13 19:00:00', 2),
(1179, 8, 2, '2012-08-13 08:30:00', 1),
(1180, 8, 1, '2012-08-13 10:00:00', 1),
(1181, 8, 3, '2012-08-13 11:00:00', 1),
(1182, 8, 4, '2012-08-13 12:30:00', 1),
(1183, 8, 7, '2012-08-13 14:00:00', 1),
(1184, 8, 4, '2012-08-13 15:00:00', 1),
(1185, 8, 1, '2012-08-13 16:30:00', 1),
(1186, 8, 6, '2012-08-13 17:00:00', 1),
(1187, 8, 3, '2012-08-13 18:30:00', 2),
(1188, 8, 3, '2012-08-13 20:00:00', 1),
(1189, 0, 7, '2012-08-14 09:00:00', 3),
(1190, 0, 14, '2012-08-14 10:30:00', 3),
(1191, 0, 11, '2012-08-14 13:00:00', 3),
(1192, 0, 0, '2012-08-14 15:00:00', 6),
(1193, 0, 10, '2012-08-14 18:30:00', 3),
(1194, 1, 11, '2012-08-14 10:00:00', 3),
(1195, 1, 8, '2012-08-14 11:30:00', 3),
(1196, 1, 0, '2012-08-14 16:30:00', 3),
(1197, 1, 0, '2012-08-14 18:30:00', 3),
(1198, 2, 13, '2012-08-14 08:00:00', 3),
(1199, 2, 1, '2012-08-14 10:30:00', 3),
(1200, 2, 1, '2012-08-14 13:00:00', 3),
(1201, 2, 10, '2012-08-14 15:30:00', 3),
(1202, 2, 0, '2012-08-14 17:00:00', 3),
(1203, 2, 1, '2012-08-14 19:00:00', 3),
(1204, 3, 10, '2012-08-14 10:00:00', 2),
(1205, 3, 10, '2012-08-14 13:00:00', 2),
(1206, 3, 3, '2012-08-14 18:30:00', 4),
(1207, 4, 11, '2012-08-14 08:30:00', 2),
(1208, 4, 0, '2012-08-14 11:00:00', 2),
(1209, 4, 6, '2012-08-14 12:30:00', 2),
(1210, 4, 0, '2012-08-14 14:30:00', 2),
(1211, 4, 14, '2012-08-14 16:30:00', 2),
(1212, 4, 0, '2012-08-14 18:00:00', 2),
(1213, 4, 6, '2012-08-14 19:30:00', 2),
(1214, 5, 0, '2012-08-14 12:00:00', 2),
(1215, 5, 0, '2012-08-14 13:30:00', 2),
(1216, 6, 12, '2012-08-14 09:00:00', 2),
(1217, 6, 0, '2012-08-14 12:30:00', 4),
(1218, 6, 0, '2012-08-14 16:00:00', 4),
(1219, 7, 8, '2012-08-14 09:30:00', 4),
(1220, 7, 2, '2012-08-14 11:30:00', 2),
(1221, 8, 0, '2012-08-14 08:00:00', 1),
(1222, 8, 2, '2012-08-14 08:30:00', 1),
(1223, 8, 11, '2012-08-14 09:30:00', 1),
(1224, 8, 3, '2012-08-14 11:00:00', 1),
(1225, 8, 12, '2012-08-14 12:30:00', 1),
(1226, 8, 3, '2012-08-14 13:30:00', 1),
(1227, 8, 3, '2012-08-14 16:30:00', 2),
(1228, 8, 9, '2012-08-14 18:30:00', 1),
(1229, 8, 6, '2012-08-14 19:00:00', 1),
(1230, 8, 8, '2012-08-14 19:30:00', 1),
(1231, 8, 0, '2012-08-14 20:00:00', 1),
(1232, 0, 0, '2012-08-15 08:00:00', 3),
(1233, 0, 6, '2012-08-15 11:30:00', 3),
(1234, 0, 5, '2012-08-15 13:00:00', 3),
(1235, 0, 14, '2012-08-15 15:00:00', 3),
(1236, 0, 0, '2012-08-15 16:30:00', 3),
(1237, 0, 7, '2012-08-15 18:00:00', 3),
(1238, 1, 0, '2012-08-15 08:00:00', 3),
(1239, 1, 8, '2012-08-15 09:30:00', 3),
(1240, 1, 12, '2012-08-15 11:30:00', 3),
(1241, 1, 11, '2012-08-15 14:30:00', 3),
(1242, 1, 12, '2012-08-15 16:30:00', 3),
(1243, 1, 8, '2012-08-15 18:30:00', 3),
(1244, 2, 1, '2012-08-15 08:00:00', 3),
(1245, 2, 0, '2012-08-15 10:00:00', 3),
(1246, 2, 10, '2012-08-15 12:00:00', 3),
(1247, 2, 13, '2012-08-15 13:30:00', 3),
(1248, 2, 1, '2012-08-15 15:30:00', 3),
(1249, 2, 9, '2012-08-15 18:00:00', 3),
(1250, 3, 3, '2012-08-15 11:00:00', 2),
(1251, 3, 1, '2012-08-15 13:00:00', 2),
(1252, 3, 3, '2012-08-15 14:00:00', 2),
(1253, 3, 11, '2012-08-15 16:30:00', 2),
(1254, 3, 10, '2012-08-15 18:00:00', 2),
(1255, 3, 3, '2012-08-15 19:30:00', 2),
(1256, 4, 0, '2012-08-15 08:30:00', 4),
(1257, 4, 6, '2012-08-15 10:30:00', 2),
(1258, 4, 0, '2012-08-15 13:00:00', 2),
(1259, 4, 0, '2012-08-15 15:00:00', 2),
(1260, 4, 9, '2012-08-15 16:30:00', 2),
(1261, 4, 11, '2012-08-15 18:00:00', 2),
(1262, 5, 0, '2012-08-15 12:00:00', 2),
(1263, 5, 0, '2012-08-15 16:00:00', 2),
(1264, 5, 11, '2012-08-15 19:00:00', 2),
(1265, 6, 6, '2012-08-15 08:00:00', 2),
(1266, 6, 0, '2012-08-15 10:00:00', 2),
(1267, 6, 13, '2012-08-15 11:30:00', 2),
(1268, 6, 11, '2012-08-15 12:30:00', 2),
(1269, 6, 10, '2012-08-15 13:30:00', 2),
(1270, 6, 8, '2012-08-15 15:30:00', 2),
(1271, 6, 13, '2012-08-15 17:00:00', 2),
(1272, 6, 12, '2012-08-15 18:00:00', 2),
(1273, 7, 6, '2012-08-15 15:00:00', 2),
(1274, 7, 8, '2012-08-15 17:30:00', 2),
(1275, 8, 6, '2012-08-15 09:00:00', 1),
(1276, 8, 3, '2012-08-15 10:30:00', 1),
(1277, 8, 2, '2012-08-15 11:30:00', 1),
(1278, 8, 3, '2012-08-15 13:00:00', 1),
(1279, 8, 2, '2012-08-15 14:00:00', 2),
(1280, 8, 3, '2012-08-15 15:30:00', 1),
(1281, 8, 0, '2012-08-15 16:00:00', 1),
(1282, 8, 8, '2012-08-15 17:00:00', 1),
(1283, 8, 3, '2012-08-15 17:30:00', 1),
(1284, 8, 14, '2012-08-15 19:00:00', 1),
(1285, 8, 1, '2012-08-15 19:30:00', 1),
(1286, 8, 6, '2012-08-15 20:00:00', 1),
(1287, 0, 4, '2012-08-16 08:30:00', 3),
(1288, 0, 0, '2012-08-16 11:00:00', 3),
(1289, 0, 5, '2012-08-16 12:30:00', 3),
(1290, 0, 14, '2012-08-16 14:00:00', 3),
(1291, 0, 0, '2012-08-16 15:30:00', 3),
(1292, 0, 0, '2012-08-16 17:30:00', 3),
(1293, 1, 12, '2012-08-16 08:00:00', 3),
(1294, 1, 0, '2012-08-16 13:00:00', 3),
(1295, 1, 11, '2012-08-16 14:30:00', 3),
(1296, 1, 8, '2012-08-16 16:30:00', 3),
(1297, 1, 12, '2012-08-16 18:00:00', 3),
(1298, 2, 5, '2012-08-16 08:30:00', 3),
(1299, 2, 14, '2012-08-16 10:00:00', 3),
(1300, 2, 1, '2012-08-16 13:00:00', 3),
(1301, 2, 2, '2012-08-16 15:30:00', 3),
(1302, 2, 9, '2012-08-16 17:00:00', 3),
(1303, 2, 15, '2012-08-16 18:30:00', 3),
(1304, 3, 6, '2012-08-16 11:00:00', 2),
(1305, 3, 10, '2012-08-16 16:30:00', 2),
(1306, 3, 3, '2012-08-16 17:30:00', 2),
(1307, 4, 1, '2012-08-16 08:30:00', 2),
(1308, 4, 0, '2012-08-16 11:00:00', 2),
(1309, 4, 1, '2012-08-16 12:00:00', 2),
(1310, 4, 9, '2012-08-16 13:00:00', 2),
(1311, 4, 8, '2012-08-16 14:00:00', 2),
(1312, 4, 14, '2012-08-16 15:30:00', 2),
(1313, 4, 13, '2012-08-16 18:30:00', 2),
(1314, 4, 8, '2012-08-16 19:30:00', 2),
(1315, 5, 0, '2012-08-16 11:00:00', 2),
(1316, 6, 0, '2012-08-16 08:30:00', 2),
(1317, 6, 0, '2012-08-16 11:30:00', 6),
(1318, 6, 12, '2012-08-16 15:30:00', 2),
(1319, 6, 5, '2012-08-16 17:30:00', 2),
(1320, 6, 0, '2012-08-16 18:30:00', 2),
(1321, 7, 7, '2012-08-16 10:30:00', 2),
(1322, 7, 7, '2012-08-16 13:00:00', 2),
(1323, 7, 13, '2012-08-16 14:30:00', 4),
(1324, 7, 4, '2012-08-16 16:30:00', 2),
(1325, 7, 10, '2012-08-16 18:00:00', 2),
(1326, 8, 7, '2012-08-16 08:30:00', 1),
(1327, 8, 3, '2012-08-16 09:00:00', 2),
(1328, 8, 3, '2012-08-16 10:30:00', 1),
(1329, 8, 3, '2012-08-16 12:00:00', 1),
(1330, 8, 12, '2012-08-16 13:30:00', 1),
(1331, 8, 3, '2012-08-16 14:00:00', 1),
(1332, 8, 15, '2012-08-16 14:30:00', 1),
(1333, 8, 3, '2012-08-16 15:00:00', 2),
(1334, 8, 4, '2012-08-16 16:00:00', 1),
(1335, 8, 3, '2012-08-16 19:00:00', 1),
(1336, 8, 12, '2012-08-16 19:30:00', 1),
(1337, 0, 0, '2012-08-17 08:30:00', 3),
(1338, 0, 14, '2012-08-17 12:30:00', 3),
(1339, 0, 6, '2012-08-17 14:00:00', 3),
(1340, 0, 10, '2012-08-17 16:00:00', 3),
(1341, 0, 14, '2012-08-17 17:30:00', 3),
(1342, 1, 10, '2012-08-17 08:30:00', 3),
(1343, 1, 0, '2012-08-17 11:00:00', 6),
(1344, 1, 11, '2012-08-17 15:00:00', 3),
(1345, 1, 0, '2012-08-17 17:00:00', 3),
(1346, 1, 16, '2012-08-17 19:00:00', 3),
(1347, 2, 1, '2012-08-17 09:00:00', 3),
(1348, 2, 1, '2012-08-17 12:00:00', 3),
(1349, 2, 11, '2012-08-17 13:30:00', 3),
(1350, 2, 2, '2012-08-17 16:30:00', 3),
(1351, 2, 1, '2012-08-17 18:30:00', 3),
(1352, 3, 10, '2012-08-17 10:00:00', 2),
(1353, 3, 15, '2012-08-17 11:00:00', 2),
(1354, 3, 13, '2012-08-17 14:00:00', 2),
(1355, 3, 15, '2012-08-17 17:30:00', 2),
(1356, 4, 9, '2012-08-17 08:00:00', 2),
(1357, 4, 6, '2012-08-17 09:30:00', 2),
(1358, 4, 3, '2012-08-17 12:00:00', 2),
(1359, 4, 3, '2012-08-17 13:30:00', 2),
(1360, 4, 0, '2012-08-17 14:30:00', 2),
(1361, 4, 16, '2012-08-17 15:30:00', 2),
(1362, 4, 0, '2012-08-17 16:30:00', 4),
(1363, 4, 9, '2012-08-17 19:00:00', 2),
(1364, 5, 4, '2012-08-17 13:00:00', 2),
(1365, 5, 0, '2012-08-17 15:30:00', 2),
(1366, 6, 0, '2012-08-17 08:00:00', 2),
(1367, 6, 12, '2012-08-17 09:30:00', 2),
(1368, 6, 0, '2012-08-17 11:00:00', 2),
(1369, 6, 6, '2012-08-17 12:00:00', 2),
(1370, 6, 0, '2012-08-17 15:00:00', 2),
(1371, 6, 0, '2012-08-17 17:30:00', 2),
(1372, 6, 12, '2012-08-17 18:30:00', 2),
(1373, 6, 6, '2012-08-17 19:30:00', 2),
(1374, 7, 8, '2012-08-17 08:30:00', 2),
(1375, 7, 13, '2012-08-17 12:30:00', 2),
(1376, 7, 15, '2012-08-17 14:30:00', 2),
(1377, 7, 7, '2012-08-17 16:30:00', 2),
(1378, 8, 16, '2012-08-17 08:30:00', 1),
(1379, 8, 16, '2012-08-17 10:00:00', 1),
(1380, 8, 14, '2012-08-17 11:00:00', 1),
(1381, 8, 0, '2012-08-17 12:00:00', 1),
(1382, 8, 2, '2012-08-17 14:00:00', 1),
(1383, 8, 3, '2012-08-17 14:30:00', 1),
(1384, 8, 3, '2012-08-17 15:30:00', 1),
(1385, 8, 8, '2012-08-17 16:00:00', 1),
(1386, 8, 16, '2012-08-17 16:30:00', 1),
(1387, 8, 4, '2012-08-17 18:00:00', 1),
(1388, 8, 6, '2012-08-17 18:30:00', 1),
(1389, 8, 12, '2012-08-17 19:30:00', 1),
(1390, 0, 5, '2012-08-18 08:00:00', 3),
(1391, 0, 0, '2012-08-18 11:00:00', 3),
(1392, 0, 5, '2012-08-18 12:30:00', 3),
(1393, 0, 0, '2012-08-18 14:00:00', 3),
(1394, 1, 8, '2012-08-18 09:30:00', 3),
(1395, 1, 15, '2012-08-18 12:30:00', 3),
(1396, 1, 0, '2012-08-18 14:30:00', 3),
(1397, 1, 7, '2012-08-18 17:00:00', 3),
(1398, 1, 12, '2012-08-18 18:30:00', 3),
(1399, 2, 1, '2012-08-18 08:30:00', 3),
(1400, 2, 1, '2012-08-18 11:30:00', 3),
(1401, 2, 2, '2012-08-18 16:00:00', 3),
(1402, 2, 14, '2012-08-18 18:00:00', 3),
(1403, 3, 15, '2012-08-18 08:00:00', 2),
(1404, 3, 15, '2012-08-18 11:00:00', 2),
(1405, 3, 12, '2012-08-18 13:30:00', 2),
(1406, 3, 1, '2012-08-18 19:30:00', 2),
(1407, 4, 16, '2012-08-18 08:00:00', 2),
(1408, 4, 3, '2012-08-18 09:00:00', 2),
(1409, 4, 4, '2012-08-18 10:30:00', 2),
(1410, 4, 3, '2012-08-18 11:30:00', 2),
(1411, 4, 11, '2012-08-18 12:30:00', 2),
(1412, 4, 0, '2012-08-18 13:30:00', 2),
(1413, 4, 0, '2012-08-18 15:00:00', 4),
(1414, 4, 5, '2012-08-18 17:30:00', 2),
(1415, 4, 0, '2012-08-18 18:30:00', 4),
(1416, 5, 0, '2012-08-18 11:00:00', 4),
(1417, 6, 12, '2012-08-18 09:00:00', 2),
(1418, 6, 0, '2012-08-18 11:00:00', 2),
(1419, 6, 4, '2012-08-18 12:00:00', 2),
(1420, 6, 0, '2012-08-18 13:00:00', 2),
(1421, 6, 14, '2012-08-18 14:30:00', 2),
(1422, 6, 0, '2012-08-18 16:30:00', 4),
(1423, 6, 8, '2012-08-18 19:30:00', 2),
(1424, 7, 8, '2012-08-18 12:00:00', 2),
(1425, 7, 8, '2012-08-18 13:30:00', 2),
(1426, 7, 15, '2012-08-18 15:00:00', 2),
(1427, 7, 15, '2012-08-18 16:30:00', 2),
(1428, 7, 1, '2012-08-18 18:30:00', 2),
(1429, 8, 3, '2012-08-18 08:00:00', 1),
(1430, 8, 6, '2012-08-18 08:30:00', 1),
(1431, 8, 16, '2012-08-18 09:30:00', 1),
(1432, 8, 16, '2012-08-18 11:30:00', 2),
(1433, 8, 2, '2012-08-18 12:30:00', 1),
(1434, 8, 16, '2012-08-18 13:00:00', 1),
(1435, 8, 11, '2012-08-18 13:30:00', 1),
(1436, 8, 16, '2012-08-18 14:00:00', 2),
(1437, 8, 0, '2012-08-18 16:00:00', 1),
(1438, 8, 3, '2012-08-18 16:30:00', 1),
(1439, 0, 12, '2012-08-19 08:00:00', 3),
(1440, 0, 16, '2012-08-19 10:30:00', 3),
(1441, 0, 6, '2012-08-19 13:30:00', 3),
(1442, 0, 6, '2012-08-19 17:30:00', 3),
(1443, 1, 10, '2012-08-19 08:00:00', 3),
(1444, 1, 7, '2012-08-19 11:00:00', 3),
(1445, 1, 10, '2012-08-19 12:30:00', 3),
(1446, 1, 0, '2012-08-19 15:30:00', 3),
(1447, 2, 1, '2012-08-19 09:00:00', 3),
(1448, 2, 5, '2012-08-19 12:30:00', 3),
(1449, 2, 14, '2012-08-19 16:30:00', 3),
(1450, 2, 2, '2012-08-19 18:00:00', 3),
(1451, 3, 16, '2012-08-19 08:00:00', 2),
(1452, 3, 10, '2012-08-19 09:30:00', 2),
(1453, 3, 15, '2012-08-19 11:00:00', 4),
(1454, 3, 14, '2012-08-19 15:00:00', 2),
(1455, 3, 3, '2012-08-19 18:30:00', 2),
(1456, 4, 0, '2012-08-19 09:30:00', 6),
(1457, 4, 5, '2012-08-19 14:00:00', 2),
(1458, 4, 1, '2012-08-19 15:30:00', 2),
(1459, 4, 5, '2012-08-19 16:30:00', 2),
(1460, 4, 16, '2012-08-19 17:30:00', 2),
(1461, 4, 1, '2012-08-19 19:00:00', 2),
(1462, 5, 0, '2012-08-19 17:30:00', 2),
(1463, 5, 0, '2012-08-19 19:00:00', 2),
(1464, 6, 0, '2012-08-19 09:00:00', 2),
(1465, 6, 12, '2012-08-19 10:00:00', 2),
(1466, 6, 0, '2012-08-19 12:00:00', 2),
(1467, 6, 11, '2012-08-19 13:30:00', 2),
(1468, 6, 16, '2012-08-19 14:30:00', 2),
(1469, 6, 0, '2012-08-19 16:30:00', 2),
(1470, 6, 0, '2012-08-19 18:30:00', 4),
(1471, 7, 6, '2012-08-19 08:00:00', 2),
(1472, 7, 5, '2012-08-19 11:00:00', 2),
(1473, 7, 13, '2012-08-19 13:30:00', 2),
(1474, 7, 15, '2012-08-19 17:00:00', 2),
(1475, 7, 4, '2012-08-19 18:30:00', 2),
(1476, 8, 0, '2012-08-19 10:00:00', 1),
(1477, 8, 3, '2012-08-19 11:00:00', 1),
(1478, 8, 4, '2012-08-19 12:30:00', 1),
(1479, 8, 6, '2012-08-19 13:00:00', 1),
(1480, 8, 1, '2012-08-19 15:00:00', 1),
(1481, 8, 16, '2012-08-19 15:30:00', 1),
(1482, 8, 2, '2012-08-19 17:00:00', 1),
(1483, 8, 8, '2012-08-19 17:30:00', 1),
(1484, 8, 12, '2012-08-19 19:00:00', 1),
(1485, 0, 10, '2012-08-20 08:30:00', 3),
(1486, 0, 10, '2012-08-20 10:30:00', 3),
(1487, 0, 14, '2012-08-20 12:00:00', 3),
(1488, 0, 4, '2012-08-20 14:30:00', 3),
(1489, 0, 14, '2012-08-20 16:30:00', 3),
(1490, 0, 16, '2012-08-20 19:00:00', 3),
(1491, 1, 9, '2012-08-20 08:00:00', 3),
(1492, 1, 16, '2012-08-20 09:30:00', 3),
(1493, 1, 0, '2012-08-20 12:00:00', 3),
(1494, 1, 10, '2012-08-20 13:30:00', 6),
(1495, 1, 6, '2012-08-20 16:30:00', 3),
(1496, 1, 8, '2012-08-20 18:30:00', 3),
(1497, 2, 8, '2012-08-20 08:30:00', 3),
(1498, 2, 5, '2012-08-20 10:00:00', 6),
(1499, 2, 1, '2012-08-20 13:00:00', 3),
(1500, 2, 1, '2012-08-20 15:00:00', 6),
(1501, 2, 14, '2012-08-20 19:00:00', 3),
(1502, 3, 1, '2012-08-20 08:00:00', 2),
(1503, 3, 4, '2012-08-20 11:00:00', 2),
(1504, 3, 8, '2012-08-20 12:30:00', 2),
(1505, 3, 11, '2012-08-20 15:30:00', 2),
(1506, 3, 3, '2012-08-20 17:30:00', 2),
(1507, 4, 6, '2012-08-20 08:30:00', 2),
(1508, 4, 3, '2012-08-20 09:30:00', 2),
(1509, 4, 6, '2012-08-20 10:30:00', 2),
(1510, 4, 13, '2012-08-20 11:30:00', 2),
(1511, 4, 16, '2012-08-20 12:30:00', 2),
(1512, 4, 5, '2012-08-20 13:30:00', 2),
(1513, 4, 0, '2012-08-20 14:30:00', 2),
(1514, 4, 16, '2012-08-20 16:00:00', 2),
(1515, 4, 16, '2012-08-20 17:30:00', 2),
(1516, 4, 0, '2012-08-20 18:30:00', 2),
(1517, 6, 16, '2012-08-20 08:00:00', 2),
(1518, 6, 13, '2012-08-20 09:00:00', 2),
(1519, 6, 0, '2012-08-20 10:30:00', 2),
(1520, 6, 6, '2012-08-20 11:30:00', 2),
(1521, 6, 11, '2012-08-20 12:30:00', 2),
(1522, 6, 0, '2012-08-20 14:30:00', 2),
(1523, 6, 8, '2012-08-20 16:30:00', 2),
(1524, 6, 6, '2012-08-20 19:00:00', 2),
(1525, 7, 5, '2012-08-20 08:00:00', 2),
(1526, 7, 1, '2012-08-20 11:30:00', 2),
(1527, 7, 17, '2012-08-20 12:30:00', 2),
(1528, 7, 6, '2012-08-20 14:30:00', 2),
(1529, 7, 9, '2012-08-20 16:00:00', 2),
(1530, 7, 17, '2012-08-20 17:30:00', 2),
(1531, 8, 15, '2012-08-20 10:30:00', 1),
(1532, 8, 3, '2012-08-20 11:30:00', 1),
(1533, 8, 0, '2012-08-20 13:30:00', 1),
(1534, 8, 2, '2012-08-20 14:00:00', 1),
(1535, 8, 3, '2012-08-20 17:00:00', 1),
(1536, 8, 2, '2012-08-20 18:00:00', 1),
(1537, 0, 14, '2012-08-21 09:00:00', 6),
(1538, 0, 0, '2012-08-21 13:00:00', 3),
(1539, 0, 0, '2012-08-21 18:00:00', 3),
(1540, 1, 11, '2012-08-21 09:30:00', 3),
(1541, 1, 9, '2012-08-21 11:00:00', 3),
(1542, 1, 10, '2012-08-21 12:30:00', 3),
(1543, 1, 7, '2012-08-21 14:00:00', 3),
(1544, 1, 10, '2012-08-21 16:30:00', 3),
(1545, 2, 15, '2012-08-21 08:00:00', 3),
(1546, 2, 1, '2012-08-21 09:30:00', 3),
(1547, 2, 17, '2012-08-21 11:00:00', 3),
(1548, 2, 2, '2012-08-21 12:30:00', 3),
(1549, 2, 1, '2012-08-21 15:30:00', 3),
(1550, 2, 15, '2012-08-21 17:00:00', 3),
(1551, 3, 8, '2012-08-21 10:30:00', 2),
(1552, 3, 16, '2012-08-21 12:00:00', 2),
(1553, 3, 2, '2012-08-21 16:00:00', 2),
(1554, 3, 1, '2012-08-21 18:30:00', 2),
(1555, 4, 0, '2012-08-21 08:30:00', 2),
(1556, 4, 7, '2012-08-21 10:00:00', 2),
(1557, 4, 13, '2012-08-21 11:00:00', 2),
(1558, 4, 14, '2012-08-21 12:00:00', 2),
(1559, 4, 0, '2012-08-21 13:00:00', 2),
(1560, 4, 16, '2012-08-21 14:30:00', 2),
(1561, 4, 0, '2012-08-21 16:30:00', 2),
(1562, 4, 0, '2012-08-21 18:00:00', 2),
(1563, 5, 0, '2012-08-21 08:00:00', 2),
(1564, 5, 0, '2012-08-21 18:30:00', 2),
(1565, 6, 0, '2012-08-21 09:00:00', 2),
(1566, 6, 0, '2012-08-21 10:30:00', 4),
(1567, 6, 0, '2012-08-21 14:00:00', 2),
(1568, 6, 0, '2012-08-21 15:30:00', 2),
(1569, 6, 0, '2012-08-21 17:00:00', 2),
(1570, 6, 0, '2012-08-21 19:00:00', 2),
(1571, 7, 10, '2012-08-21 09:30:00', 2),
(1572, 7, 13, '2012-08-21 13:00:00', 2),
(1573, 7, 5, '2012-08-21 15:30:00', 2),
(1574, 7, 5, '2012-08-21 17:30:00', 2),
(1575, 8, 11, '2012-08-21 08:00:00', 1),
(1576, 8, 6, '2012-08-21 09:00:00', 1),
(1577, 8, 3, '2012-08-21 09:30:00', 1),
(1578, 8, 16, '2012-08-21 10:00:00', 1),
(1579, 8, 6, '2012-08-21 10:30:00', 1),
(1580, 8, 3, '2012-08-21 11:00:00', 1),
(1581, 8, 3, '2012-08-21 12:00:00', 1),
(1582, 8, 3, '2012-08-21 13:00:00', 1),
(1583, 8, 6, '2012-08-21 13:30:00', 1),
(1584, 8, 16, '2012-08-21 16:00:00', 2),
(1585, 8, 1, '2012-08-21 19:30:00', 1),
(1586, 0, 11, '2012-08-22 08:00:00', 3),
(1587, 0, 5, '2012-08-22 10:00:00', 3),
(1588, 0, 0, '2012-08-22 11:30:00', 6),
(1589, 0, 16, '2012-08-22 15:00:00', 6),
(1590, 0, 11, '2012-08-22 18:00:00', 3),
(1591, 1, 0, '2012-08-22 08:30:00', 3),
(1592, 1, 0, '2012-08-22 10:30:00', 3),
(1593, 1, 0, '2012-08-22 13:00:00', 3),
(1594, 1, 7, '2012-08-22 15:00:00', 3),
(1595, 1, 12, '2012-08-22 17:00:00', 3),
(1596, 2, 10, '2012-08-22 09:00:00', 3),
(1597, 2, 0, '2012-08-22 10:30:00', 3),
(1598, 2, 1, '2012-08-22 12:30:00', 3),
(1599, 2, 11, '2012-08-22 15:00:00', 3),
(1600, 2, 0, '2012-08-22 16:30:00', 6),
(1601, 3, 11, '2012-08-22 10:00:00', 2),
(1602, 3, 3, '2012-08-22 11:30:00', 2),
(1603, 3, 13, '2012-08-22 13:00:00', 2),
(1604, 3, 1, '2012-08-22 14:30:00', 2),
(1605, 3, 17, '2012-08-22 15:30:00', 2),
(1606, 3, 15, '2012-08-22 16:30:00', 2),
(1607, 3, 10, '2012-08-22 18:30:00', 2),
(1608, 3, 15, '2012-08-22 19:30:00', 2),
(1609, 4, 5, '2012-08-22 08:00:00', 2),
(1610, 4, 9, '2012-08-22 09:00:00', 2),
(1611, 4, 14, '2012-08-22 10:00:00', 2),
(1612, 4, 0, '2012-08-22 11:00:00', 2),
(1613, 4, 9, '2012-08-22 12:00:00', 2),
(1614, 4, 0, '2012-08-22 14:00:00', 2),
(1615, 4, 13, '2012-08-22 15:00:00', 2),
(1616, 4, 3, '2012-08-22 16:00:00', 2),
(1617, 4, 6, '2012-08-22 17:00:00', 2),
(1618, 4, 0, '2012-08-22 18:00:00', 4),
(1619, 5, 0, '2012-08-22 18:00:00', 2),
(1620, 6, 8, '2012-08-22 08:30:00', 2),
(1621, 6, 0, '2012-08-22 09:30:00', 2),
(1622, 6, 12, '2012-08-22 11:00:00', 2),
(1623, 6, 0, '2012-08-22 12:00:00', 4),
(1624, 6, 6, '2012-08-22 14:00:00', 2),
(1625, 6, 12, '2012-08-22 15:30:00', 2),
(1626, 6, 0, '2012-08-22 18:00:00', 4),
(1627, 7, 6, '2012-08-22 09:30:00', 2),
(1628, 7, 4, '2012-08-22 11:30:00', 2),
(1629, 7, 8, '2012-08-22 15:00:00', 2),
(1630, 7, 1, '2012-08-22 16:00:00', 2),
(1631, 7, 13, '2012-08-22 17:30:00', 2),
(1632, 8, 8, '2012-08-22 08:00:00', 1),
(1633, 8, 7, '2012-08-22 11:30:00', 1),
(1634, 8, 8, '2012-08-22 12:00:00', 1),
(1635, 8, 6, '2012-08-22 12:30:00', 1),
(1636, 8, 3, '2012-08-22 15:00:00', 1),
(1637, 8, 2, '2012-08-22 15:30:00', 1),
(1638, 8, 15, '2012-08-22 16:00:00', 1),
(1639, 8, 2, '2012-08-22 17:00:00', 1),
(1640, 8, 3, '2012-08-22 19:00:00', 1),
(1641, 8, 4, '2012-08-22 19:30:00', 1),
(1642, 8, 9, '2012-08-22 20:00:00', 1),
(1643, 0, 11, '2012-08-23 08:30:00', 3),
(1644, 0, 14, '2012-08-23 11:30:00', 3),
(1645, 0, 10, '2012-08-23 13:00:00', 3),
(1646, 0, 5, '2012-08-23 15:30:00', 3),
(1647, 0, 12, '2012-08-23 17:00:00', 3),
(1648, 1, 12, '2012-08-23 09:00:00', 3),
(1649, 1, 11, '2012-08-23 10:30:00', 3),
(1650, 1, 0, '2012-08-23 13:00:00', 3),
(1651, 1, 16, '2012-08-23 14:30:00', 3),
(1652, 1, 10, '2012-08-23 16:00:00', 3),
(1653, 1, 9, '2012-08-23 17:30:00', 3),
(1654, 1, 15, '2012-08-23 19:00:00', 3),
(1655, 2, 14, '2012-08-23 09:30:00', 3),
(1656, 2, 1, '2012-08-23 11:00:00', 3),
(1657, 2, 9, '2012-08-23 13:30:00', 3),
(1658, 2, 8, '2012-08-23 15:30:00', 3),
(1659, 3, 15, '2012-08-23 09:30:00', 2),
(1660, 3, 3, '2012-08-23 10:30:00', 2),
(1661, 3, 4, '2012-08-23 14:00:00', 2),
(1662, 3, 1, '2012-08-23 15:00:00', 2),
(1663, 3, 17, '2012-08-23 16:00:00', 2),
(1664, 3, 3, '2012-08-23 17:00:00', 2),
(1665, 3, 16, '2012-08-23 19:00:00', 2),
(1666, 4, 0, '2012-08-23 08:30:00', 4),
(1667, 4, 0, '2012-08-23 11:00:00', 2),
(1668, 4, 11, '2012-08-23 12:00:00', 2),
(1669, 4, 1, '2012-08-23 13:00:00', 2),
(1670, 4, 5, '2012-08-23 14:30:00', 2),
(1671, 4, 14, '2012-08-23 15:30:00', 2),
(1672, 4, 2, '2012-08-23 16:30:00', 2),
(1673, 4, 8, '2012-08-23 17:30:00', 2),
(1674, 4, 3, '2012-08-23 18:30:00', 2),
(1675, 5, 0, '2012-08-23 12:00:00', 2),
(1676, 5, 0, '2012-08-23 16:30:00', 2),
(1677, 6, 1, '2012-08-23 08:00:00', 2),
(1678, 6, 0, '2012-08-23 09:00:00', 4),
(1679, 6, 13, '2012-08-23 13:00:00', 2),
(1680, 6, 12, '2012-08-23 14:00:00', 4),
(1681, 6, 17, '2012-08-23 18:00:00', 2),
(1682, 7, 4, '2012-08-23 11:00:00', 2),
(1683, 7, 8, '2012-08-23 14:00:00', 2),
(1684, 7, 13, '2012-08-23 16:00:00', 2),
(1685, 7, 11, '2012-08-23 17:00:00', 2),
(1686, 7, 10, '2012-08-23 18:30:00', 2),
(1687, 7, 6, '2012-08-23 19:30:00', 2),
(1688, 8, 17, '2012-08-23 09:00:00', 1),
(1689, 8, 16, '2012-08-23 09:30:00', 1),
(1690, 8, 6, '2012-08-23 10:00:00', 1),
(1691, 8, 4, '2012-08-23 10:30:00', 1),
(1692, 8, 3, '2012-08-23 13:00:00', 1),
(1693, 8, 3, '2012-08-23 14:30:00', 2),
(1694, 8, 9, '2012-08-23 15:30:00', 1),
(1695, 8, 1, '2012-08-23 16:00:00', 1),
(1696, 8, 16, '2012-08-23 17:30:00', 1),
(1697, 8, 16, '2012-08-23 18:30:00', 1),
(1698, 8, 17, '2012-08-23 19:00:00', 1),
(1699, 8, 16, '2012-08-23 20:00:00', 1),
(1700, 0, 14, '2012-08-24 09:00:00', 3),
(1701, 0, 2, '2012-08-24 11:00:00', 3),
(1702, 0, 0, '2012-08-24 12:30:00', 6),
(1703, 0, 6, '2012-08-24 15:30:00', 3),
(1704, 0, 16, '2012-08-24 17:00:00', 3),
(1705, 0, 8, '2012-08-24 19:00:00', 3),
(1706, 1, 12, '2012-08-24 08:00:00', 3),
(1707, 1, 9, '2012-08-24 09:30:00', 3),
(1708, 1, 0, '2012-08-24 11:30:00', 3),
(1709, 1, 8, '2012-08-24 13:00:00', 3),
(1710, 1, 10, '2012-08-24 15:30:00', 3),
(1711, 1, 12, '2012-08-24 18:00:00', 3),
(1712, 2, 13, '2012-08-24 08:00:00', 3),
(1713, 2, 0, '2012-08-24 11:00:00', 3),
(1714, 2, 15, '2012-08-24 13:00:00', 3),
(1715, 2, 16, '2012-08-24 15:00:00', 3),
(1716, 2, 12, '2012-08-24 16:30:00', 3),
(1717, 3, 1, '2012-08-24 08:30:00', 2),
(1718, 3, 3, '2012-08-24 11:00:00', 2),
(1719, 3, 17, '2012-08-24 14:00:00', 2),
(1720, 3, 8, '2012-08-24 16:30:00', 2),
(1721, 3, 15, '2012-08-24 17:30:00', 2),
(1722, 3, 10, '2012-08-24 18:30:00', 2),
(1723, 4, 0, '2012-08-24 08:00:00', 2),
(1724, 4, 3, '2012-08-24 10:00:00', 2),
(1725, 4, 9, '2012-08-24 12:00:00', 2),
(1726, 4, 14, '2012-08-24 13:00:00', 2),
(1727, 4, 3, '2012-08-24 14:00:00', 2),
(1728, 4, 0, '2012-08-24 17:00:00', 2),
(1729, 4, 3, '2012-08-24 18:00:00', 2),
(1730, 4, 0, '2012-08-24 19:00:00', 2),
(1731, 5, 0, '2012-08-24 18:30:00', 2),
(1732, 6, 6, '2012-08-24 09:30:00', 2),
(1733, 6, 0, '2012-08-24 11:00:00', 2),
(1734, 6, 14, '2012-08-24 12:00:00', 2),
(1735, 6, 0, '2012-08-24 14:30:00', 2),
(1736, 6, 11, '2012-08-24 17:00:00', 2),
(1737, 6, 14, '2012-08-24 18:30:00', 2),
(1738, 6, 0, '2012-08-24 19:30:00', 2),
(1739, 7, 15, '2012-08-24 09:30:00', 2),
(1740, 7, 17, '2012-08-24 13:00:00', 2),
(1741, 7, 13, '2012-08-24 14:00:00', 2),
(1742, 7, 4, '2012-08-24 17:00:00', 2),
(1743, 7, 2, '2012-08-24 18:30:00', 2),
(1744, 8, 3, '2012-08-24 08:30:00', 1),
(1745, 8, 16, '2012-08-24 11:00:00', 1),
(1746, 8, 16, '2012-08-24 13:30:00', 1),
(1747, 8, 14, '2012-08-24 14:00:00', 1),
(1748, 8, 14, '2012-08-24 17:30:00', 1),
(1749, 0, 8, '2012-08-25 08:00:00', 3),
(1750, 0, 7, '2012-08-25 11:00:00', 3),
(1751, 0, 0, '2012-08-25 12:30:00', 3),
(1752, 0, 5, '2012-08-25 14:00:00', 3),
(1753, 0, 0, '2012-08-25 15:30:00', 3),
(1754, 0, 17, '2012-08-25 17:00:00', 3),
(1755, 1, 9, '2012-08-25 08:00:00', 3),
(1756, 1, 11, '2012-08-25 11:30:00', 3),
(1757, 1, 0, '2012-08-25 13:30:00', 9),
(1758, 1, 15, '2012-08-25 18:30:00', 3),
(1759, 2, 2, '2012-08-25 08:00:00', 3),
(1760, 2, 1, '2012-08-25 09:30:00', 3),
(1761, 2, 14, '2012-08-25 11:00:00', 3),
(1762, 2, 1, '2012-08-25 12:30:00', 3),
(1763, 2, 1, '2012-08-25 16:30:00', 3),
(1764, 3, 16, '2012-08-25 08:00:00', 2),
(1765, 3, 16, '2012-08-25 09:30:00', 2),
(1766, 3, 0, '2012-08-25 12:00:00', 2),
(1767, 3, 15, '2012-08-25 14:30:00', 2),
(1768, 3, 11, '2012-08-25 18:30:00', 2),
(1769, 3, 3, '2012-08-25 19:30:00', 2),
(1770, 4, 14, '2012-08-25 08:00:00', 2),
(1771, 4, 0, '2012-08-25 09:30:00', 2),
(1772, 4, 6, '2012-08-25 10:30:00', 2),
(1773, 4, 10, '2012-08-25 11:30:00', 2),
(1774, 4, 3, '2012-08-25 12:30:00', 2),
(1775, 4, 11, '2012-08-25 14:00:00', 2),
(1776, 4, 13, '2012-08-25 15:30:00', 4),
(1777, 4, 3, '2012-08-25 17:30:00', 2),
(1778, 5, 11, '2012-08-25 08:00:00', 2),
(1779, 5, 0, '2012-08-25 14:30:00', 2),
(1780, 6, 0, '2012-08-25 08:30:00', 4),
(1781, 6, 0, '2012-08-25 11:00:00', 2),
(1782, 6, 12, '2012-08-25 14:00:00', 2),
(1783, 6, 0, '2012-08-25 18:30:00', 2),
(1784, 6, 6, '2012-08-25 19:30:00', 2),
(1785, 7, 15, '2012-08-25 08:30:00', 2),
(1786, 7, 2, '2012-08-25 09:30:00', 2),
(1787, 7, 4, '2012-08-25 11:00:00', 2),
(1788, 7, 13, '2012-08-25 14:00:00', 2),
(1789, 7, 8, '2012-08-25 15:00:00', 2),
(1790, 7, 0, '2012-08-25 19:00:00', 2),
(1791, 8, 15, '2012-08-25 08:00:00', 1),
(1792, 8, 3, '2012-08-25 09:30:00', 3),
(1793, 8, 16, '2012-08-25 11:00:00', 1),
(1794, 8, 2, '2012-08-25 12:00:00', 1),
(1795, 8, 16, '2012-08-25 12:30:00', 2),
(1796, 8, 3, '2012-08-25 13:30:00', 1),
(1797, 8, 16, '2012-08-25 14:30:00', 1),
(1798, 8, 6, '2012-08-25 15:00:00', 1),
(1799, 8, 3, '2012-08-25 15:30:00', 3),
(1800, 8, 2, '2012-08-25 17:30:00', 1),
(1801, 8, 16, '2012-08-25 19:00:00', 1),
(1802, 0, 11, '2012-08-26 08:30:00', 3),
(1803, 0, 6, '2012-08-26 10:30:00', 3),
(1804, 0, 11, '2012-08-26 12:00:00', 3),
(1805, 0, 0, '2012-08-26 15:00:00', 3),
(1806, 0, 6, '2012-08-26 17:00:00', 3),
(1807, 0, 5, '2012-08-26 19:00:00', 3),
(1808, 1, 12, '2012-08-26 08:30:00', 3),
(1809, 1, 11, '2012-08-26 10:30:00', 3),
(1810, 1, 0, '2012-08-26 13:00:00', 6),
(1811, 1, 13, '2012-08-26 16:00:00', 3),
(1812, 1, 0, '2012-08-26 17:30:00', 3),
(1813, 2, 1, '2012-08-26 08:30:00', 3),
(1814, 2, 16, '2012-08-26 10:00:00', 3),
(1815, 2, 1, '2012-08-26 11:30:00', 3),
(1816, 2, 1, '2012-08-26 15:30:00', 3),
(1817, 2, 0, '2012-08-26 17:30:00', 3),
(1818, 3, 3, '2012-08-26 08:00:00', 2),
(1819, 3, 13, '2012-08-26 13:00:00', 2),
(1820, 3, 10, '2012-08-26 16:00:00', 2),
(1821, 3, 0, '2012-08-26 18:00:00', 2),
(1822, 3, 6, '2012-08-26 19:30:00', 2),
(1823, 4, 0, '2012-08-26 08:00:00', 4),
(1824, 4, 14, '2012-08-26 10:00:00', 2),
(1825, 4, 0, '2012-08-26 11:30:00', 2),
(1826, 4, 10, '2012-08-26 13:00:00', 2),
(1827, 4, 0, '2012-08-26 15:30:00', 2),
(1828, 4, 3, '2012-08-26 18:30:00', 2),
(1829, 5, 0, '2012-08-26 08:00:00', 2),
(1830, 6, 0, '2012-08-26 08:00:00', 2),
(1831, 6, 0, '2012-08-26 11:00:00', 2),
(1832, 6, 12, '2012-08-26 12:00:00', 2),
(1833, 6, 0, '2012-08-26 15:00:00', 2),
(1834, 6, 12, '2012-08-26 16:00:00', 2),
(1835, 6, 0, '2012-08-26 18:30:00', 4),
(1836, 7, 4, '2012-08-26 08:00:00', 2),
(1837, 7, 17, '2012-08-26 10:00:00', 2),
(1838, 7, 8, '2012-08-26 11:30:00', 2),
(1839, 7, 4, '2012-08-26 13:30:00', 2),
(1840, 7, 7, '2012-08-26 16:30:00', 2),
(1841, 7, 7, '2012-08-26 18:00:00', 2),
(1842, 7, 0, '2012-08-26 19:00:00', 2),
(1843, 8, 15, '2012-08-26 08:00:00', 1),
(1844, 8, 3, '2012-08-26 09:30:00', 1),
(1845, 8, 3, '2012-08-26 10:30:00', 2),
(1846, 8, 16, '2012-08-26 11:30:00', 1),
(1847, 8, 3, '2012-08-26 12:00:00', 1),
(1848, 8, 15, '2012-08-26 12:30:00', 1),
(1849, 8, 3, '2012-08-26 14:00:00', 1),
(1850, 8, 16, '2012-08-26 14:30:00', 1),
(1851, 8, 3, '2012-08-26 15:30:00', 1),
(1852, 8, 0, '2012-08-26 16:00:00', 1),
(1853, 8, 0, '2012-08-26 17:00:00', 1),
(1854, 8, 3, '2012-08-26 18:00:00', 1),
(1855, 8, 8, '2012-08-26 20:00:00', 1),
(1856, 0, 0, '2012-08-27 09:00:00', 3),
(1857, 0, 5, '2012-08-27 10:30:00', 3),
(1858, 0, 17, '2012-08-27 13:00:00', 3),
(1859, 0, 7, '2012-08-27 15:30:00', 3),
(1860, 0, 0, '2012-08-27 17:30:00', 6),
(1861, 1, 12, '2012-08-27 08:30:00', 3),
(1862, 1, 0, '2012-08-27 11:00:00', 3),
(1863, 1, 9, '2012-08-27 12:30:00', 3),
(1864, 1, 8, '2012-08-27 14:30:00', 3),
(1865, 1, 9, '2012-08-27 16:30:00', 3),
(1866, 1, 10, '2012-08-27 18:30:00', 3),
(1867, 2, 0, '2012-08-27 08:00:00', 3),
(1868, 2, 0, '2012-08-27 11:00:00', 3),
(1869, 2, 2, '2012-08-27 14:30:00', 3),
(1870, 2, 2, '2012-08-27 16:30:00', 3),
(1871, 3, 15, '2012-08-27 09:30:00', 2),
(1872, 3, 0, '2012-08-27 11:30:00', 2),
(1873, 3, 11, '2012-08-27 14:00:00', 2),
(1874, 3, 16, '2012-08-27 17:00:00', 2),
(1875, 3, 16, '2012-08-27 19:30:00', 2),
(1876, 4, 9, '2012-08-27 08:30:00', 2),
(1877, 4, 5, '2012-08-27 09:30:00', 2),
(1878, 4, 3, '2012-08-27 10:30:00', 2),
(1879, 4, 0, '2012-08-27 12:00:00', 2),
(1880, 4, 8, '2012-08-27 13:30:00', 2),
(1881, 4, 13, '2012-08-27 14:30:00', 2),
(1882, 4, 11, '2012-08-27 15:30:00', 2),
(1883, 4, 0, '2012-08-27 16:30:00', 2),
(1884, 4, 11, '2012-08-27 18:00:00', 2),
(1885, 4, 12, '2012-08-27 19:00:00', 2),
(1886, 5, 20, '2012-08-27 09:00:00', 2),
(1887, 5, 0, '2012-08-27 10:30:00', 2),
(1888, 5, 12, '2012-08-27 14:00:00', 2),
(1889, 6, 0, '2012-08-27 08:00:00', 2),
(1890, 6, 0, '2012-08-27 09:30:00', 4),
(1891, 6, 6, '2012-08-27 13:00:00', 2),
(1892, 6, 0, '2012-08-27 15:00:00', 2),
(1893, 6, 12, '2012-08-27 16:30:00', 2),
(1894, 6, 0, '2012-08-27 17:30:00', 2),
(1895, 6, 1, '2012-08-27 19:00:00', 2),
(1896, 7, 17, '2012-08-27 09:00:00', 2),
(1897, 7, 4, '2012-08-27 10:30:00', 2),
(1898, 7, 2, '2012-08-27 12:30:00', 2),
(1899, 7, 14, '2012-08-27 13:30:00', 2),
(1900, 7, 4, '2012-08-27 14:30:00', 2),
(1901, 7, 13, '2012-08-27 17:00:00', 2),
(1902, 7, 8, '2012-08-27 18:00:00', 2),
(1903, 7, 15, '2012-08-27 19:00:00', 2),
(1904, 8, 9, '2012-08-27 08:00:00', 1),
(1905, 8, 16, '2012-08-27 10:00:00', 1),
(1906, 8, 16, '2012-08-27 11:00:00', 3),
(1907, 8, 3, '2012-08-27 13:30:00', 1),
(1908, 8, 9, '2012-08-27 14:30:00', 1),
(1909, 8, 16, '2012-08-27 15:00:00', 1),
(1910, 8, 4, '2012-08-27 15:30:00', 1),
(1911, 8, 12, '2012-08-27 16:00:00', 1),
(1912, 8, 11, '2012-08-27 17:00:00', 1),
(1913, 8, 3, '2012-08-27 20:00:00', 1),
(1914, 0, 11, '2012-08-28 08:30:00', 3),
(1915, 0, 14, '2012-08-28 10:00:00', 3),
(1916, 0, 10, '2012-08-28 11:30:00', 3),
(1917, 0, 17, '2012-08-28 14:30:00', 3),
(1918, 0, 6, '2012-08-28 16:00:00', 3),
(1919, 0, 16, '2012-08-28 17:30:00', 3),
(1920, 1, 12, '2012-08-28 08:30:00', 3),
(1921, 1, 11, '2012-08-28 13:00:00', 3),
(1922, 1, 9, '2012-08-28 14:30:00', 3),
(1923, 1, 12, '2012-08-28 19:00:00', 3),
(1924, 2, 17, '2012-08-28 08:30:00', 3),
(1925, 2, 1, '2012-08-28 10:30:00', 3),
(1926, 2, 2, '2012-08-28 12:00:00', 3),
(1927, 2, 1, '2012-08-28 13:30:00', 9),
(1928, 2, 0, '2012-08-28 18:00:00', 3),
(1929, 3, 8, '2012-08-28 11:30:00', 2),
(1930, 3, 15, '2012-08-28 13:00:00', 2),
(1931, 3, 20, '2012-08-28 14:00:00', 2),
(1932, 3, 17, '2012-08-28 18:30:00', 2),
(1933, 4, 8, '2012-08-28 08:30:00', 2),
(1934, 4, 3, '2012-08-28 10:30:00', 2),
(1935, 4, 0, '2012-08-28 11:30:00', 4),
(1936, 4, 17, '2012-08-28 13:30:00', 2),
(1937, 4, 10, '2012-08-28 15:30:00', 2),
(1938, 4, 0, '2012-08-28 16:30:00', 2),
(1939, 4, 13, '2012-08-28 18:30:00', 2),
(1940, 4, 20, '2012-08-28 19:30:00', 2),
(1941, 5, 0, '2012-08-28 09:00:00', 2),
(1942, 5, 7, '2012-08-28 10:30:00', 2),
(1943, 5, 0, '2012-08-28 16:00:00', 2),
(1944, 5, 0, '2012-08-28 18:00:00', 2),
(1945, 6, 6, '2012-08-28 08:00:00', 2),
(1946, 6, 0, '2012-08-28 10:30:00', 4),
(1947, 6, 14, '2012-08-28 12:30:00', 2),
(1948, 6, 12, '2012-08-28 18:00:00', 2),
(1949, 7, 13, '2012-08-28 08:00:00', 2),
(1950, 7, 2, '2012-08-28 09:00:00', 2),
(1951, 7, 8, '2012-08-28 10:00:00', 2),
(1952, 7, 9, '2012-08-28 13:30:00', 2),
(1953, 7, 15, '2012-08-28 14:30:00', 2),
(1954, 7, 4, '2012-08-28 17:00:00', 2),
(1955, 7, 2, '2012-08-28 18:00:00', 2),
(1956, 7, 4, '2012-08-28 19:00:00', 2),
(1957, 8, 16, '2012-08-28 08:00:00', 1),
(1958, 8, 3, '2012-08-28 09:30:00', 1),
(1959, 8, 16, '2012-08-28 10:00:00', 1),
(1960, 8, 2, '2012-08-28 11:30:00', 1),
(1961, 8, 12, '2012-08-28 12:00:00', 1),
(1962, 8, 16, '2012-08-28 13:00:00', 1),
(1963, 8, 4, '2012-08-28 13:30:00', 1),
(1964, 8, 16, '2012-08-28 15:30:00', 1),
(1965, 8, 3, '2012-08-28 17:00:00', 2),
(1966, 8, 0, '2012-08-28 19:00:00', 1),
(1967, 0, 0, '2012-08-29 08:30:00', 3),
(1968, 0, 7, '2012-08-29 11:30:00', 3),
(1969, 0, 10, '2012-08-29 13:30:00', 3),
(1970, 0, 0, '2012-08-29 16:00:00', 3),
(1971, 0, 9, '2012-08-29 17:30:00', 3),
(1972, 0, 0, '2012-08-29 19:00:00', 3),
(1973, 1, 12, '2012-08-29 08:00:00', 3),
(1974, 1, 10, '2012-08-29 10:00:00', 3),
(1975, 1, 9, '2012-08-29 13:30:00', 3),
(1976, 1, 10, '2012-08-29 16:30:00', 3),
(1977, 1, 8, '2012-08-29 18:00:00', 3),
(1978, 2, 1, '2012-08-29 08:30:00', 3),
(1979, 2, 1, '2012-08-29 10:30:00', 3),
(1980, 2, 8, '2012-08-29 12:00:00', 3),
(1981, 2, 8, '2012-08-29 14:00:00', 3),
(1982, 2, 6, '2012-08-29 15:30:00', 3),
(1983, 2, 1, '2012-08-29 17:30:00', 3),
(1984, 2, 11, '2012-08-29 19:00:00', 3),
(1985, 3, 3, '2012-08-29 08:30:00', 2),
(1986, 3, 3, '2012-08-29 10:30:00', 2),
(1987, 3, 1, '2012-08-29 14:00:00', 2),
(1988, 3, 14, '2012-08-29 16:00:00', 2),
(1989, 3, 16, '2012-08-29 17:00:00', 2),
(1990, 3, 3, '2012-08-29 18:30:00', 4),
(1991, 4, 0, '2012-08-29 08:30:00', 2),
(1992, 4, 13, '2012-08-29 10:00:00', 2),
(1993, 4, 0, '2012-08-29 11:00:00', 2),
(1994, 4, 1, '2012-08-29 12:00:00', 2),
(1995, 4, 0, '2012-08-29 13:00:00', 4),
(1996, 4, 5, '2012-08-29 15:00:00', 2),
(1997, 4, 0, '2012-08-29 16:30:00', 2),
(1998, 4, 14, '2012-08-29 18:00:00', 2),
(1999, 4, 20, '2012-08-29 19:30:00', 2),
(2000, 6, 0, '2012-08-29 08:00:00', 2),
(2001, 6, 6, '2012-08-29 10:30:00', 4),
(2002, 6, 0, '2012-08-29 13:00:00', 2),
(2003, 6, 0, '2012-08-29 15:30:00', 2),
(2004, 6, 12, '2012-08-29 17:30:00', 2),
(2005, 6, 12, '2012-08-29 19:00:00', 2),
(2006, 7, 8, '2012-08-29 10:00:00', 2),
(2007, 7, 15, '2012-08-29 13:00:00', 2),
(2008, 7, 4, '2012-08-29 15:00:00', 2),
(2009, 7, 2, '2012-08-29 16:30:00', 2),
(2010, 7, 13, '2012-08-29 17:30:00', 2),
(2011, 7, 4, '2012-08-29 18:30:00', 2),
(2012, 7, 8, '2012-08-29 19:30:00', 2),
(2013, 8, 15, '2012-08-29 08:00:00', 1),
(2014, 8, 0, '2012-08-29 11:30:00', 1),
(2015, 8, 3, '2012-08-29 13:30:00', 1),
(2016, 8, 16, '2012-08-29 14:00:00', 1),
(2017, 8, 3, '2012-08-29 15:00:00', 2),
(2018, 8, 0, '2012-08-29 17:30:00', 1),
(2019, 8, 16, '2012-08-29 18:30:00', 1),
(2020, 8, 1, '2012-08-29 19:30:00', 1),
(2021, 0, 0, '2012-08-30 08:00:00', 3),
(2022, 0, 17, '2012-08-30 09:30:00', 3),
(2023, 0, 5, '2012-08-30 12:30:00', 3),
(2024, 0, 0, '2012-08-30 14:00:00', 3),
(2025, 0, 5, '2012-08-30 16:00:00', 3),
(2026, 1, 8, '2012-08-30 08:00:00', 3),
(2027, 1, 10, '2012-08-30 12:30:00', 3),
(2028, 1, 11, '2012-08-30 14:00:00', 3),
(2029, 1, 0, '2012-08-30 16:00:00', 3),
(2030, 1, 0, '2012-08-30 19:00:00', 3),
(2031, 2, 1, '2012-08-30 11:00:00', 3),
(2032, 2, 15, '2012-08-30 12:30:00', 3),
(2033, 2, 1, '2012-08-30 14:00:00', 3),
(2034, 2, 7, '2012-08-30 17:00:00', 3),
(2035, 2, 21, '2012-08-30 19:00:00', 3),
(2036, 3, 10, '2012-08-30 08:00:00', 2),
(2037, 3, 6, '2012-08-30 09:30:00', 2),
(2038, 3, 14, '2012-08-30 12:30:00', 2),
(2039, 3, 20, '2012-08-30 15:00:00', 2),
(2040, 3, 20, '2012-08-30 16:30:00', 2),
(2041, 3, 16, '2012-08-30 17:30:00', 2),
(2042, 3, 6, '2012-08-30 19:30:00', 2),
(2043, 4, 0, '2012-08-30 08:00:00', 2),
(2044, 4, 13, '2012-08-30 09:00:00', 2),
(2045, 4, 0, '2012-08-30 10:00:00', 2),
(2046, 4, 10, '2012-08-30 14:30:00', 2),
(2047, 4, 11, '2012-08-30 15:30:00', 2),
(2048, 4, 1, '2012-08-30 16:30:00', 2),
(2049, 4, 0, '2012-08-30 18:30:00', 2),
(2050, 6, 12, '2012-08-30 08:00:00', 6),
(2051, 6, 12, '2012-08-30 11:30:00', 2),
(2052, 6, 0, '2012-08-30 13:00:00', 4),
(2053, 6, 0, '2012-08-30 15:30:00', 2),
(2054, 6, 12, '2012-08-30 16:30:00', 2),
(2055, 6, 0, '2012-08-30 17:30:00', 2),
(2056, 7, 0, '2012-08-30 11:30:00', 2),
(2057, 7, 4, '2012-08-30 14:30:00', 2),
(2058, 7, 15, '2012-08-30 17:30:00', 2),
(2059, 7, 8, '2012-08-30 19:00:00', 2),
(2060, 8, 1, '2012-08-30 08:00:00', 1),
(2061, 8, 21, '2012-08-30 10:00:00', 1),
(2062, 8, 3, '2012-08-30 10:30:00', 1),
(2063, 8, 20, '2012-08-30 11:00:00', 1),
(2064, 8, 17, '2012-08-30 12:30:00', 1),
(2065, 8, 3, '2012-08-30 13:00:00', 1),
(2066, 8, 2, '2012-08-30 14:00:00', 1),
(2067, 8, 21, '2012-08-30 15:30:00', 3),
(2068, 8, 3, '2012-08-30 18:00:00', 1),
(2069, 8, 6, '2012-08-30 19:00:00', 1),
(2070, 8, 16, '2012-08-30 19:30:00', 1),
(2071, 8, 9, '2012-08-30 20:00:00', 1),
(2072, 0, 5, '2012-08-31 09:00:00', 3),
(2073, 0, 0, '2012-08-31 10:30:00', 3),
(2074, 0, 11, '2012-08-31 12:00:00', 3),
(2075, 0, 6, '2012-08-31 14:30:00', 3),
(2076, 0, 2, '2012-08-31 16:30:00', 3),
(2077, 0, 5, '2012-08-31 19:00:00', 3),
(2078, 1, 0, '2012-08-31 08:00:00', 3),
(2079, 1, 0, '2012-08-31 10:30:00', 3),
(2080, 1, 12, '2012-08-31 12:00:00', 3),
(2081, 1, 8, '2012-08-31 13:30:00', 3),
(2082, 1, 10, '2012-08-31 15:00:00', 6),
(2083, 1, 8, '2012-08-31 18:30:00', 3),
(2084, 2, 2, '2012-08-31 08:30:00', 3),
(2085, 2, 0, '2012-08-31 11:00:00', 3),
(2086, 2, 16, '2012-08-31 12:30:00', 3),
(2087, 2, 21, '2012-08-31 14:00:00', 3),
(2088, 2, 21, '2012-08-31 17:00:00', 3),
(2089, 2, 0, '2012-08-31 19:00:00', 3),
(2090, 3, 20, '2012-08-31 09:00:00', 2),
(2091, 3, 10, '2012-08-31 10:30:00', 2),
(2092, 3, 3, '2012-08-31 12:30:00', 2),
(2093, 3, 20, '2012-08-31 19:30:00', 2),
(2094, 4, 0, '2012-08-31 08:30:00', 2),
(2095, 4, 0, '2012-08-31 10:00:00', 2),
(2096, 4, 14, '2012-08-31 12:30:00', 2),
(2097, 4, 0, '2012-08-31 13:30:00', 2),
(2098, 4, 11, '2012-08-31 14:30:00', 4),
(2099, 4, 9, '2012-08-31 16:30:00', 2),
(2100, 4, 6, '2012-08-31 18:00:00', 2),
(2101, 4, 11, '2012-08-31 19:00:00', 2),
(2102, 5, 0, '2012-08-31 09:30:00', 2),
(2103, 5, 0, '2012-08-31 11:00:00', 2),
(2104, 5, 0, '2012-08-31 15:00:00', 2),
(2105, 5, 11, '2012-08-31 17:00:00', 2),
(2106, 6, 1, '2012-08-31 09:00:00', 4),
(2107, 6, 0, '2012-08-31 11:00:00', 4),
(2108, 6, 0, '2012-08-31 14:30:00', 4),
(2109, 6, 12, '2012-08-31 18:00:00', 4),
(2110, 7, 9, '2012-08-31 08:00:00', 2),
(2111, 7, 5, '2012-08-31 11:30:00', 2),
(2112, 7, 17, '2012-08-31 13:00:00', 2),
(2113, 7, 15, '2012-08-31 15:00:00', 2),
(2114, 7, 17, '2012-08-31 16:30:00', 2),
(2115, 7, 13, '2012-08-31 17:30:00', 2),
(2116, 7, 10, '2012-08-31 18:30:00', 2),
(2117, 8, 17, '2012-08-31 08:30:00', 1),
(2118, 8, 3, '2012-08-31 10:00:00', 1),
(2119, 8, 21, '2012-08-31 12:30:00', 2),
(2120, 8, 3, '2012-08-31 13:30:00', 1),
(2121, 8, 15, '2012-08-31 14:00:00', 1),
(2122, 8, 3, '2012-08-31 14:30:00', 1),
(2123, 8, 16, '2012-08-31 16:00:00', 1),
(2124, 8, 6, '2012-08-31 16:30:00', 1),
(2125, 8, 3, '2012-08-31 17:00:00', 1),
(2126, 8, 2, '2012-08-31 18:00:00', 1),
(2127, 8, 20, '2012-08-31 18:30:00', 1),
(2128, 8, 21, '2012-08-31 19:00:00', 1),
(2129, 8, 21, '2012-08-31 20:00:00', 1),
(2130, 0, 0, '2012-09-01 08:00:00', 3),
(2131, 0, 17, '2012-09-01 11:00:00', 3),
(2132, 0, 7, '2012-09-01 12:30:00', 3),
(2133, 0, 6, '2012-09-01 15:00:00', 3),
(2134, 0, 4, '2012-09-01 17:00:00', 3),
(2135, 1, 0, '2012-09-01 08:00:00', 3),
(2136, 1, 11, '2012-09-01 09:30:00', 3),
(2137, 1, 10, '2012-09-01 11:00:00', 3),
(2138, 1, 12, '2012-09-01 14:30:00', 3),
(2139, 1, 0, '2012-09-01 16:30:00', 3),
(2140, 1, 12, '2012-09-01 19:00:00', 3),
(2141, 2, 1, '2012-09-01 09:00:00', 3),
(2142, 2, 21, '2012-09-01 13:30:00', 3),
(2143, 2, 1, '2012-09-01 16:30:00', 3),
(2144, 2, 15, '2012-09-01 18:00:00', 3),
(2145, 3, 17, '2012-09-01 08:30:00', 2),
(2146, 3, 13, '2012-09-01 09:30:00', 2),
(2147, 3, 15, '2012-09-01 10:30:00', 2),
(2148, 3, 17, '2012-09-01 12:30:00', 2),
(2149, 3, 17, '2012-09-01 14:00:00', 2),
(2150, 3, 16, '2012-09-01 15:00:00', 2),
(2151, 3, 0, '2012-09-01 16:30:00', 2),
(2152, 3, 16, '2012-09-01 18:00:00', 2),
(2153, 3, 17, '2012-09-01 19:00:00', 2),
(2154, 4, 8, '2012-09-01 08:30:00', 2),
(2155, 4, 9, '2012-09-01 11:00:00', 2),
(2156, 4, 11, '2012-09-01 12:30:00', 2),
(2157, 4, 0, '2012-09-01 13:30:00', 6),
(2158, 4, 0, '2012-09-01 17:30:00', 2),
(2159, 4, 16, '2012-09-01 19:30:00', 2),
(2160, 5, 0, '2012-09-01 09:30:00', 2),
(2161, 5, 7, '2012-09-01 15:30:00', 2),
(2162, 6, 0, '2012-09-01 09:30:00', 8),
(2163, 6, 4, '2012-09-01 15:00:00', 2),
(2164, 6, 0, '2012-09-01 16:00:00', 4),
(2165, 6, 2, '2012-09-01 18:00:00', 2),
(2166, 7, 21, '2012-09-01 08:30:00', 2),
(2167, 7, 2, '2012-09-01 11:30:00', 2),
(2168, 7, 1, '2012-09-01 14:00:00', 2),
(2169, 7, 15, '2012-09-01 15:00:00', 2),
(2170, 7, 13, '2012-09-01 17:30:00', 2),
(2171, 7, 9, '2012-09-01 19:00:00', 2),
(2172, 8, 17, '2012-09-01 10:00:00', 1),
(2173, 8, 1, '2012-09-01 10:30:00', 1),
(2174, 8, 14, '2012-09-01 11:00:00', 1),
(2175, 8, 21, '2012-09-01 11:30:00', 1),
(2176, 8, 21, '2012-09-01 15:00:00', 1),
(2177, 8, 3, '2012-09-01 16:00:00', 1),
(2178, 8, 20, '2012-09-01 18:00:00', 1),
(2179, 8, 3, '2012-09-01 18:30:00', 1),
(2180, 8, 7, '2012-09-01 19:30:00', 1),
(2181, 0, 10, '2012-09-02 08:30:00', 3),
(2182, 0, 0, '2012-09-02 10:30:00', 3),
(2183, 0, 12, '2012-09-02 12:00:00', 3),
(2184, 0, 5, '2012-09-02 15:00:00', 3),
(2185, 0, 6, '2012-09-02 18:00:00', 3),
(2186, 1, 15, '2012-09-02 08:30:00', 3),
(2187, 1, 11, '2012-09-02 12:30:00', 3),
(2188, 1, 10, '2012-09-02 16:00:00', 6),
(2189, 1, 0, '2012-09-02 19:00:00', 3),
(2190, 2, 0, '2012-09-02 09:30:00', 3),
(2191, 2, 21, '2012-09-02 11:00:00', 3),
(2192, 2, 0, '2012-09-02 12:30:00', 3),
(2193, 2, 9, '2012-09-02 15:30:00', 3),
(2194, 2, 5, '2012-09-02 17:00:00', 3),
(2195, 2, 0, '2012-09-02 19:00:00', 3),
(2196, 3, 15, '2012-09-02 13:30:00', 2),
(2197, 3, 3, '2012-09-02 14:30:00', 2),
(2198, 3, 15, '2012-09-02 16:30:00', 2),
(2199, 3, 15, '2012-09-02 18:00:00', 2),
(2200, 3, 17, '2012-09-02 19:30:00', 2),
(2201, 4, 0, '2012-09-02 08:00:00', 2),
(2202, 4, 0, '2012-09-02 09:30:00', 6),
(2203, 4, 5, '2012-09-02 12:30:00', 2),
(2204, 4, 0, '2012-09-02 13:30:00', 4),
(2205, 4, 20, '2012-09-02 15:30:00', 2),
(2206, 4, 8, '2012-09-02 16:30:00', 2),
(2207, 4, 14, '2012-09-02 17:30:00', 2),
(2208, 4, 0, '2012-09-02 18:30:00', 2),
(2209, 5, 0, '2012-09-02 09:30:00', 2),
(2210, 5, 0, '2012-09-02 11:30:00', 2),
(2211, 6, 0, '2012-09-02 08:30:00', 4),
(2212, 6, 0, '2012-09-02 11:00:00', 2),
(2213, 6, 10, '2012-09-02 14:00:00', 2),
(2214, 6, 0, '2012-09-02 15:00:00', 4),
(2215, 6, 0, '2012-09-02 17:30:00', 2),
(2216, 6, 0, '2012-09-02 19:00:00', 2),
(2217, 7, 17, '2012-09-02 08:30:00', 2),
(2218, 7, 2, '2012-09-02 10:30:00', 2),
(2219, 7, 22, '2012-09-02 11:30:00', 2),
(2220, 7, 7, '2012-09-02 13:00:00', 2),
(2221, 7, 8, '2012-09-02 14:30:00', 2),
(2222, 7, 2, '2012-09-02 16:30:00', 2),
(2223, 7, 2, '2012-09-02 18:30:00', 2),
(2224, 8, 20, '2012-09-02 08:00:00', 1),
(2225, 8, 3, '2012-09-02 08:30:00', 1),
(2226, 8, 16, '2012-09-02 09:30:00', 2),
(2227, 8, 3, '2012-09-02 10:30:00', 1),
(2228, 8, 3, '2012-09-02 11:30:00', 1),
(2229, 8, 7, '2012-09-02 12:30:00', 1),
(2230, 8, 16, '2012-09-02 13:00:00', 1),
(2231, 8, 16, '2012-09-02 16:00:00', 1),
(2232, 8, 3, '2012-09-02 17:30:00', 1),
(2233, 8, 21, '2012-09-02 18:30:00', 1),
(2234, 8, 3, '2012-09-02 19:00:00', 1),
(2235, 8, 16, '2012-09-02 20:00:00', 1),
(2236, 0, 0, '2012-09-03 08:00:00', 6),
(2237, 0, 11, '2012-09-03 11:00:00', 6),
(2238, 0, 14, '2012-09-03 14:00:00', 3),
(2239, 0, 0, '2012-09-03 15:30:00', 3),
(2240, 0, 16, '2012-09-03 18:00:00', 3),
(2241, 1, 12, '2012-09-03 08:00:00', 3),
(2242, 1, 0, '2012-09-03 10:00:00', 6),
(2243, 1, 0, '2012-09-03 13:30:00', 3),
(2244, 1, 8, '2012-09-03 15:00:00', 6),
(2245, 1, 11, '2012-09-03 18:00:00', 3),
(2246, 2, 21, '2012-09-03 08:30:00', 3),
(2247, 2, 12, '2012-09-03 10:00:00', 3),
(2248, 2, 9, '2012-09-03 12:30:00', 3),
(2249, 2, 17, '2012-09-03 14:00:00', 3),
(2250, 2, 0, '2012-09-03 19:00:00', 3),
(2251, 3, 22, '2012-09-03 09:30:00', 2),
(2252, 3, 21, '2012-09-03 11:30:00', 2),
(2253, 3, 13, '2012-09-03 12:30:00', 2),
(2254, 3, 20, '2012-09-03 13:30:00', 4),
(2255, 3, 17, '2012-09-03 17:30:00', 2),
(2256, 3, 20, '2012-09-03 19:00:00', 2),
(2257, 4, 0, '2012-09-03 08:00:00', 2),
(2258, 4, 8, '2012-09-03 09:30:00', 2),
(2259, 4, 0, '2012-09-03 11:00:00', 4),
(2260, 4, 8, '2012-09-03 13:00:00', 2),
(2261, 4, 0, '2012-09-03 15:00:00', 2),
(2262, 4, 3, '2012-09-03 16:00:00', 2),
(2263, 4, 0, '2012-09-03 17:00:00', 2),
(2264, 4, 14, '2012-09-03 19:00:00', 2),
(2265, 5, 10, '2012-09-03 11:30:00', 2),
(2266, 6, 6, '2012-09-03 11:00:00', 2),
(2267, 6, 0, '2012-09-03 12:00:00', 2),
(2268, 6, 0, '2012-09-03 13:30:00', 4),
(2269, 6, 6, '2012-09-03 16:00:00', 4),
(2270, 6, 12, '2012-09-03 18:30:00', 2),
(2271, 6, 0, '2012-09-03 19:30:00', 2),
(2272, 7, 15, '2012-09-03 09:30:00', 2),
(2273, 7, 4, '2012-09-03 12:00:00', 4),
(2274, 7, 15, '2012-09-03 15:00:00', 2),
(2275, 7, 15, '2012-09-03 17:00:00', 2),
(2276, 7, 1, '2012-09-03 18:00:00', 2),
(2277, 7, 7, '2012-09-03 19:00:00', 2),
(2278, 8, 2, '2012-09-03 08:00:00', 1),
(2279, 8, 7, '2012-09-03 08:30:00', 1),
(2280, 8, 16, '2012-09-03 10:00:00', 1),
(2281, 8, 1, '2012-09-03 10:30:00', 1),
(2282, 8, 0, '2012-09-03 11:30:00', 1),
(2283, 8, 3, '2012-09-03 13:00:00', 1),
(2284, 8, 21, '2012-09-03 14:00:00', 1),
(2285, 8, 3, '2012-09-03 15:00:00', 1),
(2286, 8, 21, '2012-09-03 15:30:00', 1),
(2287, 8, 21, '2012-09-03 17:00:00', 1),
(2288, 8, 16, '2012-09-03 17:30:00', 1),
(2289, 8, 20, '2012-09-03 18:30:00', 1),
(2290, 8, 21, '2012-09-03 20:00:00', 1),
(2291, 0, 11, '2012-09-04 08:30:00', 3),
(2292, 0, 0, '2012-09-04 10:00:00', 3),
(2293, 0, 10, '2012-09-04 11:30:00', 3),
(2294, 0, 0, '2012-09-04 13:30:00', 3),
(2295, 0, 5, '2012-09-04 15:00:00', 3),
(2296, 0, 0, '2012-09-04 16:30:00', 3),
(2297, 1, 0, '2012-09-04 10:00:00', 3),
(2298, 1, 8, '2012-09-04 12:00:00', 3),
(2299, 1, 0, '2012-09-04 14:00:00', 3),
(2300, 1, 0, '2012-09-04 16:00:00', 3),
(2301, 1, 9, '2012-09-04 17:30:00', 3),
(2302, 1, 24, '2012-09-04 19:00:00', 3),
(2303, 2, 21, '2012-09-04 08:00:00', 3),
(2304, 2, 14, '2012-09-04 09:30:00', 3),
(2305, 2, 15, '2012-09-04 11:00:00', 3),
(2306, 2, 0, '2012-09-04 12:30:00', 3),
(2307, 2, 0, '2012-09-04 15:00:00', 3),
(2308, 2, 5, '2012-09-04 16:30:00', 3),
(2309, 2, 2, '2012-09-04 18:00:00', 3),
(2310, 3, 20, '2012-09-04 10:30:00', 2),
(2311, 3, 21, '2012-09-04 11:30:00', 2),
(2312, 3, 17, '2012-09-04 13:30:00', 2),
(2313, 3, 21, '2012-09-04 15:00:00', 2),
(2314, 3, 20, '2012-09-04 17:30:00', 2),
(2315, 3, 22, '2012-09-04 18:30:00', 2),
(2316, 4, 0, '2012-09-04 08:00:00', 2),
(2317, 4, 3, '2012-09-04 10:30:00', 2),
(2318, 4, 0, '2012-09-04 11:30:00', 2),
(2319, 4, 7, '2012-09-04 12:30:00', 2),
(2320, 4, 0, '2012-09-04 13:30:00', 2),
(2321, 4, 3, '2012-09-04 15:00:00', 2),
(2322, 4, 0, '2012-09-04 16:00:00', 2),
(2323, 4, 0, '2012-09-04 17:30:00', 2),
(2324, 4, 11, '2012-09-04 18:30:00', 2),
(2325, 4, 8, '2012-09-04 19:30:00', 2),
(2326, 5, 0, '2012-09-04 09:30:00', 2),
(2327, 5, 0, '2012-09-04 12:30:00', 2),
(2328, 6, 0, '2012-09-04 08:00:00', 4),
(2329, 6, 0, '2012-09-04 11:00:00', 2),
(2330, 6, 12, '2012-09-04 12:00:00', 2),
(2331, 6, 0, '2012-09-04 13:30:00', 2),
(2332, 6, 5, '2012-09-04 18:30:00', 2),
(2333, 7, 22, '2012-09-04 08:00:00', 2),
(2334, 7, 8, '2012-09-04 09:00:00', 2),
(2335, 7, 7, '2012-09-04 10:00:00', 2),
(2336, 7, 24, '2012-09-04 11:00:00', 2),
(2337, 7, 5, '2012-09-04 13:00:00', 2),
(2338, 7, 24, '2012-09-04 16:00:00', 2),
(2339, 7, 0, '2012-09-04 17:30:00', 2),
(2340, 7, 14, '2012-09-04 19:00:00', 2),
(2341, 8, 3, '2012-09-04 08:00:00', 1),
(2342, 8, 3, '2012-09-04 09:00:00', 1),
(2343, 8, 20, '2012-09-04 09:30:00', 1),
(2344, 8, 21, '2012-09-04 10:00:00', 3),
(2345, 8, 0, '2012-09-04 13:00:00', 1),
(2346, 8, 21, '2012-09-04 13:30:00', 1),
(2347, 8, 3, '2012-09-04 14:00:00', 1),
(2348, 8, 8, '2012-09-04 15:00:00', 2),
(2349, 8, 21, '2012-09-04 16:00:00', 1),
(2350, 8, 3, '2012-09-04 18:30:00', 1),
(2351, 8, 21, '2012-09-04 19:30:00', 1),
(2352, 8, 16, '2012-09-04 20:00:00', 1),
(2353, 0, 22, '2012-09-05 08:00:00', 3),
(2354, 0, 12, '2012-09-05 09:30:00', 3),
(2355, 0, 0, '2012-09-05 11:00:00', 3),
(2356, 0, 2, '2012-09-05 14:00:00', 3),
(2357, 0, 6, '2012-09-05 15:30:00', 3),
(2358, 0, 17, '2012-09-05 18:00:00', 3),
(2359, 1, 1, '2012-09-05 08:00:00', 3),
(2360, 1, 10, '2012-09-05 09:30:00', 3),
(2361, 1, 24, '2012-09-05 12:00:00', 3),
(2362, 1, 8, '2012-09-05 15:30:00', 3),
(2363, 1, 12, '2012-09-05 18:00:00', 3),
(2364, 2, 7, '2012-09-05 08:30:00', 3),
(2365, 2, 13, '2012-09-05 11:30:00', 3),
(2366, 2, 1, '2012-09-05 13:00:00', 3),
(2367, 2, 24, '2012-09-05 16:30:00', 3),
(2368, 2, 1, '2012-09-05 18:00:00', 3),
(2369, 3, 16, '2012-09-05 08:30:00', 2),
(2370, 3, 15, '2012-09-05 09:30:00', 2),
(2371, 3, 2, '2012-09-05 12:00:00', 2),
(2372, 3, 10, '2012-09-05 15:30:00', 2),
(2373, 3, 10, '2012-09-05 19:30:00', 2),
(2374, 4, 24, '2012-09-05 08:00:00', 2),
(2375, 4, 0, '2012-09-05 09:00:00', 4),
(2376, 4, 0, '2012-09-05 11:30:00', 2),
(2377, 4, 16, '2012-09-05 12:30:00', 2),
(2378, 4, 0, '2012-09-05 13:30:00', 6),
(2379, 4, 11, '2012-09-05 17:00:00', 2),
(2380, 4, 0, '2012-09-05 18:00:00', 2),
(2381, 4, 9, '2012-09-05 19:00:00', 2),
(2382, 5, 0, '2012-09-05 09:00:00', 2),
(2383, 5, 0, '2012-09-05 11:00:00', 2),
(2384, 5, 0, '2012-09-05 12:30:00', 2),
(2385, 6, 0, '2012-09-05 08:30:00', 4),
(2386, 6, 0, '2012-09-05 11:00:00', 2),
(2387, 6, 11, '2012-09-05 13:00:00', 2),
(2388, 6, 0, '2012-09-05 14:00:00', 2),
(2389, 6, 0, '2012-09-05 15:30:00', 6),
(2390, 7, 8, '2012-09-05 08:00:00', 2),
(2391, 7, 4, '2012-09-05 10:00:00', 2),
(2392, 7, 15, '2012-09-05 11:00:00', 2),
(2393, 7, 7, '2012-09-05 13:00:00', 2),
(2394, 7, 4, '2012-09-05 15:00:00', 2),
(2395, 7, 9, '2012-09-05 16:30:00', 2),
(2396, 7, 5, '2012-09-05 18:30:00', 2),
(2397, 8, 20, '2012-09-05 09:00:00', 1),
(2398, 8, 14, '2012-09-05 10:30:00', 1),
(2399, 8, 3, '2012-09-05 11:00:00', 2),
(2400, 8, 20, '2012-09-05 13:00:00', 1),
(2401, 8, 2, '2012-09-05 13:30:00', 1),
(2402, 8, 21, '2012-09-05 14:00:00', 1),
(2403, 8, 0, '2012-09-05 14:30:00', 1),
(2404, 8, 9, '2012-09-05 15:00:00', 1),
(2405, 8, 2, '2012-09-05 15:30:00', 1),
(2406, 8, 16, '2012-09-05 16:00:00', 1),
(2407, 8, 6, '2012-09-05 17:00:00', 1),
(2408, 8, 8, '2012-09-05 17:30:00', 1),
(2409, 8, 2, '2012-09-05 19:00:00', 1),
(2410, 8, 1, '2012-09-05 20:00:00', 1),
(2411, 0, 17, '2012-09-06 08:30:00', 3),
(2412, 0, 11, '2012-09-06 10:30:00', 3),
(2413, 0, 22, '2012-09-06 12:00:00', 3),
(2414, 0, 11, '2012-09-06 16:30:00', 3),
(2415, 0, 4, '2012-09-06 19:00:00', 3),
(2416, 1, 0, '2012-09-06 08:30:00', 3),
(2417, 1, 8, '2012-09-06 10:00:00', 3),
(2418, 1, 0, '2012-09-06 11:30:00', 3),
(2419, 1, 9, '2012-09-06 13:00:00', 3),
(2420, 1, 12, '2012-09-06 16:30:00', 6),
(2421, 2, 9, '2012-09-06 08:00:00', 3),
(2422, 2, 15, '2012-09-06 09:30:00', 3),
(2423, 2, 21, '2012-09-06 12:00:00', 3),
(2424, 2, 12, '2012-09-06 13:30:00', 3),
(2425, 2, 17, '2012-09-06 15:00:00', 3),
(2426, 2, 1, '2012-09-06 17:30:00', 3),
(2427, 2, 21, '2012-09-06 19:00:00', 3),
(2428, 3, 13, '2012-09-06 08:30:00', 2),
(2429, 3, 15, '2012-09-06 11:00:00', 2),
(2430, 3, 17, '2012-09-06 13:00:00', 2),
(2431, 3, 13, '2012-09-06 14:30:00', 2),
(2432, 3, 20, '2012-09-06 15:30:00', 2),
(2433, 3, 15, '2012-09-06 17:30:00', 2),
(2434, 4, 0, '2012-09-06 08:00:00', 2),
(2435, 4, 2, '2012-09-06 09:30:00', 2),
(2436, 4, 24, '2012-09-06 10:30:00', 2),
(2437, 4, 13, '2012-09-06 12:00:00', 2),
(2438, 4, 0, '2012-09-06 13:00:00', 2),
(2439, 4, 6, '2012-09-06 14:00:00', 2),
(2440, 4, 0, '2012-09-06 15:00:00', 4),
(2441, 4, 7, '2012-09-06 17:30:00', 2),
(2442, 4, 16, '2012-09-06 18:30:00', 2),
(2443, 4, 8, '2012-09-06 19:30:00', 2),
(2444, 5, 0, '2012-09-06 11:00:00', 2),
(2445, 6, 0, '2012-09-06 09:00:00', 4),
(2446, 6, 0, '2012-09-06 11:30:00', 2),
(2447, 6, 14, '2012-09-06 12:30:00', 2),
(2448, 6, 0, '2012-09-06 13:30:00', 2),
(2449, 6, 0, '2012-09-06 15:30:00', 2),
(2450, 6, 0, '2012-09-06 17:00:00', 2),
(2451, 6, 0, '2012-09-06 18:30:00', 2),
(2452, 6, 13, '2012-09-06 19:30:00', 2),
(2453, 7, 0, '2012-09-06 09:00:00', 2),
(2454, 7, 15, '2012-09-06 12:30:00', 2),
(2455, 7, 24, '2012-09-06 16:30:00', 2),
(2456, 7, 10, '2012-09-06 17:30:00', 2),
(2457, 7, 0, '2012-09-06 18:30:00', 2),
(2458, 8, 21, '2012-09-06 09:00:00', 1),
(2459, 8, 24, '2012-09-06 09:30:00', 1),
(2460, 8, 16, '2012-09-06 10:00:00', 1),
(2461, 8, 7, '2012-09-06 11:00:00', 1),
(2462, 8, 9, '2012-09-06 11:30:00', 1),
(2463, 8, 3, '2012-09-06 12:00:00', 1),
(2464, 8, 0, '2012-09-06 13:30:00', 1),
(2465, 8, 20, '2012-09-06 14:00:00', 1),
(2466, 8, 24, '2012-09-06 15:00:00', 1),
(2467, 8, 3, '2012-09-06 16:30:00', 1),
(2468, 8, 22, '2012-09-06 17:00:00', 1),
(2469, 8, 16, '2012-09-06 18:00:00', 1),
(2470, 8, 2, '2012-09-06 19:00:00', 1),
(2471, 8, 3, '2012-09-06 19:30:00', 2),
(2472, 0, 0, '2012-09-07 08:00:00', 3),
(2473, 0, 14, '2012-09-07 09:30:00', 6),
(2474, 0, 0, '2012-09-07 12:30:00', 3),
(2475, 0, 11, '2012-09-07 14:00:00', 3),
(2476, 0, 17, '2012-09-07 16:00:00', 3),
(2477, 0, 14, '2012-09-07 18:00:00', 3),
(2478, 1, 9, '2012-09-07 08:00:00', 3),
(2479, 1, 12, '2012-09-07 11:00:00', 3),
(2480, 1, 11, '2012-09-07 12:30:00', 3),
(2481, 1, 24, '2012-09-07 14:30:00', 3),
(2482, 1, 12, '2012-09-07 16:30:00', 3),
(2483, 1, 9, '2012-09-07 18:00:00', 3),
(2484, 2, 1, '2012-09-07 08:00:00', 3),
(2485, 2, 5, '2012-09-07 09:30:00', 3),
(2486, 2, 1, '2012-09-07 11:00:00', 3),
(2487, 2, 0, '2012-09-07 12:30:00', 3),
(2488, 2, 1, '2012-09-07 14:00:00', 6),
(2489, 2, 0, '2012-09-07 17:00:00', 3),
(2490, 2, 1, '2012-09-07 19:00:00', 3),
(2491, 3, 16, '2012-09-07 08:30:00', 2),
(2492, 3, 15, '2012-09-07 11:00:00', 2),
(2493, 3, 20, '2012-09-07 14:30:00', 2),
(2494, 3, 7, '2012-09-07 17:00:00', 2),
(2495, 3, 10, '2012-09-07 19:00:00', 2),
(2496, 4, 3, '2012-09-07 08:30:00', 4),
(2497, 4, 6, '2012-09-07 11:00:00', 2),
(2498, 4, 20, '2012-09-07 12:00:00', 2),
(2499, 4, 5, '2012-09-07 13:00:00', 2),
(2500, 4, 16, '2012-09-07 14:30:00', 2),
(2501, 4, 0, '2012-09-07 16:00:00', 2),
(2502, 4, 10, '2012-09-07 18:00:00', 2),
(2503, 4, 13, '2012-09-07 19:00:00', 2),
(2504, 5, 24, '2012-09-07 11:30:00', 2),
(2505, 5, 3, '2012-09-07 14:30:00', 2),
(2506, 6, 0, '2012-09-07 09:30:00', 8),
(2507, 6, 0, '2012-09-07 14:00:00', 2),
(2508, 6, 6, '2012-09-07 16:30:00', 2),
(2509, 7, 8, '2012-09-07 09:00:00', 2),
(2510, 7, 9, '2012-09-07 11:30:00', 2),
(2511, 7, 4, '2012-09-07 13:30:00', 2),
(2512, 7, 15, '2012-09-07 15:00:00', 2),
(2513, 7, 5, '2012-09-07 17:00:00', 2),
(2514, 7, 5, '2012-09-07 19:00:00', 2),
(2515, 8, 24, '2012-09-07 08:30:00', 1),
(2516, 8, 3, '2012-09-07 10:30:00', 1),
(2517, 8, 21, '2012-09-07 11:00:00', 1),
(2518, 8, 3, '2012-09-07 11:30:00', 1),
(2519, 8, 17, '2012-09-07 12:00:00', 1),
(2520, 8, 3, '2012-09-07 13:00:00', 1),
(2521, 8, 20, '2012-09-07 13:30:00', 1),
(2522, 8, 16, '2012-09-07 14:00:00', 1),
(2523, 8, 21, '2012-09-07 14:30:00', 2),
(2524, 8, 4, '2012-09-07 15:30:00', 1),
(2525, 8, 21, '2012-09-07 16:30:00', 1),
(2526, 8, 2, '2012-09-07 18:00:00', 1),
(2527, 8, 7, '2012-09-07 18:30:00', 1),
(2528, 8, 16, '2012-09-07 20:00:00', 1),
(2529, 0, 5, '2012-09-08 08:00:00', 3),
(2530, 0, 0, '2012-09-08 09:30:00', 3),
(2531, 0, 7, '2012-09-08 11:00:00', 3),
(2532, 0, 0, '2012-09-08 12:30:00', 3),
(2533, 0, 11, '2012-09-08 15:00:00', 3),
(2534, 0, 17, '2012-09-08 16:30:00', 3),
(2535, 0, 16, '2012-09-08 18:30:00', 3),
(2536, 1, 10, '2012-09-08 08:00:00', 3),
(2537, 1, 24, '2012-09-08 09:30:00', 3),
(2538, 1, 9, '2012-09-08 11:30:00', 3),
(2539, 1, 0, '2012-09-08 13:00:00', 3),
(2540, 1, 9, '2012-09-08 15:00:00', 6),
(2541, 2, 8, '2012-09-08 08:30:00', 3),
(2542, 2, 21, '2012-09-08 10:00:00', 3),
(2543, 2, 26, '2012-09-08 13:00:00', 3),
(2544, 2, 1, '2012-09-08 15:00:00', 3),
(2545, 2, 21, '2012-09-08 16:30:00', 3),
(2546, 2, 1, '2012-09-08 18:30:00', 3),
(2547, 3, 6, '2012-09-08 08:00:00', 2),
(2548, 3, 2, '2012-09-08 09:00:00', 2),
(2549, 3, 15, '2012-09-08 10:00:00', 2),
(2550, 3, 11, '2012-09-08 12:00:00', 2),
(2551, 3, 20, '2012-09-08 13:00:00', 2),
(2552, 3, 20, '2012-09-08 16:00:00', 2),
(2553, 3, 1, '2012-09-08 17:30:00', 2),
(2554, 3, 9, '2012-09-08 18:30:00', 2),
(2555, 3, 15, '2012-09-08 19:30:00', 2),
(2556, 4, 20, '2012-09-08 08:00:00', 2),
(2557, 4, 0, '2012-09-08 09:30:00', 8),
(2558, 4, 3, '2012-09-08 13:30:00', 2),
(2559, 4, 0, '2012-09-08 14:30:00', 4),
(2560, 4, 13, '2012-09-08 16:30:00', 2),
(2561, 4, 13, '2012-09-08 18:00:00', 2),
(2562, 4, 0, '2012-09-08 19:00:00', 2),
(2563, 5, 24, '2012-09-08 15:30:00', 2),
(2564, 6, 0, '2012-09-08 09:00:00', 2),
(2565, 6, 6, '2012-09-08 13:30:00', 2),
(2566, 6, 0, '2012-09-08 16:00:00', 2),
(2567, 6, 4, '2012-09-08 17:00:00', 2),
(2568, 6, 0, '2012-09-08 18:00:00', 4),
(2569, 7, 6, '2012-09-08 09:30:00', 2),
(2570, 7, 4, '2012-09-08 11:30:00', 2),
(2571, 7, 13, '2012-09-08 12:30:00', 2),
(2572, 7, 0, '2012-09-08 13:30:00', 2),
(2573, 7, 15, '2012-09-08 14:30:00', 2),
(2574, 7, 8, '2012-09-08 15:30:00', 2),
(2575, 7, 1, '2012-09-08 16:30:00', 2),
(2576, 7, 15, '2012-09-08 18:00:00', 2),
(2577, 8, 21, '2012-09-08 08:00:00', 1),
(2578, 8, 3, '2012-09-08 08:30:00', 1),
(2579, 8, 22, '2012-09-08 09:00:00', 1),
(2580, 8, 0, '2012-09-08 09:30:00', 1),
(2581, 8, 16, '2012-09-08 10:00:00', 1),
(2582, 8, 3, '2012-09-08 10:30:00', 2),
(2583, 8, 0, '2012-09-08 11:30:00', 1),
(2584, 8, 6, '2012-09-08 13:00:00', 1),
(2585, 8, 22, '2012-09-08 15:30:00', 1),
(2586, 8, 16, '2012-09-08 16:30:00', 1),
(2587, 8, 7, '2012-09-08 17:00:00', 1),
(2588, 8, 3, '2012-09-08 17:30:00', 1),
(2589, 8, 8, '2012-09-08 19:30:00', 1),
(2590, 0, 5, '2012-09-09 08:00:00', 3),
(2591, 0, 16, '2012-09-09 09:30:00', 3),
(2592, 0, 26, '2012-09-09 12:00:00', 3),
(2593, 0, 7, '2012-09-09 15:00:00', 3),
(2594, 0, 0, '2012-09-09 17:00:00', 3),
(2595, 0, 24, '2012-09-09 18:30:00', 3),
(2596, 1, 8, '2012-09-09 08:00:00', 3),
(2597, 1, 0, '2012-09-09 10:00:00', 3),
(2598, 1, 16, '2012-09-09 13:00:00', 3),
(2599, 1, 10, '2012-09-09 14:30:00', 3),
(2600, 1, 15, '2012-09-09 16:00:00', 3),
(2601, 1, 0, '2012-09-09 17:30:00', 6),
(2602, 2, 21, '2012-09-09 08:30:00', 3),
(2603, 2, 1, '2012-09-09 11:00:00', 3),
(2604, 2, 1, '2012-09-09 13:00:00', 6),
(2605, 2, 5, '2012-09-09 16:30:00', 3),
(2606, 2, 14, '2012-09-09 18:30:00', 3),
(2607, 3, 22, '2012-09-09 09:00:00', 2),
(2608, 3, 10, '2012-09-09 10:00:00', 2),
(2609, 3, 20, '2012-09-09 13:00:00', 2),
(2610, 3, 0, '2012-09-09 15:30:00', 2),
(2611, 3, 21, '2012-09-09 16:30:00', 2),
(2612, 3, 0, '2012-09-09 18:00:00', 2),
(2613, 3, 6, '2012-09-09 19:00:00', 2),
(2614, 4, 13, '2012-09-09 08:00:00', 2),
(2615, 4, 7, '2012-09-09 09:00:00', 2),
(2616, 4, 20, '2012-09-09 10:00:00', 2),
(2617, 4, 0, '2012-09-09 11:00:00', 4),
(2618, 4, 3, '2012-09-09 13:30:00', 2),
(2619, 4, 11, '2012-09-09 14:30:00', 2),
(2620, 4, 20, '2012-09-09 15:30:00', 2),
(2621, 4, 0, '2012-09-09 17:00:00', 2),
(2622, 4, 11, '2012-09-09 18:00:00', 2),
(2623, 4, 13, '2012-09-09 19:00:00', 2),
(2624, 5, 0, '2012-09-09 14:00:00', 2),
(2625, 6, 0, '2012-09-09 08:30:00', 2),
(2626, 6, 0, '2012-09-09 11:00:00', 6),
(2627, 6, 12, '2012-09-09 14:00:00', 2),
(2628, 6, 14, '2012-09-09 15:30:00', 2),
(2629, 6, 0, '2012-09-09 16:30:00', 4),
(2630, 6, 26, '2012-09-09 18:30:00', 2),
(2631, 6, 21, '2012-09-09 19:30:00', 2),
(2632, 7, 22, '2012-09-09 08:00:00', 2),
(2633, 7, 22, '2012-09-09 10:30:00', 2),
(2634, 7, 21, '2012-09-09 14:00:00', 2),
(2635, 7, 4, '2012-09-09 17:00:00', 2),
(2636, 7, 7, '2012-09-09 18:00:00', 2),
(2637, 7, 4, '2012-09-09 19:30:00', 2),
(2638, 8, 16, '2012-09-09 08:00:00', 1),
(2639, 8, 0, '2012-09-09 08:30:00', 1),
(2640, 8, 16, '2012-09-09 09:00:00', 1),
(2641, 8, 3, '2012-09-09 09:30:00', 1),
(2642, 8, 2, '2012-09-09 10:00:00', 1),
(2643, 8, 21, '2012-09-09 10:30:00', 1),
(2644, 8, 5, '2012-09-09 11:00:00', 1),
(2645, 8, 15, '2012-09-09 11:30:00', 1),
(2646, 8, 3, '2012-09-09 12:00:00', 2),
(2647, 8, 0, '2012-09-09 13:00:00', 1),
(2648, 8, 0, '2012-09-09 14:30:00', 1),
(2649, 8, 16, '2012-09-09 16:30:00', 1),
(2650, 8, 9, '2012-09-09 17:00:00', 1),
(2651, 8, 17, '2012-09-09 17:30:00', 1),
(2652, 8, 6, '2012-09-09 18:00:00', 1),
(2653, 8, 3, '2012-09-09 18:30:00', 1),
(2654, 8, 16, '2012-09-09 19:00:00', 1),
(2655, 8, 3, '2012-09-09 19:30:00', 1),
(2656, 8, 16, '2012-09-09 20:00:00', 1),
(2657, 0, 22, '2012-09-10 10:30:00', 3),
(2658, 0, 14, '2012-09-10 12:00:00', 3),
(2659, 0, 0, '2012-09-10 13:30:00', 3),
(2660, 0, 14, '2012-09-10 15:30:00', 3),
(2661, 0, 10, '2012-09-10 18:30:00', 3),
(2662, 1, 24, '2012-09-10 08:00:00', 3),
(2663, 1, 0, '2012-09-10 09:30:00', 3),
(2664, 1, 0, '2012-09-10 13:00:00', 3),
(2665, 1, 15, '2012-09-10 14:30:00', 3),
(2666, 1, 0, '2012-09-10 16:00:00', 3),
(2667, 1, 12, '2012-09-10 17:30:00', 3),
(2668, 1, 0, '2012-09-10 19:00:00', 3),
(2669, 2, 1, '2012-09-10 09:00:00', 6),
(2670, 2, 21, '2012-09-10 12:00:00', 3),
(2671, 2, 21, '2012-09-10 14:00:00', 3),
(2672, 2, 0, '2012-09-10 15:30:00', 3),
(2673, 2, 6, '2012-09-10 19:00:00', 3),
(2674, 3, 6, '2012-09-10 08:30:00', 2),
(2675, 3, 15, '2012-09-10 09:30:00', 2),
(2676, 3, 15, '2012-09-10 11:00:00', 2),
(2677, 3, 15, '2012-09-10 13:00:00', 2),
(2678, 3, 16, '2012-09-10 15:00:00', 2),
(2679, 3, 2, '2012-09-10 16:30:00', 2),
(2680, 3, 16, '2012-09-10 17:30:00', 2),
(2681, 3, 17, '2012-09-10 18:30:00', 2),
(2682, 3, 15, '2012-09-10 19:30:00', 2),
(2683, 4, 4, '2012-09-10 08:00:00', 2),
(2684, 4, 13, '2012-09-10 09:00:00', 4),
(2685, 4, 20, '2012-09-10 11:30:00', 2),
(2686, 4, 11, '2012-09-10 12:30:00', 2),
(2687, 4, 1, '2012-09-10 13:30:00', 2),
(2688, 4, 10, '2012-09-10 14:30:00', 2),
(2689, 4, 12, '2012-09-10 15:30:00', 2),
(2690, 4, 17, '2012-09-10 17:00:00', 2),
(2691, 4, 14, '2012-09-10 18:00:00', 2),
(2692, 4, 0, '2012-09-10 19:00:00', 2),
(2693, 5, 0, '2012-09-10 10:00:00', 2),
(2694, 5, 0, '2012-09-10 11:30:00', 2),
(2695, 6, 0, '2012-09-10 08:30:00', 2),
(2696, 6, 11, '2012-09-10 09:30:00', 2),
(2697, 6, 8, '2012-09-10 11:00:00', 2),
(2698, 6, 12, '2012-09-10 12:30:00', 2),
(2699, 6, 0, '2012-09-10 14:00:00', 6),
(2700, 6, 0, '2012-09-10 17:30:00', 2),
(2701, 6, 12, '2012-09-10 19:00:00', 2),
(2702, 7, 22, '2012-09-10 09:30:00', 2),
(2703, 7, 4, '2012-09-10 11:30:00', 2),
(2704, 7, 24, '2012-09-10 15:00:00', 2),
(2705, 7, 10, '2012-09-10 16:00:00', 2),
(2706, 7, 15, '2012-09-10 17:30:00', 2),
(2707, 7, 4, '2012-09-10 18:30:00', 2),
(2708, 7, 7, '2012-09-10 19:30:00', 2),
(2709, 8, 15, '2012-09-10 08:30:00', 1),
(2710, 8, 26, '2012-09-10 10:30:00', 1),
(2711, 8, 5, '2012-09-10 12:00:00', 1),
(2712, 8, 16, '2012-09-10 12:30:00', 1),
(2713, 8, 2, '2012-09-10 13:00:00', 1),
(2714, 8, 16, '2012-09-10 13:30:00', 1),
(2715, 8, 3, '2012-09-10 15:00:00', 1),
(2716, 8, 21, '2012-09-10 15:30:00', 1),
(2717, 8, 24, '2012-09-10 16:00:00', 1),
(2718, 8, 16, '2012-09-10 16:30:00', 1),
(2719, 8, 21, '2012-09-10 17:30:00', 1),
(2720, 8, 3, '2012-09-10 19:30:00', 1),
(2721, 8, 21, '2012-09-10 20:00:00', 1),
(2722, 0, 5, '2012-09-11 09:00:00', 3),
(2723, 0, 6, '2012-09-11 10:30:00', 3),
(2724, 0, 7, '2012-09-11 12:00:00', 3),
(2725, 0, 17, '2012-09-11 14:30:00', 3),
(2726, 0, 11, '2012-09-11 16:00:00', 3),
(2727, 0, 26, '2012-09-11 19:00:00', 3),
(2728, 1, 9, '2012-09-11 08:00:00', 3),
(2729, 1, 11, '2012-09-11 09:30:00', 3),
(2730, 1, 8, '2012-09-11 11:00:00', 3),
(2731, 1, 12, '2012-09-11 12:30:00', 3),
(2732, 1, 11, '2012-09-11 14:30:00', 3),
(2733, 1, 9, '2012-09-11 16:00:00', 3),
(2734, 1, 11, '2012-09-11 17:30:00', 6),
(2735, 2, 2, '2012-09-11 11:00:00', 3),
(2736, 2, 1, '2012-09-11 12:30:00', 3),
(2737, 2, 8, '2012-09-11 14:00:00', 3),
(2738, 2, 21, '2012-09-11 17:00:00', 6),
(2739, 3, 22, '2012-09-11 08:00:00', 2),
(2740, 3, 16, '2012-09-11 09:30:00', 2),
(2741, 3, 21, '2012-09-11 11:00:00', 2),
(2742, 3, 6, '2012-09-11 12:00:00', 2),
(2743, 3, 15, '2012-09-11 13:30:00', 2),
(2744, 3, 2, '2012-09-11 18:00:00', 2),
(2745, 3, 6, '2012-09-11 19:30:00', 2),
(2746, 4, 3, '2012-09-11 08:00:00', 2),
(2747, 4, 6, '2012-09-11 09:00:00', 2),
(2748, 4, 0, '2012-09-11 10:00:00', 4),
(2749, 4, 13, '2012-09-11 12:30:00', 2),
(2750, 4, 16, '2012-09-11 13:30:00', 2),
(2751, 4, 3, '2012-09-11 14:30:00', 2),
(2752, 4, 0, '2012-09-11 15:30:00', 2),
(2753, 4, 8, '2012-09-11 16:30:00', 2),
(2754, 4, 0, '2012-09-11 18:00:00', 2),
(2755, 4, 14, '2012-09-11 19:00:00', 2),
(2756, 5, 0, '2012-09-11 11:30:00', 2),
(2757, 5, 0, '2012-09-11 18:00:00', 2),
(2758, 6, 12, '2012-09-11 08:00:00', 2),
(2759, 6, 0, '2012-09-11 09:00:00', 2),
(2760, 6, 12, '2012-09-11 10:30:00', 4),
(2761, 6, 0, '2012-09-11 12:30:00', 4),
(2762, 6, 16, '2012-09-11 14:30:00', 2),
(2763, 6, 0, '2012-09-11 15:30:00', 4),
(2764, 6, 12, '2012-09-11 17:30:00', 2),
(2765, 6, 0, '2012-09-11 18:30:00', 2),
(2766, 6, 12, '2012-09-11 19:30:00', 2),
(2767, 7, 10, '2012-09-11 08:30:00', 2),
(2768, 7, 13, '2012-09-11 09:30:00', 2),
(2769, 7, 7, '2012-09-11 11:00:00', 2),
(2770, 7, 6, '2012-09-11 13:30:00', 2),
(2771, 7, 4, '2012-09-11 14:30:00', 2),
(2772, 7, 24, '2012-09-11 16:30:00', 2),
(2773, 7, 10, '2012-09-11 18:00:00', 2),
(2774, 7, 15, '2012-09-11 19:00:00', 2),
(2775, 8, 24, '2012-09-11 08:30:00', 1),
(2776, 8, 3, '2012-09-11 09:00:00', 1),
(2777, 8, 21, '2012-09-11 09:30:00', 1),
(2778, 8, 0, '2012-09-11 10:30:00', 1),
(2779, 8, 16, '2012-09-11 11:00:00', 1),
(2780, 8, 3, '2012-09-11 12:00:00', 2),
(2781, 8, 21, '2012-09-11 13:00:00', 1),
(2782, 8, 21, '2012-09-11 14:00:00', 2),
(2783, 8, 22, '2012-09-11 15:00:00', 1),
(2784, 8, 8, '2012-09-11 15:30:00', 1),
(2785, 8, 3, '2012-09-11 17:00:00', 2),
(2786, 8, 3, '2012-09-11 18:30:00', 2),
(2787, 0, 22, '2012-09-12 08:30:00', 3),
(2788, 0, 0, '2012-09-12 10:00:00', 3),
(2789, 0, 4, '2012-09-12 11:30:00', 3),
(2790, 0, 26, '2012-09-12 13:00:00', 3),
(2791, 0, 5, '2012-09-12 15:00:00', 3),
(2792, 0, 0, '2012-09-12 16:30:00', 3),
(2793, 0, 16, '2012-09-12 18:00:00', 3),
(2794, 1, 11, '2012-09-12 08:30:00', 3),
(2795, 1, 0, '2012-09-12 10:00:00', 3),
(2796, 1, 14, '2012-09-12 12:00:00', 3),
(2797, 1, 11, '2012-09-12 13:30:00', 3),
(2798, 1, 0, '2012-09-12 15:00:00', 6),
(2799, 1, 10, '2012-09-12 18:30:00', 3),
(2800, 2, 24, '2012-09-12 08:00:00', 3),
(2801, 2, 12, '2012-09-12 09:30:00', 3),
(2802, 2, 9, '2012-09-12 11:00:00', 3),
(2803, 2, 13, '2012-09-12 14:30:00', 3),
(2804, 2, 9, '2012-09-12 16:00:00', 3),
(2805, 2, 2, '2012-09-12 17:30:00', 6),
(2806, 3, 15, '2012-09-12 09:00:00', 2),
(2807, 3, 20, '2012-09-12 12:30:00', 2),
(2808, 3, 10, '2012-09-12 13:30:00', 2),
(2809, 3, 3, '2012-09-12 14:30:00', 2),
(2810, 3, 16, '2012-09-12 15:30:00', 2),
(2811, 3, 0, '2012-09-12 19:00:00', 2),
(2812, 4, 16, '2012-09-12 08:00:00', 2),
(2813, 4, 0, '2012-09-12 09:00:00', 2),
(2814, 4, 0, '2012-09-12 10:30:00', 2),
(2815, 4, 13, '2012-09-12 11:30:00', 2),
(2816, 4, 0, '2012-09-12 12:30:00', 4),
(2817, 4, 16, '2012-09-12 14:30:00', 2),
(2818, 4, 0, '2012-09-12 15:30:00', 2),
(2819, 4, 3, '2012-09-12 16:30:00', 2),
(2820, 4, 1, '2012-09-12 17:30:00', 2),
(2821, 4, 7, '2012-09-12 19:00:00', 2),
(2822, 5, 0, '2012-09-12 16:30:00', 2),
(2823, 6, 0, '2012-09-12 08:30:00', 4),
(2824, 6, 0, '2012-09-12 11:00:00', 6),
(2825, 6, 24, '2012-09-12 14:00:00', 2),
(2826, 6, 0, '2012-09-12 15:00:00', 4),
(2827, 6, 0, '2012-09-12 17:30:00', 4),
(2828, 7, 5, '2012-09-12 08:30:00', 2),
(2829, 7, 4, '2012-09-12 09:30:00', 2),
(2830, 7, 15, '2012-09-12 10:30:00', 2),
(2831, 7, 24, '2012-09-12 13:00:00', 2),
(2832, 7, 7, '2012-09-12 15:30:00', 2),
(2833, 7, 22, '2012-09-12 17:30:00', 2),
(2834, 8, 1, '2012-09-12 10:00:00', 1),
(2835, 8, 16, '2012-09-12 11:00:00', 1),
(2836, 8, 3, '2012-09-12 11:30:00', 1),
(2837, 8, 16, '2012-09-12 12:00:00', 1),
(2838, 8, 21, '2012-09-12 12:30:00', 2),
(2839, 8, 1, '2012-09-12 13:30:00', 1),
(2840, 8, 5, '2012-09-12 14:00:00', 1),
(2841, 8, 2, '2012-09-12 14:30:00', 1),
(2842, 8, 22, '2012-09-12 15:30:00', 1),
(2843, 8, 3, '2012-09-12 16:00:00', 1),
(2844, 8, 4, '2012-09-12 18:00:00', 1),
(2845, 8, 21, '2012-09-12 18:30:00', 2),
(2846, 0, 5, '2012-09-13 09:00:00', 3),
(2847, 0, 0, '2012-09-13 10:30:00', 6),
(2848, 0, 7, '2012-09-13 13:30:00', 3),
(2849, 0, 10, '2012-09-13 16:00:00', 3),
(2850, 0, 0, '2012-09-13 17:30:00', 6),
(2851, 1, 8, '2012-09-13 08:30:00', 3),
(2852, 1, 11, '2012-09-13 10:30:00', 3),
(2853, 1, 0, '2012-09-13 12:00:00', 6),
(2854, 1, 12, '2012-09-13 15:00:00', 3),
(2855, 1, 8, '2012-09-13 16:30:00', 3),
(2856, 1, 24, '2012-09-13 18:30:00', 3),
(2857, 2, 11, '2012-09-13 08:00:00', 3),
(2858, 2, 1, '2012-09-13 09:30:00', 3),
(2859, 2, 2, '2012-09-13 11:00:00', 3),
(2860, 2, 10, '2012-09-13 13:00:00', 3),
(2861, 2, 15, '2012-09-13 14:30:00', 3),
(2862, 2, 21, '2012-09-13 16:30:00', 3),
(2863, 2, 11, '2012-09-13 18:00:00', 3),
(2864, 3, 16, '2012-09-13 08:00:00', 2),
(2865, 3, 3, '2012-09-13 09:00:00', 2),
(2866, 3, 17, '2012-09-13 10:00:00', 2),
(2867, 3, 22, '2012-09-13 11:30:00', 2),
(2868, 3, 24, '2012-09-13 13:00:00', 2),
(2869, 3, 3, '2012-09-13 14:00:00', 2),
(2870, 3, 11, '2012-09-13 16:00:00', 2),
(2871, 3, 3, '2012-09-13 17:30:00', 2),
(2872, 3, 17, '2012-09-13 18:30:00', 2),
(2873, 3, 4, '2012-09-13 19:30:00', 2),
(2874, 4, 7, '2012-09-13 08:00:00', 2),
(2875, 4, 20, '2012-09-13 09:00:00', 2),
(2876, 4, 6, '2012-09-13 10:30:00', 2),
(2877, 4, 5, '2012-09-13 11:30:00', 2),
(2878, 4, 21, '2012-09-13 12:30:00', 2),
(2879, 4, 20, '2012-09-13 14:00:00', 2),
(2880, 4, 9, '2012-09-13 15:30:00', 2),
(2881, 4, 20, '2012-09-13 17:00:00', 2),
(2882, 4, 0, '2012-09-13 18:00:00', 2),
(2883, 4, 5, '2012-09-13 19:00:00', 2),
(2884, 5, 0, '2012-09-13 08:30:00', 2),
(2885, 5, 0, '2012-09-13 16:00:00', 2),
(2886, 5, 0, '2012-09-13 19:00:00', 2),
(2887, 6, 12, '2012-09-13 09:00:00', 2),
(2888, 6, 0, '2012-09-13 10:30:00', 14),
(2889, 6, 0, '2012-09-13 18:00:00', 2),
(2890, 6, 6, '2012-09-13 19:30:00', 2),
(2891, 7, 14, '2012-09-13 08:00:00', 2),
(2892, 7, 4, '2012-09-13 09:30:00', 2),
(2893, 7, 17, '2012-09-13 12:30:00', 2),
(2894, 7, 5, '2012-09-13 13:30:00', 2),
(2895, 7, 4, '2012-09-13 14:30:00', 2),
(2896, 7, 15, '2012-09-13 17:00:00', 2),
(2897, 7, 0, '2012-09-13 18:00:00', 2),
(2898, 7, 9, '2012-09-13 19:00:00', 2),
(2899, 8, 20, '2012-09-13 08:00:00', 1),
(2900, 8, 15, '2012-09-13 09:00:00', 1),
(2901, 8, 21, '2012-09-13 09:30:00', 1),
(2902, 8, 21, '2012-09-13 10:30:00', 1),
(2903, 8, 16, '2012-09-13 11:00:00', 1),
(2904, 8, 21, '2012-09-13 11:30:00', 1),
(2905, 8, 0, '2012-09-13 12:00:00', 1),
(2906, 8, 24, '2012-09-13 12:30:00', 1),
(2907, 8, 3, '2012-09-13 13:30:00', 1),
(2908, 8, 16, '2012-09-13 14:30:00', 1),
(2909, 8, 21, '2012-09-13 15:00:00', 1),
(2910, 8, 21, '2012-09-13 16:00:00', 1),
(2911, 8, 16, '2012-09-13 18:00:00', 1),
(2912, 8, 21, '2012-09-13 18:30:00', 1),
(2913, 8, 0, '2012-09-13 19:00:00', 1),
(2914, 8, 21, '2012-09-13 19:30:00', 1),
(2915, 8, 15, '2012-09-13 20:00:00', 1),
(2916, 0, 6, '2012-09-14 08:00:00', 3),
(2917, 0, 17, '2012-09-14 10:00:00', 3),
(2918, 0, 5, '2012-09-14 12:30:00', 3),
(2919, 0, 3, '2012-09-14 14:00:00', 3),
(2920, 0, 0, '2012-09-14 16:00:00', 3),
(2921, 0, 26, '2012-09-14 17:30:00', 3),
(2922, 0, 0, '2012-09-14 19:00:00', 3),
(2923, 1, 11, '2012-09-14 08:00:00', 6),
(2924, 1, 8, '2012-09-14 11:00:00', 6),
(2925, 1, 0, '2012-09-14 14:00:00', 3),
(2926, 1, 0, '2012-09-14 17:00:00', 6),
(2927, 2, 1, '2012-09-14 08:00:00', 3),
(2928, 2, 21, '2012-09-14 11:00:00', 3),
(2929, 2, 1, '2012-09-14 13:00:00', 3),
(2930, 2, 5, '2012-09-14 16:00:00', 3),
(2931, 2, 9, '2012-09-14 18:00:00', 3),
(2932, 3, 15, '2012-09-14 08:30:00', 2),
(2933, 3, 16, '2012-09-14 11:00:00', 2),
(2934, 3, 20, '2012-09-14 12:30:00', 2),
(2935, 3, 21, '2012-09-14 18:30:00', 2),
(2936, 4, 14, '2012-09-14 08:00:00', 2),
(2937, 4, 0, '2012-09-14 09:00:00', 2),
(2938, 4, 13, '2012-09-14 11:00:00', 2),
(2939, 4, 9, '2012-09-14 12:00:00', 2),
(2940, 4, 0, '2012-09-14 13:00:00', 2),
(2941, 4, 13, '2012-09-14 14:00:00', 4),
(2942, 4, 0, '2012-09-14 16:00:00', 2),
(2943, 4, 6, '2012-09-14 18:00:00', 2),
(2944, 4, 20, '2012-09-14 19:00:00', 2),
(2945, 5, 15, '2012-09-14 09:30:00', 2),
(2946, 5, 0, '2012-09-14 11:00:00', 4),
(2947, 6, 12, '2012-09-14 08:30:00', 2),
(2948, 6, 0, '2012-09-14 09:30:00', 4),
(2949, 6, 0, '2012-09-14 12:30:00', 2),
(2950, 6, 16, '2012-09-14 14:00:00', 2),
(2951, 6, 0, '2012-09-14 15:00:00', 2),
(2952, 6, 12, '2012-09-14 16:00:00', 2),
(2953, 6, 17, '2012-09-14 17:30:00', 2),
(2954, 7, 10, '2012-09-14 08:30:00', 2),
(2955, 7, 24, '2012-09-14 12:00:00', 2),
(2956, 7, 9, '2012-09-14 13:30:00', 2),
(2957, 7, 21, '2012-09-14 16:30:00', 2),
(2958, 7, 24, '2012-09-14 18:00:00', 2),
(2959, 8, 3, '2012-09-14 08:00:00', 1),
(2960, 8, 16, '2012-09-14 08:30:00', 1),
(2961, 8, 2, '2012-09-14 09:00:00', 1),
(2962, 8, 21, '2012-09-14 09:30:00', 1),
(2963, 8, 3, '2012-09-14 10:00:00', 1),
(2964, 8, 9, '2012-09-14 10:30:00', 1),
(2965, 8, 3, '2012-09-14 11:00:00', 2),
(2966, 8, 20, '2012-09-14 12:00:00', 1),
(2967, 8, 21, '2012-09-14 13:00:00', 1),
(2968, 8, 16, '2012-09-14 13:30:00', 1),
(2969, 8, 24, '2012-09-14 14:00:00', 1),
(2970, 8, 20, '2012-09-14 15:00:00', 1),
(2971, 8, 22, '2012-09-14 15:30:00', 1),
(2972, 8, 16, '2012-09-14 16:00:00', 1),
(2973, 8, 3, '2012-09-14 16:30:00', 1),
(2974, 8, 15, '2012-09-14 17:00:00', 1),
(2975, 8, 16, '2012-09-14 17:30:00', 2),
(2976, 8, 11, '2012-09-14 19:00:00', 1),
(2977, 8, 2, '2012-09-14 19:30:00', 1),
(2978, 0, 0, '2012-09-15 08:00:00', 12),
(2979, 0, 11, '2012-09-15 14:00:00', 3),
(2980, 0, 7, '2012-09-15 16:30:00', 3),
(2981, 0, 17, '2012-09-15 18:00:00', 3),
(2982, 1, 10, '2012-09-15 08:00:00', 3),
(2983, 1, 11, '2012-09-15 10:00:00', 3),
(2984, 1, 24, '2012-09-15 13:00:00', 6),
(2985, 1, 12, '2012-09-15 16:00:00', 3),
(2986, 2, 0, '2012-09-15 08:00:00', 3),
(2987, 2, 1, '2012-09-15 10:30:00', 3),
(2988, 2, 0, '2012-09-15 12:00:00', 3),
(2989, 2, 14, '2012-09-15 13:30:00', 3),
(2990, 2, 26, '2012-09-15 15:30:00', 3),
(2991, 2, 0, '2012-09-15 17:30:00', 3),
(2992, 3, 1, '2012-09-15 08:00:00', 2),
(2993, 3, 14, '2012-09-15 09:30:00', 2),
(2994, 3, 22, '2012-09-15 10:30:00', 2),
(2995, 3, 21, '2012-09-15 11:30:00', 2),
(2996, 3, 20, '2012-09-15 12:30:00', 2),
(2997, 3, 3, '2012-09-15 14:30:00', 2),
(2998, 3, 11, '2012-09-15 15:30:00', 2),
(2999, 3, 0, '2012-09-15 17:30:00', 2),
(3000, 3, 11, '2012-09-15 19:30:00', 2),
(3001, 4, 13, '2012-09-15 08:00:00', 2),
(3002, 4, 0, '2012-09-15 09:00:00', 2),
(3003, 4, 17, '2012-09-15 10:00:00', 2),
(3004, 4, 3, '2012-09-15 11:00:00', 2),
(3005, 4, 0, '2012-09-15 12:00:00', 8),
(3006, 4, 24, '2012-09-15 16:00:00', 2),
(3007, 4, 16, '2012-09-15 17:00:00', 4),
(3008, 4, 14, '2012-09-15 19:00:00', 2),
(3009, 5, 0, '2012-09-15 12:30:00', 2),
(3010, 6, 0, '2012-09-15 08:00:00', 2),
(3011, 6, 0, '2012-09-15 09:30:00', 4),
(3012, 6, 11, '2012-09-15 11:30:00', 2),
(3013, 6, 22, '2012-09-15 12:30:00', 2),
(3014, 6, 12, '2012-09-15 14:00:00', 2),
(3015, 6, 1, '2012-09-15 15:00:00', 2),
(3016, 6, 4, '2012-09-15 16:00:00', 2),
(3017, 6, 15, '2012-09-15 17:30:00', 2),
(3018, 6, 0, '2012-09-15 18:30:00', 4),
(3019, 7, 17, '2012-09-15 08:30:00', 2),
(3020, 7, 2, '2012-09-15 09:30:00', 2),
(3021, 7, 8, '2012-09-15 10:30:00', 2),
(3022, 7, 15, '2012-09-15 13:00:00', 2),
(3023, 7, 22, '2012-09-15 14:00:00', 2),
(3024, 7, 13, '2012-09-15 15:00:00', 2),
(3025, 7, 10, '2012-09-15 16:00:00', 2),
(3026, 7, 13, '2012-09-15 19:30:00', 2),
(3027, 8, 21, '2012-09-15 08:00:00', 1),
(3028, 8, 16, '2012-09-15 08:30:00', 1),
(3029, 8, 15, '2012-09-15 09:00:00', 1),
(3030, 8, 16, '2012-09-15 09:30:00', 1),
(3031, 8, 15, '2012-09-15 10:30:00', 1),
(3032, 8, 16, '2012-09-15 11:00:00', 2),
(3033, 8, 3, '2012-09-15 12:00:00', 1),
(3034, 8, 21, '2012-09-15 12:30:00', 2),
(3035, 8, 6, '2012-09-15 13:30:00', 1),
(3036, 8, 15, '2012-09-15 15:00:00', 1),
(3037, 8, 6, '2012-09-15 15:30:00', 1),
(3038, 8, 21, '2012-09-15 16:30:00', 1),
(3039, 8, 21, '2012-09-15 19:00:00', 1),
(3040, 8, 3, '2012-09-15 19:30:00', 1),
(3041, 0, 0, '2012-09-16 08:00:00', 9),
(3042, 0, 11, '2012-09-16 12:30:00', 3),
(3043, 0, 6, '2012-09-16 14:00:00', 3),
(3044, 0, 0, '2012-09-16 15:30:00', 3),
(3045, 0, 24, '2012-09-16 17:00:00', 3),
(3046, 0, 10, '2012-09-16 18:30:00', 3),
(3047, 1, 8, '2012-09-16 08:00:00', 3),
(3048, 1, 0, '2012-09-16 09:30:00', 6),
(3049, 1, 16, '2012-09-16 12:30:00', 3),
(3050, 1, 8, '2012-09-16 14:00:00', 3),
(3051, 1, 12, '2012-09-16 15:30:00', 3),
(3052, 1, 0, '2012-09-16 17:30:00', 6),
(3053, 2, 2, '2012-09-16 08:30:00', 3),
(3054, 2, 1, '2012-09-16 10:30:00', 3),
(3055, 2, 12, '2012-09-16 12:00:00', 3),
(3056, 2, 21, '2012-09-16 13:30:00', 3),
(3057, 2, 7, '2012-09-16 15:30:00', 3),
(3058, 2, 21, '2012-09-16 17:00:00', 3),
(3059, 2, 21, '2012-09-16 19:00:00', 3),
(3060, 3, 1, '2012-09-16 09:00:00', 2),
(3061, 3, 14, '2012-09-16 10:00:00', 2),
(3062, 3, 0, '2012-09-16 13:00:00', 2),
(3063, 3, 22, '2012-09-16 16:30:00', 2),
(3064, 3, 16, '2012-09-16 17:30:00', 2),
(3065, 3, 15, '2012-09-16 18:30:00', 2),
(3066, 4, 1, '2012-09-16 08:00:00', 2),
(3067, 4, 0, '2012-09-16 09:00:00', 2),
(3068, 4, 8, '2012-09-16 10:00:00', 4),
(3069, 4, 13, '2012-09-16 12:00:00', 4),
(3070, 4, 3, '2012-09-16 14:00:00', 4),
(3071, 4, 0, '2012-09-16 16:00:00', 2),
(3072, 4, 0, '2012-09-16 17:30:00', 4),
(3073, 4, 14, '2012-09-16 19:30:00', 2),
(3074, 5, 22, '2012-09-16 08:30:00', 2),
(3075, 6, 11, '2012-09-16 08:00:00', 2),
(3076, 6, 0, '2012-09-16 09:00:00', 2),
(3077, 6, 12, '2012-09-16 10:30:00', 2),
(3078, 6, 2, '2012-09-16 12:00:00', 2),
(3079, 6, 10, '2012-09-16 13:30:00', 2),
(3080, 6, 0, '2012-09-16 14:30:00', 4),
(3081, 6, 0, '2012-09-16 17:30:00', 6),
(3082, 7, 10, '2012-09-16 08:30:00', 2),
(3083, 7, 10, '2012-09-16 10:30:00', 2),
(3084, 7, 9, '2012-09-16 11:30:00', 2),
(3085, 7, 15, '2012-09-16 12:30:00', 2),
(3086, 7, 13, '2012-09-16 14:00:00', 2),
(3087, 7, 8, '2012-09-16 15:30:00', 2),
(3088, 7, 27, '2012-09-16 16:30:00', 2),
(3089, 7, 27, '2012-09-16 19:00:00', 2),
(3090, 8, 21, '2012-09-16 09:30:00', 1),
(3091, 8, 3, '2012-09-16 10:30:00', 2),
(3092, 8, 21, '2012-09-16 12:00:00', 1),
(3093, 8, 27, '2012-09-16 13:30:00', 1),
(3094, 8, 16, '2012-09-16 14:30:00', 1),
(3095, 8, 21, '2012-09-16 15:00:00', 1),
(3096, 8, 27, '2012-09-16 15:30:00', 1),
(3097, 8, 16, '2012-09-16 16:30:00', 1),
(3098, 8, 3, '2012-09-16 17:00:00', 1),
(3099, 8, 3, '2012-09-16 18:00:00', 1),
(3100, 8, 2, '2012-09-16 19:00:00', 1),
(3101, 8, 3, '2012-09-16 20:00:00', 1),
(3102, 0, 22, '2012-09-17 08:00:00', 3),
(3103, 0, 0, '2012-09-17 09:30:00', 3),
(3104, 0, 13, '2012-09-17 11:00:00', 3),
(3105, 0, 7, '2012-09-17 14:00:00', 3),
(3106, 0, 0, '2012-09-17 16:30:00', 3),
(3107, 0, 26, '2012-09-17 18:00:00', 3),
(3108, 1, 8, '2012-09-17 08:30:00', 3),
(3109, 1, 9, '2012-09-17 10:00:00', 3),
(3110, 1, 0, '2012-09-17 11:30:00', 3),
(3111, 1, 0, '2012-09-17 13:30:00', 3),
(3112, 1, 8, '2012-09-17 16:00:00', 3),
(3113, 1, 9, '2012-09-17 17:30:00', 3),
(3114, 1, 8, '2012-09-17 19:00:00', 3),
(3115, 2, 5, '2012-09-17 08:30:00', 3),
(3116, 2, 12, '2012-09-17 10:00:00', 3),
(3117, 2, 21, '2012-09-17 12:00:00', 3),
(3118, 2, 12, '2012-09-17 13:30:00', 3),
(3119, 2, 0, '2012-09-17 15:00:00', 3),
(3120, 2, 1, '2012-09-17 18:00:00', 3),
(3121, 3, 21, '2012-09-17 08:30:00', 2),
(3122, 3, 22, '2012-09-17 09:30:00', 4),
(3123, 3, 15, '2012-09-17 12:00:00', 2),
(3124, 3, 22, '2012-09-17 14:00:00', 2),
(3125, 3, 16, '2012-09-17 16:30:00', 2),
(3126, 3, 13, '2012-09-17 17:30:00', 2),
(3127, 3, 3, '2012-09-17 18:30:00', 2),
(3128, 4, 7, '2012-09-17 08:00:00', 2),
(3129, 4, 0, '2012-09-17 09:30:00', 2),
(3130, 4, 0, '2012-09-17 11:00:00', 4),
(3131, 4, 10, '2012-09-17 13:00:00', 2),
(3132, 4, 20, '2012-09-17 14:30:00', 2),
(3133, 4, 16, '2012-09-17 15:30:00', 2),
(3134, 4, 0, '2012-09-17 16:30:00', 2),
(3135, 4, 5, '2012-09-17 17:30:00', 2),
(3136, 4, 14, '2012-09-17 18:30:00', 2),
(3137, 4, 0, '2012-09-17 19:30:00', 2),
(3138, 5, 0, '2012-09-17 12:00:00', 2),
(3139, 5, 24, '2012-09-17 15:00:00', 2),
(3140, 6, 0, '2012-09-17 08:00:00', 4),
(3141, 6, 0, '2012-09-17 10:30:00', 4),
(3142, 6, 5, '2012-09-17 12:30:00', 2),
(3143, 6, 0, '2012-09-17 13:30:00', 2),
(3144, 6, 0, '2012-09-17 15:00:00', 8),
(3145, 7, 10, '2012-09-17 08:00:00', 2),
(3146, 7, 21, '2012-09-17 10:00:00', 2),
(3147, 7, 17, '2012-09-17 11:00:00', 2),
(3148, 7, 15, '2012-09-17 14:00:00', 2),
(3149, 7, 0, '2012-09-17 15:00:00', 2),
(3150, 7, 22, '2012-09-17 16:30:00', 2),
(3151, 7, 20, '2012-09-17 18:30:00', 2),
(3152, 7, 1, '2012-09-17 19:30:00', 2),
(3153, 8, 15, '2012-09-17 09:30:00', 1),
(3154, 8, 16, '2012-09-17 11:00:00', 1),
(3155, 8, 0, '2012-09-17 12:00:00', 1),
(3156, 8, 8, '2012-09-17 12:30:00', 1),
(3157, 8, 1, '2012-09-17 13:30:00', 1),
(3158, 8, 11, '2012-09-17 14:00:00', 1),
(3159, 8, 3, '2012-09-17 15:00:00', 1),
(3160, 8, 1, '2012-09-17 15:30:00', 1),
(3161, 8, 2, '2012-09-17 16:00:00', 1),
(3162, 8, 21, '2012-09-17 16:30:00', 1),
(3163, 8, 3, '2012-09-17 17:00:00', 1),
(3164, 8, 21, '2012-09-17 17:30:00', 1),
(3165, 8, 21, '2012-09-17 19:00:00', 1),
(3166, 8, 2, '2012-09-17 20:00:00', 1),
(3167, 0, 28, '2012-09-18 09:00:00', 3),
(3168, 0, 6, '2012-09-18 10:30:00', 3),
(3169, 0, 11, '2012-09-18 12:00:00', 3),
(3170, 0, 16, '2012-09-18 13:30:00', 3),
(3171, 0, 5, '2012-09-18 16:00:00', 3),
(3172, 0, 28, '2012-09-18 17:30:00', 3),
(3173, 0, 14, '2012-09-18 19:00:00', 3),
(3174, 1, 10, '2012-09-18 08:00:00', 3),
(3175, 1, 12, '2012-09-18 09:30:00', 6),
(3176, 1, 0, '2012-09-18 13:30:00', 3),
(3177, 1, 11, '2012-09-18 16:00:00', 3),
(3178, 1, 10, '2012-09-18 18:00:00', 3),
(3179, 2, 16, '2012-09-18 08:00:00', 3),
(3180, 2, 21, '2012-09-18 10:00:00', 3),
(3181, 2, 21, '2012-09-18 13:00:00', 3),
(3182, 2, 1, '2012-09-18 14:30:00', 3),
(3183, 2, 24, '2012-09-18 16:00:00', 3),
(3184, 2, 13, '2012-09-18 17:30:00', 3),
(3185, 3, 3, '2012-09-18 08:00:00', 4),
(3186, 3, 20, '2012-09-18 10:00:00', 2),
(3187, 3, 13, '2012-09-18 11:30:00', 2),
(3188, 3, 3, '2012-09-18 13:00:00', 4),
(3189, 3, 21, '2012-09-18 17:00:00', 2),
(3190, 3, 15, '2012-09-18 18:00:00', 2),
(3191, 3, 3, '2012-09-18 19:30:00', 2),
(3192, 4, 5, '2012-09-18 08:30:00', 2),
(3193, 4, 0, '2012-09-18 09:30:00', 2),
(3194, 4, 13, '2012-09-18 10:30:00', 2),
(3195, 4, 1, '2012-09-18 11:30:00', 2),
(3196, 4, 13, '2012-09-18 12:30:00', 2),
(3197, 4, 0, '2012-09-18 15:00:00', 2),
(3198, 4, 13, '2012-09-18 16:00:00', 2),
(3199, 4, 0, '2012-09-18 17:00:00', 2),
(3200, 4, 4, '2012-09-18 18:00:00', 2),
(3201, 4, 0, '2012-09-18 19:00:00', 2),
(3202, 5, 0, '2012-09-18 08:30:00', 2),
(3203, 5, 0, '2012-09-18 18:00:00', 2),
(3204, 6, 0, '2012-09-18 08:30:00', 2),
(3205, 6, 9, '2012-09-18 09:30:00', 2),
(3206, 6, 0, '2012-09-18 11:00:00', 2),
(3207, 6, 8, '2012-09-18 14:00:00', 2),
(3208, 6, 0, '2012-09-18 15:00:00', 6),
(3209, 6, 0, '2012-09-18 18:30:00', 4),
(3210, 7, 7, '2012-09-18 10:00:00', 2),
(3211, 7, 0, '2012-09-18 11:00:00', 2),
(3212, 7, 27, '2012-09-18 16:00:00', 2),
(3213, 7, 8, '2012-09-18 18:00:00', 2),
(3214, 8, 21, '2012-09-18 08:30:00', 1),
(3215, 8, 15, '2012-09-18 10:00:00', 1),
(3216, 8, 0, '2012-09-18 10:30:00', 1),
(3217, 8, 7, '2012-09-18 11:00:00', 1),
(3218, 8, 3, '2012-09-18 12:00:00', 1),
(3219, 8, 28, '2012-09-18 13:30:00', 1),
(3220, 8, 15, '2012-09-18 14:00:00', 1),
(3221, 8, 4, '2012-09-18 14:30:00', 1),
(3222, 8, 24, '2012-09-18 15:30:00', 1),
(3223, 8, 3, '2012-09-18 16:00:00', 1),
(3224, 8, 21, '2012-09-18 16:30:00', 1),
(3225, 8, 9, '2012-09-18 17:00:00', 1),
(3226, 8, 0, '2012-09-18 17:30:00', 1),
(3227, 8, 3, '2012-09-18 18:00:00', 1),
(3228, 8, 0, '2012-09-18 19:00:00', 1),
(3229, 8, 28, '2012-09-18 20:00:00', 1),
(3230, 0, 16, '2012-09-19 08:00:00', 3),
(3231, 0, 28, '2012-09-19 09:30:00', 3),
(3232, 0, 0, '2012-09-19 11:00:00', 6),
(3233, 0, 28, '2012-09-19 15:00:00', 3),
(3234, 0, 24, '2012-09-19 16:30:00', 3),
(3235, 0, 14, '2012-09-19 18:00:00', 3),
(3236, 1, 0, '2012-09-19 09:30:00', 3),
(3237, 1, 1, '2012-09-19 11:00:00', 3),
(3238, 1, 0, '2012-09-19 13:00:00', 3),
(3239, 1, 4, '2012-09-19 16:00:00', 3),
(3240, 1, 10, '2012-09-19 18:00:00', 3),
(3241, 2, 1, '2012-09-19 08:00:00', 3),
(3242, 2, 16, '2012-09-19 10:00:00', 3),
(3243, 2, 9, '2012-09-19 11:30:00', 3),
(3244, 2, 21, '2012-09-19 13:00:00', 3),
(3245, 2, 29, '2012-09-19 14:30:00', 3),
(3246, 2, 30, '2012-09-19 17:00:00', 3),
(3247, 3, 22, '2012-09-19 08:00:00', 2),
(3248, 3, 15, '2012-09-19 09:30:00', 2),
(3249, 3, 3, '2012-09-19 10:30:00', 2),
(3250, 3, 3, '2012-09-19 12:00:00', 2),
(3251, 3, 2, '2012-09-19 13:00:00', 2),
(3252, 3, 1, '2012-09-19 16:00:00', 2),
(3253, 3, 21, '2012-09-19 19:00:00', 2),
(3254, 4, 20, '2012-09-19 08:00:00', 2),
(3255, 4, 5, '2012-09-19 09:00:00', 2),
(3256, 4, 0, '2012-09-19 10:00:00', 4),
(3257, 4, 5, '2012-09-19 12:00:00', 2),
(3258, 4, 0, '2012-09-19 13:30:00', 6),
(3259, 4, 16, '2012-09-19 17:00:00', 2),
(3260, 4, 0, '2012-09-19 18:00:00', 2),
(3261, 4, 13, '2012-09-19 19:00:00', 2),
(3262, 5, 10, '2012-09-19 10:30:00', 2),
(3263, 5, 7, '2012-09-19 12:30:00', 2),
(3264, 5, 0, '2012-09-19 13:30:00', 2),
(3265, 5, 0, '2012-09-19 15:30:00', 2),
(3266, 5, 0, '2012-09-19 19:30:00', 2),
(3267, 6, 0, '2012-09-19 08:00:00', 2),
(3268, 6, 8, '2012-09-19 09:00:00', 2),
(3269, 6, 14, '2012-09-19 10:00:00', 4),
(3270, 6, 0, '2012-09-19 12:30:00', 2),
(3271, 6, 12, '2012-09-19 13:30:00', 2),
(3272, 6, 0, '2012-09-19 15:00:00', 2),
(3273, 6, 12, '2012-09-19 16:30:00', 2),
(3274, 6, 4, '2012-09-19 17:30:00', 2),
(3275, 7, 10, '2012-09-19 08:00:00', 2),
(3276, 7, 27, '2012-09-19 09:30:00', 2),
(3277, 7, 15, '2012-09-19 10:30:00', 2),
(3278, 7, 4, '2012-09-19 13:00:00', 4),
(3279, 7, 27, '2012-09-19 15:00:00', 2),
(3280, 7, 15, '2012-09-19 16:30:00', 2),
(3281, 7, 6, '2012-09-19 18:00:00', 2),
(3282, 8, 21, '2012-09-19 08:00:00', 1),
(3283, 8, 3, '2012-09-19 08:30:00', 2),
(3284, 8, 29, '2012-09-19 09:30:00', 1),
(3285, 8, 3, '2012-09-19 10:00:00', 1),
(3286, 8, 12, '2012-09-19 10:30:00', 1),
(3287, 8, 30, '2012-09-19 11:30:00', 1),
(3288, 8, 28, '2012-09-19 12:00:00', 1),
(3289, 8, 29, '2012-09-19 12:30:00', 1),
(3290, 8, 24, '2012-09-19 13:30:00', 1),
(3291, 8, 29, '2012-09-19 14:00:00', 1),
(3292, 8, 16, '2012-09-19 14:30:00', 2),
(3293, 8, 22, '2012-09-19 17:30:00', 1),
(3294, 8, 29, '2012-09-19 18:00:00', 1),
(3295, 8, 3, '2012-09-19 18:30:00', 1),
(3296, 8, 8, '2012-09-19 19:00:00', 1),
(3297, 8, 15, '2012-09-19 19:30:00', 1),
(3298, 0, 14, '2012-09-20 08:00:00', 3),
(3299, 0, 0, '2012-09-20 09:30:00', 6),
(3300, 0, 0, '2012-09-20 13:00:00', 3),
(3301, 0, 17, '2012-09-20 15:30:00', 3),
(3302, 0, 26, '2012-09-20 17:00:00', 3),
(3303, 0, 5, '2012-09-20 18:30:00', 3),
(3304, 1, 11, '2012-09-20 08:30:00', 3),
(3305, 1, 10, '2012-09-20 10:30:00', 3),
(3306, 1, 30, '2012-09-20 12:30:00', 3),
(3307, 1, 10, '2012-09-20 14:00:00', 3),
(3308, 1, 9, '2012-09-20 16:00:00', 3),
(3309, 1, 0, '2012-09-20 17:30:00', 3),
(3310, 1, 24, '2012-09-20 19:00:00', 3),
(3311, 2, 21, '2012-09-20 08:00:00', 6),
(3312, 2, 0, '2012-09-20 11:00:00', 3),
(3313, 2, 14, '2012-09-20 12:30:00', 3),
(3314, 2, 1, '2012-09-20 14:00:00', 3),
(3315, 2, 2, '2012-09-20 15:30:00', 3),
(3316, 2, 14, '2012-09-20 17:30:00', 3),
(3317, 3, 1, '2012-09-20 09:30:00', 2),
(3318, 3, 21, '2012-09-20 15:00:00', 2),
(3319, 3, 30, '2012-09-20 18:30:00', 4),
(3320, 4, 0, '2012-09-20 08:00:00', 2),
(3321, 4, 14, '2012-09-20 09:30:00', 2),
(3322, 4, 0, '2012-09-20 10:30:00', 4),
(3323, 4, 3, '2012-09-20 12:30:00', 4),
(3324, 4, 0, '2012-09-20 15:00:00', 2),
(3325, 4, 0, '2012-09-20 16:30:00', 2),
(3326, 4, 20, '2012-09-20 18:00:00', 2),
(3327, 4, 8, '2012-09-20 19:30:00', 2),
(3328, 5, 0, '2012-09-20 11:00:00', 2),
(3329, 5, 0, '2012-09-20 13:30:00', 2),
(3330, 5, 0, '2012-09-20 16:30:00', 2),
(3331, 5, 0, '2012-09-20 18:30:00', 2),
(3332, 6, 6, '2012-09-20 08:00:00', 2),
(3333, 6, 0, '2012-09-20 09:30:00', 6),
(3334, 6, 0, '2012-09-20 14:00:00', 2),
(3335, 6, 28, '2012-09-20 15:30:00', 2),
(3336, 7, 0, '2012-09-20 08:30:00', 2),
(3337, 7, 24, '2012-09-20 09:30:00', 2),
(3338, 7, 9, '2012-09-20 13:00:00', 2),
(3339, 7, 8, '2012-09-20 14:00:00', 2),
(3340, 7, 4, '2012-09-20 15:00:00', 2),
(3341, 7, 22, '2012-09-20 16:00:00', 2),
(3342, 7, 15, '2012-09-20 17:30:00', 2),
(3343, 7, 8, '2012-09-20 18:30:00', 2),
(3344, 7, 33, '2012-09-20 19:30:00', 2),
(3345, 8, 33, '2012-09-20 08:00:00', 1),
(3346, 8, 24, '2012-09-20 08:30:00', 1),
(3347, 8, 20, '2012-09-20 09:00:00', 1),
(3348, 8, 3, '2012-09-20 10:00:00', 1),
(3349, 8, 20, '2012-09-20 10:30:00', 1),
(3350, 8, 24, '2012-09-20 11:00:00', 1),
(3351, 8, 28, '2012-09-20 11:30:00', 1),
(3352, 8, 3, '2012-09-20 12:00:00', 1),
(3353, 8, 33, '2012-09-20 12:30:00', 1),
(3354, 8, 16, '2012-09-20 13:00:00', 1),
(3355, 8, 21, '2012-09-20 13:30:00', 1),
(3356, 8, 28, '2012-09-20 14:00:00', 1),
(3357, 8, 3, '2012-09-20 16:00:00', 1),
(3358, 8, 0, '2012-09-20 19:00:00', 2),
(3359, 8, 16, '2012-09-20 20:00:00', 1),
(3360, 0, 26, '2012-09-21 08:00:00', 3),
(3361, 0, 11, '2012-09-21 09:30:00', 3),
(3362, 0, 22, '2012-09-21 12:00:00', 3),
(3363, 0, 16, '2012-09-21 13:30:00', 3),
(3364, 0, 5, '2012-09-21 15:30:00', 3),
(3365, 0, 17, '2012-09-21 17:00:00', 6),
(3366, 1, 12, '2012-09-21 08:00:00', 3),
(3367, 1, 16, '2012-09-21 10:00:00', 3),
(3368, 1, 1, '2012-09-21 11:30:00', 3),
(3369, 1, 9, '2012-09-21 14:00:00', 3),
(3370, 1, 10, '2012-09-21 16:00:00', 3),
(3371, 1, 27, '2012-09-21 18:00:00', 3),
(3372, 2, 9, '2012-09-21 09:00:00', 3),
(3373, 2, 21, '2012-09-21 10:30:00', 3),
(3374, 2, 9, '2012-09-21 12:00:00', 3),
(3375, 2, 0, '2012-09-21 14:00:00', 6),
(3376, 3, 29, '2012-09-21 09:00:00', 2),
(3377, 3, 30, '2012-09-21 10:00:00', 2),
(3378, 3, 2, '2012-09-21 11:00:00', 2),
(3379, 3, 20, '2012-09-21 13:00:00', 2),
(3380, 3, 21, '2012-09-21 14:00:00', 2),
(3381, 3, 4, '2012-09-21 15:30:00', 2),
(3382, 3, 30, '2012-09-21 16:30:00', 2),
(3383, 3, 29, '2012-09-21 18:30:00', 2),
(3384, 3, 1, '2012-09-21 19:30:00', 2),
(3385, 4, 16, '2012-09-21 08:30:00', 2),
(3386, 4, 14, '2012-09-21 09:30:00', 2),
(3387, 4, 0, '2012-09-21 10:30:00', 2),
(3388, 4, 8, '2012-09-21 11:30:00', 2),
(3389, 4, 0, '2012-09-21 13:00:00', 2),
(3390, 4, 14, '2012-09-21 14:30:00', 2),
(3391, 4, 0, '2012-09-21 15:30:00', 2),
(3392, 4, 9, '2012-09-21 16:30:00', 2),
(3393, 4, 1, '2012-09-21 17:30:00', 2),
(3394, 4, 3, '2012-09-21 18:30:00', 2),
(3395, 4, 20, '2012-09-21 19:30:00', 2),
(3396, 5, 15, '2012-09-21 12:00:00', 2),
(3397, 5, 0, '2012-09-21 17:30:00', 2),
(3398, 6, 0, '2012-09-21 09:30:00', 2),
(3399, 6, 13, '2012-09-21 10:30:00', 2),
(3400, 6, 0, '2012-09-21 11:30:00', 4),
(3401, 6, 0, '2012-09-21 14:00:00', 2),
(3402, 6, 12, '2012-09-21 15:30:00', 2),
(3403, 6, 12, '2012-09-21 17:30:00', 2),
(3404, 6, 14, '2012-09-21 18:30:00', 4),
(3405, 7, 21, '2012-09-21 08:30:00', 2),
(3406, 7, 5, '2012-09-21 09:30:00', 2),
(3407, 7, 10, '2012-09-21 11:30:00', 2),
(3408, 7, 24, '2012-09-21 13:00:00', 2),
(3409, 7, 4, '2012-09-21 14:30:00', 2),
(3410, 7, 24, '2012-09-21 16:00:00', 2),
(3411, 7, 13, '2012-09-21 17:00:00', 2),
(3412, 7, 5, '2012-09-21 19:00:00', 2),
(3413, 8, 33, '2012-09-21 08:30:00', 2),
(3414, 8, 21, '2012-09-21 09:30:00', 2),
(3415, 8, 28, '2012-09-21 10:30:00', 1),
(3416, 8, 3, '2012-09-21 11:00:00', 1),
(3417, 8, 29, '2012-09-21 12:30:00', 1),
(3418, 8, 12, '2012-09-21 13:00:00', 1),
(3419, 8, 28, '2012-09-21 14:00:00', 1),
(3420, 8, 29, '2012-09-21 14:30:00', 1),
(3421, 8, 6, '2012-09-21 15:00:00', 1),
(3422, 8, 3, '2012-09-21 16:00:00', 1),
(3423, 8, 15, '2012-09-21 16:30:00', 1),
(3424, 8, 8, '2012-09-21 17:00:00', 1),
(3425, 8, 29, '2012-09-21 18:00:00', 1),
(3426, 8, 33, '2012-09-21 18:30:00', 1),
(3427, 8, 30, '2012-09-21 19:00:00', 1),
(3428, 8, 3, '2012-09-21 19:30:00', 1),
(3429, 0, 0, '2012-09-22 08:30:00', 3),
(3430, 0, 11, '2012-09-22 10:00:00', 6),
(3431, 0, 0, '2012-09-22 13:00:00', 3),
(3432, 0, 6, '2012-09-22 15:00:00', 3),
(3433, 0, 14, '2012-09-22 16:30:00', 3),
(3434, 0, 10, '2012-09-22 18:00:00', 3),
(3435, 1, 5, '2012-09-22 09:00:00', 3),
(3436, 1, 10, '2012-09-22 11:00:00', 3),
(3437, 1, 8, '2012-09-22 12:30:00', 3),
(3438, 1, 15, '2012-09-22 14:00:00', 3),
(3439, 1, 12, '2012-09-22 16:00:00', 3),
(3440, 1, 0, '2012-09-22 17:30:00', 3),
(3441, 2, 24, '2012-09-22 08:00:00', 3),
(3442, 2, 0, '2012-09-22 09:30:00', 3),
(3443, 2, 1, '2012-09-22 11:30:00', 3),
(3444, 2, 2, '2012-09-22 13:30:00', 3),
(3445, 2, 1, '2012-09-22 15:30:00', 3),
(3446, 2, 24, '2012-09-22 17:00:00', 3),
(3447, 3, 29, '2012-09-22 08:30:00', 2),
(3448, 3, 20, '2012-09-22 11:00:00', 2),
(3449, 3, 21, '2012-09-22 13:00:00', 2),
(3450, 3, 30, '2012-09-22 16:30:00', 2),
(3451, 3, 22, '2012-09-22 18:30:00', 4),
(3452, 4, 0, '2012-09-22 08:00:00', 2),
(3453, 4, 14, '2012-09-22 09:00:00', 2),
(3454, 4, 7, '2012-09-22 10:00:00', 2),
(3455, 4, 0, '2012-09-22 11:00:00', 2),
(3456, 4, 24, '2012-09-22 12:00:00', 2),
(3457, 4, 0, '2012-09-22 13:00:00', 2),
(3458, 4, 16, '2012-09-22 14:00:00', 2),
(3459, 4, 0, '2012-09-22 15:00:00', 8),
(3460, 4, 2, '2012-09-22 19:00:00', 2),
(3461, 5, 0, '2012-09-22 12:30:00', 2),
(3462, 6, 6, '2012-09-22 09:00:00', 2),
(3463, 6, 0, '2012-09-22 10:30:00', 2),
(3464, 6, 4, '2012-09-22 11:30:00', 2),
(3465, 6, 12, '2012-09-22 12:30:00', 2),
(3466, 6, 0, '2012-09-22 13:30:00', 2),
(3467, 6, 8, '2012-09-22 14:30:00', 2),
(3468, 6, 0, '2012-09-22 15:30:00', 4),
(3469, 6, 12, '2012-09-22 17:30:00', 2),
(3470, 7, 10, '2012-09-22 08:00:00', 2),
(3471, 7, 4, '2012-09-22 09:30:00', 2),
(3472, 7, 27, '2012-09-22 11:00:00', 2),
(3473, 7, 4, '2012-09-22 13:00:00', 2),
(3474, 7, 30, '2012-09-22 15:00:00', 2),
(3475, 7, 33, '2012-09-22 16:00:00', 2),
(3476, 7, 17, '2012-09-22 18:00:00', 2),
(3477, 7, 27, '2012-09-22 19:00:00', 2),
(3478, 8, 22, '2012-09-22 08:00:00', 1),
(3479, 8, 28, '2012-09-22 08:30:00', 1),
(3480, 8, 17, '2012-09-22 09:30:00', 1),
(3481, 8, 21, '2012-09-22 10:00:00', 1),
(3482, 8, 21, '2012-09-22 11:30:00', 1),
(3483, 8, 22, '2012-09-22 12:00:00', 1),
(3484, 8, 29, '2012-09-22 13:30:00', 1),
(3485, 8, 24, '2012-09-22 15:30:00', 1),
(3486, 8, 3, '2012-09-22 16:30:00', 1),
(3487, 8, 28, '2012-09-22 17:00:00', 1),
(3488, 8, 3, '2012-09-22 18:30:00', 2),
(3489, 8, 21, '2012-09-22 19:30:00', 1),
(3490, 8, 11, '2012-09-22 20:00:00', 1),
(3491, 0, 7, '2012-09-23 08:00:00', 3),
(3492, 0, 10, '2012-09-23 09:30:00', 3),
(3493, 0, 15, '2012-09-23 11:00:00', 3),
(3494, 0, 26, '2012-09-23 12:30:00', 3),
(3495, 0, 35, '2012-09-23 14:00:00', 3),
(3496, 0, 2, '2012-09-23 16:30:00', 3),
(3497, 0, 17, '2012-09-23 18:00:00', 3),
(3498, 1, 0, '2012-09-23 08:30:00', 3),
(3499, 1, 24, '2012-09-23 10:30:00', 3),
(3500, 1, 8, '2012-09-23 12:00:00', 3),
(3501, 1, 24, '2012-09-23 13:30:00', 3),
(3502, 1, 15, '2012-09-23 15:00:00', 3),
(3503, 1, 35, '2012-09-23 16:30:00', 3),
(3504, 1, 0, '2012-09-23 18:00:00', 3),
(3505, 2, 1, '2012-09-23 08:00:00', 3),
(3506, 2, 1, '2012-09-23 11:00:00', 3),
(3507, 2, 16, '2012-09-23 12:30:00', 3),
(3508, 2, 29, '2012-09-23 14:00:00', 3),
(3509, 2, 9, '2012-09-23 15:30:00', 3),
(3510, 2, 7, '2012-09-23 17:00:00', 3),
(3511, 3, 3, '2012-09-23 08:00:00', 2),
(3512, 3, 22, '2012-09-23 09:30:00', 2),
(3513, 3, 3, '2012-09-23 10:30:00', 2),
(3514, 3, 22, '2012-09-23 12:30:00', 2),
(3515, 3, 15, '2012-09-23 13:30:00', 2),
(3516, 3, 22, '2012-09-23 15:00:00', 2),
(3517, 3, 3, '2012-09-23 16:00:00', 2),
(3518, 3, 22, '2012-09-23 17:30:00', 2),
(3519, 3, 10, '2012-09-23 19:00:00', 2),
(3520, 4, 11, '2012-09-23 08:00:00', 2),
(3521, 4, 16, '2012-09-23 09:30:00', 2),
(3522, 4, 9, '2012-09-23 10:30:00', 2),
(3523, 4, 0, '2012-09-23 11:30:00', 2),
(3524, 4, 6, '2012-09-23 12:30:00', 2),
(3525, 4, 13, '2012-09-23 13:30:00', 4),
(3526, 4, 22, '2012-09-23 16:00:00', 2),
(3527, 4, 0, '2012-09-23 17:00:00', 2),
(3528, 4, 11, '2012-09-23 18:00:00', 2),
(3529, 4, 1, '2012-09-23 19:00:00', 2),
(3530, 5, 0, '2012-09-23 15:00:00', 2),
(3531, 6, 0, '2012-09-23 08:00:00', 4),
(3532, 6, 0, '2012-09-23 10:30:00', 2),
(3533, 6, 0, '2012-09-23 12:00:00', 2),
(3534, 6, 0, '2012-09-23 13:30:00', 6),
(3535, 6, 12, '2012-09-23 16:30:00', 2),
(3536, 6, 15, '2012-09-23 17:30:00', 2),
(3537, 6, 0, '2012-09-23 19:00:00', 2),
(3538, 7, 8, '2012-09-23 09:00:00', 2),
(3539, 7, 17, '2012-09-23 10:00:00', 2),
(3540, 7, 9, '2012-09-23 11:30:00', 2),
(3541, 7, 27, '2012-09-23 15:00:00', 2),
(3542, 7, 15, '2012-09-23 16:30:00', 2),
(3543, 7, 14, '2012-09-23 17:30:00', 2),
(3544, 7, 0, '2012-09-23 19:00:00', 2),
(3545, 8, 33, '2012-09-23 08:00:00', 1),
(3546, 8, 28, '2012-09-23 08:30:00', 1),
(3547, 8, 0, '2012-09-23 09:00:00', 1),
(3548, 8, 3, '2012-09-23 09:30:00', 1),
(3549, 8, 0, '2012-09-23 10:00:00', 1),
(3550, 8, 29, '2012-09-23 10:30:00', 1),
(3551, 8, 3, '2012-09-23 11:30:00', 1),
(3552, 8, 30, '2012-09-23 12:00:00', 1),
(3553, 8, 21, '2012-09-23 13:00:00', 2),
(3554, 8, 0, '2012-09-23 15:00:00', 1),
(3555, 8, 16, '2012-09-23 15:30:00', 1),
(3556, 8, 13, '2012-09-23 16:00:00', 1),
(3557, 8, 6, '2012-09-23 16:30:00', 1),
(3558, 8, 29, '2012-09-23 17:00:00', 1),
(3559, 8, 28, '2012-09-23 17:30:00', 1),
(3560, 8, 6, '2012-09-23 18:00:00', 1),
(3561, 8, 28, '2012-09-23 19:00:00', 1),
(3562, 8, 29, '2012-09-23 19:30:00', 1),
(3563, 0, 0, '2012-09-24 08:00:00', 9),
(3564, 0, 35, '2012-09-24 12:30:00', 3),
(3565, 0, 0, '2012-09-24 14:00:00', 3),
(3566, 0, 14, '2012-09-24 15:30:00', 6),
(3567, 0, 11, '2012-09-24 18:30:00', 3),
(3568, 1, 28, '2012-09-24 08:00:00', 3),
(3569, 1, 10, '2012-09-24 09:30:00', 3),
(3570, 1, 10, '2012-09-24 12:00:00', 6),
(3571, 1, 16, '2012-09-24 15:00:00', 3),
(3572, 1, 0, '2012-09-24 16:30:00', 3),
(3573, 1, 24, '2012-09-24 19:00:00', 3),
(3574, 2, 21, '2012-09-24 08:00:00', 3),
(3575, 2, 0, '2012-09-24 09:30:00', 3),
(3576, 2, 1, '2012-09-24 11:30:00', 3),
(3577, 2, 3, '2012-09-24 13:00:00', 3),
(3578, 2, 12, '2012-09-24 14:30:00', 3),
(3579, 2, 7, '2012-09-24 16:30:00', 3),
(3580, 2, 3, '2012-09-24 18:00:00', 3),
(3581, 3, 0, '2012-09-24 08:00:00', 2),
(3582, 3, 21, '2012-09-24 09:30:00', 2),
(3583, 3, 16, '2012-09-24 12:00:00', 2),
(3584, 3, 15, '2012-09-24 13:00:00', 2),
(3585, 3, 2, '2012-09-24 14:30:00', 2),
(3586, 3, 20, '2012-09-24 15:30:00', 2),
(3587, 3, 22, '2012-09-24 17:00:00', 2),
(3588, 3, 16, '2012-09-24 18:00:00', 2),
(3589, 3, 0, '2012-09-24 19:00:00', 2),
(3590, 4, 11, '2012-09-24 08:00:00', 2),
(3591, 4, 14, '2012-09-24 09:00:00', 2),
(3592, 4, 0, '2012-09-24 10:30:00', 2),
(3593, 4, 0, '2012-09-24 12:00:00', 2),
(3594, 4, 20, '2012-09-24 13:00:00', 2),
(3595, 4, 0, '2012-09-24 14:00:00', 2),
(3596, 4, 8, '2012-09-24 15:00:00', 2),
(3597, 4, 6, '2012-09-24 16:00:00', 2),
(3598, 4, 8, '2012-09-24 17:00:00', 2),
(3599, 4, 35, '2012-09-24 18:00:00', 2),
(3600, 4, 0, '2012-09-24 19:00:00', 2),
(3601, 5, 14, '2012-09-24 11:00:00', 2),
(3602, 5, 0, '2012-09-24 14:00:00', 2),
(3603, 6, 0, '2012-09-24 08:00:00', 2),
(3604, 6, 9, '2012-09-24 09:30:00', 2),
(3605, 6, 0, '2012-09-24 10:30:00', 2),
(3606, 6, 0, '2012-09-24 12:00:00', 4),
(3607, 6, 14, '2012-09-24 14:00:00', 2),
(3608, 6, 0, '2012-09-24 15:00:00', 4),
(3609, 6, 12, '2012-09-24 17:00:00', 2),
(3610, 6, 33, '2012-09-24 18:00:00', 2),
(3611, 6, 17, '2012-09-24 19:00:00', 2),
(3612, 7, 24, '2012-09-24 08:30:00', 2),
(3613, 7, 22, '2012-09-24 13:00:00', 2),
(3614, 7, 9, '2012-09-24 14:30:00', 2),
(3615, 7, 17, '2012-09-24 15:30:00', 2),
(3616, 7, 28, '2012-09-24 16:30:00', 2),
(3617, 7, 10, '2012-09-24 17:30:00', 2),
(3618, 7, 8, '2012-09-24 19:00:00', 2),
(3619, 8, 0, '2012-09-24 08:00:00', 1),
(3620, 8, 29, '2012-09-24 08:30:00', 1),
(3621, 8, 0, '2012-09-24 09:00:00', 1),
(3622, 8, 3, '2012-09-24 09:30:00', 2),
(3623, 8, 8, '2012-09-24 10:30:00', 1),
(3624, 8, 0, '2012-09-24 12:00:00', 1),
(3625, 8, 28, '2012-09-24 12:30:00', 1),
(3626, 8, 21, '2012-09-24 13:30:00', 1),
(3627, 8, 2, '2012-09-24 14:00:00', 1),
(3628, 8, 3, '2012-09-24 14:30:00', 1),
(3629, 8, 2, '2012-09-24 16:00:00', 1),
(3630, 8, 22, '2012-09-24 16:30:00', 1),
(3631, 8, 0, '2012-09-24 17:00:00', 1),
(3632, 8, 29, '2012-09-24 17:30:00', 1),
(3633, 8, 16, '2012-09-24 19:00:00', 1),
(3634, 8, 29, '2012-09-24 19:30:00', 1),
(3635, 0, 12, '2012-09-25 08:00:00', 3),
(3636, 0, 2, '2012-09-25 09:30:00', 6),
(3637, 0, 16, '2012-09-25 13:00:00', 3),
(3638, 0, 0, '2012-09-25 15:00:00', 6),
(3639, 0, 11, '2012-09-25 18:00:00', 3),
(3640, 1, 9, '2012-09-25 08:00:00', 3),
(3641, 1, 12, '2012-09-25 10:00:00', 3),
(3642, 1, 0, '2012-09-25 11:30:00', 3),
(3643, 1, 12, '2012-09-25 13:00:00', 3),
(3644, 1, 11, '2012-09-25 14:30:00', 3),
(3645, 1, 35, '2012-09-25 16:30:00', 3),
(3646, 1, 0, '2012-09-25 18:30:00', 3),
(3647, 2, 29, '2012-09-25 08:00:00', 6),
(3648, 2, 11, '2012-09-25 11:30:00', 3),
(3649, 2, 13, '2012-09-25 14:30:00', 3),
(3650, 2, 0, '2012-09-25 16:00:00', 3),
(3651, 2, 33, '2012-09-25 17:30:00', 3),
(3652, 3, 20, '2012-09-25 08:00:00', 2),
(3653, 3, 17, '2012-09-25 11:00:00', 2),
(3654, 3, 22, '2012-09-25 12:30:00', 2),
(3655, 3, 35, '2012-09-25 13:30:00', 2),
(3656, 3, 20, '2012-09-25 17:30:00', 2),
(3657, 3, 17, '2012-09-25 19:00:00', 2),
(3658, 4, 8, '2012-09-25 08:00:00', 2),
(3659, 4, 20, '2012-09-25 09:00:00', 2),
(3660, 4, 14, '2012-09-25 10:00:00', 2),
(3661, 4, 0, '2012-09-25 11:30:00', 4),
(3662, 4, 8, '2012-09-25 13:30:00', 2),
(3663, 4, 3, '2012-09-25 14:30:00', 2),
(3664, 4, 0, '2012-09-25 15:30:00', 2),
(3665, 4, 20, '2012-09-25 16:30:00', 2),
(3666, 4, 4, '2012-09-25 17:30:00', 2),
(3667, 4, 6, '2012-09-25 18:30:00', 2),
(3668, 4, 3, '2012-09-25 19:30:00', 2),
(3669, 5, 0, '2012-09-25 08:30:00', 2),
(3670, 5, 0, '2012-09-25 11:30:00', 2),
(3671, 5, 0, '2012-09-25 16:00:00', 2),
(3672, 6, 0, '2012-09-25 08:00:00', 4),
(3673, 6, 8, '2012-09-25 10:00:00', 2),
(3674, 6, 0, '2012-09-25 11:00:00', 2),
(3675, 6, 2, '2012-09-25 12:30:00', 2),
(3676, 6, 0, '2012-09-25 14:00:00', 2),
(3677, 6, 0, '2012-09-25 15:30:00', 4),
(3678, 7, 21, '2012-09-25 09:30:00', 2),
(3679, 7, 10, '2012-09-25 12:30:00', 2),
(3680, 7, 0, '2012-09-25 13:30:00', 2),
(3681, 7, 7, '2012-09-25 14:30:00', 2),
(3682, 7, 33, '2012-09-25 15:30:00', 4),
(3683, 7, 2, '2012-09-25 18:30:00', 2),
(3684, 8, 15, '2012-09-25 08:00:00', 1),
(3685, 8, 21, '2012-09-25 09:00:00', 1),
(3686, 8, 3, '2012-09-25 09:30:00', 1),
(3687, 8, 29, '2012-09-25 12:30:00', 1),
(3688, 8, 3, '2012-09-25 13:30:00', 1),
(3689, 8, 29, '2012-09-25 14:00:00', 1),
(3690, 8, 16, '2012-09-25 15:00:00', 1),
(3691, 8, 28, '2012-09-25 15:30:00', 1),
(3692, 8, 28, '2012-09-25 17:00:00', 1),
(3693, 8, 21, '2012-09-25 17:30:00', 1),
(3694, 8, 3, '2012-09-25 18:30:00', 1),
(3695, 8, 16, '2012-09-25 19:00:00', 1),
(3696, 8, 33, '2012-09-25 19:30:00', 1),
(3697, 0, 5, '2012-09-26 08:00:00', 3),
(3698, 0, 0, '2012-09-26 09:30:00', 3),
(3699, 0, 6, '2012-09-26 11:00:00', 3),
(3700, 0, 11, '2012-09-26 13:30:00', 3),
(3701, 0, 0, '2012-09-26 15:00:00', 6),
(3702, 0, 22, '2012-09-26 18:00:00', 3),
(3703, 1, 0, '2012-09-26 08:00:00', 3),
(3704, 1, 0, '2012-09-26 10:30:00', 3),
(3705, 1, 9, '2012-09-26 12:00:00', 3),
(3706, 1, 35, '2012-09-26 14:00:00', 3),
(3707, 1, 12, '2012-09-26 15:30:00', 6),
(3708, 1, 11, '2012-09-26 18:30:00', 3),
(3709, 2, 1, '2012-09-26 08:00:00', 3),
(3710, 2, 2, '2012-09-26 09:30:00', 3),
(3711, 2, 10, '2012-09-26 11:00:00', 3),
(3712, 2, 1, '2012-09-26 12:30:00', 3),
(3713, 2, 0, '2012-09-26 14:00:00', 3),
(3714, 2, 1, '2012-09-26 15:30:00', 3),
(3715, 2, 17, '2012-09-26 17:00:00', 3),
(3716, 2, 12, '2012-09-26 18:30:00', 3),
(3717, 3, 15, '2012-09-26 11:00:00', 2),
(3718, 3, 30, '2012-09-26 12:00:00', 2),
(3719, 3, 3, '2012-09-26 15:00:00', 2),
(3720, 3, 22, '2012-09-26 16:00:00', 2),
(3721, 3, 15, '2012-09-26 18:30:00', 2),
(3722, 3, 9, '2012-09-26 19:30:00', 2),
(3723, 4, 3, '2012-09-26 08:00:00', 2),
(3724, 4, 0, '2012-09-26 09:00:00', 2),
(3725, 4, 33, '2012-09-26 10:00:00', 2),
(3726, 4, 20, '2012-09-26 11:00:00', 4),
(3727, 4, 29, '2012-09-26 13:00:00', 2),
(3728, 4, 0, '2012-09-26 14:00:00', 2),
(3729, 4, 5, '2012-09-26 15:30:00', 2),
(3730, 4, 0, '2012-09-26 16:30:00', 2),
(3731, 4, 14, '2012-09-26 17:30:00', 2),
(3732, 4, 20, '2012-09-26 18:30:00', 2),
(3733, 5, 0, '2012-09-26 18:30:00', 2),
(3734, 6, 0, '2012-09-26 08:00:00', 2),
(3735, 6, 0, '2012-09-26 09:30:00', 2),
(3736, 6, 30, '2012-09-26 10:30:00', 2),
(3737, 6, 0, '2012-09-26 11:30:00', 2),
(3738, 6, 0, '2012-09-26 13:00:00', 8),
(3739, 6, 10, '2012-09-26 17:00:00', 2),
(3740, 6, 21, '2012-09-26 18:00:00', 2),
(3741, 6, 0, '2012-09-26 19:00:00', 2),
(3742, 7, 7, '2012-09-26 09:00:00', 2),
(3743, 7, 24, '2012-09-26 10:30:00', 2),
(3744, 7, 5, '2012-09-26 11:30:00', 2),
(3745, 7, 27, '2012-09-26 14:30:00', 2),
(3746, 7, 24, '2012-09-26 16:00:00', 2),
(3747, 7, 5, '2012-09-26 17:30:00', 2),
(3748, 8, 0, '2012-09-26 08:30:00', 1),
(3749, 8, 30, '2012-09-26 09:00:00', 1),
(3750, 8, 16, '2012-09-26 09:30:00', 1),
(3751, 8, 21, '2012-09-26 10:00:00', 1),
(3752, 8, 29, '2012-09-26 10:30:00', 1),
(3753, 8, 16, '2012-09-26 11:30:00', 1),
(3754, 8, 29, '2012-09-26 12:00:00', 2),
(3755, 8, 28, '2012-09-26 13:00:00', 1),
(3756, 8, 3, '2012-09-26 14:00:00', 2),
(3757, 8, 20, '2012-09-26 15:30:00', 1),
(3758, 8, 3, '2012-09-26 16:00:00', 1),
(3759, 8, 28, '2012-09-26 17:00:00', 1),
(3760, 8, 21, '2012-09-26 19:00:00', 1),
(3761, 8, 29, '2012-09-26 19:30:00', 1),
(3762, 8, 24, '2012-09-26 20:00:00', 1),
(3763, 0, 11, '2012-09-27 09:00:00', 3),
(3764, 0, 6, '2012-09-27 11:00:00', 3),
(3765, 0, 17, '2012-09-27 13:00:00', 3),
(3766, 0, 26, '2012-09-27 16:00:00', 3),
(3767, 0, 0, '2012-09-27 17:30:00', 6),
(3768, 1, 0, '2012-09-27 08:00:00', 9),
(3769, 1, 8, '2012-09-27 12:30:00', 3),
(3770, 1, 0, '2012-09-27 14:30:00', 3),
(3771, 1, 35, '2012-09-27 16:00:00', 3),
(3772, 1, 10, '2012-09-27 17:30:00', 3),
(3773, 2, 1, '2012-09-27 08:00:00', 3),
(3774, 2, 24, '2012-09-27 10:00:00', 3),
(3775, 2, 36, '2012-09-27 11:30:00', 3),
(3776, 2, 30, '2012-09-27 15:30:00', 3),
(3777, 2, 11, '2012-09-27 17:30:00', 3),
(3778, 2, 2, '2012-09-27 19:00:00', 3),
(3779, 3, 15, '2012-09-27 08:30:00', 2),
(3780, 3, 22, '2012-09-27 09:30:00', 2),
(3781, 3, 0, '2012-09-27 12:00:00', 2),
(3782, 3, 15, '2012-09-27 13:00:00', 2),
(3783, 3, 15, '2012-09-27 15:30:00', 2),
(3784, 3, 20, '2012-09-27 17:30:00', 2),
(3785, 3, 0, '2012-09-27 18:30:00', 2),
(3786, 4, 0, '2012-09-27 08:00:00', 2),
(3787, 4, 24, '2012-09-27 09:00:00', 2),
(3788, 4, 35, '2012-09-27 10:00:00', 2),
(3789, 4, 20, '2012-09-27 11:00:00', 2),
(3790, 4, 0, '2012-09-27 12:00:00', 2),
(3791, 4, 12, '2012-09-27 13:00:00', 2),
(3792, 4, 24, '2012-09-27 14:00:00', 2),
(3793, 4, 36, '2012-09-27 15:00:00', 2),
(3794, 4, 0, '2012-09-27 16:00:00', 2),
(3795, 4, 7, '2012-09-27 17:00:00', 2),
(3796, 4, 35, '2012-09-27 18:00:00', 2),
(3797, 4, 6, '2012-09-27 19:00:00', 2),
(3798, 5, 0, '2012-09-27 10:30:00', 2),
(3799, 5, 22, '2012-09-27 16:30:00', 2),
(3800, 6, 0, '2012-09-27 08:00:00', 2),
(3801, 6, 12, '2012-09-27 09:30:00', 2),
(3802, 6, 0, '2012-09-27 10:30:00', 2),
(3803, 6, 0, '2012-09-27 12:00:00', 6),
(3804, 6, 12, '2012-09-27 15:00:00', 4),
(3805, 6, 0, '2012-09-27 19:00:00', 2),
(3806, 7, 24, '2012-09-27 08:00:00', 2),
(3807, 7, 4, '2012-09-27 09:30:00', 2),
(3808, 7, 10, '2012-09-27 12:00:00', 2),
(3809, 7, 10, '2012-09-27 13:30:00', 2),
(3810, 7, 8, '2012-09-27 15:00:00', 2),
(3811, 7, 9, '2012-09-27 16:00:00', 2),
(3812, 7, 24, '2012-09-27 18:30:00', 2),
(3813, 7, 17, '2012-09-27 19:30:00', 2),
(3814, 8, 28, '2012-09-27 08:00:00', 1),
(3815, 8, 2, '2012-09-27 08:30:00', 1),
(3816, 8, 29, '2012-09-27 09:00:00', 1),
(3817, 8, 33, '2012-09-27 10:30:00', 1),
(3818, 8, 3, '2012-09-27 11:00:00', 1),
(3819, 8, 29, '2012-09-27 13:30:00', 1),
(3820, 8, 22, '2012-09-27 14:00:00', 1),
(3821, 8, 29, '2012-09-27 15:00:00', 1),
(3822, 8, 0, '2012-09-27 15:30:00', 1),
(3823, 8, 20, '2012-09-27 16:00:00', 1),
(3824, 8, 8, '2012-09-27 16:30:00', 1),
(3825, 8, 16, '2012-09-27 17:00:00', 1),
(3826, 8, 27, '2012-09-27 18:00:00', 1),
(3827, 8, 3, '2012-09-27 19:30:00', 1),
(3828, 8, 29, '2012-09-27 20:00:00', 1),
(3829, 0, 35, '2012-09-28 08:30:00', 3),
(3830, 0, 16, '2012-09-28 10:00:00', 3),
(3831, 0, 28, '2012-09-28 11:30:00', 3),
(3832, 0, 0, '2012-09-28 13:00:00', 3),
(3833, 0, 0, '2012-09-28 15:00:00', 3),
(3834, 0, 0, '2012-09-28 17:00:00', 3),
(3835, 1, 10, '2012-09-28 08:00:00', 3),
(3836, 1, 0, '2012-09-28 09:30:00', 9),
(3837, 1, 8, '2012-09-28 14:00:00', 3),
(3838, 1, 0, '2012-09-28 15:30:00', 3),
(3839, 1, 0, '2012-09-28 17:30:00', 6),
(3840, 2, 2, '2012-09-28 08:00:00', 3),
(3841, 2, 21, '2012-09-28 09:30:00', 3),
(3842, 2, 21, '2012-09-28 11:30:00', 3),
(3843, 2, 1, '2012-09-28 13:00:00', 3),
(3844, 2, 5, '2012-09-28 14:30:00', 3),
(3845, 2, 17, '2012-09-28 16:00:00', 3),
(3846, 2, 0, '2012-09-28 17:30:00', 3),
(3847, 2, 1, '2012-09-28 19:00:00', 3),
(3848, 3, 30, '2012-09-28 09:00:00', 2),
(3849, 3, 15, '2012-09-28 10:30:00', 2),
(3850, 3, 13, '2012-09-28 11:30:00', 2),
(3851, 3, 22, '2012-09-28 12:30:00', 2),
(3852, 3, 15, '2012-09-28 14:00:00', 2),
(3853, 3, 24, '2012-09-28 15:30:00', 2),
(3854, 3, 22, '2012-09-28 17:30:00', 2),
(3855, 3, 20, '2012-09-28 19:00:00', 2),
(3856, 4, 24, '2012-09-28 08:00:00', 2),
(3857, 4, 0, '2012-09-28 09:00:00', 4),
(3858, 4, 14, '2012-09-28 11:30:00', 2),
(3859, 4, 0, '2012-09-28 12:30:00', 4),
(3860, 4, 16, '2012-09-28 14:30:00', 2),
(3861, 4, 0, '2012-09-28 15:30:00', 2),
(3862, 4, 5, '2012-09-28 16:30:00', 2),
(3863, 4, 0, '2012-09-28 17:30:00', 2),
(3864, 4, 8, '2012-09-28 18:30:00', 2),
(3865, 4, 7, '2012-09-28 19:30:00', 2),
(3866, 5, 0, '2012-09-28 10:30:00', 2),
(3867, 5, 0, '2012-09-28 13:00:00', 2),
(3868, 5, 11, '2012-09-28 16:00:00', 2),
(3869, 5, 0, '2012-09-28 17:00:00', 4),
(3870, 6, 0, '2012-09-28 08:00:00', 6),
(3871, 6, 12, '2012-09-28 11:00:00', 2),
(3872, 6, 0, '2012-09-28 12:00:00', 2),
(3873, 6, 16, '2012-09-28 13:30:00', 2),
(3874, 6, 0, '2012-09-28 14:30:00', 2),
(3875, 6, 0, '2012-09-28 16:00:00', 6),
(3876, 6, 12, '2012-09-28 19:30:00', 2),
(3877, 7, 17, '2012-09-28 08:00:00', 2),
(3878, 7, 27, '2012-09-28 09:00:00', 2),
(3879, 7, 9, '2012-09-28 12:00:00', 2),
(3880, 7, 21, '2012-09-28 13:30:00', 2),
(3881, 7, 27, '2012-09-28 15:00:00', 2),
(3882, 7, 8, '2012-09-28 16:30:00', 2),
(3883, 7, 6, '2012-09-28 18:00:00', 2),
(3884, 8, 21, '2012-09-28 08:00:00', 1),
(3885, 8, 28, '2012-09-28 09:30:00', 1),
(3886, 8, 3, '2012-09-28 10:30:00', 1),
(3887, 8, 3, '2012-09-28 12:00:00', 1),
(3888, 8, 29, '2012-09-28 12:30:00', 1),
(3889, 8, 28, '2012-09-28 13:00:00', 1),
(3890, 8, 3, '2012-09-28 13:30:00', 2),
(3891, 8, 30, '2012-09-28 15:30:00', 1),
(3892, 8, 12, '2012-09-28 16:30:00', 1),
(3893, 8, 0, '2012-09-28 17:00:00', 1),
(3894, 8, 3, '2012-09-28 17:30:00', 1),
(3895, 8, 29, '2012-09-28 18:00:00', 1),
(3896, 8, 10, '2012-09-28 18:30:00', 1),
(3897, 8, 21, '2012-09-28 19:30:00', 1),
(3898, 8, 16, '2012-09-28 20:00:00', 1),
(3899, 0, 0, '2012-09-29 08:00:00', 3),
(3900, 0, 11, '2012-09-29 11:30:00', 6),
(3901, 0, 6, '2012-09-29 14:30:00', 3),
(3902, 0, 28, '2012-09-29 16:00:00', 3),
(3903, 0, 20, '2012-09-29 17:30:00', 3),
(3904, 1, 0, '2012-09-29 10:00:00', 3),
(3905, 1, 8, '2012-09-29 11:30:00', 3),
(3906, 1, 10, '2012-09-29 13:00:00', 3),
(3907, 1, 12, '2012-09-29 14:30:00', 3),
(3908, 1, 0, '2012-09-29 16:00:00', 3),
(3909, 1, 10, '2012-09-29 18:00:00', 3),
(3910, 2, 1, '2012-09-29 08:00:00', 3),
(3911, 2, 36, '2012-09-29 09:30:00', 3),
(3912, 2, 14, '2012-09-29 11:00:00', 3),
(3913, 2, 21, '2012-09-29 12:30:00', 3),
(3914, 2, 1, '2012-09-29 14:00:00', 3),
(3915, 2, 24, '2012-09-29 15:30:00', 3),
(3916, 2, 12, '2012-09-29 17:00:00', 3),
(3917, 2, 16, '2012-09-29 18:30:00', 3),
(3918, 3, 2, '2012-09-29 08:30:00', 2),
(3919, 3, 21, '2012-09-29 09:30:00', 2),
(3920, 3, 6, '2012-09-29 11:00:00', 2),
(3921, 3, 13, '2012-09-29 13:00:00', 2),
(3922, 3, 16, '2012-09-29 14:00:00', 2),
(3923, 3, 20, '2012-09-29 16:00:00', 2),
(3924, 3, 21, '2012-09-29 19:30:00', 2),
(3925, 4, 16, '2012-09-29 08:00:00', 2),
(3926, 4, 0, '2012-09-29 09:30:00', 2),
(3927, 4, 3, '2012-09-29 10:30:00', 2),
(3928, 4, 20, '2012-09-29 11:30:00', 2),
(3929, 4, 5, '2012-09-29 12:30:00', 2),
(3930, 4, 0, '2012-09-29 13:30:00', 2),
(3931, 4, 3, '2012-09-29 14:30:00', 2),
(3932, 4, 0, '2012-09-29 15:30:00', 2),
(3933, 4, 16, '2012-09-29 16:30:00', 2),
(3934, 4, 13, '2012-09-29 17:30:00', 2),
(3935, 4, 36, '2012-09-29 18:30:00', 2),
(3936, 4, 24, '2012-09-29 19:30:00', 2),
(3937, 5, 0, '2012-09-29 12:30:00', 2),
(3938, 6, 6, '2012-09-29 08:00:00', 2),
(3939, 6, 0, '2012-09-29 09:00:00', 4),
(3940, 6, 24, '2012-09-29 11:00:00', 2),
(3941, 6, 0, '2012-09-29 12:00:00', 2),
(3942, 6, 12, '2012-09-29 13:00:00', 2),
(3943, 6, 0, '2012-09-29 14:00:00', 2),
(3944, 6, 27, '2012-09-29 17:00:00', 2),
(3945, 6, 0, '2012-09-29 18:00:00', 4),
(3946, 7, 8, '2012-09-29 08:30:00', 2),
(3947, 7, 4, '2012-09-29 10:00:00', 2),
(3948, 7, 0, '2012-09-29 12:30:00', 2),
(3949, 7, 24, '2012-09-29 13:30:00', 2),
(3950, 7, 8, '2012-09-29 14:30:00', 2),
(3951, 7, 27, '2012-09-29 15:30:00', 2),
(3952, 7, 8, '2012-09-29 16:30:00', 2),
(3953, 7, 15, '2012-09-29 18:30:00', 2),
(3954, 7, 27, '2012-09-29 19:30:00', 2),
(3955, 8, 12, '2012-09-29 08:00:00', 1),
(3956, 8, 3, '2012-09-29 08:30:00', 1),
(3957, 8, 21, '2012-09-29 09:00:00', 1),
(3958, 8, 29, '2012-09-29 10:00:00', 1),
(3959, 8, 28, '2012-09-29 10:30:00', 1),
(3960, 8, 2, '2012-09-29 11:00:00', 2),
(3961, 8, 29, '2012-09-29 12:00:00', 2),
(3962, 8, 20, '2012-09-29 13:00:00', 1),
(3963, 8, 28, '2012-09-29 13:30:00', 1),
(3964, 8, 3, '2012-09-29 14:00:00', 1),
(3965, 8, 28, '2012-09-29 14:30:00', 1),
(3966, 8, 12, '2012-09-29 16:00:00', 1),
(3967, 8, 26, '2012-09-29 16:30:00', 1),
(3968, 8, 15, '2012-09-29 17:00:00', 1),
(3969, 8, 28, '2012-09-29 17:30:00', 1),
(3970, 8, 29, '2012-09-29 18:00:00', 2),
(3971, 8, 4, '2012-09-29 19:30:00', 1),
(3972, 8, 33, '2012-09-29 20:00:00', 1),
(3973, 0, 4, '2012-09-30 08:00:00', 3),
(3974, 0, 35, '2012-09-30 09:30:00', 3),
(3975, 0, 0, '2012-09-30 11:00:00', 6),
(3976, 0, 36, '2012-09-30 14:00:00', 3),
(3977, 0, 24, '2012-09-30 16:00:00', 3),
(3978, 0, 0, '2012-09-30 17:30:00', 3),
(3979, 0, 24, '2012-09-30 19:00:00', 3),
(3980, 1, 8, '2012-09-30 08:30:00', 3),
(3981, 1, 0, '2012-09-30 10:00:00', 3),
(3982, 1, 10, '2012-09-30 11:30:00', 3),
(3983, 1, 11, '2012-09-30 13:30:00', 6),
(3984, 1, 10, '2012-09-30 16:30:00', 3),
(3985, 1, 8, '2012-09-30 18:30:00', 3),
(3986, 2, 1, '2012-09-30 08:00:00', 3),
(3987, 2, 17, '2012-09-30 09:30:00', 3),
(3988, 2, 29, '2012-09-30 11:00:00', 3),
(3989, 2, 35, '2012-09-30 12:30:00', 3),
(3990, 2, 1, '2012-09-30 14:00:00', 6),
(3991, 2, 5, '2012-09-30 17:00:00', 3),
(3992, 2, 35, '2012-09-30 18:30:00', 3),
(3993, 3, 24, '2012-09-30 08:00:00', 2),
(3994, 3, 3, '2012-09-30 09:30:00', 2),
(3995, 3, 36, '2012-09-30 10:30:00', 2),
(3996, 3, 36, '2012-09-30 12:00:00', 2),
(3997, 3, 0, '2012-09-30 14:30:00', 2),
(3998, 3, 1, '2012-09-30 18:30:00', 2),
(3999, 4, 13, '2012-09-30 08:00:00', 2),
(4000, 4, 16, '2012-09-30 09:00:00', 2),
(4001, 4, 0, '2012-09-30 10:00:00', 2),
(4002, 4, 20, '2012-09-30 11:00:00', 2),
(4003, 4, 4, '2012-09-30 12:30:00', 2),
(4004, 4, 3, '2012-09-30 13:30:00', 2),
(4005, 4, 20, '2012-09-30 15:00:00', 2),
(4006, 4, 0, '2012-09-30 16:00:00', 2),
(4007, 4, 3, '2012-09-30 17:00:00', 2),
(4008, 4, 0, '2012-09-30 18:00:00', 2),
(4009, 5, 0, '2012-09-30 11:30:00', 2),
(4010, 5, 0, '2012-09-30 19:30:00', 2),
(4011, 6, 0, '2012-09-30 08:00:00', 2),
(4012, 6, 27, '2012-09-30 09:30:00', 2),
(4013, 6, 0, '2012-09-30 11:00:00', 2),
(4014, 6, 0, '2012-09-30 12:30:00', 2),
(4015, 6, 12, '2012-09-30 14:00:00', 2),
(4016, 6, 0, '2012-09-30 15:30:00', 2),
(4017, 6, 35, '2012-09-30 16:30:00', 2),
(4018, 6, 0, '2012-09-30 17:30:00', 2),
(4019, 6, 0, '2012-09-30 19:00:00', 2),
(4020, 7, 27, '2012-09-30 08:30:00', 2),
(4021, 7, 33, '2012-09-30 09:30:00', 2),
(4022, 7, 33, '2012-09-30 11:00:00', 2),
(4023, 7, 5, '2012-09-30 14:30:00', 2),
(4024, 7, 15, '2012-09-30 16:30:00', 2),
(4025, 7, 24, '2012-09-30 17:30:00', 2),
(4026, 7, 5, '2012-09-30 19:00:00', 2),
(4027, 8, 16, '2012-09-30 08:00:00', 1),
(4028, 8, 21, '2012-09-30 08:30:00', 2),
(4029, 8, 3, '2012-09-30 10:30:00', 1),
(4030, 8, 16, '2012-09-30 11:00:00', 1),
(4031, 8, 3, '2012-09-30 11:30:00', 1),
(4032, 8, 17, '2012-09-30 12:00:00', 1),
(4033, 8, 21, '2012-09-30 12:30:00', 1),
(4034, 8, 3, '2012-09-30 13:00:00', 1),
(4035, 8, 29, '2012-09-30 13:30:00', 1),
(4036, 8, 28, '2012-09-30 14:30:00', 1),
(4037, 8, 29, '2012-09-30 15:30:00', 1),
(4038, 8, 29, '2012-09-30 16:30:00', 2),
(4039, 8, 29, '2012-09-30 18:00:00', 1),
(4040, 8, 21, '2012-09-30 18:30:00', 1),
(4041, 8, 16, '2012-09-30 19:00:00', 1),
(4042, 8, 29, '2012-09-30 19:30:00', 1),
(4043, 8, 5, '2013-01-01 15:30:00', 1);

INSERT INTO facilities (facid, name, membercost, guestcost, initialoutlay, monthlymaintenance) VALUES
(0, 'Tennis Court 1', 5, 25, 10000, 200),
(1, 'Tennis Court 2', 5, 25, 8000, 200),
(2, 'Badminton Court', 0, 15.5, 4000, 50),
(3, 'Table Tennis', 0, 5, 320, 10),
(4, 'Massage Room 1', 35, 80, 4000, 3000),
(5, 'Massage Room 2', 35, 80, 4000, 3000),
(6, 'Squash Court', 3.5, 17.5, 5000, 80),
(7, 'Snooker Table', 0, 5, 450, 15),
(8, 'Pool Table', 0, 5, 400, 15);

INSERT INTO members (memid, surname, firstname, address, zipcode, telephone, recommendedby, joindate) VALUES
(0, 'GUEST', 'GUEST', 'GUEST', 0, '(000) 000-0000', NULL, '2012-07-01 00:00:00'),
(1, 'Smith', 'Darren', '8 Bloomsbury Close, Boston', 4321, '555-555-5555', NULL, '2012-07-02 12:02:05'),
(2, 'Smith', 'Tracy', '8 Bloomsbury Close, New York', 4321, '555-555-5555', NULL, '2012-07-02 12:08:23'),
(3, 'Rownam', 'Tim', '23 Highway Way, Boston', 23423, '(844) 693-0723', NULL, '2012-07-03 09:32:15'),
(4, 'Joplette', 'Janice', '20 Crossing Road, New York', 234, '(833) 942-4710', 1, '2012-07-03 10:25:05'),
(5, 'Butters', 'Gerald', '1065 Huntingdon Avenue, Boston', 56754, '(844) 078-4130', 1, '2012-07-09 10:44:09'),
(6, 'Tracy', 'Burton', '3 Tunisia Drive, Boston', 45678, '(822) 354-9973', NULL, '2012-07-15 08:52:55'),
(7, 'Dare', 'Nancy', '6 Hunting Lodge Way, Boston', 10383, '(833) 776-4001', 4, '2012-07-25 08:59:12'),
(8, 'Boothe', 'Tim', '3 Bloomsbury Close, Reading, 00234', 234, '(811) 433-2547', 3, '2012-07-25 16:02:35'),
(9, 'Stibbons', 'Ponder', '5 Dragons Way, Winchester', 87630, '(833) 160-3900', 6, '2012-07-25 17:09:05'),
(10, 'Owen', 'Charles', '52 Cheshire Grove, Winchester, 28563', 28563, '(855) 542-5251', 1, '2012-08-03 19:42:37'),
(11, 'Jones', 'David', '976 Gnats Close, Reading', 33862, '(844) 536-8036', 4, '2012-08-06 16:32:55'),
(12, 'Baker', 'Anne', '55 Powdery Street, Boston', 80743, '844-076-5141', 9, '2012-08-10 14:23:22'),
(13, 'Farrell', 'Jemima', '103 Firth Avenue, North Reading', 57392, '(855) 016-0163', NULL, '2012-08-10 14:28:01'),
(14, 'Smith', 'Jack', '252 Binkington Way, Boston', 69302, '(822) 163-3254', 1, '2012-08-10 16:22:05'),
(15, 'Bader', 'Florence', '264 Ursula Drive, Westford', 84923, '(833) 499-3527', 9, '2012-08-10 17:52:03'),
(16, 'Baker', 'Timothy', '329 James Street, Reading', 58393, '833-941-0824', 13, '2012-08-15 10:34:25'),
(17, 'Pinker', 'David', '5 Impreza Road, Boston', 65332, '811 409-6734', 13, '2012-08-16 11:32:47'),
(20, 'Genting', 'Matthew', '4 Nunnington Place, Wingfield, Boston', 52365, '(811) 972-1377', 5, '2012-08-19 14:55:55'),
(21, 'Mackenzie', 'Anna', '64 Perkington Lane, Reading', 64577, '(822) 661-2898', 1, '2012-08-26 09:32:05'),
(22, 'Coplin', 'Joan', '85 Bard Street, Bloomington, Boston', 43533, '(822) 499-2232', 16, '2012-08-29 08:32:41'),
(24, 'Sarwin', 'Ramnaresh', '12 Bullington Lane, Boston', 65464, '(822) 413-1470', 15, '2012-09-01 08:44:42'),
(26, 'Jones', 'Douglas', '976 Gnats Close, Reading', 11986, '844 536-8036', 11, '2012-09-02 18:43:05'),
(27, 'Rumney', 'Henrietta', '3 Burkington Plaza, Boston', 78533, '(822) 989-8876', 20, '2012-09-05 08:42:35'),
(28, 'Farrell', 'David', '437 Granite Farm Road, Westford', 43532, '(855) 755-9876', NULL, '2012-09-15 08:22:05'),
(29, 'Worthington-Smyth', 'Henry', '55 Jagbi Way, North Reading', 97676, '(855) 894-3758', 2, '2012-09-17 12:27:15'),
(30, 'Purview', 'Millicent', '641 Drudgery Close, Burnington, Boston', 34232, '(855) 941-9786', 2, '2012-09-18 19:04:01'),
(33, 'Tupperware', 'Hyacinth', '33 Cheerful Plaza, Drake Road, Westford', 68666, '(822) 665-5327', NULL, '2012-09-18 19:32:05'),
(35, 'Hunt', 'John', '5 Bullington Lane, Boston', 54333, '(899) 720-6978', 30, '2012-09-19 11:32:45'),
(36, 'Crumpet', 'Erica', 'Crimson Road, North Reading', 75655, '(811) 732-4816', 2, '2012-09-22 08:36:38'),
(37, 'Smith', 'Darren', '3 Funktown, Denzington, Boston', 66796, '(822) 577-3541', NULL, '2012-09-26 18:08:45');

ALTER TABLE ONLY bookings
    ADD CONSTRAINT bookings_pk PRIMARY KEY (bookid);

ALTER TABLE ONLY facilities
    ADD CONSTRAINT facilities_pk PRIMARY KEY (facid);

ALTER TABLE ONLY members
    ADD CONSTRAINT members_pk PRIMARY KEY (memid);

ALTER TABLE ONLY bookings
    ADD CONSTRAINT fk_bookings_facid FOREIGN KEY (facid) REFERENCES facilities(facid);

ALTER TABLE ONLY bookings
    ADD CONSTRAINT fk_bookings_memid FOREIGN KEY (memid) REFERENCES members(memid);

ALTER TABLE ONLY members
    ADD CONSTRAINT fk_members_recommendedby FOREIGN KEY (recommendedby) REFERENCES members(memid) ON DELETE SET NULL;

CREATE INDEX "bookings.memid_facid"
  ON bookings
  USING btree
  (memid, facid);

CREATE INDEX "bookings.facid_memid"
  ON bookings
  USING btree
  (facid, memid);

CREATE INDEX "bookings.facid_starttime"
  ON bookings
  USING btree
  (facid, starttime);

CREATE INDEX "bookings.memid_starttime"
  ON bookings
  USING btree
  (memid, starttime);

CREATE INDEX "bookings.starttime"
  ON bookings
  USING btree
  (starttime);

CREATE INDEX "members.joindate"
  ON members
  USING btree
  (joindate);

CREATE INDEX "members.recommendedby"
  ON members
  USING btree
  (recommendedby);

ANALYZE;