--
-- PostgreSQL database dump
--

-- Dumped from database version 10.4
-- Dumped by pg_dump version 10.4

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: pg_trgm; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS pg_trgm WITH SCHEMA public;


--
-- Name: EXTENSION pg_trgm; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pg_trgm IS 'text similarity measurement and index searching based on trigrams';


--
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry, geography, and raster spatial types and functions';

CREATE USER kursant;
ALTER USER kursant WITH PASSWORD 'postgis';

CREATE TABLE public.bledne_geometrie (
    id integer,
    osm_id bigint NOT NULL,
    name character varying(255),
    type character varying(255),
    area real,
    z_order smallint,
    geometry public.geometry(Geometry,2180),
    st_isvalidreason text
);


ALTER TABLE public.bledne_geometrie OWNER TO kursant;

--
-- Name: cdma; Type: TABLE; Schema: public; Owner: kursant
--

CREATE TABLE public.cdma (
    x real,
    y real,
    nazwaoper character varying,
    nrdecyzji character varying,
    rodzajdec character varying,
    datawano timestamp without time zone,
    miejscowo character varying,
    lokalizacj character varying,
    idstacji integer,
    teryt character varying
);


ALTER TABLE public.cdma OWNER TO kursant;

--
-- Name: gatunki; Type: TABLE; Schema: public; Owner: kursant
--

CREATE TABLE public.gatunki (
    id integer NOT NULL,
    date_from character varying,
    date_to character varying,
    species_cd character varying,
    species_num integer,
    species_name character varying,
    latin_name character varying,
    shrubtree_fl character varying,
    bot_species character varying,
    bot_genus character varying,
    bot_name character varying,
    fomatree_grp character varying,
    act_tree_grp character varying,
    wood_kind_fl character varying,
    height_grp character varying,
    volume_grp character varying,
    worth_grp character varying,
    c_species_cd character varying,
    wage_grp_fl character varying,
    plants_fsawing_qty integer,
    plants_psawing_qty integer,
    plants_foil_qty integer,
    gat_grp character varying,
    ibl_grp character varying,
    lmr_reg_fl character varying
);


ALTER TABLE public.gatunki OWNER TO kursant;

--
-- Name: gatunki_id_seq; Type: SEQUENCE; Schema: public; Owner: kursant
--

CREATE SEQUENCE public.gatunki_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.gatunki_id_seq OWNER TO kursant;

--
-- Name: gatunki_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kursant
--

ALTER SEQUENCE public.gatunki_id_seq OWNED BY public.gatunki.id;


--
-- Name: oso; Type: TABLE; Schema: public; Owner: kursant
--

CREATE TABLE public.oso (
    id integer NOT NULL,
    geom public.geometry(MultiPolygon,2180),
    gid integer,
    nazwa character varying(254),
    kod character varying(254),
    kodinspire character varying(254)
);


ALTER TABLE public.oso OWNER TO kursant;

--
-- Name: oso_id_seq; Type: SEQUENCE; Schema: public; Owner: kursant
--

CREATE SEQUENCE public.oso_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.oso_id_seq OWNER TO kursant;

--
-- Name: oso_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kursant
--

ALTER SEQUENCE public.oso_id_seq OWNED BY public.oso.id;


--
-- Name: pomniki_przyrody; Type: TABLE; Schema: public; Owner: kursant
--

CREATE TABLE public.pomniki_przyrody (
    id integer NOT NULL,
    geom public.geometry(Point,2180),
    gid integer,
    kodinspire character varying(254),
    obiekt character varying(254),
    nazwa character varying(254),
    fop_id integer,
    gatunek character varying(254),
    data_utwor date,
    powierzchn character varying(254),
    link character varying(254)
);


ALTER TABLE public.pomniki_przyrody OWNER TO kursant;

--
-- Name: pomniki_przyrody_id_seq; Type: SEQUENCE; Schema: public; Owner: kursant
--

CREATE SEQUENCE public.pomniki_przyrody_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pomniki_przyrody_id_seq OWNER TO kursant;

--
-- Name: pomniki_przyrody_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kursant
--

ALTER SEQUENCE public.pomniki_przyrody_id_seq OWNED BY public.pomniki_przyrody.id;


--
-- Name: rezerwaty; Type: TABLE; Schema: public; Owner: kursant
--

CREATE TABLE public.rezerwaty (
    id integer NOT NULL,
    geom public.geometry(MultiPolygon,2180),
    gid integer,
    nazwa character varying(254),
    kodinspire character varying(254)
);


ALTER TABLE public.rezerwaty OWNER TO kursant;

--
-- Name: rezerwaty_id_seq; Type: SEQUENCE; Schema: public; Owner: kursant
--

CREATE SEQUENCE public.rezerwaty_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rezerwaty_id_seq OWNER TO kursant;

--
-- Name: rezerwaty_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kursant
--

ALTER SEQUENCE public.rezerwaty_id_seq OWNED BY public.rezerwaty.id;


--
-- Name: siedliska; Type: TABLE; Schema: public; Owner: kursant
--

CREATE TABLE public.siedliska (
    id integer NOT NULL,
    date_from character varying,
    date_to character varying,
    site_type_cd character varying,
    site_type_name character varying,
    site_type_nr integer,
    site_type_grp integer,
    site_type_grp_act character varying
);


ALTER TABLE public.siedliska OWNER TO kursant;

--
-- Name: siedliska_id_seq; Type: SEQUENCE; Schema: public; Owner: kursant
--

CREATE SEQUENCE public.siedliska_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.siedliska_id_seq OWNER TO kursant;

--
-- Name: siedliska_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kursant
--

ALTER SEQUENCE public.siedliska_id_seq OWNED BY public.siedliska.id;


--
-- Name: soo; Type: TABLE; Schema: public; Owner: kursant
--

CREATE TABLE public.soo (
    id integer NOT NULL,
    geom public.geometry(MultiPolygon,2180),
    gid integer,
    nazwa character varying(254),
    kod character varying(254),
    kodinspire character varying(254)
);


ALTER TABLE public.soo OWNER TO kursant;

--
-- Name: soo_id_seq; Type: SEQUENCE; Schema: public; Owner: kursant
--

CREATE SEQUENCE public.soo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.soo_id_seq OWNER TO kursant;

--
-- Name: soo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kursant
--

ALTER SEQUENCE public.soo_id_seq OWNED BY public.soo.id;


--
-- Name: wydzielenia; Type: TABLE; Schema: public; Owner: kursant
--

CREATE TABLE public.wydzielenia (
    id integer NOT NULL,
    geom public.geometry(MultiPolygon,2180),
    a_i_num bigint,
    adr_for character varying(25),
    area_type character varying(11),
    site_type character varying(9),
    silvicult character varying(5),
    forest_fun character varying(6),
    stand_stru character varying(8),
    rotat_age bigint,
    sub_area double precision,
    prot_categ character varying(9),
    species_cd character varying(9),
    part_cd character varying(3),
    spec_age bigint,
    a_year bigint
);


ALTER TABLE public.wydzielenia OWNER TO kursant;

--
-- Name: wydzielenia_id_seq; Type: SEQUENCE; Schema: public; Owner: kursant
--

CREATE SEQUENCE public.wydzielenia_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.wydzielenia_id_seq OWNER TO kursant;

--
-- Name: wydzielenia_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kursant
--

ALTER SEQUENCE public.wydzielenia_id_seq OWNED BY public.wydzielenia.id;


--
-- Name: gatunki id; Type: DEFAULT; Schema: public; Owner: kursant
--

ALTER TABLE ONLY public.gatunki ALTER COLUMN id SET DEFAULT nextval('public.gatunki_id_seq'::regclass);


--
-- Name: oso id; Type: DEFAULT; Schema: public; Owner: kursant
--

ALTER TABLE ONLY public.oso ALTER COLUMN id SET DEFAULT nextval('public.oso_id_seq'::regclass);


--
-- Name: pomniki_przyrody id; Type: DEFAULT; Schema: public; Owner: kursant
--

ALTER TABLE ONLY public.pomniki_przyrody ALTER COLUMN id SET DEFAULT nextval('public.pomniki_przyrody_id_seq'::regclass);


--
-- Name: rezerwaty id; Type: DEFAULT; Schema: public; Owner: kursant
--

ALTER TABLE ONLY public.rezerwaty ALTER COLUMN id SET DEFAULT nextval('public.rezerwaty_id_seq'::regclass);


--
-- Name: siedliska id; Type: DEFAULT; Schema: public; Owner: kursant
--

ALTER TABLE ONLY public.siedliska ALTER COLUMN id SET DEFAULT nextval('public.siedliska_id_seq'::regclass);


--
-- Name: soo id; Type: DEFAULT; Schema: public; Owner: kursant
--

ALTER TABLE ONLY public.soo ALTER COLUMN id SET DEFAULT nextval('public.soo_id_seq'::regclass);


--
-- Name: wydzielenia id; Type: DEFAULT; Schema: public; Owner: kursant
--

ALTER TABLE ONLY public.wydzielenia ALTER COLUMN id SET DEFAULT nextval('public.wydzielenia_id_seq'::regclass);


--
-- Data for Name: bledne_geometrie; Type: TABLE DATA; Schema: public; Owner: kursant
--

COPY public.bledne_geometrie (id, osm_id, name, type, area, z_order, geometry, st_isvalidreason) FROM stdin;
166694	183128131	\N	forest	13413.9707	34	010300002084080000010000001D0000007D39D7D01DA21F41D07A6F9D928413416979AF763BA21F411096F0A0438413412F669FDC52A21F41008823053A84134151F9DB653AA21F4170617B1244841341F5727E5D01A21F41F0609104F1831341200B1AEA81A11F4170CF46E5298413418B130BC226A11F416045F315578413415160A504F1A01F41D0C75B59758413411D8B64FBB0A01F41F0DD93C488841341D9FB063F7CA01F4190FAC70F828413410FF1015F2DA01F4180F5BD0B70841341F663FF882EA01F41E08C2ABF45841341027330F114A01F4170D8E357258413415EC3C734E09F1F41D041A7991E841341072C097B849F1F41207C52EC60841341F1401B2B439F1F4190B1A8E5A3841341756A2C04119F1F41101FECCB01851341160F2601E09E1F4190DA125C358513414613B090C49E1F41F06C59B7598513418DAB0E27C39E1F411004F58F8E851341009BE820D79E1F414039506BB9851341105727DF459F1F41A0633EFFC68513417D9665097A9F1F415040E9DEE285134125B082F1E99F1F41C0117C26C6851341E0A6CA6550A01F41105762D57E85134177DBEB94CBA01F4140DC2CFD478513416D638FC331A11F41C01CE7410B851341BD4611AC02A21F41F04B5E59AC8413417D39D7D01DA21F41D07A6F9D92841341	Self-intersection[518286.865280076 319760.908829341]
365302	228389735	\N	forest	205026.281	34	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	Self-intersection[510327.189067435 183256.546181143]
716730	313964509	\N	forest	253361.984	34	01030000208408000001000000230000008E308E3359DF0841F8AD3ECC5D212141FA81C2A59BDF0841A081E09C622121411271AE3F9FE10841607B5D46692121416C7208E827E20841E8BDC7CE6A2121413E32E10CDEE40841404D519B722121419C6CEC5A04E50841A8E7056072212141F8E4564E9EE6084158553D2C501F214178350DD131E7084118640FA68B1E2141BE9C6739A2E70841B02408DDF51D21417E45420843E8084180ABB6A21F1D214172533E8AF0E808418826726C381C214140ABDDE61DEA084130F674ECA61A2141CC4C010B35E60841181A76319B1A2141E8D7DF066FE20841502E8DE38F1A214132B60AC840E1084198195C598C1A21413AA0443F17E20841A0426808FC1A21411AD07959CBE10841B85E505D5A1B2141E26E1EAF47E10841D0DE175D9A1B21419E028B0C77E0084198EC5E0BF11B2141AE255BB268E0084148CC9778D61B21412E3E71E7E7E0084140E2F9926D1B21414EC476555AE1084170F4303B4B1B2141265E95135FE10841E8EACF7E0F1B2141F22EEC2B43E1084130D8370DCC1A21413A33F98FDCE008417866712C8B1A2141F66503792FE1084118A597258C1A214176A0A19ECADF08411883A8F7871A214188EDAD74A0DF0841B84F5074871A2141B64D6CD04EDF0841783D2DF6681B2141C837A48D94DE084120D5AB006B1D21415001FA1A94DE084130E39E216C1D21412CDEBEB72CDE0841984EE38A891E2141B032B33013DE084178986CF9CF1E214164E25E9D34DD084158B02D3B362121418E308E3359DF0841F8AD3ECC5D212141	Self-intersection[203803.570743048 560453.587924391]
718009	313964538	\N	forest	15723.0654	34	010300002084080000010000000D00000036E9A880FB0209416006C404A6162141568E62E79F020941A058DA68F01621412EF7BA657506094158DA62A91C1721418E6BC340110B094178EBA5D251172141E0B2532C51070941C04B78902617214148E22BAAAD06094150540AFCA416214154A07DF16C050941B846B76B89162141AED9F04053050941C0AF387174162141A8DE94ADCD04094120A3A270071621412CBC5F86A8050941289C0D7B331521414E5A9B665705094138875A55CA14214166045F8E4405094100650987CA14214136E9A880FB0209416006C404A6162141	Self-intersection[205034.146618125 560019.282085707]
816495	337629120	\N	wood	8599.28125	29	010300002084080000010000001900000074C601B2A851114110E872D05C181E41B58227DAAF511141D039DEEACB181E413B1459A9DF51114180C12A5705191E41DA675CF5C5511141C08697EF49191E41AFF7AAD9AF511141D0E082D996191E417AF8ECCEDD511141C0D6E3AD7C191E41EEFBF2FA025211418074130EED181E413EEF15AE1A521141704E6E6C74181E41D043CF1E32521141F06600FDD6171E4148447DCC5F52114150D1465FBE161E411BBA902468521141C05B73849B151E41B452D0E16C52114120A40C7E62141E41549E1DE1F9511141007C3CA7A5111E41CDCD1E78CE511141406C3ACCC5111E41ECCB5BFC1A52114190B2E53731131E41285848B64052114180246D2EBC131E411EB25DCE40521141F07236DF72141E41286946604452114150DA97D197151E41DC4E1CDE2A521141F05B392E41161E41FE32B4980C521141E0E0546272151E41E05FE9640D521141501ACA3465151E414F8970ACFF5111414087B85F48161E41C904DE79CF511141A07C8B71D8161E414C87224AB251114180F4C627A7171E4174C601B2A851114110E872D05C181E41	Self-intersection[283779.149436518 492892.598155688]
830478	341379511	\N	forest	2892.49805	34	01030000208408000001000000190000009C48D4CAA41A2641B00FCDE51965254118FC7A7BD21A2641487D3BB01D6525412C2A5410041B2641587DDCC7216525417CC22B70041B2641C00DB43D1D6525411499A6B3061B2641E8247FDF01652541F7D0EF5A2D1B264178307D0F056525417A6623FF2B1B264150CC1E7D156525411495EC182A1B26419865A5852C6525410912F563401B26419020495F2E65254143E3E174421B2641C0AA5B872E6525416AAE8752411B264118BFB1253C652541949EDC90601B2641F08F50BB3E65254147BC8217571B264118B143EF3D652541CB4489085B1B264160F684490E652541F5EB68915D1B2641E8F37B9BEF64254140F47F925E1B2641A8B27088E3642541B9C26C46291B2641207DF420DF64254193756EB9131B264128C7235ADD642541F6C869C2F11A26415074CD8ADA6425417EBE001ED91A264188ED0F7CD8642541460F7CD4AF1A2641E08A7813D564254148C69717AA1A2641400697571A6525416FB9143F9A1A26413872AD0719652541421A8FD09E1A26413876CB66196525419C48D4CAA41A2641B00FCDE519652541	Self-intersection[724309.046276321 701069.168702014]
889610	364774111	\N	forest	20385.6074	34	0103000020840800000100000020000000FA2A2DDFD084174160593101AFA41C4152B2B398B2841741101071A788A41C41DE1B4098B9841741F0B21C4F63A41C41B275D1F73D8617418041059ECFA41C4100084FAC9386174140AE1B1110A51C410014EB76C0861741B092924305A51C41CC488604EE86174110662DB5C5A41C41D6A4494F50871741607FD702D5A41C413D9FD2E9A2871741806240BF8EA41C417F864B81FF871741203D2FFAA5A41C414228206194881741F02EDF77A6A41C415A645049D8881741D077969189A41C4135D745826589174110A8BC1192A41C41C498DE8E9A891741E00A1C9E44A41C416AF1E698EA881741007B9381FCA31C414AE7152387881741B039285C10A41C4142D1D698F287174110152E8FC9A31C41FCB796638B871741E03B9851E3A31C4162C63BD4738717412067D0F235A41C41441DD5F643871741F0B3D2F765A41C4165B6F63BE285174170B0F37D89A31C416D4B7CCD33861741309F984516A31C41F7421258C5851741908812AFF5A21C41A6215ADEEC841741D05FA9C31DA41C41E2446195B984174170106F5AB9A31C41720126414F851741801DA207DDA21C414738AA8D8F8417413008635093A21C410B80C9A02F84174150EDDC843FA31C41C77056ED45841741900DF7300AA41C41008CDF199484174160E6527DACA41C4165AEC98FD1841741105BAB06AFA41C41FA2A2DDFD084174160593101AFA41C41	Self-intersection[385332.216501573 469291.749335447]
1543540	597048903	\N	forest	8927.53906	34	01030000208408000001000000250000009AAFFDC19AB2144100C7C5AE1161104184E3025FF0B21441800E4E160F61104186E43D1E5BB31441B0C96FF99D601041059E2EEBC2B3144120F92A9B665F1041B4ABFCE443B41441509F36F9745F104150CD9FB165B41441209475685B5F1041606F9B3E45B4144170BFF5E14D5F10413CC9F965ABB51441506FEFA5A65E10414A875FD651B51441C08DB7C4AE5E104173163BAC46B51441C0F966A87E5E1041D8800B0281B5144120F25F90585E104118C09AA4B0B5144110FD120E235E104183D74DA805B51441B042CBF87C5E1041CC9C4FBEFFB414413034F6CCBF5E1041BBA92945B0B41441C0579782FD5E10414504700F8AB41441F0967E4FEB5E1041EB7F211DCAB41441802B8B509C5E10419992BFE17BB41441F018A36FC55E1041C2F29FAB7BB4144110CA801B805E1041EE77F9FE46B41441C01CAE81BA5E1041DA3105504CB41441D09CA407F25E10417D0439D404B41441003F46D0F75E1041BA514FD9DDB31441B0D67933CC5E1041184A2C8FD5B3144180401483AA5E10415448F3AD0FB41441D0DEBB1EB45D10416CF3988304B41441507E7502845D104162F9DAFA24B41441606EAA58515D1041C092F6D462B4144160997150FE5C10419F8C88055BB41441706F3E7A745C104191E66F914CB4144100A59196505C10413F3093991EB4144130B646C67E5C104137B9ED7EFEB31441A09E51AB0E5D10419E84ADCBFCB31441607B1EB74D5D10413C2C3BE3E7B31441507794D35C5E10416AE4A13C39B31441C0682723AE5F1041C8FD06ADEAB214416036F055DB5F10419AAFFDC19AB2144100C7C5AE11611041	Self-intersection[339193.970306994 268183.209708139]
1643211	638964208	\N	forest	834.636108	34	01030000208408000001000000070000002824DC5446471241E02C5B0EFABC1341387492D86647124180AFC481A9BC13418DE31448D4471241004B64F371BC13415261ED9E06481241800209D5F9BB1341DB1A283E10481241F065D965C9BB134140B7048191481241600EFA7ABCBB13412824DC5446471241E02C5B0EFABC1341	Self-intersection[299509.073330922 323356.480674914]
1697968	665252824	\N	forest	2601.85327	34	0103000020840800000100000013000000B2E0D5C2DD5617412860DC74481A2541A6BA2A3DF15617419013BACE641A2541C4B87D7D22571741C88E78BD731A2541A1AE720140571741E8509819751A254180AFE84E4E57174198669075751A2541EC92F01667571741102E3D11631A2541565E6FD291571741A8A5B6145B1A2541A81C7507B857174158F519C95D1A2541344776C3BD571741B83A36F53A1A2541957D4ACDAB571741B86640292B1A254164F55B9347571741E07A7049181A25414A0C10FDB156174110FF9A1DFC1925419751594D71561741C81BDB72031A254122FA47EB93561741D0C83E23171A254174A98D9C995617412017A521251A2541D523C835B656174110B7040D2D1A2541B1F22699DE5617414075581F381A2541A03622C0DD561741604E34AE481A2541B2E0D5C2DD5617412860DC74481A2541	Self-intersection[382391.440481692 691492.228862989]
1698879	665498088	\N	forest	63575.6953	34	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	Self-intersection[377055.694125464 689946.117687731]
1704849	667283580	\N	wood	33768.0625	29	010300002084080000010000001C000000C08F9363090617414096691829FB2441DCAC2BB7FA051741188496C320FB2441DB776A33EE051741806ED0770AFB2441683062627E051741B8CBC6A062FA24411A37F10EAA041741C806E94633FA24412B8C439BCE031741E0E3EDEF43FA24410A612397AE031741D094D82959FA24410232DDC065031741109210B961FA24413C7D195F1F0317417863D9BC86FA2441F10B244625031741B8628D24B4FA2441C8835FAB1A031741D8492F595BFB2441C1901B59FA021741905F3DE57FFB24410E08D6A20F031741E8FAEBD4A4FB2441147C0B274E0317414014F81BBFFB24417ADF9B749703174188AE8AD4C6FB244135B5A829DC0317413898B408CEFB24412879712B0604174190B4DE37E9FB2441A45E2BEF03041741C83EE03F23FC2441D3D45CE7C6031741488EDCA345FC24418BE46AAD35031741087469C27AFC2441BC4E149665031741E8A2610B90FC244177CB8D47340417418095AE6A42FC24417746C271760417419008F36F5EFC244103499372A1041741D865CDE641FC24413D6B0D23EA04174198FAABD7A9FB2441490B4909DD051741B0B5FC2936FB2441A8E8A5161D06174190BC5A4623FB2441C08F9363090617414096691829FB2441	Self-intersection[377218.344026954 687508.544028995]
\.


--
-- Data for Name: cdma; Type: TABLE DATA; Schema: public; Owner: kursant
--

COPY public.cdma (x, y, nazwaoper, nrdecyzji, rodzajdec, datawano, miejscowo, lokalizacj, idstacji, teryt) FROM stdin;
19.9722214	50.8950005	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0537/1/11	P	2021-06-30 00:00:00	Włoszczowa	dz. nr 151/1	10231	2613063
22.7997227	50.1530571	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0366/1/11	P	2020-12-31 00:00:00	Mołodycz	dz. nr 907 i 910	22995	1804112
15.9416666	53.4794426	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0034/1/07	P	2017-10-31 00:00:00	Linowo	dz. nr 38	11	3203023
22.9783325	50.9622231	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0005/1/07	P	2017-09-30 00:00:00	Felicjan	\N	2013	0606032
21.4025002	52.8841667	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0497/1/11	P	2021-02-28 00:00:00	Różan	Ostrowska, dz. nr 841/2	11134	1411073
18.3908329	53.2186127	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0404/1/11	P	2020-12-31 00:00:00	Unisław	Żwirki i Wigury 9	44200	0404072
23.0852776	50.0852776	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0374/1/11	P	2020-12-31 00:00:00	Łukawiec	dz. nr 2411/8	24607	1809082
19.8377781	53.1300011	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0562/1/11	P	2021-06-30 00:00:00	Lubowidz	Jana Pawła II 86	13320	1437032
18.9258327	53.7197227	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0139/1/10	P	2020-09-30 00:00:00	Kwidzyn	Południowa 14A, dz. nr 1/13	43999	2207011
20.8236103	50.7955551	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0551/1/11	P	2021-06-30 00:00:00	Daleszyce	Głowackiego 37	11768	2604053
22.2677784	51.7544441	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0211/1/10	P	2020-11-30 00:00:00	Adamów	dz. nr 299/8	11670	0611032
22.3672218	52.9461098	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0564/1/11	P	2021-06-30 00:00:00	Faszcze	dz. nr 33/11 33/12	13343	2013102
17.2191658	54.1124992	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0306/1/10	P	2020-11-30 00:00:00	Witanowo	\N	43724	2201042
22.7983341	49.7752762	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0518/1/11	P	2021-04-30 00:00:00	Przemyśl	Batorego 26	24111	1862011
17.623333	50.6416664	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0074/1/07	P	2017-11-30 00:00:00	Niemodlin	Drzymały 4	4011	1609073
18.7844448	52.8691673	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0191/1/10	P	2020-09-30 00:00:00	Ciechocinek	gen. Bema 44	44077	0401021
19.978056	51.8172226	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0254/1/10	P	2020-11-30 00:00:00	Jeżów	targowisko gminne	30754	1021042
20.2027779	52.3891678	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0547/1/11	P	2021-06-30 00:00:00	Wyszogród	Niepodległości 56	11689	1419153
18.1288891	54.210556	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0330/1/10	P	2020-11-30 00:00:00	Szymbark	\N	44689	2205062
21.5719452	53.0813904	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0429/1/11	P	2021-01-31 00:00:00	Ostrołęka	Kopernika 9	11953	1461011
17.0222225	50.9833336	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0077/1/07	P	2017-11-30 00:00:00	Żórawina	Osiedleńcza 17	16	0223092
18.0400009	52.8169441	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0299/1/10	P	2020-11-30 00:00:00	Piechcin	Radłowska	42531	0419013
18.5986118	50.7855568	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0241/1/10	P	2020-11-30 00:00:00	Molna	dz. nr 142/4	22917	2407032
22.3294449	49.8747215	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0180/1/10	P	2020-09-30 00:00:00	Drohobyczka	dz. nr 76	24704	1813022
21.5049992	52.5866661	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0029/1/07	P	2017-10-31 00:00:00	Kamieńczyk	\N	2006	1435053
18.794445	51.9833336	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0313/1/10	P	2020-11-30 00:00:00	Uniejów	Reymonta, dz. nr 1791/10	33919	1011043
20.7513885	50.684166	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0535/1/11	P	2021-06-30 00:00:00	Pierzchnica	Gumienice, dz. nr 16/1	10181	2604152
17.9941673	51.5322227	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0471/1/11	P	2021-01-31 00:00:00	Mikstat	RTCN Kalisz-Mikstat	33770	3018063
18.6102772	51.1472206	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0118/1/10	P	2020-09-30 00:00:00	Pątnów	dz. nr 516/2	30639	1017072
18.0455551	51.0144463	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0572/1/11	P	2021-06-30 00:00:00	Wołczyn	Dworcowa 36	22370	1604043
16.376112	50.7400017	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0526/1/11	P	2021-04-30 00:00:00	Jugowice	dz. nr 67	33687	0221082
21.2272224	49.5497208	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0367/1/11	P	2020-12-31 00:00:00	Sękowa	dz. nr 209/4	24056	1205092
22.769722	52.5486107	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0440/1/11	P	2021-01-31 00:00:00	Grodzisk k/Siemiatycz	SLR Makarki	13591	2010042
21.3513889	54.2172241	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0413/1/11	P	2020-12-31 00:00:00	Barciany	Kościuszki 12, dz. nr 239	44933	2808022
21.8463898	50.794445	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0557/1/11	P	2021-06-30 00:00:00	Zawichost	dz. nr 1651/1 i 1650	12484	2609093
15.4688892	51.0758324	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0379/1/11	P	2020-12-31 00:00:00	Gryfów Śląski	dz. nr 73	30673	0212013
19.8950005	53.0699997	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0058/1/07	P	2017-11-30 00:00:00	Żuromin	Lidzbarska 50	2034	1437063
22.0786114	50.9633331	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0215/1/10	P	2020-11-30 00:00:00	Dzierzkowice	dz. nr 158	12073	0607032
17.8824997	52.1597214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0078/1/07	P	2017-11-30 00:00:00	Zagorów	Berdychów 61	28	3023083
17.0305557	50.9858322	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0472/1/11	P	2021-01-31 00:00:00	Żórawina	Aleja Niepodległości 57	34258	0223092
17.4888897	52.8366661	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0527/1/11	P	2021-04-30 00:00:00	Damasławek	oczyszczalnia ścieków	33860	3028022
20.7272224	54.3227768	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0406/1/11	P	2020-12-31 00:00:00	Bezledy	dz. nr 12/13	44404	2801032
15.3416662	53.5766678	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0037/2/08	zmP	2017-11-30 00:00:00	Dobropole	dz. nr 264/3	10	3218013
20.5311108	52.5030556	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0541/1/11	P	2021-06-30 00:00:00	Załuski	\N	10666	1420122
22.1338882	51.5463905	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0198/1/10	P	2020-11-30 00:00:00	Czołna	dz. nr 1/1	10188	0614022
23.7833328	53.1100006	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0352/2/11	zmP	2020-12-31 00:00:00	Wierobie	Wierobie 41, dz. nr 2/2	13088	2002042
19.0763893	52.1666679	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0603/1/11	P	2021-06-30 00:00:00	Grabów	Odechów 13, dz. nr 18/2	33701	1004042
17.0352783	51.3027763	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0464/1/11	P	2021-01-31 00:00:00	Trzebnica	Obobrnicka 22	33127	0220033
22.0958328	53.1627769	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0015/1/07	P	2017-09-30 00:00:00	Łomża	Szosa Zambrowska	2021	2062011
19.9586105	49.4188881	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0372/1/11	P	2020-12-31 00:00:00	Maruszyna	Jana Pawła II 1	24477	1211142
21.4638882	49.9633331	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0092/1/08	P	2018-06-30 00:00:00	Głobikowa	SLR TP Emitel	4024	1803042
19.2211113	53.6138878	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0039/1/07	P	2017-11-30 00:00:00	Limża	dz. nr 233	2019	2807043
20.6802769	50.9316673	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0560/1/11	P	2021-06-30 00:00:00	Wiśniówka Mała	dz.nr 14/35	12600	2604092
22.7727776	51.7563896	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0167/1/10	P	2020-09-30 00:00:00	Wohyń	Polna 4, dz. nr 401/1	13214	0615082
18.2633343	52.2619438	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0689/1/14	P	2024-09-30 00:00:00	Konin	Przemysłowa 85	32465	3062011
19.2391663	49.8480568	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0582/1/11	P	2021-06-30 00:00:00	Czaniec	Kard. Karola Wojtyły	24306	2402082
19.2175007	53.8208351	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0475/1/11	P	2021-01-31 00:00:00	Prabuty	Rodowo 27	40860	2207043
20.353056	49.6797218	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0243/1/10	P	2020-11-30 00:00:00	Słopnice	dz. nr 2711	24297	1207112
16.2122231	52.6080551	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0420/1/11	P	2020-12-31 00:00:00	Chrzypsko Wielkie	dz. nr 96/2	30547	3014012
21.4008331	52.8805542	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0051/1/07	P	2017-11-30 00:00:00	Różan	dz. nr 80, 83	2028	1411073
18.3174992	50.7122231	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0358/1/11	P	2020-12-31 00:00:00	Dabrowica	Opolska 6	22260	1608013
20.9925003	52.1730537	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0157/1/10	P	2020-09-30 00:00:00	Warszawa	Postępu 3	10707	1465011
20.3397217	49.5677795	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0170/1/10	P	2020-09-30 00:00:00	Kamienica	dz. nr 2268/2	22724	1207052
23.3127785	51.559166	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0418/2/13	zmP	2020-12-31 00:00:00	Lubień	dz. nr 187	12081	1209022
20.4080563	51.0216675	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0623/1/11	P	2021-06-30 00:00:00	Smyków	Straszów, dz. nr 821	12515	2604112
18.5438881	54.0466652	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0485/1/11	P	2021-01-31 00:00:00	Godziszewo	SLR Trzcińsk 29	44134	2213122
16.9799995	51.1175003	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0296/1/10	P	2020-11-30 00:00:00	Wrocław	Bystrzycka 24	34103	0264011
23.0702782	52.0341682	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0431/1/11	P	2021-01-31 00:00:00	Biała Podlaska	Warszawska 125A	13580	0661011
18.2066669	51.1180573	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0169/1/10	P	2020-09-30 00:00:00	Byczyna	dz. nr 381/20 i 382/20	22217	1604013
19.0552769	50.4147224	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0506/1/11	P	2021-04-30 00:00:00	Bobrowniki	dz. nr 523	22038	2401042
17.8999996	54.7444458	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0333/1/10	P	2020-11-30 00:00:00	Choczewo	Pucka 100/2	44711	2215042
18.5122223	52.0202789	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0061/1/07	P	2017-11-30 00:00:00	Turek	Kolska Szosa 28	26	3027011
21.5888882	52.7611122	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0554/1/11	P	2021-06-30 00:00:00	Długosiodło	dz. nr 969	11946	1435022
18.9591675	51.894722	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0047/1/07	P	2017-11-30 00:00:00	Poddębice	Sienkiewicza 48	4020	1011033
18.3297215	52.3988876	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0017/1/07	P	2017-09-30 00:00:00	Żółwieniec	\N	2	3010123
16.583334	52.6175003	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0038/1/07	P	2017-11-30 00:00:00	Szamotuły	Lipowa 2A	23	3024073
20.5347214	53.9775009	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0659/1/11	P	2021-06-30 00:00:00	Orzechowo	dz. nr 94/2	44496	2814033
17.9663887	50.4777794	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0449/1/11	P	2021-01-31 00:00:00	Krapkowice	Opolska 32	22299	1605023
18.3236103	53.0502777	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0127/1/10	P	2020-09-30 00:00:00	Przyłubie	dz. nr 316	40807	0403083
19.8866673	54.0644455	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0192/1/10	P	2020-09-30 00:00:00	Skowrony	Zakład Rolny	44465	2804022
16.0811119	50.9438896	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0385/1/11	P	2020-12-31 00:00:00	Bolków	Gorzanowice 8, dz. nr 72/2	33185	0205023
17.8652782	53.872776	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0328/1/10	P	2020-11-30 00:00:00	Osowo	dz. nr 275/2	44539	2206032
21.4305553	50.5280571	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0201/1/10	P	2020-11-30 00:00:00	Osiek	stadion sportowy	10244	2612043
17.5705547	52.0713882	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0018/1/07	P	2017-09-30 00:00:00	Żerków	Cmentarna 8	4	3006043
19.4261112	50.356945	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0578/1/11	P	2021-06-30 00:00:00	Dąbrowa Górnicza	Sztorcowa 21	22988	2465011
22.7830563	52.1855545	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0007/1/07	P	2017-09-30 00:00:00	Chotcze	\N	2003	1410023
23.7619438	50.9052773	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0415/1/11	P	2020-12-31 00:00:00	Teratyn	dz. nr 179	10211	0604072
17.0174999	53.0069427	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0185/1/10	P	2020-09-30 00:00:00	Konstantynowo	dz. nr 132/2	33752	3001032
16.0052776	51.5974998	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0258/1/10	P	2020-11-30 00:00:00	Radwanice	dz. nr 125/11	33780	0216062
14.7883329	53.9619446	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0394/1/11	P	2020-12-31 00:00:00	Kamień Pomorski	Rzemieślnicza 13	43139	3207033
21.6022224	49.8777771	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0179/1/10	P	2020-09-30 00:00:00	Cieszyna	dz. nr 140	24660	1819022
23.1416664	52.5283318	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0631/1/11	P	2021-06-30 00:00:00	Milejczyce	dz. nr 1129/1	11949	2010062
17.6127777	51.0691681	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0245/1/10	P	2020-11-30 00:00:00	Krasowice	43	24509	1606023
14.8019447	52.8866653	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0135/1/10	P	2020-09-30 00:00:00	Rościn	dz. nr 188/9	43545	3210043
20.9719448	49.6113892	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0357/1/11	P	2020-12-31 00:00:00	Biała Wyżna	\N	22240	1210011
23.1269436	51.3116684	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0343/1/11	P	2020-12-31 00:00:00	Wólka Cycowska	Wólka Cycowska 65B	10198	0610012
20.4547215	49.9644432	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0053/1/07	P	2017-11-30 00:00:00	Bochnia	Brzeźnicka	4026	1201011
21.8480549	53.9383316	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0021/1/07	P	2017-09-30 00:00:00	Miłki	Jeziorna 2	2009	2806062
19.3494453	52.8708344	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0530/1/11	P	2021-04-30 00:00:00	Skępe	Kolejowa 33/35	44107	0408073
19.0177784	51.5141678	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0250/1/10	P	2020-11-30 00:00:00	Sędziejowice	12	30501	1003032
21.9327774	53.4336128	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0148/1/10	P	2020-09-30 00:00:00	Gromadzyń Stary	dz. nr 2	11629	2006032
19.146389	50.773613	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0455/1/11	P	2021-01-31 00:00:00	Częstochowa	Palmowa 25a	24147	2464011
16.3927784	52.9816666	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0291/1/10	P	2020-11-30 00:00:00	Siedlisko	dz. nr 583/1	33877	3002073
16.6369438	52.4633331	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0273/1/10	P	2020-11-30 00:00:00	Rumianek	Nowa 7, dz.nr 34/2	33056	3021172
16.1405563	52.4000015	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0460/1/11	P	2021-01-31 00:00:00	Bolewice	Szkolna 64	32389	3015032
20.4558334	49.9641685	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0456/1/11	P	2021-01-31 00:00:00	Bochnia	Brzeźnicka	24515	1201011
17.582222	53.2311096	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0315/1/10	P	2020-11-30 00:00:00	Mrocza	teren byłego GS-u	44166	0410023
16.4844437	51.7191658	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0184/2/11	zmP	2020-09-30 00:00:00	Góra Śląska	Brzeżany, dz. nr 87	33547	0204013
16.8474998	51.6155548	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0065/1/07	P	2017-11-30 00:00:00	Rawicz	Gen. J. Hallera 2	30	3022053
23.0708332	52.0347214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0030/1/07	P	2017-10-31 00:00:00	Biała Podlaska	Warszawska 125	2011	0661011
15.8858337	54.0469437	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0300/2/11	zmP	2020-11-30 00:00:00	Karlino	Kolobrzeska 6	43202	3201033
23.6147213	53.0272217	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0663/1/11	P	2021-06-30 00:00:00	Michałowo	dz. nr 1139	11661	2002072
17.4016666	53.5383339	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0326/1/10	P	2020-11-30 00:00:00	Stare Gronowo	dz. nr 293/1	44519	2203043
17.9044437	50.9636116	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0519/1/11	P	2021-04-30 00:00:00	Fałkowice	Fałkowice 109	24507	1606032
20.4074993	51.6472206	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0674/1/11	P	2021-07-31 00:00:00	Strzałki	Strzałki	31705	1406083
19.2772217	53.1386108	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0339/1/10	P	2020-11-30 00:00:00	Wąpielsk	dz. nr 17/1	44876	0412062
22.3772221	51.9163895	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0543/1/11	P	2021-06-30 00:00:00	Łuków	Świderska 42	11277	0611011
19.8422222	51.1986122	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0594/1/11	P	2021-06-30 00:00:00	Ręczno	dz. nr 450/3	31701	1010072
21.9677773	50.269165	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0237/1/10	P	2020-11-30 00:00:00	Raniżów	dz. nr 678/5	22719	1806052
19.5697231	51.9677773	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0119/1/10	P	2020-09-30 00:00:00	Gozdów	Gozdów 12	30848	1020083
15.2919445	51.9877777	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0651/1/11	P	2021-06-30 00:00:00	Leśniów Wielki	Leśniów Wielki 90	33168	0809033
19.7202778	52.6652794	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0097/1/10	P	2020-09-30 00:00:00	Proboszczewice	dz. nr 13/6, 13/9, 14/10	11238	1419132
21.1013889	51.6474991	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0552/1/11	P	2021-06-30 00:00:00	Stromiec	Białobrzeska 5	11930	1401052
20.8611107	49.5305557	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0512/1/11	P	2021-04-30 00:00:00	Łabowa	dz. nr 92/4	22356	1210082
21.9688892	51.622776	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0432/1/11	P	2021-01-31 00:00:00	Ryki	Janiszewska 80	13581	0616043
19.1441669	52.3561096	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0130/1/10	P	2020-09-30 00:00:00	Kamienna	PGR	42781	0418113
23.2519436	53.7758331	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0636/1/11	P	2021-06-30 00:00:00	Hruskie	dz. nr 187	13085	2001072
21.4652786	50.3111115	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0089/1/08	P	2018-05-31 00:00:00	Mielec	Wojska Polskiego 3	4191	1811011
19.0341663	53.9249992	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0609/1/11	P	2021-06-30 00:00:00	Sztum	Czarnieckiego	42185	2216053
23.128334	50.7188873	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0149/1/10	P	2020-09-30 00:00:00	Zawada	Zawada 54, dz. nr 452/3	12005	0620142
16.7447224	54.5052795	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0335/1/10	P	2020-11-30 00:00:00	Postomino	Postomino 69	44715	3213052
21.5144444	54.0797234	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0665/1/11	P	2021-06-30 00:00:00	Parcz	dz. nr 5/16	44939	2808032
22.6513882	49.8922234	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0371/1/11	P	2020-12-31 00:00:00	Rokietnica	dz. nr 2915/1	24469	1804092
17.0522213	53.3572235	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0285/1/10	P	2020-11-30 00:00:00	Złotów	Za Dworcem 3	33565	3031011
16.5938892	52.9022217	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0468/1/11	P	2021-01-31 00:00:00	Czarnków	Chodzieska 11	33563	3002011
21.5858326	51.2519455	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0161/1/10	P	2020-09-30 00:00:00	Ciepielów	dz. nr 528/1	11926	1409022
17.6144447	52.6238899	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0668/1/11	P	2021-07-31 00:00:00	Modliszewko	\N	30727	3003032
20.8602772	49.6199989	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0493/1/11	P	2021-01-31 00:00:00	Cieniawa	Cieniawa 44	22239	1210042
15.5505552	51.5705566	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0652/1/11	P	2021-06-30 00:00:00	Szprotawa	Kożuchowska 4	33316	0810073
17.3244438	51.0380554	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0670/1/11	P	2021-07-31 00:00:00	Jelcz Laskowice	Al. Młodych 40	33346	0215033
19.1588898	52.5349998	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0312/1/10	P	2020-11-30 00:00:00	Kowal	Dobiegniewska	44080	0418011
16.3697224	52.7150002	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0595/1/11	P	2021-06-30 00:00:00	Wronki	Myśliwska 19	32316	3024083
22.8850002	52.8594437	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0441/1/11	P	2021-01-31 00:00:00	Topczewo	dz. nr 142/4	13592	2003082
17.7794437	50.3583336	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0646/1/11	P	2021-06-30 00:00:00	Wierzch	Wierzch 118a	24556	1610023
22.9616661	52.3858337	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0638/1/11	P	2021-06-30 00:00:00	Maćkowicze	\N	13160	2010052
21.917223	50.6380539	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0238/1/10	P	2020-11-30 00:00:00	Karczmiska	dz. nr 1475	22815	1818062
18.3580551	51.2530556	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0587/1/11	P	2021-06-30 00:00:00	Czastary	Kniatowy, dz. nr 171	30659	1018022
19.5200005	54.1300011	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0145/1/10	P	2020-09-30 00:00:00	Przezmark	Przezmark 1	44491	2804012
17.5324993	50.9180565	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0239/1/10	P	2020-11-30 00:00:00	Lubsza	dz. nr 193	22859	1601052
17.5319443	51.6119461	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0251/1/10	P	2020-11-30 00:00:00	Sulmierzyce	Poznańska 20	30507	3012011
22.2350006	52.9844437	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0168/1/10	P	2020-09-30 00:00:00	Zambrów	Polowa 4a, dz. nr 609/1	13401	2014011
22.1286106	52.0980568	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0152/1/10	P	2020-09-30 00:00:00	Skórzec	dz. nr 223/3	13147	1426092
20.7722225	52.6736107	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0042/1/07	P	2017-11-30 00:00:00	Świercze Koty	Pułtuska 18	2030	1424052
20.4180565	53.0950012	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0438/2/12	zmP	2021-01-31 00:00:00	Szydłówek	SLR Szydłówek	13589	1413082
18.3675003	53.8697205	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0533/1/11	P	2021-04-30 00:00:00	Lubichowo	dz. nr 116/1	44515	2213062
14.9527779	52.0133324	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0525/1/11	P	2021-04-30 00:00:00	Wężyska	Stacja Pkp	33170	0802063
18.1738892	50.8130569	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0229/1/10	P	2020-11-30 00:00:00	Bierdzany	dz. nr 1018/55	22262	1609132
16.4011116	52.4438896	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0294/1/10	P	2020-11-30 00:00:00	Duszniki Wielkopolskie	Kolejowa 23	33887	3024022
18.0733337	54.478611	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0337/1/10	P	2020-11-30 00:00:00	Pobłocie	dz. nr 64	44813	2215062
21.0049992	52.2316666	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0439/1/11	P	2021-01-31 00:00:00	Warszawa	Plac Defilad 1	13590	1465011
21.5513897	50.7211113	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0099/1/10	P	2020-09-30 00:00:00	Kleczanów	dz. nr 162/6	12541	2609062
19.7372227	50.6302795	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0103/1/10	P	2020-09-30 00:00:00	Zawadka	Zawadka 25	22220	2416032
14.9274998	51.708889	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0380/1/11	P	2020-12-31 00:00:00	Jurzyn	Jurzyn 95/2	31113	0811043
16.4602776	53.9577789	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0655/1/11	P	2021-06-30 00:00:00	Jatynka	dz. nr 57/3	43683	3209033
21.5319443	53.6336098	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0610/1/11	P	2021-06-30 00:00:00	Ruciane-Nida	dz. nr 192/269	43030	2816043
22.4547215	53.9522209	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0391/1/11	P	2020-12-31 00:00:00	Gąski	dz. nr 76/1	43013	2813043
21.5111103	51.8858337	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0204/1/10	P	2020-11-30 00:00:00	Ewelin	\N	11217	1403042
22.5544453	52.8611107	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0151/1/10	P	2020-09-30 00:00:00	Szepietowo	dz. nr 122/7	13026	2013092
22.6547222	51.0050011	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0048/1/07	P	2017-11-30 00:00:00	Boży Dar	dz. nr 80/2, 80/3, 207, 206, 121/2, 122/2, 133, 198, 132	2012	0609092
23.4119453	51.8788872	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0641/1/11	P	2021-06-30 00:00:00	Tuczna	dz. nr 215/10	13221	0601172
23.4258327	50.4627762	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0633/1/11	P	2021-06-30 00:00:00	Tomaszów Lubelski	Łaszczowiecka, dz. nr 27/2	12032	0618011
16.4063892	51.080555	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0272/1/10	P	2020-11-30 00:00:00	Bielany	dz. nr 51	33040	0205062
20.9741669	53.5644455	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0143/1/10	P	2020-09-30 00:00:00	Szczytno	Gnieznienska 2	44386	2817011
21.2600002	49.502224	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0517/1/11	P	2021-04-30 00:00:00	Gładyszów	dz. nr 464/4	22863	1205102
16.7763882	54.226944	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0396/1/11	P	2020-12-31 00:00:00	Podgóry	dz. nr 80	43209	2212053
16.978611	52.8133316	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0523/1/11	P	2021-04-30 00:00:00	Tarnowo	dz. nr 228/6	32312	3016023
19.6752777	52.185833	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0182/1/10	P	2020-09-30 00:00:00	Bedlno	Szewce Nadolne 15	30801	1002022
23.0894451	51.7202759	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0639/1/11	P	2021-06-30 00:00:00	Jabłoń	dz. nr 2182	13217	0613022
23.3799992	50.9163895	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0159/1/10	P	2020-09-30 00:00:00	Żułów	\N	11787	0606062
15.3888893	51.894165	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0672/1/11	P	2021-07-31 00:00:00	Świdnica	Obwodowa 15	33728	0809072
15.7075005	51.3169441	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0383/1/11	P	2020-12-31 00:00:00	Różyniec	Różyniec 20	33044	0201032
14.8841667	53.0686111	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0392/1/11	P	2020-12-31 00:00:00	Mielęcin Szczeciński	Krzemlin 18	43089	3212053
15.2394447	51.2294426	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0389/1/11	P	2020-12-31 00:00:00	Wykroty	Wyzwolenia 38	34544	0201043
17.4249992	54.0536118	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0072/1/07	P	2017-11-30 00:00:00	Wojsk	SLR TP Emitel	54	2201052
20.5194435	53.7527771	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0488/1/11	P	2021-01-31 00:00:00	Olsztyn	Masztowa 1	44372	2862011
22.2244453	50.3100014	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0178/1/10	P	2020-09-30 00:00:00	Łętownia	dz. nr 4647/1	24578	1808053
21.9108334	49.7252769	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0106/1/10	P	2020-09-30 00:00:00	Wola Komborska	dz. nr 753	22255	1807052
17.8516674	52.2947235	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0073/1/07	P	2017-12-31 00:00:00	Słupca	Bielawska 5	29	3023011
20.5708332	51.3588905	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0436/1/11	P	2021-01-31 00:00:00	Przysucha	Kozłowiec 131	13586	1423063
21.1147213	51.4097214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0437/1/11	P	2021-01-31 00:00:00	Radom	Przytycka 2	13587	1463011
21.0049992	52.1791649	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0679/1/11	P	2021-07-31 00:00:00	Warszawa	Wołoska 16	13599	1465011
17.9033337	54.3494453	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0615/1/11	P	2021-06-30 00:00:00	Sierakowice	Brzozowa 3	44174	2205042
21.4247227	50.2866669	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0444/1/11	P	2021-01-31 00:00:00	Mielec	Mickiewicza 34	20582	1811011
22.351944	51.3311119	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0150/1/10	P	2020-09-30 00:00:00	Bogucin	dz.nr 590/6	12722	0609042
22.3663883	49.5636101	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0376/1/11	P	2020-12-31 00:00:00	Tyrawa Wołoska	dz. nr 930/2, 931/2	24633	1817062
19.1183338	50.1888885	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0075/1/07	P	2017-11-30 00:00:00	Mysłowice	Orła Białego	4009	2470011
18.8202782	52.5333328	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0680/1/11	P	2021-10-31 00:00:00	Lubraniec	\N	44189	0418123
16.1358337	52.1855545	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0584/1/11	P	2021-06-30 00:00:00	Jabłonna	Błońsko 26, dz. nr 59/2	30546	3005043
18.0030556	51.2975006	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0278/1/10	P	2020-11-30 00:00:00	Kępno	Grabowska 7	33231	3008033
23.9008331	50.5002785	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0666/1/11	P	2021-06-30 00:00:00	Telatyn	Kolonia Radków, dz. nr 72	12030	0618102
18.190834	50.0849991	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0081/1/07	P	2018-03-31 00:00:00	Racibórz	Cmentarna	4015	2411011
19.9413891	53.5497208	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0026/1/07	P	2017-10-31 00:00:00	Wysoka Wieś	\N	2031	2815092
21.7658329	52.2486115	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0212/1/10	P	2020-11-30 00:00:00	Wólka Kałuska	polana leśna	11686	1412093
19.6075001	52.3647232	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0222/1/10	P	2020-11-30 00:00:00	Szczawin Kościelny	Spółdzielcza 8	13328	1404052
21.9686108	51.3255539	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0430/1/11	P	2021-01-31 00:00:00	Kazimierz Dolny	Góry 46	12772	0614043
21.8063889	49.4777794	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0363/1/11	P	2020-12-31 00:00:00	Jaśliska	Królik Wołoski, dz. nr 35/1	22851	1807023
22.0672226	50.6958351	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0110/1/10	P	2020-09-30 00:00:00	Lipa	dz. nr 1674/5	22908	1818052
18.8683338	49.7997208	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0495/1/11	P	2021-01-31 00:00:00	Grodziec	Grodziec 34	24599	2402052
20.7863884	51.253334	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0219/1/10	P	2020-11-30 00:00:00	Chlewiska	hydrofornia	12603	1430012
20.9472218	51.8219452	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0203/1/10	P	2020-11-30 00:00:00	Jasieniec	Olszańska	10543	1406062
18.3830547	51.9963875	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0050/1/07	P	2017-11-30 00:00:00	Dziadowice	dz. nr 197/3, 197/4	17	3027052
20.0955563	50.0058327	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0154/1/10	P	2020-09-30 00:00:00	Węgrzce Wielkie	dz. nr 444/23	22975	1219053
20.9436111	52.2080574	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0088/1/08	P	2018-04-30 00:00:00	Warszawa	Al. Jerozolimskie 162A	2078	1465011
19.6100006	51.231945	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0265/1/10	P	2020-11-30 00:00:00	Gorzkowice	Przemysłowa 40	31700	1010032
18.1755562	53.2669449	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0069/1/07	P	2017-11-30 00:00:00	Trzeciewiec	RTCN TP Emitel	40	0403032
18.3830547	51.9963875	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0461/1/11	P	2021-01-31 00:00:00	Dziadowice	Dziadowice 35	32512	3027052
21.2691669	49.7255554	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0104/1/10	P	2020-09-30 00:00:00	Biecz	dz. nr 2840	22243	1205023
18.4111118	50.8427773	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0513/1/11	P	2021-04-30 00:00:00	Olesno	Szkolna 144, Wachowice, dz. nr 236 i 237/7	22424	1608033
16.7408333	54.0041656	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0071/1/07	P	2017-11-30 00:00:00	Gołogóra	RTCN TP Emitel	74	3209063
21.9466667	51.1061096	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0216/1/10	P	2020-11-30 00:00:00	Ożarów Drugi	wysypisko odpadów komunalnych	12090	0612053
20.023056	51.5597229	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0588/1/11	P	2021-06-30 00:00:00	Tomaszów Mazowiecki	Warszawska 168/172	30800	1016011
18.0327778	54.5897217	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0195/1/10	P	2020-09-30 00:00:00	Strzebielino	\N	44814	2215082
19.0433331	50.2722206	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0113/1/10	P	2020-09-30 00:00:00	Katowice	Leopolda 31	24161	2469011
17.6136112	51.8644447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0289/1/10	P	2020-11-30 00:00:00	Dobrzyca	Ostrowska 1	33788	3020032
23.1491661	53.127224	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0426/1/11	P	2021-01-31 00:00:00	Białystok	Cieszyńska 3, SLR Białystok	11668	2061011
21.0505562	50.8608322	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0083/1/07	P	2018-03-31 00:00:00	Św. Krzyż	RTCN TP Emitel	4010	2604132
20.1094437	52.5497208	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0223/1/10	P	2020-11-30 00:00:00	Bulkowo	dz. nr 74/2	13330	1419042
18.8494453	50.3613892	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0101/1/10	P	2020-09-30 00:00:00	Bytom	J. Frenzla	22009	2462011
16.9655552	53.5347214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0252/1/10	P	2020-11-30 00:00:00	Lędyczek	Leśna, dz. nr 187	30541	3031053
18.6186104	53.7908325	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0128/1/10	P	2020-09-30 00:00:00	Barłożno	dz. nr 39	40854	2213102
14.8088884	53.6788902	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0131/1/10	P	2020-09-30 00:00:00	Babigoszcz	dz. nr 27/2	43144	3204062
18.6152782	51.0341682	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0234/1/10	P	2020-11-30 00:00:00	Jaworek	Jaworek 55/1	22359	1608062
20.5222225	50.4319458	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0202/1/10	P	2020-11-30 00:00:00	Mozgawa	dz. nr 840/1	10278	2608043
23.4747219	52.0361099	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0625/1/11	P	2021-06-30 00:00:00	Wólka Dobryńska	\N	11090	0601192
15.6916666	52.1997223	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0589/1/11	P	2021-06-30 00:00:00	Smardzewo	\N	31019	0808042
23.3302784	51.7552795	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0640/1/11	P	2021-06-30 00:00:00	Sosnówka	dz. nr 475/1	13219	0601152
18.9533329	51.7791672	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0003/1/07	P	2017-09-30 00:00:00	Zygry	\N	4003	1011062
19.7611103	49.5572205	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0492/1/11	P	2021-01-31 00:00:00	Spytkowice	dz. nr 4079/7	22156	1211132
15.6822224	53.8849983	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0477/1/11	P	2021-01-31 00:00:00	Sławoborze	RTCN Białogard	42969	3216052
19.021389	52.4830551	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0531/1/11	P	2021-04-30 00:00:00	Choceń	Czerniewicka	44970	0418052
22.1561108	49.5088882	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0244/1/10	P	2020-11-30 00:00:00	Niebieszczany	dz.nr 481/3	24358	1817052
20.0797215	50.3325005	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0115/1/10	P	2020-09-30 00:00:00	Wymysłów	dz. nr 238	24529	1208053
16.6072216	51.4655571	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0284/1/10	P	2020-11-30 00:00:00	Wińsko	Witosa 13	33548	0222022
16.7386112	54.003334	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0482/1/11	P	2021-01-31 00:00:00	Żydowo k/Sławna	RTCN Gołogóra	43657	3209063
19.6516666	52.8916664	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0041/1/07	P	2017-11-30 00:00:00	Rachocin	dz. nr 30/2	2025	1427052
20.6038895	52.8563881	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0690/1/15	P	2025-08-31 00:00:00	Ciechanów	Tysiąclecia 18	11692	1402011
18.3663883	53.4622231	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0126/1/10	P	2020-09-30 00:00:00	Dólsk	dz. nr 120/4	40805	0414032
23.1774998	52.7766685	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0345/1/11	P	2020-12-31 00:00:00	Bielsk Podlaski	Rejonowa 2	11268	2003011
18.9327774	49.8161125	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0509/1/11	P	2021-04-30 00:00:00	Jasienica	Koscielna	22122	2402052
19.6061115	51.4377785	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0458/1/11	P	2021-01-31 00:00:00	Majków Średni	SLR Majków	30868	1010042
18.7275009	51.6038895	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0474/1/11	P	2021-01-31 00:00:00	Sieradz	Mickiewicza 6	35738	1014011
17.0580559	51.814167	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0019/1/07	P	2017-09-30 00:00:00	Domachowo	\N	5	3004033
22.315834	50.5086098	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0577/1/11	P	2021-06-30 00:00:00	Ulanów	Dabrówka dz. nr 1412/1	22909	1812073
15.5963888	53.1847229	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0304/1/10	P	2020-11-30 00:00:00	Suliszewo	Zielona, dz. nr 643/3	43681	3202023
18.7047215	53.230835	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0302/1/10	P	2020-11-30 00:00:00	Zelgno	dz. nr 145	43419	0415022
18.2988892	52.080555	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0054/1/07	P	2017-11-30 00:00:00	Tuliszków	Zaręby 14	27	3027073
21.6275005	50.2255554	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0516/1/11	P	2021-04-30 00:00:00	Niwiska Kolbuszowskie	SKR w Niwiskach	22765	1806042
21.2955551	53.8633347	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0486/1/11	P	2021-01-31 00:00:00	Mrągowo	Spacerowa 2	44358	2810011
22.5094452	51.5605545	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0160/1/10	P	2020-09-30 00:00:00	Firlej	Baza GS	11794	0608032
15.9925003	53.0183334	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0287/1/10	P	2020-11-30 00:00:00	Przesieki	dz. nr 166/2	33763	3002043
19.5880547	49.9033318	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0175/1/10	P	2020-09-30 00:00:00	Wysoka	dz. nr 842/4 i 842/1	24326	1218093
22.4944439	49.3838882	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0086/1/08	P	2018-03-31 00:00:00	Góra Jawor	\N	4194	1801083
18.7136116	51.8119431	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0607/1/11	P	2021-06-30 00:00:00	Pęczniew	Spacerowa	33984	1011022
18.0505562	52.0383339	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0602/1/11	P	2021-06-30 00:00:00	Grodziec	Zwierzyniecka 3	33598	3010022
14.9486113	52.7577782	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0667/1/11	P	2021-07-31 00:00:00	Lubiszyn	dz. nr 280	30585	0801052
19.9861107	52.3175011	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0546/1/11	P	2021-06-30 00:00:00	Załusków	dz. nr 108	11641	1428032
16.3905563	53.6863899	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0136/1/10	P	2020-09-30 00:00:00	Kolanowo	dz. nr 189	43682	3215043
20.1736107	50.8252792	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0558/1/11	P	2021-06-30 00:00:00	Małogoszcz	dz. nr 207/7	12514	2602033
15.2777777	52.3469429	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0467/1/11	P	2021-01-31 00:00:00	Łagów Lubuski	RTCN Jemiołów	33534	0808022
20.4991665	52.2588882	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0434/1/11	P	2021-01-31 00:00:00	Kampinos	Wiejca 63B	13584	1432032
18.9472218	51.0158348	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0248/1/10	P	2020-11-30 00:00:00	Popów	Zawady 14a	24613	2406072
18.5663891	52.6827774	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0611/1/11	P	2021-06-30 00:00:00	Dobre Kujawskie	Fabryczna 10	43864	0411032
18.6919441	50.0486107	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0353/1/11	P	2020-12-31 00:00:00	Żory	Rybnicka 14	22113	2479011
22.8852787	52.8594437	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0014/1/07	P	2017-09-30 00:00:00	Topczewo	Szosa Zambrowska	2005	2003082
22.1811104	54.0163879	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0401/1/11	P	2020-12-31 00:00:00	Świętajno	dz. nr  81/35	43934	2813052
22.6366673	51.3711128	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0630/1/11	P	2021-06-30 00:00:00	Niemce	\N	11749	0609112
23.1772213	50.8791656	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0626/1/11	P	2021-06-30 00:00:00	Izbica	dz. nr 3/14	11316	0606042
21.8974991	51.7999992	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0550/1/11	P	2021-06-30 00:00:00	Żelechów	Traugutta 50	11752	1403143
19.3361111	50.7394447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0574/1/11	P	2021-06-30 00:00:00	Olsztyn	Janowska 8	22407	2404122
19.3425007	53.4311104	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0144/1/10	P	2020-09-30 00:00:00	Łąkorz	Łąkorz 34	44425	2812022
17.1227779	53.1605568	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0599/1/11	P	2021-06-30 00:00:00	Wysoka	Jeziorki Kosztowskie 42	33270	3019022
20.1805553	54.2377777	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0688/1/14	P	2024-09-30 00:00:00	Pieniężno	Cmentarna 3	44399	2802053
17.8163891	52.5661125	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0188/1/10	P	2020-09-30 00:00:00	Trzemeszno	Gnieźnieńska 4	34147	3003093
17.1494446	54.5486107	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0620/1/11	P	2021-06-30 00:00:00	Wiklino	dz. nr 158/24	44502	2212082
18.9644451	51.6872215	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0676/1/11	P	2021-07-31 00:00:00	Szadek	Sieradzka	33957	1019023
22.3077774	50.0649986	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0569/1/11	P	2021-06-30 00:00:00	Kosina	dz. nr 4241/1	22166	1810042
15.2780552	52.3474998	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0036/1/07	P	2017-10-31 00:00:00	Jemiołów	\N	25	0808022
17.3197231	52.4233322	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0183/1/10	P	2020-09-30 00:00:00	Sanniki	Folwark Sanniki	32019	3021083
21.4652786	51.6636124	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0146/1/10	P	2020-09-30 00:00:00	Kozienice	Elektrownia Kozienice Sa	11301	1407053
14.6769447	53.3341675	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0062/1/07	P	2018-03-31 00:00:00	Kołowo	RTCN TP Emitel	75	3206072
19.1288891	51.2616653	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0593/1/11	P	2021-06-30 00:00:00	Chabielice	Chabielice Kolonia	31358	1001072
21.5761108	53.0875015	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0055/1/07	P	2017-11-30 00:00:00	Ostrołęka	Kopernika 9	4024	1461011
23.4147224	53.5238876	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0662/1/11	P	2021-06-30 00:00:00	Makowlany	dz. nr 30	11649	2011072
15.1536112	52.1450005	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0653/1/11	P	2021-06-30 00:00:00	Bytnica	dz. nr 19/2	33744	0802032
15.3941669	51.4263878	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0384/1/11	P	2020-12-31 00:00:00	Luboszów	Luboszów 1, dz. nr 16/2	33046	0201052
19.7338886	51.6377792	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0268/1/10	P	2020-11-30 00:00:00	Łaznowska Wola	\N	31711	1016072
17.7683334	52.9327774	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0307/1/10	P	2020-11-30 00:00:00	Chomętowo	dz. nr 101	43801	0410053
17.7041664	54.5713882	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0317/1/10	P	2020-11-30 00:00:00	Czarnówko	wysypisko śmieci	44234	2208042
18.8686104	51.1197205	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0675/1/11	P	2021-07-31 00:00:00	Działoszyn	Ogrodowa 2	33665	1009013
19.9411106	53.5505562	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0487/1/11	P	2021-01-31 00:00:00	Ostróda	SLR Wysoka Wieś	44366	2815092
18.7275009	51.6041679	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0085/1/08	P	2018-03-31 00:00:00	Sieradz	Mickiewicza	4193	1014011
20.1663895	51.230835	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0266/1/10	P	2020-11-30 00:00:00	Sielec	dz. nr 231	31703	1007082
14.2849998	53.8927765	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0393/1/11	P	2020-12-31 00:00:00	Świnoujście	Ludzi Morza, dz. nr 202	43130	3263011
16.2124996	51.815834	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0270/1/10	P	2020-11-30 00:00:00	Łysiny	dz. nr 78/2	32653	0812033
16.6977787	50.4719429	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0654/1/11	P	2021-06-30 00:00:00	Bardo	dz. nr 13/2 (obręb Dębowina)	34216	0208072
19.9947224	52.6297226	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0622/1/11	P	2021-06-30 00:00:00	Staroźreby	dz. nr 868/7	11671	1419142
22.9874992	53.8341675	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0158/1/10	P	2020-09-30 00:00:00	Augustów	Obrońców Westerplatte 16	11257	2001011
15.0994444	51.544445	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0649/1/11	P	2021-06-30 00:00:00	Witoszyn Górny	dz. nr 67/14	33048	0810082
19.8597221	52.4933319	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0567/1/11	P	2021-06-30 00:00:00	Słupno	Młynarska 22	13416	1419122
16.9866657	52.1177788	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0020/1/07	P	2017-09-30 00:00:00	Góra	Góra 42	6	3026043
16.5352783	52.2158318	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0293/1/10	P	2020-11-30 00:00:00	Granowo	Polna 2	33886	3005012
17.5841675	51.2574997	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0277/1/10	P	2020-11-30 00:00:00	Gaszowice	dz. nr 70/2	33210	0214073
22.9147224	50.0141678	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0373/1/11	P	2020-12-31 00:00:00	Laszki	dz. nr 2554/12	24606	1804052
18.959444	52.7141685	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0142/1/10	P	2020-09-30 00:00:00	Włocławek	Toruńska 222	44236	0464011
18.167223	51.7013893	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0457/1/11	P	2021-01-31 00:00:00	Chełmce	SLR Chełmce, dz. nr 110	30567	3007082
16.2616673	53.1713905	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0478/1/11	P	2021-01-31 00:00:00	Wałcz	RTCN Rusinowo	43266	3217043
17.2597218	54.3819427	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0621/1/11	P	2021-06-30 00:00:00	Dębnica Kaszubska	Troszki, dz. nr 46/1	44961	2212032
15.5536108	52.5852776	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0650/1/11	P	2021-06-30 00:00:00	Chełmsko	dz. nr 375/3 i 375/5	33079	0803032
17.8633327	51.043335	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0573/1/11	P	2021-06-30 00:00:00	Domaszowice	Zalesie	22371	1606012
21.4638882	50.3097229	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0445/1/11	P	2021-01-31 00:00:00	Mielec	Wojska Polskiego 3	20583	1811011
22.7752781	50.2724991	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0368/1/11	P	2020-12-31 00:00:00	Majdan Sieniawski	dz. nr 3019/4	24250	1814022
19.7838898	51.8955574	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0271/1/10	P	2020-11-30 00:00:00	Nagawki	Nagawki 25	30700	1021032
16.143055	53.5497208	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0409/1/11	P	2020-12-31 00:00:00	Siemczyno	dz. nr 149/6	44549	3203013
22.8702774	51.4958344	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0349/1/11	P	2020-12-31 00:00:00	Ostrów Lubelski	dz. nr 2435	11759	0608103
23.0783329	50.5091667	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0348/1/11	P	2020-12-31 00:00:00	Szopowe	dz. nr 460	11734	0602073
18.9313889	53.3713875	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0002/1/07	P	2017-09-30 00:00:00	Radzyń Chełmiński	Orłowicza 2	8	0406043
20.4991665	52.2588882	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0009/1/07	P	2017-09-30 00:00:00	Wiejca	Wiejca 63B	2008	1432032
19.561388	51.8113899	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0269/1/10	P	2020-11-30 00:00:00	Nowosolna	WSLR Dąbrowa	31999	1006082
22.4022217	54.1663895	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0407/1/11	P	2020-12-31 00:00:00	Kowale Oleckie	dz. nr 95/1	44446	2813032
22.4575005	53.6597214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0501/1/11	P	2021-02-28 00:00:00	Grajewo	Ełcka 9	13636	2004011
21.417778	49.9202766	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0171/1/10	P	2020-09-30 00:00:00	Siedliska-Bogusz	dz. nr 530	22972	1803022
17.7394447	53.6327782	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0322/1/10	P	2020-11-30 00:00:00	Żalno	dz. 104/1	44316	0416032
20.2661114	52.8369446	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0225/1/10	P	2020-11-30 00:00:00	Zygmuntowo	dz. nr. 50/2 i 51/4	13429	1402033
22.3747215	53.8166656	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0297/1/10	P	2020-11-30 00:00:00	Ełk	Ciepła 8	41255	2805011
19.8441658	51.7397232	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0592/1/11	P	2021-06-30 00:00:00	Koluszki	11 Listopada 65	31299	1006073
16.0088882	52.4000015	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0001/1/07	P	2017-09-30 00:00:00	Bolewice	Szkolna 64	7	3015032
17.606945	50.4874992	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0514/1/11	P	2021-04-30 00:00:00	Korfantów	Powstańców Śl. 11	22547	1607033
22.2075005	50.8383331	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0200/1/10	P	2020-11-30 00:00:00	Rzeczyca Ziemiańska	\N	10223	0607072
18.9116669	52.331665	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0282/1/10	P	2020-11-30 00:00:00	Przedecz	Kościuszki 46	33305	3009113
15.3411112	53.5777779	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0481/1/11	P	2021-01-31 00:00:00	Dobra Nowogardzka	Dobropole 43	43650	3218013
19.9952774	49.7472229	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0109/1/10	P	2020-09-30 00:00:00	Pcim	dz. nr 7719/2	22578	1209042
18.4441662	51.0480537	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0232/1/10	P	2020-11-30 00:00:00	Praszka	Kościuszki, dz. nr 108	22358	1608043
15.8702774	51.1875	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0608/1/11	P	2021-06-30 00:00:00	Zagrodno	\N	34715	0226052
21.018055	49.9813881	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0451/1/11	P	2021-01-31 00:00:00	Tarnowiec k/Tarnowa	RTON Zawada, Góra Św.Marcina	22466	1216092
20.605278	50.1811104	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0236/1/10	P	2020-11-30 00:00:00	Koszyce	dz. nr 1	22480	1214022
20.4861107	53.7705574	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0190/1/10	P	2020-09-30 00:00:00	Olsztyn	Żołnierska 14a	43900	2862011
15.605278	53.7044449	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0129/1/10	P	2020-09-30 00:00:00	Poradz	dz. nr 4	40986	3218023
19.2211113	53.8199997	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0045/1/07	P	2017-11-30 00:00:00	Rodowo	Obiekt TP Emitel	12	2207043
18.7755547	54.0849991	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0693/1/15	P	2025-08-31 00:00:00	Tczew	Kazimierza Wielkiego, dz. nr 217\\11	40790	2214011
19.2186108	53.6138878	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0476/1/11	P	2021-01-31 00:00:00	Limża	RTON Iława/Kisielice	40861	2807043
21.8461113	52.4180565	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0561/1/11	P	2021-06-30 00:00:00	Korytnica	dz. nr 98/1	13110	1433032
22.0919437	53.1591682	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0499/1/11	P	2021-02-28 00:00:00	Łomża	dz. nr 12081	13447	2062011
20.6855564	49.8588905	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0227/1/10	P	2020-11-30 00:00:00	Jurków	\N	22226	1202033
20.4272213	51.3938904	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0591/1/11	P	2021-06-30 00:00:00	Wólka Karwicka	\N	31221	1007043
19.1641674	50.7733345	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0060/1/07	P	2017-11-30 00:00:00	Częstochowa	Palmowa 25a	4065	2464011
17.5458336	54.3602791	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0614/1/11	P	2021-06-30 00:00:00	Czarna Dąbrówka	dz. nr 7/9	44156	2201032
15.1311111	51.7874985	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0648/1/11	P	2021-06-30 00:00:00	Zabłocie	Zabłocie 50	31026	0811043
16.646944	50.1408348	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0534/1/11	P	2021-04-30 00:00:00	Międzylesie	Wojska Polskiego 59, dz. nr 351	33340	0208103
19.8711109	52.8297234	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0565/1/11	P	2021-06-30 00:00:00	Zawidz	Mazowiecka 30	13355	1427072
21.0616665	53.1322212	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0553/1/11	P	2021-06-30 00:00:00	Jednorożec	dz. nr 1366/3	11940	1422042
16.0663891	53.7227783	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0066/1/07	P	2017-11-30 00:00:00	Toporzyk	RTON TP Emitel	79	3216033
19.1508331	49.9674988	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0361/1/11	P	2020-12-31 00:00:00	Jawiszowice	Hubala	22498	1213023
19.0897217	50.7994461	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0568/1/11	P	2021-06-30 00:00:00	Częstochowa	Podkolejowa 45/47	22149	2464011
20.3636112	54.1777763	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0657/1/11	P	2021-06-30 00:00:00	Babiak	dz. nr 20	44441	2809032
19.2161102	51.4616661	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0606/1/11	P	2021-06-30 00:00:00	Zelów	Poznańska	33911	1001083
20.2480564	51.8872223	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0253/1/10	P	2020-11-30 00:00:00	Nowy Kawęczyn	Kolonia Starorawska, baza GS	30552	1015072
21.0080547	52.231945	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0087/1/08	P	2018-04-30 00:00:00	Warszawa	Pl. Defilad 1	2058	1465011
16.2622223	53.1702766	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0035/1/07	P	2017-10-31 00:00:00	Rusinowo	Rusinowo 35	20	3217043
21.2980556	53.8650017	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0032/1/07	P	2017-10-31 00:00:00	Mrągowo	Spacerowa 2	2010	2810011
19.4508343	49.8786125	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0511/1/11	P	2021-04-30 00:00:00	Chocznia	Kościuszki dz. nr 1352/1	22334	1218093
21.8777771	49.9452782	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0228/1/10	P	2020-11-30 00:00:00	Babica	dz. nr 403	22252	1819012
21.9683342	51.6238899	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0006/1/07	P	2017-09-30 00:00:00	Ryki	Janiszewska 80	2017	0616043
18.9438896	53.378334	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0484/1/11	P	2021-01-31 00:00:00	Radzyń Chełmiński	Orłowicza 2	44126	0406043
21.748888	51.2994461	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0559/1/11	P	2021-06-30 00:00:00	Babin	Szlachecki Las, dz. nr 143	12521	1436032
21.3013897	50.1141663	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0581/1/11	P	2021-06-30 00:00:00	Stara Jastrząbka	Wieś Róża, dz. nr 1053	24160	1803032
19.5691662	53.3905563	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0692/1/15	P	2025-08-31 00:00:00	Kurzętnik	dz. nr 1643\\3	44363	2812042
20.9174995	49.7047234	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0242/1/10	P	2020-11-30 00:00:00	Jankowa	Jankowa 180, dz. nr 274/2	22954	1205032
16.5222225	50.7541656	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0117/1/10	P	2020-09-30 00:00:00	Lutomia	dz. nr 355	30575	0219072
15.9319448	53.478054	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0479/1/11	P	2021-01-31 00:00:00	Drawsko Pomorskie	SLR Linowno	43350	3203023
14.6741667	53.3336105	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0490/2/11	zmP	2021-01-31 00:00:00	Kołowo	RTCN Kołowo	44592	3206072
22.6152782	52.3461113	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0637/1/11	P	2021-06-30 00:00:00	Korczew	dz. nr 623/14	13113	1426022
20.7886105	49.958889	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0570/1/11	P	2021-06-30 00:00:00	Wojnicz	Łopoń 194	22194	1216133
19.3405552	52.230278	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0473/1/11	P	2021-01-31 00:00:00	Kutno	Chopina 29	35033	1002011
18.8644447	50.8469429	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0450/1/11	P	2021-01-31 00:00:00	Klepaczka	RTCN Wręczyca	22422	2406092
23.2994442	53.2955551	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0344/1/11	P	2020-12-31 00:00:00	Czarna Białostocka	dz. nr 77	11157	2002023
21.4280548	53.2633324	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0205/1/10	P	2020-11-30 00:00:00	Siarcza Łąka	48, dz. nr 170/1	11282	1415052
21.1419449	54.1699982	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0685/1/14	P	2024-06-30 00:00:00	Korsze	Wolności 5	44394	2808043
20.0155563	51.5302773	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0064/1/07	P	2017-11-30 00:00:00	Tomaszów Mazowiecki	Mościckiego 14/18	4024	1016011
23.5555553	50.7688904	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0629/1/11	P	2021-06-30 00:00:00	Czartoria	dz. nr 42	11726	0620062
15.478056	51.7480545	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0469/1/11	P	2021-01-31 00:00:00	Brzeźnica	RTCN Żagań/Wichów	33586	0810032
17.0849991	53.9241676	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0319/1/10	P	2020-11-30 00:00:00	Koczała	dz. nr 524/9	44250	2203052
16.9272213	52.4041672	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0124/1/10	P	2020-09-30 00:00:00	Poznań	Piekary 14-15	33153	3064011
18.669445	50.3052788	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0580/1/11	P	2021-06-30 00:00:00	Gliwice	Św. Małgorzaty 1	24143	2466011
21.2263889	51.1688881	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0542/1/11	P	2021-06-30 00:00:00	Iłża	\N	11211	1425033
18.5677776	52.5002785	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0338/1/10	P	2020-11-30 00:00:00	Kozy	dz. nr 95/3	44852	0411053
22.8700008	51.1302795	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0424/1/11	P	2021-01-31 00:00:00	Piaski	RTCN Piaski	11125	0617033
22.4488888	50.8411102	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0199/1/10	P	2020-11-30 00:00:00	Blażek	dz. nr 2293/5	10221	0605012
20.123888	51.8736115	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0522/1/11	P	2021-04-30 00:00:00	Dębowa Góra	Żelazna, dz. nr 24/1	30697	1015082
19.9724998	49.2919426	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0520/1/11	P	2021-04-30 00:00:00	Zakopane	dz. nr 125/2 Nr Obrebu 12	26082	1217011
17.6213894	50.6411095	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0452/1/11	P	2021-01-31 00:00:00	Niemodlin	Drzymały, SLR Niemodlin	22499	1609073
23.5974998	50.4269447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0632/1/11	P	2021-06-30 00:00:00	Jarczów	dz. nr 59/2	12029	0618032
19.7172222	53.3286095	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0342/1/10	P	2020-11-30 00:00:00	Mroczno	dz. nr 4/8	44911	2812032
14.415556	52.9474983	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0399/1/11	P	2020-12-31 00:00:00	Chojna	dz. nr 36/237	43677	3206033
16.2808342	53.3577766	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0301/1/10	P	2020-11-30 00:00:00	Górnica	dz. nr 4/1	43291	3217052
22.0983334	52.5461121	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0433/1/11	P	2021-01-31 00:00:00	Chruszczewka Włościańska	SLR Chruszczewka	13583	1429053
21.8458328	53.9383316	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0489/1/11	P	2021-01-31 00:00:00	Miłki	Jeziorna 2	44471	2806062
22.0047226	50.4894447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0247/1/10	P	2020-11-30 00:00:00	Przyszów	dz. nr 1915	24539	1818022
20.2308331	51.1452789	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0556/1/11	P	2021-06-30 00:00:00	Ruda Maleniecka	\N	12314	2605052
16.3408337	52.1194458	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0186/1/10	P	2020-09-30 00:00:00	Wielichowo	Rakoniewicka 31	33885	3005053
19.8813896	52.044445	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0263/1/10	P	2020-11-30 00:00:00	Jamno	Wytwórnia Mas Bitumicznych	31179	1005072
18.0363884	52.2125015	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0123/1/10	P	2020-09-30 00:00:00	Sługocinek	Sługocinek 53	33008	3010013
18.1561108	54.3463898	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0336/1/10	P	2020-11-30 00:00:00	Łapalice	dz. nr 156/23	44724	2205023
15.393611	53.9986115	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0329/1/10	P	2020-11-30 00:00:00	Dargosław	dz. 4/4	44582	3205012
20.5205555	53.7536125	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0043/1/07	P	2017-12-31 00:00:00	Olsztyn	Masztowa 1	2022	2862011
19.4761105	51.581665	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0255/1/10	P	2020-11-30 00:00:00	Wola Kazubowa	Górecka 82	30825	1006113
19.6191673	50.5705566	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0510/1/11	P	2021-04-30 00:00:00	Pradła	Goluchowice 48	22219	2416042
23.7527771	50.5950012	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0417/2/13	zmP	2020-12-31 00:00:00	Łaszczów	dz. nr 26	11728	0618062
18.2419453	52.7497215	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0140/1/10	P	2020-09-30 00:00:00	Inowrocław	Fabryczna 4	44131	0407011
20.5127773	49.7761116	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0111/1/10	P	2020-09-30 00:00:00	Ujanowice	dz. nr 142	22948	1207062
20.458889	51.7825012	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0267/1/10	P	2020-11-30 00:00:00	Biała Rawska	miejskie wysypisko śmieci	31706	1013023
21.2661114	53.1766663	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0210/1/10	P	2020-11-30 00:00:00	Baranowo	Juranda ze Spychowa 43	11653	1415012
20.7419453	53.6355553	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0617/1/11	P	2021-06-30 00:00:00	Pasym	Tylkowo, dz. nr 80/2	44387	2817043
19.7316666	50.2644463	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0575/1/11	P	2021-06-30 00:00:00	Sułoszowa	dz. nr  921 i 922	22610	1206132
22.4280548	49.9752769	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0515/1/11	P	2021-04-30 00:00:00	Kańczuga	Żuklin, dz. nr 1151/3 i 1151/1	22555	1814053
15.7194443	52.771389	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0673/1/11	P	2021-07-31 00:00:00	Gościm	\N	30588	0806023
22.9777775	50.9625015	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0422/1/11	P	2021-01-31 00:00:00	Gorzków	SLR Felicjan	10204	0606032
16.9533329	53.6880569	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0141/1/10	P	2020-09-30 00:00:00	Czarne	dz. nr 8	44192	2203023
21.5486107	54.2236099	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0686/1/14	P	2024-06-30 00:00:00	Leśniewo	5	44475	2808062
17.6933327	54.1419449	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0332/1/10	P	2020-11-30 00:00:00	Nakla	\N	44708	2201072
19.3361111	49.6513901	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0359/1/11	P	2020-12-31 00:00:00	Jeleśnia	dz. nr 3387/1	22349	2417042
20.4222221	53.0958328	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0011/1/07	P	2017-09-30 00:00:00	Szydłówek	\N	2036	1413082
20.0819435	49.9586105	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0076/1/07	P	2017-11-30 00:00:00	Mietniów	Mietniów 70	4090	1219053
21.9861107	50.0497208	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0090/1/08	P	2018-06-30 00:00:00	Rzeszów	Broniewskiego 1	4094	1863011
18.1541672	50.4655571	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0454/1/11	P	2021-01-31 00:00:00	Góra Św Anny	SLR Wysoka, dz. nr 28/1	24055	1611043
21.8544445	52.6136093	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0545/1/11	P	2021-06-30 00:00:00	Sadowne	\N	11604	1433072
16.0647221	53.7194443	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0480/1/11	P	2021-01-31 00:00:00	Połczyn Zdrój	RTON Toporzyk	43542	3216033
19.4497223	50.7180557	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0235/1/10	P	2020-11-30 00:00:00	Janów Częstochowski	Kielecka, dz. nr 361	22408	2404032
18.1544437	50.4650002	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0082/1/07	P	2018-08-31 00:00:00	Góra Św. Anny	SLR TP Emitel	13	1611043
16.1027775	50.7658348	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0387/1/11	P	2020-12-31 00:00:00	Czarny Bór	Borówno, dz. nr 363	33498	0221042
21.8505554	50.9538879	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0163/1/10	P	2020-09-30 00:00:00	Bliskowice	dz. nr 712	12089	0607023
18.1552773	52.3136101	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0598/1/11	P	2021-06-30 00:00:00	Kazimierz Biskupi	Golińska 10	33212	3010032
22.7036114	50.521389	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0207/1/10	P	2020-11-30 00:00:00	Biłgoraj	Krzeszowska 59 A	11349	0602011
19.3313885	52.978611	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0318/1/10	P	2020-11-30 00:00:00	Stary Kobrzyniec	dz. nr 3	44239	0412032
15.6861115	53.8861122	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0049/1/07	P	2017-11-30 00:00:00	Sławoborze	dz. nr 5/1	2028	3216052
21.7666664	52.1027794	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0549/1/11	P	2021-06-30 00:00:00	Cegłów	Piaseczno	11730	1412042
18.435833	54.4527779	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0661/1/11	P	2021-06-30 00:00:00	Chwaszczyno	dz. nr 127	44683	2205083
15.8483334	52.5774994	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0276/1/10	P	2020-11-30 00:00:00	Gorzycko Stare	Gorzycko Stare 22	33204	3014033
19.4611111	50.5538902	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0112/1/10	P	2020-09-30 00:00:00	Włodowice	dz. nr 300/2	22956	2416092
19.019722	49.7211113	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0355/1/11	P	2020-12-31 00:00:00	Szczyrk	Wrzosowa 28 A	22145	2402011
21.0125008	49.9847221	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0080/1/07	P	2017-11-30 00:00:00	Góra Św. Marcin	RTCN TP Emitel	4023	1216092
16.980278	52.1199989	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0462/1/11	P	2021-01-31 00:00:00	Śrem	Góra 42	32745	3026043
19.2322216	52.746666	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0320/1/10	P	2020-11-30 00:00:00	Nowa Wieś	dz. nr 49/6	44276	0408092
20.7138882	49.6547241	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0356/1/11	P	2020-12-31 00:00:00	Nowy Sącz	Zabełecka 34	22230	1262011
18.8600006	50.6522217	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0079/1/07	P	2017-11-30 00:00:00	Koszęcin	Boronowska	4017	2407062
20.3694439	52.6297226	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0691/1/15	P	2025-08-31 00:00:00	Płońsk	Zacisze 3	13307	1420011
14.5950003	52.7347221	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0398/1/11	P	2020-12-31 00:00:00	Boleszkowice	dz. nr 935/6	43669	3210022
20.9936104	50.1863899	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0571/1/11	P	2021-06-30 00:00:00	Dąbrowa Tarnowska	Warszawska, dz. nr 458/7	22288	1204023
21.0327778	50.6811104	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0098/1/10	P	2020-09-30 00:00:00	Raków	stacja benzynowa	11761	2604162
19.2005558	54.3274994	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0683/1/13	P	2023-10-31 00:00:00	Kobyla Kępa	Kobyla Kępa, dz. nr 63/6	43967	2210052
20.3497219	50.478611	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0156/1/10	P	2020-09-30 00:00:00	Lubcza	dz. nr 515	10184	2602092
21.271944	50.4269447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0100/1/10	P	2020-09-30 00:00:00	Połaniec	Krakowska 15	12560	2612053
18.4163895	51.8375015	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0624/1/11	P	2021-06-30 00:00:00	Lisków	Spółdzielców 11	32667	3007062
15.9019442	53.2866669	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0684/1/13	P	2023-10-31 00:00:00	Kalisz Pomorski	dz. nr 16/2	43293	3203033
18.2983341	54.7469444	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0334/1/10	P	2020-11-30 00:00:00	Werblinia	dz. nr 30	44714	2211072
18.8644447	50.8469429	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0057/1/07	P	2017-11-30 00:00:00	Wręczyca Wielka	RTCN TP Emitel	4007	2406092
16.3400002	51.3044434	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0275/1/10	P	2020-11-30 00:00:00	Mierzowice	Mierzowice 51	33160	0209073
19.0913887	51.3477783	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0261/1/10	P	2020-11-30 00:00:00	Szczercowska Wieś	dz. nr 344/2	31171	1001072
15.855278	52.0972214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0280/1/10	P	2020-11-30 00:00:00	Przeszkoda	dz. nr 74/1	33277	3029022
17.8280563	50.166111	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0645/1/11	P	2021-06-30 00:00:00	Bogdanowice	Kwiatowa 22	24555	1602033
22.020834	53.5941658	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0298/1/10	P	2020-11-30 00:00:00	Biała Piska	dz. nr 7/3	41625	2816013
20.1138897	53.0177765	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0563/1/11	P	2021-06-30 00:00:00	Szreńsk	Żuromińska 2	13321	1413072
21.5455551	49.9958344	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0177/1/10	P	2020-09-30 00:00:00	Niedźwiada	dz. nr 5336	24446	1815033
16.5874996	52.9055557	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0023/1/07	P	2017-10-31 00:00:00	Czarnków	Chodzieska 13	22	3002011
19.9208336	49.7908325	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0507/1/11	P	2021-04-30 00:00:00	Stróża k/Myślenic	Stróża,  dz. nr 2447	22076	1209042
22.2938881	54.2816658	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0390/1/11	P	2020-12-31 00:00:00	Gołdap	TON, Piękna Góra	41626	2818033
20.6794453	53.1105537	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0209/1/10	P	2020-11-30 00:00:00	Kostusin	dz. nr 14/1	11633	1413022
21.5436115	51.0122223	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0504/1/11	P	2021-04-30 00:00:00	Bałtów	dz. nr 1023  obręb Bałtów	11697	2607022
22.8230553	50.7513885	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0214/1/10	P	2020-11-30 00:00:00	Radecznica	Klasztorna 2	11757	0620082
18.8672218	50.0058327	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0643/1/11	P	2021-06-30 00:00:00	Kobielice	Rolna 4	22144	2410062
17.9636116	54.1608315	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0137/1/10	P	2020-09-30 00:00:00	Skorzewo	dz. nr 614/1	43746	2206042
19.2191658	49.6313896	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0114/1/10	P	2020-09-30 00:00:00	Juszczyna	dz.nr 1229	24173	2417102
23.4197216	53.8974991	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0416/1/11	P	2020-12-31 00:00:00	Rygol	dz. nr 984	11674	2009022
16.6005554	50.3061104	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0378/1/11	P	2020-12-31 00:00:00	Stara Bystrzyca	dz. nr 172	30572	0208063
19.1161118	50.1880569	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0443/1/11	P	2021-01-31 00:00:00	Mysłowice	Orła Białego 43, RTCN Katowice/Kosztowy	20581	2470011
22.7772217	53.4058342	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0147/1/10	P	2020-09-30 00:00:00	Mońki	Kościelna 57, dz. nr 363/2, 364, 365	11620	2008063
19.3183327	52.6388893	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0613/1/11	P	2021-06-30 00:00:00	Dobrzyń nad Wisłą	Szkolna 4	44100	0408043
17.8066673	53.4038887	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0532/1/11	P	2021-04-30 00:00:00	Mąkowarsko	dz. nr 452/2	44122	0403043
22.2775002	49.6500015	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0249/1/10	P	2020-11-30 00:00:00	Łodzina	dz. nr 692/4	24632	1817052
15.082222	53.5813904	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0411/1/11	P	2020-12-31 00:00:00	Osina k/Nowogardu	dz. nr 354	44629	3204052
20.5708332	51.3588905	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0025/1/07	P	2017-10-31 00:00:00	Kozłowiec	\N	2026	1423063
17.9963894	51.5305557	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0016/1/07	P	2017-09-30 00:00:00	Kaliszowice Kaliskie	Kaliszowice Kaliskie 122D	1	3018063
22.7849998	52.1861115	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0425/1/11	P	2021-01-31 00:00:00	Łosice	RTCN Łosice	11271	1410023
15.4063892	53.4280548	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0134/1/10	P	2020-09-30 00:00:00	Długie	dz. nr 128	43535	3214023
21.4247227	50.2866669	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0022/1/07	P	2017-09-30 00:00:00	Mielec	Mickiewicza 34	4027	1811011
22.2844448	51.0869446	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0536/1/11	P	2021-06-30 00:00:00	Borzechów	\N	10203	0609022
16.7000008	51.5858345	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0288/1/10	P	2020-11-30 00:00:00	Gola Wąsowska	dz. nr 126/1	33774	0204043
20.8950005	53.2675018	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0208/1/10	P	2020-11-30 00:00:00	Chorzele	Grunwaldzka 97, dz. nr 65/2	11631	1422023
21.0938892	51.0488892	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0028/1/07	P	2017-10-31 00:00:00	Starachowice	Martenowska 2	4016	2611011
18.8036118	51.9908333	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0063/1/07	P	2017-11-30 00:00:00	Uniejów	Dąbska	4030	1011043
18.2063885	54.1336098	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0316/1/10	P	2020-11-30 00:00:00	Nowa Karczma	dz. nr 29, 151/6	44178	2206072
23.4208336	51.1472206	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0428/1/11	P	2021-01-31 00:00:00	Chełm	Kumowa Dolina	11786	0603032
19.0283337	49.8080559	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0354/1/11	P	2020-12-31 00:00:00	Bielsko-Biała	Oświęcimska 22	22123	2461011
14.7433329	52.3472214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0524/1/11	P	2021-04-30 00:00:00	Rzepin	Gajec 34 (obok przejazdu kolejowego)	33072	0805043
19.7930565	49.6674995	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0231/1/10	P	2020-11-30 00:00:00	Osielec	dz.nr 4748/3	22335	1215052
18.601944	54.3669434	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0194/1/10	P	2020-09-30 00:00:00	Gdańsk	CLR Gdańsk	44697	2261011
22.8097229	53.7683334	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0350/1/11	P	2020-12-31 00:00:00	Bargłów Kościelny	dz. nr 292/6	11954	2001032
19.3522224	49.5724983	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0494/1/11	P	2021-01-31 00:00:00	Korbielów Górny	dz. nr 3945	22350	2417042
18.1450005	50.3358345	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0448/1/11	P	2021-01-31 00:00:00	Kędzierzyn-Koźle	Piramowicza 22	22234	1603011
16.1616669	54.2016678	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0682/1/13	P	2023-10-31 00:00:00	Koszalin	Morska 54-60	43188	3261011
22.3250008	50.7669449	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0217/1/10	P	2020-11-30 00:00:00	Modliborzyce	dz. nr 144	12323	0605062
19.6075001	51.4377785	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0056/1/07	P	2017-11-30 00:00:00	Majków Średni	dz. nr 51/2	4031	1010042
16.979166	54.1011124	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0331/1/10	P	2020-11-30 00:00:00	Dretyń	dz. nr 29	44700	2201063
15.1499996	52.7258339	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0121/1/10	P	2020-09-30 00:00:00	Gorzów Wielkopolski	Rolna, dz. nr 116	31614	0861011
17.7169437	52.273613	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0596/1/11	P	2021-06-30 00:00:00	Strzałkowo	Młodziejowice 25	33011	3023072
21.5819435	53.809166	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0656/1/11	P	2021-06-30 00:00:00	Mikołajki	Tałcka 2	44251	2810023
21.4638882	50.3097229	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0084/1/08	P	2017-12-31 00:00:00	Mielec	Wojska Polskiego	4192	1811011
20.6394444	51.9441681	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0555/1/11	P	2021-06-30 00:00:00	Skuły	Petrykozy Parcele, dz. nr 91	11970	1405062
23.1511116	53.1277771	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0094/1/08	P	2018-06-30 00:00:00	Białystok	Cieszyńska 3	3039	2061011
17.4050007	53.7408333	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0325/1/10	P	2020-11-30 00:00:00	Polnica	dz. 214/14	44509	2203032
15.6897221	50.9772224	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0528/1/11	P	2021-04-30 00:00:00	Czernica	dz. nr 291	34534	0206062
18.8652782	50.455555	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0176/2/11	zmP	2020-09-30 00:00:00	Tarnowskie Góry	Fabryczna 28	24423	2413041
20.9750004	52.8358345	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0566/1/11	P	2021-06-30 00:00:00	Karniewo	dz. nr 81	13360	1411032
16.0030556	52.8694458	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0601/1/11	P	2021-06-30 00:00:00	Krzyż Wielkopolski	Portowa 6	33562	3002043
17.0272217	50.7394447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0586/1/11	P	2021-06-30 00:00:00	Szczodrowice	65	30603	0217043
18.7419453	52.1983337	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0181/1/10	P	2020-09-30 00:00:00	Grzegorzew	teren przy oczyszczalni ścieków	30505	3009052
17.2369442	51.3111115	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0286/1/10	P	2020-11-30 00:00:00	Zawonia	dz. nr 15	33673	0220052
14.2694445	52.9102783	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0410/1/11	P	2020-12-31 00:00:00	Czachów	dz. nr 51	44570	3206023
20.541666	50.731945	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0421/2/11	zmP	2020-12-31 00:00:00	Chęciny	Łukowa, dz. nr 189	10182	2604033
23.5813885	52.7536125	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0351/1/11	P	2020-12-31 00:00:00	Hajnówka	dz. nr 1/68	13064	2005011
20.6363888	49.5752792	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0233/1/10	P	2020-11-30 00:00:00	Stary Sącz	Wielki Wygon, Oczyszczalnia Ścieków	22363	1210163
14.8263893	52.523056	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0381/2/11	zmP	2020-12-31 00:00:00	Chartów	dz. nr 7	31680	0807032
22.7711105	52.5499992	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0031/1/07	P	2017-10-31 00:00:00	Makarki	\N	2004	2010042
17.7797222	53.1619453	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0402/1/11	P	2020-12-31 00:00:00	Strzelewo	dz. nr 83/13	44101	0403072
21.0088882	52.2041664	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0681/1/12	P	2022-03-31 00:00:00	Warszawa	Ligocka 8	10786	1465011
22.2605553	52.271946	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0505/1/11	P	2021-04-30 00:00:00	Suchożebry	dz. nr 723/2	13126	1426102
18.4763889	52.9055557	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0403/1/11	P	2020-12-31 00:00:00	Gniewkowo	dz. nr 73/2	44118	0407033
20.8472214	50.5449982	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0164/1/10	P	2020-09-30 00:00:00	Balice	dz. nr 164	12510	2601022
19.9088898	50.5708351	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0664/2/11	zmP	2021-06-30 00:00:00	Stary Węgrzynów	dz. nr 30/1 i 30/2	12441	2602072
20.1758327	54.3694458	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0408/1/11	P	2020-12-31 00:00:00	Lelkowo	dz. nr 323/6	44463	2802042
21.5741673	53.3586121	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0220/1/10	P	2020-11-30 00:00:00	Łyse	dz. nr 2128/5	13005	1415072
21.0455551	52.2394447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0502/1/11	P	2021-04-30 00:00:00	Warszawa	Stadion Narodowy	16016	1465011
21.9080563	52.810276	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0503/1/11	P	2021-04-30 00:00:00	Ostrów Mazowiecka	Lipowa 4	11190	1416011
18.1333332	53.7047234	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0314/1/10	P	2020-11-30 00:00:00	Śliwice	wysypisko śmieci	44098	0416052
16.5477772	51.9711113	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0274/1/10	P	2020-11-30 00:00:00	Wydorowo	Wydorowo 21	33122	3011053
19.9974995	53.230835	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0341/1/10	P	2020-11-30 00:00:00	Przełęk Duży	Przełęk Duży 4, dz. nr 34/1	44909	2803052
20.9327774	54.0083351	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0414/1/11	P	2020-12-31 00:00:00	Wójtowo	Wójtowo 31	44943	2814082
17.0227776	52.580555	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0295/1/10	P	2020-11-30 00:00:00	Murowana Goślina	Polna 5	33890	3021113
19.4752769	52.4863892	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0213/1/10	P	2020-11-30 00:00:00	Lucień	dz. nr 109/2	11688	1404022
18.644722	53.4697227	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0310/1/10	P	2020-11-30 00:00:00	Nowe Marzy	\N	44057	0414022
21.875555	54.2524986	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0412/1/11	P	2020-12-31 00:00:00	Budry	Budry, dz. nr 257/4	44931	2819012
17.5683327	52.0713882	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0470/1/11	P	2021-01-31 00:00:00	Żerków	Cmentarna 8	33768	3006043
19.3408337	52.2216682	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0095/1/08	P	2018-11-30 00:00:00	Kutno	Chopina 25	4195	1002011
21.8641663	49.5708351	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0105/2/13	zmP	2020-09-30 00:00:00	Rymanów	dz. nr 3142	22249	1807083
20.2502785	51.7711105	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0052/1/07	P	2017-11-30 00:00:00	Rawa Mazowiecka	Mszczonowska 10	4021	1013011
16.8297215	50.6416664	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0386/1/11	P	2020-12-31 00:00:00	Ząbkowice Śląskie	dz. nr 368/180	33496	0224053
22.5463886	49.5600014	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0370/2/11	zmP	2020-12-31 00:00:00	Wojtkowa	dz. 682	24444	1801083
18.6122227	51.4211121	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0260/2/11	zmP	2020-11-30 00:00:00	Złoczew	Spółdzielcza	31159	1014113
20.8938885	53.0241661	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0153/1/10	P	2020-09-30 00:00:00	Przasnysz	Orlika 29, dz. nr 1193/3	13371	1422011
20.8252773	53.8291664	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0616/1/11	P	2021-06-30 00:00:00	Ramsowo	Kromerowo Kolonia, dz. nr 41/16	44355	2814013
20.8288879	51.6183319	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0162/1/10	P	2020-09-30 00:00:00	Wyśmierzyce	dz. nr 900	11928	1401063
21.1166668	53.9425011	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0658/1/11	P	2021-06-30 00:00:00	Wola	dz. nr 21/6	44494	2808053
17.3011112	52.1366653	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0585/1/11	P	2021-06-30 00:00:00	Sulęcinek	Klonowa 37	30597	3025022
14.8847218	53.4444427	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0397/1/11	P	2020-12-31 00:00:00	Strumiany	dz. nr 90/1	43443	3214102
20.6122227	50.2508316	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0165/1/10	P	2020-09-30 00:00:00	Czyżowice	dz. nr 292/2	12511	2603012
17.9458332	50.6588898	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0508/1/11	P	2021-04-30 00:00:00	Opole	Armii Krajowej 36	22088	1661011
22.4899998	49.3827782	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0453/1/11	P	2021-01-31 00:00:00	Solina	Wieża TV, Góra Jawor	22907	1801083
23.520277	51.0547218	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0634/1/11	P	2021-06-30 00:00:00	Sielec	dz. nr 358, 359, 360	12079	0603072
18.4105549	54.1847229	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0197/1/10	P	2020-09-30 00:00:00	Mierzeszyn	dz. nr 391	44951	2204082
15.313611	53.0361099	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0400/1/11	P	2020-12-31 00:00:00	Pełczyce	Pełczyk 10	43680	3202053
16.7241669	53.0533333	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0279/1/10	P	2020-11-30 00:00:00	Ujście	Huty Szkła 2	33274	3019073
18.9544449	51.7791672	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0459/1/11	P	2021-01-31 00:00:00	Zygry	RTCN Zygry	31344	1011062
19.561388	51.8113899	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0093/1/08	P	2018-06-30 00:00:00	Dąbrowa	\N	4032	1006082
23.2502785	52.9216652	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0635/1/11	P	2021-06-30 00:00:00	Ryboły	dz. nr 1028/60	13065	2002143
22.6088886	49.7877769	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0362/1/11	P	2020-12-31 00:00:00	Krasiczyn	Korytniki dz. nr 1474	22553	1813042
19.7613888	53.8461113	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0196/1/10	P	2020-09-30 00:00:00	Bagnity	dz. nr 62	44904	2815052
22.6686115	54.2602768	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0628/1/11	P	2021-06-30 00:00:00	Przerośl	dz. nr 1251	11647	2012042
22.6586113	53.1572227	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0221/1/10	P	2020-11-30 00:00:00	Zawady	dz. nr 333	13185	2002152
21.4377785	51.4630547	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0206/1/10	P	2020-11-30 00:00:00	Pionki	Zakładowa 7	11347	1425011
21.4719448	52.0594444	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0544/1/11	P	2021-06-30 00:00:00	Kołbiel	1-go Maja 108	11470	1417052
18.169445	50.084446	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0365/1/11	P	2020-12-31 00:00:00	Racibórz	dz. nr 1140/33	22913	2411011
16.8700008	54.3697205	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0132/1/10	P	2020-09-30 00:00:00	Kczewo	dz. nr 17/20	43211	2212062
17.4338894	50.4113884	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0360/1/11	P	2020-12-31 00:00:00	Wierzbięcice	Wierzbięcice 83	22478	1607053
18.0672226	52.9311104	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0308/1/10	P	2020-11-30 00:00:00	Pęchowo	dz. nr. 112/7	43826	0407092
18.3208332	51.4930573	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0669/1/11	P	2021-07-31 00:00:00	Czajków	dz. nr 216	32660	3018012
21.3863888	49.623333	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0108/1/10	P	2020-09-30 00:00:00	Cieklin	dz. nr 278/1	22542	1805032
17.0369453	51.3030548	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0068/1/07	P	2017-11-30 00:00:00	Trzebnica	Obornicka 2	24	0220033
19.2791672	51.9722214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0590/1/11	P	2021-06-30 00:00:00	Ozorków	Łęczycka 5/7	31094	1020021
21.7527771	50.4080544	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0102/1/10	P	2020-09-30 00:00:00	Nowa Dęba	Rzeszowska, dz. nr 306	22179	1820043
22.1002769	52.5461121	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0008/1/07	P	2017-09-30 00:00:00	Chruszczewka	Szlachecka 24	2007	1429053
18.1738892	53.2666664	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0483/1/11	P	2021-01-31 00:00:00	Trzeciewiec	RTCN Trzeciewiec	44059	0403032
19.3752785	50.4266663	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0230/1/10	P	2020-11-30 00:00:00	Łazy	Wysocka, dz. nr 1484/3	22274	2416053
18.4013882	50.0508347	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0642/1/11	P	2021-06-30 00:00:00	Pszów	Lipowa 71	22111	2415011
21.4333324	51.9708328	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0040/1/07	P	2017-11-30 00:00:00	Osieck	dz. nr 1613/6,1611/1	2023	1417062
20.5944443	51.0747223	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0218/1/10	P	2020-11-30 00:00:00	Stąporków	dz. nr 324	12516	2605083
17.2872219	52.9430542	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0290/1/10	P	2020-11-30 00:00:00	Gołańcz	Margonińska 8	33852	3028033
18.1519451	52.4949989	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0604/1/11	P	2021-06-30 00:00:00	Wilczyn	\N	33718	3010142
20.3325005	51.9827766	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0548/1/11	P	2021-06-30 00:00:00	Puszcza Mariańska	\N	11710	1438032
21.8597221	50.3427773	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0240/1/10	P	2020-11-30 00:00:00	Kopcie	dz. nr 889	22911	1806062
17.7933331	50.7938881	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0576/1/11	P	2021-06-30 00:00:00	Chróścice	dz. nr 533 b/22	22842	1609032
23.7519436	52.935276	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0347/2/11	zmP	2020-12-31 00:00:00	Nowa Łuka	Topolowa 15	11618	2005092
17.8658333	52.6880569	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0340/1/10	P	2020-11-30 00:00:00	Mogilno	dz. nr 141/15	44889	0409033
23.4205551	51.1472206	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0033/1/07	P	2017-10-31 00:00:00	Chełm	Kumowa Dolina	2015	0603032
19.8280563	54.3680573	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0687/1/14	P	2024-06-30 00:00:00	Braniewo	5, nr. dz. 3/10	44351	2802011
14.5119448	53.4272232	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0395/1/11	P	2020-12-31 00:00:00	Szczecin	Santocka 36	43169	3262011
20.3341675	49.7711105	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0173/1/10	P	2020-09-30 00:00:00	Rupniów	dz. nr 81	24058	1207072
22.9186115	54.2069435	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0627/1/11	P	2021-06-30 00:00:00	Jeleniewo	dz. nr 297	11627	2012032
17.2422218	51.9202766	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0597/1/11	P	2021-06-30 00:00:00	Borek Wielkopolski	H. Sienkiewicza 33	33130	3004013
20.0819435	49.9586105	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0447/1/11	P	2021-01-31 00:00:00	Wieliczka	RMietniów 70, TCN Chorągwica	20591	1219053
18.8600006	50.6522217	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0446/1/11	P	2021-01-31 00:00:00	Koszęcin	Boronowska, RCN Koszęcin	20584	2407062
19.3111115	50.1027794	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0369/1/11	P	2020-12-31 00:00:00	Libiąż	Działkowa 2	24420	1203043
16.5452785	54.248333	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0133/1/10	P	2020-09-30 00:00:00	Witosław	dz. nr 22/10	43212	3213042
23.249445	53.5688896	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0166/1/10	P	2020-09-30 00:00:00	Kopciówka	dz. nr 52/2	13196	2011093
16.5841675	52.6127777	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0466/1/11	P	2021-01-31 00:00:00	Szamotuły	Lipowa 2 A	33271	3024073
17.1558342	51.5872231	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0116/1/10	P	2020-09-30 00:00:00	Szkaradowo	Szkaradowo 9	30513	3022023
22.2266674	50.5519447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0107/1/10	P	2020-09-30 00:00:00	Pysznica	dz. nr 2521	22326	1818032
19.394722	51.8019447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0677/1/11	P	2021-07-31 00:00:00	Łódź	Traktorowa 148/158	31209	1061011
21.4322224	52.6119461	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0498/1/11	P	2021-02-28 00:00:00	Wyszków	Leśna 50	13413	1435053
21.0938892	51.0488892	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0442/1/11	P	2021-01-31 00:00:00	Starachowice	Martenowska 2	13593	2611011
15.1002779	53.9097214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0193/1/10	P	2020-09-30 00:00:00	Rybokarty	dz. nr 208/6	44635	3205023
21.2419453	52.6513901	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0539/1/11	P	2021-06-30 00:00:00	Pniewo	dz. nr 53/1	10647	1424072
21.9266663	49.4233322	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0377/1/11	P	2020-12-31 00:00:00	Moszczaniec	dz. nr 15/144	24766	1817042
15.6427774	52.4458351	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0264/1/10	P	2020-11-30 00:00:00	Bobowicko	Międzyrzecka 7a	31503	0803023
19.3950005	51.0958328	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0259/1/10	P	2020-11-30 00:00:00	Stobiecko Szlacheckie	dz. nr 336	31059	1012092
18.5361118	54.5472221	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0091/1/08	P	2018-06-30 00:00:00	Gdynia	Bosmańska 51	38	2262011
17.7186108	51.7186127	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0605/1/11	P	2021-06-30 00:00:00	Raszków	Orpiszewska 7	33789	3017063
16.8525009	52.2388878	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0600/1/11	P	2021-06-30 00:00:00	Mosina	Śremska	33550	3021103
21.2811108	50.7455559	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0538/1/11	P	2021-06-30 00:00:00	Iwaniska	Wojnowice, dz. nr 509	10249	2606022
19.4969444	54.2077789	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0044/1/07	P	2017-11-30 00:00:00	Jagodnik	dz. nr 110	2018	2804052
22.834444	53.1175003	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0500/1/11	P	2021-02-28 00:00:00	Kruszewo	dz. nr 414/2	13201	2002013
15.6702776	51.9455566	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0155/1/10	P	2020-09-30 00:00:00	Łaz	dz. nr 18/5	30529	0809092
19.9052773	51.4427795	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0187/1/10	P	2020-09-30 00:00:00	Bronisławów	dz. nr 108/3	33913	1010112
19.6427784	50.4749985	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0579/1/11	P	2021-06-30 00:00:00	Pilica	dz. nr 575	24004	2416073
14.4666662	53.206665	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0529/1/11	P	2021-04-30 00:00:00	Nowe Czarnowo	\N	43257	3206043
23.2477779	50.2455559	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0375/1/11	P	2020-12-31 00:00:00	Chotylub	dz. nr 515	24609	1809023
18.7580547	51.2702789	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0262/1/10	P	2020-11-30 00:00:00	Osjaków	dz. nr 51	31173	1017052
19.6497231	52.8908348	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0435/1/11	P	2021-01-31 00:00:00	Sierpc	Rachocin	13585	1427052
21.3636112	53.4894447	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0619/1/11	P	2021-06-30 00:00:00	Rozogi	Rozogi, dz. nr 158/1	44470	2817052
14.9816666	52.4191666	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0382/1/11	P	2020-12-31 00:00:00	Lubień	dz. nr 21/8	31687	0805033
18.060833	53.169445	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0311/1/10	P	2020-11-30 00:00:00	Bydgoszcz	Izerska 19, dz. nr 61	44060	0461011
23.5022221	51.4255562	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0419/1/11	P	2020-12-31 00:00:00	Osowa	dz. nr 226/2	12773	0619032
20.4952774	53.3261108	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0309/1/10	P	2020-11-30 00:00:00	Zagrzewo	dz. nr 9/28	44041	2811043
19.7691669	50.5072212	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0246/1/10	P	2020-11-30 00:00:00	Żarnowiec	dz. nr 670/2	24520	2416073
17.0583324	51.814167	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0463/1/11	P	2021-01-31 00:00:00	Domachowo	SLR Domachowo, dz. nr 98/3 i 98/5	32910	3004033
20.9174995	52.543335	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0540/1/11	P	2021-06-30 00:00:00	Jaskółowo	\N	10650	1414043
20.1986103	51.6719437	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0257/1/10	P	2020-11-30 00:00:00	Lipie	\N	31051	1016042
21.0149994	52.2322235	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0678/1/11	P	2021-07-31 00:00:00	Warszawa	Chmielna 19	11039	1465011
15.2113886	53.7449989	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0303/1/10	P	2020-11-30 00:00:00	Wyszogóra	dz. nr 1	43551	3205043
18.5436115	54.0466652	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0067/1/07	P	2017-11-30 00:00:00	Trzcińsk	SLR TP Emitel	52	2213122
18.1691666	51.7013893	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0059/1/07	P	2017-11-30 00:00:00	Chełmce	dz. nr 110	34	3007082
18.7561111	50.2633324	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0174/1/10	P	2020-09-30 00:00:00	Zabrze	Sejmowa 38	24083	2478011
17.9661102	50.478054	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0012/1/07	P	2017-09-30 00:00:00	Krapkowice	Opolska 30	4004	1605023
18.6236115	50.3983345	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0027/1/07	P	2017-10-31 00:00:00	Pyskowice	Armii Krajowej 22	4002	2405021
21.9719448	51.3255539	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0024/1/07	P	2017-10-31 00:00:00	Kazimierz Dolny	Góry I 46	2020	0614043
17.2830563	50.6363907	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0364/1/11	P	2020-12-31 00:00:00	Strzegów	dz. nr 120/4	22874	1601033
18.3277779	52.398613	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0465/1/11	P	2021-01-31 00:00:00	Ślesin k/Konina	RTCN Konin - Żółwieniec	33255	3010123
17.0141659	50.5344429	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0388/1/11	P	2020-12-31 00:00:00	Niedźwiedź	dz. nr 246	34304	0224063
20.249445	53.873333	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0324/1/10	P	2020-11-30 00:00:00	Świątki	dz. nr 270	44466	2814122
20.7113895	54.1827774	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0660/1/11	P	2021-06-30 00:00:00	Lidzbark Warmiński	dz. nr 248/3	44498	2809022
20.1772213	50.4683342	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0226/1/10	P	2020-11-30 00:00:00	Książ Wielki k/Miechowa	Moczydlo 1	22132	1208042
18.5524998	50.4958344	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0583/1/11	P	2021-06-30 00:00:00	Wiśnicze	dz. nr 419/117	24534	2405082
17.626667	51.4799995	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0189/1/10	P	2020-09-30 00:00:00	Sośnie	Jerzego Lańca, dz. nr 238/11	34729	3017082
18.145277	50.3358345	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0013/1/07	P	2017-09-30 00:00:00	Kędzierzyn-Koźle	Piramowicza 22	4006	1603011
18.9449997	53.0508347	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0327/1/10	P	2020-11-30 00:00:00	Ciechocin	dz. 311/5	44523	0405022
19.310833	51.8238907	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0256/1/10	P	2020-11-30 00:00:00	Aleksandrów Łódzki	Piotrkowska 10/12	30854	1020043
16.8413887	50.7949982	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0671/1/11	P	2021-07-31 00:00:00	Łagiewniki	Przemysłowa 2	33461	0202062
16.7997227	53.4172211	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0281/1/10	P	2020-11-30 00:00:00	Jastrowie	Cmentarna 9/2	33303	3031023
20.5575008	53.4997215	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0618/1/11	P	2021-06-30 00:00:00	Jabłonka	dz. nr 41	44437	2811043
17.1924992	50.8083344	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0125/1/10	P	2020-09-30 00:00:00	Wiązów	Kolejowa 1	34178	0217053
17.5147228	52.3113899	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0292/1/10	P	2020-11-30 00:00:00	Chocicza Wielka	ferma drobiu	33884	3030053
15.478056	51.748333	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0046/1/07	P	2017-11-30 00:00:00	Wichów	Obiekt TP Emitel	33	0810032
18.5347214	54.5449982	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0612/2/15	zmP	2021-06-30 00:00:00	Gdynia	Bosmańska 51	41378	2262011
18.5652771	52.9719429	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0138/1/10	P	2020-09-30 00:00:00	Toruń	Poznańska 290-292	43874	0463011
22.8700008	51.1302795	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0004/1/07	P	2017-09-30 00:00:00	Giełczew	\N	2002	0617033
15.5116663	52.8800011	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0283/1/10	P	2020-11-30 00:00:00	Strzelce Krajeńskie	Cmentarna 6a	33309	0806043
18.6166668	51.9205551	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0070/1/07	P	2017-11-30 00:00:00	Dobra	Wiatraki 3	32	3027033
22.398056	52.7163887	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0224/1/10	P	2020-11-30 00:00:00	Boguty-Pianki	dz. nr 213	13345	1416032
21.7549992	49.9900017	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0172/1/10	P	2020-09-30 00:00:00	Wiśniowa	dz. nr 637	22973	1815012
19.6091671	54.292778	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0405/1/11	P	2020-12-31 00:00:00	Tolkmicko	Pogrodzie 69	44350	2804093
17.3266659	52.5750008	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0122/1/10	P	2020-09-30 00:00:00	Ujazd	dz. nr 88	32103	3003042
20.7694435	52.6716652	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0427/1/11	P	2021-01-31 00:00:00	Świercze	Pułtuska 18	11690	1424052
14.9858332	52.2386093	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0647/1/11	P	2021-06-30 00:00:00	Gądków Wielki	Strażacka 37	31001	0807053
22.6552773	51.0052795	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0423/1/11	P	2021-01-31 00:00:00	Krzczonów	RTCN Lublin/Boży Dar	10205	0609092
15.1808329	51.3927765	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0521/1/11	P	2021-04-30 00:00:00	Ruszów	Zgorzelecka, dz. nr 513	30687	0225063
19.0744438	49.5752792	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0644/1/11	P	2021-06-30 00:00:00	Cisiec	Mała Barania Góra	22940	2417152
23.478611	53.1383324	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0346/1/11	P	2020-12-31 00:00:00	Gródek k/Białegostoku	dz. nr 81	11296	2002042
19.6355553	53.2030563	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0321/1/10	P	2020-11-30 00:00:00	Górzno	Wybudowanie 90	44277	0402053
17.4252777	54.0541649	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0491/1/11	P	2021-01-31 00:00:00	Wojsk	SLR Wojsk	44706	2201052
21.1638889	53.6905556	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0323/1/10	P	2020-11-30 00:00:00	Jeleniewo	\N	44434	2817022
15.6374998	54.1488876	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0305/1/10	P	2020-11-30 00:00:00	Stramnica	dz. nr 72/3	43685	3208042
21.1147213	51.4097214	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0010/1/07	P	2017-09-30 00:00:00	Radom	Przytycka 2	2027	1463011
17.1394444	50.4963875	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0496/1/11	P	2021-01-31 00:00:00	Maciejowice	dz. nr 121/350	24589	1607063
19.4522228	51.7444458	NORDISK POLSKA Sp. z o.o.	CDMA420/8/0120/1/10	P	2020-09-30 00:00:00	Łódź	Wróblewskiego 18	31205	1061011
\.


--
-- Data for Name: gatunki; Type: TABLE DATA; Schema: public; Owner: kursant
--

COPY public.gatunki (id, date_from, date_to, species_cd, species_num, species_name, latin_name, shrubtree_fl, bot_species, bot_genus, bot_name, fomatree_grp, act_tree_grp, wood_kind_fl, height_grp, volume_grp, worth_grp, c_species_cd, wage_grp_fl, plants_fsawing_qty, plants_psawing_qty, plants_foil_qty, gat_grp, ibl_grp, lmr_reg_fl) FROM stdin;
15	01-01-1970	\N	ACE.PL.LO	320106	klon pospolity                	Acer platanoides Palmatifidum 	D	klon                          	odm.Lorberga                  	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
16	01-01-1970	\N	ACE.PL.RE	320102	klon pospolity                	Acer platanoides Reitenbacha  	D	klon                          	odm.Reitenbacha               	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
17	01-01-1970	\N	ACE.PL.SC	320101	klon pospolity                	Acer platanoides Schwedleri   	D	klon                          	odm.Schwedlera                	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
18	01-01-1970	\N	ACE.PS.LE	320204	klon jawor                    	Acer pseudoplatanus Leopoldii 	D	klon                          	odm.'Leopoldii'               	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
19	01-01-1970	\N	ACE.PS.PH	320203	klon jawor                    	Acer pseudoplatanus Pr.Handjer	D	klon                          	odm.'Prinz Handjery'          	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
20	01-01-1970	\N	ACE.PS.PU	320201	klon jawor                    	Acer pseudoplatanus Purpureum 	D	klon                          	odm.'Purpureum'               	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
21	01-01-1970	\N	ACE.PS.SL	320205	klon jawor                    	Acer pseudoplatanus Sim.Lo.Fr.	D	klon                          	odm.'Simon Luis Freres'       	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
22	01-01-1970	\N	ACE.PS.WO	320202	klon jawor                    	Acer pseudoplatanus Worleei   	D	klon                          	odm.Worleei'                  	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
23	01-01-1970	\N	ACE.SA.LU	320703	klon srebrzysty               	Acer saccharinum Lutescens    	D	klon                          	odm.'Lutescens'               	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
24	01-01-1970	\N	ACE.SA.PY	320702	klon srebrzysty               	Acer saccharinum Pyramidale   	D	klon                          	odm.'Pyramidale'              	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
25	01-01-1970	\N	ACE.SA.WI	320701	klon srebrzysty               	Acer saccharinum Lacin.Wieri  	D	klon                          	odm.'Wieri'                   	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
26	01-01-1970	\N	AES.HI.BA	1100101	kasztanowiec biały            	Aesculus hippocastanum Bauman.	D	kasztanowiec                  	odm.'Baumanni'                	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
27	01-01-1970	\N	AES.HI.PA	1100103	kasztanowiec biały            	Aesculus hippocastanum Partyz.	D	kasztanowiec                  	odm.'Partyzant'               	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
28	01-01-1970	\N	AES.HI.PY	1100102	kasztanowiec biały            	Aesculus hippocastanum Pyram. 	D	kasztanowiec                  	odm.'Pyramidalis'             	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
29	01-01-1970	\N	AES.HI.UM	1100104	kasztanowiec biały            	Aesculus hippocastanum Umbrac.	D	kasztanowiec                  	odm.'Umbraculifera'           	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
30	01-01-1970	\N	AGR	590100	agrest pospolity              	Ribes grossularia             	K	agrest                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
31	01-01-1970	\N	AK	410100	robinia akacjowa              	Robinia pseudoacacia          	D	robinia                       	\N	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	28000	7000	0	BRZ	BRZ      	\N
32	01-01-1970	\N	AKT.P	1160200	aktinidia pstrolistna         	Actinidia kolomikta           	K	aktinidia                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
33	01-01-1970	\N	AMB.A	620100	ambrowiec amerykański         	Liquidambar styraciflua       	D	ambrowiec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
34	01-01-1970	\N	AMF.K	920100	amorfa krzewiasta             	Amorpha fruticosa             	K	amorfa                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
35	01-01-1970	\N	ARA.C	70100	araukaria chilijska           	Araucaria araucana            	D	araukaria                     	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
36	01-01-1970	\N	ARA.W	70200	araukaria wyniosła            	Araucaria heterophylla        	D	araukaria                     	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
37	01-01-1970	\N	ARO.C	510099	aronia czarna                 	Aronia melanocarpa            	K	aronia                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
38	01-01-1970	\N	AZA.G	1240300	azalia gandawska              	Rhododendron gandavense       	K	azalia                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
39	01-01-1970	\N	AZA.J	1240200	azalia japońska               	Rhododendron japonicum        	K	azalia                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
40	01-01-1970	\N	AZA.P	1240100	azalia pontyjska              	Rhododendron flavum           	K	azalia                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
41	01-01-1970	\N	BER	510100	berberys pospolity            	Berberis vulgaris             	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
42	01-01-1970	\N	BER.AG.PR	510401	berberys wiązkowy             	Berberis aggregata prattii    	K	berberys                      	odm.Pratta                    	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
43	01-01-1970	\N	BER.AT.NA	510202	berberys Thunberga            	Berberis thunbergii Atrop.Nana	K	berberys                      	odm.'Atropurpurea Nana'       	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
44	01-01-1970	\N	BER.B	510900	berberys brodawkowaty         	Berberis verruculosa          	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
45	01-01-1970	\N	BER.C.PUR	510601	berberys Chopina              	Berberis chopinii purpurowy   	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
46	01-01-1970	\N	BER.G	510800	berberys Gagnepaina           	Berberis gagnepainii          	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
47	01-01-1970	\N	BER.GA.LA	510801	berberys Gagnepaina           	Berberis gagnepainii lanceifo.	K	berberys                      	odm.lancetowata               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
48	01-01-1970	\N	BER.HYB.C	511001	berberys mieszańcowy          	Berberis hyb.-gagnepa.Chenault	K	berberys                      	odm.'Chenault'                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
49	01-01-1970	\N	BER.J	510700	berberys Juliany              	Berberis julianae             	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
50	01-01-1970	\N	BER.K	510500	berberys koreański            	Berberis koreana              	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
51	01-01-1970	\N	BER.T	510200	berberys Thunberga            	Berberis thunbergii           	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
52	01-01-1970	\N	BER.TH.AT	510201	berberys Thunberga            	Berberis thunbergii Atropurpu.	K	berberys                      	odm.'Atropurpurea'            	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
53	01-01-1970	\N	BER.VU.AT	510101	berberys pospolity            	Berberis vulgaris Atropurpurea	K	berberys                      	odm.'Atropurpurea'            	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
54	01-01-1970	\N	BER.W	510400	berberys wiązkowy             	Berberis aggregata            	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
55	01-01-1970	\N	BER.WI	510300	berberys Wilsona              	Berberis wilsoniae            	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
56	01-01-1970	\N	BET.PE.OY	360104	brzoza brodawkowata           	Betula pendula oycoviensis    	D	brzoza                        	odm.oycoviensis               	\N	BRZ	BRZ	L	\N	\N	BRZ      	\N	3	0	0	0	BRZ	BRZ      	\N
57	01-01-1970	\N	BET.PE.PU	360105	brzoza brodawkowata           	Betula pendula                	D	brzoza                        	odm. Purpurea                 	\N	BRZ	BRZ	L	\N	\N	BRZ      	\N	3	0	0	0	BRZ	BRZ      	\N
58	01-01-1970	\N	BET.PU.CA	360201	brzoza omszona                	Betula pubescens carpatica    	K	brzoza                        	odm.carpatica                 	\N	BRZ	BRZ	L	\N	\N	\N	\N	3	0	0	0	BRZ	BRZ      	\N
59	01-01-1970	\N	BEZ.C	1350100	bez czarny                    	Sambucus nigra                	K	bez                           	\N	\N	\N	\N	L	\N	\N	\N	\N	1	15000	6000	0	OS	BRZ      	\N
60	01-01-1970	\N	BEZ.K	1350200	bez koralowy                  	Sambucus racemosa             	K	bez                           	\N	\N	\N	\N	L	\N	\N	\N	\N	1	15000	6000	0	OS	BRZ      	\N
61	01-01-1970	\N	BK	300100	buk pospolity                 	Fagus silvatica               	D	buk                           	\N	\N	BK 	BK 	L	\N	\N	BK       	\N	3	32000	8000	20000	BK	BK       	\N
62	01-01-1970	\N	BKP	1020100	bukszpan wieczniezielony      	Buxus sempervirens            	K	bukszpan                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
63	01-01-1970	\N	BKW	850700	brzoskwinia pospolita         	Prunus persica                	D	śliwa                         	\N	\N	\N	\N	L	\N	\N	\N	\N	3	0	0	0	OS	BRZ      	\N
64	01-01-1970	\N	BOŻ.G	1010100	bożodrzew gruczołkowaty       	Ailanthus altissima           	D	bożodrzew                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
65	01-01-1970	\N	BRZ	360100	brzoza brodawkowata           	Betula pendula                	D	brzoza                        	\N	\N	BRZ	BRZ	L	\N	\N	BRZ      	\N	3	30000	10000	25000	BRZ	BRZ      	\N
66	01-01-1970	\N	BRZ.C	360300	brzoza ciemna                 	Betula obscura                	D	brzoza                        	\N	\N	BRZ	BRZ	L	\N	\N	BRZ      	\N	3	0	0	0	BRZ	BRZ      	\N
67	01-01-1970	\N	BRZ.H	360700	brzoza Hosera                 	Betula Hoseri                 	D	brzoza                        	\N	\N	BRZ	BRZ	L	\N	\N	BRZ      	\N	3	0	0	0	BRZ	BRZ      	\N
68	01-01-1970	\N	BRZ.KA	360500	brzoza karłowata              	Betula nana                   	K	brzoza                        	\N	\N	BRZ	BRZ	L	\N	\N	\N	\N	3	0	0	0	BRZ	BRZ      	\N
69	01-01-1970	\N	BRZ.M	360800	brzoza Maksymowicza           	Betula maximowicziana         	D	brzoza                        	\N	\N	BRZ	BRZ	L	\N	\N	BRZ      	\N	3	0	0	0	BRZ	BRZ      	\N
70	01-01-1970	\N	BRZ.N	360400	brzoza niska                  	Betula humilis                	K	brzoza                        	\N	\N	BRZ	BRZ	L	\N	\N	\N	\N	3	0	0	0	BRZ	BRZ      	\N
71	01-01-1970	\N	BRZ.O	360200	brzoza omszona                	Betula pubescens              	D	brzoza                        	\N	\N	BRZ	BRZ	L	\N	\N	BRZ      	\N	3	25000	8000	0	BRZ	BRZ      	\N
72	01-01-1970	\N	BRZ.P	360600	brzoza papierowa              	Betula papyrifera             	D	brzoza                        	\N	\N	BRZ	BRZ	L	\N	\N	BRZ      	\N	3	0	0	0	BRZ	BRZ      	\N
73	01-01-1970	\N	BST	330300	wiąz górski                   	Ulmus glabra                  	D	wiąz                          	\N	\N	DB 	DB 	L	\N	\N	BK       	\N	3	15000	6000	0	DB	DB       	\N
74	01-01-1970	\N	BUD.D	1310100	budleja Davida                	Buddleja davidii              	K	budleja                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
75	01-01-1970	\N	BUD.S	1310200	budleja skrętolistna          	Buddleja alternifolia         	K	budleja                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
76	01-01-1970	\N	BUX.SE.SU	1020101	bukszpan wieczniezielony      	Buxus sempervirens Suffrutic. 	K	bukszpan                      	odm.'Suffruticosa'            	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
77	01-01-1970	\N	CAR.BE.CO	350102	grab pospolity                	Carpinus betulus Columnaris   	D	grab                          	odm.kolumnowa                 	\N	GB 	DB 	L	\N	\N	GB       	\N	3	0	0	0	GB	BRZ      	\N
78	01-01-1970	\N	CAR.BE.FA	350103	grab pospolity                	Carpinus betulus Fastigiata   	D	grab                          	odm.stożkowa                  	\N	GB 	DB 	L	\N	\N	GB       	\N	3	0	0	0	GB	BRZ      	\N
79	01-01-1970	\N	CAR.BE.QU	350101	grab pospolity                	Carpinus betulus Quercifolia  	D	grab                          	odm.dębolistna                	\N	GB 	DB 	L	\N	\N	GB       	\N	3	0	0	0	GB	BRZ      	\N
80	01-01-1970	\N	CDR.A	90100	cedr atlaski                  	Cedrus atlantica              	D	cedr                          	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
81	01-01-1970	\N	CDR.C	90200	cedr cypryjski                	Cedrus brevifolia             	D	cedr                          	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
82	01-01-1970	\N	CDR.H	90300	cedr himalajski               	Cedrus deodara                	D	cedr                          	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
83	01-01-1970	\N	CDR.L	90400	cedr libański                 	Cedrus libani                 	D	cedr                          	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
84	01-01-1970	\N	CEC.K	80100	cedrzyniec kalifornijski      	Calocedrus decurrens          	D	cedrzyniec                    	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
85	01-01-1970	\N	CHA.JA.AL	720101	pigwowiec japoński            	Chaenomeles japonica alpina   	K	pigwowiec                     	odm.alpejska                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
86	01-01-1970	\N	CIS	190100	cis pospolity                 	Taxus baccata                 	D	cis                           	\N	\N	JD 	JD 	I	JD       	JD       	JD       	\N	1	25000	7000	0	OS	JD       	\N
87	01-01-1970	\N	CIS.AD	190101	cis pospolity                 	Taxus baccata                 	D	cis                           	odm. Aurea Decora             	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
88	01-01-1970	\N	CIS.AE	190102	cis pospolity                 	Taxus baccata                 	D	cis                           	odm. Adpressa Erecta          	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
89	01-01-1970	\N	CIS.FA	190103	cis pospolity                 	Taxus baccata                 	D	cis                           	odm. Fastigiata Aureomarginata	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
90	01-01-1970	\N	CIS.J	190300	cis japoński                  	Taxus cuspidata               	D	cis                           	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
91	01-01-1970	\N	CIS.K	190200	cis kanadyjski                	Taxus canadensis              	D	cis                           	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
92	01-01-1970	\N	CIS.P	190400	cis pośredni                  	Taxus media                   	D	cis                           	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
93	01-01-1970	\N	COR.AL.AR	1220104	dereń biały                   	Cornus alba Argenteomarginata 	K	dereń                         	odm.białobrzega               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
94	01-01-1970	\N	COR.AL.GO	1220105	dereń biały                   	Cornus alba Gouchaultii       	K	dereń                         	odm.Gouchaulta                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
95	01-01-1970	\N	COR.AL.KE	1220102	dereń biały                   	Cornus alba Kesselringii      	K	dereń                         	odm.Kesselringa               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
96	01-01-1970	\N	COR.AL.SI	1220101	dereń biały                   	Cornus alba sibirica          	K	dereń                         	odm.syberyjska                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
97	01-01-1970	\N	COR.AL.SP	1220106	dereń biały                   	Cornus alba Spaethii          	K	dereń                         	odm.Spatha                    	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
98	01-01-1970	\N	COR.AL.SV	1220103	dereń biały                   	Cornus alba Sibirica Variegata	K	dereń                         	odm.syberyjska pstrolistna    	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
99	01-01-1970	\N	COR.AL.V	1220107	dereń biały                   	Cornus alba                   	K	dereń                         	odm. Variegata                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
100	01-01-1970	\N	COR.AV.AU	760102	leszczyna pospolita           	Corylus avellana Aurea        	K	leszczyna                     	odm.złocista                  	\N	\N	\N	L	\N	\N	\N	\N	1	20000	6000	0	OS	BRZ      	\N
101	01-01-1970	\N	COR.AV.C	760105	leszczyna pospolita           	Corylus avellana              	K	leszczyna                     	odm. Contorta                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
102	01-01-1970	\N	COR.AV.FU	760101	leszczyna pospolita           	Corylus avellana Fuscorubra   	K	leszczyna                     	odm.purpurowa                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
103	01-01-1970	\N	COR.AV.HE	760103	leszczyna pospolita           	Corylus avellana Heterophylla 	K	leszczyna                     	odm.strzępolistna             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
104	01-01-1970	\N	COR.AV.P	760104	leszczyna pospolita           	Corylus avellana              	K	leszczyna                     	odm. Pendula                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
105	01-01-1970	\N	COR.ST.FL	1220201	dereń rozłogowy               	Cornus stolonifera Flaviramea 	K	dereń                         	odm.złotokora                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
106	01-01-1970	\N	COT.BU.FL	770801	irga pomarszczona             	Cotoneaster bullata floribunda	K	irga                          	odm.kwiecista                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
107	01-01-1970	\N	COT.CO.PU	1050101	perukowiec podolski           	Cotinus coggygria Purpureus   	K	perukowiec                    	odm.'Purpureus'               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
108	01-01-1970	\N	COT.CO.RU	1050102	perukowiec podolski           	Cotinus coggygria Rubrifolius 	K	perukowiec                    	odm.'Rubrifolius'             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
109	01-01-1970	\N	COT.DA.RA	771201	irga Dammera                  	Cotoneaster dammeri radicans  	K	irga                          	odm.pełzajaca                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
110	01-01-1970	\N	CPK.B	180100	cypryśnik błotny              	Taxodium distichum            	D	cypryśnik                     	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
111	01-01-1970	\N	CPR.W	150100	cyprys wieczniezielony        	Cupressus sempervirens        	D	cyprys                        	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
112	01-01-1970	\N	CPS.L	140100	cyprysowiec Leylanda          	Cupressocyparis leylandii     	D	cyprysowiec                   	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
113	01-01-1970	\N	CRA.MO.BI	750101	głóg jednoszyjkowy            	Crataegus monogyna Bicolor    	K	głóg                          	odm.'Bicolor'                 	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
114	01-01-1970	\N	CRA.MO.ST	750102	głóg jednoszyjkowy            	Crataegus monogyna Stricta    	K	głóg                          	odm.'Stricta'                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
115	01-01-1970	\N	CRA.OX.CA	750203	głóg dwuszyjkowy              	Crataegus oxyacantha Candidop.	K	głóg                          	odm.'Candidoplena'            	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
116	01-01-1970	\N	CRA.OX.PL	750204	głóg dwuszyjkowy              	Crataegus oxyacantha Plena    	K	głóg                          	odm.'Plena'                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
117	01-01-1970	\N	CRA.OX.PS	750201	głóg dwuszyjkowy              	Crataegus oxyacantha Paul Sc. 	K	głóg                          	odm.'Paul's Scarlet's'        	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
118	01-01-1970	\N	CRA.OX.RP	750202	głóg dwuszyjkowy              	Crataegus oxyacantha Rubra Pl.	K	głóg                          	odm.'Rubra Plena'             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
119	01-01-1970	\N	CYP.G	110400	cyprysik groszkowy            	Chamaecyparis pisifera        	D	cyprysik                      	\N	\N	JD 	JD 	I	JD       	JD       	JD       	\N	1	0	0	0	OS	JD       	\N
120	01-01-1970	\N	CYP.G.FN	110401	cyprysik groszkowy            	Chamaecyparis pisifera        	D	cyprysik                      	odm. Filifera Nana            	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
121	01-01-1970	\N	CYP.G.N	110402	cyprysik groszkowy            	Chamaecyparis pisifera        	D	cyprysik                      	odm. Nana                     	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
122	01-01-1970	\N	CYP.G.PA	110403	cyprysik groszkowy            	Chamaecyparis pisifera        	D	cyprysik                      	odm. Plumosa Aurea            	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
123	01-01-1970	\N	CYP.L	110100	cyprysik Lawsona              	Chamaecyparis lawsoniana      	D	cyprysik                      	\N	\N	JD 	JD 	I	JD       	JD       	JD       	\N	1	0	0	0	OS	JD       	\N
124	01-01-1970	\N	CYP.L.AL	110101	cyprysik Lawsona              	Chamaecyparis lawsoniana      	D	cyprysik                      	odm. Alumnii                  	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
125	01-01-1970	\N	CYP.L.AU	110102	cyprysik Lawsona              	Chamaecyparis lawsoniana      	D	cyprysik                      	odm. Aurea                    	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
126	01-01-1970	\N	CYP.L.EG	110103	cyprysik Lawsona              	Chamaecyparis lawsoniana      	D	cyprysik                      	odm. Ellwood s Gold           	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
127	01-01-1970	\N	CYP.L.LA	110104	cyprysik Lawsona              	Chamaecyparis lawsoniana      	D	cyprysik                      	odm. Lane                     	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
128	01-01-1970	\N	CYP.N	110200	cyprysik nutkajski            	Chamaecyparis nootkanensis    	D	cyprysik                      	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
129	01-01-1970	\N	CYP.N.P	110201	cyprysik nutkajski            	Chamaecyparis nootkatensis    	D	cyprysik                      	odm. Pendula                  	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
130	01-01-1970	\N	CYP.T	110300	cyprysik tepoluski            	Chamaecyparis obtusa          	D	cyprysik                      	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
131	01-01-1970	\N	CYP.T.NG	110301	cyprysik tępołuski            	Chamaecyparis obtusa          	D	cyprysik                      	odm. Nana Gracilis            	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
132	01-01-1970	\N	CYP.Z	110500	cyprysik żywotnikowy          	Chamaecyparis thyoides        	D	cyprysik                      	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
133	01-01-1970	\N	CZM	851800	czeremcha pospolita           	Prunus padus                  	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	15000	5000	0	OS	BRZ      	\N
134	01-01-1970	\N	CZM.P	851900	czeremcha późna               	Prunus serotina               	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
135	01-01-1970	\N	CZR	851300	czereśnia pospolita           	\N	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
136	01-01-1970	\N	CZR.P	851400	czereśnia ptasia              	Prunus avium                  	D	śliwa                         	\N	\N	BRZ	BRZ	L	BRZ      	BRZ      	OS       	\N	3	0	0	0	OS	BRZ      	\N
137	01-01-1970	\N	DB	310100	dąb nieokreślony              	Quercus species               	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
138	01-01-1970	\N	DB.B	310300	dąb bezszypułkowy             	Quercus petraea               	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	35000	7000	0	DB	DB       	\N
139	01-01-1970	\N	DB.BI	310600	dąb biały                     	Quercus alba                  	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
140	01-01-1970	\N	DB.BU	310900	dąb burgundzki                	Quercus cerris                	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
141	01-01-1970	\N	DB.BŁ	311000	dąb błotny                    	Quercus palustris             	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
142	01-01-1970	\N	DB.C	310400	dąb czerwony                  	Quercus rubra                 	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	35000	7000	20000	DB	DB       	\N
143	01-01-1970	\N	DB.D	311200	dąb dachówkowy                	Quercus imbricaria            	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
144	01-01-1970	\N	DB.K	310800	dąb kaukaski                  	Quercus macranthera           	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
145	01-01-1970	\N	DB.O	310500	dąb omszony                   	Quercus pubescens             	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
146	01-01-1970	\N	DB.S	310200	dąb szypułkowy                	Quercus robur                 	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	45000	8000	20000	DB	DB       	\N
147	01-01-1970	\N	DB.SZ	311100	dąb szkarłatny                	Quercus coccinea              	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
148	01-01-1970	\N	DB.W	310700	dąb wielkoowocowy             	Quercus macrocarpa            	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
149	01-01-1970	\N	DBK.O	830100	dębik ośmiopłatkowy           	Dryas octopetala              	K	dębik                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	DB	DB       	\N
150	01-01-1970	\N	DER.B	1220100	dereń biały                   	Cornus alba                   	K	dereń                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	15000	5000	0	OS	BRZ      	\N
151	01-01-1970	\N	DER.J	1220400	dereń jadalny                 	Cornus mas                    	K	dereń                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	25000	10000	0	OS	BRZ      	\N
152	01-01-1970	\N	DER.K	1220500	dereń kousa                   	Cornus kousa                  	K	dereń                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
153	01-01-1970	\N	DER.R	1220200	dereń rozłogowy               	Cornus stolonifera            	K	dereń                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
154	01-01-1970	\N	DER.Ś	1220300	dereń świdwa                  	Cornus sanguinea              	K	dereń                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	15000	5000	0	OS	BRZ      	\N
155	01-01-1970	\N	DEU.GR.CA	560202	żylistek różowy               	Deutzia rosea Campanulata     	K	żylistek                      	odm.'Campanulata'             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
156	01-01-1970	\N	DEU.GR.GR	560201	żylistek różowy               	Deutzia rosea Grandiflora     	K	żylistek                      	odm.'Grandiflora'             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
157	01-01-1970	\N	DEU.SC.CA	560304	żylistek szorstki             	Deutzia scabra Candidissima   	K	żylistek                      	odm.'Candidissima'            	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
158	01-01-1970	\N	DEU.SC.PL	560302	żylistek szorstki             	Deutzia scabra Plena          	K	żylistek                      	odm.'Plena'                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
159	01-01-1970	\N	DEU.SC.PR	560303	żylistek szorstki             	Deutzia scabra Pr. of Rochest.	K	żylistek                      	odm.'Pride of Rochester'      	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
160	01-01-1970	\N	DEU.SC.VA	560301	żylistek szorstki             	Deutzia scabra Watereri       	K	żylistek                      	odm.'Watereri'                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
161	01-01-1970	\N	DG	50100	daglezja zielona              	Pseudotsuga menziesii         	D	daglezja                      	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	35000	10000	60000	JD	ŚW       	\N
162	01-01-1970	\N	DG.S	50200	daglezja szara                	Pseudotsuga caesia            	D	daglezja                      	\N	\N	JD 	JD 	I	DG       	DG       	JD       	\N	2	0	0	0	JD	ŚW       	\N
163	01-01-1970	\N	DŁW.A	1080200	dławisz amerykański           	Celastrus scandens            	K	dławisz                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
164	01-01-1970	\N	DŁW.O	1080100	dławisz okrągłolistny         	Celastrus orbiculata          	K	dławisz                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
165	01-01-1970	\N	EGZ.W	680100	egzochorda wielkokwiatowa     	Exochorda racemosa            	K	egzochorda                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
166	01-01-1970	\N	EUO.FO.GR	1070402	trzmielina Fortune'a          	Euonymus fortunei Gracilis    	K	trzmielina                    	odm.pstrolistna               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
167	01-01-1970	\N	EUO.FO.RA	1070401	trzmielina Fortune'a          	Euonymus fortunei radicans    	K	trzmielina                    	odm.położona                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
168	01-01-1970	\N	EUO.NA.TU	1070501	trzmielina niska              	Euonymus nana turkestanica    	K	trzmielina                    	odm.turkiestanska             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
169	01-01-1970	\N	FAG.SI.AS	300107	buk pospolity                 	Fagus silvatica Asplenifolia  	D	buk                           	odm.'Asplenifolia'            	\N	BK 	BK 	L	\N	\N	BK       	\N	3	0	0	0	BK	BK       	\N
170	01-01-1970	\N	FAG.SI.AT	300101	buk pospolity                 	Fagus silvatica Atropunicea   	D	buk                           	odm.'Atropunicea'             	\N	BK 	BK 	L	\N	\N	BK       	\N	3	0	0	0	BK	BK       	\N
171	01-01-1970	\N	FAG.SI.CU	300102	buk pospolity                 	Fagus silvatica Cuprea        	D	buk                           	odm.'Cuprea'                  	\N	BK 	BK 	L	\N	\N	BK       	\N	3	0	0	0	BK	BK       	\N
172	01-01-1970	\N	FAG.SI.FA	300108	buk pospolity                 	Fagus silvatica Fastigiata    	D	buk                           	odm.'Fastigiata'              	\N	BK 	BK 	L	\N	\N	BK       	\N	3	0	0	0	BK	BK       	\N
173	01-01-1970	\N	FAG.SI.PE	300103	buk pospolity                 	Fagus silvatica Pendula       	D	buk                           	odm.'Pendula'                 	\N	BK 	BK 	L	\N	\N	BK       	\N	3	0	0	0	BK	BK       	\N
174	01-01-1970	\N	FAG.SI.RO	300105	buk pospolity                 	Fagus silvatica Roseomarginata	D	buk                           	odm.'Roseomarginata'          	\N	BK 	BK 	L	\N	\N	BK       	\N	3	0	0	0	BK	BK       	\N
210	01-01-1970	\N	GŁG	750100	głóg jednoszyjkowy            	Crataegus monogyna            	K	głóg                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	20000	7000	0	OS	BRZ      	\N
175	01-01-1970	\N	FAG.SI.ZL	300106	buk pospolity                 	Fagus silvatica Zlatia        	D	buk                           	odm.'Zlatia'                  	\N	BK 	BK 	L	\N	\N	BK       	\N	3	0	0	0	BK	BK       	\N
176	01-01-1970	\N	FOR.IN.DE	1270204	forsycja pośrednia            	Forsythia intermedia Densifl. 	K	forsycja                      	odm.gęstokwiatowa             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
177	01-01-1970	\N	FOR.IN.NA	1270205	forsycja pośrednia            	Forsythia intermedia Nana     	K	forsycja                      	odm.karłowa                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
178	01-01-1970	\N	FOR.IN.PR	1270203	forsycja pośrednia            	Forsythia intermedia Primulina	K	forsycja                      	odm.pierwiosnkowa             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
179	01-01-1970	\N	FOR.IN.SP	1270201	forsycja pośrednia            	Forsythia intermedia Spectab. 	K	forsycja                      	odm.okazala                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
180	01-01-1970	\N	FOR.IN.SS	1270206	forsycja pośrednia            	Forsythia intermedia          	K	forsycja                      	odm. Spectabilis              	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
181	01-01-1970	\N	FOR.IN.VI	1270202	forsycja pośrednia            	Forsythia intermedia Vitellina	K	forsycja                      	odm.ciemnożółta               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
182	01-01-1970	\N	FOR.SU.FO	1270102	forsycja zwisająca            	Forsythia suspensa fortune'a  	K	forsycja                      	odm.Fortune'a                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
183	01-01-1970	\N	FOR.SU.SI	1270101	forsycja zwisająca            	Forsythia suspensa sieboldii  	K	forsycja                      	odm.Siebolda                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
184	01-01-1970	\N	FOT.A	610100	fotergilia amerykańska        	Fothergilla major             	K	fotergilia                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
185	01-01-1970	\N	FRA.EX.AP	340105	jesion wyniosły               	Fraxinus excelsior Aurea Pend.	D	jesion                        	odm.złotokora zwisająca       	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
186	01-01-1970	\N	FRA.EX.AU	340104	jesion wyniosły               	Fraxinus excelsior Aurea      	D	jesion                        	odm.złotokora                 	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
187	01-01-1970	\N	FRA.EX.DI	340102	jesion wyniosły               	Fraxinus excelsior Diversifoli	D	jesion                        	odm.jednolistna               	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
188	01-01-1970	\N	FRA.EX.EL	340107	jesion wyniosły               	Fraxinus excelsior Elegantiss.	D	jesion                        	odm.drobnolistna              	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
189	01-01-1970	\N	FRA.EX.HP	340103	jesion wyniosły               	Fraxinus excel. Heteroph.Pend.	D	jesion                        	odm.jednolistna zwisająca     	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
190	01-01-1970	\N	FRA.EX.NA	340106	jesion wyniosły               	Fraxinus excelsior Nana       	D	jesion                        	odm.kulista                   	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
191	01-01-1970	\N	FRA.EX.PE	340101	jesion wyniosły               	Fraxinus excelsior Pendula    	D	jesion                        	odm.zwisająca                 	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
192	01-01-1970	\N	FRA.PE.AU	340202	jesion pensylwanski           	Fraxinus pennsylva. Aucubae.  	D	jesion                        	odm.pstrolistna               	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
193	01-01-1970	\N	FRA.PE.CR	340203	jesion pensylwanski           	Fraxinus pennsylvanica Crispa 	D	jesion                        	odm.kulista                   	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
194	01-01-1970	\N	FRA.PE.LA	340201	jesion pensylwanski           	Fraxinus pennsylvanica lanceo.	D	jesion                        	odm.wąskolistna               	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
195	01-01-1970	\N	FRS.E	1270500	forsycja europejska           	Forsythia europaea            	K	forsycja                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
196	01-01-1970	\N	FRS.K	1270400	forsycja koreańska            	Forsythia ovata               	K	forsycja                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
197	01-01-1970	\N	FRS.KO	1270600	forsycja Kobendzy             	Forsythia kobendzae           	K	forsycja                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
198	01-01-1970	\N	FRS.M	1270300	forsycja 'Maluch'             	Forsythia 'Maluch'            	K	forsycja                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
199	01-01-1970	\N	FRS.P	1270200	forsycja pośrednia            	Forsythia intermedia          	K	forsycja                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
200	01-01-1970	\N	FRS.Z	1270100	forsycja zwisająca            	Forsythia suspensa            	K	forsycja                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
201	01-01-1970	\N	FSI.PU.PE	300104	buk pospolity                 	Fagus silvatica Purpurea Pend.	D	buk                           	odm.'Purpurea Pendula'        	\N	BK 	BK 	L	\N	\N	BK       	\N	3	0	0	0	BK	BK       	\N
202	01-01-1970	\N	GB	350100	grab pospolity                	Carpinus betulus              	D	grab                          	\N	\N	GB 	DB 	L	\N	\N	GB       	\N	3	40000	10000	0	GB	BRZ      	\N
203	01-01-1970	\N	GLC.C	930200	glicynia chińska              	Wisteria sinesis              	K	glicynia                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
204	01-01-1970	\N	GLC.K	930100	glicynia kwiecista            	Wisteria floribunda           	K	glicynia                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
205	01-01-1970	\N	GLE.TR.IN	860101	iglicznia trójcierniowa       	Gleditsia triacanthos Inermis 	D	iglicznia                     	odm.bezbronna                 	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
206	01-01-1970	\N	GR	700100	grusza pospolita              	Pyrus communis                	D	grusza                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	15000	6000	0	OS	BRZ      	\N
207	01-01-1970	\N	GR.O	700300	grusza oliwnikowa             	Pyrus elaeagrifolia           	D	grusza                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
208	01-01-1970	\N	GR.W	700200	grusza wierzbolistna          	Pyrus salicifolia             	D	grusza                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
209	01-01-1970	\N	GRJ.J	520100	grujecznik japoński           	Cercidiphyllum japonicum      	D	grujecznik                    	\N	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
211	01-01-1970	\N	GŁG.D	750200	głóg dwuszyjkowy              	Crataegus oxyacantha          	K	głóg                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	25000	8000	0	OS	BRZ      	\N
212	01-01-1970	\N	GŁG.DL	750500	głóg długocierniowy           	Crataegus macracantha         	K	głóg                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
213	01-01-1970	\N	GŁG.K	750700	głóg kropkowany               	Crataegus punctata            	K	głóg                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
214	01-01-1970	\N	GŁG.O	750400	głóg ostrogowy                	Crataegus crus-galli          	K	głóg                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
215	01-01-1970	\N	GŁG.S	750300	głóg szkarłatny               	Crataegus coccinea            	K	głóg                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
216	01-01-1970	\N	GŁG.l	750600	głóg Lavallego                	Crataegus lavallei            	K	głóg                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
217	01-01-1970	\N	GŁK.K	740100	głogownik kosmaty             	Photinia villosa              	K	głogownik                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
218	01-01-1970	\N	GŁW.C	100100	głowocis chiński              	Cephalotaxus fortunei         	D	głowocis                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
219	01-01-1970	\N	GŁW.J	100200	głowocis japoński             	Cephalotaxus harringtonia     	D	głowocis                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
220	01-01-1970	\N	HAM.JA.FP	600301	oczar japonski                	Hamamelis japonica flavo-purp.	K	oczar                         	odm.złtopurpurowa             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
221	01-01-1970	\N	HOR.B	570300	hortensja bukietowa           	Hydrangea paniculata          	K	hortensja                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
222	01-01-1970	\N	HOR.K	570200	hortensja krzewiasta          	Hydrangea arborescens         	K	hortensja                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
223	01-01-1970	\N	HOR.O	570100	hortensja ogrodowa            	Hydrangea macrophylla         	K	hortensja                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
224	01-01-1970	\N	HOR.P	570400	hortensja pnąca               	Hydrangea petiolaris          	K	hortensja                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
225	01-01-1970	\N	HYD.AR.GR	570201	hortensja krzewiasta          	Hydrangea arborescens Grandif.	K	hortensja                     	odm.'Grandiflora'             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
226	01-01-1970	\N	HYD.PA.GR	570301	hortensja bukietowa           	Hydrangea paniculata Grandifl.	K	hortensja                     	odm.'Grandiflora'             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
227	01-01-1970	\N	IGL.T	860100	iglicznia trójcierniowa       	Gleditsia triacanthos         	D	iglicznia                     	\N	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
228	01-01-1970	\N	IRG	770400	irga pospolita                	Cotoneaster integerrima       	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
229	01-01-1970	\N	IRG.B	771000	irga błyszcząca               	Cotoneaster lucida            	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
230	01-01-1970	\N	IRG.C	770600	irga czarna                   	Cotoneaster melanocarpa       	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
231	01-01-1970	\N	IRG.D	770700	irga Dielsa                   	Cotoneaster dielsiana         	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
232	01-01-1970	\N	IRG.DA	771200	irga Dammera                  	Cotoneaster dammeri           	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
233	01-01-1970	\N	IRG.DA.CB	771202	irga Dammera                  	Cotoneaster dammeri           	K	irga                          	odm. Coral Beauty             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
234	01-01-1970	\N	IRG.K	770500	irga kutnerowata              	Cotoneaster tomentosa         	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
235	01-01-1970	\N	IRG.P	770100	irga pozioma                  	Cotoneaster horizontalis      	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
236	01-01-1970	\N	IRG.PO	770800	irga pomarszczona             	Cotoneaster bullata           	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
237	01-01-1970	\N	IRG.R	770300	irga rozkrzewiona             	Cotoneaster divaricata        	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
238	01-01-1970	\N	IRG.W	770200	irga wczesna                  	Cotoneaster praecox           	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
239	01-01-1970	\N	IRG.WK	771100	irga wielokwiatowa            	Cotoneaster multiflora        	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
240	01-01-1970	\N	IRG.WL	770900	irga wielkolistna             	Cotoneaster foveolata         	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
241	01-01-1970	\N	IWA	390800	wierzba iwa                   	Salix caprea                  	D	wierzba                       	\N	\N	OS 	OS 	L	BRZ      	BRZ      	OS       	\N	1	0	0	0	OS	BRZ      	\N
242	01-01-1970	\N	IWA.P	390801	wierzba iwa                   	Salix caprea                  	D	wierzba                       	odm. Pendula                  	\N	OS 	OS 	L	BRZ      	BRZ      	OS       	\N	1	0	0	0	OS	BRZ      	\N
243	01-01-1970	\N	JAN.B	970200	janowiec barwierski           	Genista tinctoria             	K	janowiec                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
244	01-01-1970	\N	JAN.C	970100	janowiec ciernisty            	Genista germanica             	K	janowiec                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
245	01-01-1970	\N	JAN.W	970300	janowiec włosisty             	Genista pilosa                	K	janowiec                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
246	01-01-1970	\N	JAŁ	60100	jałowiec pospolity            	Juniperus communis            	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	15000	6000	0	OS	ŚW       	\N
247	01-01-1970	\N	JAŁ.C	60200	jałowiec chiński              	Juniperus chinensis           	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
248	01-01-1970	\N	JAŁ.C.CG	60201	jał88owiec chiński            	Juniperus chinensis           	K	jał88owiec                    	odm. Columnaris Glauca        	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
249	01-01-1970	\N	JAŁ.C.P	60202	jał88owiec chiński            	Juniperus chinensis           	K	jał88owiec                    	odm. Pfizeriana               	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
250	01-01-1970	\N	JAŁ.C.PA	60203	jałowiec chiński              	Juniperus chinensis           	K	jałowiec                      	odm. Pfizeriana Aurea         	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
251	01-01-1970	\N	JAŁ.C.S	60204	jałowiec chiński              	Juniperus chinensis           	K	jałowiec                      	odm. Stricta                  	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
252	01-01-1970	\N	JAŁ.C.V	60205	ja88łowiec chiński            	Juniperus chinensis           	K	jał88owiec                    	odm. Variegata                	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
253	01-01-1970	\N	JAŁ.DA	60101	ja88łowiec pospolity          	Juniperus communis            	K	jał88owiec                    	odm. Depressa Aurea           	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
254	01-01-1970	\N	JAŁ.G	60500	jałowiec grecki               	Juniperus excelsa             	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
255	01-01-1970	\N	JAŁ.GK	60900	jałowiec grubokory            	Juniperus pachyphloea         	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
256	01-01-1970	\N	JAŁ.HI	60102	jał88owiec pospolity          	Juniperus communis            	K	jałowiec                      	odm. Hibernica                	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
257	01-01-1970	\N	JAŁ.K	60800	jałowiec kolczasty            	Juniperus oxycedrus           	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
258	01-01-1970	\N	JAŁ.N	60300	jałowiec nadbrzeżny           	Juniperus conferta            	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
259	01-01-1970	\N	JAŁ.P	60400	jałowiec pestkowaty           	Juniperus drupacea            	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
260	01-01-1970	\N	JAŁ.PL	60600	jałowiec płożący              	Juniperus horizontalis        	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
261	01-01-1970	\N	JAŁ.PL.BC	60601	jał88owiec płożący            	Juniperus horizontalis        	K	jał88owiec                    	odm. Blue Chip                	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
262	01-01-1970	\N	JAŁ.PL.DG	60603	jał88owiec pł88ożący          	Juniperus horizontalis        	K	jał88owiec                    	odm. Douglasii                	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
263	01-01-1970	\N	JAŁ.PL.MO	60604	jałowiec płożący              	Juniperus horizontalis        	K	jałowiec                      	odm. Montana                  	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
264	01-01-1970	\N	JAŁ.PL.RP	60602	jał88owiec pł88ożący          	Juniperus horizontalis        	K	jał88owiec                    	odm. Reptans                  	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
265	01-01-1970	\N	JAŁ.PL.WT	60605	jałowiec płożący              	Juniperus horizontalis        	K	jałowiec                      	odm. Wiltonii                 	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
266	01-01-1970	\N	JAŁ.R	61000	jałowiec rozesłany            	Juniperus procumbens          	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
267	01-01-1970	\N	JAŁ.S	61100	jałowiec sztywny              	Juniperus rigida              	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
268	01-01-1970	\N	JAŁ.SA	61200	jałowiec sawina               	Juniperus sabina              	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
269	01-01-1970	\N	JAŁ.SA.BD	61201	jałowiec sabiński  (sawina)   	Juniperus sabina              	K	jałowiec                      	odm. Blue Danube              	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
270	01-01-1970	\N	JAŁ.SA.T	61202	jałowiec sabiński  (sawina)   	Juniperus sabina              	K	jał88owiec                    	odm. Tamariscifolia           	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
271	01-01-1970	\N	JAŁ.SK	61300	jałowiec skalny               	Juniperus scopulorum          	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
272	01-01-1970	\N	JAŁ.TM	60103	jałowiec pospolity            	Juniperus communis            	K	jał88owiec                    	odm. Tempelhof                	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
273	01-01-1970	\N	JAŁ.W	61500	jałowiec wirginijski          	Juniperus virginiana          	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
274	01-01-1970	\N	JAŁ.W.GO	61501	jałowiec wirginijski          	Juniperus virginiana          	K	jałowiec                      	odm. Grey Owl                 	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
275	01-01-1970	\N	JAŁ.W.S	61502	jałowiec wirginijski          	Juniperus virginiana          	K	jałowiec                      	odm. Skyrocket                	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
276	01-01-1970	\N	JAŁ.Z	60700	jałowiec zachodni             	Juniperus occidentalis        	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
277	01-01-1970	\N	JAŁ.Ł	61400	jałowiec łuskowaty            	Juniperus squamata            	K	jałowiec                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
278	01-01-1970	\N	JAŁ.Ł.BC	61401	jałowiec łuskowaty            	Juniperus squamata            	K	jał88owiec                    	odm. Blue Carpet              	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
279	01-01-1970	\N	JAŚ.F	550300	jaśminowiec Falconera         	Philadelphus falconeri        	K	jaśminowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
280	01-01-1970	\N	JAŚ.K	550200	jaśminowiec kaukaski          	Philadelphus caucasicus       	K	jaśminowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
281	01-01-1970	\N	JAŚ.L	550400	jaśminowiec Lemoine'a         	Philadelphus lemoinei         	K	jaśminowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
282	01-01-1970	\N	JAŚ.P	550700	jaśminowiec panieński         	Philadelphus virginalis       	K	jaśminowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
283	01-01-1970	\N	JAŚ.P.BS	550703	jaśminowiec panieński         	Philadelphus virginalis       	K	jaśminowiec                   	odm. Biały Sopel              	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
284	01-01-1970	\N	JAŚ.P.G	550702	jaśminowiec panieński         	Philadelphus virginalis       	K	jaśminowiec                   	odm. Girandale                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
285	01-01-1970	\N	JAŚ.W	550100	jaśminowiec wonny             	Philadelphus coronarius       	K	jaśminowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
286	01-01-1970	\N	JAŚ.WI	550500	jaśminowiec wierzchotkowy     	Philadelphus cymosus          	K	jaśminowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
287	01-01-1970	\N	JAŚ.WL	550600	jaśminowiec wielkokwiatowy    	Philadelphus polyanthus       	K	jaśminowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
288	01-01-1970	\N	JB	690100	jabłoń dzika                  	Malus silvestris              	D	jabłoń                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	18000	6000	0	OS	BRZ      	\N
289	01-01-1970	\N	JB.J	690400	jabłoń jagodowa               	Malus baccata                 	D	jabłoń                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
290	01-01-1970	\N	JB.K	690500	jabłoń kwiecista              	Malus floribunda              	D	jabłoń                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
291	01-01-1970	\N	JB.N	690200	jabłoń niska                  	Malus pumila                  	D	jabłoń                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
292	01-01-1970	\N	JB.P	690300	jabłoń purpurowa              	Malus purpurea                	D	jabłoń                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
293	01-01-1970	\N	JB.S	690600	jabłoń Scheideckera           	Malus scheideckeri            	D	jabłoń                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
294	01-01-1970	\N	JD	40100	jodła pospolita               	Abies alba                    	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	35000	10000	50000	JD	JD       	\N
295	01-01-1970	\N	JD.A	40300	jodła Arnolda                 	Abies arnoldiana              	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
296	01-01-1970	\N	JD.AL	42500	jodła algierska               	Abies numidica                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
297	01-01-1970	\N	JD.B	40500	jodła Borysa                  	Abies borisii-regis           	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
298	01-01-1970	\N	JD.BA	40400	jodła balsamiczna             	Abies balsamea                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
299	01-01-1970	\N	JD.BK	42300	jodła białokora               	Abies nephrolepis             	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
300	01-01-1970	\N	JD.BO	40600	jodła Bornmullera             	Abies bornmuelleriana         	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
301	01-01-1970	\N	JD.D	41100	jodła Delavaya                	Abies delavayi                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
302	01-01-1970	\N	JD.F	41400	jodła Frasera                 	Abies fraseri                 	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
303	01-01-1970	\N	JD.G	41900	jodła górska                  	Abies lasiocarpa              	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
304	01-01-1970	\N	JD.GK	41901	jodła górska                  	Abies lasiocarpa ssp.arizonica	D	jodła                         	odm.korkowa                   	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	ŚW       	\N
305	01-01-1970	\N	JD.GR	40800	jodła grecka                  	Abies cephalonica             	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
306	01-01-1970	\N	JD.H	42700	jodła hiszpańska              	Abies pinsapo                 	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
307	01-01-1970	\N	JD.J	41000	jodła jednobarwna             	Abies concolor                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
308	01-01-1970	\N	JD.JP	41300	jodła japońska                	Abies firma                   	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
309	01-01-1970	\N	JD.K	41800	jodła koreańska               	Abies koreana                 	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
310	01-01-1970	\N	JD.KS	42400	jodła kaukaska                	Abies nordmanniana            	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
311	01-01-1970	\N	JD.M	41600	jodła mandżurska              	Abies holophylla              	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
312	01-01-1970	\N	JD.MS	42100	jodła marokańska              	Abies marocana                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
313	01-01-1970	\N	JD.N	40700	jodła nadobna                 	Abies bracteata               	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
314	01-01-1970	\N	JD.NI	41700	jodła nikko                   	Abies homolepis               	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
315	01-01-1970	\N	JD.NO	43300	jodła nieokreślona            	Abies species                 	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
316	01-01-1970	\N	JD.O	41500	jodła olbrzymia               	Abies grandis                 	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
317	01-01-1970	\N	JD.P	42600	jodła Pardego                 	Abies pardei                  	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
318	01-01-1970	\N	JD.S	40900	jodła syryjska                	Abies cylicica                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
319	01-01-1970	\N	JD.SC	42900	jodła sachalińska             	Abies sachalinensis           	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
320	01-01-1970	\N	JD.SL	42800	jodła szlachetna              	Abies procera                 	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
865	01-01-1970	\N	LIP.LOE	2005800	lipiennik Loesela             	Liparis loeselii              	K	lipiennik                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
321	01-01-1970	\N	JD.SY	42200	jodła sycylijska              	Abies nebrodensis             	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
322	01-01-1970	\N	JD.SYB	43000	jodła syberyjska              	Abies sibirica                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
323	01-01-1970	\N	JD.T	41200	jodła trojanska               	Abies equi-trojani            	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
324	01-01-1970	\N	JD.V	43100	jodła Veitha                  	Abies veitchii                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
325	01-01-1970	\N	JD.VI	43200	jodła Vilmorina               	Abies vilmorinii              	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
326	01-01-1970	\N	JD.W	40200	jodła wonna                   	Abies amabilis                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
327	01-01-1970	\N	JD.WS	42000	jodła wspaniała               	Abies magnifica               	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
328	01-01-1970	\N	JD.WS.S	42001	jodła wspaniała               	Abies magnifica var.shastensis	D	jodła                         	szasteńska                    	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	ŚW       	\N
329	01-01-1970	\N	JEM	480100	jemioła pospolita             	Viscum album                  	K	jemioła                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
330	01-01-1970	\N	JEM.J	480200	jemioła jodłowa               	Viscum abietis                	K	jemioła                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
331	01-01-1970	\N	JEM.R	480300	jemioła rozpierzchła          	Viscum laxum                  	K	jemioła                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
332	01-01-1970	\N	JKL	320900	klon jesionolistny            	Acer negundo                  	D	klon                          	\N	\N	OS 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
333	01-01-1970	\N	JRZ	730100	jarząb pospolity              	Sorbus aucuparia              	D	jarząb                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	25000	6000	0	OS	BRZ      	\N
334	01-01-1970	\N	JRZ.B	730500	jarzab brekinia               	Sorbus torminalis             	D	jarząb                        	\N	\N	BRZ	BRZ	L	BRZ      	BRZ      	OS       	\N	3	0	0	0	OS	BRZ      	\N
335	01-01-1970	\N	JRZ.M	730400	jarzab mączny                 	Sorbus aria                   	D	jarząb                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
336	01-01-1970	\N	JRZ.P	730300	jarzab pośredni               	Sorbus hybrida                	D	jarząb                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
337	01-01-1970	\N	JRZ.S	730200	jarzab szwedzki               	Sorbus intermedia             	D	jarząb                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
338	01-01-1970	\N	JS	340100	jesion wyniosły               	Fraxinus excelsior            	D	jesion                        	\N	\N	DB 	JS 	L	\N	\N	DB       	\N	3	30000	8000	40000	DB	DB       	\N
339	01-01-1970	\N	JS.A	340300	jesion amerykanski            	Fraxinus americana            	D	jesion                        	\N	\N	DB 	JS 	L	BK       	BK       	DB       	\N	3	0	0	0	DB	DB       	\N
340	01-01-1970	\N	JS.M	340400	jesion mannowy                	Fraxinus ornus                	D	jesion                        	\N	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
341	01-01-1970	\N	JS.P	340200	jesion pensylwanski           	Fraxinus pennsylvanica        	D	jesion                        	\N	\N	DB 	JS 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
342	01-01-1970	\N	JUD.K	880200	judaszowiec kanadyjski        	Circis canadensis             	K	judaszowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
343	01-01-1970	\N	JUD.P	880100	judaszowiec południowy        	Cercis siliquastrum           	K	judaszowiec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
344	01-01-1970	\N	JW	320200	klon jawor                    	Acer pseudoplatanus           	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	30000	10000	15000	DB	DB       	\N
345	01-01-1970	\N	JŚM.N	1300100	jaśmin nagokwiatowy           	Jasminum nudiflorum           	K	jaśmin                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
346	01-01-1970	\N	KAL.B	1360500	kalina Burkwooda              	Viburnum burkwoodii           	K	kalina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
347	01-01-1970	\N	KAL.H	1360200	kalina hordowina              	Viburnum lantana              	K	kalina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	25000	8000	0	OS	BRZ      	\N
348	01-01-1970	\N	KAL.J	1360400	kalina Judda                  	Viburnum juddii               	K	kalina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
349	01-01-1970	\N	KAL.K	1360100	kalina koralowa               	Viburnum opulus               	K	kalina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	25000	8000	0	OS	BRZ      	\N
350	01-01-1970	\N	KAL.KA	1360800	kalina kanadyjska             	Viburnum lentago              	K	kalina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
351	01-01-1970	\N	KAL.KR	1360300	kalina koreanska              	Viburnum carlesii             	K	kalina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
352	01-01-1970	\N	KAL.S	1360600	kalina sztywnolistna          	Viburnum rhytidophyllum       	K	kalina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
353	01-01-1970	\N	KAL.W	1360700	kalina wonna                  	Viburnum fragrans             	K	kalina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
354	01-01-1970	\N	KAR.C	940300	karagana ciernista            	Caragana spinosa              	K	karagana                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
355	01-01-1970	\N	KAR.K	940400	karagana karłowata            	Caragana pygmaea              	K	karagana                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
356	01-01-1970	\N	KAR.P	940200	karagana podolska             	Caragana frutex               	K	karagana                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
357	01-01-1970	\N	KAR.PO	940500	karagana pomarańczowa         	Caragana aurantiaca           	K	karagana                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
358	01-01-1970	\N	KAR.S	940100	karagana syberyjska           	Caragana arborescens          	K	karagana                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	25000	8000	0	OS	BRZ      	\N
359	01-01-1970	\N	KER.JA.PL	800101	złotlin japoński              	Kerria japonica Pleniflora    	K	złotlin                       	odm.'Pleniflora'              	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
360	01-01-1970	\N	KET.S	1150100	ketmia syryjska               	Hibiscus syriacus             	K	ketmia                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
361	01-01-1970	\N	KL	320100	klon pospolity                	Acer platanoides              	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	30000	10000	15000	DB	DB       	\N
362	01-01-1970	\N	KL.C	320600	klon cukrowy                  	Acer saccharum                	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	0	0	0	DB	DB       	\N
363	01-01-1970	\N	KL.CZ	320800	klon czerwony                 	Acer rubrum                   	D	klon                          	\N	\N	DB 	BK 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
364	01-01-1970	\N	KL.CZ.CO	320801	klon czerwony                 	Acer rubrum                   	D	klon                          	odm. Columnare                	\N	DB 	BK 	L	\N	\N	BK       	\N	3	0	0	0	DB	BRZ      	\N
365	01-01-1970	\N	KL.G	320400	klon ginnala                  	Acer ginnala                  	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	0	0	0	DB	DB       	\N
366	01-01-1970	\N	KL.N	321300	klon nikkonski                	Acer nikoense                 	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	0	0	0	DB	DB       	\N
367	01-01-1970	\N	KL.O	321100	klon okrągłolistny            	Acer circinatum               	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	0	0	0	DB	DB       	\N
368	01-01-1970	\N	KL.P	320500	klon polny                    	Acer campestre                	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	30000	10000	0	DB	DB       	\N
369	01-01-1970	\N	KL.PA	321000	klon palmowy                  	Acer palmatum                 	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	0	0	0	DB	DB       	\N
370	01-01-1970	\N	KL.PE	321200	klon pensylwanski             	Acer pensylvanicum            	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	0	0	0	DB	DB       	\N
371	01-01-1970	\N	KL.SR	320700	klon srebrzysty               	Acer saccharinum              	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	0	0	0	DB	DB       	\N
372	01-01-1970	\N	KL.T	320300	klon tatarski                 	Acer tataricum                	D	klon                          	\N	\N	DB 	BK 	L	BK       	BK       	BK       	\N	3	0	0	0	DB	DB       	\N
373	01-01-1970	\N	KLC.P	1330100	kolcowój pospolity            	Lycium halimifolium           	K	kolcowój                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
374	01-01-1970	\N	KLM.S	1250100	kalmia szrokolistna           	Kalmia latifolia              	K	kalmia                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
375	01-01-1970	\N	KOK.W	490100	kokornak wielkokwiatowy       	Aristolochia durior           	K	kokornak                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
376	01-01-1970	\N	KRK.A	1000100	korkowiec amurski             	Phellodendron amurense        	D	korkowiec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
377	01-01-1970	\N	KRU	1120100	kruszyna pospolita            	Rhamnus frangula              	K	kruszyna                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	25000	8000	0	OS	BRZ      	\N
378	01-01-1970	\N	KSZ	1100100	kasztanowiec biały            	Aesculus hippocastanum        	D	kasztanowiec                  	\N	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	30000	6000	0	OS	BRZ      	\N
379	01-01-1970	\N	KSZ.C	1100200	kasztanowiec czerwony         	Aesculus carnea               	D	kasztanowiec                  	\N	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
380	01-01-1970	\N	KSZ.D	1100600	kasztanowiec drobnokwiatowy   	Aesculus parviflora           	D	kasztanowiec                  	\N	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
381	01-01-1970	\N	KSZ.G	1100400	kasztanowiec gładki           	Aesculus glabra               	D	kasztanowiec                  	\N	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
382	01-01-1970	\N	KSZ.K	1100500	kasztanowiec krwisty          	Aesculus pavia                	D	kasztanowiec                  	\N	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
383	01-01-1970	\N	KSZ.Z	1100300	kasztanowiec zółty            	Aesculus octandra             	D	kasztanowiec                  	\N	\N	OS 	BRZ	L	BRZ      	OS       	OS       	\N	3	0	0	0	OS	BRZ      	\N
384	01-01-1970	\N	KT	840100	kasztan jadalny               	Castanea sativa               	D	kasztan                       	\N	\N	DB 	DB 	L	DB       	DB       	OS       	\N	3	0	0	0	OS	DB       	\N
385	01-01-1970	\N	KTP.B	1340200	katalpa bignoniowa            	Catalpa bignonioides          	D	katalpa                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
386	01-01-1970	\N	KTP.O	1340400	katalpa okazała               	Catalpa speciosa              	D	katalpa                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
387	01-01-1970	\N	KTP.P	1340300	katalpa pośrednia             	Catalpa erubescens            	D	katalpa                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
388	01-01-1970	\N	KTP.Z	1340100	katalpa żołtokwiatowa         	Catalpa ovata                 	D	katalpa                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
389	01-01-1970	\N	KUN.C	130100	kuningamia chińska            	Cunninghamia lanceolata       	D	kuningamia                    	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
390	01-01-1970	\N	KŁO.P	1090100	kłokoczka południowa          	Staphylea pinnata             	K	kłokoczka                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
391	01-01-1970	\N	KŁk.K	870100	kłęk kanadyjski               	Gymnocladus dioicus           	D	kłęk                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
392	01-01-1970	\N	LAR.GM.JA	20401	modrzew daurski               	Larix gmelinii japonica       	D	modrzew                       	odm.japońska                  	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
866	01-01-1970	\N	LNI.WON	2000900	lnica wonna                   	Linaria odora                 	K	lnica                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
393	01-01-1970	\N	LAR.GM.OL	20402	modrzew daurski               	Larix gmelinii olgensis       	D	modrzew                       	odm.ussuryjska                	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
394	01-01-1970	\N	LAR.GM.PR	20403	modrzew daurski               	Larix gmelinii pr.-rupprechtii	D	modrzew                       	odm.Ruprechta                 	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
395	01-01-1970	\N	LAW.W	1320100	lawenda wąskolistna           	Lavandula angustifolia        	K	lawenda                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
396	01-01-1970	\N	LEU.EU.SU	20105	modrzew europejski            	Larix decidua sudetica        	D	modrzew                       	odm.sudecka                   	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
397	01-01-1970	\N	LIG	1290100	ligustr pospolity             	Ligustrum vulgare             	K	ligustr                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
398	01-01-1970	\N	LIG.A	1290400	ligustr amurski               	Ligustrum amurense            	K	ligustr                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
399	01-01-1970	\N	LIG.J	1290200	ligustr jajolistny            	Ligustrum ovalifolium         	K	ligustr                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
400	01-01-1970	\N	LIG.OB.RE	1290301	ligustr tępolistny            	Ligustrum obtusifol.regelianum	K	ligustr                       	odm.Regela                    	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
401	01-01-1970	\N	LIG.T	1290300	ligustr tępolistny            	Ligustrum obtusifolium        	K	ligustr                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
402	01-01-1970	\N	LIG.VU.AT	1290102	ligustr pospolity             	Ligustrum vulgare Atrovirens  	K	ligustr                       	odm.ciemnozielona             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
403	01-01-1970	\N	LIG.VU.AU	1290104	ligustr pospolity             	Ligustrum vulgare Aureum      	K	ligustr                       	odm.złocista                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
404	01-01-1970	\N	LIG.VU.CH	1290105	ligustr pospolity             	Ligustrum vulgare Chlorocarpum	K	ligustr                       	odm.zielonoowocowa            	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
405	01-01-1970	\N	LIG.VU.DE	1290106	ligustr pospolity             	Ligustrum vulgare Densiflorum 	K	ligustr                       	odm.gęstokwiatowa             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
406	01-01-1970	\N	LIG.VU.LO	1290101	ligustr pospolity             	Ligustrum vulgare Lodense     	K	ligustr                       	odm.karłowa                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
407	01-01-1970	\N	LIG.VU.PY	1290103	ligustr pospolity             	Ligustrum vulgare Pyramidale  	K	ligustr                       	odm.stożkowa                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
408	01-01-1970	\N	LIL	1280100	lilak pospolity               	Syringa vulgaris              	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
409	01-01-1970	\N	LIL.A	1280800	lilak amurski                 	Syringa amurensis             	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
410	01-01-1970	\N	LIL.C	1280400	lilak chiński                 	Syringa chinensis             	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
411	01-01-1970	\N	LIL.H	1280200	lilak hiacyntowy              	Syringa hiacithiflora         	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
412	01-01-1970	\N	LIL.J	1280500	lilak Josiki                  	Syringa josikaea              	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
413	01-01-1970	\N	LIL.M	1280900	lilak Meyera                  	Syringa meyeri                	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
414	01-01-1970	\N	LIL.P	1280300	lilak perski                  	Syringa persica               	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
415	01-01-1970	\N	LIL.PR	1280700	lilak Prestony                	Syringa prestoniae            	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
416	01-01-1970	\N	LIL.W	1281000	lilak Wolfa                   	Syringa wolfii                	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
417	01-01-1970	\N	LIL.Z	1280600	lilak zwisły                  	Syringa reflexa               	K	lilak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
418	01-01-1970	\N	LON.IN.SE	1391101	suchodrzew skrytoowocowy      	Lonicera involucrata serotina 	K	suchodrzew                    	odm.późna                     	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
419	01-01-1970	\N	LON.SP.AL	1391201	suchodrzew ciernisty          	Lonicera spinosa albertii     	K	suchodrzew                    	odm.Alberta                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
420	01-01-1970	\N	LP	400100	lipa drobnolistna             	Tilia cordata                 	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	40000	8000	20000	OS	DB       	\N
421	01-01-1970	\N	LP.A	400600	lipa amerykańska              	Tilia americana               	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
422	01-01-1970	\N	LP.D	400900	lipa dlugoogonkowa            	Tilia petiolaris              	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
423	01-01-1970	\N	LP.G	401000	lipa gwiaździsta              	Tilia stellata                	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
424	01-01-1970	\N	LP.H	400300	lipa holenderska              	Tilia europaea                	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
425	01-01-1970	\N	LP.J	400400	lipa japońska                 	Tilia japonica                	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
426	01-01-1970	\N	LP.K	400500	lipa krymska                  	Tilia euchlora                	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
427	01-01-1970	\N	LP.M	401100	lipa Moltkego                 	Tilia moltkei                 	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
428	01-01-1970	\N	LP.NO	401200	lipa nieokreślona             	Tilia species                 	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
429	01-01-1970	\N	LP.S	400200	lipa szerokolistna            	Tilia platyphyllos            	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	50000	8000	0	OS	DB       	\N
430	01-01-1970	\N	LP.SR	400700	lipa srebrzysta               	Tilia tomentosa               	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
431	01-01-1970	\N	LP.W	400800	lipa warszawska               	Tilia Varsaviensis            	D	lipa                          	\N	\N	OS 	BK 	L	LP       	OS       	OL       	\N	1	0	0	0	OS	DB       	\N
432	01-01-1970	\N	LSZ	760100	leszczyna pospolita           	Corylus avellana              	K	leszczyna                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
433	01-01-1970	\N	LSZ.P	760200	leszczyna południowa          	Corylus maxima                	K	leszczyna                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
434	01-01-1970	\N	LSZ.T	760300	leszczyna turecka             	Corylus colurna               	K	leszczyna                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
435	01-01-1970	\N	LWŚ.W	852000	laurowiśnia wschodnia         	Prunus laurocerasus           	K	śliwa                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
436	01-01-1970	\N	MAG.D	530600	magnolia drzewiasta           	Magnolia acuminata            	D	magnolia                      	\N	\N	\N	\N	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
437	01-01-1970	\N	MAG.G	530500	magnolia gwiaździsta          	Magnolia stellata             	K	magnolia                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
438	01-01-1970	\N	MAG.J	530400	magnolia japońska             	Magnolia kobus                	K	magnolia                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
439	01-01-1970	\N	MAG.K	530800	magnolia kobus                	Magnolia kobus                	K	magnolia                      	odm. Susan                    	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
440	01-01-1970	\N	MAG.N	530200	magnolia naga                 	Magnolia denudata             	D	magnolia                      	\N	\N	\N	\N	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
441	01-01-1970	\N	MAG.P	530300	magnolia purpurowa            	Magnolia liliflora            	K	magnolia                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
442	01-01-1970	\N	MAG.PA	530700	magnolia parasolowata         	Magnolia tripetala            	D	magnolia                      	\N	\N	\N	\N	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
443	01-01-1970	\N	MAG.S	530100	magnolia Soulange'a           	Magnolia soulangiana          	K	magnolia                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
444	01-01-1970	\N	MAG.SO.AL	530103	magnolia Soulange'a           	Magnolia soulangiana Alexandr.	K	magnolia                      	odm.'Alexandrina'             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
445	01-01-1970	\N	MAG.SO.AM	530101	magnolia Soulange'a           	Magnolia soulangiana Amabilis 	K	magnolia                      	odm.'Amabilis'                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
446	01-01-1970	\N	MAG.SO.LE	530104	magnolia Soulange'a           	Magnolia soulangiana Lennei   	K	magnolia                      	odm.'Lennei'                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
447	01-01-1970	\N	MAG.SO.NI	530301	magnolia purpurowa            	Magnolia liliflora Nigra      	K	magnolia                      	odm.'Nigra'                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
448	01-01-1970	\N	MAG.SO.SP	530102	magnolia Soulange'a           	Magnolia soulangiana Speciosa 	K	magnolia                      	odm.'Speciosa'                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
449	01-01-1970	\N	MAH	500100	mahonia pospolita             	Mahonia aquifolium            	K	mahonia                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
450	01-01-1970	\N	MAK.P	470100	żołtnica pomarańczowa         	Maclura pomifera              	D	maklura                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
451	01-01-1970	\N	MAL.PU.PA	690201	jabłoń niska odm.rajska       	Malus pumila paradisiaca      	D	jabłoń                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
452	01-01-1970	\N	PRZ.CW	580600	porzeczka czerwona            	Ribes rubrum                  	K	porzeczka                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
453	01-01-1970	\N	MD	20100	modrzew europejski            	Larix decidua                 	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	50000	10000	25000	SO	SO       	\N
454	01-01-1970	\N	MD.A	20700	modrzew amerykański           	Larix laricina                	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
455	01-01-1970	\N	MD.C	21100	modrzew chiński               	Larix potaninii               	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
456	01-01-1970	\N	MD.CZ	20200	modrzew Czekanowskiego        	Larix czekanowskii            	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
457	01-01-1970	\N	MD.D	20400	modrzew daurski               	Larix gmelinii                	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
458	01-01-1970	\N	MD.E	20300	modrzew eurojapoński          	Larix eurolepis               	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
459	01-01-1970	\N	MD.H	20500	modrzew himalajski            	Larix griffithiana            	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
460	01-01-1970	\N	MD.J	20600	modrzew japoński              	Larix kaempferi               	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	32000	8000	0	SO	SO       	\N
461	01-01-1970	\N	MD.K	20106	modrzew europejski            	Larix decidua                 	D	modrzew                       	odm.Kórnik                    	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	ŚW       	\N
462	01-01-1970	\N	MD.M	20800	modrzew Marschlinsa           	Larix marschlinsii            	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
463	01-01-1970	\N	MD.NO	21300	modrzew  nieokreślony         	Larix species                 	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
464	01-01-1970	\N	MD.P	20104	modrzew europejski            	Larix decidua polonica        	D	modrzew                       	odm.polska                    	\N	SO 	MD 	I	\N	\N	SO       	\N	1	32000	8000	0	SO	SO       	\N
867	01-01-1970	\N	MAL.MOR	2007600	malina moroszka               	Rubus chamaemorus             	K	malina                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
465	01-01-1970	\N	MD.S	21200	modrzew syberyjski            	Larix sibirica                	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
466	01-01-1970	\N	MD.Z	21000	modrzew zwisły                	Larix pendula                 	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
467	01-01-1970	\N	MD.ZD	20900	modrzew zachodni              	Larix occidentalis            	D	modrzew                       	\N	\N	SO 	MD 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
468	01-01-1970	\N	MDK.C	170100	modrzewnik chiński            	Pseudolarix kaempferi         	D	modrzewnik                    	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	SO	ŚW       	\N
469	01-01-1970	\N	MIG	850800	migdałowiec pospolity         	Prunus amygdalus              	D	śliwa                         	\N	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
470	01-01-1970	\N	MIG.K	851000	migdałowiec karłowy           	Prunus tenella                	D	śliwa                         	\N	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
471	01-01-1970	\N	MIG.T	850900	migdałowiec trojklapowy       	Prunus triloba                	D	śliwa                         	\N	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
472	01-01-1970	\N	MIŁ.D	160100	miłorząb dwuklapowy           	Ginkgo biloba                 	D	miłorząb                      	\N	\N	\N	\N	I	\N	\N	OS       	\N	1	0	0	0	OS	ŚW       	\N
473	01-01-1970	\N	MIŁ.D.F	160101	miłorząb dwuklapowy           	Ginkgo biloba                 	D	miłorząb                      	odm. Fastigiata               	\N	\N	\N	I	\N	\N	OS       	\N	1	0	0	0	OS	ŚW       	\N
474	01-01-1970	\N	RNK.B	1230200	różanecznik Biały Cunninghama 	Rhododendron Cunnigham's White	K	różanecznik                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
475	01-01-1970	\N	MIŁ.D.P	160102	miłorząb dwuklapowy           	Ginkgo biloba                 	D	miłorząb                      	odm. Pendula                  	\N	\N	\N	I	\N	\N	OS       	\N	1	0	0	0	OS	ŚW       	\N
476	01-01-1970	\N	MOR.AL.PE	460101	morwa biała                   	Morus alba Pendula            	D	morwa                         	odm.'Pendula'                 	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
477	01-01-1970	\N	MRL	850600	morela pospolita              	Prunus armeniaca              	D	śliwa                         	\N	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
478	01-01-1970	\N	MS.C	62000	metasekwoja chińska           	Metasequoia glyptostroboides  	D	metasekwoja                   	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
479	01-01-1970	\N	MSZ.P	910100	moszeniec południowy          	Colutea arborescens           	K	moszeniec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
480	01-01-1970	\N	MW	460100	morwa biała                   	Morus alba                    	D	morwa                         	\N	\N	BRZ	BRZ	L	BRZ      	BRZ      	OS       	\N	3	15000	8000	0	OS	BRZ      	\N
481	01-01-1970	\N	OCZ.J	600300	oczar japonski                	Hamamelis japonica            	K	oczar                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
482	01-01-1970	\N	OCZ.O	600200	oczar omszony                 	Hamamelis mollis              	K	oczar                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
483	01-01-1970	\N	OCZ.W	600100	oczar wirginijski             	Hamamelis virginiana          	K	oczar                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
484	01-01-1970	\N	OGN.S	1410100	ognik szkarłatny              	Pyracantha coccinea           	K	ognik                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
485	01-01-1970	\N	OKŁ.B	810100	okółkowiec biały              	Rhodotypos scandens           	K	okółkowiec                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
486	01-01-1970	\N	OL	370100	olsza czarna                  	Alnus glutinosa               	D	olsza                         	\N	\N	OL 	OL 	L	\N	\N	OL       	\N	3	35000	12000	0	OL	OL       	\N
487	01-01-1970	\N	OL.S	370200	olsza szara                   	Alnus incana                  	D	olsza                         	\N	\N	OL 	OL 	L	\N	\N	OS       	\N	3	35000	14000	0	OL	OL       	\N
488	01-01-1970	\N	OL.Z	370300	olsza zielona                 	Alnus viridis                 	D	olsza                         	\N	\N	OL 	OL 	L	OL       	OL       	OS       	\N	3	0	0	0	OL	OL       	\N
489	01-01-1970	\N	OLW.B	1190300	oliwnik baldaszkowy           	Elaeagnus umbellata           	K	oliwnik                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
490	01-01-1970	\N	OLW.S	1190200	oliwnik srebrzysty            	Elaeagnus commutata           	K	oliwnik                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
491	01-01-1970	\N	OLW.W	1190100	oliwnik wąskolistny           	Elaeagnus angustifolia        	K	oliwnik                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
492	01-01-1970	\N	ORZ.C	430200	orzech czarny                 	Juglans nigra                 	D	orzech                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
493	01-01-1970	\N	ORZ.S	430300	orzech szary                  	Juglans cinerea               	D	orzech                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
494	01-01-1970	\N	ORZ.SE	430400	orzech sercowaty              	Juglans cordiformis           	D	orzech                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
750	01-01-1970	\N	WIN.T	1140300	winobluszcz trójklapowy       	Parthenocissus tricuspidata   	K	winobluszcz                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
495	01-01-1970	\N	ORZ.W	430100	orzech włoski                 	Juglans regia                 	D	orzech                        	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
496	01-01-1970	\N	OS	380200	topola osika                  	Populus tremula               	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	25000	6000	0	OS	BRZ      	\N
497	01-01-1970	\N	OST.K	1060100	ostrokrzew kolczasty          	Ilex aquifolium               	K	ostrokrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
498	01-01-1970	\N	OSZ.G	440100	orzesznik gorzki              	Carya cordiformis             	D	orzesznik                     	\N	\N	BRZ	BRZ	L	BRZ      	BRZ      	OS       	\N	3	0	0	0	OS	BRZ      	\N
499	01-01-1970	\N	OSZ.O	440400	orzesznik owłosiony           	Carya tomentosa               	D	orzesznik                     	\N	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
500	01-01-1970	\N	OSZ.P	440200	orzesznik pięciolistkowy      	Carya ovata                   	D	orzesznik                     	\N	\N	BRZ	BRZ	L	BRZ      	BRZ      	OS       	\N	3	0	0	0	OS	BRZ      	\N
501	01-01-1970	\N	OSZ.S	440300	orzesznik siedmiolistkowy     	Carya laciniosa               	D	orzesznik                     	\N	\N	\N	\N	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
502	01-01-1970	\N	PAR.T	990100	parczelina trójlistkowa       	Ptelea trifoliata             	K	parczelina                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
503	01-01-1970	\N	PCK.K	820100	pięciornik krzewiasty         	Potentilla fruticosa          	K	pięciornik                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
504	01-01-1970	\N	PCY.BO.BL	550501	jaśminowiec wierzchotkowy     	Philadelphus cymosus Bouq.Bl. 	K	jaśminowiec                   	odm.'Bouquet Blanc'           	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
505	01-01-1970	\N	PER.P	1050100	perukowiec podolski           	Cotinus coggygria             	K	perukowiec                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
506	01-01-1970	\N	PGC.J	720100	pigwowiec japoński            	Chaenomeles japonica          	K	pigwowiec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
507	01-01-1970	\N	PGC.O	720200	pigwowiec okazały             	Chaenomeles speciosa          	K	pigwowiec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
508	01-01-1970	\N	PGC.P	720300	pigwowiec pośredni            	Chaenomeles superba           	K	pigwowiec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
509	01-01-1970	\N	PGW	710100	pigwa pospolita               	Cydonia oblonga               	K	pigwa                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
510	01-01-1970	\N	PHI.CA.AU	550201	jaśminowiec kaukaski          	Philadelphus caucasicus Aureus	K	jaśminowiec                   	odm.'Aureus'                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
511	01-01-1970	\N	PHI.LE.ER	550401	jaśminowiec Lemoine'a         	Philadelphus lemoinei Erectus 	K	jaśminowiec                   	odm.'Erectus'                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
512	01-01-1970	\N	PHI.PO.NO	550601	jaśminowiec wielkokwiatowy    	Philadelphus polyanthus Norma 	K	jaśminowiec                   	odm.'Norma'                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
513	01-01-1970	\N	PHI.VI.VI	550701	jaśminowiec panieński         	Philadelphus virginalis Virgi.	K	jaśminowiec                   	odm.'Virginal'                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
514	01-01-1970	\N	PHY.OP.LU	650101	tawułowiec kalinolistny       	Physocarpus opulifolius Lateus	K	tawułowiec                    	odm.zółta                     	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
515	01-01-1970	\N	PIC.AB.CA	30107	świerk pospolity              	Picea abies carpathica        	D	świerk                        	odm.karpacka                  	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
516	01-01-1970	\N	PIC.AB.CU	30113	świerk pospolity              	Picea abies                   	D	świerk                        	odm.Cupressina                	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
517	01-01-1970	\N	PIN.RH.R	11101	Pinus rhaetica                	Pinus rhaetica                	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
518	01-01-1970	\N	PK	1311100	pęcherznica kalinolistna      	Physocarpus opulifolius       	K	pęcherznica                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
519	01-01-1970	\N	PK.L	1311101	pęcherznica kalinolistna      	Physocarpus opulifolius       	K	pęcherznica                   	odm. Luteus                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
520	01-01-1970	\N	PLA.K	630100	platan klonolistny            	Platanus acerifolia           	D	platan                        	\N	\N	DB 	BRZ	L	BK       	BK       	BK       	\N	1	0	0	0	OS	DB       	\N
521	01-01-1970	\N	PLE.MA.HE	550402	jaśminowiec Lemoine'a         	Philadelphus lemoinei Man.d'H.	K	jaśminowiec                   	odm.'Manteau d'Hermine'       	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
522	01-01-1970	\N	POP.NI.IT	380401	topola czarna                 	Populus nigra Italica         	D	topola                        	odm.'Italica'                 	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
523	01-01-1970	\N	POP.SI.FA	380601	topola chińska                	Populus simonii Fastigiata    	D	topola                        	odm.'Fastigiata'              	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
524	01-01-1970	\N	PRS.J	1260100	pieris japoński               	Pieris japonica               	K	pieris                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
525	01-01-1970	\N	PRU.CE.DI	850201	śliwa wiśniowa                	Prunus cerasifera divaricata  	K	śliwa                         	odm.kaukaska                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
526	01-01-1970	\N	PRU.CE.N	850204	śliwa wiś98niowa              	Prunus cerasifera             	K	śliwa                         	odm. Nigra                    	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
527	01-01-1970	\N	PRU.CE.PI	850202	śliwa wiśniowa                	Prunus cerasifera Atropurpurea	K	śliwa                         	odm.purpurowa                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
528	01-01-1970	\N	PRU.CE.RH	851101	wiśnia pospolita              	Prunus cerasus Rhexii         	D	śliwa                         	odm.'Rhexii'                  	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
529	01-01-1970	\N	PRU.CE.SP	850203	śliwa wiśniowa                	Prunus cerasifera Woodii      	K	śliwa                         	odm.Wooda                     	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
530	01-01-1970	\N	PRU.CE.UM	851102	wiśnia pospolita              	Prunus cerasus Umbraculifera  	D	śliwa                         	odm.kulista                   	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
531	01-01-1970	\N	PRU.GL.AL	851601	wiśnia gruczołkowata          	Prunus glandulosa Alboplena   	D	śliwa                         	odm.biała                     	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
532	01-01-1970	\N	PRU.IN.IT	850501	śliwa lubaszka                	Prunus insititia italica      	D	śliwa                         	odm.renklody                  	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
533	01-01-1970	\N	PRU.IN.SY	850502	śliwa lubaszka                	Prunus insititia syriaca      	D	śliwa                         	odm.mirabelki                 	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
534	01-01-1970	\N	PRU.LA.SC	852001	laurowiśnia wschodnia         	Prunus laurocerasus Schipkaen.	K	śliwa                         	odm.szypkajska                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
535	01-01-1970	\N	PRU.LA.ZA	852002	laurowiśnia wschodnia         	Prunus laurocerasus Zabeliana 	K	śliwa                         	odm.Zabela                    	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
536	01-01-1970	\N	PRU.SE.A	851503	wiśnia piłkowana              	Cerasus serrulata             	D	śliwa                         	odm. Amanogawa                	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
537	01-01-1970	\N	PRU.SE.KA	851501	wisnia piłkowana              	Prunus serrulata Kanzan       	D	śliwa                         	odm.'Kanzan'                  	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
538	01-01-1970	\N	PRU.SE.KR	851504	wiśnia piłkowana              	Cerasus serrulata             	D	śliwa                         	odm. Kórnicensis              	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
539	01-01-1970	\N	PRU.SE.KS	851502	wiśnia piłkowana              	Prunus serrulata Kiku-shi.-sa.	D	śliwa                         	odm.'Kiku-shidare-sakura'     	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
540	01-01-1970	\N	PRU.SE.S	851505	wiśnia piłkowana              	Cerasus serrulata             	D	śliwa                         	odm. Shirofungen              	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
541	01-01-1970	\N	PRZ.A	580100	porzeczka alpejska            	Ribes alpinum                 	K	porzeczka                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
542	01-01-1970	\N	PRZ.AM	580400	porzeczka amerykańska         	Ribes americanum              	K	porzeczka                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
543	01-01-1970	\N	PRZ.C	580500	porzeczka czarna              	Ribes nigrum                  	K	porzeczka                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
544	01-01-1970	\N	PRZ.K	580300	porzeczka krwista             	Ribes sanguineum              	K	porzeczka                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
545	01-01-1970	\N	PRZ.K.KE	580301	porzeczka krwista             	Ribes sanguineum              	K	porzeczka                     	odm. King Edward VII          	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
546	01-01-1970	\N	PRZ.S	580700	porzeczka skalna              	Ribes petraeum                	K	porzeczka                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
547	01-01-1970	\N	PRZ.Z	580200	porzeczka złota               	Ribes aureum                  	K	porzeczka                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
548	01-01-1970	\N	PSE.DO.GL	50103	daglezja zielona              	Pseudotsuga menziesii glauca  	D	daglezja                      	odm.sina                      	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
549	01-01-1970	\N	PYR.CO.LA	1410101	ognik szkarłatny              	Pyracantha coccinea Lalandei  	K	ognik                         	odm.'Lalandei'                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
550	01-01-1970	\N	QUE.PE.ME	310301	dąb bezszypułkowy             	Quercus petraea Mespilifolia  	D	dąb                           	odm.'Mespifolia'              	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
551	01-01-1970	\N	QUE.RO.CO	310201	dąb szypułkowy                	Quercus robur Concordia       	D	dąb                           	odm.'Concordia'               	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
552	01-01-1970	\N	QUE.RO.FA	310202	dąb szypułkowy                	Quercus robur Fastigiata      	D	dąb                           	odm.'Fastigiata'              	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
553	01-01-1970	\N	QUE.RO.PC	310204	dąb szypułkowy                	Quercus robur Pectinata       	D	dąb                           	odm.'Pectinata'               	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
554	01-01-1970	\N	QUE.RO.PE	310203	dąb szypułkowy                	Quercus robur Pendula         	D	dąb                           	odm.'Pendula'                 	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	DB       	\N
555	01-01-1970	\N	RHO.CA.AL	1230101	różanecznik katawbijski       	Rhododendron catawbiense Albus	K	różanecznik                   	odm.biała                     	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
556	01-01-1970	\N	RHO.CA.CA	1230102	różanecznik katawbijski       	Rhododendron catawb.Caractacus	K	różanecznik                   	odm.'Caractacus'              	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
557	01-01-1970	\N	RHO.CA.GR	1230103	różanecznik katawbijski       	Rhododendron catawb.Grandiflo.	K	różanecznik                   	odm.wielkokwiatowa            	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
558	01-01-1970	\N	RHO.CA.N	1230104	różanecznik katawbijski       	Rhododendron catawbiense      	K	różanecznik                   	odm. Nowa Zembla              	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
559	01-01-1970	\N	RHU.TY.DI	1040101	sumak octowiec                	Rhus typhina Dissecta         	K	sumak                         	odm.'Dissecta'                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
560	01-01-1970	\N	RIB.PE.CA	580701	porzeczka skalna              	Ribes petraeum carpathicum    	K	porzeczka                     	odm.karpacka                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
561	01-01-1970	\N	RIB.RU.PU	580601	porzeczka czerwona            	Ribes rubrum pubescens        	K	porzeczka                     	odm.omszona                   	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
562	01-01-1970	\N	RNK.K	1230100	różanecznik katawbijski       	Rhododendron catawbiense      	K	różanecznik                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
563	01-01-1970	\N	RNK.S	1230300	różanecznik Smirnowa          	Rhododendron smirnowii        	K	różanecznik                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
564	01-01-1970	\N	ROB.AM.DE	410301	robinia pośrednia             	Robinia ambigua Decaisneana   	D	robinia                       	odm.'Decaisneana'             	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
565	01-01-1970	\N	ROB.HI.MA	410501	robinia szczeciniasta         	Robinia hispida Macrophylla   	D	robinia                       	odm.wielkolistna              	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
566	01-01-1970	\N	ROB.L	410200	robinia lepka                 	Robinia viscosa               	D	robinia                       	\N	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
567	01-01-1970	\N	ROB.N	410400	robinia nowomeksykańska       	Robinia neomexicana           	D	robinia                       	\N	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
568	01-01-1970	\N	ROB.NE.LU	410401	robinia nowomeksykańska       	Robinia neomexicana luxurians 	D	robinia                       	odm.bujna                     	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
569	01-01-1970	\N	ROB.P	410300	robinia pośrednia             	Robinia ambigua               	D	robinia                       	\N	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
570	01-01-1970	\N	ROB.PS.BE	410102	robinia akacjowa              	Robinia pseudoacacia Bessonia.	D	robinia                       	odm.'Bessoniana'              	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
868	01-01-1970	\N	MAN.NAD	2006900	mannica nadmorska             	Puccinellia maritima (H.) Par.	K	mannica                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
571	01-01-1970	\N	ROB.PS.RO	410103	robinia akacjowa              	Robinia pseudoacacia Rozynsk. 	D	robinia                       	odm.'Rozynskiana'             	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
572	01-01-1970	\N	ROB.PS.UM	410101	robinia akacjowa              	Robinia pseudoacacia Umbracu. 	D	robinia                       	odm.kulista                   	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
573	01-01-1970	\N	ROB.S	410500	robinia szczeciniasta         	Robinia hispida               	D	robinia                       	\N	\N	BRZ	BRZ	L	\N	\N	OL       	\N	3	0	0	0	BRZ	BRZ      	\N
574	01-01-1970	\N	ROK	1200100	rokitnik pospolity            	Hippophae rhamnoides          	K	rokitnik                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	25000	8000	0	OS	BRZ      	\N
575	01-01-1970	\N	ROS.OM.PT	790301	róża czteropłatkowa           	Rosa omeiensis pteracantha    	K	róża                          	odm.oskrzydlona               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
576	01-01-1970	\N	RUN.J	1030100	runianka japońska             	Pachysandra terminalis        	K	runianka                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
577	01-01-1970	\N	RÓŻ.AL	791400	róża alpejska                 	Rosa pendulina                	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
578	01-01-1970	\N	RÓŻ.C	790300	róża czteropłatkowa           	Rosa omeiensis                	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
579	01-01-1970	\N	RÓŻ.CZ	790700	róża czerwonawa               	Rosa glauca                   	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
580	01-01-1970	\N	RÓŻ.D	790600	róża dzika                    	Rosa canina                   	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
581	01-01-1970	\N	RÓŻ.EL	791300	róża eliptyczna               	Rosa inodora                  	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
582	01-01-1970	\N	RÓŻ.F	790400	róża francuska                	Rosa gallica                  	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
583	01-01-1970	\N	RÓŻ.FL	790900	róża fałdzistolistna          	Rosa rugosa                   	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
584	01-01-1970	\N	RÓŻ.FM	791700	róża                          	Rosa ssp. Flamentanz          	K	róża                          	odm.Flamentanz                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
585	01-01-1970	\N	RÓŻ.G	790100	róża gestokolczasta           	Rosa pimpinellifolia          	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
586	01-01-1970	\N	RÓŻ.J	791600	róża jabłkowa                 	Rosa villosa                  	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
587	01-01-1970	\N	RÓŻ.K	791500	róża kutnerowata              	Rosa tomentosa                	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
588	01-01-1970	\N	RÓŻ.R	790800	róża rdzawa                   	Rosa rubiginosa               	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
589	01-01-1970	\N	RÓŻ.RO	791100	róża rolna                    	Rosa egrestis                 	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
590	01-01-1970	\N	RÓŻ.S	790500	róża stulistna                	Rosa centifolia               	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
591	01-01-1970	\N	RÓŻ.SI	791200	róża sina                     	Rosa dumalis                  	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
592	01-01-1970	\N	RÓŻ.W	791000	róża wielokwiatowa            	Rosa multiflora               	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
593	01-01-1970	\N	RÓŻ.Z	790200	róża zółta                    	Rosa foetida                  	K	róża                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
594	01-01-1970	\N	SAL.AL.CH	390103	wierzba biała                 	Salix alba Chermesina         	D	wierzba                       	odm.czerwonopędowa            	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
595	01-01-1970	\N	SAL.AL.SE	390104	wierzba biała                 	Salix alba Sericea            	D	wierzba                       	odm.srebrzysta                	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
596	01-01-1970	\N	SAL.AL.TR	390101	wierzba biała                 	Salix alba Tristis            	D	wierzba                       	odm.płacząca                  	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
597	01-01-1970	\N	SAL.AL.VI	390102	wierzba biała                 	Salix alba Vittelina          	D	wierzba                       	odm.złocista                  	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
598	01-01-1970	\N	SAL.EL.AN	391001	wierzba siwa                  	Salix elaeagnos Angustifolia  	D	wierzba                       	odm.'Angustifolia'            	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
599	01-01-1970	\N	SAL.FR.BU	390201	wierzba krucha                	Salix fragilis Bullata        	D	wierzba                       	odm.'Bullata'                 	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
600	01-01-1970	\N	SAL.LA	392100	wierzba lapońska              	Salix lapponum                	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
601	01-01-1970	\N	SAL.MA.TO	390301	wierzba mandżurska            	Salix matsudana Tortuosa      	D	wierzba                       	odm.'Tortuosa'                	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
602	01-01-1970	\N	SAL.PU.GR	390501	wiklina                       	Salix purpurea Gracilis       	K	wierzba                       	odm.'Gracilis'                	\N	OS 	OS 	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
603	01-01-1970	\N	SAM.NI.AU	1350101	bez czarny                    	Sambucus nigra Aurea          	K	bez                           	odm.złocista                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
604	01-01-1970	\N	SAM.NI.LA	1350102	bez czarny                    	Sambucus nigra Laciniata      	K	bez                           	odm.strzępolistna             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
605	01-01-1970	\N	SAM.RA.PA	1350202	bez koralowy                  	Sambucus racemosa Plumosa Aur.	K	bez                           	odm.pierzasta złocista        	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
606	01-01-1970	\N	SAM.RA.PL	1350201	bez koralowy                  	Sambucus racemosa Plumosa     	K	bez                           	odm.pierzasta                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
607	01-01-1970	\N	SCH	1390100	suchodrzew pospolity          	Lonicera xylosteum            	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
608	01-01-1970	\N	SCH.A	1390500	suchodrzew alpejski           	Lonicera alpigena             	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
609	01-01-1970	\N	SCH.C	1390700	suchodrzew czarny             	Lonicera nigra                	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
610	01-01-1970	\N	SCH.CH	1390900	suchodrzew chiński            	Lonicera pileata              	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
611	01-01-1970	\N	SCH.CR	1391200	suchodrzew ciernisty          	Lonicera spinosa              	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
612	01-01-1970	\N	SCH.K	1390300	suchodrzew Korolkowa          	Lonicera korolkowii           	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
613	01-01-1970	\N	SCH.L	1391000	suchodrzew Ledeboura          	Lonicera ladebourii           	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
614	01-01-1970	\N	SCH.M	1390400	suchodrzew Maacka             	Lonicera maackii              	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
615	01-01-1970	\N	SCH.S	1390800	suchodrzew siny               	Lonicera coeruela             	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
616	01-01-1970	\N	SCH.SK	1391100	suchodrzew skrytoowocowy      	Lonicera involucrata          	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
617	01-01-1970	\N	SCH.T	1390200	suchodrzew tatarski           	Lonicera tatarica             	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
618	01-01-1970	\N	SCH.W	1390600	suchodrzew wschodni           	Lonicera orientalis           	K	suchodrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
619	01-01-1970	\N	SK.K	450100	skrzydłorzech kaukaski        	Pterocarya fraxinifolia       	D	skrzydłorzech                 	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
620	01-01-1970	\N	SO	10100	sosna zwyczajna               	pinus silvestris              	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	45000	18000	80000	SO	SO       	\N
621	01-01-1970	\N	SO.B	10200	sosna Banksa                  	Pinus banksiana               	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
622	01-01-1970	\N	SO.BL	11300	sosna błotna                  	Pinus uliginosa               	D	sosna                         	\N	\N	SO 	SO 	I	SO       	SO       	SO       	\N	1	0	0	0	SO	SO       	\N
623	01-01-1970	\N	SO.C	10300	sosna czarna                  	Pinus nigra                   	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	60000	10000	50000	SO	SO       	\N
624	01-01-1970	\N	SO.H	11200	sosna hakowata                	Pinus uncinata                	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
625	01-01-1970	\N	SO.J	11000	sosna Jeffreya                	Pinus jeffreyi                	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
626	01-01-1970	\N	SO.K	10600	kosodrzewina                  	Pinus mugo                    	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	25000	10000	0	SO	SO       	\N
627	01-01-1970	\N	SO.L	10700	sosna limba                   	Pinus cembra                  	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	25000	12000	0	SO	SO       	\N
628	01-01-1970	\N	SO.O	10800	sosna oścista                 	Pinus aristata                	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
629	01-01-1970	\N	SO.S	10400	sosna smołowa                 	Pinus rigida                  	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
630	01-01-1970	\N	SO.W	10900	sosna wydmowa                 	Pinus contorta                	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
631	01-01-1970	\N	SO.WE	10500	sosna wejmutka                	Pinus strobus                 	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
632	01-01-1970	\N	SO.Ż	11100	sosna zółta                   	Pinus ponderosa               	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	SO       	\N
633	01-01-1970	\N	SOF.J	890100	sofora japońska               	Sophora japonica              	D	sofora                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
634	01-01-1970	\N	SOR.AU.ED	730101	jarzab pospolity              	Sorbus aucuparia Edulis       	D	jarząb                        	odm.'Edulis'                  	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
635	01-01-1970	\N	SOR.AU.JA	730103	jarzab pospolity              	Sorbus aucuparia              	D	jarząb                        	odm.japonska                  	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
636	01-01-1970	\N	SOR.AU.PE	730102	jarzab pospolity              	Sorbus aucuparia Pendula      	D	jarząb                        	odm.'Pendula'                 	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
637	01-01-1970	\N	SOR.J	660100	sorbaria jarzębolistna        	Sorbaria sorbifolia           	K	sorbaria                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
638	01-01-1970	\N	SPI.BU.AW	640701	tawuła drobna                 	Spiraea bumalda Anthony Water.	K	tawuła                        	odm.'Anthony Waterer'         	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
751	01-01-1970	\N	WIN.Z	1140200	winobluszcz zaroślowy         	Parthenocissus vitacea        	K	winobluszcz                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
639	01-01-1970	\N	SPI.BU.CR	640704	tawuła drobna                 	Spiraea bumalda Crispa        	K	tawuła                        	odm.'Crispa'                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
640	01-01-1970	\N	SPI.BU.FR	640703	tawuła drobna                 	Spiraea bumalda Froebelli     	K	tawuła                        	odm.'Froebelii'               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
641	01-01-1970	\N	SPI.BU.PR	640702	tawuła drobna                 	Spiraea bumalda Pruhoniciana  	K	tawuła                        	odm.'Pruhoniciana'            	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
642	01-01-1970	\N	SPI.CH.UL	640501	tawuła ożankolistna           	Spiraea chamaedryfolia ulmifol	K	tawuła                        	odm.wiązolistna               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
643	01-01-1970	\N	STE.P	670200	stefanandra pogięta           	Stephanandra incisa           	K	stefanandra                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
644	01-01-1970	\N	STE.T	670100	stefanandra tanaki            	Stephanandra tanakae          	K	stefanandra                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
645	01-01-1970	\N	STR.Z	900100	strączyn żołty                	Cladrastis lutea              	D	strączyn                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
646	01-01-1970	\N	SUM.O	1040100	sumak octowiec                	Rhus typhina                  	K	sumak                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
647	01-01-1970	\N	SYR.AM.JA	1280801	lilak amurski                 	Syringa amurensis japonica    	K	lilak                         	odm.japońska                  	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
648	01-01-1970	\N	SZD.B	960500	szczodrzeniec biały           	Cytisus albus                 	K	szczodrzeni                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
649	01-01-1970	\N	SZD.C	960200	szczodrzeniec czerniejący     	Cytisus nigricans             	K	szczodrzeni                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
650	01-01-1970	\N	SZD.G	960400	szczodrzeniec główkowaty      	Cytisus supinus               	K	szczodrzeni                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
651	01-01-1970	\N	SZD.J	120100	szydlica japońska             	Cryptomeria japonica          	D	szydlica                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
652	01-01-1970	\N	SZD.P	960600	szczodrzeniec purpurowy       	Cytisus purpureus             	K	szczodrzeni                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
653	01-01-1970	\N	SZD.R	960300	szczodrzeniec rozesłany       	Cytisus ratisbonesis          	K	szczodrzeni                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
654	01-01-1970	\N	SZF.S	1210100	szeferdia srebrzysta          	Shepherdia argentea           	K	szeferdia                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
655	01-01-1970	\N	SZK	1110100	szakłak pospolity             	Rhamnus cathartica            	K	szakłak                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
656	01-01-1970	\N	SZK.W	1110200	szakłak wielkolistny          	Rhamnus imeretina             	K	szakłak                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
657	01-01-1970	\N	SŁN.S	950100	słonisz srebrzysty            	Halimodendron holodendron     	K	słonisz                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
658	01-01-1970	\N	TAM.C	1170400	tamaryszek czteropręcikowy    	Tamarix tetrandra             	K	tamaryszek                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
659	01-01-1970	\N	TAM.D	1170300	tamaryszek drobnokwiatowy     	Tamarix parviflora            	K	tamaryszek                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
660	01-01-1970	\N	TAM.F	1170700	tamaryszek francuski          	Tamarix gallica               	K	tamaryszek                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
661	01-01-1970	\N	TAM.O	1170600	tamaryszek odeski             	Tamarix odessana              	K	tamaryszek                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
662	01-01-1970	\N	TAM.P	1170500	tamaryszek pieciopręcikowy    	Tamarix pentandra             	K	tamaryszek                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
663	01-01-1970	\N	TAW.B	640800	tawuła białokwiatowa          	Spiraea albiflora             	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
664	01-01-1970	\N	TAW.BI	641100	tawuła Billarda               	Spiraea billardii             	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
665	01-01-1970	\N	TAW.CI.G	641300	tawuła                        	Spiraea cinerea               	K	tawuła                        	odm. Grefsheim                	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
666	01-01-1970	\N	TAW.D	640700	tawuła drobna                 	Spiraea bumalda               	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
667	01-01-1970	\N	TAW.DE	641400	tawuła                        	Spiraea densiflora            	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
668	01-01-1970	\N	TAW.DG	641000	tawuła Douglasa               	Spiraea douglasii             	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
669	01-01-1970	\N	TAW.H	640400	tawuła van Houtte'a           	Spiraea vanhouttei            	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
670	01-01-1970	\N	TAW.J	640600	tawuła japońska               	Spiraea japonica              	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
671	01-01-1970	\N	TAW.J.G	640601	tawuła japońska               	Spiraea japonica              	K	tawuła                        	oodm. Golden Princess         	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
672	01-01-1970	\N	TAW.J.L	640602	tawuła japońska               	Spiraea japonica              	K	tawuła                        	odm. Little Princess          	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
673	01-01-1970	\N	TAW.M	640900	tawuła Menziesa               	Spiraea menziesii             	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
674	01-01-1970	\N	TAW.O	640500	tawuła ożankolistna           	Spiraea chamaedryfolia        	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
675	01-01-1970	\N	TAW.T	640200	tawuła Thunberga              	Spiraea thunbergii            	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
676	01-01-1970	\N	TAW.W	640300	tawuła wczesna                	Spiraea arguta                	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
677	01-01-1970	\N	TAW.WB	641200	tawuła wierzbolistna          	Spiraea salicifolia           	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
678	01-01-1970	\N	TAW.Ś	640100	tawuła śliwolistna            	Spiraea prunifolia            	K	tawuła                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
679	01-01-1970	\N	OSN.JAN	2008300	ostnica Jana                  	Stipa joannis Celak.          	K	ostnica                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
680	01-01-1970	\N	TIL.AM.AM	400602	lipa amerykańska              	Tilia americana Ampelophylla  	D	lipa                          	odm.'Ampelophylla'            	\N	OS 	BK 	L	BRZ      	OS       	OL       	\N	1	0	0	0	OS	BRZ      	\N
681	01-01-1970	\N	TIL.AM.FA	400603	lipa amerykańska              	Tilia americana Fastigiata    	D	lipa                          	odm.'Fastigiata'              	\N	OS 	BK 	L	BRZ      	OS       	OL       	\N	1	0	0	0	OS	BRZ      	\N
682	01-01-1970	\N	TIL.AM.MA	400601	lipa amerykańska              	Tilia americana Macrophylla   	D	lipa                          	odm.'Macrophylla'             	\N	OS 	BK 	L	BRZ      	OS       	OL       	\N	1	0	0	0	OS	BRZ      	\N
683	01-01-1970	\N	TIL.PL.LA	400204	lipa szerokolistna            	Tilia platyphyllos Laciniata  	D	lipa                          	odm.'Laciniata'               	\N	OS 	BK 	L	BRZ      	OS       	OL       	\N	1	0	0	0	OS	BRZ      	\N
684	01-01-1970	\N	TIL.PL.PA	400201	lipa szerokolistna            	Tilia platyphyllos Pyram.Aurea	D	lipa                          	odm.'Pyramidalis Aurea'       	\N	OS 	BK 	L	BRZ      	OS       	OL       	\N	1	0	0	0	OS	BRZ      	\N
685	01-01-1970	\N	TIL.PL.RU	400202	lipa szerokolistna            	Tilia platyphyllos Rubra      	D	lipa                          	odm.'Rubra'                   	\N	OS 	BK 	L	BRZ      	OS       	OL       	\N	1	0	0	0	OS	BRZ      	\N
686	01-01-1970	\N	TIL.PL.VI	400203	lipa szerokolistna            	Tilia platyphyllos Vitifolia  	D	lipa                          	odm.'Vitifolia'               	\N	OS 	BK 	L	BRZ      	OS       	OL       	\N	1	0	0	0	OS	BRZ      	\N
687	01-01-1970	\N	TOR.K	220100	torreja kalifornijska         	Torreya californica           	D	torreja                       	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
688	01-01-1970	\N	TOR.O	220200	torreja orzechowa             	Torreya nucifera              	D	torreja                       	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
689	01-01-1970	\N	TP	380100	topola biała                  	Populus alba                  	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
690	01-01-1970	\N	TP.B	381000	topola berlińska              	Populus berolinensis          	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
691	01-01-1970	\N	TP.C	380400	topola czarna                 	Populus nigra                 	D	topola                        	\N	\N	OS 	OS 	L	BRZ      	OS       	OL       	\N	1	0	0	0	TP	BRZ      	\N
692	01-01-1970	\N	TP.CH	380600	topola chińska                	Populus simonii               	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
693	01-01-1970	\N	TP.K	380500	topola kanadyjska             	Populus canadensis            	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
694	01-01-1970	\N	TP.KO	380900	topola koreańska              	Populus koreana               	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
695	01-01-1970	\N	TP.M	380800	topola Maksymowicza           	Populus maximowiczii          	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
696	01-01-1970	\N	TP.NO	381200	topola nieokreślona           	Populus species               	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
697	01-01-1970	\N	TP.P	381100	topola petrowska              	Populus petrowskyana          	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
698	01-01-1970	\N	TP.S	380300	topola szara                  	Populus canescens             	D	topola                        	\N	\N	OS 	OS 	L	\N	\N	OL       	\N	1	0	0	0	TP	BRZ      	\N
699	01-01-1970	\N	TRZ	1070100	trzmielina pospolita          	Euonymus europaea             	K	trzmielina                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
700	01-01-1970	\N	TRZ.B	1070200	trzmielina brodawkowata       	Euonymus verrucosa            	K	trzmielina                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
701	01-01-1970	\N	TRZ.F	1070400	trzmielina Fortune'a          	Euonymus fortunei             	K	trzmielina                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
702	01-01-1970	\N	TRZ.N	1070500	trzmielina niska              	Euonymus nana                 	K	trzmielina                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
703	01-01-1970	\N	TRZ.S	1070300	trzmielina szerokolistna      	Euonymus latifolia            	K	trzmielina                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
704	01-01-1970	\N	TS.C	230300	choina chińska                	Tsuga chinensis               	D	choina                        	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
705	01-01-1970	\N	TS.K	230100	choina kanadyjska             	Tsuga canadensis              	D	choina                        	\N	\N	JD 	JD 	I	JD       	JD       	JD       	\N	1	0	0	0	OS	BRZ      	\N
706	01-01-1970	\N	TS.K.N	230101	choina kanadyjska             	Tsuga canadensis              	D	choina                        	odm. Nana                     	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
707	01-01-1970	\N	TS.KA	230200	choina karolińska             	Tsuga caroliniana             	D	choina                        	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
708	01-01-1970	\N	TS.R	230400	choina różnolistna            	Tsuga diversifolia            	D	choina                        	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
709	01-01-1970	\N	TS.S	230600	choina Siebolda               	Tsuga sieboldii               	D	choina                        	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
710	01-01-1970	\N	TS.Z	230500	choina zachodnia              	Tsuga heterophylla            	D	choina                        	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
711	01-01-1970	\N	TUL.A	540100	tulipanowiec amerykański      	Liriodendron tulipifera       	D	tulipanowiec                  	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
712	01-01-1970	\N	TWŁ.K	650100	tawułowiec kalinolistny       	Physocarpus opulifolius       	K	tawułowiec                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
713	01-01-1970	\N	ULM.CA.DA	330403	wiąz polny                    	Ulmus carpinifolia Dampieri   	D	wiąz                          	odm.'Dampieri'                	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
714	01-01-1970	\N	ULM.CA.SU	330401	wiąz polny                    	Ulmus carpinifolia suberosa   	D	wiąz                          	odm.korkowa                   	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
715	01-01-1970	\N	ULM.CA.UM	330402	wiąz polny                    	Ulmus carpinifolia Umbraculif.	D	wiąz                          	odm.'Umbraculifera'           	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
716	01-01-1970	\N	ULM.CA.VR	330404	wiąz polny                    	Ulmus carpinifolia Wredei     	D	wiąz                          	odm.'Wrede'a'                 	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
717	01-01-1970	\N	ULM.GL.CA	330301	wiąz górski                   	Ulmus glabra Camperdownii     	D	wiąz                          	odm.'Camperdownii'            	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
718	01-01-1970	\N	ULM.GL.EX	330303	wiąz górski                   	Ulmus glabra Exoniensis       	D	wiąz                          	odm.'Exoniensis'              	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
719	01-01-1970	\N	ULM.GL.PE	330302	wiąz górski                   	Ulmus glabra Pendula          	D	wiąz                          	odm.'Pendula'                 	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
720	01-01-1970	\N	ULM.PU.AR	330501	wiąz syberyjski               	Ulmus pumila arborea          	D	wiąz                          	odm.turkiestanska             	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
721	01-01-1970	\N	VIB.OP.RO	1360101	kalina koralowa               	Viburnum opulus Roseum        	K	kalina                        	odm.płonna                    	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
722	01-01-1970	\N	WAJ.C	1380100	wajgela cudowna               	Weigela florida               	K	wajgela                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
723	01-01-1970	\N	WB	390100	wierzba biała                 	Salix alba                    	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
724	01-01-1970	\N	WB.K	390200	wierzba krucha                	Salix fragilis                	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
725	01-01-1970	\N	WB.L	390400	wierzba laurowa               	Salix pentandra               	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
726	01-01-1970	\N	WB.M	390300	wierzba mandżurska            	Salix matsudana               	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
727	01-01-1970	\N	WB.NO	391100	wierzba nieokreślona          	Salix species                 	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
728	01-01-1970	\N	WB.O	390700	wierzba ostrolistna           	Salix acutifolia              	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
729	01-01-1970	\N	WB.P	392200	wierzba pięciopręcikowa       	Salix pentandra               	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
730	01-01-1970	\N	WB.PZ	392300	wierzba płożąca               	Salix repens                  	K	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
731	01-01-1970	\N	WB.RO	392400	wierzba rokita                	Salix rosmarinifolia          	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
732	01-01-1970	\N	WB.S	391000	wierzba siwa                  	Salix elaeagnos               	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
733	01-01-1970	\N	WB.SL	392500	wierzba śląska                	Salix silesiaca               	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
734	01-01-1970	\N	WB.SZ.H	392700	wierzba szczepiona            	Salix integra                 	D	wierzba                       	odm. Hacuro Nishiki           	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
735	01-01-1970	\N	WB.TR	392600	wierzba trójpręcikowa         	Salix triandra                	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
736	01-01-1970	\N	WB.W	390600	wierzba wawrzynkowa           	Salix daphnoides              	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
737	01-01-1970	\N	WB.WI	390900	wierzba wiciowa               	Salix viminalis               	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
738	01-01-1970	\N	WB.Z	392000	wierzba zielna                	Salix herbacea                	D	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	OS       	\N	1	0	0	0	OS	BRZ      	\N
739	01-01-1970	\N	WCK.H	1400400	wiciokrzew Heckrotta          	Lonicera hecrottii            	K	wiciokrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
740	01-01-1970	\N	WCK.P	1400100	wiciokrzew pomorski           	Lonicera periclymenum         	K	wiciokrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
741	01-01-1970	\N	WCK.PR	1400200	wiciokrzew przewiercien       	Lonicera caprifolium          	K	wiciokrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
742	01-01-1970	\N	WCK.T	1400300	wiciokrzew Tellmanna          	Lonicera tellmanniana         	K	wiciokrzew                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
743	01-01-1970	\N	WEI.FL.AL	1380102	wajgela cudowna               	Weigela florida Alba          	K	wajgela                       	odm.białokwiatowa             	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
744	01-01-1970	\N	WEI.FL.PU	1380103	wajgela cudowna               	Weigela florida Purpurea      	K	wajgela                       	odm.purpurowa                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
745	01-01-1970	\N	WEI.FL.VA	1380104	wajgela cudowna               	Weigela florida Variegata     	K	wajgela                       	odm.pstrolistna               	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
746	01-01-1970	\N	WEI.FL.VE	1380101	wajgela cudowna               	Weigela florida Venusta       	K	wajgela                       	odm.koreanska                 	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
747	01-01-1970	\N	WIK	390500	wiklina (wba purpurowa)       	Salix purpurea                	K	wierzba                       	\N	\N	OS 	OS 	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
748	01-01-1970	\N	WIK.N	390502	wierzba purpurowa             	Salix purpurea                	K	wierzba                       	odm. Nana                     	\N	OS 	OS 	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
749	01-01-1970	\N	WIN.P	1140100	winobluszcz pięciolistkowy    	Parthenocissus quinquefolia   	K	winobluszcz                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
752	01-01-1970	\N	WIS.G	851600	wisnia gruczołkowata          	Prunus glandulosa             	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
753	01-01-1970	\N	WIS.P	851500	wisnia piłkowana              	Prunus serrulata              	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
754	01-01-1970	\N	WIS.W	851700	wiśnia wonna                  	Prunus mahaleb                	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
755	01-01-1970	\N	WIŚ	851100	wiśnia pospolita              	Prunus cerasus                	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
756	01-01-1970	\N	WIŚ.K	851200	wiśnia karłowa                	Prunus fruticosa              	K	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
757	01-01-1970	\N	WSN.P	1180100	września pobrzeżna            	Myricaria germanica           	K	września                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
758	01-01-1970	\N	WZ	330100	wiąz pospolity                	Ulmus                         	D	wiąz                          	\N	\N	DB 	DB 	L	\N	\N	BK       	\N	3	15000	6000	0	DB	DB       	\N
759	01-01-1970	\N	WZ.NO	330600	wiąz nieokreslony             	Ulmus species                 	D	wiąz                          	\N	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
760	01-01-1970	\N	WZ.P	330400	wiąz polny                    	Ulmus carpinifolia            	D	wiąz                          	\N	\N	DB 	DB 	L	GB       	GB       	BK       	\N	3	0	0	0	DB	DB       	\N
761	01-01-1970	\N	WZ.S	330200	wiąz szypułkowy               	Ulmus laevis                  	D	wiąz                          	\N	\N	DB 	DB 	L	GB       	GB       	BK       	\N	3	15000	6000	0	DB	DB       	\N
762	01-01-1970	\N	WZ.SY	330500	wiąz syberyjski               	Ulmus pumila                  	D	wiąz                          	\N	\N	DB 	DB 	L	\N	\N	BK       	\N	3	0	0	0	DB	DB       	\N
763	01-01-1970	\N	WZW.P	420200	wiazowiec południowy          	Celtis australis              	D	wiazowiec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	DB	BRZ      	\N
764	01-01-1970	\N	WZW.Z	420100	wiazowiec zachodni            	Celtis occidentalis           	D	wiazowiec                     	\N	\N	DB 	DB 	L	\N	\N	\N	\N	1	0	0	0	DB	DB       	\N
765	01-01-1970	\N	WŚL.A	1130200	winorośl amurska              	Vitis amurensis               	K	winorośl                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
766	01-01-1970	\N	WŚL.J	1130300	winorośl japońska             	Vitis coignetiae              	K	winorośl                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
767	01-01-1970	\N	WŚL.P	1130100	winorośl pachnąca             	Vitis riparia                 	K	winorośl                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
768	01-01-1970	\N	ZŁK	980100	złotokap pospolity            	Laburnum anagyroides          	K	złotokap                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
769	01-01-1970	\N	ZŁK.A	980200	złotokap  alpejski            	Laburnum alpinum              	K	złotokap                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
770	01-01-1970	\N	ZŁK.W	980300	złotokap  Waterera            	Laburnum watereri             	K	złotokap                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
771	01-01-1970	\N	ZŁT.J	800100	złotlin japoński              	Kerria japonica               	K	złotlin                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
772	01-01-1970	\N	ŚL	850300	śliwa domowa                  	Prunus domestica              	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
773	01-01-1970	\N	ŚL.A	850400	śliwa ałycza                  	\N	D	śliwa                         	\N	\N	BRZ	BRZ	L	BRZ      	BRZ      	OS       	\N	3	0	0	0	OS	BRZ      	\N
774	01-01-1970	\N	ŚL.L	850500	śliwa lubaszka                	Prunus insititia              	D	śliwa                         	\N	\N	BRZ	BRZ	L	\N	\N	OS       	\N	3	0	0	0	OS	BRZ      	\N
775	01-01-1970	\N	ŚL.T	850100	śliwa tarnina                 	Prunus spinosa                	K	śliwa                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
776	01-01-1970	\N	ŚL.W	850200	śliwa wiśniowa                	Prunus cerasifera             	K	śliwa                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
777	01-01-1970	\N	ŚNG.B	1370100	śnieguliczka biała            	Symphoricarpos albus          	K	śnieguliczka                  	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
778	01-01-1970	\N	ŚNG.C	1370300	śnieguliczka Chenaulta        	Symphoricarpos chenaultii     	K	śnieguliczka                  	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
779	01-01-1970	\N	ŚNG.K	1370200	śnieguliczka koralowa         	Symphoricarpos orbiculatus    	K	śnieguliczka                  	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
780	01-01-1970	\N	ŚW	30100	świerk pospolity              	Picea abies                   	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	75	15	0	ŚW	ŚW       	\N
781	01-01-1970	\N	ŚW.A	30900	świerk ajański                	Picea jezoensis               	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
782	01-01-1970	\N	ŚW.B	30700	świerk biały                  	Picea glauca                  	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
783	01-01-1970	\N	ŚW.B.AG	30701	świerk biały                  	Picea glauca                  	D	świerk                        	odm.Alberta Globe             	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
784	01-01-1970	\N	ŚW.B.C	30702	świerk biały                  	Picea glauca                  	D	świerk                        	odm.Conica                    	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
785	01-01-1970	\N	ŚW.BR	30500	świerk Brewera                	Picea breweriana              	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
786	01-01-1970	\N	ŚW.C	30200	świerk chiński                	Picea asperata                	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
787	01-01-1970	\N	ŚW.CZ	31200	świerk czarny                 	Picea mariana                 	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
788	01-01-1970	\N	ŚW.D	30300	świerk dwubarwny              	Picea bicolor                 	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
871	01-01-1970	\N	NAB.NAD	2004300	nabrzeżyca nadrzeczna         	Corrigiola litoralis L.       	K	nabrzeżyca                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
789	01-01-1970	\N	ŚW.E	30600	świerk Engelmanna             	Picea engelmannii             	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
790	01-01-1970	\N	ŚW.H	31800	świerk himalajski             	Picea smithiana               	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
791	01-01-1970	\N	ŚW.J	31000	świerk japoński               	Picea koyamai                 	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
792	01-01-1970	\N	ŚW.K	31500	świerk kaukaski               	Picea orientalis              	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
793	01-01-1970	\N	ŚW.KB	31900	świerk kłujący                	Picea pungens                 	D	świerk                        	odm.Białobok                  	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
794	01-01-1970	\N	ŚW.L	31100	świerk likiangeński           	Picea likiangensis            	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
795	01-01-1970	\N	ŚW.S	30400	świerk Sargenta               	Picea brachytyla              	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
796	01-01-1970	\N	ŚW.SA	30800	świerk sachalinski            	Picea glehnii                 	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
797	01-01-1970	\N	ŚW.SE	31400	świerk serbski                	Picea omorika                 	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
798	01-01-1970	\N	ŚW.SI	31700	świerk sitkajski              	Picea sitchensis              	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
799	01-01-1970	\N	ŚW.SR	31600	świerk srebrny                	Picea pungens                 	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
800	01-01-1970	\N	ŚW.SY	31300	świerk syberyjski             	Picea obovata                 	D	świerk                        	\N	\N	ŚW 	ŚW 	I	\N	\N	ŚW       	\N	2	0	0	0	ŚW	ŚW       	\N
801	01-01-1970	\N	ŚWŚ.J	780100	świdośliwa jajowata           	Amelanchier ovalis            	K	świdośliwa                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
802	01-01-1970	\N	ŚWŚ.K	780200	świdośliwa kanadyjska         	Amelanchier canadensis        	K	świdośliwa                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
803	01-01-1970	\N	ŻAR.M	960100	żarnowiec miotlasty           	Cytisus scoparius             	K	żarnowiec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
804	01-01-1970	\N	ŻWC.J	210100	żywotnikowiec japoński        	Thujopsis dolabrata           	D	żywotnikowiec                 	\N	\N	\N	\N	I	\N	\N	JD       	\N	1	0	0	0	OS	ŚW       	\N
805	01-01-1970	\N	ŻYL.L	560400	żylistek Lemoine'a            	Deutzia lemoinei              	K	żylistek                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
806	01-01-1970	\N	ŻYL.R	560200	żylistek różowy               	Deutzia rosea                 	K	żylistek                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
807	01-01-1970	\N	ŻYL.S	560300	żylistek szorstki             	Deutzia scabra                	K	żylistek                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
808	01-01-1970	\N	ŻYL.W	560100	żylistek wysmukły             	Deutzia gracilis              	K	żylistek                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
809	01-01-1970	\N	ŻYW.J	200500	żywotnik japoński             	Thuja standishii              	K	żywotnik                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
810	01-01-1970	\N	ŻYW.K	200100	żywotnik koreański            	Thuja koraiensis              	K	żywotnik                      	\N	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
811	01-01-1970	\N	ŻYW.O	200400	żywotnik olbrzymi             	Thuja plicata                 	K	żywotnik                      	\N	\N	JD 	JD 	I	JD       	JD       	JD       	\N	1	20000	12000	0	OS	JD       	\N
812	01-01-1970	\N	ŻYW.W	200300	żywotnik wschodni             	Thuja orintalis               	K	żywotnik                      	\N	\N	JD 	JD 	I	JD       	JD       	JD       	\N	1	0	0	0	OS	JD       	\N
813	01-01-1970	\N	ŻYW.W.AN	200301	żywotnik wschodni             	Thuja orientalis              	K	żywotnik                      	odm. Aurea Nana               	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
814	01-01-1970	\N	ŻYW.Z	200200	żywotnik zachodni             	Thuja occidentalis            	D	żywotnik                      	\N	\N	JD 	JD 	I	JD       	JD       	JD       	\N	1	20000	12000	0	OS	JD       	\N
815	01-01-1970	\N	ŻYW.Z.D	200201	żywotnik zachodni             	Thuja occidentalis            	K	żywotnik                      	odm. Danica                   	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
816	01-01-1970	\N	ŻYW.Z.RH	200202	żywotnik zachodni             	Thuja occidentalis            	K	żywotnik                      	odm. Rheingold                	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
817	01-01-1970	\N	ŻYW.Z.SM	200203	żywotnik zachodni             	Thuja occidentalis            	K	żywotnik                      	odm. Smaragd                  	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
818	01-01-1970	\N	ŻYW.Z.SU	200204	żywotnik zachodni             	Thuja occidentalis            	K	żywotnik                      	odm. Sunkist                  	\N	\N	\N	I	\N	\N	\N	\N	1	0	0	0	OS	ŚW       	\N
819	01-01-1970	01-01-2014	KŁK.K	870100	kłęk kanadyjski               	Gymnocladus dioicus           	D	kłęk                          	\N	\N	\N	\N	L	\N	\N	\N	\N	\N	\N	\N	\N	OS	BRZ      	\N
820	01-01-1970	01-01-2014	ŚW.S.A.	30800	świerk sachalinski            	Picea glehnii                 	D	świerk                        	\N	\N	ŚW 	ŚW 	I	ŚW       	ŚW       	\N	\N	\N	\N	\N	\N	ŚW	ŚW       	\N
821	01-01-1970	01-01-2014	BEZ_GAT	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
822	01-01-1970	01-01-2014	ŻYW.SPE	\N	żywotnik - rodzaj             	\N	K	\N	\N	\N	\N	\N	l	\N	\N	\N	\N	\N	\N	\N	\N	OS	ŚW       	\N
823	01-01-1970	01-01-2014	RDE.JAP	\N	rdestownik japoński           	\N	K	\N	\N	\N	\N	\N	L	\N	\N	\N	\N	\N	\N	\N	\N	OS	ŚW       	\N
824	01-01-1970	01-01-2014	JAŚ.SPE	\N	jaśminowiec - rodzaj          	\N	K	\N	\N	\N	\N	\N	L	\N	\N	\N	\N	\N	\N	\N	\N	OS	ŚW       	\N
825	01-01-1970	01-01-2014	WB SZ	390105	wierzba szara                 	Salix cinrea                  	D	wierzba                       	\N	\N	OS 	OS 	L	BRZ      	OS       	OS       	\N	\N	\N	\N	\N	BRZ	\N	\N
826	01-01-1970	\N	BEZ.L	\N	                              	                              	 	                              	                              	                              	   	   	 	         	         	         	   	 	\N	\N	\N	BRZ	         	\N
869	01-01-1970	\N	MIE.BŁO	2001000	mieczyk błotny                	Gladiolus paluster            	K	mieczyk                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
827	01-01-1970	\N	CZM.A	\N	                              	                              	 	                              	                              	                              	   	   	 	         	         	         	   	 	\N	\N	\N	BRZ	         	\N
828	01-01-1970	\N	SO.P	\N	                              	                              	 	                              	                              	                              	   	   	 	         	         	         	   	 	\N	\N	\N	SO	         	\N
829	01-01-1970	\N	TAWL.JRZ	\N	                              	                              	 	                              	                              	                              	   	   	 	         	         	         	   	 	\N	\N	\N	BRZ	         	\N
830	01-01-1970	\N	WB.KAS	\N	                              	                              	 	                              	                              	                              	   	   	 	         	         	         	   	 	\N	\N	\N	BRZ	         	\N
831	01-01-1970	\N	DB.KR	311300	dąb korkowy                   	Quercus suber                 	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	\N	T
832	01-01-1970	\N	DB.OS	311400	dąb ostrolistny               	Quercus ilex                  	D	dąb                           	\N	\N	DB 	DB 	L	\N	\N	DB       	\N	3	0	0	0	DB	\N	T
833	01-01-1970	\N	JS.WS	340500	jesion wąskolistny            	Fraxinus angustifolia         	D	jesion                        	odm. wąskolistna              	\N	DB 	JS 	L	\N	\N	DB       	\N	3	30000	8000	40000	DB	\N	T
834	01-01-1970	\N	PIN.CAN	11400	sosna kanaryjska              	Pinus canariensis             	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	\N	T
835	01-01-1970	\N	PIN.HAL	11500	sosna alepska                 	Pinus halepensis              	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	\N	T
836	01-01-1970	\N	PIN.HAL.K	11501	sosna alepska odm. kalabryjska	Pinus halepensis var. brutia  	D	sosna                         	odm. kalabryjska              	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	\N	T
837	01-01-1970	\N	PIN.LEU	11600	sosna bośniacka               	Pinus leucodermis             	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	\N	T
838	01-01-1970	\N	PIN.RAD	11700	sosna kalifornijska           	Pinus radiata                 	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	\N	T
839	01-01-1970	\N	PIN.PIN	11800	sosna nadmorska               	Pinus pinaster                	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	\N	T
840	01-01-1970	\N	PIN.PI	11900	sosna pinia                   	Pinus pinea                   	D	sosna                         	\N	\N	SO 	SO 	I	\N	\N	SO       	\N	1	0	0	0	SO	\N	T
841	01-01-1970	\N	BAB.PIE	2006700	babka pierzasta               	Plantago coronopus L.         	K	babka                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
842	01-01-1970	\N	BDR.SKA	2006400	biedrzeniec mniejszy skalny   	Pimpinella saxifraga ssp. Rup.	K	biedrzeniec                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
843	01-01-1970	\N	BEZ.OKR	2003600	bezlist okrywowy              	Buxbaumia viridis             	K	bezlist                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
844	01-01-1970	\N	CZS.SIT	2003000	czosnek siatkowaty            	Allium victorialis            	K	czosnek                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
845	01-01-1970	\N	CZS.SYB	2002900	czosnek syberyjski            	Allium sibiricum              	K	czosnek                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
846	01-01-1970	\N	DSŁ.POP	2000100	dziewięćsił popłocholistny    	Carlina onopordifolia         	K	dziewięćsił                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
847	01-01-1970	\N	DZW.BRO	2008800	dzwonek brodaty               	Campanula barbata L.          	K	dzwonek                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
848	01-01-1970	\N	DZW.KRK	2000300	dzwonek karkonoski            	Campanula bohemica            	K	dzwonek                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
849	01-01-1970	\N	DZW.PIŁ	2000400	dzwonek piłkowany             	Campanula serrata             	K	dzwonek                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
850	01-01-1970	\N	DZW.WON	2000200	dzwonecznik wonny             	Adenophora lilifolia          	K	dzwonecznik                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
851	01-01-1970	\N	GNI.HAC	2006300	gnidosz Hacqueta              	Pedicularis hacquetii Graf    	K	gnidosz                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
852	01-01-1970	\N	GNI.SUD	2000500	gnidosz sudecki               	Pedicularis sudetica          	K	gnidosz                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
853	01-01-1970	\N	GOR.CZS	2005300	goryczuszka czeska            	Gentianella bohemica Skalicky 	K	goryczuszka                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
854	01-01-1970	\N	GOR.POL	2005400	goryczuszka polna             	Gentianella campestris        	K	goryczuszka                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
855	01-01-1970	\N	GŹK.LŚN	2000600	goździk lśniący               	Dianthus nitidus              	K	goździk                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
856	01-01-1970	\N	GĘS.ALP	2003200	gęsiówka alpejska             	Arabis alpina                 	K	gęsiówka                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
857	01-01-1970	\N	IRG.KUT	2004400	irga kutnerowata              	Cotoneaster tomentosus (A.) L.	K	irga                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
858	01-01-1970	\N	JSK.POL	2007200	jaskier polny                 	Ranunculus arvensis L.        	K	jaskier                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
859	01-01-1970	\N	JSK.SKA	2007400	jaskier skalny                	Ranunculus oreophilus M. Bieb.	K	jaskier                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
860	01-01-1970	\N	JSK.WKW	2007300	jaskier wielki                	Ranunculus lingua L.          	K	jaskier                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
861	01-01-1970	\N	JĘZ.SYB	2000700	języczka syberyjska           	Liguralia sibirica            	K	języczka                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
862	01-01-1970	\N	KAL.DSK	2003700	kaldezja dziewięciornikowata  	Caldesia parnassifolia        	K	kaldezja                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
863	01-01-1970	\N	KIK.ZOS	2005600	kiksja zgiętoostrogowa        	Kickxia spuria (L.) Dumort.   	K	kiksja                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
864	01-01-1970	\N	LEN.BEZ	2000800	leniec bezpodkwiatkowy        	Thesium ebracteatum           	K	leniec                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
870	01-01-1970	\N	MOC.WŁO	2004500	żaglik (moczara) włoskowaty   	Dichelyma capillaceum         	K	moczara                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
872	01-01-1970	\N	OKR.JEL	2005700	okrzyn jeleni                 	Laserpitium archangelica Wolf.	K	okrzyn                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
873	01-01-1970	\N	OSN.PIA	2008200	ostnica piaskowa              	Stipa borysthenica Klokov     	K	ostnica                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
874	01-01-1970	\N	PAR.DŁU	2005900	parzęchlin długoszczecinowy   	Meesia longiseta              	K	parzęchlin                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
875	01-01-1970	\N	PJŹ.POJ	2003500	podejźrzon pojedynczy         	Botrychium simplex            	K	podejźrzon                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
876	01-01-1970	\N	PMT.ALP	2005000	przymiotno alpejskie          	Erigeron alpinus L.           	K	przymiotno                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
877	01-01-1970	\N	PON.KRA	2001100	ponikło kraińskie             	Eleocharis carniolica         	K	ponikło                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
878	01-01-1970	\N	PON.WIE	2004800	ponikło wielołodygowe         	Eleocharis multicaulis Sm.    	K	ponikło                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
879	01-01-1970	\N	PRZ.ALP	2008500	przetacznik alpejski          	Veronica alpina               	K	przetacznik                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
880	01-01-1970	\N	PRZ.SIT	2004900	perz sitowy                   	Elymus farctus (Viv.)R. ex M. 	K	perz                          	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
881	01-01-1970	\N	PRZ.WCZ	2008600	przetacznik wczesny           	Veronica praecox All.         	K	przetacznik                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
882	01-01-1970	\N	PRŁ.ORZ	2006000	perłówka orzęsiona            	Melica ciliata L.             	K	perłówka                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
883	01-01-1970	\N	PSZ.PIE	2001400	pszonak pieniński             	Erysimum pieninicum           	K	pszonak                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
884	01-01-1970	\N	PTU.MAŁ	2001200	przytulia krakowska           	Galium cracoviense            	K	przytulia                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
885	01-01-1970	\N	PTU.STP	2005200	przytulia stepowa             	Galium valdepilosum Heinr. Br.	K	przytulia                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
886	01-01-1970	\N	PTU.SUD	2001300	przytulia sudecka             	Galium sudeticum              	K	przytulia                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
887	01-01-1970	\N	PŁA.ORZ	2006600	płaskomerzyk orzęsiony        	Plagiomnium drummondii        	K	płaskomerzyk                  	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
888	01-01-1970	\N	PĘC.BŁO	2001900	selery (pęczyna) błotne       	Apium repens                  	K	selery                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
889	01-01-1970	\N	RDS.PDŁ	2006800	rdestnica podługowata         	Potamogeton polygonifolius P. 	K	rdestnica                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
890	01-01-1970	\N	ROG.ALP	2004200	rogownica alpejska            	Cerastium alpinum L.s.s.      	K	rogownica                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
891	01-01-1970	\N	RZE.SZC	2001600	rzepik szczeciniasty          	Agrimonia pilosa              	K	rzepik                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
892	01-01-1970	\N	RZŻ.GOR	2003800	rzeżucha gorzka Opiza         	Cardamine amara L.subsp.opizii	K	rzeżucha                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
893	01-01-1970	\N	RZŻ.REZ	2003900	rzeżucha rezedolistna         	Cardamine resedifolia L.      	K	rzeżucha                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
894	01-01-1970	\N	RŻE.GÓR	2007500	różeniec górski               	Rhodiola rosea                	K	różeniec                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
895	01-01-1970	\N	RŻN.ŻÓŁ	2001500	różanecznik żółty             	Rhododendron luteum           	K	różanecznik                   	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
896	01-01-1970	\N	SAS.OTW	2001700	sasanka otwarta               	Pulsatilla patens             	K	sasanka                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
897	01-01-1970	\N	SAS.SŁO	2001800	sasanka słowacka              	Pulsatilla slavica            	K	sasanka                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
898	01-01-1970	\N	SAS.WIO	2007100	sasanka wiosenna              	Pulsatilla vernalis (L.) Mill.	K	sasanka                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
899	01-01-1970	\N	SAS.ŁĄK	2007000	sasanka łąkowa                	Pulsatilla pratensis (L.)     	K	sasanka                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
900	01-01-1970	\N	SAU.WIE	2007800	saussurea wielkogłowa         	Saussurea pygmaea (Jacq.) Spr.	K	saussurea                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
901	01-01-1970	\N	SEL.WĘZ	2003100	selery węzłobaldachowe        	Apium nodiflorum (L.) Lag.    	K	selery                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
902	01-01-1970	\N	SIE.BŁY	2004700	sierpowiec błyszczący         	Drepanocladus vernicosus      	K	sierpowiec                    	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
903	01-01-1970	\N	SKA.BAZ	2008000	skalnica darniowa bazaltowa   	Saxifraga moschata ssp. basal.	K	skalnica                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
904	01-01-1970	\N	SKA.MCH	2007900	skalnica mchowata             	Saxifraga bryoides            	K	skalnica                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
905	01-01-1970	\N	SKA.NAP	2008100	skalnica naprzeciwlistna      	Saxifraga oppositifolia       	K	skalnica                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
906	01-01-1970	\N	SKA.TRF	2002100	skalnica torfowiskowa         	Saxifraga hirculus            	K	skalnica                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
907	01-01-1970	\N	SKA.ZWO	2008700	skalnica zwodnicza            	Saxifraga sponhemica          	K	skalnica                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
908	01-01-1970	\N	SKA.ŚNŻ	2002200	skalnica śnieżna              	Saxifraga nivalis             	K	skalnica                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
909	01-01-1970	\N	SO.DRZ	2006500	sosna drzewokosa              	Pinus x rhaetica Brügger      	K	sosna                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	SO	\N	N
910	01-01-1970	\N	SRP.RÓŻ	2002000	sierpik różnolistny           	Serratula lycopifolia         	K	serpik                        	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
911	01-01-1970	\N	STB.ŁĄK	2002300	starodub łąkowy               	Angelica palustris            	K	starodub                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
912	01-01-1970	\N	SZF.MIĘ	2006100	szafirek miękkolistny         	Muscari comosum (L.) Mill.    	K	szafirek                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
913	01-01-1970	\N	SZT.DRO	2005500	szarota drobna                	Gnaphalium supinum            	K	szarota                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
929	2019-08-07	\N	CHI	\N	Choinka zwyczajna	Choinkus vulgaris	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1	01-01-1970	\N	AKT.O	1160100	aktinidia ostrolistna         	Actinidia arguta              	K	aktinidia                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
2	01-01-1970	\N	ABI.FA	43400	jodła sp.                     	Abies fargessi                	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	ŚW       	\N
3	01-01-1970	\N	ABI.PI	43500	jodła sp.                     	Abies pindrow                 	D	jodła                         	\N	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	ŚW       	\N
4	01-01-1970	\N	ABI.SA.MA	42901	jodła sachalińska             	Abies sachalinensis mayriana  	D	jodła                         	odm.Mayra                     	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
5	01-01-1970	\N	ABI.SA.NE	42902	jodła sachalińska             	Abies sachalinensis nemorensis	D	jodła                         	odm.leśna                     	\N	JD 	JD 	I	\N	\N	JD       	\N	2	0	0	0	JD	JD       	\N
6	01-01-1970	\N	ACE.NE.AV	320904	klon jesionolistny            	Acer negundo Aureovariegatum  	D	klon                          	odm.'Aureovariegatum'         	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
7	01-01-1970	\N	ACE.NE.OD	320901	klon jesionolistny            	Acer negundo Odessanum        	D	klon                          	odm.'Odessanum'               	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
8	01-01-1970	\N	ACE.NE.VA	320903	klon jesionolistny            	Acer negundo Variegatum       	D	klon                          	odm.'Variegatum'              	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
9	01-01-1970	\N	ACE.PA.AT	321001	klon palmowy                  	Acer palmatum atropurpureum   	D	klon                          	odm.'Atropurpureum'           	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
10	01-01-1970	\N	ACE.PL.CK	320107	klon pospolity                	Acer platanoides              	D	klon                          	odm. Crimson King             	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	BRZ      	\N
11	01-01-1970	\N	BER.C	510600	berberys Chopina              	Berberis chopinii             	K	berberys                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	OS	BRZ      	\N
12	01-01-1970	\N	ACE.PL.DR	320104	klon pospolity                	Acer platanoides Drummondii   	D	klon                          	odm.Drummonda                 	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
13	01-01-1970	\N	ACE.PL.FB	320103	klon pospolity                	Acer platanoides Faassen's Bl.	D	klon                          	odm.'Faassens Black'          	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
14	01-01-1970	\N	ACE.PL.GL	320105	klon pospolity                	Acer platanoides Globosum     	D	klon                          	odm.'Globosum'                	\N	DB 	BK 	L	DB       	DB       	BK       	\N	3	0	0	0	DB	DB       	\N
914	01-01-1970	\N	SZU.ROG	2006200	szurpek Rogera                	Orthotrichum rogeri           	K	szurpek                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
915	01-01-1970	\N	TOC.KAR	2002400	tocja karpacka                	Tozzia carpatica              	K	tocja                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
916	01-01-1970	\N	TOJ.MOR	2002500	tojad morawski                	Aconitum firmum ssp.moravicum 	K	tojad                         	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
917	01-01-1970	\N	TRG.ZWI	2003400	traganek zwisłokwiatowy       	Astragalus penduliflorus Lam. 	K	traganek                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
918	01-01-1970	\N	TRZ.CRN	2004100	turzyca czarna                	Carex parviflora Host         	K	turzyca                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
919	01-01-1970	\N	TRZ.PAT	2004000	turzyca patagońska            	Carex magellanica Lam.        	K	turzyca                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
920	01-01-1970	\N	WB.LAP	2007700	wierzba lapońska              	Salix lapponum                	K	wierzba                       	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
921	01-01-1970	\N	WDZ.ZIE	2004600	widłoząb zielony              	Dicranum viride               	K	widłoząb                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
922	01-01-1970	\N	WRZ.POL	2002600	warzucha polska               	Cochlearia polonica           	K	warzucha                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
923	01-01-1970	\N	WRZ.TAT	2002700	warzucha tatrzańska           	Cochlearia tatrae             	K	warzucha                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
924	01-01-1970	\N	WŁO.CIE	2008400	włosocień cienisty            	Trichomanes speciosum         	K	włosocień                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
925	01-01-1970	\N	ZAN.SER	2003300	zanokcica serpentynowa        	Asplenium adulterinum         	K	zanokcica                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
926	01-01-1970	\N	ŚWT.MAL	2005100	świetlik maleńki              	Euphrasia minima              	K	świetlik                      	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
927	01-01-1970	\N	ŻMI.CZW	2002800	żmijowiec czerwony            	Echium russicum               	K	żmijowiec                     	\N	\N	\N	\N	L	\N	\N	\N	\N	1	0	0	0	BRZ	\N	N
928	\N	\N	CZM.AM	851900	czeremcha amerykanska         	Prunus serotina               	D	śliwa                         	\N	\N	BRZ	BRZ	L	BRZ      	BRZ      	OS       	PL 	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: oso; Type: TABLE DATA; Schema: public; Owner: kursant
--

COPY public.oso (id, geom, gid, nazwa, kod, kodinspire) FROM stdin;
1	01060000208408000001000000010300000001000000162D00000A5B839A076D2441642EDA13C26308410A5D7A9E1E6D24411CDD65A3C0630841366B6F823C6D2441FEDF324FD2630841BD7C451A576D24411CC09344D5630841067C88C1706D2441C6336DC0CD630841353B00938A6D2441220E345EAD63084113672171A46D2441EA26F7108963084105CDDCD4BD6D244134CC9E476E630841D1F4B728CF6D2441A4BEB2ED5C6308413A5C31FBE06D2441085942215A630841584DEFBCF56D244166E6AAA55F6308412E2E3DD30D6E244158FEB5AD706308413449C1AE2B6E2441C2A2293A876308418514D39F526E24413C616724916308415B40C83C7F6E24410076A58090630841E251D653A66E244186A4AD3A83630841CE9EE4DCEA6E24416885BF2F396308419B4922B5376F244106504372C26208417AF6E692826F2441E2FB7055646208414FA1A82E976F244100FE2FAB46620841105D3F4CB46F24412E07FF021962084118A84A93C26F2441667DD9D4F1610841F2EEAB8FCE6F2441CE6A9523BB610841F3EA9D84D26F244172B3A290876108415AD7B0E5D26F2441C6963F3151610841374E994DCF6F2441FEFB4BFCBF60084113C581B5CB6F244164FC645010600841456B98F0CB6F2441A022415CB45F08414D71C940CC6F2441E4A7FA874F5F084175DF683BD16F244192D5ED40FB5E084105A8BA91DB6F2441BC29D206925E0841E8B82B53EA6F2441B40DAAFC415E08411DC90BFDFF6F2441F0296E05FE5D0841E73DDD5D177024412E87FBCEC75D0841736A8F532A7024412073331D955D08413756ADDC377024419C0C73FA645D084181D0AE773D7024415EF9F3F3475D0841C3FFDC4A41702441C6396D5E285D084177510EBA4270244152F618F2065D08413A3F7BC9417024411258B567E05C08411AE49B163D702441B6887C77B55C0841C6677736337024417240195F845C08416AAF958B25702441C0F77346555C0841856CA65A0F7024418A396A061A5C08410FAA85540570244124B5D784FE5B0841AE8F9ECEFF6F24411E40F0B2D65B0841A9F13FE9FD6F2441AC669814AC5B08413003A682FF6F24411CBB0DDB8D5B08410CC376EC05702441A019A24F6F5B08413ABAC9BE14702441F4F226ED505B08417CEFA41E51702441FAA464D2E25A0841C48048CB657024413C3B9CAEBA5A08419544337E87702441D02E68FF735A084193141C11B07024417000C1EE065A084113564DD3CD7024410C6148639959084110F0716CE670244114096E4543590841C3C45DE2FD7024414E38ECA9025908413C3AA057407124417EB4FCD16A580841F8DA5A1765712441E86D160F1E58084139D8EA77937124417CBAA127AF570841EE293463D3712441AA831069F156084149B0079DF271244198BCA6D098560841825C87A7FF712441EC82711277560841ACB73A19177224417E18A24337560841382B168C2972244106F4ECE11256084157D323CB40722441E2E333DCEF550841FF390C8659722441EC797263DF55084171DD7AA27B7224415E2ECCF4CF5508411E63BDC4A1722441D849DFFDD85508416CC6C4CBBD722441BA34664CF355084130ECECD8E372244108D71A83275608419C3EBB9DFD72244192A07EC648560841657D008411732441F2B8CBCE57560841EE41E00E26732441581015EC62560841CB6F507331732441DCA9201F64560841AB16304537732441469666C36056084196AA4FCF3C732441BE89BC694D5608418040F65E4073244136C72DD335560841CCEC3DEA407324410E035D3C20560841059B0C7B3F732441FEF736E30856084195ACD6D43A73244126861CBDF2550841F9AF1B4931732441B210F3EACC55084129222D0F2C732441742F494AB45508416198E81F2973244162E359308F550841DFA5A46E28732441ACEB28886155084189BF261E227324414C6D640838550841C6524592157324413A9CE26CF7540841E28C43D80E732441E6E0A5D8CD540841F58ECADD0C732441DE01C238AF540841BC1A96D20D7324419654EE537B54084119CF31F31273244104D9EFD44B5408412F735D681B732441BA961F6926540841B5CDAB03277324413C46284E0954084111CDB62B3473244184A1B4C1F2530841FB641C4042732441669BDF14E9530841EA5EBFAE54732441FE690AAFE4530841A34C007D667324412A9D6315E553084170728C4A8673244110ED5A3002540841B1EEE8A99C732441FCC0DD21235408411A113003C6732441265EC45665540841121174C0F17324412C7F7862A954084107DD7A890B7424415EE229D9C9540841784A5D2B2A74244122ED4F32E1540841FA786AE54D7424417A4E76FDED540841567A6C117274244182185796F35408419B5C14D688742441E6F7758BF85408414344C093A0742441C612899401550841B5E9ED34CD742441BAB578201C5508416BF0571AEC7424415267D15B2C5508417FE1B11B077524418249B6512B55084166117D442375244164486DA6155508415B24AD8A3C75244186B428CAEE5408411E125219487524410CFB76E1D8540841AA3E3C8E67752441249B08C1965408417EAB0DA0897524417409CD52DC540841BC4F5C7AE2752441D0E903406E530841F970E072FC752441780F565D03530841265F95E815772441CCD099FC7C4E0841FD82B827EB772441AC5DD31C364C0841BBD40788B57A2441C49EC5759A440841D660918EAA7D24416ABF9785893C084180055F92A87F2441A4C7A4C11437084140B6620E7A8224410C7655614A340841DC035842DD85244162871449EE300841E6A2E296D38424411CE8CFB4C02A084122A96959EE83244158FB3C0973250841D78304B4BB832441584CE7F9AF200841EB064815498324414ECF1738491D084104182FF08A8224411407A61E1B1C0841F93376E3F3812441062B2241AD180841AAD3EB67408124417AD1F694761408410E0A38E8B4802441802FAD5D33110841A6B932F307802441A4EEAB39770B08418171B74E997F244184B30424920A08414EDA9E94587F244146EA438AF40908413B9AE783077F24411C7AA6B9C2090841A20360E1BF7E244126DC8882A308084137A95D8A6F7E244104FCCA3624080841816879221F7E244108A028BBC0040841EBB21BDC917D2441F401DB2CDC0208412BF5FDB8767D2441C231DD919702084121742E78587D2441405B8DF464020841ADE3ABE4237D2441F8FDD67EED0108411B1DA9140B7D244126ED16CEB20108419BDD36D7F77C2441AC1709317E0108419FBE6033B27C2441483D19E7F0000841F5A0F07B8A7C2441A6B6F40EAA000841AF88BC3C707C2441925076EC770008417DE03EFF3F7C2441562BB3342400084123567DBDF27B24410861419BD3FF07412FC6E77A217C24412C0E2B7C49FE0741E594AEDE577C24416609F0CB7DFC07415587D28C8A7C2441342F3F2AE0FA074133B3BBEB977C24411A71AB9471FA0741F4E1E4F1F97B2441266EE9E680F90741CA8402FDBE7B24412EAA454F22F90741A7F37E53787B2441EEAB0FA325F807412ADCB771F97A244150195E1825F60741C3E3DAF86E7A2441C0B1E79B05F4074125AF84720C7A244144EC390181F2074160574EF4F779244180BACCEF19F207410F92010C487A244124A180E205F00741D281D51D777A2441026F1ECFBFEE07411721B26BD57A24413657BAC33BED0741C08939A82A7B2441CA4D8BBDDEEB0741E7BC41BEAD7B244168F8DFFB52EE0741567B40F40C7C24418474E1D290EF07413AFE76375B7C244128E2A6F98FF007419B226950E07C24413207885F70F20741D9F35F4D4C7D244180496FCE0AF4074160FFF856477D2441C61F11C498F507411F871A01467D24416C36037859F607412FD85698547D2441CA29E37379F607417D7339A0657D2441FC6FC28BAEF60741F1C97930757D2441C69B9CF009F707410D87327D847D24412EE088088EF7074198FC94F5947D244196372F7C15F80741ACEDB677A37D2441E27F5EEA77F80741D3DED8F9B17D2441C80541C2C0F807412046B68CBD7D24416268F238E1F807412A468A4BD07D2441E895844807F90741FB88797CE67D24411694C5F224F907412D3187BBFD7D24415A76B1933BF90741E8D39001147E2441ACAB95A54FF90741E00732B61F7E2441F248F2845EF90741ED6FD8DF307E2441FA97659F7FF907415BAF829C507E2441D66FC392E1F90741E08E4AC37C7E2441064F46897AFA07418CDC41E6947E2441B42863D2BEFA074140AFA656AE7E24411C460832F3FA074193AE853DCE7E2441FE5A198F3BFB074188FB4F09E77E2441F6A9515476FB0741610C5D0AFC7E2441E0C430B3B0FB0741F44FDD520B7F2441BC211428DFFB0741F504DE491C7F2441183150D81DFC07419950B227307F2441646139E988FC07411EADBF47467F24416A6931ED08FD074197D7B2B84E7F24418440818A3BFD0741E63833BA6C7F244170F12F71B0FD0741842043387E7F2441B6D2A567FAFD07413D576C089A7F2441F630638889FE0741BDD23750B77F2441CC017DCF2CFF0741EF7A7D0EDB7F2441005B7399E1FF07416BD567E9EC7F24413C6D7CF531000841CDA85D71FF7F2441A4984FAF75000841F36522FC2D80244152BF2768100108417E9493764B802441E60EB08378010841A9A6CEE471802441943A143E070208411097CF4DA08024413C301E3CB50208411769A3A6C08024413E307B92310308416BE5C786CA802441461D8D8C5F030841B4630FACD88024417CDC0C776703084127C0C44914812441E0A1F9B9DB030841D2D5C8EFF8802441D2527C9C94020841485C20EDDF802441AE8E60583B010841C8167121AD80244102F374C9BCFE0741E45813F8F5802441B0541C3DB7FD0741EC64995254812441009BD6FB47FC0741EAB525E5AD81244146CAD508F5FA0741D9E962D9BF812441E2C5FE59BDF90741D77DBAE2D181244140D24FB05DF807416AF1391C7A812441E07176E36FF707416419493808812441CC640F8555F5074118F6283ABA81244174E84803FEF30741116E8783838224416291233864F207412C784E59D7822441FA8222DD0BF20741D0FF93BD338324413E619BD07EF1074186CCBB9F2D8324417631A36EE9F20741FFF6E68F42832441CEBCB09EA0F307419BFF83AF14842441C4E4E7FE92F207418E1CFF8E49842441DC734B3594F50741296429225B842441107185349AF50741A9261EE777842441F23B3D21F2F40741E7F1F75892842441E05218D23DF40741F45B5D07AE84244112B3CC4587F30741DB8969ABBF84244124D048F90DF30741378974D3CC842441C6AA4341BCF207419341567EDA842441FE177CBA79F20741C61FB8B8E8842441168D0DE13CF20741D4BDEA5CFD842441CA920F8DFDF10741800D698513852441A674282DCBF10741F2319BA434852441E0C48E479DF10741538883B269852441725ABF785DF10741F1BC31BBA6852441C0DB2EA302F107414F2A4CDCD185244166F099FEB8F00741E1F0BEAA038624415071027E46F0074133F4E31B2C862441180A6F5ACDEF0741AD1CC0854F862441A2645C773CEF0741150B026A73862441E669BFCC82EE074172C353139A862441B46FDACC93ED07413FE9DFE0B9862441101718ADADEC07419937D819E4862441C4B2D2DD33EB07415AEBF06107872441169298179FEB07418291A3DC0D8724419E942A6ECAEB07418B93C6211287244106BCE7D0E6EB0741E24ABD2C18872441A4C17B2F0FEC07412471CFC333872441BEC5B980C7EC07418F46201057872441DA12A547E3ED074182A875E699872441808EF51E6EEF07418DE03C22E08724419A5E2ABC8FF007411F283B740488244140977AD02FF107417B25871707882441A09C0D7D3BF107417127AA5C0B882441ECBDF5324EF10741CB737312128824418C7EBEC86BF10741479809F22C882441488373760DF20741F881D8F4488824418CE619EF0CF30741112017D77C8824411A61901A37F40741F2320F9E89882441C85B95198EF4074112D79ED38B882441567C3BCFA2F4074163A081418F88244188DFEC45C3F407413A0DEA848F8824417A2D3EC0C5F40741BDEE797AB988244192CACC9750F6074185F732E6C9882441881BD2089DF60741DBDF6FBBDA8824419025B661B6F607410C09097EE488244108613B7605F707410E3D0EF3E9882441B64470C231F70741E5DF437AED882441222DFD6583F707417D76239F0F892441FC7A878319F907415E53C76A25892441B8936C378BF907414066BF3132892441A63161C2FCF907419597E4084D892441824660760CFB0741588551184C892441C6367A7132FB0741BB8C149657892441DAA610974CFB0741EB7F91DC76892441D022D06D8CFC0741A6EAF7A0A48924418E4D5629B1FD07417C9173B2B08924411E33E27622FE0741E8E3D178B18924411A07FD13A6FE0741DAC60A55C1892441CE36437B8DFF074161D6E9E8C4892441A05F4989BFFF0741DC794CC7C7892441BA1368C5C9FF07417D911B30D689244154AC614F920008415F231875D7892441C6D3475E5C010841546EEB3CD989244146CCF55B6E01084143F89C93EC8924418C9FF68C33020841CC0C4659AA8A24416EE4F11F300108417F2D3D2BC18B2441042C7C0BAC010841C306AA115C8C2441B4CC64B98EFD07418984CFB6FE8C2441DECF32DDB5FC0741BAA3DFF6818E2441104D56955AF807411D3F2E4A14912441EC7C531A35F5074161BB6C5D23922441D485BD85AAF20741E30D4A33A694244198BE2476FAEC07417777B282CC952441A2C4C0BD48EB07411D3E49A57E96244186B2ECE65DF0074134EF3BE020982441A623D80F66EF07419C5AEF60D99724413ACD2CD944E607417801289613982441B682DA0358E70741593546F662982441F8C7792EECE7074117E7B3A0B7982441A0B7D5AE2BE8074112ACA04B0C9924419AD81DAEACE70741CAB2ECA0369924418488F2AD2FE60741B04A0741669924410EB2FC839BE50741A7820EC1A59924411828232EF2E40741CC4BE48BEA9924411C6336839DE40741E723D8EB399A2441D203CC02DFE3074160F968164F9A24416EBDC7D8CBE2074121F196D66E9A2441CA27FDADBAE00741E2BFDBAB599A2441E48970ACBEDE0741B99209A1349A2441960E71D7D7DC074199561901059A2441A8FABD2B85DB0741DDEBD06BFA992441BC4DD2D75CDA0741A5E62CD1099A24416641888066D907418AD3FBB0C29A24412C7EFC41FCD50741E3BA89A58B9C2441BCDA28288AD007410C26D986459D2441182EEBA2A2CD0741786A954E9A9E2441B87B11D66CCC07419B8C73B2449F24416AA8403720CA074163105FB1CBA024417E47EB6E86C6074174B5DFC6A8A024417AEA753ED0C10741C456FE7D90A124418E3B8096A1BF07417078FAFC61A2244176453092DABC07413298C5CCB8A32441822A3D4020BA0741F94FF55079A32441FEEAA6A072B7074196AED69991A22441E4E5CE22D6B807418AB3AE172EA124414ED8BCC8A7BC0741E0EC31837FA0244132B12D3C66BD07415545C52E54A12441C4E458032FB90741DD124BF019A02441805056ADBAB9074126009C8136A02441F836D97AA7B607414233D14F44A12441A260544637B50741790E2E0251A124415695F52CA7B00741111E36A212A224412078169C9EAE074117539C1F9BA22441103694BDA2AC0741D0512600F4A2244106A8DF0472AB074188D148380AA324413C1C178B8FA90741AF74989E6CA32441A2B18F00ABA8074169612EA0B5A3244100F411DFA6AA074137CD2B4A41A424419C80507830AC0741D149A7B335A52441FE3BE25AE6AA0741E8358225ABA524419449F4B414A70741FB596AE3CAA52441926F0D22AFA607417FD816FC39A62441369DEA4B34A4074181458AC56CA62441245B686D38A20741B6B373AE46A624414282F7F979A1074159B42E3E1AA624418616FA4FEEA00741010E380996A624411461B60A7CA007416068FC63E5A624413CCE29D4AEA007415030EF173BA72441D638B15E93A107414A015CBB98A7244106331E5123A307412DECC00D67A824414EA1073AFDA20741824FFF57BEA824416C1122D251A20741A618682BBBA82441D4EF255380A10741E57DD7248DA8244184CD6E44DBA00741A1D10DCF22A8244116AA41168FA00741B2768EE4FFA72441EA62E7B9F69F074155774974D3A72441886D5245039D0741264AE7C6ABA724417451E9D3A19A07411BD4F90D71A7244112A424DBED9707419A1D40A957A724415284590B979607419C78BF937AA724414A3F305E7995074196492C37D8A72441881F658E22940741B63E819855A824413249E059B29207411618AD9BE7A82441BAABE897D89507415869F7062FA92441C2F01145F6960741C6FBC8AD28A9244110903AB64A93074139E7E88FCAA9244106712A76C7910741038BF38500AA24413423C7EC17930741C680037751AA24414AD08BE5CB950741807F8D57AAAA2441BAF3B81318960741DF43E50F02AB2441A61A21851E960741A563080E15AB2441D05BA8452E960741559687932EAB2441DCD9A06F26960741D8AABE5557AB24410885149B6A960741004E0EBCB9AB2441BC3C441F2B960741FC629F6709AC2441B8B514BAAF960741C5A11CCD29AC24410E7BC6A73D9707418B788F483FAC2441DA7BA0539E970741F4E1C79F5BAC24410C14C7DC1D9807416E89A88773AC2441DAC7426FA4980741FBB114F37DAC2441DE5D12F7DE980741F17D1BBC97AC24419C29999176990741FBB53A7AB8AC24413287AC5D6A9A0741BA0529A1E7AC2441EC121E8FB59B07419414E71B0BAD2441E44F5050AE9C0741531B7D4217AD244194320FF20D9D074133C2CC1236AD2441F20518E6589E0741290DA0DA37AD2441A6284947819E0741DF904FB940AD2441801CA698859E07411E58E3A052AD2441247CE00EF99E0741D3A7FD086FAD24417A4505AA2AA0074181AABDA38BAD24411EB856D21DA107410851C61899AD244196107E489DA1074141AF0444A6AD2441A445BB031AA207419B7E8800C3AD24414A870AC751A30741B507ACD6E5AD244116B82ADA99A407418078C7AEDBAD2441F27BFB70AFA40741676C014EE1AD2441CE79CD1B18A50741D6A72D01ECAD2441F0F313F07CA50741F4962C3EF6AD2441A467161823A60741A8E85DADF7AD2441EEBCFD35C8A60741C9C0F257FFAD24419AC11A3807A70741263F72FC19AE2441C62873069AA70741B3A1B06C30AE2441DC3C070EFEA70741292A6F6C47AE24411E880AD389A807418A46DDF74AAE2441B6B720E3ABA80741905FDACD6AAE2441E687B98161AA0741F902ADAA86AE244176E0D14CACAB0741BDA51AB196AE2441A8510E7458AC07417429CA8F9FAE24419C297312D2AC0741A937EBB4AAAE24410281198659AD074135E3D9A7BEAE2441D05A662663AE0741EE964871C4AE2441E86F70D893AE0741CD416ECDD2AE2441F6DE21542CAF07414D836710E4AE2441F09980E9EBAF074105395DDFE7AE2441A4CF6BA617B0074148E7FF2EF9AE244154B111F426B10741ABB8A6301AAF2441B04462D5A1B307417B0EF2E836AF2441A6EB2165DCB4074122C0D9AC3EAF2441E80F3BC894B507416F5B843543AF2441541A832242B60741FEB72D955FAF24413495684D21B70741E52E5ABA87AF24416283EC9E12B807418B638C868CAF24414C909DA33DB80741BD88DFBE8DAF2441E46CF69748B8074150043B0892AF2441FA8F2EA488B80741BB5609CDABAF2441CEC01A0D02BA0741C4DB761AADAF244130A44F592EBA0741E1DB47F88CAF244150DED90349C507413EDB8C68B9AF24418A582EC507CC0741E622A25425B0244154AF55587AD2074120D8E59997B02441443832930ED50741978BF82F8FB124416AA5A55C41D507417441F704D5B12441E27CA0B058D60741D68796D199B22441109EE19F56D707415F5F9125B1B32441FC81782EF5D407418F112E9C01B5244102364654C0D50741B7A2892354B52441C0F89BF360D20741159A4F47C2B724416E7F8CEFA6D50741159A4F47C2B724415E08692A3BD8074197BD7C750EB824411A2C965887D807419B97630874B824419A914565CFDA07419E714A9BD9B8244120E0637E52D90741D7B91A1719B924410CC4FA0CF1D607415B4ABB0E98B92441F2BE228F54D8074113A222994FBA244106DB8B00B6DA0741685C153C19BB2441A8C4568CDCDD074153A63DFA92BB24419416D553CCD70741A36B831C05BC2441F4DE360571D70741FB88600BCCBB2441EE0BF230ACDC0741F469F5D46BBC2441EE0BF230ACDC074100C8354A9DBC24419C33932993DE0741FA2B1F68ABBD24411C3620433DE007419A6C82EE15BE2441627DBBE70CDF0741C89A5B0562BE2441C49F42AD9FDD0741F84B89701CBF24415E1E7CA0CADC0741205BF75008C024417CF967C18DDC07418F34552A32C0244126638A2BF0D907416984269188C124419675149B0EDA0741771B939CAEC1244120AA25D0BFD80741C55D846AB2C12441F68B490FE8D60741A130AA2577C32441FEBDCD2AEFD30741AFC716319DC324417E0E2E07CED20741821C926EBFC324411A3A7A0470D10741FA4D87143EC3244176A39C6ED2CE07410249DD3D72C42441BCEA3713A2CD074194F2D3B8B6C4244192CC5B52CACB0741D7FC97C2D6C624411E5B929B69C90741F4D3D8DEDEC924412EAE2E4E6ABE0741CDA055F1C6CA2441E86693A99ABF0741355B489490CB2441EAC5D2F0DCC10741943A4F1697CC24414CED73E9C3C307411B095A7018CD24415E379CA73DC40741A25410762BCD2441341EDA19BAC507418E9E3834A5CD24411A4F404AB0C70741523289B098CE2441BA8BF8CB5FCB0741F039C0A00ECF24417850AF7849CE0741375D4638B2CF2441F6A00F5528CD074169EE099BFBCE244100D393702FCA07410F4ED857C6CE2441D0FB525427C707417246A16750CE24416ED4B15B40C5074115EAEE39B8CD2441E818C0E665C207414F7608C635CE2441A21FF804CBC00741915AB91E08CE2441F4F7560CE4BE07410ECB830358CE2441467DC81D74BC0741C5C7677425CF2441EE39D87D5FBA0741F3F5408B71CF2441A087AB4094B707414677079846D0244104AA320627B60741242AC34A9AD0244168CCB9CBB9B4074152589C61E6D02441BEB06A248CB407412BA2C41F60D1244148928E63B4B207413064EEB29FD22441C6CD28FA52BB074132E742070ED3244114F974F7F4B907412C251974CED12441B498C68119B10741A995E3581ED224415E02E9EB7BAE07415BD646DF88D22441A2EA444909AB0741433A30FD96D32441109E8F71E5A807411E8A0164EDD424412CCC688831A9074157161BF06AD5244190EEEF4DC4A707410B0E39734AD62441AA40DE713CA607417C20C3E268D624419EAF1A0FF3A60741EBF920BC92D624412AF07D955DA707419210AA75D2D62441E249A3A94BA607414C27332F12D724411AACFE7FC0A707410B7CAE6C34D724412C73D2E9CBA707416821A69D57D724414AD1125FFDA70741B0590B907FD724413C3AA653D7A70741FACA9C189CD724416629AA2B52A707411D9B35BAB6D72441B8DDF3253FA70741F0EFB0F7D8D7244172BA6D8E9BA60741F0EFB0F7D8D724419CA9716616A607419EDC5FE4EDD7244152D9D8C4FBA507416D607BDC28D824411CD6BC35C9A607412D81907144D82441022B3873EBA60741B1C7808969D82441E6D2A0A696A707413109ABB3A0D82441D40BCD3C8BA707413591C5F5FCD82441AA997410A2A70741B80B1CB628D924411AACFE7FC0A707412EBB9FC227D92441BCE39CCE1BA807413F57D2BB3BD9244120E20E8782A807410BD627C688D924412C4FBDDC9FA9074124CBD446E0D9244120B850D179A90741B36F05D436DA2441BAB9DE1813A90741121AC3F247DA2441668240CAB7A807412853EF883CDA24419A7FB3B00DA7074104B7BC8F28DA2441609A03862AA507417D6B068A15DA2441342202B164A40741C5ECB07FC8D9244116EE7FF13BA30741A826A4B989D92441F8606793ADA00741D95943BEC3D924415CDC84F7A5A00741F653B62C09DA2441B2438AA4E6A007412853EF883CDA24416A20040D43A00741F7D60A8177DA2441069F3D006E9F07418C85C7E9A9DA2441D8CDA58C429D0741867B3B0ECEDA24414887995DFB9B07415E0EA9CFD2DA244190518956399B0741FE63EBB0C1DA24419CE24CB9829A0741512EF7C021DB24413891ED0A9399074150625D6928DB244198594FBC37990741BFF2753FC7DB24411A33AD9561990741A3AFBDCDF6DB244142759E6365990741519C6CBA0BDC24419A5FF864149A0741395E7A3629DC2441A8F664703A9A07416E6279804ADC2441508F5FC3F99907413288540354DC2441D06214F446990741D59917CFA5DC2441B6B78F3169990741E5C8B789BEDC24419CE24CB9829A0741E1F75744D7DC24418C9ECDA3E59A07417E48D437D8DC2441363D719F819B074173A14EBF1BDD244100B700BCE09B074169C6629E58DD24413AC66E9CCC9C07414FBCD6C27CDD24412E35AB39839D0741C26694E18DDD24415A83EE58409F0741667857ADDFDD2441C0816011A79F0741B9F91DBAB4DE2441A0A0CB47079F07419FEF91DED8DE2441BC51F9B2C19F0741BD8138FC10DF244176B1C76F8C9F074180A7137F1ADF24414EEC814D1A9F07416FF6012B82DF2441A01D77F3989E074147896FEC86DF244148E02FFC609D0741C896336EB7DF244102BDA964BD9C074173B28215E5DF24418E7AB896B99C07415B402AE9FBDF24411E989585809C0741216BCB59F3DF24412A2959E8C99B0741E613FB306BE0244174F9F189E49B0741D79B1573C7E02441AAFC0D19179B07414675734CF1E0244136BA1C4B139B07413BCEEDD334E12441D23EFFE61A9B0741D44D0A824EE12441F09C3F5C4C9B074131F301B371E124410A48C41E2A9B0741C39CF82DB6E124412823B03FED9A0741F96C91CFD0E1244136BA1C4B139B07416B4BB596E8E12441D0B0E7B67B960741B9C10C0DF3E1244112C81BFD659507419CB2BA4329E22441DEEEBD233C95074163A9F50B1AE22441F66F8430119607410F5D78623AE22441DCC4FF6D339607411AEF1E8072E22441BE66BFF80196074155FDA9A56FE224414A4E8CE0069507411AEF1E8072E224413C5E89367B930741A710FBB85AE22441BCAEE9125A92074101B12CFC8FE224410279D90B9891074133E4CB00CAE22441C8ECBF7F1A91074122FF53042BE32441103A04CDC6900741659ABF5972E32441D8ADEA4049900741B7AD106D5DE324410EB106D07B8F0741BBB2D65A4BE324410E587031168E07417885E0FEEDE32441628F0E80718E074143389CB141E4244180ED4EF5A28E074163036F656EE42441361DB653888E0741C07400EE8AE42441EC4C1DB26D8E07419502A8C1A1E4244198922A0FA48D07413558EAA290E42441887869AF0F8D07411D1AF81EAEE4244196B63F1CD08B0741B5CD7A75CEE42441B28B8294B68A07416FE4032F0EE524418696D5135F8A07414472AB0225E52441127EA2FB63890741018EFAA952E52441DE279976A8890741122A2DA366E52441CEE319610B8A074185D4EAC177E5244168BBE9F29B8A074136C65F9C7AE52441DA50C8B6288B074156913250A7E52441D06C175E568B0741B3362A81CAE52441D06C175E568B07415B194D9203E624415A247DE7758A0741C9F2AA6B2DE624412098635BF8890741D484518965E62441066A8A44AC8907411FC27C697BE6244176237E156588074138B729EAD2E62441020B4BFD69870741BB3180AAFEE62441AED3ACAE0E870741CA60206517E7244102B2B45E04860741F5D2789100E7244154E3A90483850741F98EF97B63E72441703B41D1D7840741EBE2AD15B9E72441807FC0E674840741C03CEF40C9E724412A1E64E2108507410B7A1A21DFE7244172BE952546850741681F125202E82441805502316C850741480BFA9A4AE824413A62E3F7AD8407415E4426313FE82441E27789F6FE830741CC51EAB26FE824418EBD965335830741EB50230FA3E824416E5F56DE038307415BF61A40C6E824412A4279EF3C830741ADF48CF82CE924419A54035F5B830741D0C4259A47E92441E0EE8BF9B38207412D6A1DCB6AE9244188B144027C810741595FCA4BC2E92441DC0CF85D038007412A1C12DAF1E924419619D924457F0741BD91A2AC2FEA2441DCB361BF9D7E0741A08250E365EA244140593DD99E7D074181F18C801CEB24412CB0D5D3E27A07417D5493E33BEB24412CB0D5D3E27A0741C58CF8D563EB2441B81AF70F567A0741F6BF97DA9DEB24412A573F357D790741021ED84FCFEB2441EEC47C0023780741BE6D8D9F03EC24416E15DDDC01770741CDD0930223EC24411ADE3E8EA6760741103899AF63EC2441B4863637DA7407410962737C8EEC2441167FFF4664740741CA828811AAEC2441EA8952C60C740741201EF466F1EC2441EA8952C60C740741B2C7EAE135ED244106B82BDD58740741C8B7D1749FED2441784D0AA1E5740741BD104CFCE2ED24418867CB007A750741E1AC7EF5F6ED2441A442B7213D750741569068AAFCED244124166C528A740741084E77DCF8ED244178711FAE117307417D316191FEED2441DA93A673A4710741CC73525F02EE2441B8AC680128700741A8A3B9BDE7ED244112C180B8DF6F0741F3144B4604EE24417436F573FB6E07419AF76D573DEE244172B3A01F8D6E0741DB59AD1690EE24413AAADBE77D6E0741FE2946B8AAEE2441ACE6230DA56D0741B7BD7A1D7CEE2441725A0A81276D074102FBA5FD91EE24410E5C98C8C06C07410D8D4C1BCAEE24419C490E59A26C0741305DE5BCE4EE244162BDF4CC246C07415028B87011EF244136C8474CCD6B0741D43A42E02FEF24410C80ADD5EC6A0741F40515945CEF2441CE40D8961B6A0741CA5F56BF6CEF2441A2F294775E68074138B65F4428EF2441EAC22D19796807413BBB253216EF2441CE8EAB5950670741171FF33802EF2441F44D48D3E5660741D80BA22517EF2441122934F4A8660741C3D2758F22EF2441BC98FF06E86407415E8BBED330EF24412CA5E0CD29640741D1357CF241EF24419020FE31226407416DEEC43650EF244190A352869064074103691BF77BEF2441B8E5435494640741747BA5669AEF24416631FA59A764074144CB5AB6CEEF24413ABFA12DBE6407411959028AE5EF24414CDF0B362F6607414A8CA18E1FF02441E633877351660741A73199BF42F02441942C5083DB6507410EB27C1129F024414AD9628D52650741417D4FC555F02441F2EE088CA3640741F9FBA4CFA2F02441C882590897650741BD218052ACF0244158C96537DE6607414CC6B0DF02F124414C62608A9D660741AF7534EC01F12441229771BF4E650741B3FD4E2E5EF12441840CE67A6A6407413F9DB9CDC6F124415411905136630741570F12FAAFF12441BA39C0BFA5620741D44B7636F9F12441D691578CFA610741B132989153F22441A6E9EE584F610741C39A64E260F22441BA39C0BFA5620741FCA3291A70F224412C4C4A2FC46207415849214B93F224419EB76A3D48640741400B2FC7B0F2244112FA5B0B4C640741720A6823E4F224418E9DA9DDB3630741874394B9D8F22441D23732780C63074120F71610F9F22441487A234610630741B5A5D3782BF32441C8D02CCBCB6207417692826540F32441A8EF97012C620741615956CF4BF3244128C34C3279610741285091973CF32441368477F3A76007411E2C6073EEF3244150D66517205F0741BAE4A8B7FCF32441D22C6F9CDB5E0741930F4A28F4F324415E143C84E05D0741E9DE1B2642F424418A8694B0C95D0741BB67FD0B6BF42441EAFB086CE55C074112BA235E27F52441CA971F4ED75B074111EE89062EF5244186A40015195B0741950014764CF5244158A9AAEBE45907417CF6879A70F5244184C81522455907419FC6203C8BF5244154A3014308590741ABF0FA08B6F52441C6B58BB22659074192E66E2DDAF52441644017F70A5A07418BDCE251FEF52441CCEB9BB9E8590741EB86A0700FF624413A75282CBC580741643BEA6AFCF5244162E1D7AFC8570741C1E0E19B1FF624419E1A0446BD570741ACA7B5052BF624415650144D7F580741DDDA540A65F624418E2F1BCF85590741E86CFB279DF62441C6B58BB226590741612145228AF62441468940E3735807413376C05FACF624412AD81278B95707417955E59429F72441309B3D765F5607416F12F756A8F72441EC9B3E97BD560741154599091BF824411ED5F72E585707419BBC0CA8ABF82441D0DB0E148057074183650C83E2F8244162D60DA5245807416AC43903A0F924418820E0FF9D570741E2A5E73A0BFA2441B8CEE049305707416C4FF250A8FA2441E018B3A4A9560741A3DFAB0D0CFB2441182BE2DD545607416EC354DFF1FA2441DC02420999540741CF726B9F50FB24417A1B88276C540741EF08310676FB244166C872FB31530741FC9EF66C9BFB2441AA5D2D27F152074149EDE412C2FB2441C6B81845495107410910532604FC2441947F5FADAE5007411681AFDF6CFC2441D2B0EBE954500741952DC0CAEAFC2441B684601C0A500741936F8BE127FD2441DA141AD96D5007417F4A22346BFD244138DD76B79F50074169421BF02EFE2441E2E4A312945107415CE814F684FE244154090285EA5007411E7FE59710FF24416CAAD4042D500741C74A538689FF24411A00BFB3294F07412FFD6F1BC9FF244132A191336C4E07410A10AA8FDAFF244156CC068BEA4D0741C8994C67160025413016D9E5634D0741476BC6FF500025410A67C225054D0741C04C7437BC002541F259945BB54C0741CDE2399EE1002541689D4FD1064C0741268B2E3EB2002541000C809ED64A0741806FE24AFE002541EE4323C0A44A0741CA2405B51E012541C029C72B054A07413EF984223A012541265652F94F4A074189AEA78C5A012541ACCDC597E04A07414E03AD17A901254162F33980034B0741961F0446C30125416CE220BD244C0741BF19F89B0102254152B695EFD94B07415CE86B5F5B022541B8BCACD4014C0741887B2BF19F02254156D5F2F2D44B074170242BCCD6022541803E2251494B07418460EA385203254196C097CD904A0741D4BB06A9C803254118AD521E194A07414C9DB4E03304254106E5F53FE74907410B2757B86F042541FE80C750CE490741700805F0DA042541AE616A4DD34907412BD472DE5305254128EAF6AE424907418C83899EB20525415898F7F8D448074199F4E5571B062541A2728310B24807416FB01FA76306254192AA2632804807412D3AC27E9F0625418C6555466248074164CA7B3B030725412CA40F4D58480741C2E0C6BF5B072541FA6A56B5BD470741A12598AB79072541901F6EE47747074106CB867669072541162B8638FB4607416D2EAA2A1C0725414E3DB571A6460741D491CDDECE062541081D42F8DE450741C6FB0778A9062541D09EB77426450741E542D4FD41062541E266145358450741B8164930F7052541DE47B74F5D450741327A6CE4A9052541C83A89850D45074194ABF820500525412C41A06A3545074141B71075D3042541B6722CA7DB44074123A3C08AF50325414A2744D69544074186D44CC79B032541F8E889CF9F4407414DD0307CEE022541A0F0B62A94450741EFDE4EA552022541BC42B6E001460741C34B8F130E02254164BF2AEEED45074177220A1BA4012541D22970C22E460741A969D6A03C012541FA73421DA8450741CDE2399EE1002541988C883B7B450741BDB3A8FBB500254156458B63C44307416FF157C745002541489C8B888D43074141C5CCF9FAFF244118EE8A3EFB430741B98F2472A7FF2441F65DD181974307411A4D4E2004FF2441BCF835B3DB3E074160F542C0D4FE2441D8E7C586263C07415D370ED711FF2441C2DA97BCD63B07416FFF6AB543FF244142A8F509643B07411928E57247FF24417030826BD33A074120F347265AFF244128100FF20B3A07419FC4C1BE94FF24417609F80CE43907417AB29285E9FF2441D08C83FFF739074159F7637107002541423C9ABF563A07416BBFC04F39002541EC43C71A4B3B07412417CCAF680025418E0D3A6F493C0741088E341393002541F85822408F3C07410E342E19E900254150B6394A803C07418615DC5054012541E0C03B28373B0741B441671E9F012541925BF7C2513A0741A11CFE70E2012541F8610EA8793A074188A0949E5C0225414CA0C8AE6F3A07418CADC268AC02254172EA9A09E939074109E670C5E002254120ACE002F339074107283CDC1D03254134939AE41F3A074109B3F42926042541A6B7F85676390741AFE596DC98042541D665F9A00839074185C639D99D0425410614FAEA9A380741D9DF8A32D7042541A42C40096E3807415E57FED06705254172F38671D337074141A9FD86D505254140BACDD93837074106FE02122406254176AD9F0FE936074178144E967C0625416679E7E6A9350741A4CC76D57D062541F8995A6071360741A540D963C7062541F8995A6071360741AC0B3C17DA062541B62CE99F97340741F834C10F4407254152BA767062330741EBDABA159A072541B85B49F0A4320741E91C862CD7072541C898ED80CE310741CF2CBACB070825416845D85494300741B2A3222F3208254194D47B9B2B30074149A7333F790825412A8993CAE52F074101667363A208254110F1ACB28D2E074191C38A6D930825416EC2F5F8A92C0741E0AA444FC00825415270F6423C2C07418F2ABF318D0825410A596F315F2907410C636D8EC10825411032E5D26F280741381B96CDC208254140E0E51C022807412FB767DEA9082541869B1431E427074177F827BA80082541649FFF297326074183A1FD678E082541E4652F833F2607417C475C929E08254146384D036625074104A35F9F530825410ADAC49428240741F0249A240A082541707ADAEE252307417126FC5BCF07254116B108BB9E220741F981FF688407254172B26AF263220741382D35D5C6062541828C7287642007412C772E9EA0062541D84A137E5C1F074162AEBEBE9A062541A8F2D7A3DD1E07412E371DAEC206254124EA9B94711E0741A6724BD6F20625416C1FA271C81D074122A3292B24072541C20464C3941D0741178D898426072541AC54ED0E971C07418A1C9A3F170725417820FB321F1B07411AC24AA10507254110D14028841A0741EEA05A2709072541969C098C9419074162F059F21B07254128E3CC473B190741FDED452E89072541A80F5255AE180741EB386231EE07254112FE94765E180741090670182A082541DED10F69EB18074197765F5D390825410C94123DA0180741B0974FD735082541D85F20612817074180CCCB339D082541A068A1300C17074133A90CB6850825419484C22086130741772BFE995C08254150A964E0E30F0741045A52ABEA0725417C36A697B90F07416A13D4AFBB0725414CDE6ABD3A0F0741E9787321CC072541AAF03B9D690D074176E96266DB072541F8C485D05D0C07415DC872ECDE072541506567A8C90807416F7D56E9790725418EC66812A4080741CBAB653A90072541ECD839F2D2060741298408B54207254132D97EB24A060741365A976B62072541D620566FD0030741B4BF36DD72072541ECF5B3A3A30007414C8861FC00082541B4FE347387000741FD2FE1610A082541D8453DEFA5FF06413132B06525082541B0B999B99EFC064152347F694008254184C3734AD9F90641F8C55E284C082541B413425653F80641A96DDE8D5508254198631062CDF606415E0A0E206008254132D7E2ABD6F4064181419E405A0825416227B1B750F30641D0991EDB50082541C2D80AAE94F0064120F29E7547082541184C983726EF064139138FEF43082541DC78620511EE0641ABA29FAA3408254178EC344F1AEC0641637490591E082541C42A467C44EA0641585EF0B2200825418857104A2FE90641D3CEDFF72F082541A49E5D86C5E7064111E74EA2480825413AA8AD9610E606412CC82D2C670825412462FEDB48E4064145E91DA663082541A8F805237AE30641A82B435AD4072541FC3E3F5E31E4064197A9963675072541E4CB3B558FE40641BFD5D6837007254110E748442AE30641A37F25ED940725412AF9D463E1E106412C8692F8E507254110D76EA720DF06417ECA41F0F907254130883E1D75DD06411651D1DB060825415839C9D251DC06410125918E0B082541062851B479DB0641D503A1140F0825416AAC119C6BDB0641F0E47F9E2D0825413080D14E70DB0641772BFE995C082541C6918E2DC0DB06419C227DCA78082541E84ACB7119DC0641C119FCFA94082541E40D9D8635DA064131744B99A6082541D292E7EE16D90641DFE609E2D00825411093716F06D80641BF9BA81EF4082541689C37FF61D7064152B8B5D042092541E63284060BD606413C0E22A7A6092541A02AD2778ED40641BC33B028D9092541B0685924C9D306415C9B1E9E040A25415E57E105F1D2064119192DBA2D0A25417CD3EF5E66D1064131F88100A90925412AC277408ED006416DDB2F8EE20925419E128B0C80CE064107D91BCA4F0A254154A8C3124ACF06419D2AEA987D0A2541923619CBFECC06410E452847B10A2541A8DE22B1F7CB0641323A1D342A0A2541E4DEAC31E7CA0641CC370970970A25412C0C464039C80641E4E326DDD60A25415E99423797C80641F17023D4340B25419A6C7869ACC906415A2C2F1CA90B25416ED7C9E3D1C706412A61AB78100C25412E399A8E13C60641A7D32401C30C2541DA1FB5A136C306415C705493CD0C2541D6B5326878C30641611C72000D0D2541380D9F0190C5064137BB7096320D25414CBD15B68DC6064117700FD3550D2541A8030A31CDC70641F9A201EC190D2541BEB380E5CAC806417FA7E4B3C70C2541A80B77FFD1C906415EA515B0AC0C25411CD62B6203CB0641DB4AC6119B0C2541AE7D660795CB0641B3671884610C25418E6B1FA855CC0641DDC819EE3B0C2541E07C97C62DCD0641B1A729743F0C25414E36D40A87CD0641B1A729743F0C2541C86A0BA776CE064161983B990A0C254136CB3DD0E9CF0641CE7B2EE7BB0B25419211324B29D10641FD46B28A540B2541C410630AC2D2064166C0229F470B2541A69454B14CD4064161CB7272460B25412A33C9C682D50641730B8462240B25416EA5424F35D60641B68D7546FB0A2541689C37FF61D70641253157A4CE0A25411229AA75D0D806414087083BAA0A2541203ADDD330DA0641327CB867AB0A2541724B55F208DB0641B31619F69A0A2541062851B479DB0641FB8DBA06730A2541AAE9C9073FDC064161473C0B440A25410630BE827EDD0641C9C0AC1F370A25414203F4B493DE064195490B0F5F0A2541F48F216B8AE0064151857EF7060A25418C48D42EF4E1064125648E7D0A0A2541CE1BC5A091E30641B5093FDFF80925410A5072BC91E506411E83AFF3EB092541768350972AE90641FA4B1FD3F1092541B0823C964BEB06410562BF79EF09254130B72E72C3EC06418BA83D751E0A2541489C6643A0ED0641A2946CD23B0A2541443A51D8E6EF06412F055C174B0A2541C6A304D13DF10641232FCD602B0A2541420DFD890CF20641637CFD27230A2541CE4AB5F5DFF206411B4EEED60C0A2541F003F23939F30641EC40CFFFF2092541B20368B949F406415ED0DFBAE3092541F00B5F083EF506416F10F1AAC109254146529843F5F50641D554A0A2D5092541145BD45261F606410562BF79EF092541F8B20F2DE0F606411B4EEED60C0A25418E8F0BEF50F706411B4EEED60C0A2541F6DEC5F9EBF70641DA00BE0F150A2541DE6BC2F049F80641BC754B5C5A0A2541C22475B4B3F90641BA408A3F7B0A2541E6127315ECF90641F12E88A0B30A2541B0B12CEB99FA0641A496F615DF0A254102C3A40972FB064120C7D46A100B25413E96DA3B87FC0641347E42AB4E0B254192DC13773EFD0641CC466DCADC0B2541FC2BCE81D9FD06417742CFC2A60B2541ECF5B3A3A300074100BE0EDBB40B2541EE058E40AD04074172D84C89E80B2541B81EE9AC9A0807414835B0EB8C0B254184F2639F270907417FE11219440B2541B87F609685090741AB77D59FFD0A25414227E0FB8E0907412F47F74ACC0A25419E0C5D8DE309074179F35978830A2541C8C55411C50A0741CEB55C4C380A2541F01DD5ABBB0A07410C439E030E0A25415CA250D3350B07415E2B7440C4092541BA016DA0980B0741F48A0EFBC4092541542671532D0C074130AD0A56C10925412A4BB709910D0741E513FF66B60925410CE70C54030F07412136FBC1B20925411C4950E803100741EE2EA16BBE0925419471C3C961110741F48A0EFBC40925410602508F1612074139F52F37B409254114B7E00760130741476C3FCBC20925410E856AABB1130741515A5EF3DF0925412219249C60140741515A5EF3DF092541A04F0927D8140741BCFAC338DF0925416A0BB2F24615074115386298E309254188A7494088170741F81CC093DB092541DC63340FC61807412CF7960DE509254120A90F4AF519074111556B731C0A2541FA3C8737D5190741DAC420B1360A2541369E88C8061A0741C3D8685F4A0A2541E6B705FAAC1A0741E90EAD685A0A254150CA28D55E1B07416F24BB6B370A2541E8A239FA9E1B0741A22B15C22B0A25412C49D4C2301C07414AC1F3853C0A2541CEEB4160C81C0741955AFF74470A2541843735EE1C1D074194878251320A2541ACEFB08E911D0741F6DFC2B53E0A2541886E5C7C631E07416C41C446700A2541E247F1A741200741227B357B7A0A2541002144D0502107415AE7BD8D9A0A2541C421C8D6EE220741BC3FFEF1A60A254156EC6652152407416DF07EBABF0A254164EDEA58B32507416F69F524FF0A25414CC067316C280741095B4178160B25418EB94FDE462907412A089515350B25412C9A3E60192B0741D370F0FC5A0B2541BCB72AC0882C07414D5BE2F97D0B2541C04F11DC312D074175135E9AF20B25410495EC16612E0741B813FF1B5A0C25416C5B1C64BE2E074174B29E0C900C254184B15470322E074184ABE537030D2541522F7C57662D074198CC5D41050E25419AF854C91F2C07411D81ACB67F0E25413CFC81F4192C07410AEAA81F0D0F254154F1FA722B2C0741EABE8C19530F254148279EFAD32B074154F571A4CA0F254104810332422B0741F8D4DC1FFF0F254122D0E1E7C12A07412653460A02102541CA05856F6A2A0741EE2BF8B0A9102541B471CB7EBB29074160AA021D141125412AC4D65F35290741E84148B75511254146B2F58752290741A90FD25AA71125412C2596ED9728074121F30A833D12254116F29B8A4B270741E442CCBDF3122541AAF444AFA7250741C517B0B739132541AC55043D0A2507410CFB475E681325410A14562DD52307416C430EC1C2132541564D26E077230741EB922E7A111425418E0626878A2507410C40821730142541DE761DC8732607413C64E5485D14254190DC8D876E270741BBB30502AC14254178726C96DB24074131150793DD1425414A220ADABD230741410E4EBE50152541E024B3FE19220741DC44D4CA2F1625413419A8768D2007411E9F7B056D162541347A6704F01F0741288D9A2D8A162541548BC4D5341E07418BB857B5AB1625410CC2EB637B1F0741493AEECAA8162541F40AF4C9A420074181CA388D8E162541E67E183688210741653DD9F2D31525416AD2A71DA0220741C868967AF5152541E2FA1AFFFD2307410AC33DB5321625412E34EBB1A0230741193A4D494116254120A80F1E84240741C4859F552E162541300A53B2842507412565694FFB152541648C2BCB5026074144908555B5152541622B6C3DEE260741E20AC214BE152541B29B637ED727074115121C6BB2152541AC082E94C628074155EA8B0E8B152541F25C41827C2B074170D1F1611B1625419EDDF47C8A2F074184AD2FB255162541F6A751F5E12F0741029C90DD41172541F8081183442F0741C74C11A65A172541BA099589E2300741B97BFB5876172541BA099589E230074125EFDDC18A172541789A214F973107413B4D53A9291825417AFBE0DCF9300741AB49267E2F182541789A214F973107411C2237A36F1825415CAC02277A3107417F4DF42A911825419E7C35EF273007413B928D62F1182541FC3A87DFF22E074174FE157511192541DC7BB1E8892E0741E4FAE8491719254180E09DA1E62D0741C329D3FC321925417AE7F7F7DA2D0741B658BDAF4E1925416291BFEB662E07414C8BD48D64192541AECA8F9E092E0741CA34FBFF881925415CF9D8CFBD2D0741DE103950C319254100FD05FBB72D0741C75104DBC11925415405E4574A2F0741FFBD8CEDE1192541C8F62FAB612F07419CFBCBCE4D1A25411E4CE4B0372D0741D46754E16D1A2541B424F5D5772D0741C0D0504AFB1A2541601C1779E52B074161CDC4A0681B2541CAA4C5E1072B07413C3D7ADE821B25411CD73B3EB62A0741B1F881288A1B25417A958D2E812907410CB8571FF31B2541EC16E240AF280741539BEFC5211C2541907BCEF90B280741ED8C3B19391C2541406C96468526074114697969731C2541069058F64A26074184418A8EB31C254112BB74FC042607413EA32CA14C1D2541D46E3F6BE124074199620298B51D2541D0D6584F3824074122A04179211E254128027555F223074148D68582311E25410ED6D4489A220741ECB5F0FD651E254184899FB77621074129AB697C771E2541AE645901132007416117F28E971E25411C242FF87B2007413D87A7CCB11E25410E3794D6FC2107414FBDEBD5C11E254108DD2E9F8E220741BFB9BEAAC71E254166AF697478240741C442AF16B91E254108050169CC2807415F95BAF7321E25418C589050E4290741ABDD805A8D1E2541DCC88791CD2A07417CFE57E2271F254154F1FA722B2C0741B22DE316AB1F2541D6820B3F7E2E0741D0F73F8F0220254128B5819B2C2E0741D0F73F8F022025418687BC70163007419967F5CC1C2025413293C7F8A2310741BA59832303212541187B10D169330741F4B03F3615222541EC3E97F96A350741FF041121FC232541FE6259A930350741694386C1D82425411C0C347DC8350741EED135266C2525412CA4DBB6DB350741211E4568C92625414AF112A98134074105BD9229D8272541FE626344EE3307411F13A46C0728254144C87D15FB330741808589D611282541867276FE1D330741AD9AA31D4D28254148A0877C6433074140554694A228254158B4E18610340741239C0B51A82825410685FF20BD3307419488BAF1AE282541BEFE159E5C3307415B93FA62BD282541081B15FCFE3207411964040FC628254174B75CDAC632074178CD68A7CF28254160566AB9883207416FCB7DE1D7282541D22C22AB583207410343CB1FE0282541C67DCAC52832074151275EAAEE2825416E3AEC03D431074196BE9667FD282541285E020F7E3107412883DAB20B2925418A2E20A92A310741F00C57211B2925414C9132C9D030074104C62DA41B292541826D8412C430074147F14D6C23292541CC2E9AA600300741BF64B9E01C292541F675C6BC542F0741A273339E142925416C654C5F212E0741997110591029254142080C94762D0741743368C81429254198561BAD032D074157421A0519292541446F0B5F962C07417C01F6962C29254184BBCA21F62B074128CEF13739292541B2933ABE902B074185828D583E292541F20A5790672B07416BFB080458292541766A0459992A07417A1878A56D29254106ECA72D0D2A07413E3CE12D892925411A4F294D682907419DA545C6922925414818988EAA28074184521E698C292541FE91AE0B4A280741319CCF019C2925415A370097CA270741FE42E752AE29254186615A4E33270741729927E3BD292541E67534A99E260741DEE9FEA3C02925414E7720FE3726074152765BB0BA29254178C7EE6CA7250741AD77B55EB929254118688B4A8624074152781A35C5292541EC0E61D602240741179805B4CB29254130DE35C599230741C1AF38DDD3292541ECFCBFCE4F23074197D7AF70EB29254120D59E6A9F22074118CC9A2AB82925413CEFA31D79220741DE1FE3A09E2925419A544F3F622207418784D457A0292541B04444E1E320074151E9F0548A292541CE198FE3BD1F0741E070F005D0292541E88EBC6EFA1E074144537DE4042A25410296764E9A1E07418C346BC8492A25412234396D5D1E0741D9E7472E482A2541D00E81C9A61D07418C346BC8492A2541D4E68A30101D074173627C46902A25414081705F031D0741EFA0354DA42A254190597AC66C1C0741EA8D4FCFF62A2541E8C4AF7C291C0741AE23B9132A2B25411E922214231C0741A6A02B21522B2541F233C222B61B0741A0CE3C9F982B25413006B1A46F1B07410897334CD22B25418E08EF994F1B074192C206D5382C25414635611DA61B07415AC8178E962C254144C7ED71091C0741B36E295B972C254100E951DB481A0741DE895E87822C2541F2D728DC81180741D67C93EE842C25419016EC0EE81707412E372008D12C254186154D14F817074115653186172D2541B64BB76CCE170741CE91A3096E2D25414AB1D13DDB1707413DF1A2F5CA2D25412C7DA5DAE41707417542384E3A2E254158497977EE1707411BD2D76D872E2541B8F3440844180741B003751BD42E25414EDA66D1611807417CEFEFA2362F2541F86E311BA5180741A88E4790972F2541A09588B94B190741F9B1CB6AC02F2541C834EAD2FE18074117EE467CF42F25416CA01F89BB18074178602CE6FE2F25411276EBFA441807413AFCB00FE22F2541807E44D5D4170741B8DDA81F792F2541D8E9798B91170741E8ECA78104302541008DB894141707417674A7324A3025410AFCCA3AA1160741203E3DDA73302541D24763325715074118BBAFE79B3025413E78B2A57D1507413211C12ACB3025418CE248614A150741C10E8335EB30254122206D99C0140741484071A3013125412A210C94B01407416E48C0513F312541248A03558D140741889ED1946E312541065AB4E166140741B99955AAAE3125417A8BA24F7D1407412C5581BEEA312541248A03558D140741004EC7DE4A322541DCB675D8E31407414022EA299232254120B2F9ED231507419DAE65C597322541248A03558D1407417C8C80E55E322541B2C6889213140741F0FE654F69322541846828A1A61307414D01A444493225410C0AC8AF39130741C8C99AF1823225415EBADB7D0C1207411507B5FDA6322541CAEA2AF132120741A01E0D3AC232254138F383CBC2110741AF81E915EF322541FCF89EB072110741556515EF1333254180C611486C11074158D5BC633E3325416829EE23991107417F53CE6B5633254156D24712CC1007410E9287726A332541E2A059A4B5100741629B751B9833254134516D72880F0741F82F4065DB33254114CCB5E2740E0741E343BBB126342541143A298E110E07417DBEEFC96E34254180838390E70C07417E34B22349342541347C5266A00A0741D30D106F683425415CC33B4B810A0741A636E6ECD63425416620306A130A07418CEE3411433525410AE42177340D07413A9E348771352541168BB4BA2E0F07413D0EDCFB9B3525411ADC3FE74B100741E661AF49EB3525416E5283B71F1207415A5ED2591B362541D43C5518401307418F3FC03D60362541B681AA7AFD140741D089A5E2813625410CD4D4A10A160741B4470FEC9D3625414C89DBA444170741A012448EB7362541ACDCA4C6411807414EC24304E6362541308D2FDFBB190741496617DC06372541DEDC1B11E91A074150BC281F363725415AA512BE221B0741A069EA9F84372541C467EE85AC1B0741103FACE5BB372541200096BFBF1B0741E13D0DEBCB3725410045EB217D1D074197709A53D23725411C9D302E3A1E07410BE37FBDDC3725415629A29DED1E0741C0E890763A382541FA77EFD42A20074162E652815A3825418CDD09A637200741857EFABA6D382541820084540E210741B7EF402A883825414AC59D117821074197C740659F3825417268DC1AFB200741D145526DB73825417A697B15EB2007415BE7E74FF83825418A7AA414B222074153645A5D203925411CE0BEE5BE220741AE04514571392541A017C83885220741739ABA89A4392541EE13EB48B5220741F62E85D3E7392541C2B58A574822074118516AB3203A2541F4AAF387D8220741543F2330633A25417C338807BC2307417E2DDCACA53A25416E7EF84E292507417DB71953CB3A2541E04550017325074104E907C1E13A2541F4068DCE0C2607418D067BE2AC3A2541362A077DE3260741CF071ADD9C3A25416C89066940270741DF567B6C7E3A2541A0ECE2446D270741A562A70A8C3A2541B6AD1F1207280741D3ED83ABA13A2541E8A2884297280741C02E7BA7953A2541B86C1EEAC02807414AC2B0223B3A2541CE2D5BB75A290741B4E49F2EC63925415C4DF875612A0741B6D024E27A3925410A0B58532B2B0741F9478636453925417C643C5AD82B0741D4B5F9E1E1382541D420FD3CB22C0741D396DD99D4392541D420FD3CB22C0741F8286AEE373A254158EE6FD4AB2C0741B1CB9ECB683A254160EF0ECF9B2C0741D46346057C3A25417E233B32922C07412F043DEDCC3A2541F62C3307122C0741A75C8C25DC3A254116CBF525D52B0741D101FFF7EC3A2541F4DBA7DAF42A0741512622CD053B25410EE361BA942A0741512622CD053B2541B04E9770512A07410759AF350C3B2541702B1DC27A29074132FE21081D3B2541149752783729074132FE21081D3B2541AE8F989897290741734807AD3E3B2541CCC3C4FB8D29074125952A47403B2541F4622615412907412D61FEE3493B2541829FAB52C72807411546C9B75E3B25417EE0AC7A0D280741956AEC8C773B25411A4766460A280741F180A5CEA23B2541141ED1B2832707410440AED2AE3B2541967DD09EE027074142A429A9CB3B2541427C31A4F027074104CAEB78D43B254106F0BF343D270741B179EBEE023C2541906D469A09260741180D173E563C254194B3C3AC0F250741F3D130FBBF3C2541649664E3E8230741CC9C659DD93C25417AC5145C1F2407411DC0E977023D2541D0C6B3560F2407411C4A271E283D254128A05CB868230741BDD126CF6D3D25412E5070863B2207418F464A2E583D254112F82A7A7E210741C59DFA6B773D2541EA71D4EF7A2007414DCFE8D98D3D2541487412E55A2007418E19CE7EAF3D25413E7373EA6A200741B4D8D682BB3D254152519836841F07418A3364B0AA3D2541A225C5AD1D1F0741A9E5A11BB93D254198D39A86101E0741BD1A6D799F3D25410045EB217D1D074116C17E46A03D25410AB4FDC7091D07417ECA6CEFCD3D25417293C10E131C074153AF37C3E23D2541628DA629631C0741086C02D20E3E25413006B1A46F1B07416288D6F8E93D25414025D718CF19074100E974DF363E2541D0CBF21122190741D1E7D5E4463E254180F7C59A881907414D268FEB5A3E2541E4900CCF8B190741DBAD8E9CA03E25410E9EE193DB1807412FF87341C23E2541B09BA39EFB180741B72962AFD83E2541383D43AD8E180741FC59B122FF3E2541C6E35EA6E117074150EDDC71523F2541ACF98C45C116074120767B1D883F2541329B2C54541607413B424FBA913F2541202B7BB3D7160741CDAFB839DC3F254166909584E4160741399F10B10E402541102560CE27170741B0F75FE91D4025413031969887160741EE5BDBBF3A40254178042415311607415AC1F59047402541E87613AB8D150741611707D4764025414E7ECD8A2D1507410F08FE4599402541FEC2ABA243140741396C791CB6402541F899160FBD1307419D8FFDF6DE402541D8145F7FA91207417274C8CAF34025410AB93C831C1207415FB5BFC6E74025411ABF5768CC110741CE14BFB2444125412A57FFA1DF1107418F83C72C7F4125410668B156FF1007415689D8E5DC412541B0FC7BA042110741324EF2A246422541B69384DF6511074160D9CE435C422541C4DAA0EC5B1007412DF2C57A67422541244B528DD80F0741B0FC521E8542254160AFCD63F50F0741166302BE2F432541729800CA25110741F63A02F946432541D09A3EBF051107417279BBFF5A4325411E05D57AD21007417279BBFF5A432541EAA1F89EA510074143781C056B4325413EA3979995100741E6EBA06965432541EC96EA848E0E07413885E79D6843254154083B20FB0D074130B913015F4325412E41E36DB10D0741C73963FE56432541E05DCBEC300C0741475E86D36F4325411899B12FC70B07417103F9A580432541D60BA1C5230B074104281C7B994325412C77D67BE00A07411401BBB0A04325412030BA6EEA0B074149586BEEBF432541FE2384A48A0C0741CDA3EF8DD14325413219EDD41A0D074103FB9FCBF04325418C432163910D0741C0C435731A4425418E94AC8FAE0E074153A8614C3F4425416EF6E970EB0E0741ED9858BE614425412C4CF187C80F0741610B3E286C442541D8B8C538750F0741463F6A8B624425418E94AC8FAE0E07413380618756442541C0A6FD3EBE0D0741832D2308A54425412013D2EF6A0D0741869DCA7CCF44254148489D4D510D074102DC8383E34425417CAB79297E0D07410D59F6900B4525414C079C250B0E0741BA08F6063A452541C0A6FD3EBE0D0741065A8B5FA94525418EB1940E2E0D0741D2BBC840E6452541AE4F572DF10C07411020441703462541448D7B65670C07417C855EE80F4625413036D5539A0B0741411BC82C434625410A010AF6B30B0741923E4C076C462541466585CCD00B0741CFA2C7DD884625410893964A170C074101140E4DA3462541E86247D7F00B0741796C5D85B24625414EFC8D0BF40B0741981E9BF0C04625419AF8B01B240C0741009E4BF3C84625410AE42177340D074184E9CF92DA462541761471EA5A0D07412444539477472541CEED194CB40C07413C6DE827FE472541D85C2CF2400C074192FAF891A1482541B2AEDFCEA60A0741B92FC4EF87482541141483550C080741DC548537BB482541A8A5A663A30607417D639D72A7482541A23797B2DD0507419E4DF919C5482541F6AA9AB6860507417BE60417C6482541C4AD1460F8040741FFBB793ABA48254162E9312162040741A903358D9E4825410A87C001170407412ED9A9B09248254104622978EE020741A67B4A05CC482541DE7D9C190E030741329B83B5E6482541588CB454FA020741047E533F0E4925414E2A4335AF02074167F7258CF4482541E003EFD6CD010741ED49330BCA482541921B32E3C7FF06418A5E1A8FF34825417A1F6961F2FE0641C3EEDC9945492541A003F6BFD2FE0641E655D19C44492541EE391F2E59FF0641F74A7F7053492541B8FFBE41A8FF064155BFCED985492541180D1AA8DBFF0641D8A56472A84925411E017C1661FF06412FDB417BA5492541A003F6BFD2FE0641460F62AFE94925414AD96AE3C6FE0641C9673E77FC4925414E477A948CFF064179EE6B2A164A254134C55E55F7FF06417F2DDE8A4B4A2541980F94514DFF0641929F24BA3B4A2541D8753CEFC2FE06418B1D097BA64A2541BC3C99D7CAFE06410E049F13C94A254194A184A087FE06412EE3A88EF54A2541C8245DB4D5FD0641B1C93E27184B254114ED767196FD06417BF003F5284B25419A95E60E0DFE06417BF003F5284B254172747F1A0AFF064150CD0436134B2541980F94514DFF0641A8909B0F204B2541EAFC449836000741A0D49053094B2541BC6DCEF26D0007418FDFE27FFA4A2541F6969CFAC0000741BC7F7A9AF14A2541E8F75045530107413FD85662044B254122A0C0E2C9010741F68CD500254B2541A454CE11BB020741B58B182C6C4B2541966C0A35B0030741DEA3C5BE904B25414E5B785052040741CAB4E633BF4B2541922F309F8D04074155578788F84B25414A1E9EBA2F050741C7BAB57CFC4B254108B301CAD6060741D0F35894F44B2541D4E6B08EEB0707410E899E82FA4B254186E1BC3B08090741925E13A6EE4B25412297873FB20907415C85D873FF4B25410EBB61F4210B07413524B3B93D4C254168D45AECCF0B07418C6AB137694C2541C86057E8260C07415D4D81C1904C25418CB8E74AB00B074114020060B14C2541E02BEB4E590B0741A6D2F19FF14C2541F6BE98724C0A07417AC013560A4D254118EC9DF8C9090741E51F247E3A4D25417A7649BD7A09074188EAC45A364D25417267D9626D0907413338DC801C4D2541FA6F100FDD0807414C894459184D25414AD580DBDF080741D834C34D134D2541D0BF6F7E97080741F855987CFF4C254138B3D022A5070741164527BBF04C254126E9698775060741E802D5DFF24C254160C7B9CE3A050741A93D007DEB4C2541F4EE8C2D9903074198BEB0CE0C4D2541AA21FA4200030741F73D5264304D254108F76E66F4020741FFF95C20474D25417E9777F01A0207411029FA70D74D254152BF8823B5020741819D49DA094E2541EE26E7ACDE0407418AD6ECF1014E2541C40580B8DB0507415D3655D70A4E254100E6D59891060741E08E319F1D4E254184516BA0E5070741B3EE9984264E2541D676022A0E090741831AE235EB4D254182CB18E325090741A681D638EA4D2541DA2D8A0271090741C660E0B3164E2541F81DB5F2CB0907414947764C394E2541A66139C7850A074190155F52374E2541C0148A21BE0B0741136E3B1A4A4E2541CE2D83196C0C0741F545B977804E2541C6B3CEED260E0741E156DAECAE4E2541949E058B9E0F07410BFD4050E34E2541C2DF0FB6E6100741DB62787E294F25412A1202A6421207416EB0021A4B4F2541B471F91B1C13074163FAC6A6714F25414E27C41FC6130741E4D50A13A34F25414088786A581407414455ACA8C64F25416E17EF0F21140741525029C51250254102A8228AA213074184A1796F2F502541AAC60FD53313074122B660F358502541147F54824F130741D1AED4D56250254188990A4FB61307418863537483502541045FAA62051407415A4623FEAA5025416E17EF0F21140741F54FB855E35025411AA4EB0B78140741A5D6E508FD502541C630E807CF1407415B0ECC4B3C51254192AD0FF480150741951B27B26F512541220169D8DF1507410690761BA2512541266F7889A516074149D67499CD5125410442730328170741D47815EE06522541301A62D08D160741193CACC713522541BEB633DC891607419C224260365225411619A5FBD416074115427B105152254198D2A67DA9160741AA1DBF7C825225414ED957A545150741ED63BDFAAD522541D0DBD14EB714074199620026F5522541D6CF33BD3C140741B213B9B51A5325414E27C41FC6130741B213B9B51A532541F645B16A57130741F9E1A1BB18532541D855867AFC120741D974DE6FDC522541D855867AFC120741DC6E0F279F5225413863E1E02F130741C53AEFF25A52254150AD16DD851207415E8DFC713052254156EAF072A8110741F5D4B7C41452254148D1F77AFA1007412A315A9B22522541149C8BE12C1007412A315A9B225225411A90ED4FB20F074178BB4D5D37522541CE104CBA8E0F074142E2122B48522541BA8292E97E0F0741D62F9DC669522541B2D7A8A2960F0741C3BD569779522541DEAF976FFC0E074139A96F13505225411ECDC7E5D40E0741AB9A57D8635225411C16400D720E07412C769B449552254186CE84BA8D0E07418CF53CDAB8522541AC6999F1D00E074178065E4FE7522541588D7A8F450D07417C3A7E832B532541F87F1F29120D074106DD1ED8645325418C1053A3930C074126BC28539153254118F69CD62C0C07416C0D79FDAD53254182AEE183480C074107170E55E653254128477C111A0D0741AE6498F007542541D84188BE360E07410BD9E7593A542541A255944C060D0741788B5DBE1854254166753E6C500C074131BD74B81A542541D421E587F10B0741870373364654254126DE60B3370B07417F47687A2F54254108EE35C3DC0A0741C048254FE85325418A2896AF8D0A074183419931F25325410C2B1059FF090741A1A30A513D54254168CA5B0E6D090741D5FFAC274B542541C4E84859FE080741A7E27CB17254254158797CD37F080741C5D2A7A1CD542541FE5F83DBD107074135B93D3AF0542541E06F58EB76070741EAB63400AE5425416E0C2AF772070741C110CE9C79542541CC62FD8443070741A565E45591542541A61555C8800507419DA9D9997A54254150EBC9EB7405074147F194EC5E5425418420368542060741E871F3563B5425411037B5D37E0707412784D1A02254254184516BA0E507074107170E55E653254156C2F4FA1C0807418F746D00AD5325412A3872A8370707414267129A7953254192392F7DF00607413C28A039445325419082A7A48D06074131387549E952254174CF564A5505074121C05FD1BB52254138EF006A9F04074186B6CA798352254142203D6E47030741BC014CDB62522541B4523647A8010741D62F9DC6695225416EC7F61F0A010741F819F96D87522541A601570CBB0007413432A600AC52254188112C1C6000074165941720F7522541443D74CD240007416389C5F305532541AA3E31A2DDFF0641EBE6249FCC5225412E79918E8EFF0641D3356C0FA75225414A31D63BAAFF0641D3356C0FA7522541D45F9896E0FE0641A695D4F4AF5225416045E2C979FE06410F4E19A2CB522541ECA9CD9236FE0641EA698C43EB5225412C107630ACFD0641268239D60F53254164D028DA1CFC0641C3BD569779522541B68CA40563FB064115427B105152254110D7D218B4FD0641807758194E522541C8FD267795FE0641F4571F69335225416821012C05000741EC9B14AD1C5225416821012C05000741D47815EE065225410E89669E33FF064135E7950EFC512541788F17C6CFFD0641EEA666D90D522541CA4B93F115FD064196E3CFFF00522541DC27B93CA6FB06413CA3A0CA12522541D60222B37DFA0641A955162FF15125410A86FAC6CBF90641727CDBFC01522541EC95CFD670F906412BAEF2F60352254134A761BBCEF80641D5F5AD49E8512541E4B9B074E5F706419860685BE2512541A422D3BBCCF606416F82AA453F522541924BA1C31FF70641DAB7874E3C522541BAB580DFBFF5064174F97358E35125413CB8FA8831F50641B40B52A2CA512541F62CBB6193F406413C69B14D91512541EACA494248F406414CD0A55090512541A6C55CD869F20641A4933C2A9D51254136B09A5EE6F00641AECCDF419551254184B58EB1C9EF064195A240CA7A51254112CC4BBFF2EE06413F63E20454512541E0A246E1B7ED064164476F6334512541F604BFE907EB0641DFE3406F30512541BAF333EEAEE806418FDCB4513A5125416854EF2146E606418631CB0A5251254166BA9EA8C0E20641CD9BCAF36F5125413C7BBFCE1FDF06411E1932D3735125410800F98AA7DE06415514F770785125414E69B358A0DE0641458B175881512541DAE9718392DE0641577EB416AA512541E228800C5DDE06417C503078B451254162A9606D4FDE0641C1B50242FA5125419CEB982D12DE0641E2D468E7265225416C6273FFEADD06417E521FF53B52254132F9F386D8DD0641D1D03AD95C5225416C23E6E9A3DD0641E125F579805225418C1C03E76ADD06415C4AC3D8A75225414AA589BE17DD0641398BFFC2D2522541821CDA3ABDDC064173391E4F1C53254116737D5636DC06419F0F00B338532541004BB94802DC0641D455345845532541E0747056E7DB0641B6324822745325416856BDA083DB06410CE319F5A853254156996B0B13DB064152FBF5B1E85325419EEBF8CF64DA0641ED40993FFC532541CCAF38662FDA06418B7121C1FE532541B20ED48528DA0641F3DCA89E0C542541EE1BF48908DA0641E63E8E763654254134D3821BA8D90641374084643B54254170C3D0C09CD90641B3E38EC06354254140F1057A46D90641206E70057F54254158D6261B0CD9064153C94FB8835425418EB27864FFD80641B000A6DF9E542541F42C968CB6D806410F6A0A78A85425417EB2E0B89CD806412D57BA2EC1542541869A095B5AD80641736DF769C454254184B24FB851D8064178D322CCF6542541D0909401F6D70641F4F7B8AB1155254136019A26C5D70641F3FBFE351A552541CEC19666B1D706418024DB9F3D552541485E199A5FD70641669F4D4F6E552541C4DE3F19EFD60641DAF3CE5A7355254136ABDF07D7D60641A1CAB1D4A1552541286D30F1F9D5064100B38AE9B8552541D64164E2CDD5064199C6AF07C55525415474B69DB6D506414E95CEEDD5552541EC51853C8ED506413929EE77DB55254172808DF680D506415DB20510DF552541B2D54B6878D50641D6258900175625418E901D50F6D406419C7DBF7E2B56254114D2DF65ECD40641A5FE1EC130562541885B393EE2D4064168EA3C4A3E56254174EBA218C8D40641109CCC8B6B5625416A3835DC70D406410EEBB99C88562541D464DB96FDD40641EB61DA8391562541BE1F452ADED406419E7B30F29D5625410AEA596DB2D406413C2BF570A15625412ABC8C08A6D4064196FC6F31D55625412E0544CA0DD406413CF96E7A0A5725416E826248A5D30641733B5D950E5725412A9BEAA59AD30641935ED14537572541BEBC750531D306414D4C1214495725415A17FBCD02D306415133C9F96D572541AC260ED293D2064107815C5C8C5725414AFA336D38D20641D04065459F5725415C88129C0AD20641049CEC75C9572541A4BC5757A4D10641DC741E76E95725410410BFC756D1064137F96AAA0A58254130132F1DECD00641387AD62A2F582541282BA924B2D006413D5F060B56582541A66713E382D00641BFD2453E6258254156072F1874D006412742F3A2AA5825410E4CD082B4CF064134AA614DAF5825412E1E031EA8CF0641B00484A7CD58254108E2765E41CF06415782EE7027592541CAE4B65C11CE06419649BAD7455925413CCA1253BDCD0641E94A90C27C5925413AC113A425CD06412A8F811FB759254140CC10518FCC06410B6E8CEDFC59254186749E87D6CB06414BB29D4D055A2541FA028461C0CB0641A86AB7771F5A25417048C4227BCB0641E8B02FDA575A2541FE4299CA0CCB06415D0788E6A55A2541D20641B574CA064191E14B14D15A2541B6AE249720CA0641EA7C72D90D5B254156491C1FBBC906414D0372541A5B25416C41F71B84C906417A0FE0323A5B2541A4A58D3C26C906413DFD84C1455B25419CB3EF4004C90641F89F8E075C5B2541428857DCA6C80641BDBD2A00715B25414275402A27C80641E5675B848C5B25417835D9687FC7064171D97772945B2541F2EF00FC61C70641E4B2020BA15B2541DE9C3C3533C70641917D77A6AF5B2541EC84312D22C70641F19BA4B6BD5B2541BE87662DD1C60641017063D5D55B2541C20B3857DCC5064142358833285C25410CF4374DECC40641DDFB2643475C2541B2BE87E5A6C40641FFD1DC65765C2541165B036E3DC406417D628B3A985C254132A008DA11C40641EA672B739F5C2541F4CC8C9308C406417714AE47B55C2541DEF5285CD1C30641FE285C0FD05C2541CA1E85EB01C40641420AD7A3DD5C2541FE84EB51C2C40641D4A3703DE65C2541BEA3703D3CC50641315C8F42D55C2541C6F5285CE9C50641656666669E5C2541A0703D0A45C606412B333333955C25419447E17A54C60641B047E17A8A5C25412CAE47E1DEC606412185EB516E5C2541320AD7A330C7064190C2F5A8545C2541B0C2F52844C70641D1CCCC4C3F5C2541E47A14AEB3C7064117AE4761335C254110295C8F66C8064155B81E85345C2541183333337FC80641C7F528DC3A5C2541EEFFFFFF07C90641020000803B5C2541DA1E85EB15C906416C3D0AD7295C25415CB81E85C5C906415D8FC2F5045C25412E0AD7A33CCA064100000080F35B2541BC703D0A75CA064185EB51B8E85B25417614AE47DDCA064154B81E85EC5B25412C33333305CB06411885EBD12D5C2541608FC2F5BCCA0641C01E85EB365C254138B81E85D3CA06411985EB51535C2541FAFFFFFF19CB0641EE285C0F585C2541D67A14AE25CB06411DAE47E1535C25417E66666692CC064152B81E85535C254146E17A14B2CC06417BEB5138575C254134AE47E1B4CC06416C666666715C2541AC1E85EBC7CC064163666666955C2541FC84EB5130CD0641A0703D8ABE5C25415C3D0AD761CD064195C2F528CB5C254112D7A37061CD0641255C8F42D65C2541C6703D0A61CD06417814AEC7EE5C25418E703D0A7BCD0641A947E1FA015D2541A2F5285C8FCD0641225C8F420F5D254158333333B1CD0641CEA3703D165D2541F6AD47E1BECD0641713D0A57215D25415EEB51B8E0CD0641F9285C0F2E5D254158B81E8507CE0641BDF528DC385D25414C66666628CE0641050000005B5D2541300AD7A368CE064108D7A3705E5D25416E14AE47AFCD06412D5C8FC26C5D254130D7A37071CD0641A847E1FA825D2541A499999961CD06410FAE47E1AF5D25417A3D0AD769CC064142E17A94D45D25418AC2F52816CC064131333333E05D2541903D0AD7D7CB0641C5F528DC195E25416E666666A2CA0641040000001E5E25410C000000AACA0641315C8FC22A5E2541EC7A14AEC1CA0641959999192F5E2541445C8FC2C9CA0641558FC2F5525E2541A41E85EB4BCB0641BA1E85EB5F5E2541D2285C8F5ECB064180EB5138655E254170C2F52866CB0641FAFFFFFF975E2541668FC2F552CB06410BAE4761B75E2541B247E17A6ACB06412485EBD1DA5E25419414AE47BFCA064137333333005F254108295C8FE8CA0641E07A14AE065F2541EC7A14AEEFCA0641DFA3703D205F2541F6A3703D30CB0641F6285C8F2C5F25414E0AD7A360CB06413A333333375F254112295C8F8ACB0641340AD7233C5F2541B01E85EB9DCB0641C9F5285C815F254112333333CBC90641C7CCCC4CA95F25412EE17A14F2C9064149B81E05B85F2541F27A14AE4FCA064196999999B55F254164EB51B8D4CA06419D999919C55F2541E2FFFFFF4FCB0641A5703D0AE35F25412EAE47E194CB0641D77A14AE32602541823D0AD70BCD0641E67A14AE7C602541A8703D0AFDCD0641B847E1FA94602541BC99999961CE0641693D0A57BF6025419A47E17AE6CE064103D7A3F0E26025419CF5285C65CF0641BDF5285CFA6025413E0AD7A358D00641C4F5285C15612541903D0AD70BD10641255C8FC21E61254192999999CFD106410EAE47E123612541F2A3703D3AD20641293333333C61254198EB51B8FAD20641A847E17A30612541F4AD47E19ED30641A847E1FA24612541B247E17A40D406412085EB512C612541480AD7A3C8D806412785EBD13B612541BA703D0AA9D906412B3333B34D6125418866666636DA0641F9285C0F6B6125412C333333C3DA0641A9703D8A756125416EB81E85F5DA0641B11E856B7F61254150E17A145EDB0641F9FFFFFF84612541EC51B81E99DB0641FFFFFFFF99612541E47A14AE77DC0641225C8F42A5612541B6CCCCCCEEDC0641BEF528DC8F61254192C2F528ACDD06419799999989612541AA999999E3DD064196C2F5A88361254196C2F52814DE06418BEB513851612541FCA3703DB0DF064153B81E8531612541603D0AD721E006412385EBD12C612541540AD7A38CE006415BB81E05166125418299999923E106415F6666E6106125415AB81E8545E10641A8703D8A19612541688FC2F504E20641E97A14AE236125414AE17A14E6E20641A9703D0A28612541AA47E17A00E306419299991944612541B8A3703DBEE20641CEA3703D536125418E99999963E30641C11E85EB3C612541D4285C8F20E406416F6666663E6125410085EB519AE40641F1285C0F39612541E4FFFFFFEBE4064188C2F528346125410E52B81E37E5064112AE476124612541809999999FE50641C11E85EB2561254106AE47E104E6064119AE4761286125413AE17A14A8E60641A8703D8A44612541763D0AD701E706414AB81E853E612541DCCCCCCC7EE706419D703D8A3461254144E17A1402E8064151B81E85566125412EE17A140AE80641C0F528DC67612541AA999999EFE706413A0AD7A36F6125413A5C8FC2E3E70641E27A142E70612541E8CCCCCCD0E70641323333B37C61254106295C8F0AE60641588FC2F59061254102AE47E1C2E40641DBA3703D97612541C6F5285C5DE406412D3333B39561254176C2F528B6E30641205C8FC293612541F8285C8FE4E20641DDA370BD91612541B0CCCCCC0AE2064140E17A14906125419014AE4759E1064196C2F5288F612541BCF5285CF3E00641E551B81EEC61254102295C8F9CE006419599999907622541EAFFFFFF59E0064191C2F5281B622541A4EB51B820E00641A6703D0A52622541C81E85EB7FDF064109D7A3F05B62254120D7A3703DDF0641343333B35F622541EEA3703D24DF06411CAE476167622541E451B81EC7DE0641C4F528DC81622541EAA3703D86DD064105D7A3708362254192703D0A73DD064155B81E8584622541408FC2F554DD06417CEB51B88A62254152333333ABDC06414AE17A14916225411A000000FCDB064150B81E0595622541DA285C8F90DB06410500008097622541020000004CDB06417DEB51389962254146E17A143ADB0641578FC2F5AF6225414AB81E854FDA0641D2A370BDB76225410252B81EFFD906410DAE47E1C36225412CD7A37081D90641E651B81EE3622541DA1E85EBADD90641F7285C8FE86225419C999999B5D90641548FC2751F6325411E5C8FC203DA06415D66666640632541DEA3703D6CDA0641E57A14AE3E632541C6703D0A85DA0641BD1E856B386325414E3D0AD7DFDA06410BAE47E1586325413A33333321DB06410ED7A3F05E63254164B81E852DDB06417514AEC7636325417A999999CFDA064192999919B0632541A6EB51B8F8DA0641E57A14AEF0632541CCCCCCCC26DB0641FD285C0F11642541F2FFFFFF99DB06412C5C8F4207642541B447E17A6ADC06413B333333D0632541B247E17AE8DC0641235C8FC2846325414EE17A14B6DC0641050000005563254116D7A37019DF064180EB51B84863254100295C8FB6DF06415E8FC2F53463254132333333B3DF06412185EBD1F762254192EB51B862E00641CCCCCC4CC26225418A999999EBE00641CFCCCC4C896225414033333319E10641F651B89E72622541C8A3703D42E206415C8FC275716225417CEB51B88EE306413B3333B37A622541A8703D0AF7E3064188EB51B8866225412CAE47E14AE4064192C2F5A896622541E27A14AE9DE5064165666666A96225416E14AE4743E606415D6666E6B062254124000000D8E60641205C8F42D5622541DAF5285C3FE706417CEB5138EC62254142333333B1E706413A0AD723496325415E6666669CE6064151E17A149D6325412C5C8FC24FE6064103D7A3F0D26325411E0AD7A364E60641215C8FC2EB6325415614AE479BE606414AE17A14096425411485EB514EE70641F6285C0F106425411A295C8F5AE70641305C8FC2386425412085EB5122E70641989999198B642541C8F5285C53E7064157B81E05A96425417A99999947E70641B61E85EB276525415E6666666EE60641A7703D0A48652541748FC2F554E60641D4A370BD576525410652B81E27E6064110D7A3F0BC6525417814AE47D5E40641C01E85EBFA6525418014AE4741E406411E85EBD14B66254160E17A14B8E30641030000005366254126AE47E186E306414AE17A94806625415C3D0AD753E206412A3333B38F662541663D0AD7EDE10641DAA3703D97662541AAF5285C91E1064186C2F5289E6625419EEB51B83EE10641B21E856B9F66254160B81E852FE10641A547E1FAA5662541468FC2F5E0E00641B747E1FAB6662541A2F5285C15E0064108D7A370CC662541E4285C8F84DF06412C5C8F42F76625411E33333363DE0641255C8F42F666254118D7A3703FDE0641606666E6E2662541A0F5285CCBDD064143E17A94D8662541F2FFFFFF2BDD064194C2F528D1662541AE999999B9DC0641EC51B89ED0662541468FC2F5DADB0641B547E17AD06625414AE17A14A2DB06417BEB5138D0662541EE7A14AE37DB064104D7A370D4662541300AD7A384DA0641783D0A57D5662541BA703D0AA9D90641DD7A14AE07672541388FC2F5E2D806417614AEC708672541DA51B81E95D806418CEB51380967254160E17A1476D806419F999919F86625419EEB51B8EAD70641F0285C0F026725416AEB51B836D706417114AE47446725410685EB518ED70641215C8F425767254130B81E850DD80641AE47E1FAA0672541A699999975D806415F8FC2F5FB672541FE7A14AE7DD806418DC2F528316825418A66666682D80641A1703D0A3A682541F051B81E03D806410EAE476145682541C0CCCCCC60D706417214AEC7466825419C14AE47F3D606411B85EB514A6825417E14AE47DBD506412D5C8F4275682541FC84EB5106D6064111AE47E19B6825413C333333CBD50641CDA370BD9F682541DAF5285CC1D506417C14AE47B5682541C01E85EB89D506417F14AEC7B56825416C666666D0D40641BAF528DC96682541540AD7A342D40641EE51B81E85682541380AD7A33ED40641C01E856B89682541EE51B81ED7D3064148E17A94A46825419C14AE47ADD306410BD7A370D4682541488FC2F53ED30641DBD988B5D4682541E2E9006A3FD3064107D7A370DC682541C07A14AE29D30641BE1E85EBFB6825417A8FC2F51CD506416F53057700692541908662A38AD5064111E889D71169254196D3E96812D60641F7603D02386925411EE40670C9D606416F1FC0FB5E692541CA3053E06AD70641BBD144157F692541360FC880D4D70641EC795254966925419E45863E49D8064149B1387D98692541FE7519A44FD806410D9B0780B4692541FEAF1AB8A2D806412056D506CC692541A035C9E51CD90641F7321512E869254152C69D6CAED90641C49F92DDFA692541046BA2F90FDA0641FF029AE4166A254126BEFE6BA1DA0641E5C2068E236A2541DCDA2D2109DB064121D9DF082D6A2541D83F2FEE56DB0641AF35196A306A254136013A8472DB0641783C1351366A2541147D3803A2DB0641084E152A3E6A25413444DDF0E0DB06411D3DB0A64E6A25412AC6411D65DC0641E3925F1F656A2541DA94D0B8F4DC064178085ED77B6A2541F42B7AEC8FDD0641D43F44007E6A25414E30CB989DDD06413328E595886A254116C3921FE0DD0641D38CAA0B9D6A2541A6B64CC760DE0641A54ED639B46A2541F63C02A0F2DE0641D4C2A684B96A2541F2C8EDCE13DF0641FA7FC391C26A2541C6DE398142DF0641E7C6948CE76A2541163E05F800E00641D643BA82036B2541347D650E91E00641DA2842E5046B2541EC13AB4098E00641D1284E23246B25412068150959E10641B14E1270506B25417C8466BF56E20641235FDE0F6E6B2541B6B0966E00E30641C0B9C216856B254114F534CBDEE206417AE59CF2656C25417A557004C0E1064137BD7AD1EE6C2541CC75CF61D5E006411361CF264B6D2541B4A5B446AEE00641E848A4FCC66D25410236DF6FF3DF0641EC74EF47D76D2541F68541D382E00641D09462BB026E2541DEB5AB3DA1E00641C55067C0286E2541902581145CE10641BB4CCD26606E2541BA35780B4FE106418EAC2681E26E2541F0F587196DE006417C1095EFE76E25412096B34430E00641923C5BB5B26E2541408637C8F7DF0641A78475CF9A6E254152C68E1E7EDF0641ACB879D3816E25418C16D3606CDE0641A5200761956E2541BCB6831175DE06419E6487E1B46E254118F755E2B5DD0641923C5BB5B26E254150B7EA7519DD06418838C11BEA6E254178C7D76181DC06417740FF59066F2541B0876CF5E4DB064197CC146FC86E2541EE676AF1E8DA064197B0C01AAB6E25415EE89D233BDA06419A383C96A46E25419CC8169AF9D8064187F85FBAD86E254128A91496FDD7064173300863136F254160692EAFA6D7064175F8E43F1E6F25417CC9F87858D7064175B883DE0C6F2541D609C13E0ED6064173F0A601026F254116EA43C057D5064160B0CA25366F25417C4A7FF938D406419F8894EEA86E2541D88ACC4434D30641AA30FE57886E2541BEAB9206EED00641A110106AA26E25411AECDF51E9CF064125FBA5508D6E254106B4D5BFDECD0641A8703D8AEF6E25413EE17A14A2CD0641D4A3703D976F2541285C8FC281CD0641221862BED46F2541B60CB01E2ECE064115683F9C1E702541124DFD6929CD0641F987B20F4A70254142EDAD1A32CD0641AD3F278632712541708D54C0AFCC0641AD3F2786327125416E8D4AB524CC06419BBFE948557125419C2D76E0E7CB064161F71677D5712541D4ED8FF990CB064146D7AD0E35722541AE6D52BCB3CB064146D7AD0E357225414A0D1783D2CC0641335770D1577225414A0D1783D2CC06413397D13269722541920D036DBCCB064128EF67C989722541920D036DBCCB06410ED7B719C0722541C8CD970020CB064101E73396F8722541028E369F0ECB0641EC1EDC3E337325418AED99041CCC0641D03E4FB25E732541B88D40AA99CB0641DADEFF62677325410AAE9F07AFCA0641ABBE96FAC6732541700EE54B1BCA0641A25E47ABCF732541D66E2085FCC806418B0E74D810742541FAEED83C94C80641877E3FA4407425410A2FAB0DD5C7064174BEA005527425415E4F0A6BEAC60641424E64CAF2742541FC6FE442BAC506412426BD23367525414E9043A0CFC40641088691F87275254156B0AC0870C40641FC9DC62D827525412A10106E7DC506419C4D82EB937625413C5067C403C5064180AD56C0D07625414E90BE1A8AC406418375339DDB762541F4D086E03FC3064139F5FF6A897725410E31479F66C20641571DA711467725410892F34777C006417E25DB44D77625411AD24A9EFDBF064193ED329C9C762541B6F29FF087BE0641AE8D5EC75F7625412473C9174FBD0641BA35C8303F762541CAB30C58BFBB0641D48DD9411A7625410C948FD908BB0641DAA589F1E37525417814347B8AB90641F1751F87C5752541CC349DE32AB90641012E80E7977525413AB5C60AF2B7064112E6E0476A7525417075D61810B7064124E65BC224752541B255DE1F9FB606416B1E75DA8E7425416855E82A2AB706418E16B2162D74254184B5B2F4DBB60641BCB658BCAA73254160B68AC8AFB40641D95E3DA0447325414E76AEECE3B4064107FFE345C27225410E962B6B9AB506413F3F3B9C48722541A635E6262EB606416177D939F8712541CEB5A8E950B606415A5FA404E971254132976AA312B206418167D8377A7125417477F72FE7B10641A4539EF82F71254190E2B420A0AC0641D14BB778EE7125419A82CC4A3EA806417BF43F0E7673254166929A4AC1A60641A8EC588E34742541567DD3745DA3064132A2FC838A76254160A35F9F74A20641455C0F641977254146AB461FB6A1064158162244A8772541CE7ECAC98DA006416C714711EF77254158A3F3FE8F9E0641588FC275487825413A333333CB9F06416C3D0A5765782541F4A3703DE89F064140E17A14C0782541EEA3703DD09F064188C2F528FC782541DEA3703DF09F0641DDA370BD03792541DCF5285CFB9F0641FD285C0F00792541320AD7A3E69F0641CACCCCCC14792541EAD6A370B39F0641BFF528DC04792541F6A3703D6A9F06417F14AEC739792541EA7A14AE3B9D0641305C8FC252792541AAF5285C8B9C06410FD7A3F086792541CA7A14AEE99B0641A9703D0AFB792541185C8FC2219B06416D3D0AD7727A25413C8FC2F5249A0641548FC275FE7A25417E14AE47F398064157B81E05697B2541E47A14AE4B98064118AE47E1E87B2541BA1E85EBAF97064184EB51B8FC7B2541A49999998F970641390AD7A3AB7C254176999999699606412F5C8F42FA7C2541B49999990B96064116AE4761917D25410C295C8F22950641D3A3703DEE7D2541A014AE4793940641BA1E856BFE7D25410E000000B694064106000000137E2541A8EB51B818950641A09999192B7E2541CC1E85EBDB95064116AE47E1377E25419AEB51B8C295064157B81E85507E2541A4C2F5289C950641733D0AD7D87E254132B81E85C7940641568FC275FF7E25416A14AE478B9406416F666666427F2541CACCCCCC04940641C3F5285CC57F25413CB81E85FD9206418CEB51B8D37F2541D47A14AEE7920641C11E856B57802541B0CCCCCC1E9206418EC2F52897802541B4999999BD9106417D14AEC7A5802541EEA3703DDA92064186EB51B8AF802541E4FFFFFF9B93064191C2F528BA8025416014AE4767940641A6703D8AD180254164B81E859594064158B81E05DF8025417AC2F528B0940641E351B89EE680254190703D0ABF940641B647E17AF380254156666666D8940641E37A142E0381254168B81E8561960641A8703D0A0E812541E0CCCCCC709706411B85EBD17E812541F0D6A3706B960641333333B3AD81254186EB51B8D69506410BD7A3F0B2812541FAA3703DC695064102000000BD812541BEA3703DA6950641B047E1FAC9812541BA703D0A7D950641F351B89EFC8125419447E17ADC940641CEA3703DA08225411C0AD7A3F8920641DC7A142EBC822541C2703D0AAB9206415D6666E6DE8225411A295C8F7093064149E17A94F2822541EAA3703D7A9306416C666666068325417C3D0AD7AD9306414AB81E051B832541D07A14AEE393064192999919408325410685EB516A940641C3F528DC44832541BC1E85EBF39406417914AE47E3822541F27A14AE0F960641F351B89E04832541663D0AD7E197064148C3CC210C832541F231D81CC597064133F98232B3832541A471EA736B9C064179A67AB273832541CE3B9049D19E06417593341DE8832541244A67F423A00641551728DD88832541DE93919FF1A306418D1D53124682254144B72F20A8A806410F27F6DC0B8225419808414BB7AB06414F96E7BC9C8125419025EFA05CAE064109E9EF3CDC812541E433C64BAFAF0641AD995F52A5822541840B4C7737B606415E666666AB8225415266666658B60641C7CCCC4CDE8225418CEB51B84CB70641EF51B89E4E8325415A8FC2F56AB606412685EB515783254172EB51B89CB60641E17A14AE748325415A8FC2F544B7064149E17A14C7832541B0703D0A95B60641B81E856B06842541CCCCCCCC26B6064180EB51B86A84254150E17A1478B50641F251B81E858425411000000046B506411B85EB51EA8425416EC2F52886B406411D85EB514C852541205C8FC2CDB3064119AE47617C85254106D7A37073B3064157B81E05CB852541C8F5285C67B206417F14AE47D1852541DCF5285C53B20641225C8FC21B86254108D7A37063B1064187EB51B8818625410A5C8FC233B00641C5CCCC4CB9862541C4F5285C65AF0641303333B317872541E87A14AEADAE0641293333B36C8725410085EB51EEAD0641AD703D0A878725418E14AE47C5AD06418AC2F528A18725418CEB51B89CAD064119AE4761E8872541CA1E85EB2DAD064108D7A370198825416614AE47B7AC06410CAE47E11F882541045C8FC2A7AC06415F6666E6408825419A1E85EB57AC0641BC1E856B4F882541AAC2F5282CAC064188C2F5A8558825417814AE4719AC0641C6F5285CB88825417C14AE47EFAA06419B703D0A198925413AE17A14EEA906410BD7A370B1892541E8285C8F38A8064149E17A94C9892541B047E17A9CA8064137333333D289254192C2F528C0A80641390AD723DB89254124AE47E15AA90641BE1E85EBDB892541300AD7A368A90641255C8FC2DD892541D6A3703D88A906414EE17A14E4892541B4999999F5A906412385EBD1E88925412EE17A1448AA064117AE47E1E9892541ECA3703D5AAA0641225C8F42F4892541C2CCCCCCEEAA06418314AEC7FA8925411685EB514CAB06414CB81E050F8A2541E8D6A370C3AB0641DE7A142E1D8A25419699999951AC06412D3333331E8A2541D8A3703D7EAC0641235C8F42258A254124333333AFAD0641773D0AD7268A25418C703D0AF3AD0641E951B89E278A2541F0D6A37025AE06415C8FC275288A2541040000005CAE064197999919298A2541608FC2F586AE064108000080298A25410652B81EA1AE0641BEF5285C2C8A2541F0D6A3705BAF06416C3D0AD72D8A254146E17A1474AF0641420AD7A3328A254120000000C4AF06412F5C8F42388A25419899999921B00641340AD723398A25411C295C8F30B00641733D0A573A8A2541A4C2F52840B00641DC7A142E458A254110D7A370CFB00641410AD7234F8A254178EB51B852B1064105000000578A2541CC51B81EA5B106412D5C8FC23A8A254162EB51B8E4B1064182EB51B83C8A25410A295C8F32B20641CBCCCC4C458A2541508FC2F576B206418AEB51384C8A2541B2C2F528AEB20641CCCCCCCC538A25419C47E17AEAB20641A2999919508A2541047B14AE0BB3064184EB51B8428A2541BAA3703D84B30641B91E856B428A25414C33333395B306418114AE47428A2541065C8FC29BB30641450AD7A33E8A2541BCA3703D6AB40641A6703D8A3F8A2541120000006CB40641C7CCCCCC2D8A2541E6285C8F7EB506412E3333B3158A2541D4CCCCCC3EB6064109D7A3F00F8A2541F47A14AE43B6064191C2F52876892541460AD7A3D4B6064184EB51B8E1882541E051B81E9FB70641F551B89EC288254186703D0A71B806411EAE4761C0882541583D0AD7EDB80641C8CCCC4CB9872541CCF5285C1BBB0641616666E6D9872541D0CCCCCCE4BB06410D348529FE872541BED7BE2D9ABD0641702DFABD8487254170BF4E89A2BE06412FF6D0F9948625410254960F28C1064177FA5D6BA78625410E1E4B50AFC10641BD3F4E79BE86254150BD7D217EC1064128C6A123DA86254126330C880BC2064159E30DBC9F862541BC09681DCAC20641D54D15C3E5852541466786DF5FC40641693BE33AE7852541D49ADB942EC50641C6CCCC4CB4852541D447E17AA6C506417BEB513858852541E051B81E55C60641DFA370BD5385254102295C8F5CC706413F0AD7A34E852541480AD7A302C8064110D7A3F04F852541425C8FC27FC806411F85EB5152852541BE99999967C90641CDA370BD208425418C14AE4781CB064189EB5138278425414E8FC2F5B6CB06410DD7A3F03B842541D01E85EB65CC0641C7F528DC47842541448FC2F5C8CC06414A543EC50A8525414E99E3926FCB0641EE51B81E148525416AE17A1450CC0641370AD7A31C852541E6A3703D86CC06414FE17A143D8525419847E17A5CCE06410500008096842541506666666ACF0641360AD7A3CF8325410C5C8FC2C3D00641420AD723D78325418214AE470FD106412085EB51F48325415AE17A147ED206418AC2F528FF832541FE285C8FE2D20641303333B3108425418299999925D30641F8285C8F388425411E00000096D406412C3333B343842541D051B81EFDD40641D2CCCCCC5A842541BC999999D3D506410CAE47E19D832541B047E17A58D70641E951B81EE08325419AC2F528A4D90641EC51B81E0384254152666666DADA0641DD7A14AE1784254100AE47E190DB06411985EBD112842541D0CCCCCCBCDB0641E651B89E0D842541465C8FC2EBDB0641450AD723F7832541528FC2F5B6DC0641989999191E84254182703D0A37DD0641373333B37E842541D4A3703D74DE0641F6285C0F1384254194EB51B8E4DF0641D6A3703DDD8325414C8FC2F59CE00641265C8FC2798325418014AE47A7E10641683D0A57288325417414AE475DE20641AA47E17AB18225412AE17A1426E3064158B81E85D2822541C87A14AE63E406417414AEC78382254106AE47E1CEE40641656666E6758225418A47E17A08E6064113D7A370748225418299999929E60641A547E1FA748125418AC2F52816E70641D5CCCC4CCD8025417699999915E8064109D7A370EF802541B2F5285CADEA064114AE4761C0802541F2A3703D4CEB06414BE17A94BA802541C047E17A72EB06419D703D8AB0802541AC47E17AB4EB0641E07A14AE958025415C14AE4765EC0641C8CCCCCC698025410EAE47E1E2EC0641AD47E17A0C8025416E666666EEED064159B81E853B802541E6D6A37037EF06415CB81E857280254112000000BAEE06417114AE4770802541A69999999DEE0641BEF5285C908025415814AE47EBED0641D2A3703DB0802541BCA3703DA8EC064189EB51B8BB8025415CE17A1426EC0641DF7A142ECC8025417E8FC2F5ACEB0641DDA3703DEE802541BEF5285C2DEB0641353333B3048125415E8FC2F512EB0641440AD72346812541E2F5285C27EB0641723D0A578F812541E27A14AE21EB0641440AD7A3008225411E85EB51B8EA06415E8FC2F51882254166E17A148AEA0641969999994F822541843D0AD7DBEB064118AE47E14F822541923D0AD70BEC06413E0AD72350822541843D0AD737EC0641BFF5285C508225417214AE475DEC0641EB51B81E01822541B8A3703D6EEC0641F7FFFF7F0E82254166E17A14F6EC0641B41E856B8B812541C6CCCCCCF0ED0641548FC2F517812541B4999999CDEE0641D2A3703D208125415CE17A143EEF0641B41E85EBFB802541F6FFFFFFBDEF06418114AE47BD802541528FC2F516F00641440AD7A39F80254196C2F5286CF00641060000007F802541485C8FC267F10641E47A142EB0802541568FC2F52AF106416C3D0AD7188125418866666602F006419599991939812541F0A3703D9AEF06411F5C8F42718125416C8FC2F5E4EE06417B14AE47208225410485EB514EED06419C703D8A53822541A247E17AA0ED0641628FC275058225411800000076EE06410FD7A3F0D581254154E17A14F8EE064119AE4761AF812541F0A3703D9AEF064162666666C38125411A5C8FC241F00641929999195B81254116AE47E126F1064187C2F5A8258125410200000074F10641B61E85EB18812541981E85EB5DF10641343333B3D3802541403333330DF20641DCA370BDF3802541FC285C8FDCF206412A33333398812541CE1E85EB93F106413B0AD723058225418A666666BAF00641753D0A5708822541EC51B81EDBF00641BBF528DC0A822541CCA3703D04F106418CEB51B811822541DC7A14AE73F10641EA51B89E298125414A66666602F40641CFCCCC4C53812541D6285C8F20F50641F2285C8F5E8125414CB81E854FF5064196C2F528D481254180C2F5283AF706412933333330822541D6A3703DDAF6064105D7A3F04C82254186666666BCF606417CEB5138AD822541ECD6A37009F6064152B81E05E0822541FEAD47E1AAF506412C333333EB82254132E17A1496F506417B14AE4742832541360AD7A3E4F406418AC2F5A86F832541EAA3703D88F406417BEB513887832541DCA3703D58F40641BCF528DC9C832541C8CCCCCC12F50641B547E17A2584254198EB51B820F70641393333B32E8425414E33333315F7064151E17A144F84254196703D0AEDF6064136333333738425413085EB51C0F606411BAE4761A584254180C2F52882F6064136333333C98425418C99999941F70641693D0AD707852541BA1E85EB8FF80641D87A142EAC842541E4F5285C31F9064140E17A1458842541DEFFFFFFC5F9064190C2F5282B842541BE7A14AE39FA0641BE1E85EB0F842541623D0AD775FA0641255C8F42F2832541F6FFFFFFA3FA06414EE17A94CD83254122000000E4FA06415BB81E05998325410E52B81E31FB06411D85EBD1838325410200000052FB064107D7A3F0468325412E85EB51E8FB0641F151B81E3583254134AE47E1EEFB0641B31E856B17832541543D0AD7F9FB0641B9F5285CED8225415C14AE47B5FD0641315C8F42B882254108AE47E11AFE06410EAE476117832541580AD7A30CFF06410CAE4761258325415E66666630FF06414DE17A147A832541BC9999990700074184EB51388E8325412285EB51E4FF06415E8FC2F5A4832541DAA3703DBCFF0641DDA3703D62842541FED6A3706FFE06416E6666E6EB8425414466666688FF06413933333300852541047B14AE55FF0641383333B31F852541C4CCCCCC06FF06415CB81E05988525410A000000420007410800000023862541E4CCCCCCBEFD0641A547E1FA7A8625417E8FC2F5DEFE06412485EBD1D0862541EAA3703DF8FF0641606666E60D8725419A14AE47E9FE0641440AD7A31D872541BA999999A3FE0641A5703D8A74872541503D0AD787FE0641DB7A14AE888725412AD7A37081FE06418114AE47D6872541F8D6A370BBFF064148E17A94378825419A47E17A56FF0641E951B81E62882541F0A3703D2AFF0641A947E1FADE8825416A6666664CFE064185C2F5A8408925412E85EB51CAFD0641BD1E856B74892541BEF5285C85FD06412185EB517E892541B2A3703D78FD0641783D0A57C88925418899999915FD064103D7A370038A254162666666D0FC06415B8FC2F5448A2541C27A14AE83FC0641FC285C0F278B2541A2703D0ACFFC0641D8A370BD9F8B254104000000E4FC0641608FC2F5E58B25419AC2F528F0FC0641B91E856B6C8C25411ED7A3706FFC0641CBCCCCCCBC8C254160EB51B86EFC064188EB51B8EB8C254198EB51B854FC0641AC703D0A928D25419447E17AF8FB06417914AEC7588E2541BC47E17AFEFB0641D3CCCCCC668E254132E17A14D2FB06414BE17A14718E2541F4D6A370B1FB0641F3285C8F748E2541F8285C8FA6FB064193999999798E2541603D0AD79FFB0641A0703D8A7B8E2541503333339DFB0641080000805A8F25413A0AD7A3EEF80641A3703D0AF48F25418E14AE47FFF70641E07A142E769025411A85EB51D0F70641380AD723C39025418EEB51B886F70641F1285C8F4791254142E17A1408F706417E14AEC77191254176C2F528E8F6064153B81E057F912541EAD6A370E3F60641AAAFB7B2DD912541C2615E1AEDF60641E07A14AE24922541100000004EF60641325C8FC24292254154E17A143CF60641D2CCCCCCE2922541283333335BF5064197C2F5A846932541F2AD47E1CEF4064155B81E85BD932541FE7A14AE7DF3064163666666DC932541D8F5285C4FF30641040000807C942541B8703D0A5FF206411D85EBD1D0942541EECCCCCCBEF00641C0F5285C469525416A14AE47C1F00641AB47E1FAF4952541BE1E85EB4FF0064142E17A14329625419E1E85EB21F20641C8CCCCCC359625410A85EB513EF2064115AE47E158962541D67A14AE49F30641AF47E17AAA962541D8F5285C17F6064199999919BB962541E6D6A370A9F60641CAF528DCBF962541A8F5285CD3F60641B147E17AC4962541F47A14AEFBF6064155B81E85EF962541568FC2F56EF806419C703D0AF2962541BCCCCCCC84F806419C703D0A099725418814AE474BF90641F351B81E0B972541D451B81E5DF9064189C2F5A80E972541548FC2F576F90641460AD7A365972541CC1E85EBEFFB0641FE285C8FD096254124E17A140EFE0641548FC27512962541D0A3703D98FF06418AC2F528FE9525412685EB51C2FF0641363333B35B9525412C5C8FC2FB01074110AE4761EE942541F0FFFFFFD7020741783D0AD7B9942541360AD7A3C00207413C0AD7239F9425410252B81EFD0207413F0AD7236994254102295C8F8C030741598FC2F530942541B2CCCCCCAA04074159B81E05EC9325413E85EB511C05074195C2F5288B93254160EB51B8F0050741BCF528DC5A9325416EEB51B84E060741DA7A14AE31932541E6CCCCCCC2060741A5703D0A469325417E14AE47DD070741AB703D0A44932541F2AD47E10008074152B81E8541932541A847E17A2E0807415F8FC2752F932541485C8FC271090741450AD7A33C932541385C8FC2F50A074192C2F5A834932541FEAD47E17E0C0741753D0AD7499325416AE17A14B40D0741D77A142E1D9325418A14AE47C70E07416B6666E62593254156E17A14341007410200000035932541D0A3703DE81007411985EB5141932541B647E17A061107412285EBD1539325419C703D0A4D110741D4A3703D67932541668FC2F5BC11074188EB513889932541FCAD47E1021207412B333333869325411C0AD7A34C120741DD7A142E74932541B8F5285C8D120741DBA370BD739325414AB81E85AF120741CECCCCCC9C932541BC7A14AE1D130741FA285C0FB293254158B81E85691307414CE17A94C49325416EC2F52884130741A547E1FACC93254172C2F528901307417D14AEC7D7932541D67A14AE9F130741C4CCCCCCE8932541DCA3703DD41307412085EB51F4932541F0A3703D1C1407412E333333FF93254172666666BA140741F9FFFFFF1E94254164EB51B80E150741E951B81E25942541A014AE474B15074149B81E052394254134333333851507419D9999993B942541F0D6A370ED150741DB7A14AE3C942541809999993D160741F451B89E40942541F6285C8F9A160741265C8F424E942541D87A14AEF11607417214AEC76294254110295C8FA6170741C2F5285C6F9425414285EB510A18074110AE47E17594254150333333511807415AB81E057394254134333333F9180741C9F528DC7B94254194703D0A25190741D9A370BD8C9425411285EB5144190741949999999E942541AAC2F52856190741733D0A57B09425412C5C8FC259190741E951B89ECB9425414C0AD7A35E190741FEFFFFFFCB9425411CAE47E1B2190741B81E85EBC094254130333333511A0741A647E1FAC3942541007B14AE991A074197C2F5A8D2942541B447E17AD81A07419E999999049525410A85EB513C1B07419E703D0A13952541B2F5285C4B1B0741B91E856B2B9525415CE17A14321B07411F85EBD132952541643D0AD7831B0741E67A14AE2C95254112295C8FD21B0741D6A3703D2A952541E0CCCCCC261C0741BE1E85EB2E952541CCF5285C571C0741CEA370BD59952541CEA3703D261D0741608FC2755C9525416A14AE47331D0741E651B81E4F9525416E666666561D0741A29999992A952541E6285C8FFE1D074113AE47E119952541C0703D0A6B1E0741255C8F421195254120AE47E1961E074113D7A3F0029525419C14AE47C11E0741E57A14AEFB9425413EE17A14C41E0741A0703D0AEE942541C8CCCCCCEA1E07412F333333DF94254192999999211F07413C0AD7A3D89425418A14AE475F1F074104000080D59425413C33333305200741E87A14AED99425415633333387200741D87A14AEF99425411052B81E73210741D3CCCCCCFB942541D6CCCCCCE2210741FF285C0FE3942541CA47E17A4222074147E17A94EB9425413A0AD7A3762207415D8FC2F5EE94254108D7A3708B220741A747E1FAF19425417E3D0AD79D22074141E17A9401952541E07A14AED52207416C3D0A57089525412E3333331B230741616666E617952541F0D6A3706D230741E451B81E1B95254110295C8FC2230741C6CCCCCC109525413E8FC2F50E240741350AD72322952541303333332F240741F5285C8F23952541D6CCCCCC4E240741C6CCCCCC24952541CEA3703D6A240741606666661D952541C6A3703D80240741D0A3703D2995254168EB51B834250741C8F528DC27952541A0F5285C3D250741C3F5285C24952541E6F5285C53250741588FC2F5219525414266666662250741F8285C0F24952541385C8FC223260741D77A14AE3B95254180EB51B83426074112D7A37061952541AA1E85EBB3260741A4703D0A6A952541360AD7A3142707419799999970952541DA51B81E792707416D6666668F952541A4999999052807417714AE47B6952541F8D6A3708B280741B21E85EBB69525411633333303290741F9285C0FD695254188EB51B870290741F151B81EE695254120333333D3290741E67A142E15962541C2A3703DCA29074194999999449625413C85EB511C2A0741B31E856B60962541D41E85EB952A0741460AD72366962541480AD7A3202B0741B147E17A6E962541500AD7A3662B0741F0285C8F759625413C85EB51AE2B07416F6666669D962541CE47E17AFE2B0741606666E6A0962541F0CCCCCC422C0741C3F5285CB396254122D7A3706D2C0741733D0AD7BA962541C6A3703DCC2C0741BA1E856BD196254110D7A370DD2C07416F666666E2962541620AD7A3622D074188EB51B80897254146E17A14922D07411BAE47E11C972541DE7A14AEDD2D0741F0285C0F479725412885EB51002E07416E66666663972541AE999999092E0741D4A3703D769725415C8FC2F5FC2D07412185EB51829725418A9999996B2E0741D3A370BD9597254140B81E85932E0741D3A370BD95972541325C8FC2E12E07412285EB51B3972541283333334D2F0741578FC2F5C99725419A1E85EBA92F0741B41E856B0998254130D7A370B52F074109000000259825413E0AD7A330300741DFA370BD2C982541BA47E17A183107419E99999939982541963D0AD74B3107418BEB51383F9825416CEB51B88A310741E0A3703D3B98254186703D0A633207410A0000006A9825411485EB516A33074180EB51B8909825416E3D0AD70D340741E07A14AEA29825418AC2F528EA3307412E333333A99825417414AE47E3340741CEA3703D9798254108000000003507411A85EB5189982541CC7A14AE91350741DAA370BD8A982541C8703D0A3D3607415C8FC275829825418414AE472F370741C11E856B789825414E0AD7A300380741265C8F4274982541F4A3703DAA380741C4F528DC64982541C61E85EB99390741C5F5285C5C982541D6285C8F543A0741558FC2F58C982541D047E17A083A0741EF285C8FEA97254118D7A3706B3D07411F85EB51BE972541C8703D0AA73C07412085EB515497254148E17A14643E0741BBF5285CB4972541C247E17AB03E0741C3F528DC9B9725416C14AE47014007415A8FC275B39725415066666636400741FE285C0FE79725413485EB51AA400741E87A142E1A982541283333336F40074115AE47E13D9825415E0AD7A3BE410741AB703D8A8098254182C2F5287C42074186EB51389A9825419E14AE47C54207417414AE47C89825410852B81E7944074180EB5138CA9825410ED7A3708B440741B01E856B059925411052B81E1B45074180EB513837992541ECFFFFFF93450741235C8FC23C99254166666666B24507416B666666569925417A14AE473F4607414BB81E856599254188C2F528924607414AB81E0582992541240AD7A32E470741D4CCCC4C89992541480AD7A356470741C4F5285C6499254130D7A370ED4707417B14AE477B992541A0703D0A8F480741255C8FC259992541B6CCCCCC6C4907411885EB514C992541628FC2F5644907415F6666E609992541BAA3703D644A0741969999993D9925413C5C8FC2B14A07414CB81E8551992541FC7A14AECF4A0741949999994B992541CE7A14AE694B0741B21E85EB41992541E8A3703D644C0741BAF528DC099925411485EB51344D0741F7285C0FEE98254144666666364D0741C21E856BBD982541823D0AD7394D0741B01E85EBA0982541DA1E85EB134D07419899991972982541285C8FC2D54C0741F151B81E669825417A3D0AD7C54C07412A5C8FC249982541F6FFFFFF9F4C07410FD7A3F0259825417E666666704C0741F7285C8F199825413EE17A145A4E07417DEB51383A982541263333333F4E074141E17A143F98254174666666B04D0741FDFFFFFF5398254184703D0AD94C07416F6666666E98254158E17A14FA4C074140E17A94E2982541F87A14AE8B4D07410DD7A3F0D1982541B01E85EBC14E07412D333333D1982541503D0AD7CF4E0741BA1E85EBDB9825416A666666C24E0741E37A142EF998254184EB51B81C4F0741B11E85EB13992541CEA3703DFA4E0741D8A3703D3F992541220AD7A3C24E0741E97A14AE30992541EEA3703D8C4E074159B81E8511992541D6CCCCCC824E07417614AEC707992541CAF5285C4D4E0741DE7A14AE20992541027B14AE814D074114AE47E12E99254154B81E854F4D0741DEA370BD489925410E000000F44C0741F8FFFF7F589925413E85EB51BC4C0741DD7A14AE5F992541388FC2F51A4C0741EC51B89E6A992541445C8FC2254B0741BE1E856B7799254118AE47E1164A0741FF285C8F84992541C2F5285C01490741E37A14AE8B99254170EB51B86A480741D8A370BD8C99254104000000544807418414AEC7909925416414AE472D470741CACCCCCCE0992541027B14AEE145074112D7A3F0729A2541205C8FC2434407410AD7A3F0829A2541E251B81EF5430741C9CCCC4CC39A25414C0AD7A3B8420741F1285C8F0E9B25412A85EB51B44007413A0AD7A34D9B2541F6D6A370033F074199999999B29B254190EB51B87A3E074196999999D49B254120D7A370B13D07411D85EBD1009C2541B0CCCCCC403E0741F251B81E229C2541AAEB51B8AC3E07410CAE47613A9C254118AE47E1283E074145E17A14609C254148E17A145C3D0741A747E17A6F9C25415E3D0AD7813D074163666666989C2541EEFFFFFFC93C0741AF47E17AA19C25415814AE47A13C0741E851B81E9C9C2541623D0AD7073C074148E17A94B69C254166B81E858F3B07411B85EBD1D49C25418C3D0AD7053B074197C2F528FF9C2541703D0AD7AD3B074113D7A370189D25419614AE47153C074106D7A370029D254170EB51B87C3C074186EB5138DA9C2541B81E85EB393D0741EE51B89EB99C25411A333333D33D0741648FC275AF9C254100AE47E1023E074109D7A370F49C2541D47A14AEDB3E074150E17A14789D25414285EB51663D074140E17A14849D2541F884EB51443D0741CACCCC4C779D254108AE47E1123D074186EB51B8529D254114333333853C07411CAE47E1309D25413EE17A14023C0741A4703D0A8B9D2541A81E85EBBF3A0741AA47E17A079E25417814AE47C7390741BD1E85EB299E25419C47E17A82390741BEF5285C529E254100295C8FAE390741F0285C8F549E2541588FC2F5B039074138333333579E2541465C8FC2B33907412A5C8FC2859E2541B2F5285C6339074114D7A3F0879E2541A047E17A6039074158B81E05E39E2541F0CCCCCCE8380741390AD723F89E254186703D0ACD380741FAFFFF7FFC9E2541FAAD47E112390741B247E1FA4F9F25417014AE4725390741B347E1FA7D9F25413A33333395390741793D0A57C29F2541CEF5285CC33907413C3333B3E69F25418A14AE47033A0741A7703D0AEC9F254180999999353A0741A9703D0AF29F25411E333333FD3B074105D7A37003A02541DCFFFFFF033C0741CFCCCCCC42A02541C447E17AF43B0741080000005AA02541C21E85EBF93B0741DCA370BD5BA025419CC2F5286A3B07411EAE47615DA0254114D7A370433B0741DFA3703D70A025419A1E85EB873907412585EB518FA025417EEB51B8303807410FAE476197A025414AE17A14D83707418BEB51B8C4A0254118295C8F8E360741215C8FC2D0A025410CAE47E13636074158B81E85D6A02541DE51B81E0D36074151B81E0520A1254108295C8FE6330741A847E17A1FA125416414AE479732074195C2F5A82AA1254192999999AF3207417E14AE474FA12541B2703D0AFF320741666666667CA1254122333333613307416F3D0AD791A12541DC7A14AE8F3307411BAE47E1A9A12541563D0AD75D3307411CAE47E1C3A12541D6285C8F103307411DAE47E1DDA12541C8F5285CC33207419C703D0ADBA125416EEB51B8143207413F0AD7A3DAA12541D4285C8FFC310741A2703D8A26A225415CB81E85BB3107418114AEC72CA2254182C2F528B6310741E751B81E37A225419414AE47AD3107415D8FC27577A22541343333335F31074118AE476189A22541E4285C8FD4300741363333338BA22541B047E17AC6300741A6703D0AAEA22541385C8FC27F300741C8F528DCD2A22541A4703D0A353007411B85EB51EEA225416414AE47FD2F0741A0999919EFA22541EE7A14AEFB2F0741646666E60DA32541DCFFFFFF1530074151B81E0536A325410085EB51383007412C3333B33BA32541203333333D300741D4A3703D3CA32541686666669E300741548FC2758FA3254172EB51B8183107410DD7A3F089A3254162B81E856F3007411A85EB5186A325410A85EB5100300741C0F528DC69A325419047E17A242F074189EB51B880A32541F8285C8FB02E07419B703D0AA9A3254184703D0A652E07411DAE47E1DCA325411C000000042E0741CECCCCCC37A42541F8AD47E1742D07417D14AE476AA4254124D7A370252D07417214AEC790A4254136AE47E1E82C074111AE47619BA42541A6C2F528D82C07410300000009A52541580AD7A3362C0741A199999910A52541C6F5285C2B2C07411785EBD117A5254182EB51B8202C07411DAE47E17FA525414C3D0AD71B2B074187C2F5A8D2A525414485EB51F42B0741A847E17AF4A52541B2A3703DAA2B0741BF1E856BEFA5254180666666122B07418114AE47EEA52541F0A3703DF02A0741E951B89E01A625417CEB51B8F028074114AE47611CA625416414AE47E728074106D7A3709BA625419E47E17ABC2807411D85EBD1A1A62541FC84EB51BA280741F9FFFFFFFAA62541F6A3703D9C280741648FC2F5EEA62541B0F5285CC72907417514AE4728A72541F47A14AEA929074119AE476150A7254126AE47E194290741285C8FC2BFA72541225C8FC2C5280741E07A142ED1A7254168EB51B8A828074141E17A9461A82541DA1E85EBB7270741C11E85EBF3A825412E333333E3250741030000800FA9254118295C8F9A250741AE703D0A5BA9254190999999D3240741255C8F4293A925412A33333373240741C4CCCCCC9DA9254168B81E856B240741FCFFFFFFB4A92541045C8FC239240741EE285C8FE3A92541A447E17ACE23074152B81E05F9A92541FE7A14AE91230741B21E85EB0AAA2541663D0AD77F2307410500008037AA254128E17A142623074186C2F5A8F5A92541D8CCCCCC92210741A1703D0AB5A92541A6C2F528581F07414CB81E85C1A92541B4703D0A211F0741A93AB3D8EDA925410C4E99C7BF1E0741A20A840233AA254190DD75D7BB1F07411D139EE557AA2541D07CA8A88A1F0741D162374E3FAA2541880F3425221F074129E98AF85AAA2541F438D88F631E074134FABEBEA4AA25410CE5B1B5691E07418C801269C0AA2541FA9D3230A71E0741657AF67F02AB254166EA1C2CF31F0741469EED8341AB2541E8BF9ABC3A1F07413903482485AB2541B299A5BE941E07414FF084E68FAB254172CC4111721F07415A01B9ACD9AB2541B867E7702E1F0741FFF60F5209AC2541FA061A42FD1E0741056286DB0AAC254172CC4111721F0741367FF273D0AB254148D9E865A91F07415BC671F992AB254196ABB78955200741AFA0EB7DA8AB2541126D52E7B7200741DC74491900AC254196ABB78955200741BBD9A3B943AC2541C49A83C30B200741A998401D3FAC25418E748EC5651F0741ABBAA8A9D2AC25414C84E486381E074145DA123CFFAC254164C7D69AE81D07416EC74FFE09AD2541A001AFCB731D074189F77ED4C4AC25418855D5A56D1D0741ABBAA8A9D2AC2541B0DF463FE01C0741AAF5EF5C19AD25416ADBB9CDCD1C0741C588EA5B6CAD2541F27E7910AF1C0741E6865BE4C0AD2541AC7AEC9E9C1C074173D0D863EAAD2541801EACE17D1C07417EE10C2A34AE25415EA81D7BF01B0741F9E9260D59AE25417AB951413A1C0741A54AF43B8AAE2541A4ACAAEC021C074150ABC16ABBAE2541E4790E9A251B0741CCB3DB4DE0AE254138F7D8DE601A07418FC082A217AF2541F0F24B6D4E1A074168BA66B959AF2541684F8C2A6D1A0741F0986DAF81AF254172C8C9FD951907412BC70D0E91AF25414EE95385B2180741787774A5A9AF25418A74A3239C190741CB51EE29BFAF2541BA353E81FE190741F603E43883AF254110D64E57441B07417AFBC9555EAF2541283C87FCFE1C0741F9EA0412D0AF2541522FE0A7C71C0741B021BF5304B02541B644A1DF231D0741AF5F94FB29B025410A8802768F1D0741E522BED037B02541CEF07A052A1D07419D1BA36A46B02541464DBBC2481D07410C8CA5E28DB02541B2A5DD90101E074175535C29AEB025418EBA2F46B11D07415DA4F40EC9B02541E25A401CF71E074128E1CA39BBB025418A781B37781F07418126BB47D2B02541E81C4AFC142007412BC55D1E29B12541829EA1B2621F0741A16201784CB12541E25A401CF71E0741777236C162B12541E25A401CF71E0741522E45307FB1254176C8B49F5F1F0741704595DF86B125412ABC7CCDE31F0741B01F0F649CB12541EA85310E6B2007419F9D482B93B12541241181AC54210741A3846904E0B12541A23B031C0D220741D6C33D2939B22541D07070D60E20074111F2DD8748B225410CAB48079A1F07417BB994CE68B22541487C3926CF1E074190E11844BAB225418E80C697E11E0741F5FCF564D4B22541D0B611575A1E0741AD967BCFA0B32541BE6F92D1971E074123341F29C4B32541B2A5DD90101E0741A4A7AF95EAB32541B2A5DD90101E0741E7368233FFB32541443BAED1D91D07418952CE7F9FB425416A1F6285391D0741D7A3703DBDB42541D8CCCCCC1E1E0741A647E17A11B5254168B81E85371F07419C703D8A18B52541FC285C8FD81F074113D7A3F02DB5254194703D0AEB1F0741DBA3703D50B525412C0AD7A3082007418FC2F52861B525411C333333172007414BE17A947EB52541D4285C8F082107417814AEC757B5254110D7A370252207410FAE47E14FB525419EC2F528B422074101D7A37028B52541A0703D0ADF230741420AD72310B52541DA285C8F382407412885EB5103B52541803D0AD7E7240741325C8F42FCB42541E6A3703D48250741638FC2F506B52541488FC2F56825074130333333F9B425416614AE47A9260741A847E1FAF7B425411AD7A370C52607413E0AD7A30CB525417AEB51B8D42607410DAE476169B52541C2F5285C19270741B347E1FA60B52541528FC2F59C270741F9285C0FC2B525412AAE47E1BE27074115AE47E1BDB52541C047E17A24270741793D0A578EB52541F651B81ED1260741305C8F4291B52541220000004E260741AB47E1FA9BB52541D47A14AE6D250741BFF528DCA7B52541623D0AD7A9240741713D0AD7D7B525410200000050240741D7A3703D21B6254108AE47E1D223074156B81E050DB62541E6D6A370D3230741EA51B81E69B62541420AD7A3B421074154B81E055DB62541D0CCCCCC94200741BCF5285C6DB62541ECCCCCCC482007411A85EB518DB6254136E17A14B41F07412C3333B39BB62541608FC2F5AE1F07412185EB51FEB625415A3D0AD78B1F0741E951B89E62B72541C4A3703D082207415CB81E8577B72541FEFFFFFF05220741948454A6A9B72541788AEB11C023074111AA98311BBA254152428E87862207416F9B626538BA2541EC0987BE1F20074189CB913BF3B9254126DB77DD541F0741BAE8FDD3B8B9254156CA43170B1F0741EE285C8FB8B92541E2A3703DA41E07412585EB51BBB9254132333333751D0741683D0AD7C8B925416E666666BC1A074186C2F5A8CAB92541F884EB51F81907412385EB510EBA2541260000006C1A074159B81E05C3BA25418614AE47DF1B074148E17A1408BB25418E14AE47811C0741BDF528DC6ABB2541886666662C1D0741BEF5285CA7BB2541B2C2F528C81D0741638FC2F5DABB2541BCA3703D201E0741E651B81E54BC25412E3333334B1F0741DE7A14AED9BC2541B4C2F528AE1E0741F551B81E39BD2541EA285C8F661E07410EAE476190BD25417CEB51B8801D0741BD1E85EB01BE25414285EB51B41C07410000008009BE2541E8285C8FA61C07417FEB513845BF2541A247E17A6E1A0741DCA370BD5BC02541220AD7A372180741FAFFFFFF4BC12541E251B81E9D160741C2F528DC5FC125410E000000761607410AD7A3F061C22541628FC2F578140741B547E1FAEEC3254192C2F528BE1107412285EB51F1C425413C85EB51A60F0741A299999983C525412085EB518E0E07416B3D0A573BC62541600AD7A32E0D0741F451B89E81C6254172C2F528A80C0741703D0AD777C72541588FC2F5760A07416B3D0A57F8C725419EC2F528740907418EEB51B8FDC725415AB81E856909074112D7A3F028C925413EB81E851B0707413A3333B32BCA2541623D0AD7D10407411A85EBD151CA2541F2D6A3707B040741C5CCCC4C3ECB25411C295C8FB60207412A5C8FC25ECC25419214AE4785000741628FC2F589CC2541500AD7A32A000741CBF5285C77CD25415A8FC2F538FE0641CECCCC4CF6CD2541263333338BFB06410ED7A3F005CE25410C295C8F36FB0641C9CCCCCC5CCE2541A6F5285C61F906412F5C8F428FCE254170EB51B850F806417414AEC7FBCE25415CE17A14D6F506414EB81E8596CF2541FC51B81E4DF2064152E17A14C2CF254192C2F52868F10641E851B81E3ED02541883D0AD7DDEE06412585EBD144D02541600AD7A3BAEE0641F7285C0FA2D0254132B81E85D1EC06412C3333B3C6D12541AC703D0A9DE606412485EBD1D0D125415633333367E606414FE17A94D4D12541668FC2F552E60641E0A3703DCBD225410A52B81E2DE10641606666663BD32541A499999927DE06414CB81E05BFD325416A8FC2F5D4DB06414CC1C1FA8BD42541505F87061DDC0641BBF3EECAADD42541E69ECAAD31DD064161E94570DDD425418C53BEB65CDD064112B5892810D5254170FCE86FC7DE0641A0FE06A839D52541A0549CBBD3DE0641C9EB436A44D52541AACDD98EFCDD0641BB9101A78CD52541B032342F40DE0641F9A6C2DEE8D525418C53BEB65CDD0641DE0E8AFB4ED72541C279B3B402DE0641B4214D3944D725412EC69DB04EDF06412ABFF09267D72541006EEA6442DF0641F9A184FAA1D72541FAC2EE43B3E0064138B74532FED72541E87B6FBEF0E00641E093BDB07AD825411EA264BC96E1064101922E39CFD825413080FC2F03E10641B8C8E87A03D925413CF939032CE00641DC4AAFB30CD9254198865A093ADE0641E2B5253D0ED9254110293C47A4DC064149F986D379D925413294F4C01EDA06411E4791C4B5D92541F49FBD10DFD806412C3FE6634CDA254146915AB2B9D50641CFB0E758C7DA2541AA9B45FD02D30641E4D86BCE18DB254190CC2546F2D00641E6FAD35AACDB25414C504E6464CD0641B4DD67C2E6DB254122A39639E7CB06418ED74BD928DC2541A47814CA2ECB064105348C9647DC25419EAAD21795CA0641CDEC0C1185DC25411AB20EF642C906418A8E3DDCBADC25416884DD19EFC90641DD68B760D0DC2541382C2ACEE2C90641387360BBA0DC25418A400D01C8C806413FA38F915BDC25417E0D71AEEAC70641CA05EC3738DC25418886AE8113C70641CA05EC3738DC25411C3AC485C7C5064183C0FB2921DC2541FEBFA8AD27C50641ACEE9B8830DC254186FA80DEB2C406413CBC6EB80EDC254104D48BE00CC406412A0238E7FBDB2541EE41E0C7BAC20641E00DF9C2A2DB25416C7AE57333C20641C86DC3DC57DB25411E8AA2CC5FC1064199F76B8C54DB2541ACAFD48368C10641B26E684B42DB25418808B6B303C106410925008E5ADB25415ECDE6ABEEC006414F48FFD0E9DC2541F04365E057BF0641D0752A5F0BDD2541A2F325B035BF0641EC84E863BCDF25417AFC50AB77BC0641FD133B39A7DF25416AA44F5557B70641AEFD7C0E13DF2541C0BEF27E7CAF0641C049956341DD25412A19C5FCDD9E0641D7494C6E3BDD2541940AD3AAA59E0641215C8FC248DD25414E333333539E06410FD7A3F0DDDD254172C2F5281C9A064131333333E6DD254164666666E09906417B14AE47E9DD2541D6A3703DCA9906419F703D0AECDD2541A247E17AB69906410DCC445809DE254162554C05E39806419BC5B77938DE25410C333BC0609806410A3E5A2A55DE25411EE3A1577998064156E39294B9DE2541AE011895069806418868DC990DDF25418E71A062FE970641F39D8C367ADF2541FCD3E6B8B29806416AFACCF398DF2541FAA72E04E2990641132E046982DF2541148DAA155B9B064128AD47D540DF2541B0DEBCA5C59B06413A97EB7AD8DF254188F84D319F9E0641BFA50BF792E0254174EEFD0862A00641EFFDBE429FE02541EA049D4535A20641D9734DA92CE125418C05230A0BA7064144B42B734DE12541DC56359A75A7064127514AFA8CE125416AF6676B44A706417D07B72A3BE22541BC7332B07FA60641AC543C4993E22541F06085C2B2A506415E8E795712E32541003F1D361FA506416E4B874362E32541B4EB917E31A40641CACE572133E325412E231383C2A10641FA260B6D3FE32541F01880781AA10641A97927A271E325419E482A7CF1A006419D980C62BAE32541A246B1546EA006415CB364B0F0E32541A45C0DAFD69F0641FB3D45CC1EE4254114EB0BBA5B9F06414BE0FA6938E425417899F929F19E06410B0681E522E42541AA0709D0659E0641337A96242DE425419CBE1023209E06410FF8CFEB23E42541BAE5A043D29D0641A7A9402804E425413A267F0DF39D064150DD779DEDE32541AA1D652ACE9D064195111E9592E425413207C6EDFA9B0641BC7A05A7E8E42541C2253C2B889B06418041371B25E52541E434F7C94E9B0641AF99EA6631E52541E6E16B12619A06414D5F1236A6E5254142661AF5A89B0641C575DD12CAE5254160774EBBF29B0641854AC08005E62541148DAA155B9B064130AB8DAF36E62541C2BC5419329B06414792AE8883E62541D61930F95C9A06414687805BCFE625413ADE79C35A9906415936DD4D20E725412AAD569800990641B8E643E538E725415E0391BC8998064140C54ADB60E725419CBA980F449806411C4384A257E72541D2262F8E35970641809FC45F76E72541443471057996064103D2F12F98E72541A6631B09509606416B2081F3B7E72541D452E7420696064173041F00BAE72541B8570FD7249506411A739D28EAE725416A6FE458109506414A85DB93FBE72541DAFDE263959406412930AB143AE825410E0192D030930641B9F24F1764E825413EC22C2E93930641741B595F99E82541AE502B391893064103DEFD61C3E825415EE9BC4E45930641A25DB0503DE925413C43E9C1D4930641D2B5639C49E92541925553CD36920641753293BE78E92541E46936001C91064185FACED77CE925417C057782E48F0641D59C847596E92541BCD2DA2F078F0641383F3A13B0E92541D045126A9A8D0641DC7A14AECFE925418AEB51B8BC8C06410700008057EA2541B6703D0A938B0641021A231A81EA2541C628D271258C0641B16C3F4FB3EA254164620F80A48C0641A7B8BAC843EB25417807F0A9679006418A55D94F83EB25411CEC28D9758F0641CE2CD0074EEB254184F286B2AC8C064126B323B269EB2541DA9B09ACB88A064172A9FF297DEB2541EE61CC9D398A06410A5B70665DEB254142F5F23CDD8806412DD20872B2EB25416006270327890641A6AD8C9B8FEB254184419A56BE870641D04E3894E1EB254184419A56BE87064120F1ED31FBEB2541C677E515378706411029B218F7EB2541C88D41709F8606410B72AAC53CEC25411A0B0CB5DA850641B6D277F46DEC25417A245A5E498606415E41F61C9EEC2541EE47F82FF58406418D48065BFBEC254168DDDAD8868606415055ADAF32ED25411A74F3C6308606410F7005FE68ED2541B82EED68F18606417BB0E3C789ED2541EA05E420BC86064102D55F9EACED254118483B12608706416918C13418EE25417CA39DCA078606418D9A876D21EE2541BA5AA51DC285064176F9DB74CFED2541729CB92CFB830641BAC5A4FFE5ED2541B4D204EC738306415277153CC6ED254176C871E1CB820641AFFAE51997ED254146D9A5A715830641B7E9B1534DED25418A3BA91B5F81064147AC565677ED25418ED048E2858006415277153CC6ED2541EA016C0DE0800641BAC5A4FFE5ED25412CA19EDEAE8006415D42D42115EE2541642391B7087F0641606F6ADB5CEE25410ACB9A89917C06415F643CAEA8EE25419EE7979F9B7B0641B7EA8F58C4EE2541B0C52F13087B06415FB6BDC0CEEF2541E4C8DE7FA3790641EE7862C3F8EF2541C20CAF98CA7A0641BE15814A38F0254154AA6842167A064146F4874060F02541C6A14E5FF1790641B06FADBDC7F0254142CCD0CEA97A06415FC2C9F2F9F02541F27ABE3E3F7A0641CA3DEF6F61F1254154AA6842167A064159F56545D7F12541A229ACAED4790641FB66673A52F2254106D8991E6A7906411A322620A1F225411437EE2518790641C01E85EBE5F225411485EB519278064198C2F5289AF325413CB81E85517706416F66666620F425414E6666664C7606415D8FC2F584F425414C0AD7A32C7506414FB81E85F8F42541789999990374064147E17A1467F5254164E17A1426730641F0285C0FBEF5254186EB51B85C720641E87A142EF3F52541405C8FC2CD710641A5703D8A19F62541EAD6A370537106410000000025F6254102AE47E12E7106412185EB5101F7254112295C8FDE6F0641B247E17A7FF72541CA703D0AF96E0641EF51B81EC8F72541828FC2F5746E0641DE7A142ECEF72541A61E85EB696E064102D7A370C8F72541FA51B81E436E06412F5C8FC284F7254126333333796C0641568FC2F573F7254176999999076C0641CDCCCCCC6CF725418A703D0AD76B0641DBA370BD46F72541CCF5285C2F6B06411785EB5139F7254140E17A14B26A06412D5C8F422EF7254112333333F3690641383333332DF72541E4285C8FE0690641315C8F4212F725416AEB51B8A86806414AB81E8510F72541EA285C8F9468064102000000F1F62541FEAD47E1726706418AC2F5A8E9F62541C0703D0A35670641B747E1FABCF6254134B81E85BB650641BD1E85EBEBF625416C14AE47D36406417A14AEC748F72541CEA3703DB263064196C2F528BAF7254160B81E85B5620641DA7A14AEF8F72541B8CCCCCC2262064183EB51B8AEF72541100000005C6106414CB81E0592F72541DECCCCCC96600641CDA3703D64F72541CCF5285C1B6006417914AEC745F725419C14AE47E35E064187C2F5A822F725412885EB51085E064105000080DAF6254172EB51B8A45C06419E999919A2F625419AEB51B8A25B064157B81E0569F625410CD7A370A35B064112AE47E152F62541600AD7A3745A06411885EB5131F6254168E17A14965906410FD7A370F6F525417CC2F52838590641CCF528DCEBF525418E14AE47D358064140E17A949FF52541A2F5285C47580641696666666CF52541563D0AD76F560641F9FFFF7F66F525417014AE47FB550641E27A142E5AF5254116333333F35506411C85EB514CF52541B8A3703DEA5506419999999951F5254192C2F528B055064181EB51B867F525419C14AE4761550641F051B89E81F5254104AE47E104550641A0999999ABF52541C47A14AEBB540641FEFFFFFFAEF5254118D7A370615406416B6666E697F52541E851B81E91530641D87A14AE58F5254142B81E851D54064151E17A1449F5254128D7A3704154064108D7A370EAF42541E07A14AE1B550641FD285C8FEBF425419CEB51B844550641E47A14AE60F42541EC285C8F98560641EE285C0F3DF4254178999999C5560641AF47E17A2AF42541A0703D0ADD5606413F0AD723E8F3254188EB51B8C4570641A9703D8AB9F32541503D0AD77358064152B81E0595F325417CC2F5280A5906416A6666E63CF32541DCF5285CED590641763D0A57F1F2254172666666EA5A0641DA7A14AE99F22541E6FFFFFF3B5B06414BB81E8566F22541A89999996B5B06418214AE47D1F12541A247E17A225C0641773D0AD770F125416EEB51B8985C0641BA1E85EBD1F0254194999999615D06417DEB51B83EF0254168E17A14405E0641DB7A14AE47F025417C3D0AD72F5D064155B81E8549F025415EB81E85F75C0641FA285C0F41F02541889999990F5D0641EF51B81E65EF25415A3D0AD77F5F06415CB81E05F5EE25410AD7A37083610641EB3492AAD1EE25411C29BD4443600641D88535B880EE2541CE036369A95E06418AF7FE3CFDED254138B7C4F2E85C0641D5CCCCCC72EE2541FA51B81EEB5B0641430AD723D2ED254196EB51B8965B0641DDA370BD43ED254160B81E85715B06413133333337ED254172C2F528245B06419399991910ED254140333333F7590641D2A370BD08ED25414C3333339D5906412F3333331AED2541F2FFFFFFFF5806416A6666E617ED25413E85EB519E580641BFF528DC02ED2541F0A3703D3C580641DDA3703DF6EC25410C52B81ED95706414CB81E85F9EC25416E8FC2F586570641E751B89EFDEC25416466666674570641E37A14AE05ED25417C3D0AD74F570641305C8F4206ED2541EAFFFFFFF9560641B41E856BE4EC2541981E85EBAD56064196999919C3EC2541763D0AD72F5606413D0AD7A3BDEC2541AC47E17ADC55064101000080C2EC2541BECCCCCC6655064131333333C7EC25412ED7A370335506411CAE4761CFEC2541F27A14AED9540641BBF5285CEBEC25414CB81E8541540641B71E85EBFBEC254198C2F5285C530641DC7A14AE01ED2541543D0AD79F5206410AD7A3F005ED25414085EB51405206418CC2F5280CED254152B81E85635106410AD7A3F005ED25413685EB51DE4F0641B247E17A06ED2541E0CCCCCCD04F06413033333309ED25410AAE47E18C4F0641DB7A14AE15ED2541443333334B4F06412F5C8F4242ED2541520AD7A3564E064194C2F5283EED25419214AE47274E06411F85EBD13FED2541300AD7A30C4E06416A66666651ED25418CC2F528A84D06417414AEC758ED2541528FC2F5E44B064150E17A945BED2541488FC2F5424B0641538FC27556ED254154666666704A06412585EBD154ED25413C3333332D4A06412D5C8F4253ED2541C8703D0AED490641E67A142E45ED2541A6F5285C6F490641DB7A142E21ED254160E17A142E480641450AD7A31AED2541A2999999F347064187EB51B802ED25412CAE47E1544606412885EB51CEEC25413485EB516E440641D5CCCCCCCCEC25414CB81E855544064156B81E05B6EC2541440AD7A3E442064117AE4761A9EC254162E17A1474410641A49999199AEC2541AACCCCCC12410641AA703D8A8FEC25416EB81E85CF40064107D7A3703FEC25419614AE47D13E06412DDE14A4DDEC2541420E74A8973C064135C2B2B0DFEC25414EE3AE5674390641A43A5561FCEC254182E65DC30F3806418C834D0E42ED25418465A12FCE370641634A7F827EED2541E4C27C0FF936064177AD15F4A1ED2541463D4570FA350641225C8FC23FEE2541DA1E85EBA1340641618FC2F538ED2541ECFFFFFF553206419C703D0A1AED254136AE47E110320641668FC2F533ED2541E251B81EBF310641686666E695ED2541E0F5285C9F3006416A6666664EED2541E851B81E0F2F06413A0AD72316ED2541520AD7A3D22D0641215C8F4277EC2541A8CCCCCC962B06415E6666661CEC25417C8FC2F50E2A064151B81E85BEEB25418EEB51B818280641A5703D0A53EB2541F451B81E0D260641293333B3FDEA25418614AE47E7260641723D0AD7E0EA2541D247E17A262706414EE17A94A4EA25410E5C8FC233260641B2D51D7D5CEA2541D8802419432506411EC379733CEA2541D6F200507F24064194B7DCC3CCE925416CBC72AE9B2206419DA6A8FD82E925418C62463B0C2206416A720206DEE82541A23E6587F520064169509A794AE82541DA34155FB82206416F12D0F9B8E7254136B9C341002406418FAD755975E72541EA65388A122306418D80DF9F2DE725416E511275C22106418D8B0DCDE1E62541FCF044469121064176EA61D48FE6254130312310B22106418E963BFA95E625417A84AEC79F2206416617F88DD7E62541FC43D0FD7E2206417DB8A38629E7254116294C0FF823064148B4161517E72541722EB78581250641564FBC74D3E62541B2CDE956502506411283F3E9BCE625412C63CCFFE12606415E335A81D5E6254138966852BF270641E7E147F16AE62541484848115B280641934D434D50E6254138966852BF27064163DE55A264E525418A368E863B2306418B5D990E23E5254126DB2BCE9324064126F62A2450E52541B2CDE9565025064172A691BB68E525411EB1EC40462606413491D0830CE525414CF34332EA26064105444B65B4E4254168D8BF4363280641E0FCCBDFF1E4254106FCA0F7792906412CB860A4BEE42541A4CCF6F3A2290641911FCF8E91E4254182BD3B55DC290641893B31828FE4254110B0F9DD982A06417949394828E4254150C4C18C132B064197999999D0E3254180C2F52880290641D6A370BD50E32541BE1E85EBB729064152E17A1487E2254102AE47E1842C06418763558B3EE225414CC3C320772D0641547C678C51E12541768A9F02FF280641CBCD791CBCE125419846CFE9D72706413830C07270E22541CC3322FC0A27064157AADB4A10E3254160FD935A27250641D5EAB91431E325419EF1CA0A672606413947FAD14FE325417E6153D85E260641762F255064E32541466BA3009C2406413947FAD14FE325412688A016A6230641F464D5ECD0E32541AE7101DAD2210641BF551A4E0AE42541825B629DFF1F06417F352BE9F9E325411E4F1389691C064170781DFDA9E32541A23AED73191B0641718F575C89E425415EBE15928B170641A7A9402804E425415AB5B8CCFB14064122A72CDE74E425418E4F802741130641DFF19DB23DE5254192FA7B48D01106414F7793F1A0E5254176E57EBDDD11064108000080DBE52541CCF5285C9B1206413C0AD7A328E6254136AE47E19C1306412A3333B381E6254174C2F528C6140641F1285C8FE8E62541A89999999B17064195C2F528EEE625410E333333BD170641E851B89E79E725413A85EB51FE1A0641C65A946A3AE82541E4058432301906412C5D41CE81E825413C02E6AAB21806413342BDDFFAE925412626C75EC919064129E0B96BB1EB254158179284D81E0641C46D1D542AEC2541BAF3B0D0C11D064134AB785100EC25416483E5205F1B06412CC7DA44FEEB254174F89582751A0641D04E3894E1EB2541EA841B66771906416CE7C9A90EEC2541FC780F344C180641543BF08308EC25416E8651AB8F170641E408C3B3E6EB2541C26C03022117064195209835D2EB2541721BF171B616064120F1ED31FBEB2541F66FB26EBC150641016176FFF2EB254138A6FD2D351506417D74BE0FCCEB25414AED7CB3F714064125EE6A65B0EB25410A7A0297F9130641BA6717BB94EB2541E01FD6236A130641991D156987EB2541B074972070120641560BD7FD75EB2541C2BB16A632120641B1C9EE8E8DEB254114BA9D7EAF110641BE5966C195EB25413676CD6588100641F9870620A5EB25416A632078BB0F0641A5E8D34ED6EB25412E41B8EB270F0641F7B71FA637EC2541F0CD3DCF290E0641877AC4A861EC2541702478F3B20D06415722115D55EC2541A2FB6EAB7D0D0641E3FD948632EC2541F0E39929920D0641A0EB561B21EC254102C2319DFE0C0641552CC67A31EC25414404DED28D0C06417714AEC7F1EC2541B21E85EB950A0641C5F5285CA7ED25414233333357080641C11E856BACED2541243333334708064198999919E8ED254166B81E85710706416A6666E6F4ED25411C5C8FC243070641723D0A5763EE254100000000EA040641C8CCCCCCB2EE25418814AE4783000641245C8F42D8EE2541943D0AD7D9FD0541FBFFFF7FDAEE2541440AD7A3B0FD0541CDCCCCCCDBEE2541648FC2F598FD0541B91E856BDEEE25417C14AE4769FD05417914AEC7DFEE254198EB51B850FD05416D3D0A5717EF2541000000008EFA0541EA51B89E1CEF2541408FC2F558FA0541676666E621EF2541385C8FC223FA054187C2F52824EF25413AAE47E10CFA0541A3703D0A31EF25412085EB5148FA0541400AD7A332EF25414E333333D9FA0541E77A142E47EF25412433333351FB0541EA51B89E75EF254156B81E8575FB05416A6666668FEF254134B81E8533FC0541F151B89E8DEF2541EA7A14AED9FC054188C2F5A888EF254176B81E8545FD0541AE47E1FA71EF2541C0CCCCCC8AFD05414BE17A9473EF2541D67A14AEF5FD054154B81E8597EF25412485EB5152FE0541B647E1FAB7EF254110AE47E154FE0541A6703D0AC1EF2541DE7A14AE3BFE0541588FC275D4EF2541C67A14AE43FE0541BAF528DCE3EF2541F4FFFFFF89FE054113AE47E1EEEF25412485EB515AFF05417D14AE47EEEF254100295C8FB0FF054145E17A94F9EF25414C0AD7A3E4FF05417F14AEC716F0254124333333FBFF05419A99999923F02541ECFFFFFF250006417314AE4723F025410A00000092000641A3703D8A5BF025416014AE4785010641F2285C8F9EF02541E07A14AEBB010641EE51B81E98F0254160666666480206412A33333393F02541DC51B81E6D0206412E5C8F429FF0254148B81E85890206417714AEC7AAF025418E14AE477D0206418114AEC7B7F02541EE51B81EA90206415BB81E85CEF025418E3D0AD7F5020641793D0A57D0F02541C61E85EB3D030641CBF5285CDAF02541123333333303064115AE4761DDF025415CE17A14EE02064110AE47E1D6F02541CE47E17AC60206419E999919D9F0254108AE47E15C020641F351B81E03F12541FC7A14AE49020641DD7A14AE16F12541AEF5285CCD0206411DAE47613DF12541B499999929030641A5703D8A55F12541A647E17AF60306412A3333335CF12541F0CCCCCC40040641D2A370BD5CF1254162B81E85CB04064115AE47E16CF1254182666666FE040641C6F528DC99F12541E07A14AE010506412B5C8F429EF12541120000008205064192999999ABF12541CECCCCCCB605064150B81E05D2F12541C2CCCCCCE2050641DAA370BDE7F125411A33333341060641F8FFFFFFF7F12541843D0AD7A1060641EB51B89E26F225419014AE47D7060641B047E17A31F22541AAC2F52820070641373333B346F22541A899999953070641B81E856B3BF2254114000000FA070641733D0A574AF22541A647E17AA0080641CBCCCC4C55F22541C6CCCCCCE4080641D5CCCCCC6DF22541BA9999997D09064158B81E055DF22541F0D6A370C5090641989999995BF22541A6C2F528DC090641E57A14AE7EF22541CA47E17AFE090641DB7A14AE88F225414CB81E85D9090641245C8F4291F225418614AE47A909064140E17A14A1F225414E3D0AD7B10906417214AEC7C2F22541743D0AD7350A06410FD7A370C4F2254164E17A14780A0641D0CCCC4CC0F22541F6AD47E1C80A06412B5C8F42C0F22541748FC2F5260B0641B247E1FAC6F22541260AD7A34E0B0641773D0A57DDF22541A6703D0A570B06416B6666E6E6F2254186C2F528520B064140E17A14E3F2254134E17A14340B064189EB51B8FFF22541E051B81EC50A06419C703D8A1FF325413685EB517C0A0641255C8F422FF32541A01E85EB050B0641373333B337F32541D2CCCCCCA20B0641608FC2F52CF32541280AD7A3340C0641723D0A573BF3254118D7A370930C0641C1F5285C50F3254186C2F528880C06412C33333361F3254136AE47E1580C0641A3703D0A85F32541F6A3703D5A0C0641D2CCCCCC97F32541CE7A14AE650C064146E17A949EF32541BC999999A10C0641C0F5285CA3F32541F4A3703D060D0641608FC275A5F32541C4A3703D660D0641F7285C8FA0F32541DEA3703DC60D064185C2F5A891F32541766666662E0E06416D3D0A5782F32541F451B81E810E0641D05DB23421F32541BE5F2E29B50E0641F4DF786D2AF325411A7BF5F9A60F0641D05DB23421F3254198A577695F100641F8D1C7732BF3254174E94782861106414C71FA44FAF22541123B5A12F11106419148F1FCC4F22541C6E7CE5A03110641AEABD27585F2254196F802214D110641CD301C7BD9F22541600D29369D120641B8B1D80E1BF3254150AED42EEF120641F0ED296729F325417A4530FF03150641544A6A2448F32541E42833E9F9150641CF5284076DF32541A48900182B1606414B5B9EEA91F3254130CF4958D5170641F7C6994677F325410EC08EB90E180641DF1AC02071F325419CB24C42CB180641DA63B8CDB6F32541C87560C7B01906415D5070BDDDF32541A838744C961A06411541B51E17F4254136D8A61D651A06416D0D7EA92DF4254194DB986C6B1B0641E750DF3F99F42541BE885097E81C064152868FDC05F52541A23AED73191B0641F9F40D0536F525419272B15A151B06413523AE6345F52541046A9777F01A06413915FD6946F525413857EA89231A0641AC39794069F525412A0EF2DCDD190641F04BB7AB7AF52541863F1508381A0641589A466F9AF525411A46B6C3D9190641DF784D65C2F5254178F61C5BF2190641DB86FE5EC1F5254194880DB57D1A0641421B0303DCF5254176617D94CB1A06412E564AB622F62541481F26A3271A06415ABCAEFB2DF625412626C75EC919064122805DA31FF6254128A50ACB871906417D3E753437F62541EA9A77C0DF180641F9468F175CF625418CEA1029C718064151CDE2C177F625412CD1C27F5818064153FA787BBFF62541907FB0EFED170641840CB7E6D0F62541C0EDBF9562170641E481D6CAA2F62541146B8ADA9D1606411CBE2723B1F62541F6595614541606418CF054F3D2F6254156201906D5150641A39100EC24F7254168FEB079411506415EBA09345AF725411CAB25C25314064135813BA896F725411A423EB0FD130641D019CDBDC3F725412A5D0581EF140641A7E0FE3100F825411481E634061606412BCDB62127F8254144D99980121606415FD1439339F82541E2FC7A3429170641E7AF4A8961F82541BE6E7C29A4170641F9A41C5CADF8254164BC9C6A081706418D591065D8F82541C0EDBF9562170641200E046E03F9254192AB68A4BE160641007E8C3BFBF82541F8850EC9241506414D392100C8F82541AEDFF75949130641BA842DF79CF8254174E94782861106417D9C027988F82541AA0253498A0F06410E2460C86BF825417E3F3FC4A40E064198D24D3801F82541AC8196B5480F0641794D0433ADF72541022B19AF540D064192040C8667F72541B4584A8BA80C0641A0AADF12D8F625414CA1FF55830A0641B529237F96F62541AC5166ED9B0A06410D011A3761F625416E5D2F3D5C0906413026313090F52541ECF098BE6A0A06411096B9FD87F52541F01C51733B090641C4E552666FF52541C2DAF98197080641294DC15042F525416E5D2F3D5C09064146B0A2C902F52541C02D85398509064176138442C3F425413EEF1F97E7090641079BE191A6F42541C02D853985090641A33EA1D487F4254120DEEBD09D0906414FAA9C306DF42541E4E9B4205E0806419B7114256BF425412E310F7013080641BF1E856B7DF425419C47E17A360506418CC2F5284DF42541205C8FC24902064105D7A3702FF425418CC2F5285E010641773D0AD7F0F32541ECA3703D6EFF05416020143A97F325416EA4C18055FE0541EFE2FB3975F32541AEBDE3458FFB05418B86BB7C56F325415239356347FA0541D514BA87DBF22541862688757AF905416312A63D4CF3254178F3EB229DF805417BBE7F6352F3254168C2C8F742F8054126141F65CFF325411AF0F9D396F705419254FD2EF0F32541CC70B667D8F70541C222D95CD4F42541505484E5E7F805413E361D44B2F52541BED7820F38FC054114E6B770EDF525416497EDC124FD0541F893986C12F62541C40D26005BFD0541E14333994DF625416497EDC124FD05417E52A606F4F62541749AACBF06FC0541A092939F46F72541C0F92CB532FB05412160BC5B8FF72541C6B0FA407CFA054109BAC322C3F72541B62E66DEC0F90541D96ABB6709F82541B48DE6D3ECF805410AFF81354DF82541864C9C228FF80541FF9B8DDEF4F8254196FC364FCAF805411731B1C443F92541CE897272C0F80541AD0C988AE8F82541BC665E0531F7054109EEACE2CFF82541764B325BFAF5054144E567076CF8254134C5299712F50541848849F716F82541F4014B83F9F30541988532AEF5F72541165624B8EAF3054170438BE48CF72541D4CF1BF402F305417D41D1B376F72541987FB6203EF305413A06B5945BF7254178EE069C1BF30541568FC27526F72541B2F5285CB7F1054135EF435DF6F62541087FC25DDEF00541350AD723E2F625410852B81E83F00541F9285C0F82F72541C6CCCCCC40EE0541295C8FC235F825410A000000FEE7054176928866C6F8254132803B0528E70541182C5738CFF825410EC2B4E618E7054118AE476135F92541648FC2F556E80541EC51B81E90F925411833333353E905414AE17A94FDF925415CE17A1480E905414EB81E85F8F92541E27A14AE73E70541F4285C8FADFA254166E17A1438E7054111AE47611CFB2541943D0AD705E70541608FC2F58FFB2541EED6A37081E705417114AE47F7FB2541165C8FC2DDE70541548FC2754EFC2541A4703D0A53E70541FF285C0F58FC2541E851B81E39E60541AA703D0A59FC2541783D0AD71BE605418DEB51385AFC25410A52B81EF9E505418FC2F52866FC2541C0A3703D3EE605414CB81E057EFC2541DE1E85EB53E60541568FC27599FC25414C8FC2F59EE6054104D7A3F0B1FC254162E17A14D0E6054195C2F5A8B1FC2541F6285C8FF8E605415F6666E683FC25413E8FC2F576E705418214AE4789FC254158B81E8597E70541C6CCCC4CA5FC2541B2CCCCCCEAE70541A947E1FAC8FC254134AE47E154E80541380AD7A3D9FC254154E17A14DEE805417214AEC7F9FC25419614AE4755E90541B647E17A15FD254172C2F5287EE90541C11E856B11FD2541F6285C8FC0E90541646666E6EEFC254194703D0ADFE90541B547E1FAEFFC25419EEB51B808EA054155B81E05F8FC254102295C8F12EA0541FAFFFFFF0EFD2541AE9999995BEA05415F6666E61EFD2541C0703D0A4DEA05417E14AE4743FD2541C6703D0A09EA0541383333B35AFD2541343333330FEA0541A399991974FD2541423333333FEA0541DD7A14AEA2FD254136AE47E178EB0541340AD7A3A7FD2541748FC2F57CEB0541D4A3703DB5FD2541B2CCCCCC30EB054186C2F5A8C8FD25410EAE47E144EB0541AD47E17A41FE2541AC703D0A8FEA054180EB51B876FE25413833333377EA05415E6666660FFF2541600AD7A332EA05418E6D24EE12FF2541CEB7569114EA054105D7A37015FF2541A8EB51B8FEE90541693D0A574DFF2541CE1E85EB7BE70541265C8F424EFF25418A14AE4771E70541E57A14AE960026411252B81E5BE80541BA1E856BE0002641C8CCCCCCB4E705412085EB5149012641B0CCCCCCFCE50541DD7A14AE41012641F6A3703D64E40541BC1E85EB4A01264148E17A1450E205412C3333334E012641DA285C8F92E105419D99999923012641903D0AD791DC05418FC2F5A88B012641963D0AD7A1DB0541315C8F42E1012641941E85EBC1DA0541BAF528DCA90026415CE17A14BAD805418BEB51B8B30026419414AE4773D605417714AEC7D8002641EACCCCCC78D50541F051B81EF700264118AE47E166D405412D5C8FC2D2002641FA84EB5104D30541723D0AD7EE0026417E14AE4789D20541B21E85EB540126410052B81E99D50541A8703D0A840126410452B81E6FD405413669A2A28F0126419E7DD4C40FD40541608FC27595012641AC999999A9D30541C3F5285C9C012641F2285C8F8CD305412DE0F1C29E012641F68AAFED4DD205412885EBD19D012641403333334FD105411AAE4761730126418C47E17AB2CF05417B14AEC729012641D41E85EB5BCF05410DD7A3F0F80026416414AE479FC70541305C8F4230FF25416CB81E8521BD05413E0AD72343002641B6703D0A25BC05417DEB51B8CEFF2541B247E17A62B905419D703D0AFCFF254172C2F5280EB905417B14AEC7F3FF2541DEA3703D68B605418EC2F5A889FF2541F0FFFFFF15B4054193999999B2FF2541EE285C8F72B20541295C8FC265FF2541FBAD47E15EB00541F451B89E48002641C6F5285C95AB0541CECCCC4C62002641B8703D0A45AC0541303333B388002641D71E85EBB7AA05410FAE4761CB00264187C2F52806A805414BB81E05CF002641FA285C8F2AA60541DEA370BD160126416B3D0AD7E3A40541ED285C0F4A0126411C85EB51DEA205419D703D8A51012641E8FFFFFFDBA20541F151B89E750126415A8FC2F5D0A205410DD7A3708801264177B81E85CFA205417A3D0A573F03264102000000B2A20541D97A14AEA1032641408FC2F58EA005413B0AD723F003264144B81E85DD9F05417F14AEC7280426419514AE47139E054189EB51B821042641FC84EB51EA9D0541558FC2F5E503264158B81E858B9D05416F6666E6D2032641405C8FC2599D05417314AE47B103264114D7A370D39E054185C2F5285B032641CD1E85EBAD9F054156B81E053403264178999999EB9F054106D7A3F0F00226411A0AD7A3E29F05411D85EB51A1022641FAD6A370599F05412285EB510102264126AE47E17C9F0541F2285C8FA9012641AB1E85EB639F0541F051B81E920126417714AE47399F05419C703D8ADE00264191C2F5287A9E0541040000809E002641B0C2F528E69E05410CAE47E14600264147333333939F054192C2F5283C0026413C85EB51A89F0541D2CCCCCCF5FF2541643D0AD7BD9E05412C3333B3DEFF25419447E17A809E054184EB51B8BBFF2541428FC2F5D29D05411A85EB51A8FF254144B81E859F9D0541ED51B81E8AFF254176666666349D0541AF1E85EB4CFF2541405C8FC2239C05413A0AD7A3F2FE2541B4999999619B05412285EBD198FE254137333333119C054113D7A3F048FE25417B8FC2F57A9B0541C11E856BAFFD25412ED7A3703D9C05410EAE47E170FD254100AE47E1C29D054110D7A3709AFB2541B4C2F5285EA105416666666646FB2541F3A3703D809F054110AE47619DFB254124333333AF9C0541F151B81E9EFB2541D951B81EA99C0541A5703D8A10FC2541668FC2F53A9C054187C2F5A853FC2541C4A3703DC09B05418DEB51385AFC2541C1A3703DB49B0541373333B3A5FC2541536666662A9B0541CCCCCCCC07FD2541BF7A14AE7B990541D8A370BDA1FD254134E17A14FC97054183EB51B829FE2541F77A14AEC7960541265C8FC2A7FE2541C0A3703D4A9505412C333333F6FE2541EEFFFFFF7D92054107D7A3F0FBFE2541E7D6A370499205414DE17A1488FF254100AE47E152920541B21E85EBF0FF25412EE17A14FC90054104D7A3F025002641EACCCCCC3C8F0541B61E856B1F00264125E17A14C88E0541BE1E856B0F002641981E85EBA98D05412685EBD133002641C8CCCCCC8E8D0541F1285C0F6500264112D7A370838D0541A199991975002641723D0AD7CB8D0541E57A14AEAD00264191999999438E0541A647E1FAB700264100AE47E1DE8E0541325C8FC2E400264116295C8F2C8F05413733333305012641F8285C8F788F0541648FC2F511012641DFFFFFFF858F0541D3A3703D29012641037B14AE298F0541363333B3D301264184703D0A2D8F0541EF51B81ED1012641265C8FC2FB8E054180EB5138CB012641C8703D0A8B8E05411EFC0993C6012641BCC7E88E698E0541CD40DFFECA0126418D81C088588E054139A8E95E1A02264162FA5433AF8D0541BEDC4C34840226417D29BF3238890541953AB4C90D03264138ED74DD8C8905412AFE69746203264152A253DD8E88054120AD1D3FA70326410E660988E38805411BDD112AD80526418EFB4B88DF8A0541B93CA201F005264100DC96D7078B054188861242190626413B584EE7118B0541BAC0A55928062641761204CBFF8A0541EBFA3871370626413C394FFD1F8B0541B661950947062641D8C428CE018B054172CA043462062641648EBBDA098B05415AB13E00930626412AB5060D2A8B05410B5CD222A90626413C394FFD1F8B0541EF5FF846C00626413AF34979CB8A0541A0298B53C80626413AF34979CB8A0541259C9EF0DA062641D8A529E40F8B0541D2252097F3062641C65FDFC7FD8A0541C92946BB0A07264100DC96D7078B054176D2C64B15072641D8862AFA1D8B05419D4E7E5B1F0726419E4871BEF78A054105E4B6063B072641753103B5F18A0541F7E5C998460726412B1A0B7B708B0541A8AF5CA54E0726413D7F5481748B054145DE38B85A0726412A58094F548B0541B34E39C3610726413CBD5255588B05419ED83039FF0726418E6F32C09C8B054185FD68D91308264156398034E78B05415485D7ED200826412D22122BE18B05417C018FFD2A082641661AC6E2B28B054169E28F1339082641A0127A9A848B0541E93391344E082641C829E8A38A8B05411B6E244C5D082641040BA421DB8B0541FE334C9C900826412D031341EF8B05412251F35BB90826413D605597828B0541D4DC8794DD082641646FBCF0178B054106F81BC2FA082641C65FDFC7FD8A05414A51AEC3FB08264112FBDA59B78A0541AD47E1FA32092641CCF5285C438A054187EB51B8600926413E8FC2F5128B0541C6F5285C840926418FEB51B8B48B0541FDFFFFFFD1092641788FC2F5148D0541BA1E856B370A26411052B81EE18E05416B3D0AD7720A26414E8FC2F592920541A947E1FA700A2641C67A14AE57930541618FC2756B0A26416414AE479D95054104000080C7092641C8703D0A69980541548FC2F5C2092641DE7A14AE159A0541A2999919BB0926419B1E85EBD99A05417614AE479D0926411A333333C19D0541A4703D8A5F0926416D8FC2F5C4A30541683D0A57FA08264188703D0A8FA5054143E17A14D20826412085EB515EA605417A3D0A57220926411C3333338DA90541DDA370BD8D092641A0703D0AF9AC054186C2F5A8770926410A295C8FFAAD0541D5A3703D950926416EEB51B812AF054188EB51386F0926419547E17AFEAF05416D3D0AD7AF09264130AE47E1D2B20541628FC2F5C70926414866666618B40541C8F5285CFD092641C27A14AE33B505416D6666663F0A264132E17A1492B60541723D0A570F0A2641503333336DB80541C9F528DC2A0B264198C2F52864B905417114AE47730B2641C8703D0A23BA0541F9FFFFFF7F0B26410A295C8F44BA054192999919D70B264176C2F5282ABB0541B547E17AF30B2641E2A3703D7ABB0541315C8F42850C26418C99999915BD0541C9CCCCCCFE0C26410C0000007ABD054112D7A3707C0E2641E0A3703D6EBB0541AF1E85EBC80E2641B4703D0A9BBB0541B09FC5ADCB0E26416EC6E57E9CBB05413F0AD723CE0E26417EC2F5289EBB0541CBF528DC000F2641863D0AD7BBBB0541FAFFFF7F5B0F2641C61E85EBCBBB05418BEB5138F60F26416CC2F52862BB0541C9CCCC4C25102641500AD7A3BCBA05412F5C8F421E1026417A8FC2F59ABA0541410AD7A35A10264124000000FEB9054155B81E857710264114D7A3709DB8054151E17A1474102641D4CCCCCCA6B90541A1703D0AA31026413AE17A1498B80541AD47E17A82102641E47A14AE17B80541D6A370BDA2102641D01E85EB8DB605410CAE47E1F5102641903D0AD7F7B405412685EBD1C2112641F47A14AEC3B20541AF47E17AEC1126412E0AD7A3F8B10541BB1E856B19122641876666666CAF05412C3333B3641226410000000016AE0541E651B81EA712264189EB51B844AF0541558FC2F51F13264154333333F7AE0541BD16DB6A291326417026C31BEFAE0541F9FFFF7F25132641CE7A14AECBAE0541B447E17A09132641DA51B81ECBAD05413B0AD723FF1226412285EB511CAC05410ED7A3703113264112AE47E17EAB054105D7A370AB132641285C8FC285AA0541696666E69D14264175B81E855BA90541D9A3703DE0142641CCCCCCCC9AA805417B14AE47EB14264195C2F52864A80541E47A14AE15152641CC1E85EBF9A70541B647E17AC9142641B2703D0A17A50541BB1E856B20152641F0AD47E194A30541CEA3703D6B152641E87A14AE29A20541DFA370BD70152641D61E85EB0FA20541606666E687152641DAF5285CA3A10541383333338A1526417A3D0AD79FA1054181EB5138E3152641FCD6A37019A10541F9FFFFFFF5152641C2A3703DBAA005410AD7A3F01D1626418414AE4743A005417714AEC7791626410CAE47E1789F0541683D0AD7C4162641E0F5285CF39E0541703D0A57441726418FEB51B80C9E0541C2F528DC591726410F85EB51D69D05410A00008045172641698FC2F57C9D05413B3333B358172641C91E85EB079D05417FEB51B87417264195EB51B8929C05418DC2F5A80C17264185C2F528329B0541A747E1FA0D172641AB703D0A219B0541E17A142E3F172641D87A14AE999805419499999904182641C2CCCCCC44950541B21E85EBFD172641320AD7A322950541743D0A57EE172641DAA3703DF294054113AE4761D9172641465C8FC2C9940541D4A370BDC9172641225C8FC2A1940541558FC275BE1726419F703D0A65940541E17A14AEB7172641FEAD47E106940541CEA370BDB417264118000000989305416D3D0A57AB172641AC703D0A31930541D5A3703D961726419414AE47D19205410FAE4761741726416AB81E853592054150E17A94641726413085EB51D69105414EE17A945E1726415E6666669E9105418BEB51B85C172641FCFFFFFF779105414BE17A145E1726417E9999994D9105411E85EBD15C172641D8285C8F1C910541B31E856B5A172641F4A3703DF8900541F551B89E50172641ECCCCCCCCE9005417EEB51383B172641A49999999B9005411885EBD1301726411C295C8F7A9005410EAE47612F17264184703D0A639005413F0AD723311726415E3D0AD74B90054144E17A943D172641F051B81E299005414EB81E05421726417E3D0AD70B9005413A0AD7A3411726411A0AD7A3F68F05411785EB51391726413885EB51DE8F05418AEB51382017264166666666A68F0541B91E856BFF162641F37A14AE498F05414FE17A94DD1626410A85EB51E68E05413B0AD7A3C01626413C85EB51868E0541370AD7A39D1626410752B81EE38D054196C2F5A87B1626413A0AD7A34A8D0541CFCCCCCC6A162641DCF5285CEB8C05412485EB515E162641E2F5285C798C0541F7285C0F46162641F2A3703DC48B054142E17A14211626415D8FC2F5768A05410AD7A370FE1526413885EB51748905416E3D0AD7FC15264158666666688905419F703D8AAE1526419B1E85EB438605412B5C8FC2A71526417C666666EE850541618FC2F59E152641F2285C8FB08505413FE17A949C1526412FAE47E17A8505416A3D0A57A315264196703D0A0D85054104000000AD152641A11E85EBC9840541E451B89EB3152641CE7A14AE69840541E57A14AEC7152641AE1E85EB39830541713D0A57E6152641CC7A14AE4D820541B11E85EBFB1526414185EB51C2800541C6CCCC4CFF152641EDFFFFFF25800541C3F528DC0F162641F5D6A370197F0541DB7A14AE131626419EF5285CC17E0541D2CCCC4C12162641CA703D0A7D7E0541A199991913162641D6F5285C4B7E0541D9A3703D16162641F2A3703D167E0541F2285C0F1D16264158B81E85E17D05419399999930162641F6FFFFFF817D05411F5C8FC25A162641C4F5285CD97C0541380AD7A3751626411C000000747C05417214AE478716264118D7A3701D7C0541DAA3703D8916264198999999037C05411785EB518A1626413C333333F57B054106D7A3708A162641B247E17AA07B05417F14AE47891626413A3333333D7B0541E651B81E8B16264134AE47E1FC7A0541B41E85EB8B16264140333333CB7A054103D7A3F0891626419E703D0A9B7A05417EEB5138891626418014AE477F7A0541773D0AD78A162641280AD7A35A7A0541D1A370BD8A16264110AE47E1287A0541305C8FC27F1626414E3D0AD7977905412A5C8FC2811626416EC2F52880790541420AD7A382162641823D0AD743790541C3F528DC7F162641C2703D0A0379054108000080791626416E14AE47B1780541CFA3703D79162641E5CCCCCCAC780541CCCCCCCC7516264124E17A14727805415AB81E0575162641829999991978054112AE476175162641F1FFFFFFE5770541D5CCCC4C74162641D77A14AEB977054141E17A1449162641E4A3703DA27605413D0AD72337162641953D0AD76776054104D7A3F01F16264110000000B8750541313333B315162641FCD6A370817505417DEB5138FF1526410CD7A370337505419C703D0AF01526419E14AE47AF740541265C8FC27E152641E6D6A370A96F054132593299A3142641687DC720DA7005413F1CDCB984142641828D4A5E5D6F05416E82C3FE3D11264117C525C9CF70054165E27F0E3A0F2641BE60CE08356E0541EACD706BF70E2641EA4004A70A6C0541DA6A9970F80E26412E4633849E6B0541C34B96A0E00E264110F899EE976905413B04ED35EB0E264174FC08D9D067054143E17A94EB0E2641B1A3703DC267054110AE4761140F264101295C8F8264054133BD9D49150F2641C9A7A9B37F640541FC883E1BCE0E2641005E0C25D0610541EBF9EB45E30E264166BACD52D358054130B3A000300F26411C09D4516251054167FC05B6A90F2641221031E6FB49054164DD02E6910F2641F7458B10964705412C356580910F264174C08A8B8347054109000080F60E2641A31E85EBEF430541DDA3703D0C0F2641CA1E85EBC74305418CC2F528C51026413EB81E8577400541A7703D0A8D102641D6285C8F723B0541E27246008C10264158C48A4E513B054116AE47E1951026417214AE47293B054189EB51389F1026416EE17A14003B0541CFA370BDB81026412485EB51A43A0541255C8FC2CE10264140B81E85F33A054192999999FC10264142333333273B0541673D0A572F11264151333333D93A0541F9285C0F49112641C7CCCCCCAC3A054157B81E0569112641DA7A14AEAF3A054100295C0F751126410DD7A3706F3B05412185EB517A112641408FC2F5DE3B0541C9CCCCCC941126419147E17A5E3C0541D5CCCC4C9C1126419747E17A483C054104000000B2112641EAFFFFFF773C0541B41E85EBCA1126415414AE477D3C05410ED7A370FB112641783D0AD7373C0541C2F5285C4B1226419C703D0AC53B05417514AE476D122641CEA3703DDE3B05418014AE477D122641D451B81E0D3C05410BD7A370A1122641EAD6A370FF3B054142E17A14C1122641B21E85EBD33B054187C2F528C6122641803D0AD7D13B05414DB81E05E8122641CAF5285CDD3B0541F7285C8F0513264154666666AE3B0541CAF5285C7113264177C2F528603C0541265C8FC282132641FA84EB51523C0541AD47E17ACE132641B91E85EB113B0541CFCCCC4CDC1326416C8FC2F5E83A0541D5A3703D0B1426416E8FC2F56A3A0541343333331A14264108AE47E1BC3A0541DAA370BD3C1426412185EB51F43A0541703D0AD75F1426415EB81E85CD3905417214AEC7961426415F14AE47FF380541343333B3EB142641DE285C8F4C390541460AD7230B1526412CAE47E124390541DAA370BD1C152641FC285C8F823805411B85EB511E15264122D7A3704338054188C2F5283515264134333333B13705410800000063152641F4A3703D5C370541AE703D8A7115264173666666423705416D6666E69D1526418614AE474537054100000080AC1526419414AE47D1370541AD703D8AB015264141E17A14F8370541EF285C0FE61526412AD7A370B7380541420AD7231E16264126000000C8380541F3285C0F7916264103D7A3700D390541AA47E1FAA91626419DF5285C03390541E37A14AECC162641543D0AD725390541ED51B89EF0162641405C8FC2A938054166666666F2162641D4285C8F4E380541B81E856BFC162641A899999913380541B61E85EB1817264194999999F93705410200008041172641403333332937054161666666501726413A0AD7A3F436054116AE47E16917264188EB51B8D83605412385EBD1991726414233333385370541B51E856BA5172641E3CCCCCC9837054115AE4761CB172641D551B81E913705412585EBD1E41726415C8FC2F5C23705410CD7A370EC172641F4285C8FE0370541EC51B81E18182641D2A3703D1A380541E551B89E391826412C0AD7A3FA37054138333333381826418BEB51B8BE37054111D7A37054182641A6C2F5287036054109D7A3F0581826413C0AD7A3483605417714AEC775182641598FC2F54A3505417114AE4783182641AE999999353505414C6B0A5EAF182641A28B60D00E36054192999999B01826416A66666644360541696666E6AC18264122D7A37071380541E0A3703DB1182641E0A3703D783805418CEB51B802192641A2F5285C913805417914AE4739192641D8CCCCCCAA3805414CE17A9454192641DE1E85EBCD38054117AE47E1C4192641FA7A14AE67390541733D0A57E7192641C91E85EB8D39054150B81E85EA192641CECCCCCC8E3905417414AEC7E4192641A8F5285CE9360541E0DAE6B9E41926417EF029E198360541A947E17A3A1A2641F2CCCCCCB83505416F6666E6501A26416DB81E85AF35054198F56D17641A2641924E031BCD350541A5717A57C31A26417999241BCB3605410FF1FE2C2B1C26414E12B9C521360541DE28DA979D1D26418102EBC59E370541FE5EF9B78B1E2641026DA8C5A2350541F7632D98182026411CDF4C45E83205413D112518D91F2641D81C8EEFC32F05412EC73033A11F2641F23950C1032E0541874A24C37A1F26414CF765DA6D2C05416265B9EC6C1F26415CBA67739A2A054108AF9149901F2641BB4A43A578260541AEAD96A99F1F264113DC0BCB92240541657967F6AB1F2641C28371E4F22305412D8D0EAA10212641385441BD85210541723D0A576A2126412885EB5142210541430AD723A2212641285C8FC2F7200541DC7A14AEC52126413CB81E851D210541B747E17AF3212641EFA3703DFA20054109D7A3F036222641586666661621054145E17A142F222641D47A14AEAB200541F4285C8F1F22264151E17A14A01F0541F9285C8F1A2226416DC2F528F61D0541B61E856B352226412A333333BB1C0541A947E17A192226410D000000081B0541E651B89EEC212641A8F5285C071A0541D9A3703DAE2126419847E17A86190541B31E85EB852126418C703D0AC71805418114AEC78021264116295C8FAE18054106D7A3708721264182C2F5288C18054116AE476195212641A4F5285C3B180541BF1E85EB28212641C6F5285C3F1505419B703D0A2C212641E8A3703D621305412285EB517D2126419847E17AE611054155B81E85C42126410585EB51D60F0541FB285C0F012226410752B81ECD100541A19999993D222641ECCCCCCC7A1105413C0AD723A9222641E0F5285C4D120541B047E17A252326415D0AD7A34613054102D7A3706023264110AE47E13A130541E77A142EB2232641EEFFFFFF571305417714AE47C0232641A1703D0A5D130541636666667D2426419CC2F5288A13054154B81E05A9242641C8A3703DF61205417DEB51B8A924264160B81E858F1205417CEB5138C6242641F8285C8F621205419A999999D0242641E251B81EAD1105419C999919F9242641A2F5285C471105416766666627252641A447E17AB2100541618FC2F55C2526417FC2F52806100541D8A370BDB12526412885EB51460F054161666666AD25264177999999190F05413B0AD7A3E3252641145C8FC2E10E05412D3333B3C7252641CD51B81EF10D0541606666E6B5252641B4999999570D054181EB51B895252641D0285C8F840D0541E67A14AE8B25264132B81E85990D05415F8FC275762526415E0AD7A3C20D05418014AEC74A2526417F703D0A0D0E0541618FC2F545252641F17A14AE070E054194C2F5281D252641CA703D0A830D0541BDF5285C15252641388FC2F5660D05417314AEC7F2242641EA285C8F5A0D05415D8FC2F5E0242641E8A3703D540D0541C6F5285CC6242641598FC2F5540D05418EC2F5A88F242641D87A14AE570D0541733D0A578B2426411CD7A370C10C0541713D0A5785242641BD47E17A2E0C0541FA285C0F6A242641A2F5285C670B0541343333330324264106295C8F4E0B0541F7285C8FCE232641D751B81E7B0B0541EE51B81EB9232641773D0AD7A10C0541275C8FC285232641C8A3703DBA0C05412B5C8F42722326415FE17A14040A05418CC2F528B52326412E85EB51580A05412F5C8FC28C232641F9AD47E12E0805411AAE4761EE2226410C295C8F70080541FEFFFF7FDE2226415466666676080541B447E17A1D2326417C6666666C06054101D7A370F8232641320AD7A3DA0405419F703D8AC623264110D7A370070205413D0AD7A371242641ABF5285C7F010541706666E6E024264118AE47E1F2FF04419B999919F6242641A447E17A62FF04414CB81E854825264172EB51B82CFF04418FC2F52850252641C11E85EBCBFE0441315C8F425825264133B81E8565FE044188C2F5284C252641EE51B81EC5FD0441FCFFFFFF6625264107D7A370C3FD0441753D0A5788252641B0C2F528AAFD0441CFCCCCCCB8252641568FC2F58AFD0441DE7A142ED2252641CE7A14AE75FD044108000000FE252641C3A3703D6EFD04412585EBD113262641F351B81E81FD0441C8CCCCCC3B2626419C1E85EB9BFD0441275C8FC24A262641D251B81E93FD0441FE285C8F69262641608FC2F580FD04419E99991963262641CECCCCCC02FD044114AE476150262641BF7A14AE7DFA0441ED51B89E412626412B85EB5122F804410AD7A37040262641405C8FC21FF804411685EBD1222626415DB81E85DFF7044144E17A14132626419D703D0A1BF70441AB47E1FA4B2526410ED7A37061F5044147E17A9408252641E2285C8F80F404412F3333B3C22426413AB81E8597F30441AF47E1FA212426415C8FC2F560F20441EE51B81EB62326410D52B81E6BED0441DD7A14AEDB232641A6703D0A2DE804414DB81E85FE2326410DD7A37011E404412D5C8FC20A2426414AE17A14A0E20441F9FFFFFF7D2426418C99999985DC044108D7A3709424264114D7A37071D9044143E17A147E242641DCFFFFFF43D804419C9999194A242641B5703D0A87D50441BB1E856BBF2326413485EB5168D304419E999919EC2226418966666600D20441B01E85EBAF22264154E17A14FED10441683D0AD7032226419814AE47F7D104412285EB51C2212641E7CCCCCCECD10441343372CDA5212641745A6263E2D10441EF285C8F8921264172C2F528E6D10441C1F528DC5F212641D447E17AD8D10441A4703D8A55212641B3C2F52894D1044189C2F5A8DB202641DCA3703DF4D0044144E17A14A0202641D27A14AEB3D00441C01E856B2F202641A2C2F5281ACF04414AB81E051D20264112333333E7CE0441370AD723D51F2641B4C2F52820CE04415D666666651F2641EAD6A3703BCC044186EB51B8FB1E2641A2EB51B88CCA0441390AD7A3C41E26416C666666A4C9044146E17A94871E264116AE47E1EAC80441DBA3703D291E2641961E85EB3BC80441A747E17ABF1D2641A41E85EB91C7044192999919241D2641B0703D0A43C70441CECCCCCCB71C26419914AE479BC704418EEB5138321C2641518FC2F57EC704414DE17A94051C2641CECCCCCC8CC704414CB81E85F11B2641215C8FC243C70441D9A3703DB41B264184703D0A03C70441AD703D8A931B264118295C8FE0C60441D5A3703D7D1B2641F051B81EC9C6044198C2F5A8591B2641D9A3703D5EC604419C999999D01A2641E0FFFFFF79C504418CC2F5A8691A26412B85EB5110C404414AE17A140C1A2641943D0AD741C1044169666666051A2641510AD7A348C10441235C8F42001A26412DD7A37085C004411685EBD1EF1926419FC2F5287EBF04410A000080C8192641AA703D0AFDBC0441F5285C0FB4192641F27A14AEAFBB044115716CCED01926416FE088DFA0BB0441A6E2D37FCC19264120AD2AA609BB0441A057D974CD19264147DA1DCC53BA044183FF041DD519264144B4D08EFEB70441D3D6B834DE192641E0970953E0B404415FBD25DBDA192641B5155DC387B3044195A0F43DD21926412B30DDD390B204413EDF353CC719264195A72C43BEB1044135CE1FEAAC1926417DA6BC369DB00441813F6B58601926416A7B74F21BAE0441E47D90130D192641F85DA4BCAFAB04411C072E5BE5182641DD6FA7C5CFAA0441FD6FFCC1AF1826417EA899F3BFA9044119E883B76D18264105F78037AEA80441A20E5799F5172641B4307C5FECA6044114E713AB4C1726414213AC2980A40441E759A099DE1626410A79917DBAA2044100295C0FA616264132E17A144CA20441DDA3703D7E162641C57A14AEA5A10441606666E6361626410A85EB51CE9F0441C5CCCC4CF91526416AEB51B8E09E044100324168ED15264164AE3386479E044100B104E5B515264179180BE75F9D0441F845BD777C152641FBBB4482899C0441BD7B49E8F7142641CA8AF83C8E9A0441262B9ECE0F142641CA0B679B1F970441ACE81428A91326418051995194950441FEAADC230213264142792A5EDF920441E983D1BBE9122641BF71B650449204414D210756991226412D90C15B58900441AEB95D2C65122641267DE733448E0441A44937FB4712264152558802538D04415292368104122641C51E41B62B8B0441321BB88594112641C8B7B61E5786044199BDCCE327112641829D01D7D48104410CF712DBF01026419B1FE041877F0441B83A339DC9102641A5A0B5B2EB7D0441CC81F1A2A7102641F03C7B407A7C04417A3162CC07102641AC38F0456F7D04415A53722DF40F264114C3B2CADD7C0441DECE9766B70F26417B78EF6E277B044161A4EEBA990F264144460142B17B04414B1ED3737E0F2641F26BE76C337C04419EFA654F6B0F2641D465E36BB97C044186227C3E610F26417AE76133327D04413CE91AA40E0F2641206A72C06D7D0441E17B7989E00E2641EA20C3CD847D0441C2AC432BD10E2641B4C89025647D0441CBB46A579C0E2641500C3F65A87B0441AEC142D1470E2641BCB2411A297C0441DDC9A1635E0E2641A6287A2DB97C044198FF1C532F0E264112DEFF97717D0441F443E391EC0D26419E34679D337E0441092512841E0E26412620D8C3537F0441DE9BDDD3C10D2641E7D8D30CF77F044185F029D1600D26418AD7086A988004417B022365830D2641AE38B2A348820441A4919B9FD30C264190BAD72653840441CA87019EC70C2641E23972D5A3840441BA2AE6417B0C2641EB5F0F397585044141EE0EC93D0C2641E6DB3309DB8504414947E7482A0C26413E22649FF98504419FE41DD1C70A2641769801004F8804419EF155B39E0A26413F5166D3C8890441D47862DDF9092641BE4C4031AB890441E9CB8E7EF909264104F86D2878870441869256F45009264131675F0809870441A45D440CC60826411EFA80F9868704414B9F1229D1082641646E5D71898A0441F4C3E9A71B082641AEE8AD66648A04419F9E5C77F8072641E6EC0E132E8704418DF10C6BA1072641B26B85AA268704412010612898072641EE3E0955FE8504414EF9E9362E0726416436CAF726860441FB7ACDDF35072641F913CA00CF860441FF03CA29470726417478E9186A8804417DBFCB843E072641AE635A3F8A890441C2655E6D280726410E928E9BBD8A0441C2655E6D280726412E6A3B8B5C8C0441707606C4ED062641B43D806F978C04416994A4CF0B062641FCF1BEA0F38D0441D6E22E21970526411AFD1DB63D8E0441755F92E780052641F4D615DEED890441A66AF1FCCA0526416BFD8380F0880441FF2823E0BF052641C04F7EC2C08704413BFF6F0D7F05264151B8362F25870441D2B6687D47052641DE5ADDD70A88044156C111E1B80426412083338B1589044100790A51810426410278D475CB880441410B76902604264103359AF50E87044107AB53B6240426417289A708EE8504410AF410F83405264130615155E3840441A6CA9729760526417FA1B30E3D8304413D58EC0A7907264192881D1D467F0441293572AB6407264199577B25007E0441FDE8FA2AE80726417843D0CB7A7D0441D00962B9ED07264148885827F27B044164BBD7676208264148885827F27B044178DE51C77608264196916961817F0441CB20D6955A09264122774A8A23820441983C40BA68092641B6099EAEE77F04419BDF5CC467092641A2B842CDCD7D04411602147DB7092641042F66EA8E7C04410DFAEC50EC092641ED68B28E127B044122DB1B431E0A26412285F8C726790441D8B55E787A0A26419A9987A106780441FB0D91209B0A26414003D3441C770441FEB0AD2A9A0A26417547611D8E76044189FDD2FB6D0A264128424003177604417D48BD5D4C0A2641C69EB32C817504419205FA27390A2641086A931378740441CFA365E4570A2641D6953C9BF1730441EACF7E38680A2641E3176D8FFF720441C7774C90470A2641C7B939343A710441D32C622E690A264182BCCF79F76F0441EB4870C14A0A264135A5FDBA436F04415F8FC275900A2641DB7A14AE376E0441393333B3B20A264114AE47E1046D0441C1F5285CED0A2641F2A3703D0E6C04416D3D0AD72A0B2641C947E17AD66C0441616666E6810B264110AE47E1666B04410FD7A3F0B60B2641E8CCCCCCF669044116AE4761DD0B2641FE51B81E8D69044124EE643C050C26411C6FE0F1FC68044153F1DA1AF00B2641564BEEC9B7680441ECCE2362A00B26415AC046441A68044114828EC4350B2641CE5F7DA3976704411378BC5CDE0A2641357341DA1867044119DDC67EAA0A2641508605119A660441F1FB978C780A26419251E5F7906504412664188D2F0A264152C9D3B7B0630441B9DC56B2130A26419594B39EA7620441E0B3B33CEE0926413ADBD7BCD6600441B28C4B36BE0926418EA2612CB55E0441AE034FECAC0926410B4F7005DE5D0441A068590E79092641D06D4113AC5D0441C49C998E54092641562C4980F75C0441D12DBD043109264120BB51EEB05B04414E03DF1F1609264190BDE7336E5A04414E03DF1F16092641DB9AC0AE8759044176C01BEA02092641BE324B1FD45604411EF696D9D3082641C2A2827FBF550441B71E856B9F082641B4C2F528DA5404412F333333C9082641AAF5285C67520441CACCCCCCDB082641C3CCCCCC685104413C0AD7A3ED082641B0CCCCCC745004412E5C8FC2E20826416FB81E855D4D0441FF285C0FE1082641506666665C4C04410CAE4761E00826415C0AD7A3F64B044157B81E85F708264128E17A14CA4A0441DCA370BD1D092641CE51B81E8F4804414FB81E85350926414485EB517C470441DC7A14AE8D09264116D7A370094504418CEB5138D709264150B81E856F43044186C2F5A8CD092641F17A14AEA13F0441A747E17A1D0A264172666666E83C0441B11E856B5B0A2641C847E17AD43A044191C2F528D20926413D0AD7A33239044195999919FB092641B4F5285C5D3704413E0AD723770A2641FAAD47E1C03804412F5C8FC20F0B264192EB51B8C2360441F8285C8FDB0B2641773D0AD783330441638FC275E90B2641323333334B33044196C2F5A8440C2641923D0AD78733044146E17A94B30C264140B81E85D13304413A0AD7A30D0D2641BEF5285C0D3404415F666666130D26419C999999B73304417814AE47450D264198703D0A33330441353333B37C0D2641D4285C8F34320441AD47E1FAB40D264174EB51B8A430044192999999CA0D2641E6A3703DDC2F0441DE7A14AE120E2641EFA3703D9E2A0441040000801B0E2641DACCCCCC982904411B85EBD1100E26413CE17A14FC2804412C333333050E2641FED6A3705128044196C2F5A8EA0D26415C3D0AD76327044198C2F5A8AE0D2641A4EB51B80A260441BB1E85EB770D264198C2F52812250441F8285C8F280D264102295C8FDA250441C5F5285C880C2641D47A14AEAD260441C1F528DCEC0B2641F251B81EA9270441C4F528DC2F0B264182EB51B85A2804415AB81E85A90A264116000000E8270441BFF528DC120A2641B447E17AFE26044157B81E856709264176666666F22504419A99999966092641468FC2F5F02504419F999999AF082641E9FFFFFFDF240441315C8F425F08264148B81E8597260441696666E66A08264152666666922804418AC2F5A87808264194EB51B8302B0441EF51B89E85082641F2D6A370B12D0441E951B81E0F08264130AE47E1082D04417FEB51B89F072641E9285C8F6E2C0441F251B81EF70626414B8FC2F55E2B0441A9703D0A34062641A8999999BD2B04411A85EB519F0526413C8FC2F5082C0441568FC2752A05264102D7A370892C0441E0A370BDD50426419C47E17AE62C044193999919C4042641863D0AD7F92C0441A5703D8A7604264127333333872B0441AC47E1FA15042641CACCCCCCB8290441CCCCCCCC6E0326418E703D0AC32A04410700000008032641E8285C8FAE2A0441CFA370BDF6022641F851B81EAB2A0441B747E1FA3D022641AAEB51B8FA2A0441E67A142E20022641C147E17AD02A04410700000090012641D0A3703D042A044156B81E850101264170B81E85932904410BD7A3F06B0026411033333351290441A299991908002641A2703D0A812A0441235C8FC27BFF2541C0F5285C792C0441DD7A142EE1FE25415C3D0AD7792E04410700000030FE25412885EB51223104410FB755DFE6FD254142ED8061303104418B73B210A6FC254124423D2B66310441BB5236C74BFC25415411738975310441515F9E7460FB2541BC2E79F4E4310441491FE150A1FA2541A21BB5BD63320441B11DA6E1ABFA2541F70FA8E6163204417CAB53799DFA2541702437C0F6300441FFEF511EA6FA25411EA07BF72E30044141F3C7FC90FA2541FA5797A7A42F0441F7C338CA95FA2541F82A2EEECF2D0441400DE8BC7EFA2541DDEF2118F12C0441C0F528DC57FA25418FC2F528BC2C0441BAF528DC42FA2541408FC2F5A8290441275C8FC284FA25414285EB5148270441950C6C3846FA254120F3885AFD2604416FD869991EFA254109129930D524044194BB249F02FA25418CD392638123044139818C9EAAF92541CA34AF9A6F1F0441B52CF773DBF925412C0F80FB3B1D0441F79EE7F4F8F92541C45E8DD5D31B04411C85EBD104FA25415E0AD7A3081B04417F14AE473FFA2541C2A3703DE018044145E17A147BFA254156333333A31404410BD7A37094FA25414D66666666130441F5285C8F99FA2541240AD7A326130441BCCC9125BBFA2541E6FCB6E4C511044143942B99D5FA254127FB86045811044162942FC1DEFA2541B7865A2BB1100441D0B066AFDAFA25417F111EB2E50F0441D1943B39FAFA25415C27A5BF4E0E0441C0236BF825FB2541FF700A09660B04413BCFD5CD56FB2541C7FBCD8F9A0A0441B30858727CFB25412A14951D9609044126EC1C5C77FB2541311025BD950804413BCFD5CD56FB2541B9D236E078070441F30744AA4EFB25410D26ACCAFE0604419F15E5E552FB254120B4454A19060441BE1E856B79FB25411E0AD7A3BC050441E651B81EA5FB2541E0A3703D620504418AC2F528E4FB254136E17A14EC0404416E666666FCFB254150333333CD0404410CAE476112FC2541CFCCCCCC96040441C6CCCCCC15FC25414DE17A1488040441C4F5285C18FC2541BB703D0A710404410DAE476115FC2541D67A14AE47040441343333330DFC2541F6A3703D2404044150E17A940EFC2541DA285C8FEC0304414AB81E8513FC254157333333D5020441DD7A14AE13FC25416AEB51B87C0204413A3333B316FC254144E17A1454020441B21E85EB20FC2541478FC2F5CA0104419DB5EAD708FC25414E479AA43D010441A20BA89233FC25411CCEEDCA71FF0341CDB60A1852FC2541F41D03F51BFE0341BB453AD77DFC25416E51E130CAFC034105F1A084A5FC254107DC9417DAFB034156F1A8D4B7FC2541B0827FECE5FA034199999919E3FC25416A6666667EF90341D5CCCCCC53FD25418F3D0AD7E7F503413C3333B3EDFD254150E17A1444F30341AC47E1FA77FE2541D151B81EE1F00341E17A142E1BFF25412ED7A37075ED0341B71E856B0E0026418EEB51B874EB03417D14AEC704012641FD84EB5160E70341B41E856B24012641728FC2F5DCE60341F451B89EAC0126410652B81E77E903418BEB51B83F022641A61E85EB35EC03417114AE47A00226416A14AE4703EE0341235C8FC2FA0326416614AE4793EC0341578FC2F516042641A7F5285C75EC03418DEB51B82D042641563D0AD723EC034190C2F5A8950426418414AE4775EC034137333333BE04264106295C8FFCEC03411BAE4761D604264128D7A37083EC0341A6703D8AE60426415A8FC2F5F2EC0341F8285C0F270526412033333377EC0341656666664C052641CEF5285C7BEC034187EB51B8230526413B8FC2F5B6E8034193999919D80426412EB81E85E9E10341783D0A57F604264170B81E85C5E10341D87A142E8F0526410CD7A3700FE10341174290DF8C052641C2EDA67340DE03412585EBD18C0526414E3D0AD72FDE0341AF47E17ADC042641120000006CDC0341568FC275B20326414285EB5192D803419B703D0AC30326414CB81E850BD60341DA263211F10326418CDFE99505D1034110D7A3F0F10326411E333333EDD003414FB81E8574042641E2FFFFFF69CD03415E8FC2F58A042641290AD7A324CD03416B66666698042641FE51B81EFBCC0341C7CCCCCCEB042641DA51B81EF9CB0341EE51B89E0B05264166EB51B896CB0341060000807C0526415E0AD7A38AC90341773D0AD7D8052641448FC2F5CCC70341303333B33D06264196C2F528E6C50341E0A370BDFF062641EAD6A370E3C30341CFCCCC4CEE0726412E0AD7A3CCC103418CEB51387308264117295C8F06BF0341E451B89E5209264140E17A14AEBF03418AC2F528A609264160EB51B8ECBF0341FA285C0F330A26412F333333D1BE03411AAE47E13D0A2641A6F5285C43BE034197999919430A2641A847E17AFEBD0341693D0AD7C20A26417C999999AFBE03414BE17A14BE0A2641726666669CBE0341723D0AD78A0A264128E17A14C8BD0341DAA3703D6D0A2641869999996FBD0341989999195D0A2641DDCCCCCCF0BB03415A8FC2F55B0A2641F4285C8FBEBA034112F1424E8E0A2641FC3A2093B0B803417B9CAD23BF0A2641326A8E6E5EB6034194D63F68090B2641147955FB0FB30341F2657B9F500B2641206E251A58B00341BA9F0594880B26411A6535B932AE034109A129FCDA0B26411A6535B932AE0341FD851676310C26414A0E600ED1AD0341743D0AD78C0C264103AE47E118AD034196999919950C26415C0AD7A3F0AB034102000000A90C26415814AE47FFAA0341588FC275490C264105000000C4AA0341E57A142E0F0C2641480AD7A372AA03413FE17A143A0C2641583333336FAA034188C2F528140D26414AB81E855FA903416C3D0AD7650D2641EECCCCCC9EA803410BD7A3F0D40D2641BA47E17AC2A7034105D7A3F0850E26415A6666663EA60341568FC275330F2641628FC2F5BEA403410DD7A3F0AB0F26417899999975A30341B91E856BBB0F26416B14AE474BA303410AD7A370ED0F26419E999999C3A20341DC7A14AE1F102641A6F5285C3BA20341F651B89EAA10264175B81E85C9A00341BBF528DC4A1126411052B81EB59E0341430AD7A3EF1126415614AE47999C0341598FC2F50C122641370AD7A3AE9B03410DAE47E13112264192703D0A879A034110D7A3F0651226415D8FC2F5E6980341D1A3703D9B122641A014AE4711980341245C8FC2CA122641280AD7A352970341673D0A574213264196C2F528769503413B0AD7A360132641CAA3703D8E920341CDCCCCCC711326417414AE47E9900341E951B81E7913264111000000988F0341343333B3731326416EC2F5289A8C03418FC2F5287C132641BF703D0A658B03418CC2F5288A1326414466666664890341080EF650C2132641F29E4A7C52860341D7A370BDC313264114295C8F3E86034112AE47E1BB132641CE1E85EB7B850341E951B89EAF132641AEF5285C0D8403412B333333891326419D99999921840341B71E85EB371326411233333335820341C9F528DC1D13264124D7A370B981034108D7A3F02713264124AE47E16E8103413FE17A9430132641BA1E85EB9181034194C2F5284C132641F07A14AE018203412685EBD17C132641F5A3703D108303416C666666A7132641C4703D0A8183034115AE4761A5132641165C8FC2E782034109D7A3F0C5132641CD47E17A2E7F03411F5C8FC2E2142641A4703D0A6D7A03413B0AD7233D152641D851B81EE97803410FD7A3F0AB15264136B81E853B760341353333B3301526414E3333333175034116AE4761DE142641283333337F740341390AD7235A1426417E14AE4763710341A947E17ABF13264198999999FD6F03412785EBD16B132641230AD7A3FC6F03419B703D8AAF1226413B85EB51307103411E85EB5137122641FDFFFFFF6D7203419E99999996112641FC7A14AEBB710341323333333811264126E17A14626F03416766666615112641E151B81ED36E0341F451B89E1111264174EB51B8B66E03412F333333D310264139E17A14E26C03417614AE47B3102641FB285C8FF26B0341FF285C8F5E102641D0285C8F9A680341DD7A142E5C102641A647E17A82680341CECCCC4C710F2641E6A3703DE067034113D7A370960E2641A4C2F528746703410CD7A370CC0D2641B647E17AD06603418314AEC7350D26417CEB51B84C65034188EB51B8560C26410085EB51126303410AD7A3704E0C2641C07A14AE13630341DF7A142E0E0C26410E295C8FCA600341F051B89E640B2641D81E85EBC1600341285C8F423D0A26412EAE47E1B26003411B85EB514C0A26419BC2F528F45C03411AAE47E1FB092641D47A14AEE95B0341AE703D0A4A09264108295C8F9C5903418AEB51B8D10826410FD7A37017580341E77A142E73082641E8A3703D76570341A0703D0AC108264109295C8F56560341666666661C09264143666666F6540341CCF528DC4B09264160EB51B8F8530341AE47E17ABD082641B71E85EBE5540341004CE2858208264117863FCC635503416B3DF8B75C0826418266C02A25540341A4847B709907264156AF8F9ACA4D034185C2F5A875072641CE47E17AE44D0341636666E69B0626413A5C8FC2CF4E03419E9999198E062641EDA3703D924F0341B61E85EB4F062641896666666A51034150B81E0526062641CECCCCCC0A52034147E17A9410062641368FC2F5CA5103411785EBD187052641CE1E85EB335003419A999999A204264169C2F528AE50034113D7A370F2032641B247E17A944F03413A3333B32C032641B4999999754E0341C4F528DC2E022641728FC2F5504F0341C5F5285C6001264118295C8F9E4F03410681EEB1600126419E914948A14F034163EB3AA260012641E2C81B7BA84F0341416203078F0126417E4D42551D510341E08E25FBBA012641E43DE9FD84520341740C584508022641CEDDAF8E445503415C368E5D2A02264129FA004542560341080581024E0226416666DA16A8570341F0FA21A483022641615E37C3915903417DDC9C119B02264132E70FF3995A03415FB78158A60226410F97B083DF5A03411C0BD60CAC022641A0739A78355B0341ED13BBB9A9022641051D2B078B5B03410A05097DA5022641B607D003325D0341494B69639F022641F4E34AF9D25D0341B805D213AB02264158CC689D6F5E034183F7586CC5022641FEF1FE550C5F03411BD7B094D80226418D1FBA11E05F03419A6122DBDA022641BEDC3BFE1561034141CA219DD802264128713DDF436303416CA09302DC022641F2CDD355536403411BD5298FDA022641CA3E78D19C640341A2630DA1D2022641497B3FE6E9640341C98AFBA380022641E0E1AEB7F1660341F317350C2F02264177307BD58568034192AED8FAB40126416868553F59690341EB7956336501264192053C749B69034160B57E2FE0002641F6C06D0AA46A03414E64BA1D7A00264106F264713E6B034146DDE5CD480026414ED21E6AB46C034128D97B89E2FF2541E4FFA57BB96D03415C1BCAAD50FF25410145083E0A6E0341B665D4DE4CFF25412834D98D1A6E0341AD63B19948FF2541168A9EAA296E0341544BD5DC08FF25416BA4940CD96F034142C6CB4F01FF2541B6C57CC2EB6F0341DC07895C76FE2541ECAF59BC6A7003412EF21C3F08FE25414EC3771902710341B37C72523CFD2541348658087572034176D0525199FC254120D5F07B3A740341BB61560718FC2541D7F962E2657603412A2284C09AFC2541C22F3F4E6778034143C032A1E7FC2541DC20B9F7177A0341B3FBAE4F3DFD2541D914004DDA7B0341960EF71195FD2541264C590EC07D0341C7B8C3D5B6FD2541484BCD67B17F03415D625704BAFD254192D0FAEC3D81034116181554B1FD2541E7C41F416A8203418453D108A3FD25418C532A74F8830341D0BAAE9BAEFD2541D6FAB559648503418D57EB51BEFD2541F4552CD10B8703416432FCD9B6FD254164D7E255EB8803419272C7AFB6FD2541368B18956A8A03418FC1D4C3A1FD2541503D0529D48B034106FF7B3E8BFD2541A005451A848D0341B631C34498FD25412CC35EB21C8F034195DCC89DD8FD25413465874242910341CBE862BDE5FD2541729B2F047593034119CDF547F4FD254171462E9784950341435EC535F6FD2541491276892C970341C6CDBEDEF9FD2541573E849856970341C6CFB5E210FE2541239E17123D990341023136E42EFE25413672F306D19A03417E876A361FFE25418E740062059D0341201E069E15FE2541753B54FE1B9F034107C98FBA1DFE2541620D48F11FA0034149C269922AFE2541AD53E86065A103411667FADD3EFE254134A7A8D48AA203410F18518A4DFE2541E731D805D8A30341FF4551F03FFE2541F6CB43E763A503415FE5998527FE2541CE835BD33BA70341445C76AF04FE25410CB104E6D6A80341763A68EBF9FD2541A1E846A447A903411CECDFB0E8FD2541F0DCFCF8BEAA03412EEEF6B7CDFD254108D8314FDBAB03411D1E0E25A5FD254103234C17DCAD0341438EE4295DFD2541297902E3C0AF03413A3F435DFBFC254130FF71684BB10341CF9F660F9DFC2541BDC0FEAD87B30341B0F9A75677FC2541A458828D83B403412EBCDC2130FC2541B6660240EEB503410C6175F4D3FB2541B25FD596A4B70341DD9DD79B7FFB2541524F6EE9DCB803412467064E3EFB25419CC00E121DBA0341A172B31CE8FA2541143A08E862BB0341EB56A6B060FA25415B24DAE3C0BC0341721519B5D8F92541895917F947BE0341CB65B8F6CEF9254100A9CC1367BE0341FFF28D9E83F925418C2DFEEBFCBE034153D7E4F2F5F825418C7414060FC00341E9EEFF9FBFF82541C1A20A17C9C00341696018D737F82541B05187559DC20341F254F752E5F725413FE813E2DEC403419DA0DFF5A7F72541D55428092BC603414D076C7756F72541A4162F4C3DC7034151A3BBDC02F72541649E9CCF99C7034117AC7CCFA2F625412A57D80DE3C7034145D30E99E6F52541E04D930B44C80341583D009259F525414430AF0320C90341CF614EFDB8F425415639A3B496CA0341DBCB63B089F42541573D16623ACB0341FA207E5A17F42541685E5070A8CC03411D278BF0B9F32541CCFACBF83ECC0341FFEEC3B473F32541FCA54F8745CC0341E699DDD262F32541E6A4D23161CC034164A3E39840F3254184CA9C94CCCC0341DDC7A102B9F225410DE4B84A1BCE0341E6168F2C46F1254144BA653ECACE034116A27DDE02F025415618FBB9DED103415F84D1F03EEF2541C65DC92F0ED60341DB8F9EC2B6EE25416EAC8A4F81D8034134C1576BB8ED2541162FA82D03DC03410F3422D309ED2541D59AFC0372DF0341F7C51A617BEC2541295D514CD6E203417220454229EC254132B2BE6CA5E403417E86DCEBE4EB2541EB855F0C53E603411ED477D592EB254124483950AEE70341C34FF32165EB25419848925321E90341D1A2F6C40DEB25418A20F7F19AE903410A0059C680EA2541765B5F5F90EB03414B42E3208BEA254166B47ED5F2EC0341562FEB597EEA254138333F0213EE03415093DBFA6DEA2541BA34490539EF034175CFC4065FEA2541C62828065EF10341DA85C37204EA25416573AA22FCF203411800F9D586E925416CEA75A3AAF40341AB2AB010F3E82541B4CA2F9C20F60341EC8B14DF42E82541B9892A8B31F803417E69FD9606E725412870E2DC5EFA0341985685DC31E62541C9B9A8FB28FD0341821CDB6183E525417A0307C655000441E2E9F364E0E42541EA89494C2902044108D9066799E42541FAB9275F73030441FF40451921E42541268D4E014B0604410B5E4C43ADE325410CEDFF28BE0904416EE0B53866E325411693F8BC030D0441314B68414FE32541AEA7201DC10E04419B20699227E325410689E86B661004418B4AB36FF8E2254135A2C9CCCE110441A96D4FAA7EE225411ECB33DC9412044111C2747C19E22541941EFF4DDB1204410BD7D71556E1254182A4AD7B5513044123DD30F0B3E02541FE82171E9E1404414E5340CCFBDF2541F44FA8BB5B160441AB034667ADDF25413C0F7AFEBE17044187F9C24E85DF2541707A11D026190441B6ECEF9959DF25418F015B01121B0441B7243B9967DF2541AC9F74E5271D0441E32C83F04CDF2541CDB7A446DD1E0441DBE177A93EDF2541B652827F2C210441DA6064ABF4DE2541848B88EDBB230441A31859059FDE2541B05A99386C2604414F4DDF9CEEDD2541B631DA8474280441882B3D206DDD25414784AA50F72A0441270D30132DDD2541C26214F33F2C0441D8755B1618DD2541E09D5EB2A82C04413711B6A3D1DC25413CD2521C1A2E0441D20D9132A9DC254124B9D2706F310441599C7444A1DC254111A8F518DB3204417F8FADCD94DC2541E18EB415203504416E06263778DC254134050AEC01370441514D7BF564DC25416237A7542E38044151CC0F7540DC254106D06C3428390441BB6915C255DC2541DD8311735C3A044184298EA981DC2541962BDF58C63B0441548198E6A8DC254168AA9F85E63C0441D0DB12C3A1DC254186FC73A4723E04418812941598DC2541EB7FD382F2410441D5F6B6A18DDC254150AEEEEC50440441985F72A65FDC2541CA09FD0F5B460441C6D521793DDC2541291FED7240490441504DD3773FDC2541DE61ED352B4A044180BF743F21DC254174F4D26AFA4B04411DEECD3D00DC254194F45F183C4D0441E9130A10D5DB2541A6D66967DF4E04412624FE7E99DB2541E0AB5A5DBA500441FFE71CFA37DB25415A4A6943AF5304419393573107DB2541A208C5DB45550441DF3FF73EE2DA254168421848F45604413845EFF9C3DA2541626B775999580441529460CEA8DA2541285799AB245A04414796131594DA25417CA8931E505B04412486E36F33DA2541C4BCA9D5D45D04416F6EA4080CDA2541C0BE1E85A65F0441C320ADE5F3D92541B4956ACFCF6004414D9470DCC7D92541FAA19A2B0D620441513030408DD92541246DDB729D63044122B8A96C66D92541D2673DC87064044178D65A403CD92541B2F5DC4E53650441B5E4C7A902D92541E59F013602670441BC3371FDF3D82541742C76BF5B690441F692AAFFAFD82541424DD979776B04417838902C21D82541F67E4E3D296F0441D907F02EE0D72541E3849EEE3B710441B4FB5D9662D72541E32A6ED6D3730441B27ADA99FFD62541836F4B9D2D760441D89F99198AD62541D496445C63790441928BE3E384D625417B667D4C8E7904414FC21084A0D52541A208338AF57C0441F10D5DE75CD52541B84CB0A2C47D0441C5B2E97BE1D4254130D3BE7EC97F0441AC91481572D42541D6A83C22E6820441452669B589D42541EC612A6715860441953C7AAF9FD4254117963C7F138904412701F679BAD425417DE90FA3A48C0441388A4591CAD4254155D110A0E78E04415DC4FF1998D425418C998F39878F04412F84344498D4254122B57543D98F0441FF0FF4FA79D42541708D15373990044171E3498CF6D32541E1D0B4509E910441FC8EE883BFD325414E716FDC0992044185CE1604A7D32541E4BBC84CFA9204418DD2505090D32541DC1BCF189F930441A3F1923B5FD325418A2E77CB699404412D67DD3731D3254180CB1E58BC9504412FCF07250AD3254125202877F7960441B2F538CFD1D225419D94954B499804413ED56C3D87D22541D2F68AC4959904411EB0390854D22541A436BEDB6E9A044164411DBB04D225415EAA8C59469B04416EAD81F4C6D125416FAF0D5D199C04412C33CC9D7CD125410EB80561999C044171453BD41FD12541B65FDE44249D0441D1E05DE2CCD02541BA170C2D3E9D0441F3A1C8006ED02541F27BA24DE09C0441496F45C4C4CF2541F2718A4AF89C04414584A0D671CF25417C35ECE1589D04411B5D6A5F08CF25415ABB0264709D0441D99377FC55CE25418296A3ADB09D0441DDE2B8D8BDCD2541E2E8F1C9129E04416B71D0B232CD25414EA5080A9D9E04412E14B63EEBCC25413443313FDD9E0441D82B7969DACC25419C614C49DE9E0441FDE82578CACC2541A42CA38CB09E044160EC527082CC254168CF6DBF269D04415437D63C39CC254148E2F7C3649C04410ED6817C08CC2541DA7655F4DB9B04415EA302F7EECB254118EAFE180F9B04418A2C9E52BACB2541A410EDCDEB990441D942CF4F9ECB25416A91B6F6FE98044125AA3CE490CB25419D73503FBA970441E42D180487CB25419012CD1D3197044136AE127080CB254128DDE160059704410BD2BBFE37CB25411B5F8CE090960441E5954A78EFCA2541747C99946296044135DEE1689CCA25414E93CAF0129604416920108A3CCA2541C4D7F15D7D960441FF80DBB903CA2541CCFE046CFE9604416B072779CBC925419E6522E5AA9704411F55C26279C925410E6B4D3D199804415C9D91D232C92541B4B2415695980441CD3EB9EFF2C82541BCCAB05F3A9904418FA9FBF9C2C82541A4EFA7C15C990441557ECFF39BC825419EC8F10958990441962ABB4532C82541C8F66118E8980441348FA0BE14C82541FCF99DC3AE9804418AA7A405B2C725413E0430C46C970441AA4905B890C72541964DB3DB05970441E9C5499B68C72541C2417F2CBF960441733B5C182EC725413C27A7789C960441F27A7E5AF6C62541C5CE4F0562960441880B497B56C6254174656C8BBB95044189F227EBD8C5254198846C3F3E9504416569A054BCC52541B9045869E7940441FFAE83E86BC5254140B248F574930441FF2B916249C5254154062610F49204413A42526114C525415A10AD129192044102FE1C47AEC425414741BA756D910441D14F627B5EC42541BF26856BCE9004419428648301C4254150A8284042900441012EEC3FCAC32541822922C01A900441738414549BC32541965A2BD0ED8F0441477289EA29C32541F4CA649F8B8F04416AE61DFF92C2254114B05196828F0441E1D4BFEC20C225419834B718E78F044147BF8B4EBFC12541085C40D134900441F85B6CCB64C1254104D987FB79900441F4EFCB5B06C12541DA975D91E690044130040655D3C02541089AB4922B910441065ECB5F75C0254100E68A58009204411B47B94F4DC0254122A8009BC79204416193320A09C02541F93048CA84930441C67B5FEA6ABF25415F1B4A1DA8950441F5A20930EDBE25419B8723EF0D970441BEDDF00FBABE254130EB3867C2970441E96C917A98BE25416FB80F5887980441A3D361B972BE25415E5F039290990441874EDCEF32BE25413C22182BD29A0441C8C41BC4F7BD25412C9D9501149C04414ED41A5BC9BD2541E7FDA923E89C0441145E7F4D9ABD25415037088EB79D04413B83764C31BD2541C8B47411A19F0441A49F689BFCBC2541A06DA551C9A00441F49EDF0A93BC2541C68544B233A20441C17516500CBC2541BFDFA52894A30441357F4857D7BB2541A8479D4DA1A40441C2DBF93D83BB2541FA89966574A5044141CC6E75CABA25412620BFF021A70441A99D51C6F7B92541A216CC46DEA804410E0BD82EACB925412157A9B252A90441B9D395CC3FB92541368D9B1A96A90441E2F84CC53AB92541AC32AEFD26AA0441CAC22054A1B82541C82AF8F9A4A90441E3FCD625DFB7254151C415D6DEA804415ECEB9760CB72541C6D66F8357A704410752F59F6CB62541E86073B0E8A60441B2CF2BBAB9B525411C2AAE475CA604410E378959FDB42541768ED11540A7044121A339D77AB4254136336E4E04A804416FB7CB5222B4254108238C9C33A704412BBCCA7E81B325415671720913A60441925D765F09B325411A2CE0EFFCA404415B15A338C0B22541528B8DB82EA40441CC3527564FB225416123CA3DF0A204419910F4201CB22541B033993F55A10441F392D9520DB2254132DC8ECA39A0044194F390BD25B225415EABA261C09E044154ABE9D7C9B1254113A7ECACEB9A0441AF166DFE47B1254159247A2A389A0441DE07FBC7DFB02541F21BD02B0A9C04417CEBAC3FAAB02541C91218D7AC9D044186892771EAAF2541B677215645A1044162C6CDD5C1AF254114809F5CEFA20441955721878BAF25411DD97F2A62A50441987434EF36AF2541AC8BC5C13EA80441AAA8D1ECB2AE2541E652885D0AAA044135D3CCE44AAE2541360EB348FBAA04412B844B1BB7AD25417EC30F32FAAB044152D9798AF3AC2541C82682002BAD04416ADDDB603AAC254121C9199005AF04413A1EA495BCAB2541040942A9BDB00441A03C5DF021AB25410C6D53CE68B20441FC6D0E1294AA25411F91E7352AB504417745B66B38AA2541F4DD8CA93EB70441F0691C53D6A925411E25B673BCBA04414650D222E9A925419B4507859FBD0441D0FB901D80A9254164276E2ABFBF04418113C08FF8A8254197E8BF1A15C204417C2C612CAEA82541AF0E5280A8C30441E267991DD8A825413096A25CABC504410A590B9B31A92541454B1DF436C8044112F3E3EF8EA925417CDC3F801ACB0441D0AE4A152FA925411DCFD5D529CD0441D161AC8A03A92541862B65A121CE04416F4190FD6DA82541C90D944969D10441AD080C6941A82541C02A3AB0D0D4044105A064291EA82541A486782AA0D70441F435EF8553A725412C5FC379CEDA04418CB1861E64A62541501F0714F5DC04419ECEA9942EA5254166C23DFA49DF0441F395614F0EA42541E82BA32311E20441541863CD3DA325413B648438FCE2044134277513ACA22541FDD71E0C05E40441E444199350A225410520772615E504410D4FD8FA84A125413A773B4829E70441F12D5F1E73A025414A1E1986F0E90441C838571BC69F254146AF336089E90441A9FCC1DA1F9F254153C39EBB3FE90441AC9602C0769E2541565A8797CAE804418E54A0EFC99D2541C49FFB0254E80441EB74240D599D2541060DBDCA11E504419BDB0811E29C2541C622B724E5E304415A424D1ED59B254170ECAA611EE1044152A894CC459B254183FD87B9B2DF0441D9E73AD2D59A2541153DA17508DE0441FDD84C5F359A25413E2EB616F2DB0441AEF4F9DAC29925417E7778D67ADA0441304B4A79F19825410A2FF064A5D8044165789D941C982541A103C054E5D70441EA3847A347972541523A670FE5D604418018A752EA9625410251826F53D80441CA90096CB3962541C4C592ED28D90441DB47B9F21F96254150AD93EA6BDB0441A3BAD355BC9525416647CB2129DD0441ED68AA6D4A952541A2B717A132DF0441E87F8C85F5942541D6572485F9E00441B4A3D153B3942541B0C280017BE20441648D18DC77942541F42E262912E40441FC1B0475FF932541C6D1286598E60441C9F2E2379E932541DE61A5EFE9E80441E0C6451D4C93254164051ED63CEB04418EB0ACA8DE9225412EC0F76F05EE044104208A1E14922541BCCE9C7B14F10441946312EEB2912541FBE71588DFF20441F3FEC4FD4691254190A4E22159F50441BEA32551DE90254119F8FFEBFAF60441E492A851B09025413D1B734D21F7044181428DD3819025418983CE73C2F804415E382237989025412A0507A8C2FC04415B51DB4F8C902541F2FA9D53B2FE044168384E78859025412675D929F6FF0441E35E4B5AD0902541A2665A7EBE0105412F8EDDEDCD90254191E77CAA44020541B33789980F9125414C428F20580305416A3CA4F73C9125412E0DE76A5D06054110B8FF40419125412DEC41BC7B090541EAFCA1B8429125414476BC9A0C0C05416E5501D7C6902541C0040E28D50F054108D170E579902541A535EF922D1205413A2AD119109025411A608C51C714054199783D21538F25410E324C9AFC1505410F675794898E25410488DD0C3D1605415A006B22E18D2541545FC102C91705414128EA3C888D25410CA57875831A05414D494F6D5B8D254186396F58901D054107678F2C068D2541B39E957E821F0541F9791F7C898C2541DA160701C3210541C59B35C7238C2541A842F86893230541432AED972E8C2541C7439E6A2524054118CF5929E58B254118AC0B3AFF24054114CFA1B6108B25418C21350C2525054133EE0FE3CC8A254110B53E9365250541FC602A46698A254173ACA3E56125054133D52E59EB89254144C71E430825054140A55F793F8925416720200BDE24054124CF159E998825416FD9D546FD230541A1DCB9705A8825418DAFC1E29B230541A08BC566778725416C131DAE57230541784B16DDB58625416891DA82692305413B20F25D1E862541685D7EC45A220541CB5F8C258F85254155C28A8FC92105411491AD451A852541BEBEEAE26E21054108DC6891DD842541F4836C7937210541C3F52A4773842541748FD4D24C210541DCB4722010842541F2A9E0303E210541E5EA1260C283254178E61645402105410774A27D6E8325414E46330D272005414EBADEA90A832541C25CA311C71E054112C317225382254153EE033F671D05419CEB7398AE81254120156CF1191B05418E4D7973A6812541D6726C0DA21905418E7FC7EA30812541344C7AF98316054184F8129ECD8025416C39B4982C1405419215A242B1802541BC6AC8A620130541128BE00064802541963557E7CA1105419F64D7E0F97F254120361738A80F0541E6E25E0CA47F25415576B19CEB0C05418ADDC65A2C7F2541CECD4F5E280A054131AC590F567E2541A6DF9762680905412B8D3FAEE47D2541548F70F085080541FD0125D4AA7D2541707EBB3D6C0705415D503959137D25415D76E0E0450505419CC877B87E7C25412F15D0117B030541FC4C38BBB87B25413294153A92020541838A77BE187B25416FE206A59200054198DDAE293E7A2541707E1E2C95FF0441E840328602792541A66EA07B58FF0441F0409ECD8B7825414C72D8D315000541F7C13D162D782541F8D66AA1AE000541012EFAD1C97725419C4430C8AD010541DE51472717772541B25451226E010541E4A0807CEF76254104D035461AFF0441B5E1D02BC9762541EE492E152DFD0441751ACD459E762541CA702E7342FB0441DE6A5C92E575254157588F12D8F90441C0E3FFC75C752541D57840C60DF90441C3CAF6B31D75254196A151D260F80441270281A3B574254152784F1738F704414008F2F951742541B2539E081DF60441321B4ACAC8732541EB59F10506F404413D0464FB8D732541CB297B4759F204418B9DA78162732541383B93F4D3F00441DA6A607B557325419340BAED00ED0441FD3CB8973D732541C2B3CB66D1EB0441F62542C71B732541DE81D1A728EA04417146EA9E0873254160BCC6B627E804414D3E5E8AF772254149521B3A59E60441DB1964EAE2722541A66DB33E59E4044104A785D65272254118E5B162A3E2044155F183C92F7225413A4D572F55E20441510A3DE2237225411C5A3CDE4EE2044115DF30DFCA7125417816BB7276E20441ADF43485AF712541229938F34AE204412B7D974B5C712541B74C66807FE00441135ECDE535712541F0AB709F2DE00441891A415F077125413FFEC9B9B0DF04417AC77DC2FA70254184DC42AD23DF0441CFAF4A99F27025416F4268CCE2DD04414955FCFDE6702541700867B88FDD0441BBF2DD909E702541AC7D428563DB044181C7790B6B7025415845041AFCD90441B7C09F2733702541887AFE2752D804416672D32FF66F2541C60BF0553DD70441CE111087BE6F25410C4B091293D50441C35C3BD19A6F2541906C9F6F4AD404410E8A9EE1746F2541BEF26A441ED30441B33F5C316C6F2541326E396C88D204414C5311515F6F2541DF1DB5A329D104415F402D4F016F2541260D16ED51CE0441CB90CC90F76E25413A3F95A7F1CD0441E87F934EF56E25412D67125BEBCB0441EBE72D3AE76E2541784BFCF9D3CA0441148EE0B4ED6E2541F6CEDC7409C804418999B13DF56E2541FF86795CD8C704416A40198A526F2541369C130821C50441EC325D3B536F25412E8DA3AD13C504411E2A1885EB6F2541556847432AC104412D4926A83D7025412C3EAA8490BE0441F9385E7A667025419639512638BB0441E0B181A3A5702541EE9E909442B704416A296B21B470254162FD2F0745B604417AFD993EE5702541ACE52FFD54B5044179C56E42A5702541CD23910EE0B304414D3855DDC470254108D310998AB104419EB8C7CE667025411CB57A8A80AF0441132A64C9A66F2541907F48731AAD04414F082AC4AE6F254105AF747F7EAB04410554C622B66F25411A9DDA22E3AA0441994E3E66ED6F2541A47D6EBB81A704413F04143223702541F239B54699A30441A003232A306F2541242667923CA2044104BA2196D56E2541F5B7E11A60A30441A38671022D6E254174231C964BA40441459823E0E96D25415494E9BD42A50441FE360F26556D2541F706DE8FB9A504410B52C7C9EF6C2541A87BF90BB0A5044102E865EBD36B25417A5800A85FA40441EEE3B7E9416B25415A4D42A3E5A30441E45C939EC56A25410300A93425A40441BC20421B4B6A25413F03B1351DA4044165ED9DC5C1692541F0B0571B9AA40441A6952B1111692541A4579DADFEA60441286FFE3649682541D02122F7BAA90441A3466E11E1672541A2EB0E9514AC0441FD7D94407F67254174569FBB64AD0441912927FA286725418656F113C0AE04416ED23DD6E166254160E6054A74B104416A685CEB8D662541349D95E246B40441B51683FE66662541849A4AE655B60441383DEC273B662541B3C0404D7DB804414AFA60B71E662541963EDD272CBB0441C39D739AD6652541FC0C2670B4BC0441873ED220916525414CD1F2B3C0BD0441FC770319F564254190F1F5BF51BE04415FE39A042264254134D5A1BD7DC104410E185194EE632541520FD32896C20441F53F782CBB6325411057889922C40441F10FA1C57F632541D5B6AC1354C6044134BA550D63632541643FAEEF09C804419B25C56E3263254196FC8C32BCC90441D5CD1EF204632541F9F6EE878FCA0441BAFD2921BD62254104765D5C54CA0441ABDEFBFA9C622541F1AA207405CD044115FBCD469A622541409FD6C87CCE0441B2AEA0D0996225412A776F11C5CE0441066119AC9A622541E0C3E42D14D0044191D67B24AB6225419CC8393963D404412B52D3B61F6225416E18275D92D80441FC8C3E5AB46125412D5EAA257EDB0441E8D5EEDCB1612541627E1586ACDB0441B291D13E8A612541729AC39226DD04412467FED04F6125413FFEC9B9B0DF044194D22975F36025415AE52B6079E10441B942007AAB6025415AD2116223E5044128FF5F2ECE602541DEF7BACA2BE804414205790290602541E8A1260C15EC04413DB8BE2B2661254135DA98214BED0441FE413F51C5612541176F05AF24F00441E1056A0A83612541191DBBF103F404412B8459ADB6612541EE1E34F4DEF40441CF015CFF866125414CCC0B3854F90441E7569A6372612541F25EE66E02FC0441E6D1D0DC06612541AE0A84588CFE04412AE8159F99602541CA5DB4D29902054119FB95F96D5F2541D3F4086203060541C6E086027B5E2541BE4DB9D8B007054122465D9CC05D2541520B9FC67A090541F0CFBDD7015D2541887F929DF60B0541B4A2BAD0915C25415AC8670DEB0C05419DB3EF5B045C254190A9A2AE4E0D0541710D2DEC4E5B2541B48CBA53210F0541AC1FE866AD5A2541C1A5B1B0CB0E0541238D1ED4165A25414C3E138F310F0541C970E41090592541620B31DA301205413EB2B9994359254110617CF96913054169BE9FFD0B5925419291F9622E15054141FB6DEC40582541CCF4D385FC1505417BD7D46BA85725419E7105B4FF170541E0F5ADC9DB56254158F5908A03180541F4938CBB155625419EAB06C852180541B91B722F78552541540591EA601A054191264A29FD542541142543A5C91C054165820EBF455425411C680FBEE51D0541DE550817585325414E2EEDAF2F200541C04FFF50B5522541A8D49A96312205415B93935E73522541B2284CB92C25054199902B46315225413C9C953B0D280541E5BB9752F4512541B328496D5629054173CD4930B1512541E076428AA12A05413287295053512541822CDAC8862B0541A3A9DCF00551254190AEA2F69E2C05417567E297E2502541B27D8A95A12E0541351F733193502541F46B603FEE300541E29E60495B5025418BBA2C5D8232054101438080445025416C2BFA8479330541BF49DE2744502541D63542DF2634054102A9D36CD44F254148A43E080336054180D10B29D24E25418A1F2BDEF936054179FD60CF684E25418D7786A43D3605413A1F335DD74D25416ABA3F0DEE3405413FEF4FB87C4D2541FED757BFE0330541ECB95455724D2541120F0625F8320541C0620771314D2541B87F85479D310541D9E724C3E74C2541E809C4C914310541E34DC4F3324C25416D5A2AE4E63005415DDCFBD0754B2541A390A9F96B320541F36E4DF7D34A25417115528301360541C2C2892F9B4A25416646CB99BC380541CF622B5D6F4A2541460C3A8C513B0541DFB170F0664A254124A07E68783B0541A19F3582404A25411454E4FEBC3D05412E7D52E9104A2541915D0807F93F05410788425FD449254130455B5C97430541E4B57A44D34925412E67591A24470541BBDB3253E049254162782076764705416E42CFC93D4A25416D8E5DD77A4905410DA7ECC12C4A2541124C38C7234C0541426A1665D8492541F6A77641F34E05410E0BA12C804925419011406C4E5205410F3FC6A453492541CE992F9FCB540541F9D27530404925416A023DCC525905415E5567A050492541CE3E8690C05B0541670EFA65254925418E5E384B295E05411FF854B398482541521417E448610541B9F099BC1C482541E89758143C630541EA7FFEF05E472541333040F5CB6405412E5E10302247254110D2B22B026505411E0B6D96E3462541B414BEEC0D650541B556E53A8D4625415BE982DE2C650541F49A169E6346254154D0FA8037650541023969454646254199B7722342650541C08648EC1F462541681E334672650541D277AA74CA452541DDD2E92DDF650541E377EA7A66452541F877C1BB896605415ED2F45846452541A57CDEBDC8660541434B588821452541D379A9BD19670541708984DCE444254147285EF9C5670541AFFF3B3652442541BCDBFB8CE2680541676A3A83F64325412FA30F7AD66805419510094A3B4325416C5BEB0995670541F74902C39242254186A695CBAD660541E828FD9B29422541067EFEBC306605414C5EE8098541254116407FFD186605411267E17B314125417F9B981E446705416598D65ACF4025416C64EAB82C680541E224EFA99D402541FE69A2BEDC690541833C4E1493402541C8B8AD84606A0541B3E6725A8F4025418CAB8D80806A0541378CC0FE89402541F6A2BE28AE6A05415C004D8C63402541BE5F6D149B6B0541D3841D844C402541E70A82A3EC6B0541934044A350402541EC57AC12F86B054193A8CE99933F2541C24EF4BD9A6D0541EDF4AB2DB93D2541A9CF474819720541CFCD1D4DE53B254106730789A67605411D97F0C5393B2541ABC413A50A7705419B85567D2B3A25410E53047D157605413C07A7E0933925411094D5E3357405419706620D56392541750E96B570730541D863D8D37738254141301510B37005419A382CDA8837254198F09A9E9F6D05414B88C64EDD362541301EDFA8736B0541E74AAFD5DA362541DA91B8246C6B0541AAA2455D5936254191D772E3FC690541612436B7573625413E0D924AF76905418F96F78107362541C1323EFFD56805412B12B78B053625413CE34D8FD0680541B48BD713C735254195E32B8E3A68054162BE5E20703525412658BA5CEF66054144B696D5C2342541648566BB60640541287AD90ABF3425415562FA04526405416022E392463425412E248A9664620541417E535D443425416F7948085C620541B8EF07D4C2332541F8D0DBCB77600541D65B4C0AB7332541044BBE9E48600541A436F9D1B5332541889F3A10426005416339C1F361332541D2360CE9575E0541A1FE455B1E33254171EFEE232E5D05412A406BDF1C332541B406F380275D0541BBBB762DD632254102BE4D68F85C05416BA1772B923225410EEAFE20A65C0541AF0473F48E3225412DCFEB179D5C05414EE8246C59322541FA623BF2E45B0541589D51A4573225411EAD98B5DE5B054112BBE9E5DC312541824EA03F695B0541006A5D53833125419BCD4969145B054177A3DE463231254142989901CF5A05414EB2FCCABF302541079478AC865B054132F3DC7B80302541382C9F35065C0541547E0B1B693025419DE4D3C8375C05418B7502B40D302541DC99645C055D054131DC2A75C22F254119DBE01EF45D0541ACB362D04D2F25418A2CAE92685F0541C6B7F49E112F25416C727B0165600541BE68FB4FD52E2541669238BAEE610541D02359D8D32E2541DA3C7A48F761054197ADBDCAA42E2541F0983DBEBD6205413FDC2207A32E25413E1168E6C3620541358F08403F2E254142D6AAD49C6305415178BAF97A2D2541E2035B924F65054117CEF973782D25415DAFDE2056650541C734F6F33F2D25419ACEFC8265660541CE049BC93C2D254156CF3E836366054191282455262D2541CFC2942950660541A9FA6F33EF2C2541EBF96B3B156605419C920189EA2C25411AAA7BCB0F6605418A0BE97B8D2C254127D2162D96650541FD147305332C25412611A442DD6505411332DEEFB82B2541DA325FF9386605411900ACC46C2B254158B7F8256C660541A692E9251C2B2541BEE3E43300660541134B9BD8AC2A25414C5FD109F76605414DDC7AD4CD292541C075E16B446905411749C8A7632925417CAA7F2A516A0541C432DF37AB282541460C454CD86A05412C4F818B2B282541DA5D5C665D6A05416F2D7B4EB0272541CB1E37A5B3690541DF4F86713D27254188D44C3478680541D87D7A9910272541E4C540DBFE680541D681E026E72625411E11784A59690541E0E91ED96E262541D7E3A23F3A6B0541B87721D822262541467AA21E3A6C054157D6E9C5B325254113550813946C05419452C63102252541E0255604066D0541FA6EC0075D242541A1C5663BD66D054160A46B6F1C2425414ABFE3E6276F054188FF9666DC232541E639F2BDB470054119C48AB69F2325412F1E1F64CE72054144D29F9D8B232541FEBACA432A730541EE6600443F232541D92E266F43750541E0FEE91B1523254132F78E0CA1770541FE219ED2D92225417E92D046847A05417910A837F12225412503F0C6D67C05418918544FD0222541F78939F8C17E05413D68563BAE2225412242C0E34E800541F081042C952225418828ACDF4A820541C9901A29932225412683EB5415830541A586070F84222541CF33C3E7378405414DB72BD08C222541A7BC0A17F58405414DB902D1D5222541B071A7AF168805418FB0AD25BF222541FBA4306DDC880541F802847168222541606664AFA5890541EEFE51AC0E222541888702BFA78B0541FDCE42C6C62125411A63D35FAD8C0541FFB7C0B785212541EE727ABC978D05419363336E61212541B1E2FE38798E05410507C28D512125419CC7AC87808F05411FC233DBFE202541B8883D20C6900541E496EF5899202541004C25BA50920541FA7F85C69620254114AE8D855B92054173A4EBAD342025410FBA1A38159405416E3EF8CA0E202541B3350EB923950541DCFAAF010C202541604E5BC1329505417542521AC61F25415086352B06960541628555108B1F2541C8F516FE63970541B282457A231F2541ADF727ACA19805419412A33DE81E2541D6CC80F6199A0541A267B560E61E2541518BBEE0239A05418C7A896D951E2541AE718130729B0541E95ED483E81D25418469E22F659C0541B91EB9B29D1D254142052363159C05418FC1D6BD621D2541217C95E0509C05411784A7C8211D25410C542E29999C054151E3184AEA1C25419486A9902F9D0541F1F868348A1C2541CCFCE0B8849D0541C6A133CC871C2541D4FD22B9829D054112015552051C25413C0D3D682B9D0541D36FFDE9AB1B2541B074DB89C59C0541CF86BFFE881B25414C80BEE7E39E05418FC10A9F4F1B254120DC0760D4A005419E913338141B25415FB2DDFF30A20541F5A9177CE31A2541A8536739DCA3054152CAD3187F1A254148C82D11A1A605410F1CF949611A2541CAC5C46623A705417B6AA187401A25410EE6C772B4A7054114B43AA4111A2541887ED4ACE8AA054187892FB7CA192541FD7D145C0BAD05413254C455A7192541875317FB1EAE0541E5243A4939192541A8541A532DAF0541A846045018192541D02500F001B005417002CF35B21825412AD02084A7B20541D4B8252432182541B6DAF58B96B40541F48E1B4DFD17254136D716374CB50541EFF04C69E2172541BA814DC733B60541883C1509D71725411EF8979FF4B8054101AEC1F8C5172541B62B215DBAB90541EA8AB10897172541E8CBD0EA04BB05410EC78298491725415CD5CB4693BC0541F65C31AFDC1625415A7CB4827BBE0541EE8CACDCAD1625412CB75B9860BF05412B9F5FD07C162541B41D33BE05C10541804F192773162541A8DD51FF87C10541DB05B4D21E162541FC6AD4DE10C40541F7F4BA96B8152541726E873BD7C605413D0513C67615254126D342B51DC80541122BEBD75115254112C208070DC90541112B9BDC0615254104F027C474CA05415C922874C7142541F82AB9DD17CD05412AE87BB373142541CA4531EFE7D00541D767A14A4814254194B9971822D205415A43BB6FE21325413C17FD3C71D405414224F71EA2132541DABB300D6ED5054178AD60249A1325418497416A8DD50541AAC16EDC79132541AC4C11A64AD50541A370B60833132541CA44B8F844D50541D5CB7D3FF9122541A6E74383CBD40541D765F6A35C122541E49A931196D3054100BD3393EE1125411CFF293238D305417B92AC696F112541F6012B8818D3054160F27E0AB41025416C17823868D205419281533D0F10254154F14C2951D10541D2AC9B8F740F2541F00DBB86A8D0054186AD28F0DD0E2541A0B37B11DECF0541FD9B7AE2200E25415450ACEC30CE0541A638479A170E2541BA99C7AF2CCE0541039C3EAC840D254146EB127480CD054132F92471BF0C25417E7107F501CD0541723B3FCDB00C25411043C0921FCE0541A9E9F5E1700C2541B041A093B7CE05412EA8006F5F0B2541262884DD68CD054112539A99860A2541240D87D0A1CB05412DD8CF677B0A2541548997F809CB0541B781CFDD070A254164D58EB841C90541B0172EF94F0925419214E71C87C605410B51BB2A1E092541F0417D7FB6C505416E1C45A1ED08254128BF7251A0C40541138355E6630825418A147B69A8C20541F05F09C0980725412094A98E4AC005417D0513A767072541DABB789A9FBF0541BBCA3F8C490725417A692A7E3DBF05417820E3C640072541A6A69BE725BF0541FFE2B3D1FF06254136533F7594BE0541BC327200B2062541E65E89201DBD05411BD08B1276062541A69CE38690BB0541778676B96C06254178578CC260BA054100C863BE5E062541781A8EAB36B9054195F6007A69062541D8FA0B4893B705412E892A166A0625419CCDBF8B74B60541602F41516A062541B2C9B0DF64B60541A77B0A07710625418AC83E88A1B5054177863E3A600625415823A6A2E6B30541672FE51700062541D61D864899B20541CA6A459387052541AAC9E7D509B205413FF16411620525414C09F6933EB10541C481B7AC1905254154C2ABCF5DB005411E021E609C04254174ED98D8ECAD05417BE610F414042541A9618FFB3EAC0541D985410DBE03254132DFF3CCDDAA0541BD498442BA03254150EFE07CCFAA05416CFDAE4E94032541DC31883C47AA054187BABF1D7E032541857F90AABCA90541C3155B13570325410BBD3C698BA90541D834BD01F402254146242DE380AA05414672383BF0022541B9CE6E7189AA054161E09BFF58022541E8F6F3D6CDAB054174C92178A70125416F6BF95682AD0541F20A234248012541CC3F1B9F1DAE0541FA08B001F9002541B634864651AE0541466C2F8EBD002541120832E41FAF054136D033F45B0025412AED5285E5AE05419A84CB5DD1FF24414B3456EF8BAD0541C9AD34285EFF2441C4CDDB1F63AC0541E236B0805BFF244105239A915AAC05417A48C61E12FF2441383693954DAB05411E4754F4D4FE2441B89F9EB46EA90541075AB8026BFE2441ED306736ACA705416ADA2AF40CFE24413C2E1F8691A50541436A04F409FE2441263C463589A50541D847FDA07CFD24417629412C42A405414581E25425FD2441940F477789A3054153D0F7EF9FFC244161BF4F5C6CA305413BB35C0D9DFC2441969615A46BA30541E0E159D211FC24413005CB720DA30541FC4FD512B9FB2441AF3893D8C2A205410E88289956FB2441EB3183D6D2A2054165570C5FDDFA24412AE82CBEF0A2054104BADAD0DAFA2441364EDF8AF1A205415583A5C29FFA24412CA05AA60AA305410B86591F9DFA24415E256A7D0AA30541504D0953EDF924416EF102C1DAA20541A016644699F92441FEE9486A4FA305415785A81D46F924416A8B1C4A0BA305418542816D23F92441A84FF48B38A3054191612719ECF82441185F37E78EA3054118EEDBA7C0F82441A4F20CC400A40541AC4CB85A00F824413D3308DE01A60541766E7EAA4FF724418447C13E0AA8054177557D1DA0F62441AA2262884AA805419C919EA89DF6244170F9E5CF4BA805411DEE2BD5EBF52441E4C46C6AE3A805413E45C5FDE7F524417D68974BE4A805410C1C4C3EACF52441128420FFB9A80541CB6B5A68A9F524410E326A8EBAA8054158C8B3CC7AF52441B16FE94DD2A805412086AD3538F5244182C9F1C0BFA80541D06DFDB9E5F42441BA022BD2EAA7054129F002EFA4F424417C2FAF8BE1A70541CD39E0C8A1F4244152D1556CE6A70541AA63BAA759F42441F713BE836EA805413973E57F18F424415BFB657D3EA90541748548789CF32441C1CFB07187AA0541A914F5209AF32441D8AECF668CAA054167197CC750F32441840534DA15AB05415AE39313E3F2244196F684D718AC0541498E897774F22441B8CF847903AE054142737D21FFF1244100BA567561AF054106C7AD1BA7F12441C9581AAE12B105410E14D0699AF124419CA14C7483B20541FE41084F99F12441BC69670C8FB2054187BB98D573F12441A07004BCC0B3054105107EA172F124412CD4F087C7B30541D16B9E7025F124411492457546B50541F23F0D94F2F02441FA088448B3B50541DEBA430D87F024412C96797AFAB60541D48065CA5BF02441F0D514E670B705411C8058762AF02441862A865949B8054196236B59E2EF2441BA40D9B68FB805415DA951429EEF2441DA40090E55B90541122BF2A051EF2441E09B1B8468BA054129801889FEEE2441D0D40E428CBA05411A610A66ACEE2441B66DAB75D8BA0541433BAAD979EE2441D8EC7D4B31BB0541D433C3A110EE24412A351CB948BB05410DDEA32AE1ED24413696428455BB0541662C14E9B3ED2441F6CC81EAB7BA0541A0D276686FED24411C9B0D2E39BA05418B4B0E60C7EC2441E067BFC559B905410472FB4C63EC2441DE777C1E86B80541EE8210D507EC24411A5FCB14E3B7054181AD6F8D99EB244184F2B6ED96B6054187344C645AEB2441B6DE68393AB5054127447FC3A8EA244168D811DD0FB30541188F6299C9E92441A23F05A3DBAF05415420728D67E92441C26037FFFEAD054158BC697039E9244172D2F821A2AC05419E511B284AE92441A08CC35E08AC0541063A080210E924416D762DFA90A80541622400A59BE824412828738535A60541B88912757DE82441D685A74B8CA405419864DF3F4AE8244122CCA75D24A20541A736FFDC25E82441316D863B01A1054106512669C7E72441548E15EEA09F05410BA0474261E7244186896B3E209E0541270E8B03FCE624411E40F324A89D05413812B911C6E62441D42C961F219E0541143E727856E62441E2405ED1539E0541942EC7ACCFE52441A9F9990F9D9E0541ACFEE30775E52441A4983F9AC19E054197FCF48AEDE42441087C74E6ED9E0541A5C84F1F52E42441D486C3EBB29F0541CA7059A7D9E324416563ADE008A0054128D4183A3AE3244102880199A7A00541B59A2B1872E22441F1123CC815A105416D37B05BADE1244124334AD2C7A005417820EA8F40E12441C4FCB4C000A105411ED06A5118E124413FCE095D8AA105417BBC7174F9E0244147C0A758ACA10541069670DB1EE024418E4BC08684A105413BDA2502BDDF244136023D6FEBA105416CB411BA45DF24413AB4C501C1A205413EEFEC5BF3DE2441E527FCD335A30541D5B50B784ADE2441EAB3B35888A30541FBDCC1FBEBDD24416286C4F2E5A20541E1084F218FDD244194225E2909A40541BCC6D88B33DD2441658D91F9DCA40541EC6C9FCBE8DC244120935FFBCEA40541E70445E692DC2441228531A1BFA405412E85FB9460DC24416061AC9660A50541D532855221DC2441DBD3476564A40541321F54F6F5DB2441EC605393EDA30541B25A30AEB5DB2441109D82FCD7A30541473C87616FDB24419B192BD0A2A30541DC9AB30FFADA2441FED68E0E4CA30541A3A3E400B3DA2441498A19F2FCA10541008CC59C59DA24414CE274B840A10541AF736DA3E1D924411877DDE6D89F05418AB40110E7D92441EEE011B2A79E0541CBADA368E7D92441C0DD4406969E05412094093DAFD924414C1B60C4199E0541391B761557D92441062C5F1D449D0541F538CE5040D92441F9CF67FDAE9C0541EE1F09FA2CD92441AD986B92459B054165D8C6EADCD824417A0F8CB7259A0541E5CE902C82D82441F643101BAF98054154B988CF0DD82441DAB67EEAFB970541F60674B406D82441CE55581FEF970541B9A56B3891D7244114D9E748FC96054146857FA378D724417AB0328CF2940541F91F619577D72441308F4AD6DF940541A4EC7C3952D724411E74B51DB6920541E61B3B0E3DD724412637835CBD910541983579000BD72441FB1B2D4C838E0541EAFE23EF01D7244188BC77D1068C054135646200D1D6244175DA6D82638A05410188FF5069D624413C8E7D610B870541CD2C209E64D6244166041DDEFD86054104D511AAADD5244188F44CD565850541B09D3F465AD52441E3CAA0C5A18405418E482D235CD52441BCABE66426840541076F528F04D52441904A33ECD7820541CB0B6B8BB6D424418A8B38FDC6800541E12E63FFA6D42441EA67A042FC7E05419FFF342CA3D42441323EA2DADC7C0541D40FBD53DED42441301401C9397B05419B6743CD3DD5244123040C67FD7705417DC3CB137AD5244146DCF5006E760541F6816689DFD52441385730D07E740541AC50F56D09D62441D3C0599D2C740541511F7CCBA3D624410E7E64D8627205417DF92B3420D724412B13DFAF3370054182E2F1999AD7244138C906E8306E05416CF7F4296DD72441406E8C1D806D054186AED0F1C6D62441E8A10D29FB6A054163D4844944D62441686AD215A26A054160570F58DDD52441AAC592335A6A0541073D04187AD52441B4522F622E6A054176A6C8B9EDD4244166844A1B3A690541AA6BB1E1A3D424416803904351680541FAE94CD2FCD32441849C20724966054104D3860690D32441004C17AEF3660541208AEA4841D324418A2C4BA43F670541DA90E8FF46D22441F1CF9333CD68054189F72486AAD12441272D5A01A26A0541587FDEB81FD12441116E67C4DB6B05411D09BB3099D02441DC90FC26986C05410A01A7A130D024417CFCC34FC56E0541064CAE31AFCF2441B87A3E29DE700541D558896D6ACF24411ABE4597E071054112E849DB16CF2441169147E01373054171B7B16465CE24418B949DE65D75054159C806F3A5CD2441D80369BD7978054112E4A73014CD2441AE3ECA7F577A0541FDA9A5338BCC244188B225AB707C0541DBBC5586DCCB2441DE8978A0B17D0541AEAACA1C6BCB244142A70B57AD7E05416A32DCD1BACA244138606CEE9A800541B878BCC4ECC924411D9B655CDB8205417FB7093290C92441DF5AA24BEA84054110FBA97D6DC92441BA95720D7D86054124E2A8F0BDC82441EAEB51850F890541014000CA23C82441B66388B2698B05410E9164EB8FC724417E932072AC8D0541E69F626C4FC72441E855DC077B8D0541A03CDF28FBC6244158496658368D054101BF882450C624411293F01AE78C054168269A7FD8C524412A50B1AF0C8D054178DF600D2AC52441E2DDF7327C8C0541C75FF3019AC42441E8DEDCDCFD8B05415CBE1FB024C424416E08FC3E808B05416573546FB2C32441FEBE1426538B054134E7838648C32441D0F73C40428A0541C4BF91F3D1C2244122855DB81089054130FB1DB046C22441701ED0387C850541C93ED2C0D2C12441487D334F65810541666D2BBFB1C12441426E2397AA7D05419BB3B7E698C12441482C087E417C0541AA0275FF38C124414AEE50B51978054194967C0D00C12441D4865889D9730541C53CEBCADAC02441D24FFFC7F3710541D38F26ED8FC024418460D57470700541B21B66B0A9BF2441DC23B8A8866A054113EDF4358CBF2441062D70FDE3680541B8A04B8353BF2441481FBCA0AA670541C772DB1E48BF2441B6045EEA5D6605412FA87EFF77BF2441160C233F0A650541A332040B29BF2441062CBA97BC610541723D5841E6BE244169C4651C3360054101989A9ED2BE2441E42460E3835E0541D025A9DBA5BE2441928B9358725D05412D59D97B86BE2441BE9D4A5C675C0541589B6B5D20BE2441169A1204AA5B054133109DC7A1BD24418CEEF6C9405B05416BB6AF4B12BD2441A01777D5485A0541D9F13381F7BC2441CEA64159B459054135D8759B61BC2441A11548797E570541A19067548EBB24418C3F88D5635405410E02F0891FBB2441BE8E0946B45405416835F03183BA24414CCC815AB45405411E1DCC0088B924417210971EE655054136A458DCFDB82441CBB118A6465405411549D1ABD3B82441ACCDA1591C540541E83EB253A5B82441FE10B4C53F5405416BE298F56FB824415010AD1A285405415574390107B8244158B7C14E94520541FF426CACC6B72441AB862EE98D5205410962525E2BB72441CB9F779E9353054106759669F3B6244137587887F65305414F72CA90B7B6244187C1FEAA20540541976D3F3371B62441FA886FEE9054054116AF587950B62441E2C1965683540541616135154BB62441DC95549D8A5405415EF76BA635B6244127A8984EC1540541B2C0CA69E1B424415DBDD257B755054160783B00C4B4244178374DD6EA550541622B45F3BDB42441057E6743065605417DE49F3986B424415EF12E16C6560541F7EF3C1381B324419295AEA7305905410DC42FFA15B32441F4C91111575A05414B8785DEAEB22441DC1EF283E45A0541BD5C627529B224418C0F3CD6CF5B05418933613B96B12441322BBA8B845C0541DBB12C246CB1244132005D7C0D5C0541BD3DB45B41B12441A75E59458C5B0541A182821430B1244108650546E85A05414FB9BFA9FAB02441B0F5B020CC5A05414E36B5A799B02441E31A4B2C725A0541A09DAE86E3AF24414DB3C2061A59054190B0B65B0FAF24411EA985AA8D57054130473A47C7AE24418BD7CC0C70560541B88A76D2AAAE244133043318DA5405418A91647B91AE244194270ECE9D5405415DBBDA994FAE244139D1BB034D5305415F6CED8832AE24411CA51549C0520541FB66B11025AE244148945598855205419531B6AD1AAE24416EAA104A695205410D222F9CF1AD244156B764F8175205414834CA1382AD2441944DE227F75005414996177CA5AC2441A2EBC302FD4E05419B93AF6363AC2441B0EC7402B04E05419346AD183EAC24410CB8979BB34E05418BA83E3E8DAB244103B86EEF054E054198442AE33FAB2441EE90208C9E4D05412C28989DDEAA24414ECF3EA2304E0541C91EDE1BBCAA24419016CFB9184E05419444AAEF77AA24417F4A3676484E0541345803D600AA2441003FCE1C334E054137A79C3443A924410A0EF563254F05411C52865AB5A82441FA500025314F05410F6586A851A82441D6FB14B4824F0541E7A50A20A8A724415C39C172514F054187BDC10C78A72441FCE67256EF4E0541677FE5CC6FA62441B9A99DEB724E0541726AF6014CA6244124A65A95944E0541A72DC8221DA624412AC3F849B14E0541153171570DA62441F4FEEC5DB54E05415992AD9BFFA524416EC2B649B34E0541AEF94671DFA5244152566A258F4E05410B166D8827A52441CCD74CA2F24C0541F0BE5FAA82A4244166AFD341024E05415275F69E9EA32441D68644E5CF500541D982A6AF7EA32441503152C9095105419CA400B844A32441A0D965027B5105417B02500A1BA3244102FC2764EE51054186B7D4C4F3A224410C914D978D52054157F665EFC2A2244172A3AFF6505405416A2E41F0B7A224419C31F226B754054150A3961497A22441EADD1BB74F550541ABD696BCFAA1244147FEDF1AF1560541ABC1F33592A12441FB456CDFCF570541B440EC7567A124412247DE3693580541D7FD688CDAA024410E1030D17B590541010E0579C4A024417E5EA3EB9C590541DA955AEB3FA0244112DAFEC0485A0541A06C5D683CA024418754B494625A0541817B2FA80EA024410CCF0114DF5A0541354EB41BF69F24419F6319F14E5B054190835345969F2441BE47903D795B05419FD41FDE8B9F2441A04FE9EA7E5B0541FC090F03779F24413CB96F0EA95B0541421E553A639F244142C8DF68B65B05417B4969C44B9F2441987A7AA4C45B05415E5AA2064E9F2441DE357CE3075C05415F0DACF9479F24412B0E1CD7675C0541583F56AA3C9F244154A50060E95C054108F169AF319F244101C7EFC0135D0541A3EDB43C229F2441A435CE3B635D0541FB05097F0A9F24410031DAE5D15D054127125FE1EB9E24414DFF61D6495E05417FE389A6D49E24416A44C4989A5E05412E14FAAB989E244139EA11D1115F05417F15D81D5F9E244148F4C17F5C5F0541E580D780159E24412A27783CD95F0541B60A48B1059E24413A19E28D2C60054192491D99009E2441018E04B53A600541C55B144AFB9D244117BB54C462600541BB25EC8FF19D24415C93286291600541032390B5CE9D2441A0D0FDCC0D6105411E298986C29D2441D68565B42D610541DFE2F020BC9D244120B57BC44F61054155EA43A0AE9D2441C792E20E8A61054104577DAE959D2441507D2E08BE61054164737B3B809D2441426E4FAEFB610541E1C72888729D2441BE14473B0E620541D0421FFB6A9D2441622C52431F620541D8C5CDC3619D244138B53C1C60620541C6424B3C589D2441F850DAA58C6205418EC849A1529D2441CFD02226B26205411B29598E459D24412E4FE7A5DB620541F437FF8C2A9D2441EEE06C2C2063054140E65D1F109D244151B5FD737063054174F4D6C6F59C244125AE77C7B36305415837AE7BCD9C2441BAF45D8A006405413F1AA39AB19C2441564F40A94E64054153D182199B9C24414D97A3C17F640541A39CB40D909C2441D49EC1199F6405411B102082899C2441D4993518AB640541033A3E1E6D9C2441B24A4C53BD6405418FE13E09539C24417AACB41EC8640541B5D6FE97449C24414A0F5FEAD0640541F6CDE16B3A9C2441F64D20AAE6640541C372CA39299C2441225F1BB00765054101B982A2FD9B24416692D8179C6505419149517AED9B2441424C91ABC9650541BCD6A25EDA9B2441F0428053F9650541A3043F04D39B244190201B4802660541B3D28815BF9B2441EEAC0D223B660541CD590D6AA59B2441FCD81B31656605416E716CD49A9B2441F08097BE7366054127272A24929B2441A2CEC8D896660541F635A4E1899B24416DE3D28AC7660541E093FF717F9B2441D8B8A5D215670541F0E20C866A9B2441FC1F324B7767054191AF8CEA3E9B2441CD864FC423680541126ECB263A9B2441746ECE1146680541C0ED983B349B2441ACFC4B97926805411C2547E5299B24416AE5A49015690541D2A886C5199B2441B8AF162A66690541728A9134189B24416E7F8A6F77690541B43A830A1B9B244164DAA7E3AB690541EF990C08229B24416A3FD25CA76A0541D8F9261D229B244140FD3148476B0541DA2D2C92279B244130319904776B05419CE544A62F9B2441EA7E9674CB6B05417DF804EE2F9B2441F99C7629E66B05413CFD6B91189B2441909588288C6C0541977FE1C4F09A244190C0E537036D0541EE18F909D89A24417571C8C8466D0541A8B76CCA9A9A24418C63FE6FCB6D05416F8CE841999A2441A1C5663BD66D0541BE234D40959A2441B7ECB49E3D6E0541135343948C9A24416A30CEB5786E05412F46185D869A24414A9E9EDA986E0541DA5D1307829A24415C267B5DAA6E05413EE09478799A244116873229026F0541576B97D6749A244148E0CB9C3A6F05413614C62E6C9A2441BAF084A25D6F054197AF3838649A244177BCAEE6786F054168F0F8E5569A24414AD184EEDA6F05415B4EF0B5529A244134C163941A70054105683AE63F9A2441041AF65C3B700541962C9E341C9A244196F6DF5191700541FC1C87210C9A2441559709DDB170054174D71B13059A244136A4EE8BAB700541B8B91B5AF69924416AAB408E99700541AA9A5D32EF992441B5D1B445A0700541B604E3E3D8992441F657D272CF70054191C602D4D09924417C814E2BCE700541CB6E94D6AF9924416F243EB7E8700541BEBB0EA77D9924411E0C895A3C710541BB517DB77499244180FE61AB4471054134C3F12757992441C87FBF2CB1710541DB2932654A9924418D772B2AC5710541D2EFC32038992441EE8AEC30E071054173BE3A89239924417675382A14720541BDB79824F8982441D5F7120165720541A64D9736D6982441AE4243C5A772054108664F39B89824412E3BF1C2B97205417DF0ECC0A798244194CDB19EE4720541AD9AA1088B982441733E22705F730541C1870D0278982441D4824232B273054189111A726E982441A4CC30F6F67305418C772D5862982441BE5EF1D121740541061BB039339824410515670F717405411FED6B1615982441A883458AC07405414A7A4DFCE89724418C51FA79EF740541A01385449E972441D8639B81A275054151FDABC9949724411E451178EC750541C168B76A6A9724413C46B7797E760541F34442A42F9724419A1AD9C1197705412ABBE538EE96244158F919B8B4770541E5DAC479D596244142E9F85DF4770541E70CD3EAC396244182958A422A7805413374407FB6962441C685A43D5078054196F8D8F792962441A405B913A7780541ECDA30C15E96244166979BF067790541C56AD2414F9624419C4777D693790541397633CC3D9624416853DF2FA9790541C083E3DC1D962441080078BFF6790541A4C6F210029624410BC147002C7A05417DD3A10BD0952441371A7274AF7A0541F0AA35A0C595244102256423F87A0541965CE5E4C095244180838998247B0541965E346BB2952441DE2236CE607B05419A41C5C99C952441B49DF24C927B0541BDCC2BE891952441DC7D1F98C67B05418E0DB41678952441A85D118E147C05419BA9D73A3795244135D4140C9B7C0541103475C2269524415BD113B6BA7C0541DA70C3A423952441E008BEC8C87C0541141B4CAB19952441243DF1DA297D05418D0B3598099524418D507E37767D05410FB5904700952441F2F5F86EA47D054136A642CBF594244156B24359FD7D0541B37BEB99F39424417301BE1E367E054161FD7733F894244182313FDB037F05419BDF4B39FC9424415B9828AAE17F0541C0E5E049F6942441D4ACC35C5D8005414DC3A52EEC942441B270F149EF800541129C2FB1E694244112AF0F608181054167CDE489E894244130E1B7C6CE81054184BE324DE4942441EDB58363058205413F27320FE29424416A30058D50820541F3F79F7BE4942441CEFBF37B858205411B1F16F9E9942441DEF775D0C082054133BD74DEEB942441C7FF9AD3F782054140DACB03C3942441491049DBF983054161B069AAB394244136FEF5D898850541C0172FC180942441C46E5401DB8605411119B5B06C9424412A77FBB332890541D95523963794244182747C0D738B0541CDE936E21D9424411A50BCAD2D8C05411DB7EFDB109424414F7EB2BEE78C0541F35DFBEE03942441FE69700FDF8D0541EF3ED906039424410CD9218B778E0541726771B3FA932441AABAD2D6A78E0541299E8207D8932441C469C2673A8F0541BE49F5BDB3932441268B0E1FE18F05417DCF57E3A7932441737C6A1A0590054111FC1D9E69932441413572AE7F900541C3CEFA932B932441D1455B0B689105418922430A12932441B45127661192054189229B8CEC9224416A3AB4096392054145F15D3993922441E466F26F52930541833716A267922441B4E0C94402940541DAD0BDE835922441B21FFA03CD930541A18E9FD5B49124419D391D6533950541AF287473829124412271C777419505414C575D734891244139855B7FA5950541781C52D91D91244191F4AFA4C19505417DE689287E90244179027AFD3C950541F6D63A96619024411A9D7185D79405418080728BFA8F2441A8C12D9213950541BB60DF8ECE8F2441C87518244F950541F1216229AE8F24410736DA0E5595054171180C68858F2441AB652B745D950541B345D338598F244189F96F50849505412900E0AFFA8E2441B460C81E17960541889DC142B28E244138CD8AED07960541D81B3D303D8E2441022AC40D9B96054193B6FA67DE8D24411A0940591C970541431FD66F7E8D2441AE7B9C7F309705415C271EC7638D2441544B7819DF960541D5CC7F300D8D24417761D9C01C92054121791F3EE88C2441C6CCEEE263910541130DAB0F778C2441A191D8CDC990054127E39C81B28B24412C4F950FE691054183972026798B2441BE1339A7449205417D7A6DC7378B2441F884412422930541E7CC4313E18A2441BA5D3A1BF59405419E031DE8B18A24415230D8629495054167408BCD7C8A24414D0D955833960541692782B93D8A24416430CD6473960541D1458B0FEE892441004C226E7A9605415BB7E70392892441CE1DE609B9960541ECFC9E5654892441AD6885CDB096054115F0333222882441120E0005DF960541ECFA2B2F7587244140DBE1F3C4960541467FF0E83E87244166F5B2FCCF960541B769A8852E872441EEF32EFCD3960541AD67A543F8862441F6BE853FA69605414D815334DF86244193D138F091960541F5E176E680862441157EA1281A96054194449DDA588624412AA17CDEDD950541C5A3E21A34862441BB61ADC898950541FB66B43B058624416862571D3495054188C53C23FA852441CB06FF5319950541D5A7A02AE58524413269D61ED9940541422E9467D285244146913DD690940541FDCC3FA7A1852441E448AA669A93054195DE35428A8524419CC8C28FFA920541CC58C7DE76852441BA9EAE2B99920541D173A33C6F852441D18C71257A9205416987785F308524412AA668822492054115520DFE0C852441A3A3D62BF991054158FE80CAFA842441D6AFB42FDB91054169EB144E458424412C33DC044B910541A7AE6A32DE8324417E38D705F4900541A6B0B9B8CF832441A6F23243A5900541B8358BC6CA8324415BD14A8D92900541E43FCA21C783244192829C1D8B900541D5A5DD07BB832441A79B5FD06690054114E84FE686832441CDA7027F62900541B965FAB57C8324414696CC235B900541C686076475832441FC612A1245900541709E020E7183244162BEFF30449005412DF2E6C35D83244108D2F4E12D900541AD2F2A7E4D83244178B6DA2D0D90054147FA2E1B438324412409CCF3F28F054199F92D053183244107B0392BD28F0541C44EA4E828832441F422D1A6CC8F0541656603531E8324411C04749CCD8F054179552ED115832441B4D29E36C98F05411801ADC510832441B3EAE493C08F0541D4565000088324413E75BBC19A8F05410E801504FF822441169E30CF818F054110EAFE75E28224411EC1D02F5F8F054175EBBCE4DA8224419A1997A24E8F05412E5663AFA482244149D26EDF038F0541DB5684C8848224411CAEB97DDF8E0541898B3A58518224416D048645068F0541A1DE81B82582244124BCB32D208F0541BAB0AD9320822441B0075A9C2F8F0541F45CBD9F14822441E89BD9CD3C8F05413E8E9EB903822441699913CD428F05417BA28030F6812441A21F65A4408F054106977728E2812441DC4D6D5E338F05417604B24CDB8124418CD0B634398F05414C60A6DAA0812441ACDA5BE56290054159FEC00277812441702D0E0359910541883A464E6E81244132A2C12AB2910541BFB4D7EA5A812441B0FAE4F31D920541D42080E1488124411C91877CA1920541EDA7CCB622812441726E7FC726930541462AF2EEAF802441BA45941BAB980541CACD101087802441FC0C230DA89A0541A12B6CA07C80244158FDFD5FDE9B0541CC378A835180244109C2D14E029D0541905705043F802441EA45B628799E0541EBD7F331198024417417A370659F0541AF769333C97F2441CA4EC8877CA10541CBE86C7AB77F2441DEFCD26E8DA205412952F1158F7F24417D12E078CCA3054129D14D165E7F2441E02EFD84FBA405416564340B457F24414ECFB71067A5054156C69168177F2441C0CB4010BAA50541C57C2C14C37E24417A65E09B14A7054145F0E3CC777E2441AA237BDC9AA705415FF66C9F527E24415E4E35428EA805416B156BCDF57D244191F4E67B99A9054196A01D30A67D2441984FF9F1ACAA0541301E4CC3637D2441EE007BD96AAB0541F33DAFC7127D2441F4958E63D1AC0541BCF9E9ABC57C2441F5C45E20ECAD0541B2F55F64917C2441A2DC357E2EAE0541F6D568A76B7C24415EF08E30ACAE05418D6A594F067C2441BC8E221298AF054111C360EBAF7B2441BCB97F210FB0054162F863D5497B24410C671F5C74B0054142D3F8200A7B2441DACEF8D2F4AF054159A79385C47A24412C085092ACB00541CC7A21964D7A2441C0834E11DCB00541F21E5592E5792441EAEF32E162B10541B5F3F893417924418CB9FA2518B20541573D4EF3E67824419ACDC2D74AB205419E06B524B2782441947BAF10CFB10541005589A37E7824414442B5A793B105416FC21B4A5278244166CFB5D7FBB1054139316021FF7724410EC932834DB3054143EA2A66E07724413E7E2B6BB8B30541767332093577244126E62290C5B40541278F1704CF76244194C3DB325BB6054194CAF3BB8E76244120480D0BF1B60541924BD7C15B7624412A0E35A34BB70541090813BC2076244100BE6634DCB70541C842B6DEC1752441EE48A1634AB8054162054F6A74752441684EF56766B9054162ECDDDEAB7424410AA6E9E03FBC0541CA0A1FB4687424412489D8D964BD0541264295DE517424410043916D92BD0541F8FDDB0024742441A2DB564D8CBE054133DC897FED732441C48586325CBF05413FC5DB2FBF73244136C083F3A5C00541CED6C58C887324411E5D93D495C10541671ED8A35B732441D0204E6F69C30541155585373F732441C015856CCEC3054124276D550E732441B28CECEBE8C4054154CD6B14D07224414ECAFCAB4BC505415C503AE0947224415ABEDBAC70C70541A2644898747224417E256825D2C70541E4C33DDD0472244134CF67B3DCC705413BDEE0A5DE712441243DD0835FC8054101B3B49FB7712441003E9F319FC905412DBDF3FAB37124410848838AB8C90541F57CACE87B7124416433D2DBFACA0541BD0293D137712441F60A30CF5CCB054178D52B0ACE702441EC953654FCCB05419DC2670B3E70244180EAA7C7D4CC0541D8D63106F26F244162FC1878C2CC0541BA668FC9B66F24417E244C85ABCC05416EEAB62D686F2441EE68A79CE4CC054130D6DC3D056F24412441E38EB0CC0541E0F189B9926E2441BEC252B955CC054177500663686E24415AF7C0209DCC054188543471326E2441B891E154E5CC0541682F013CFF6D244126FD26CEF1CC05417FB8DC9D666D2441542F67E0A1CD0541A08C1342276D244188587499EBCD0541FA446D72DD6C2441A8FF492568CD0541B849F418946C2441C6DF4DC4EECC054192BE7D05F06B24413226DB83C8CB05412F6E6287C16B244180C90565C9CB054132045DE20F6B2441FC48139008CC054163AA2322C56A2441602832850DCC05415D0EA4C49B6A2441D00C18D1ECCB0541D4006C39646A2441D2C974647ECB0541258116AA126A2441D0C61A0B2BCA054189371516B86924415A2BC3D405C90541D319F929DB6824416A5F17E1C9C60541F0ED1FD9EC672441BE9DFAA175C70541DE663F4B9C672441FC355C80DBC70541FBD42A8A5C672441108EAC48FEC70541CB90B1B2CA6624410636852C89C805419FB830CD7166244116F8056D71C8054120AD1B873E66244114247CD038C80541FCA01169186624415219567721C80541DEB1DAAC016624415049E23110C80541E7E971F0CA6524418273083FAAC705415621209AC0652441F44DD687A1C705416E2918F65A652441F2AEC1FDC7C70541F7EBC8FD4B652441DAFAA2C1BDC705414AA0905F3E6524414E313F7E9CC70541CA5C689909652441008AA1EFF7C605410C3D41E4666424413A72ACE328C505416359DBB0576424410C830F3EE7C40541215E9AD61A6424419E123EC3E6C405414902E64EF163244172EEE5B73EC50541FB5160C0776324412610A16E9AC50541802B9B5D39632441B8DEFFB264C5054136E35738D76224410014BB18CBC40541ABEA023AA462244180D267028AC4054132AD9BC556622441E0CF14544EC3054180C3244515622441949818E9E4C105418A2DEAFC9A612441CA07830A43C0054180F30BBA6F6124412C172EBA36C005414F32A56BCE602441948A8D3859C105413F1576D054602441E8B8B3A0D8C2054137C2C6F8F65F2441923FA4CE50C3054119077D35A75F2441F2F5DA63B0C4054113EE7F5F875F24418EDD300525C405411809243E735F2441B0911B9760C4054144C4B58EEE5E2441128867950CC505417A897EB3D65E24417C80B1918AC405413E603135885E24415201136600C40541F1F6EC9F4C5E2441D65003D605C405413CDB17B3D15D24417451157F3EC30541A893E968305D244172265B194BC20541A461537DEA5C244112D582A7B5C105416C6835E8B15C2441765D71D3FFC00541F1F6907F525C24412EC5E648ECBF0541EBD915A01D5C2441FAFEA8B44FC1054187D431AAEA5B24411E4963CEC5C105415B300EBC715B2441E6DAB4AA3BC205414C5C4F9D595B24413E28AB6F78C20541082F58D4085B24410A33FA743DC305412886497FDF5A2441FC4E1BD475C3054147267BAE9A5A2441B6AA469ED9C30541A2DE0C5E5D5A24410632722138C405412BD114D9C15924418413361DD4C60541AAC5771837592441F49AEE4D74C805416A7FA7332459244164AFBDAABEC805416D667E1C175924410636852C89C80541F00DE3C7F6582441E0543F8D04C90541DED380C1035924411AAF1A013BC9054129849ED8F3582441AC8B04F690C905414CC22EEDB0582441E8A59656ACCA0541433DA92371582441222B7283DDCA05419EF30B50105824415810C37B68CB054197A004F6D757244190D42BBEE0CB0541C9336FAE865724418002EE24CCCC054184197CEA61572441E2203DD99BCC0541ADA874D71A572441DEA19A5A08CD05415BA9CD6F075724417C936555E1CC05418281B6E55956244138F3602365CE0541A925925F1756244118212E8871CE0541B95DED6C445524419C187DDE2BD005413769B2B72C5524412602B0830FD1054179C67879995424414023B6E7AED205418798481B2A542441A25CA552C9D30541682A2DE4EC53244124293A4390D40541A63A714EFC53244106617C0101D50541A921A0B9C95324419C6DBE0677D50541BD8F9736A95324419E1B77952CD505410CDCAC306B5324411800868DB9D50541E94C580A48532441CA8CE766A7D50541977FFF19BF52244164646E06B7D605411727C4CE0852244128F71B3EAED90541523B564AB05124412CA9012700DB05417543CAE282512441A257B662ACDB0541C95D3DB3DF502441CA52E0BAA7DD0541CA8D7423855024411C9FF1D562DE05413CE484BB17502441E49E432EBEDF054175F6CF375D4F2441CED595448CE1054197FA05CDB64E244180905130C8E205410B08B6DD964E24417C12255C01E305413078E464294E2441C20CB4B08BE30541DE5D7DEB5B4D2441422B33BC20E405414FC9F88A4A4D2441B24431C4E2E30541F4AE7D4CCE4C2441FC8BEA8778E405417DF0FA52A74C24412E45561D87E5054187DD928D814C24413E40BF1D72E60541186AABDC4F4C2441FC7D5C8B16E805417CD7E149B94B2441B299CF42AAE90541C21FA57B534B2441723E6C7B6EEA0541A0C863D5314B24419CCCAEABD4EA0541940FC11AAE4A2441806FA93510EA0541BCE9B810564A2441EA233771CFE9054159CB5B08CB4924415251992930E90541B0E110C97649244196206E18C7E805419BAB345328492441D67BD1DF02E805410294212DEE482441CCB01D46B4E705412002ED68E0482441D2E1EB00A1E7054191D9F8827E48244158FDDC0814E70541E1A21BF71D482441CAC07D4864E60541D71D962DDE4724419041477177E505414229B3FAA04724415AF67E01D2E40541012C5B197F47244136C9964647E405417A5228034D4724414AE85BA5E3E30541801C28D3A0462441E4D186987CE105418A86250A33462441F63038B4B7DF0541F58BCDC9C945244184E80C995EDE0541652F7CEC87452441506ED1C21ADD054120197730914524413631B5FD63DA0541022AB07293452441A8C056D521D90541C1E52E147245244142EE9ADFF5D60541970B7724664524418EFF25DF2ED405419422E1B66845244174204D3D31D30541CC98844B274524415CB830BF7FD00541FEF57A051145244104C5C76827CE0541ACAB6496F5442441ACF6B97585CC05417CB628CBCB442441CE39A78804CB0541BEAF72A1F14424414EADCAAA0DC905412466C108E2442441F8E718BD7FC80541ACAB2C17E944244170D7FBB5C8C70541320623301A4524412801FD69BEC50541844E429B1E452441468730932FC40541A4A9E9CE16452441D2EB35B386C305419F8C4EEC13452441884E1F277FC205416C31DF37284524412E0CFD62FEC00541B915CA441145244106CD164A44BF05411A642EC5C4442441BC8031270DBB0541AF5C1F03FE44244118D5549593B905415EACF97DEE432441D25C53193BBA054124344FF069432441461FDB043BBA0541A554131495422441329DA3D76DB90541BBDBDFF5A64124413EC055E183B805418D4E5E193D412441AEC283361BB80541095C5A6ED8402441EA8D1922DDB60541535351077D40244174C764DC40B50541EB9EE12765402441FA8CF81B42B40541FB218C39CC3F244198F44FE3A1B105411D2829D1553F24413C7ABB09EBAE054192E4BC4DF53E244182B6D7C269AC05418B485DF3993E2441E52C25E700AB05411FF676B2413E2441EA37C53DEEA9054148CE8F20113E2441E8179985AFA80541832B421DCF3D2441EAB7C663D9A705419AFDADFE653D2441516411EED4A50541D45CAF81153D244112973AFD0FA505419B65C06F003D2441AB31662F79A40541D8A79257363C24414C4247DA16A20541589E3C960D3C2441E78E9E48D9A1054164B9143D763B24412BFA2D68F69F0541651FF82AED3A2441D449C5D4889E05410AD1E775843A24413EF969B8D79D0541F2B11D105E3A2441F4996A974A9D0541ABE49057583A2441C240D123129D05414896A45C4D3A24413230E8C6299C05413BAB0BAD193A2441F0852B34189A0541576466F3E1392441BCD1EE498198054131A71167CC392441008F2231659705418F125587AE3924415C08A102A2960541CCA185F37339244191E50BA0E59505411D22D8E1473924418AB6CCE315950541C6398390F83824415E467566EB93054197F9D7BDC6382441CB78D21FF5920541BA820F59983824415C1332FC2C9205418757F717203824412CF6DDED209005412B0D656CCC372441D0E22E903E8F05417D8B3055A2372441A48F06C87B8E054101B04AF88437244174AA24CFA58D0541EF5EF6E4373724416ABAB87B248C05410297296807372441131CF1EF698B05411D504C2FC33624417625F749198C05413AC086F4743624415944DA56428D0541A4100EBA2C362441A472D712148E05411DEC1BA1A7352441E6D57D8B138F054161C836DC533524410A770B18C88F05414358CC1E25352441F87A2C6D108F05413F266EB2EB3424415AA706D26B8F05410995D28C663424418E4713B632910541F7C4417C18342441121702004D930541768139B9B1332441927C9725F49405412569E1BF3933244146339A1085960541704DB450E4322441FC40E2B9DF930541E037547195322441E535F00A97930541AA2B82D27B322441F175D1C914930541AB5BF1C12D322441A8B88E85CE9005412869059307322441087C3AC33F8F0541AB5D78C72B3224417BCC4E85B68D0541E35467D94032244171A357C8AE8B0541A0F39A9367322441F6BAD5227E8A05413235EC5853322441BCE9FA83CA880541A0729F115C32244108D257D056880541C8952787333224416ECF7321D08605419E70E813E131244146AED511CE840541319F6D53AD312441DB8C60AE79830541F53D45D469312441FBF035770B8205418C1B8E7C273124414E75194A4F80054140A36B69FA302441706AD542AB7E054119AE935ECA302441C6B88705BC7D0541C0DE0FA2AD302441DE64C0E67E7C0541E037F8509B302441E6F21813277B0541881B46086C30244127D24D046E7905410A42CF340E302441969294EA6A770541956AEBA4CD2F24417A27611A977605418F4D00C77F2F2441AC22B76A167505417A17944F4A2F24418C723F867E750541BFAA6E06122F24417B724A849F74054121B0B205AF2E244160CE8B4A4573054166417E3C212E2441C08D21318F710541F0ECAC35D12D24412CE7684C6C700541FBA111EDDB2D24418413BDAE9D6F054157581C97A02D24418BE0A2F08C6E05415DF2A4F0B22D2441C6D0933F056E0541580BB68B812D2441EAB30B872A6C054177F865429A2D2441B499457C406B05411946C125AC2D2441110A22F5616A0541A66EBD929D2D2441D92E8CA94269054196E9AB7E062E2441EA533CB12A6705415C0907FC252E2441E03CE6FBD5650541B2A62C4C092E2441D22994F46F650541C42B6E581D2E244106E543DB57640541BD271409662E244148EA49DA21630541732EB66D912E244154004434F5610541EA35E9E9B52E2441848F0EB860610541020E8AD2DC2E2441DAF979850C610541535A5FC6022F2441CD86B2B24C6005412BFF33CF422F2441CAC5851B9B5F0541CB63F944572F2441CC4EE3469A5E0541D51A1D816C2F2441FDA3090D2F5E0541B7F571C6902F24417400D779E35A054180328829812F2441EB158B80AF5A0541C593346C8C2F2441F134B833E9590541C59563EFAF2F2441EBBCD35EEA5805416B47A335922F2441008568F4CB570541AC3E4E8A7B2F24410347AEDFCD57054182E36299572F24410321DDD14A570541A106BFCD412F24417832C1D4F65505411C2BE5AE432F24417AEA916694550541D5E279FF832F2441E0CC6A573F53054142EC0740B92F244130C47D51E05105418AB54E6EB62F244178CEDBA7CF5005419D70E475C12F24419A1A6B136A4F0541BAAA8A39E02F2441E6B080EEAB4E05418FCE33C8972F2441B361A227DF4D05413F35C049462F2441F02693BD5C4D05413A50E8EBF92E2441CE47EEC52D4C0541401C673ABC2E2441E8D1259D8D4B0541476B480DBA2E2441023E156B354B05416BA9D821772E24410F36C7BB504A05410AC31614452E2441A8D99446D54905410525D831112E2441B22D49B5A6480541E34ADC84D92D2441C8CBF6E5DD4605415809BF876A2D24410EF9CBF0FC440541662616AD412D2441C49DE226974405417BC8A2A00D2D24410342EB06024405413ACBDAC0D22C244106A3E82561430541775C3AB0BB2C244141A3F32382420541EF4C7B1F862C244190FAD83FF94105419D85AFB8672C2441EE526F5B23410541E49577E63E2C24410894011A544005410D70F7563E2C244158E65A34D73F0541175DE713F32B2441784FBCFE5C3E05411810110ABB2B24410E62A359173E0541276135258B2B2441E041044F1A3E05418C986792482B24410C5E30AC733D0541E27CEEDE372B2441E67D03613F3D05415AEA5CCBAD2A2441D453CAA3393B0541B4A246FD4A2A2441BA53ACF5AC390541E7B0DFA7FE292441C9F5007E56380541B73C2F60C7292441A0F9BDD10A3705415F54FA11462924414ADF6A19DF34054105B5CDC89C282441B2AE89AE863205415869B52D5D282441C5D1070ECE3105410F1F9380222824419892B2F55E3005412D8D263D08282441194331850E3005417AA3073FA12724415C0594176A2E0541BFB99CFC7E2724415862AF89702D05419E9680CE30272441A4A2ADEF472B05417DF0399BB326244148F0A6005B2705419B9670D9812624410F28CB103F260541D7F1D34F4E262441F4490BC391240541E642F86A1E2624417CD1879718230541FA2DA5DF0026244199B7308CE321054121573264EB2524417448BEB83A20054189753BBA9B2524419012AEA26A1E054166ECEBA28B25244153E4EB3B7F1D05416952FF887F252441EC822DC50F1D05415699F086722524419F381AA8261B054197115FDE5A252441F6BFB42A3A1B05416D9FA1E3AA2424418C0FF7F29A1C05412B2365876224244113552CB6341D0541E6BF19C31A242441E826BCA7A41D0541276EC499BB2324415244BE5D551E05419D5A5707F42224412C7AA5C7771F0541DB219BF3BA222441C47D4574D21F054172334193582224419C27D2AF1E210541FC5D940DCB212441489F7B2F372205410E15048E9B212441E82F5BB4E9210541A3C006465E212441DCA3D7D965210541ACF845074D212441564A7210FC20054172CD1901262124417295792891200541E1BB372BEC202441654B2310AF200541F90CC006B62024411DC1233627200541FB78307E9720244167CFF439BA1F05412CA0623E71202441C609A0A2A81F05415E7A2EF32B202441D6EEF4ED3C1F054130ED1C15DB1F2441DB40AB5E3C1F054168E463A9CA1F2441CD3A6E5D951F0541DA02793D9A1F24412AD11BE4391F0541092C8A854C1F2441A0F68C43321E0541EEA4B5351B1F24418ABB0EDAFA1D05411BE3A90AD21E2441DCB27E2A181D05411732D7218B1E2441CC6042B7EE1B05415ADE4AEE781E24410A394AFFEB1B05419386C474191E2441102CA4F8E11A0541ADC49846021E24411ADB9E87951A0541EA9EA8B8E81D244170539505CD1A0541D0CC6461AF1D24411C89B46CC71A0541AEF42739821D2441C423784A931A054164F53C14431D2441BCF4DB374719054130D0F162D11C2441823B47F68A1705415CD8C9BB9D1C24415A2C4AEE3B1605419C88A315621C24418C137038EB1405410324FAEB8B1B2441308B4D62D2150541B7A7E9D0301B24417C980512151605417F618533A71A24414CF20D8502160541914EC134171A2441A46E77B0DD1605413C1B355BCC192441A4A3ECC23C1705419AB6AFEB5319244110658F04BB1705411B90DA9366182441C6984819461905410B3D37FA2718244174994FC45D190541C13D1456DC17244191E63A8B791A054175C1CBBB74172441C50F4844C31A054159ED98E7B3162441DAAE0EC94A180541332E85D6931624419776C55FC21705413A7B37266E162441C017C2EB2B180541F4E54DEF50162441FC24E2EF0B1805411724DE030E1624417FD031D443180541DF60DCEABF152441643E71F818180541459687527F152441FEEA3D3235180541FE83C82091152441BF5A65589A180541E5773A3FA3152441B6F2DD39751A05419DB2A999C71524412844ABADE91B0541B9B88267ED152441AEB02729D31C05411AD9867844162441A2A8B87F8B1E0541481793C939162441965F3568F21E0541C107B4353616244176F260F0C81F0541FC6605B430162441F46BC9C5C3200541B420098E301624415E6D1271D920054146E38D54341624413A7C6CCFA422054173A66BB32416244111699C775F240541BE5689CA141624419E1C9E0C102605411A8C78EFFF1524419A36B66F552805413BE3D998EF15244160377E727D2905419AC9132CCA152441FCA88D9A722A05413D4965048C1524410DAE0E9E452B05411ABCCF6273152441D01C1D705A2C0541887A0E9F6E152441F42CD6757D2C0541386206A14115244158589786882D054194E0DDC73615244112BE37AA502E0541FF32941012152441BAC6FB03022F0541F7E3423FFB142441787DDCEDFC2F05414B4D2B9BCC142441BE7B8199AE300541902BADD8A81424413CD08E0BF3300541F1FEFAE295142441BEC30D5E8D31054143FA4344621424412A9E6CA7CF310541C1394E0AEC132441B26FFC983F320541B835C4C2B7132441FAFFFD1E883205416C835FAC65132441C2B72009813305418C1035541A132441ACDC74C11F340541E3A9341DC3122441CEA25DB18A35054156819032AC1224415400D9D11B360541273DBFD83F12244186C24316C2370541AB1849FCF2112441215B3DA08A380541E8262664D2112441960A688603390541CA3BA530DD1124417BA28E0F8339054132DBE187A5112441BEAF7A6994390541A048943147112441162D5A3F3C3A0541958DDA6FDE10244130E1787B463A0541AFCB06C4A1102441CEF212D8E13A0541296F51266610244105EB7A82EC3B05414E94882B990F244183B1FB1DBA3D0541CED31A6C7A0F2441F22F5849463E054129D5E418920F2441C9A9FB73273F05412C3BA8033B0F2441FEF7C0E6A34005417204D7B5F90E24414EE3D4E2FF41054108E4DEE2C10E24414002509B8B430541057ADDF49F0E24416E421B5EC7440541FC2AE4A5630E24415CDA6A93F4450541A7AC4047EB0D2441823FC563B5470541C1FD70A0DA0D2441123E0DB9EA4705410A7AC1C1D10D2441CC736775CB4705418D579A6B760D244126CECF964349054143D9AAC8420D2441B19FBCDE2F4A05411FCFEF300E0D2441FA54761EAB4B0541A3A8F24EC30C24413DCF49A0514D054104F71E506A0C24416EEC9DAE5D4F05415DAB92FF810B244178F5C509A35005414BD5E463E20A2441E01B6A186F5105413BEE61463A0A2441805E633042520541D1CDA1F20E0A244124A1CB47CA5205411B486B0E080A2441DA75CB8ECF5205413684D8DDC0092441806FEBE3A45305412FE452FC2A09244186D52EB1F053054108A819F5EE08244101BA3DA97D5405418A9CAC2CE108244197A950F98B5405419683AF56C10824414CB43BFDBC540541909ED7F874082441C111C21B6F5405418A4DFF21600824419EC76458755405411B9396715408244162D28AB18C54054191D0CDED240824412EADF0A5E65405410B402B57220824418A78133FEA54054133E4AE4E0508244126E123B847550541B170379CEC072441B2798596AD5505416C0F53DAD4072441C26BEFE7005605411EAC8352C507244157A4A7503E56054108C1F6E0B007244112C2BBAF27560541FEEE8291FA062441FEF80DC6F557054132FF823EDE062441A26147EB00590541506F0DFFDA062441AA5C873F3E590541752AC309B406244120DBAFC0FB590541693FD2D7A5062441FA253DDBBA5A05414401F2C79D062441321D8C31755C05412593EE0C9F062441C929CE36EB5C0541C7AABD75AD062441B36ADBF9245E0541B5A6AF6AB1062441D44EAF9CCB5E0541E51A80B5B6062441B2DC4E23AE5F05414BD3351FD7062441863425EEFA600541EB353C10E106244120E564D5BA610541B3BD69F8FE062441168C2465F56205413667FD2602072441A58E821152630541ACF1D22DFE0624418C0FD9E7A663054151EEB9FAF40624418087C8BAC66305416FDB89B4DB062441313F87A32B6405418A15A8FDA20624418647DCFD27650541BC7425BD8A0624418ABAD77AB665054127C55400680624416C0ABDEC9A660541D861DDFA320624419D9CE1C9596705412C95E15926062441123053A5376705416FC02125FC052441D2BC4C2A886705413418B025EB052441BAFDFC96456805413A675979DC0524412EF556EB206905414CE874FEB5052441C7B9C6D8B069054178758E63960524418845A709B16A05419E1BF1E2510524418257D911AF6B0541A79C702825052441D2C4D2E27C6C05413E31794CFE042441CA07AAF9B96C05413C33B056B1042441A27D37CD736D0541A9ED908C65042441103F37656E6E0541F8821E8A18042441CB74EE77CB6E0541474C097FAB032441EEE9A84A3C6F0541B2D21CBF66032441E2B3DF8EA66F0541357A49EB3903244106E16AF3B46F054154505F17D3022441486F6E7B2B7105414A1878D8BE0224416BB9CB3E25710541427E2F85480224411587D286AF720541CA3E098CF00124417EE777A9CE730541EA4685AB52012441CE5FFF27517405417A56B083110124411EEB4002D77405412EDA9F68B6002441F1FF160A39750541F2783F6A660024412EF4D75CD17505411F6CE43AE3FF2341121C5DC215770541D855570495FF234136535D8088770541E5DECEA502FF23412CD9D70334780541A2E10E4D57FE2341D3BFE0A68978054142AAA8308DFD2341F0759D3E137B05419071F4A3E3FC23410B6CA3E9B77C05415C953972A1FC2341F9F15117327D054130BB518A18FC23412C7F4749797E05418F56E496DEFB2341EB6B13F09F7F0541051149905AFB23417646FFE6238105414C10CC3D10FB23417E7F56A6DB8105412CEB6089D0FA23414C39D4E422820541BAAF24E116FA23410065A79E668205412300ECAC6AF92341B5C7D319908405416DAEFA4305F92341063643952A85054114457A782DF8234138CD50CA5986054169E2BFCBDEF723419CD240CDE1860541757E03F36BF72341BAC55B1EE8860541F8577E96C9F62341EA929A634A87054104752D3E7BF623417456FCFAAA870541E6B58574E4F523416597D51316890541F76E2CFF67F52341E09C2918328A05417FB0C9080FF52341637CD5BA788B05412BFA9AA4ECF4234126C0867D168C05415AA4DFEDB6F4234174486EFE488B0541098EB67762F423414EE2FAD9378A054151046293B0F3234158580DA9E88805418C18BC8F4BF323415FFEAB3288870541DC62DA85F6F22341166A37FF9B860541BF26753DCDF223410644CE45B6850541C4C0E51AA1F22341836E3AA6578405412879DB8A5DF22341A1DCCA1B55820541A21EE5712CF223412981194FC780054174DEE11C20F22341FA9B94AC6D80054154B9566512F2234164555193A47F05415B89FB3A0FF22341733EBC35607F0541C275D61C03F22341DA6B1EEEC07E054170F3E4ACF2F123413FFE81736F7E054142B3E157E6F1234170440435287E054158554E48E4F123413A94284FFC7D05415CBD20B3E2F1234108144823747D0541A2CFDFE4D0F123413AE440647C7B05419D330805CDF12341BE5179DD397B0541B96F1D52ABF123419E1C771D9979054137AF071567F12341202B9972547705413FB3416150F1234155097ABA647605412FABEDCB4BF1234169079DB6F5740541E3AF10B208F12341888C5A359A730541AAB841A3C1F02341D77658297C7105415E87808CA0F023410C337EBA307005417EDC42B453F02341E6AB6833146E054121A73B132AF0234160281C05006D0541E2DDE8A60DF02341F25D1DBE6D6B05419861988516F0234100788AC5E46A05418AFB786103F023417D5EDD0E4B690541B55435CF03F02341060213EE6C6805417B272A4104F02341453C31A919670541459A24A1D2EF2341DAEBEB88AA640541D5A7C87393EF2341335F13FEBC610541887A4DE77AEF2341E8FBA02F8C6005414C1B8C6A67EF23411848C846895F054168D2272C25EF2341CC81C95ADC5F0541E0C2F89CD6EE234134D0CD7548600541E7C4EBE95DEE2341CE770EAE7060054114A1F62F5BED2341D068C7FF1061054174B95E37F2EC2341EE7C275DA66105417B3C4D0685EC234174D100251C620541A8B0B5D900EC23414368AA58B762054189BFDF9BADEB23410899FE15CE630541850C4E2E5CEB2341BE5A4401D0630541B535CF7427EB23411A55DA0072640541B6E8F86AEFEA2341208B34BD526405411A9B99D04DEA2341B41DBD9BA565054123542C9622EA2341CA583B05DD6505417D5180C0B4E923412C5DB55D9866054147730E91F7E823417190CF1BA9670541CF356F9D9DE82341D01BA9A19168054198A47BF53DE823414ECF128BDF690541B49312BBBEE7234114F11F9A966B05414071DF2644E72341F4B63136AF6D0541C5FF723DF1E6234105AD0E35A66E0541B6E02C9B92E62341D456CF1AC16F05414009318F13E6234161FDBBA9B27005418A383BA8B9E523412A640DCD2D7105415CF411CC72E5234166885ADAB4710541AD72353723E5234102D5B14877710541C21223A9B2E42341A1910731F1700541986AB93031E423410E03F2FF41700541FB24C6A7D2E323417C3E4E68E36F05413482F02939E3234174E33BF2CF6E05414E3DF278CDE22341D406BA51176E05414B88690765E2234117FD78A2816D0541185F104BF7E123411077091DF76B054112F5DE6458E123417187CD203B6B054126DEB4D8F1E02341E0BE1332B56A05410725BA9B93E02341640079F12E6A0541999C7F5F44E023419A90857598690541F49B020DFADF23414BDAE68B9B6805414D1C314170DF23417DE4E0E0F66605415D546C4BCFDE2341AC43C253F765054171BE95C34EDE234198CFB88039650541DEF9717B0EDE2341E2B7B8764964054177C05091C9DD2341F4FD0AE13C630541A9D0904449DD2341145455F9426105412DDED8DD9FDC234130DC5A2802620541B41D0FE516DC23415A566D5298620541CE55AEAF6FDB2341F071535CEA620541E94674F813DB2341A8EB69D989620541FE67EDED95DA23413A7299AFF1610541B983DE264FDA23419BB12D7050620541A964D003FDD92341F080F760C66205416C03200A62D92341A8E75382626205411BEF95154AD923416691C20F226205419D11F9BAB1D82341BCE98CD51A6105413EDA729B19D823419DED72D57C600541763B1B2795D72341E0978F0AE15E0541F2C5EC7601D72341420FF682C85C05410DFE33BF7FD62341B817382D595B054179B86C770ED623413A6D709C265A05414A4076A5CED523417AEF1A1CB25905412BD23A6BC3D523413A5643937F5905413E8D6074B5D5234108F81D1E535905411E68D5BCA7D523419A9F92004A590541998CC31E9DD5234178EFBDC535590541497871A991D523418A8BCA4E175905411DEBAFC68BD52341FF1424270D59054125B5870C82D52341406AE2980459054148BF2A2878D5234172DC371401590541D1B9EEAF6AD52341C6935E5103590541A9133C3564D52341942695D7FA5805411466627C58D52341EAD9A5BDD55805410B643F3754D5234106100725CE5805414D1272884CD523412C09F077C658054177EA327441D52341CF50873AC65805417C4EBF5437D52341680CF878BE580541353C902430D52341484969E2A65805419AF49D102BD52341C75AD3E77C5805419D5C707B29D523410DF9A5715858054102DD6AE722D523415829322C4758054188B8440621D52341019D0BA83F580541C39859871AD52341359BBB5112580541FB8FD89A16D52341A13B198701580541FBC52C960DD52341D9DE3CBDEA57054135F1789F02D523417604AAC9D9570541E37046B4FCD423411404A31EC2570541FD760706E4D4234106DD20118C570541617AA4FCB4D42341958E50A0EE560541E8BF2F0E8AD423416B0FB27464560541F13CF9CA3BD423410623212324550541D81DF7E508D42341A841EAD4C95305411A4957B4ACD32341CC275F1FC6520541B30FFE4A5BD323415857EF2CBE51054190BA0B2B2BD3234100B5B4F35F50054116499F41D8D22341EAA91F9B93500541FE299D5CA5D2234198DE25AE3D510541C62E68C087D223415E8D49E99E510541A1A7672F69D22341091D39C6AE5205410792339107D223413C9C009EE653054186D155D3CFD12341FFDFB16084540541D0CA7BEF97D1234170E65263BF540541FA593C5D44D12341E5486583655405414D8BA13AFBD02341206ECBE43C540541DE4BA78290D02341F6198AC8295405411C1323EE63D023418439BAD371540541817E0AD5DBCF23412A30DD2570540541C2DFDEA144CF2341BBC43A56E753054153A4D2F107CF234100B0C84F19540541C0DBC0A199CE2341F415171B86530541894E83825BCE23415890D7ECC05205410CF4802B0BCE2341615718D96B520541BBDB283293CD234191B76FF638510541252A11760ECD234168C95AA4FC4F05412979C2508FCC2341F1687A2CF74E05411F2A0908EFCB234111F320030C4E05419F9B59BE73CB2341A883D7DB104D05414D812AC4B2CA23412AED3F51AE4B05412A7717AAA3CA2341F4DC9149AC4A0541E077640471CA23411B80C07DB6490541B13BA7396DCA23417AA754342549054173A482410DCA2341E2A0B784F3470541957A58670ACA23416A6A611B1C4705418F61CB8F03CA234128828D1D90440541A7B2C369E6C92341F69838771643054136C8D34DEAC9234137953FC748410541D7285339F6C92341D2C5DD2A704005418AC3A4290ECA234137CE2AD3213E0541E7FC815627CA2341EE57FEA8ED3C0541FBB379514FCA234142E05429D53B0541FDB3394BB3CA2341616F8701DE3A054175C1694F5BCB23416E59AEA16D390541DEAFFB2ECACB234166B31264A436054151040D3CB6CB23415641AA383C34054161D46D5487CB23416E9785518D320541CDDDC315B0CB2341BA03FA1A2C300541E2CA678EA9CB23417301E2C1D62E05412D43AAA4A4CB2341954C58D9202E054190977BABF4CB234184FC4D0E982B05419D847B5D58CC23417D9D25415D2A05411B5A042988CC2341320FF90C392805413A0053E394CC2341607E97D865260541261357E8C0CC23419A0BB902312405419F843B57BCCC234194BF4A91F9220541A886961BCDCC23415A3170B530220541570AA23340CD23411CCBDEE2921F054126AB947271CD234154EDEAEA161E05411DF6EFB4CACD2341986CAA10041C054118A7965C24CE2341B22D3EF51F190541B45A69E623CE234114F146890D180541E4247BF22DCE2341087B10F3B3170541AC58B69F38CE2341A499D4BF541705418763660F60CE23418CAC2A1AC4160541C0283F29F7CE23414DC22474971505410C7797521BD023414A90FA5D291305414D3CBCB06DD023418E56D09D28120541B89240FEA8D023412C4CB1EF28120541B64100979AD123417E1CDA87F6100541BA79B30D32D22341995DC99CA3100541891E0453AAD2234178C124685F100541187FD33901D323411ECB0116611005414457541F5AD323415E34F08D2810054107925732F5D32341FC542EEF9F1005419CDB24FED2D42341B24EE6EFD7110541E6EDBBA563D5234170086F2C401105416999B6D696D52341F0E4631FB710054103AD2BF0EDD52341589F395A3E0F0541EE8B9A7E2DD623410E588096A80E0541866D91287DD62341169B4FFB9A0B0541A3A9F670A6D6234190AE31FC180905417C37A1ED7FD62341A2CA3FABE5060541FF93EE1332D6234172F401B7EB05054155F7415F09D623419E9213E9B6040541BECE0135ECD5234121F3D90539030541C4E7568DE6D523412E074561EF02054144DC4147B3D523413BBE85ED3C0005416DCB4CC2DCD523418E897FDA92FF0441A211A16AB7D52341888D86D457FC0441DDBDE06E28D6234182948AD1F3F904410A498B4A49D62341B79C527EAEF90441FFE0341C83D62341ACF8884633F9044108AF82E4FED62341CFFBCFEF1AF804411D388A6EE3D72341704FB15DA3F604418CF22A9EFBD723417AEF07E87AF604412F8D3C8877D8234136E8C0E3ADF5044153AE71A75DD92341E7DFDA8866F4044131764E193DDA2341954CB35399F20441833FD90466DA23419279E5B434F10441F52DCFA4CEDA23414C39B6F064EF0441EB7AB1EC25DB23412438E74225EE0441D944E56B86DB2341B750169DA7EC04414AB0D0098EDB2341563D55968CEC04416584B3E203DC2341C6069B2B21EB0441056A74DA23DC2341A2B2C80EC3EA0441C75719692FDC2341DCD72E709AEA0441810FAEB96FDC234120A390B18DE90441A51B28D6AEDC23411A1D7E827FE80441733DDE17DFDC234114C6DEB90FE80441AB0267362BDD23411E45F03758E70441822837C176DD23417AE029C0F0E60441C4A4731DBFDD23410806FF207DE60441F9B4C3C5EDDD2341B0D53711A8E60441A3664B808BDE2341E719A2790BE5044194CC06E4A4DE234139283FD3CFE40441F71E51E5F6DE234150FA48C215E40441549F578F0FDF2341968AEDF1E1E30441A0CE019F4BDF23418D94DC481CE3044123C5A35693DF2341E3DD020A39E2044171F465E20DE0234183BF13F8BBDE044157BA979491E023419A2DD81788DC04410D0A02F8F8E02341AD44B71BDDDA04415BF0C3052BE12341A7B8A2400EDA04415ABE059087E12341CF4DA31A09D904418BB5A85DE1E12341EA2A4D603CD70441CAFB7842F4E1234184ACBC8AE1D604417AADC4C6F5E123419C7DAD25D7D604413E52F15110E2234163948C292CD50441DD4EDCD596E22341344339B38DD204417EE4907264E22341FD64675314D20441951BD396F7E12341022BD936D3D10441DE6E445974E123418CF03A7A6DD104412A894317F0E02341E043B064F3D0044115314E2C45E02341B99615AF54D00441DDF6B7BFF1DF2341C092A54E54CF044137BBF9C242DF2341276E8E9F57CD0441F2F12F6FBADE2341DCA3AC5B98CC04416E0D4F6D7FDE2341AF30A0C23ACC0441FC993EAC18DE2341D04A9730A4CB04411560B08FD7DD2341DCD67AF721CB0441CE9702548FDD234104BA336901CB04416D250EAB68DD23413DB923C9DCCA0441B45D700F45DD2341669CDC3ABCCA0441AF07B3541ADD23411DD54A17B4CA0441DF94B233D8DC23417EB7F3E86ECA0441C65A20EF8DDC23410E43C70FC8C90441510457BC47DC234186B383886EC904415A3CB1D011DC2341B8EC01058BC9044118E6EBC5D4DB23418D7C458CE4C904416EAC65F9A5DB234144B5B368DCC904419471BFEC2DDB2341087D552C09CA0441FEAB59818ADB2341FE8AD52D78CD044178E053D578DA2341FCCA038B27CF04416C5004D603DA2341459295AE2FCF0441EB4EDC45A8D9234134CAF3EA02CF04416CDCE37478D9234124789E40C6CF044180306D272CD923411EB22C5D07D004416E4B7C85CCD82341B99615AF54D00441D682C6F971D82341FC9735EF9DD00441549DC9DFF6D72341264820C5F3D10441304708FDC2D72341892D19B765D20441AC6227FB87D723412E11E2C869D204412B61FF6A2CD72341482F4997D3D20441D4B2447544D6234176A5A550E8D304418FE97A21BCD5234148FC7AFB49D40441D1CB1FCB6DD52341ECDF430D4ED4044126AEC4741FD52341423609188BD40441E71E8D65E1D42341AED7634C4DD20441763AAC63A6D42341C32F5937F8D20441CB8D214E2CD423412EDE132DE0D30441BB8BE91DACD323410EFA3A7BB7D30441C5C3433276D32341E5168209D8D30441135147393DD3234134A485109FD30441826D7E2739D32341E1862EE259D30441C44F23D1EAD223415C873E827ED30441EAA4C89BDED22341482F4997D3D2044100F8353652D223412CDBC30C29D30441E1F7310E49D22341B00D82088ED104411CA1608BF0D123416E0FB2E8FBD104412ABB57F959D123418467A7D3A6D204411380A99CCFD0234119861E4235D30441ED9AB8FA6FD0234136DDF3EC96D30441D09998BA26D02341446C27D4CBD304412EB5B390E2CF23410834C997F8D304416109416B9FCF234191C30C1F52D40441512334B1FFCE234132E4B36D4ED504413293E4B18ACE23418CCACC9F09D604415591B0A913CE2341E423E2CAFDD60441DD53C2CCF6CC2341CED84CA178D904414CE0ADE386CC23417E152BDE70DA04413788B8F8DBCB234122C62554EBDB04418615BCFFA2CB2341DC01E4509ADC044162BFFA1C6FCB23415805441176DD044150BEDE042FCB2341507CB06AAFDE0441F7A08BFEF2CA2341E0D4B5F57EDF044140D8D14A8FCA234164A1D7B9D0E00441B79D338E29CA2341C4C3AEE83AE20441072A1B7DB0C92341F7C95EC9CDE304418E6169195FC92341A47939FFFEE404410999B38D04C92341FCD24E2AF3E50441DE7930A75AC82341664BEB639AE70441EC1F07B438C72341B1E2FE0BD0E90441193A024AABC623412820EDE8ECEA044162FD2735BCC5234130B6E050D9EC0441CD1B975338C62341FB53A4D9A1F00441A8C169380DC523417E1D767D3CF10441E7DC80E6BFC4234146DB07A0FAEE044172129752EEC32341FB53A4D9A1F00441019E6A7947C32341EE91A256E3F10441F09C4E6107C32341573D0D2C14F20441477ED7F278C22341C0E8770145F20441E50CFF6192C2234103B7C9A504F40441367DBBDA38C223417C2AD63E62F404418FB6395755C22341A6DAC014B8F504417A62B0A4A1C22341DEE9605670F904419F43350E0AC22341C85B4DAF84F90441BCD034EDC7C123415AEA70F694F9044111B3D99679C1234118ECA0D602FA0441E3B09D3EF0C02341DFB692BAE6FA044194239A3729C123416F0F9845B6FB044119EC4FC383C1234114C092BB30FD0441BBEC5F63A8C12341E74C8622D3FC0441EA5E50E4C5C1234155BE62DBC2FC0441067C9B9AEFC12341B8A35BCD34FD04411CD3746D5AC22341281888A6DBFD0441B7F203CC1FC32341F0E5C9AA76FF04417EB989770CC32341D204411905000541BA619CDC73C223413E4D5FD7D90305415CD260A52CC2234172BCFB0F3703054189EC5B3B9FC123415575D646B20605419AD6D42D36C3234170A3EDF6F80A0541D47F03ABDDC223417839E15EE50C0541C3958AB846C12341B827019D9A080541AF58A42B3CC0234124B39DD8D50E0541BD578C3B05C02341DCB83D19441005410BE58F42CCBF23416C4411409D0F0541BBFF96505ABF2341D3C90D3B6A140541CEE01BBAC2BE2341A0C35D5AD712054156A799159DBE2341AE1FC3A582140541E6A68D9D81BE2341A05DC122C4150541D2C2B81362BE23419D9A9F5FBC160541B6A56D5D38BE234108495A55A417054145C18C5BFDBD23411B6B31840E19054131DDB7D1DDBD234104536AF6121A05415F6BD3C8DBBD2341A700154CD61A05418DF9EEBFD9BD2341DC3CE3E8A91B05419C87068FCEBD2341EBCE66F0951C0541624E8C3ABBBD234150B7AF02BF1D05410D87F6EEA9BD2341B72CFC1BAF1E0541783145AC9ABD23414CC1BFA32D200541EA140A9695BD23418E8CC12736210541D34D7C9A96BD2341B6395CDDD4210541806ABBD8A4BD234170786AFA3A230541806ABBD8A4BD234114261550FE230541783145AC9ABD234155F116D40625054118A3258D93BD2341D62DE570DA25054137A329B59CBD2341BCDCAF06E726054153C0746BC6BD2341CC3B6572492905410E6BCB78C9BD2341BAE90FC80C2A05414B87FE3EBCBD23418E433593252B054137A329B59CBD2341589E7A9E872C05413EF8CA5787BD23413ABDF10C162D0541D913EE7D55BD2341B2FADFE9322E0541FE84BEBE29BD234150E2185C372F0541192EE913C8BC2341D3781C6448310541E2D7273194BC234158453E289A320541B648F02156BC23412FA50334213505417FF22E3F22BC234144CA2A83423705412163F307DBBB23419EF3C132643A0541E645A429A8BB2341B318E981853C0541DE0C2EFD9DBB2341EB8D25FB503D054149B77CBA8EBB2341F32319633D3F0541B361CB777FBB234113D52379DC4005419461C74F76BB2341686B17E1C84205410F7E02667BBB23413BC53CACE143054185D3AF8081BB2341862982B88D4705418D0C26AD8BBB2341201BCBCB004B0541BF0C2AD594BB234122EB4C502E4D0541EE7E1A56B2BB234166B99EF4ED4E054198B8A022E1BB2341506E09CB68510541C1641FC03FBC2341540E0DD4C3550541F448F87168BC2341FCC1576AF55705410F826E9E72BC2341A07252E06F5905413D108A9570BC23415BB160FDD55A054103D70F415DBC23415C7E92614C5C054119BAC8B23CBC2341EA16C649CB5E05416C9D89742EBC2341BA377D38EC5F054158B9B4EA0EBC2341AAB259F2256205414C0E568DF9BB234116646408C5630541C646BC19DFBB2341DE31A60C60650541C0F0FE5EB4BB23419637464DCE6605410462D3C791BB2341FA1F8F5FF767054107458C3971BB2341583F166EAA6805414BB660A24EBB234185B2220708690541C7D17FA013BB2341A596FBB830690541D460B38748BB2341150B2892D7690541345F87CFE3BA23419AD74956296B0541D095B95352BA23410A4C762FD06B0541D37872C531BA2341DCA24BDA316C0541FDAFB4E9C4B92341F6F38044256B054100936D5BA4B9234159D97936976B05414092599376B92341AB6C1D7ECC6C0541A759EFDE87B923419CA7CBDA566D05419ACABBF752B92341273A5F82676E054107E80EFE8EB923410959D6F0F56E05415858CB7635B923415AB65B7CEA700541F7E5D6CD0EB92341607CCD5FA9700541A8E4B265BCB82341DE827D403C720541FDAB48B1CDB82341EC11B127717205413572BEBC95B82341AC16312896730541BF37200030B82341918FDD0162750541DF360810F9B7234131E352ECE77405414119B1E1B3B72341DE5C0F66D8760541A8E0462DC5B7234134B3D47015770541576C1E7C27B72341A6C4B432607B0541F8F80DBBC0B62341CEA41D84887A05417EDCD2A4BBB62341BD1FFA3DC27C05410787258AB5B62341F8EE6B22CB7E05415A6AE64BA7B62341B22D7A3F31800541788615EA90B623414A4F41CE768105416FBE6FFE5AB623416E39BAC00D83054171BD53E61AB623414E2213735B840541DD66868BCBB52341E07D681EE28505411710B50873B52341E14A9A82588705417882A9B199B52341E24DEAA20F880541CE644E5B4BB523410172F1B1E78905419C644A3342B523410CCB06DDDB8A0541F3B9F3253FB523411C5D8AE4C78B0541D32AC03E0AB52341E2277CC8AB8C0541C62BD82E41B52341B581A193C48D0541BA8079D12BB52341D1A25882E58E0541BE62162BCBB42341E42ACCE8628D0541779A68EF82B42341BC4A63973A8E0541EE5FCA321DB423415E5EAA24118C0541F7B34FBDC7B32341509958819B8C0541B0EBA1817FB3234132B8CFEF298D0541F922E8CD1BB3234118679A85368E05417995E09E4BB323415A329C093F8F0541B25A3A92D3B22341765353F85F900541B4C9D2A227B22341FD22C5DC68920541EE8E2C96AFB123411A371C0A64900541C7C5666A30B12341F09391F533920541FD1C4465A4B12341C4BAE824C3940541C7514609A5B023416C7183DBAB9705415A34F30269B023419EAA0158C8970541318874650AB023417900B7C2E097054177DC0140C7AF234102C3C8E5C3960541BC31AB32C4AF2341BAFE86E27297054182F830DEB0AF2341323C75BF8F9805411A319B929FAF234147946AAA3A990541E74CC2E076AF2341687B937C1A9A0541F38300DD00AF2341ED37055F8F9705415BBB4A51A6AE2341CA900AEA5E98054149D659AF46AE234160A22197C79505414BB9122126AE2341726AC35AF49505417CD1D58618AD23418C555C8DD4970541F1279FB95EAD2341D023AE31949905417E406E976CAC2341BF9E8AEBCD9B05413421E788B9AB2341A750A5A1919D05419DCC515EEAAB2341FFA9BACC859E05410221E360B0AB234194C8313B149F0541B8757CB388AB23412A1A77452C9E0541A13ACE56FEAA23414075BC508E9F05414EE2D01B41AA234192D241DC82A10541913896267EAA2341F6BA8AEEABA20541B6191B90E6A92341E8C26AAFACA405415151692C95A92341C8ABC361FAA50541898BFF98E8A9234148B273428DA70541FD6DA86AA3A9234121D20AF164A80541B6A5FA2E5BA92341B293FCD3FEA60541C2C00DB504A92341CEB4B3C21FA805415A85570868A8234124D8AA31D3A90541AE6818CA59A82341A8A17CD56DAA054106BEC1BC56A823418AC0F343FCAA0541872F9E7546A82341974F272B31AB0541762E825D06A82341F6FBB140ABAB0541A82E86850FA82341F135405DECAB05417D832300F1A723417DFEF1C03DAC0541EFF633C157A823413607E22163AE0541F165CCD1ABA72341740FC2E263B005412F7D774767A62341BAE063A7DAB20541A35DEA7CA6A523411207AB3645B50541FC94325D47A52341EC2642E51CB605410A3D3F06A1A4234172BB0DBDADB7054186E6733F56A42341D0D2BC5A72B6054137573A9C13A423410247E1E306B70541FB3A07D620A4234132F35B595CB70541BDACE94A1EA42341A22CE2258BB70541F30191A916A42341C64929B4ABB70541B27375B218A42341F4BC354D09B80541055736740AA423413E4C718450B80541285738080FA42341ACF8F349B8B80541C8562E24F8A32341C8DE042C61B905419D1DB663E9A32341E8FD83EA01BA0541ACABCD32DEA32341EAC52DFE40BA054139561E84D3A323411A72A87396BA0541530065F1B1A32341C05571859ABA0541475506949CA3234170C86D7ED3BA05414671310A7DA3234116AC3690D7BA0541BB37AF6557A3234116AC3690D7BA05412C379FC532A32341B0901FE224BB05413BC5B69427A32341C4E5C4AC18BB0541018C3C4014A32341FA57B1052DBB05414D3687D5FBA22341862063697EBB0541E56EF189EAA2234192AF9650B3BB054113FD0C81E8A22341E8055C5BF0BB05411A52AE23D3A2234164066CFB14BC05417EA75B3ED9A22341167968F44DBC054140A753EEC6A2234122089CDB82BC0541BAC38E04CCA22341FA24E369A3BC05410EA74FC6BDA223416609BC1BCCBC05419BC38ADCC2A2234186ED94CDF4BC054178519E83AEA22341B826134A11BD0541D0A64776ABA223416A990F434ABD054161A63BFE8FA22341289B3F23B8BD05412FA637D686A2234146F214CE19BE05418289F89778A22341E2D6FD1F67BE0541CE33432D60A223415A4A0AB9C4BE054104FBD45068A22341D084A8752ABF054138DE91EA50A2234106F794CE3EBF054199DC6532ECA123416A990F434ABD05412D4AD6B2E4A023417C31338BA4BF05418EBCCA5B0BA1234140C3B69290C00541A49F83CDEAA02341D81A9CDD16C1054176811CFF80A02341AC74C1A82FC20541F29C3BFD45A023415E1A8C3DF2C005416ED48571EB9F2341C8C84633DAC105413B6061E8569F234180CEE67348C305417242026AFF9E23414C5F4A3BEBC30541B697AB5CFC9E2341C49C381808C5054181D01939F49E2341C0D9165500C605415B7B746E009F2341381705321DC70541EE5D2168C49E234136E1E675DCC705412D5D0DA0969E2341E28D718B56C80541C5B1A2CA659E23414A39DC6087C805419EE8DC9EE69D2341E686B10A9FC605419159A9B7B19D2341AA4B03AE14C60541761148E88D9D2341721C1494C2C6054154AB8B3A699D234178730B5091C70541C5270CC53C9D234118B9D57F78C8054145904EDBF29C23410AFF2A2F04CA0541C08595BABF9C23413EF5870D1ACB0541F77CB9B4799C2341DAB75D4779CC05415DCBF238029C234160AE45A533CE05412AB991DFD19B2341F8B5CF0F31CF05410853D531AD9B2341D0B2A059FBCF05416EA10EB6359B2341601F205679D2054147800639AF9A2341585818AE40D50541CF1B27A6779A234146E3218E6AD6054167A3099F229A2341BE7C294446D8054179673DB9FA992341F23D746521D905410A9E872F2C9A234138659B734DD905410EDF25092E9A2341802430C699DB0541AD5077694E9A2341601C3EF98ADB0541A90FD98F4C9A2341CCF267142ADC0541F0342F55E09923413E3771E2A7DC0541698EAA4ED4992341D474A4C72DDC0541379F9C5A7D992341806F0F7D0FDD05412FD84867709923412AD975C9E6DC0541745EA78B5E99234110ADA34D01DD054121622D725E992341DCB97C50D5DC054121622D725E9923418604046E3ADA054157CB18D6B89823411E0C8ED837DB0541556F8AC92298234174C764273EDC0541DBB14BE08A9623413CEBEA3D9FDE05411764BBA9A696234132A74C0C4AE0054163E9173AC09623414A16703F59E105410DEBF454AD96234178ED2C3B7AE20541922758FFA9962341E0179C3DEBE305411505FEE6DA962341944995AA59E60541EAB3B37A1C9723413289016ED5E80541075CF5A2A9972341DC44633C80EA0541F7565E52E2972341A429080F0AEB0541423DE03F59982341C88A2D6C67EB0541DC077C80B5982341B02294A355EB0541D9DA6847B3982341D03948E296EF0541B2B960CA2C9823411E7F8792D9EF0541A22CEF4F71962341925D437953F1054113A96FDA44962341F2565A8D43F205417C0BE7D2EA9523415E3C155F16F4054116A70740B3952341EECD072B50F40541137AF406B19523410082DF8EFDF40541919C4E1F809523415AF2A340FAF705412EF851AC71952341D253541DFCF8054143570F6F3D9523415A2AFB19D4F80541FAFEC517269523410AA706244CF90541BE4C564E0A952341C0DE5DFD25FA054160342AD7C9942341F0BB7865B2F905410FC2D7ED84942341BE61C77309F90541008EC5C929942341C09F7CB94EF80541BA628FAB14942341C09F7CB94EF8054164646CC60194234174D7D39228F905418829E636F2932341D253541DFCF80541CA6726FCDB932341C21C13436BF9054169F03CC2CF9323418208B7004EFA0541CA99D085A59323412809CDFF96FB05412A11BABFB1932341CA8C4C75C3FB0541E186C6DED0932341F82BB2970AFC0541810FDDA4C493234172CB17BA51FC054155305AA2A6932341D402E41387FC05412D7077827D93234156E089FBB7FC05414AE93DD776932341B0D9159003FD0541B5D9ED657C932341200A6E7E84FD0541D1B3D917D3932341B256AC1920FE05418829E636F2932341BE0AF9FD28FE0541DCFAF5E2029423413434520151FE0541ECCDE2A90094234104573799C4FE05418829E636F29323411E04101219FF0541161F2D16BF932341C642DB56A7FF05418EB5B632C09323410A4ADA4100000641452BC351DF932341184366D64B000641BA943935DE932341D473BEC4CC00064174690317C99323412674494471010641CA99D085A5932341425FD7020B0106413A1651107993234128B2FE89B60006418C5928262A932341322896287A010641BDC47B241693234166C0FC5F68010641843F1F94FC922341B4053C10AB010641D355E370AB922341AA8946057C02064143D263FB7E922341246EEBD7050306413CB85A69519223413E1BC4505A030641FDD8D76633922341FA4B1C3FDB0306416609A5D50F9223412EE48276C90306411DB15B7EF8912341F00DDC79F103064144A3E827EB912341385A1A158D040641372FB923B99123413E531B2A34040641226FD603909123411AF2F5CCD6030641799FA3726C9123416837357D1904064164DFC05243912341BA37C0FCBD04064174B2AD1941912341087DFFAC00050641DFA25DA8469123418A5AA5943105064196186AC765912341468BFD82B2050641760E3C26D791234180DEAF890206064173AF7E630B922341F607098D2A060641EB4508800C92234170A76EAF710606415636B80E1292234140CA5347E5060641F8EBE10D089223419AC3DFDB30070641760E3C26D7912341205CD192C3070641159752ECCA912341D0D8DC9C3B0806415249C2B5E6912341BE63E67C650906418087027BD091234176D9F29B84090641BF982F07B891234176D9F29B840906417640E6AFA091234138034C9FAC0906417D5AEF41CE912341268E557FD60A064118F60FAF9691234160E10786260B0641C911F65BB19123412450A039910B0641908C99CB97912341D2876C93C60B0641D78854161991234172CD36C3AD0C0641A162B548CB9023412EFE8EB12E0D064104395C45A390234128058E9C870D06411C58FC2798902341248299A6FF0D064133779C0A8D90234108970BE8650E0641A62030CE62902341A0663E79890E0641CBE5A93E539023411C899891580E0641D39E8D7323902341A65F3F8E300E06412ACF5AE2FF8F23411C899891580E06414E94D452F08F234156DC4A98A80E0641BF1055DDC38F2341248299A6FF0D064175B80B86AC8F2341F8277334FB0D0641B7F64B4B968F234104DCBF18040E064171CB152D818F234172C7D856420E0641D174A9F0568F23418A74B1CF960E0641EE1F1ACF198F2341D63C5AF6BC0D0641193FBAB10E8F2341625840A3D70D06411612A7780C8F2341A65F3F8E300E0641477DFA76F88E23415221FFC8460E0641D2452E1DC38E234172C7D856420E064143C2AEA7968E2341F8277334FB0D0641A69855A46E8E2341D63C5AF6BC0D0641093D52177D8E234108970BE8650E0641DF1DB234888E2341029E0AD3BE0E0641A33998E1A28E234170C17AEAD60F064107DE9454B18E234116C290E91F110641FA37BBC6B58E23416C7D67382612064104B1811BAF8E23419699D864E5120641ECC38BC2838E2341C4383E872C130641FFF5354C4D8E23418662978A54130641058206481B8E234198166FEE011406419AC30043DF8D2341C232E01AC11406416EE47D40C18D23417870956006140641603EA4B2C58D23411CFA72429E12064182A46060EA8D2341989F36D1501106417530315CB88D23414261F60B671106412F05FB3DA38D23416C7D673826120641639D6175918D2341B046B1DD391306416D1628CA8A8D234128A861BA3B140641D1ECCEC6628D234196937AF87914064167CDA364C98C23417E2BE12F681406418EF1DA97858C23415447C7DC821406416FEADBAC2C8C23416EF49F55D7140641C12DB3C2DD8B234110781FCB03150641175E8031BA8B2341E65BAE9E441406419480DA49898B2341BE77944B5F140641C9184181778B23418C1DE359B613064164E60B78098B23415C40C8F12914064188DD2F72C38A234100D003402D1106415CFEAC6FA58A2341F29E20D207100641237950DF8B8A234132B37C14250F06413DC503FB828A234108970BE8650E06411047A655C28A2341AE9D7F531A0E064106CEDF00C98A2341982E5C200B0D06411DED7FE3BD8A234172CD36C3AD0C0641C233112F498A23414AE91C70C80C064154164E67418A234148AB672A830D06413DF7AD844C8A234104DCBF18040E0641E499CDDC6D8A234170892311FD0E0641B8BA4ADA4F8A2341A09E9552630F06416E620183388A2341640D2E06CE0F064135DDA4F21E8A2341E6EAD3EDFE0F064174EED17E068A23410A14A271820F0641211DC2D2F5892341B2526DB6101006416AA7B5B3D6892341B2526DB610100641DD504977AC892341C48F0CFD0C0E0641E0AF063A78892341AE9D7F531A0E064168197D1D778923416496F5E81C0D06418CDEF68D6789234196F60447310C0641E30EC4FC4389234196F60447310C06410D2E64DF38892341E2BEAD6D570B0641635E314E15892341BE95DFE9D30B06418823ABBE058923419CE9A7EF6C0D0641D707C511EB882341DE7A9ABBA60D0641933B4CB6A1882341327B253B4B0E06411878AF609E882341E46D3D64E20E0641D9982C5E8088234194EA486E5A0F0641678E733D4D8823412CF2D2D857100641A69FA0C934882341A21B2CDC7F100641C7370701238823412CF2D2D857100641B27724E1F98723416052E2366C0F0641BB300816CA872341CCFF452F65100641982B71C50288234178F95C43551106416205D2F7B487234114BC327DB41206412CAD88A09D8723413CA04CD09912064182DD550F7A8723418868F5F6BF1106419F88C6ED3C87234116C290E91F110641C67A53972F872341A0DD76963A110641EB3FCD072087234124F37357451206413E43873DFA862341DEEB746CEC110641B4192E3AD2862341C0835024361106419C0459B0BA862341C02ED43C7B1106417BC67B3382862341F29E20D207100641FE74A6471F862341723E1174F3100641C521F440CF852341A0DD76963A11064121DE91AB798523414261F60B67110641169775E049852341B04C0F4AA5110641C3C5653439852341B6075B19071206418713F66A1D85234128AEBF26A7120641D6F70FBE028523419699D864E51206418972B32DE98423410808E698AB120641C496EA60A584234128AEBF26A7120641D49B81B16C84234192DE8C958312064151BEDBC93B842341DA688076641206412F581F1C17842341826FF4E118120641932EC618EF832341585383B55911064165F3B4093B832341588BDA8E33120641ECBD504A97832341127E7D376F130641584DDB7B3F832341DE1D6ED95A1406419B4BFE6052832341A87FA93501160641DD893E263C832341BA338199AE1606416038693AD98223410C340C1953170641451E60A8AB822341B0BDE9FAEA150641AC211ADE858223414E0FE583041306410A0BCB81328223414616E46E5D130641D1B7187BE28123415C40C8F129140641B5DD2CC98B8123415EBD5E7B461506410E6DB7FA338123415003B42AD21606412E486AC82E80234148364E162E1B0641DD0493B27D8023418CFF97BB411C0641947DCE87D27F23418C76D0D8F21E0641BFCE18F4907F2341AA9F13DDD11D0641B7B40F62637F234110922B06691E06414F231D96297F234144ECDCF7111F06419B0CCE39D67E23411C85592E49200641599CE3EA227F234194E6090B4B210641F924FAB0167F2341386A898077210641EAF0E78CBB7E23416641467C982206417F32E2877F7E23416409EFA2BE210641B6290682397E23414A56B8BDFE220641BE430F14677E23419C56433DA3230641961FD8E0AA7E234110FDA74A43240641DD1B932B2C7E2341AE3C140EBF2606417DD6537BE97D2341BCF6BE5E33250641B16EBAB2D77D2341CEAA96C2E0250641F7CB9A5AB67D23416E28B8CBA1270641CBEC1758987D23415CB3C1ABCB280641244AF8FF767D2341BEE42F99952A06412FC3BE54707D2341D8C95FEBC32B0641BA594871717D2341AA69DB0C542D064146B0B4AD9B7D234114D2FF540A2E064146B0B4AD9B7D2341D00258438B2E0641B1A0643CA17D23416C8DD6A3102F0641B1A0643CA17D2341FC6308208D2F0641A7279EE7A77D2341AE5620492430064175BC4AE9BB7D2341FC9B5FF9663006411F8C7D7ADF7D23417042C40607310641ED202A7CF37D2341B68E02A2A2310641AF0FFDEF0B7E2341F0E1B4A8F23106418F3779D8467E2341D03BDB1AF7310641AD70224D697E234104D44152E53106411B5C3B8BA77E23411E811ACB39320641EEDDDDE5E67E2341B0CD5866D5320641EC7E20231B7F2341D62E7EC33233064125D2D2296B7F23411C7BBC5ECE3306418D63C5F5A47F2341C4B987A35C340641D12F3E51EE7F234132A5A0E19A34064185468DAD418023415E440604E234064120D10B0EC7802341BEF8DD678F350641523C5F0CB3802341BABA28224A360641D38BCC5D84802341EA91E51D6B370641A47F362264802341CEA6575FD137064124CFA37335802341C668179AE7370641E5EF2071178023411869A2198C38064163127B89E67F2341428513464B3906410827624BA87F23411EA184720A3A0641F8537584AA7F23418C8C9DB0483A0641B455529F977F234114258F67DB3A064108590CD5717F2341F0FBC0E3573B0641573D2628577F2341E44774FF4E3B064174E896061A7F23416E1E1BFC263B064148091404FC7E23412494271B463B064169A17A3BEA7E23414AF54C78A33B0641514611151D7F2341B059D81D5E3C064176969716487F234110D8527CD23C0641F4B342A1A07F23412824F263743D064142BA737DD47F23419EE0CD1AB13D06419DEDBCDFDF7F2341084EFFA6343E0641B0158060F57F234114F4CE9A853E064148B51E7812802341AADDC2D7993E06411B0B686A38802341F67DCFDAEF3E064191C743217580234198AD9F0EAB3F06417AD337EEA380234162A2192DB53F06416F0C4441AA8023418426577C244006418F611F48978023411078B954C1400641521D8D139B802341C62ED21A03410641F4831FD8B18023418842D39AD7410641051EFBFED38023414A9FBB546A4206418A95D695DB80234182B87FC5394306415818380ED980234126F68D88CE4406412F628D33D0802341DE71FDA32B460641B5B1A549C280234180A1CDD7E64606410A120732A58023418C479DCB374706410C782B0B838023418A395F3C5E4606412CCD06127080234174A4D81AFE45064191C7432175802341882B21AD844506416C9F80A05F80234106C97502F7440641A182430140802341506982054D45064196BB4F5446802341BEEDBF54BC45064183938CD3308023415E6677C2354606410B718C431680234140A790C8E1460641D0921EE8F77F23410204798274470641C5CB2A3BFE7F23412488B6D1E34706410B718C43168023413A1D3DF343480641E98DC9E2358023413085AB8ECC480641114474BD3E80234168F594C8334A06418E5A80802A802341B495A1CB894A0641F6E2A4E922802341961FA20BF44A06410B718C4316802341ECAE653C594B06417D98E1D8F27F23414C8DD397774B0641CE04378E04802341B227CA149F4D0641E3BAE1680D802341D462202A504E064186F9B0AC0E802341C0DBD797C94E0641C5CB2A3BFE7F23414C7621AA244F06419DEDBCDFDF7F23418A705EB9294F0641FD141275BC7F2341CCCA8EC5D84E0641FF7A364E9A7F2341B68C2D6D104F0641215EF9AE7A7F234118C2C091C64F0641D1F1A3F9687F23416419E65A5E500641DE1EBC7F407F2341E46D53761250064166D4F86E107F234118C2C091C64F0641384B661ADF7E2341D8C78382C14F0641B2D38A83D77E2341AE02DA97725006416D2E297BBF7E2341FC59FF600A51064182BC10D5B27E23417216DB17475106416F944D549D7E23417EBCAA0B98510641F7714DC4827E2341F4CFAB8B6C520641F9D7719D607E2341D659ACCBD6520641DE4EDF482F7E2341EAE0F45D5D520641AE37659A0A7E234134CAE89A71520641AE37659A0A7E2341ECEE32ED3653064120877DB0FC7D2341D867EA5AB05306411826AEDCE07D23412EF7AD8B155406418DDBEACBB07D2341507BEBDA845406410C581B687A7D2341BA91F79D70540641894664AA507D2341BA481064B254064120DF63FA007D234104DBDED72E540641956CDD68BB7C2341585C6479BA530641E7661A78C07C234156053FB0225306414FC77B60A37C234156053FB0225306412C05DDB86B7C2341C2D26339505306410E16268B5C7C234162AB0EA4735306418B046FCD327C2341E29F88C27D530641F38C93362B7C23417A97BA8E6B5406416AA8F4FED87B23411862276AB55306411441F44E897B234176325736FA520641C63AC372557B2341F4CFAB8B6C52064111AC6D2D297B23413273C3D1D9510641CD6C30FEEE7A2341DC2CE7DA32510641AAAA9156B77A2341869D23AACD50064134EEB59F7A7A2341F84BC1D130500641BE31DAE83D7A2341CC21B48E704F064133BF5357F8792341802A82C2824E064175F7F1BEC5792341C4403BF03A5006416E9DC1B2167A23417216DB1747510641713248D4767A234154F7002149520641FD7C0BE5A67A23416A8C8742A9520641CD6C30FEEE7A23412CE96FFC3B53064111AC6D2D297B2341DABE0F2448540641B90DABEC7D7B2341DCCC4DB3215506417F36DC58CC7B234152E04E33F655064100BAABBC027C2341969FE29716570641C6E2DC28517C2341BC3F9C0539590641081B7B901E7C234108E0A8088F59064196CB627A2C7C23419E20C20E3B5A06416842D025FB7B2341B4FE2F6A595A06410DE7C342DA7B2341D639867F0A5B06410714DCC8B17B23411634C38E0F5B0641BFE09266A67B2341F8BDC3CE795B06417A3B315E8E7B23415AF356F32F5C064169A155376C7B234170DF02DE275D06416B077A104A7B23415212DE54FA5C0641CB060C25117B23414415E997115C06415DABFF41F07A2341D890AB48A25B0641B20B612AD37A23418201E8173D5B0641BF3879B0AA7A2341607DAAC8CD5A06411499DA988D7A2341CA93B68BB95A0641232C17F8427A23415480B50BE55906418D1A603A197A2341B2A70AA1C159064133BF5357F87923416807FE9D6B5906417D58C192E179234106D26A79B55806418A85D918B97923415853F01A41580641EAAC2EAE9579234198AD2027F05706417C5122CB7479234158FCCA51A95706412CBD09954D792341F61D5DF68A57064126EA211B2579234142674430495706415D330955E37823415E861E2747560641DDAF39F1AC782341FC508B0291550641516576E07C7823415C21BBCED5540641910F2DEE567823419491A4083D560641B3F2EF4E377823416C8313E42F570641FE639A090B7823416CDA38ADC757064135D544C4DE77234124486A394B580641FAF6D668C077234164F9BF0E92580641A129B2DF92772341FAE2B34BA65806410CF037A1537723419CBB5EB6C95806414E28D608217723417C8E4630F258064128D84F07F6762341906CB48B105906412A3E74E0D376234112783A6D065906417F9ED5C8B67623418834162443590641CA0F80838A7623419C12847F6159064114A9EDBE73762341D2D42227995906415453A4CC4D7623415480B50BE55906415847B0FF1E7623410AEEE697685A06415BADD4D8FC7523412ABB0B21965A064120CF667DDE7523412ABB0B21965A064157401138B2752341CA93B68BB95A06418C23D49892752341A22E009E145B0641477E72907A752341D890AB48A25B0641CCCD8AA66C75234164E20D213F5C06418F89F87170752341669926E7805C0641093AE05B7E752341C617A145F55C064179FB10187D752341E852F75AA65D0641DFF54D2782752341AA0605DED05E0641DFF54D27827523418CE72AE7D25F064101D9108862752341EEC59842F15F064136BCD3E84275234164D999C2C5600641935541242C75234146639A0230610641DEEEAE5F1575234148BABFCBC761064148DDF7A1EB7423411E5509DE22620641D58DDF8BF9742341F64678B9156306417DC0BA02CC742341ACFD907F57630641CF923491BB7423415A8A496DA5640641C9BF4C179374234106A9D0CE6F650641FFA20F787374234174CD1A2135660641F64140A45774234136E11BA10967064141DBADDF40742341586559F078670641699158BA4974234178E9963FE867064116971BAB44742341C640BC088068064106FD3F8422742341928C5BF021690641F53AA1DCEA732341A87807DB196A0641A0DA3FF40774234160E638679D6A0641387ADE0B25742341A0978E3CE46A064189E633C136742341F626526D496B0641B9FDAD6F5B742341585CE591FF6B0641B79789967D742341F09CFE97AB6C06419F7BBAE29674234152D291BC616D0641D2201CEBAE7423419E29B785F96D0641EB1BC7E5EC74234194DA0C5B406E06414B4ABB4236752341C2BB3264426F06411EC8C7B571752341B823A1FFCA6F06416F341D6B8375234178724B2A846F0641428A665DA975234122E387F91E6F06410DA7A3FCC87523414CFF56AD056F0641A5464214E675234156EE0DDB146F0641DE96C8151176234156EE0DDB146F06419EEC110837762341820ADD8EFB6E064114A9EDBE737623416A75566D9B6E06413AF973C09E76234182610258936F06417AD28C16FB762341C412582DDA6F0641230C07553A7723410E5C3F67986F06411F18FB21697723411A5934248170064112EBE29B9177234112C1A2BF0971064105BECA15BA772341723F1D1E7E710641158069BDF1772341C885F91425720641E66F8ED63978234156D75BEDC17206412749A72C96782341E071A5FF1C730641C5BB2DBEDB7823412223FBD4637306413DDE2D4EF6782341D8902C61E773064115288373ED782341BA1A2DA1517406410DC7B39FD178234106125F6D3F750641F23D214BA0782341FC22A83F307506413CD78E86897823419E527873EB7506418FA90815797823413858E8CEB2770641B3F2EF4E37782341987F3D648F77064106C569DD26782341221A8776EA77064170B3B21FFD77234132CE94F914790641B7B7993986772341BA5AA07C96780641DE66A54C22772341B8037BB3FE7706413FF41EBBDC76234182EAB6422F770641077CD5389C7623419E527873EB75064199F805D56576234106125F6D3F75064150E6E02B0376234100880B98A17606417FF6BB12BB7523416E636EB0A8770641FF4A292E6F752341104A57AAA5780641DB888A8637752341A88A70B0517906412E5B04152775234148BA40E40C7A06417A5A9629EE7423414022AF7F957A06419F7BBAE296742341C2845A2A237B06411EF8EA7E607423410C25672D797B0641FB0D895613742341AAEFD308C37A0641CD84F601E2732341A8E19579E97906412D848816A9732341FA0BF651DD7806411CEAACEF86732341844F1A9BA0780641B1F4C4E54373234158250D58E0770641062D634D11732341B6F53C2425770641701BAC8FE7722341E8F2847641760641870FB8C2B872234172DF83F66C7506414C314A679A72234128969CBCAE7506418E69E8CE6772234132E546E7677506419EFC242E1D7223413AC6BF859D740641CAA6DB3BF7712341CEA17533D873064154EAFF84BA712341009FBD85F4720641D6CC54FA61712341926C35A455710641B8AE3B84D07023418CF993BC0A6F06415EDA7733367023413245E00E797106416E9C16DB6D7023411218C888A17106419FB3908992702341FE907FF61A720641B2DB530AA8702341A02043278072064148ED0AC8D17023419688B1C208730641C00F0B58EC70234162D450AAAA730641A81BFF241B71234106125F6D3F75064171AA546A477123410AD7B5C25A760641D6CC54FA6171234176FBFF142077064177A5FF6485712341F0C5195B36780641EAFBB642E4712341BE1FF7D1B179064173E0557A36722341CA65D3C8587A06411E80F49153722341B6DE8A36D27A06416E140DC87A7223416E5AFA512F7C06419F2B87769F7223413C5DB2FF127D0641CF420125C47223411E87BF42D37D064132D7195BEB7223410AB78F768E7E06412B7DE94E3C732341BAE3546732800641BF287C33887323413E543EA1998106410268B962C2732341BE56F64E7D82064170C3C545E3732341F66FBABF4C83064173584C67437423410624C84277840641CC2571F070742341A65398763285064194B4C6359D74234192CC4FE4AB850641A57665DDD4742341C88EEE8BE3850641C5CB40E4C17423417456502416860641C73165BD9F7423413E4BCA422086064199A8D2686E742341EA122CDB5286064116971BAB447423412AC481B09986064136ECF6B131742341E07A9A76DB86064176BE704021742341ACC6395E7D870641506EEA3EF673234118945EE7AA870641A7347000B773234100A8B2FCB28606418A45B9D2A77323415429389E3E8606413C3F88F673732341729F375ED4850641496CA07C4B732341FC8B36DEFF8406414BD2C45529732341083206D25085064110F456FA0A7323411E1EB2BC48860641062D634D1173234194DA8D7385860641B1CC01652E7323414C48BFFF08870641C18EA00C6673234142B02D9B918706418CABDDAB85732341EE2EA8F905880641CFEA1ADBBF732341AED477ED56880641CFEA1ADBBF7323415A9CD985898806419FD3A02C9B7323416642A979DA8806414CD9631D96732341B2E2B57C30890641F2A51ABB8A732341E8A4542468890641CC5594B95F7323417CD72F9B3A890641701BAC8FE7722341D6E20812648706417281D068C5722341425908D2F9860641FBBD55EA1B72234170F1ECCBA4840641C2450C68DB7123419648652A708306414C8930B19E712341805CB93F78820641D43E6DA06E7123410849B8BFA38106410BB0175B4271234126089FB9F78006412E6B173B0D712341F0A5F30E6A8006411B4354BAF77023419CC47A7034810641E064E65ED97023414843F5CEA88106417A6AA94FD47023412ACDF50E13820641F38CA9DFEE70234162E6B97FE282064116770B083C712341249AC7020D84064139616D308971234148E35BA7978506416584DBABDC71234176648EB3EF860641FBBD55EA1B7223414C9FE4C8A08706416FEC4947657223416642A979DA880641969B555A017223417E2E5564D2890641AB293DB4F47123413E8B3D1E658A0641922E92B9B67123410091000F608A0641DF05614D6871234120BE1895378A0641F026850611712341F4EA301B0F8A064165DCC1F5E070234148CCA9B9448906419ABF8456C1702341A63CE688DF880641A7EC9CDC98702341461591F3028906411CA2D9CB6870234172E8786D2B8906419E842E4110702341DAA75F677F8806413BF0150BE96F2341CE0190732E8806412FCA9C4C7E7023413E8B3D1E658A0641D803178BBD70234142997BAD3E8B0641AEEEE69E43712341F27C5964248D0641E9F4177B77712341DE4C369B358E0641B4E991998171234154091252728E06414C8930B19E712341C0D636DB9F8E0641177EAACFA8712341AC4FEE48198F06412F9A79838F71234182331F95328F0641C116AA1F59712341789B8D30BB8F06418E990B9856712341B84CE305029006416F44309169712341A4C59A737B90064111ABC25580712341F21CC03C1391064122459E7CA2712341FC0B776A22910641F728CFC8BB71234146555EA4E09006415BBDE7FEE27123411093BFFCA8900641F35C86160072234106A408CF9990064105854997157223413217FD4B1891064191CF0CA845722341D2EFA7B63B910641EE687AE32E722341B2C28F3064910641969B555A01722341C8571652C49106417A12C305D071234154525361C991064185D9B6B2C971234114F822551A9206410F1DDBFB8C712341F681239584920641D43E6DA06E71234140CB0ACF42920641468E85B6607123415E982F5870920641515579635A7123410C17AAB6E492064116770B083C712341B6DE0B4F1793064128982FC1E4702341AC467AEA9F930641E458F291AA70234184E1C3FCFA9306411D015FDDD96F23412A3684ADE29106417F8ED84B946F234178E4CE3F12930641EA83C055D76F23414E1F2555C3930641388AF1310B702341A665014C6A940641915716BB38702341BCFA876DCA940641E1C36B704A702341E08C034C139606417BC92E6145702341341CC77C789606415679A85F1A702341AC2FC8FC4C970641E0BCCCA8DD6F23417624421B57970641C7995E2D8A6F2341ECE01DD2939706419B76F0B1366F23410011419B829606414D70BFD5026F23412E3B4EDE42970641282039D4D76E234116A6C7BCE2960641A2A85D3DD06E234182CA110FA89706410FFDCA58846E23418EB9C83CB7970641079CFB84686E23413A38439B2B980641A09A1FAEF66D23414E16B1F649980641D7E306E8B46D23410C0E36586B970641C9AF4F9A706D2341D43D59215A960641661B3764496D234108F2B939B895064129AFE1AE376D2341508488AD34950641C3B4A49F326D2341E6165721B194064123DCF9340F6D2341705A7B6A749406416D4DA4EFE26C2341580EDC82D2930641AF854257B06C2341027F18526D93064157B81DCE826C2341AA383C5BC6920641F1951D3E686C23418CC23C9B30930641A98A975C726C23416E4C3DDB9A930641E1FB4117466C23418C196264C8930641495CA3FF286C2341A257C3BC90930641D89A72432A6C2341CCBC79AA35930641D89A72432A6C23416C3EFF4BC1920641230C1DFEFD6B23415E982F5870920641B5B0101BDD6B23412C44C23CBC9206418DFA6540D46B23410C6ECF7F7C9306415DE3EB91AF6B23414CC8FF8B2B930641D19828817F6B23412A8DA9767A920641AC48A27F546B23414803A93610920641716A3424366B234114F822551A92064105754C1AF36A2341B479A8F6A591064180FD7083EB6A23416622832D0E910641103C40C7EC6A2341DAD0205571900641958B58DDDE6A23412EB299F3A68F0641D55DD26BCE6A23418ED9EE88838F0641A44658BDA96A2341885DD942BF91064102E0C5F8926A23412C44C23CBC920641DE1D27515B6A234198BF3158199406412C24582D8F6A2341BA436FA7889406414053BA75116B2341F0050E4FC0940641A9E27DA6766B2341D0D8F5C8E89406418F608A19B26B2341128A4B9E2F95064180CD4DBAFC6B234112E17067C79506412907C8F83B6C2341D43D59215A960641C7794E8A816C23418AAB8AADDD9606415A25E16ECD6C23410C571D922997064110B436B4F96C234122ECA3B38997064116871E2E226D23416E43C97C219806413CD7A42F4D6D2341FCEB501E56990641122CC448A86D23419C735B17259A0641993B2C6C106E23416C071FBDEF9A06417E685EF0266E2341D62179EFFD9B06411193556A5C6E23414E06B574719D0641BBD12A1CBC6E2341C694CDE1BA9F0641C9123BD8FC6E2341601B646EFE9F0641781000CE1B6F2341D45EAF3420A006412E6A64D6486F2341EAFB5E036FA00641B938BC3D706F2341584896F214A00641AD1D2DE7A26F2341B4EE31EAE79F0641E6E94944E96F2341584896F214A00641A8E70E3A087023418E55C30B9CA00641A8E70E3A08702341B2BC542D50A10641E6E94944E96F2341B65D45ECA1A20641E6E94944E96F2341020822D477A30641E6E94944E96F2341E838954891A4064140482461D86F2341DE0FA4B47DA50641E6E94944E96F2341962AFEE68BA606418D8B6F27FA6F2341A29EBC21C7A706414E89341D19702341FC127B5C02A906415E4173423570234148BD5744D8A90641CE3CFD2D73702341BAAA7FF2CFAA06413294262CBF702341A0DBF266E9AB0641C7E49E0B68712341784284889DAC06417D3E031495712341E4B201D3D5AC06413A7DD8C5F47123414A2C6B4692AC0641DD5F0E6546722341706FB60CB4AC0641E0FCBD3395722341E4B201D3D5AC06418E8354C0D87223412293FC6746AD0641FA361DD132732341D2B642C3D8AD0641BB34E2C6517323418CAD569A54AE0641AF19537084732341E08024163EAE064142444AEAB973234184DA881E6BAE0641E9E56FCDCA73234134FECE79FDAE0641F89DAEF2E6732341F6C7B0CC62AF06412A0E2C3D1F742341E62115D58FAF064154220A7549742341C6B1978A57AF06410A7C6E7D7674234172DEC90E6EAF064157BFB9439874234180A8AB61D3AF0641AC5EA41CC874234180A8AB61D3AF064114FE8EF5F7742341EEF4E25079AF0641103F9FB1387523415C411A401FAF06418B33787ED37523419E1829AC0BB00641E7B7D30036762341767FBACDBFB00641DB9C44AA6876234166D91ED6ECB006416EC73B249E762341F295D30FCBB00641DE39F478B776234142728DB438B006417164EBF2EC7623410492921FC8AF0641AA300850337723412CD5DDE5E9AF0641D544E6875D7723412202106A00B006412AE4D0608D7723411A2F42EE16B006412288314E7F772341EAC20594E1B00641166DA2F7B1772341EAC20594E1B00641CCC60600DF77234166D91ED6ECB00641B84FD89603782341EAC20594E1B0064198BD1AD75A7823412CD5DDE5E9AF06417F10CEC0E4782341B014E8BB08AF0641452271EE2D792341C0BA83B3DBAE064116D87409697923413CD19CF5E6AE0641F2A8077B71792341B014E8BB08AF0641B51DFBD96B79234118FD64317FB106414C07E297607923415A7E508541B30641F8DE25280C792341AA1F414493B40641E0CA47F0E17823416416551B0FB506411771E3E7B47823411043879F25B50641F900669D7C7823418C59A0E130B506413F5F40BA6B7823419050B4B8ACB50641CA2D98219378234168B745DA60B606413A29220DD1782341FC6A0EEBBAB60641CD53198706792341FC6A0EEBBAB606418A091DA24179234196F1A477FEB60641F2A8077B7179234130783B0442B70641E68D7824A4792341D4D19F0C6FB70641EA2A28F3F2792341F2411D57A7B70641B3848CFB1F7A23417C2218EC17B806417D551F6D287A2341B02F45059FB80641B3848CFB1F7A2341A80654718BB906415926B2DE307A2341E20A95618EBA0641713A90165B7A23410A4EE027B0BA06419B4E6E4E857A23411818C27A15BB064135D504DBC87A234174683A5ABEBB06413D31A4EDD67A234190FCFDFF88BC06419EEB1D1DD47A2341C6092B1910BD0641CDBEEB98BD7A2341FA16583297BD0641D41A8BABCB7A23413024854B1EBE0641D05B9B670C7B2341E81A99229ABE06411D9FE62D2E7B2341B8AE5CC864BF0641C4400C113F7B2341E6E8BB6502C00641A1119F82477B2341789C84765CC00641A86D3E95557B2341E2B6DEA86AC106410928B8C4527B234118C40BC2F1C1064131161597097B23412438CAFC2CC3064151A8D256B27A2341680FD96819C4064100C8D7C1417A2341E425F2AA24C40641BF9F1B52ED792341603C0BED2FC40641958B3D1AC3792341C4B57460ECC30641C4D539FF87792341AE18C5919DC30641FFC396D13E792341C0BE608970C306412E0E93B603792341489F5B1EE1C30641BE1209CBC578234140766A8ACDC40641A7FE2A939B782341F099B0E55FC50641DEA4C68A6E78234164DDFBAB81C506414B7ACF10397823416CB0C9276BC506413466F1D80E782341C28397A354C5064157955E67067823417A7AAB7AD0C506414B7ACF1039782341C6248862A6C6064114D4331966782341B428C952A9C706419FA28B808D78234192866E4BD9C8064108B9A4C298782341808AAF3BDCC90641101544D5A6782341ECA4096EEACA0641D2893734A1782341BA38CD13B5CB06412BE81151907823414ABAB86777CD06410C7894065878234124905D8BE5D00641431E30FE2A78234150CABC2883D1064186682CE3EF77234150CABC2883D10641CCC60600DF77234196D3A85107D1064102F6738ED6772341C63FE5AB3CD00641166DA2F7B1772341D8E580A30FD006413D5BFFC96877234162C67B3880D00641B28CA76241772341CCE0D56A8ED1064165495C9C1F7723416E3A3A73BBD10641AFEFF793F27623410420E040ADD00641A7935881E4762341B0A235DDEDCF06417D7F7A49BA7623414C29CC6931D00641303C2F8398762341EE8230725ED00641C72516418D7623413E5FEA16CCCF06410D0DC2F4A0762341F2B40D2FF6CE064114696107AF7623410C849ABADCCD0641ACC9762E7F762341A660545F4ACD0641C72516418D762341FE0FDC7FA1CC0641F2B022E292762341D2D57CE203CC0641E2F8E3BC76762341648945F35DCC06418D59F9E346762341C02FE1EA30CC06416BA1BABE2A762341BA38CD13B5CB064139313D74F2752341862BA0FA2DCB0641454CCCCABF7523414078D7E9D3CA064136948DA5A3752341AEC40ED979CA064165DE898A687523418E54918E41CA06412B126D2D22752341067496F9D0C90641D6728254F27423415A476475BAC9064181D3977BC2742341F4CDFA01FEC90641B87933739574234124E4134409CA06416B36E8AC73742341FCA0C87DE7C90641326ACB4F2D74234172C0CDE876C90641836C065A0E7423415A476475BAC9064197E334C3E973234178B7E1BFF2C906416DCF568BBF7323418E54918E41CA064118306CB28F732341484BA565BDCA06412CA79A1B6B732341484BA565BDCA0641EA7EDEAB16732341862BA0FA2DCB064195DFF3D2E67223412E7C18DAD6CB0641B1B2C14ED0722341D2D57CE203CC064150F8471FD3722341100C9B8F9ECB0641A1FA8229B472234120B2368771CB0641C9E8DFFB6A7223412E7C18DAD6CB0641CDA7CF3F2A7223412E7C18DAD6CB0641202139B3E6712341C802AF661ACC0641E6541C56A071234106E3A9FB8ACC064182FDF2575471234126532746C3CC064135BAA791327123414ABAB86777CD0641A9EB4F2A0B712341C29EF4ECEACE0641034A2A47FA7023411EEF6CCC93CF0641267997D5F1702341BCA7E0156FCE0641544C6551DB7023414EEC95240FCC0641777BD2DFD2702341DAFE6D7617CB0641F4081A8BB970234132AEF5966ECA0641D9354C0FD0702341808AAF3BDCC906417FD771F2E0702341A8231E1A28C90641F4081A8BB97023413EB3A0CFEFC80641460B55959A7023411E432385B7C80641598283FE757023419A593CC7C2C80641CE3CFD2D73702341A8231E1A28C906419F692FB28970234198275F0A2BCA06410024A9E186702341D2D57CE203CC06412FF7765D707023419896720CE5CC06416DF9B1675170234190C3A490FBCC06414E89341D19702341A660545F4ACD06412CD1F5F7FC6F2341528D86E360CD064115BD17C0D26F2341CEA39F256CCD06414C63B3B7A56F23411C8059CAD9CC0641354FD57F7B6F23410CDABDD206CD06416CF570774E6F2341D6766DA155CD064154E1923F246F2341889AB3FCE7CD0641F49D4779026F234122214A892BCE0641A75AFCB2E06E2341682A36B2AFCD0641EC41A866F46E234126532746C3CC064170B460BB0D6F234126A94A5EEDCB0641A75AFCB2E06E234194F5814D93CB0641BBD12A1CBC6E23414078D7E9D3CA0641BBD12A1CBC6E2341808AAF3BDCC90641DD896941D86E23411E432385B7C80641260EC5C33A6F23416A7EEC6AD3C606415022A3FB646F23417A7AAB7AD0C50641354FD57F7B6F2341BC8C83CCD8C40641E6E94944E96F2341680FD96819C4064120B666A12F702341D65B1058BFC306413B1206B43D702341626EE8A9C7C206419CCC7FE33A70234118C40BC2F1C106410C3F383854702341C446615E32C10641B3E05D1B6570234112231B03A0C006414ACA44D959702341B8AE5CC864BF06410C3F383854702341D27DE9534BBE06414ACA44D959702341FA16583297BD064104E39825467023412A83948CCCBC064109A2886905702341061C036B18BC0641DF8DAA31DB6F2341A6438AB6ADBD0641829220469D6F2341088B166DD2BE06418B872E37F76E2341EEBB89E1EBBF0641A4BD4CE4916E23413A6666C9C1C006410937B6574E6E23413A6666C9C1C00641C129893EC76D234100275CF3A2C106419378FB374E6D2341D88DED1457C20641E9392686EE6C234106C84CB2F4C20641050DF401D86C2341DE8401ECD2C2064166C76D31D56C2341BE4F4D87B6C006415E6BCE1EC76C2341C6783E1BCABF0641FDB054EFC96C23411E28C63B21BF06415E6BCE1EC76C2341225AA3F8B8BD0641FDB054EFC96C2341B83F49C6AABC0641BB66580A056D2341268C80B550BC0641875D6CE1806D23417A5F4E313ABC0641C5E87882866D23414C25EF939CBB0641E1BB46FE6F6D2341CC6DE5923FBA06415CD25F407B6D234104ADEF685EB90641A556BBC2DD6D23414CB6DB91E2B80641993B2C6C106E234192BFC7BA66B80641FAF5A59B0D6E2341E29B815FD4B706418A83ED46F46D23410C11AAE28DB6064182274E34E66D23413C7DE63CC3B50641B9CDE92BB96D23419050B4B8ACB50641AA15AB069D6D234126E0366E74B50641122CC448A86D23416416551B0FB50641EFFC56BAB06D2341186C783339B406413D40A280D26D2341701B005490B30641EEDA1645406E234198B46E32DCB20641BF901A607B6E23418AEA8CDF76B2064128A733A2866E23415CB02D42D9B10641724DCF99596E2341E2EF3718F8B00641B0D8DB3A5F6E234162382E179BAF06414203D3B4946E23415C411A401FAF0641D52DCA2ECA6E23412634ED2698AE064193E3CD49056F23414ECD5B05E4AD0641B69B0C6F216F23411AC02EEC5CAD06410B3BF747516F2341784284889DAC0641D40B8AB9596F23413C6289F32CAC06416CF570774E6F2341C874614535AB06416499D164406F234102B46B1B54AA064187C83EF3376F23416236C1B794A9064154E1923F246F2341EE4899099DA80641D16EDAEA0A6F234146F8202AF4A70641D9CA79FD186F234166BEC18C56A706419B3F6D5C136F2341BC6D49ADADA606416858C1A8FF6E23415253EF7A9FA50641A75AFCB2E06E2341E838954891A40641D52DCA2ECA6E234186F108926CA3064136E8435EC76E2341A0C0951D53A20641BBD12A1CBC6E2341D02CD27788A10641B3758B09AE6E234120098C1CF6A00641C7ECB972896E23419087A0C8339F0641D30749C9566E23419AB0915C479E0641A197CB7E1E6E23415EAC506C449D0641F3990689FF6D23412A9F2353BD9C06418777B132A36D23416494852A579C0641397180566F6D2341A2379D70C49B0641F4CB1E4E576D23419848E642B59B0641E1A35BCD416D234104160BCCE29B0641565998BC116D2341AE26549ED39B0641386AE18E026D2341DA5061E1939C0641CA0ED5ABE16C23411C02B7B6DA9C06417E0F43971A6D23411686A170169F0641CC1574734E6D2341F2854EDBE2A00641CA0ED5ABE16C23415EAA982DA8A106418F306750C36C2341925EF94506A106414E574EFA666C234192B51E0F9EA10641A883F894056C23416AA78DEA90A2064168B17E06166C23412C0476A423A306419DBC04E80B6C2341B855D87CC0A3064198C159EDCD6B2341A2177724F8A30641CDA41C4EAE6B2341ACAF08896FA30641BC0A41278C6B2341823C140CF1A206417F9EEB717A6B23418A1D8DAA26A206411E98BA95466B23410EA528D2E09F0641D2F7AD92F06A2341120A8C2A52A106415C3BD2DBB36A2341AE1DE03F5AA00641215D6480956A23411CA21D8FC9A00641EEB063B0106A23416CBE3FD8E39E06411A5B1ABEEA69234162CF88AAD49E064117C6939C8A6923418C8B6461119F0641B6979F3F4169234118DDC639AE9F0641F06E6ED3F2682341289F124CB2A10641B5900078D46823415670CB5935A3064112BECF73C86823410E9515ACFAA30641B5FC9EB7C968234150E6778497A40641B3967ADEEB6823415C3CC176BDA4064103973154086923410604230FF0A406410B649F67196923410654A9101BA5064181B4DCDE60692341B222AA70BAA50641A669625814692341B8EE9F8D42A7064160309F8FF1682341D8C263DEDCA70641AAC90CCBDA682341FA46A12D4CA80641EA072599BF68234170B3F6E25DA80641D74B00589F682341CE2AD27965A80641D1E4B61D6C6823416414C6B679A80641065CDB3E57682341E4B8B9D358A80641AB94301C41682341DA797CA41EA80641131D558539682341B05DADF037A80641C1B679363F6823416414C6B679A80641761D0CFB55682341469EC6F6E3A80641FC0086D152682341C64959DB2FA90641CB7D6DE338682341B2C21049A9A90641909FFF871A682341EAD435F20BAA06416D49FF1FD867234180154FF8B7AA0641A426481AA16723419E3BC8B622AA06413F04488A8667234114418BA71DAA06413EFDA8C219672341B419361241AA064175DAF1BCE2662341AA311EAC9EAA0641624690FCD76623414AB3A34D2AAA06413A90E521CF6623418856BB9397A906411A13479ACC662341889FA2CD55A9064178401696C0662341700A1CACF5A806411D0DCD33B5662341DAC902A649A80641EF5B775E6E6623417CF9D2D904A906416ED8A7FA376623410852D4790EAA0641D8C6F03C0E6623414A032A4F55AA0641AE16C0C81C662341442950788CAB0641799F9BA7316623415A0E5D9B17AC06412E2EF1EC5D66234106E4FCC223AD0641D961F1C4856623410842C15328AE06413A90E521CF662341F8CF5518E8AF06418035472AE766234166F49F6AADB006416978FD87716623414A937D015EB2064152F08F9495662341EE7966FB5AB30641E68E094B5D6623418EA9362F16B40641F34F83913F662341D83B05A392B306416DD10833CB652341F02E5055F7B40641A7A8D7C67C652341F6B1046328B3064177F0E229C96423411E09D7968CB506416399BD60316423412010765EF9B50641C01E73A629632341F64ACC73AAB606419007F9F70463234116C86AFBACB606412FD9049BBB62234120679B2791B60641C6DDA22A616223418A7DA7EA7CB606415DBA7D39F1612341B499769E63B606413203AEFD92612341FEDBBE10B5B50641912A03936F6123417E80B22D94B506419490276C4D612341FEDBBE10B5B50641611389E44A612341728A5C3818B5064104E6B9E856612341381A73FEB0B30641EB56AD2D0E612341AED64EB5EDB30641B8D90EA60B612341F0DEC953CCB406419B56F6B7F16023419CA62BECFEB40641355CB9A8EC602341920E9A8787B50641073FC593B060234172E18101B0B50641A2B026C4A0602341A487A48A34B406411C394B2D996023413A7198C748B406415144D10E8F60234190B0D5F682B40641ECB5323F7F6023413AC8BD90E0B4064161D70D6E446023419EADCAB36BB50641B33DE9BC3E602341CA275EF856B6064130C093BF1F6023410AD9B3CD9DB60641ADD69F820B60234120BEC0F028B70641228CDC71DB5F23419831B56DA7B70641407B939FEA5F2341D09AFFDFA1B80641F27462C3B65F23411253F47C55B90641076FE85C9F5F2341E428E73995B80641F4DA869C945F2341B0C63B8F07B806416702DC31715F234180958F84DAB60641E11E625B745F23414A836ADB77B60641EC79B7C8785F23419E04F07C03B60641F740AB75725F234132E744F2AAB50641B19B496D5A5F23413CCF5C584DB50641EDD83CDAE95E23417291FBFF84B50641C52292FFE05E234176A6D856CBB6064165FB3C6A045F2341DAE20A43EEB706415B3449BD0A5F2341860192A4B8B80641337E9EE2015F234112036E7B2AB90641364348CD505E2341AA4A264943BA0641EC3D3C52725E2341EA9B8821E0BA064164F49DA2975E2341625F03A089BB06411AEF9127B95E2341508FD3D344BC06416094F32FD15E234186F17E7ED2BC0641F89F3087E35E2341E82612A388BD064190AB6DDEF55E234194F5120328BE06416B6286A4375F234104D814E39BBF06419E07E8AC4F5F23419A182EE947C006413D45928FFB5E2341528DFE3C38C106412F7D7981AC5E2341549B3CCC11C2064114F4E62C7B5E2341D231F25917C10641FBF83B323D5E234174113C8CA7C10641E17648A5785E2341AE3FDD53BDC306417CE8A9D5685E23411856E916A9C306416EB4F287245E2341AC88C48D7BC3064168B9478DE65D2341C216ACE76EC30641B42478E1A25D2341C2C625E643C306412BD43A6A5B5D234196F33D6C1BC3064143C8469D2C5D2341CCFEC34D11C30641DB2B6A3E435C23410CB0192358C306416C355DD3AA5B23416E8E877E76C306413157EF778C5B2341787D3EAC85C3064134BD13516A5B23416E952646E3C306415D3EE27CD95A2341B2FB6575C6C506412D7BC300A15A23415AABB91573C60641A8F2903F8F5A2341D88F28B262C606416D415601855A2341A67EC32F3FC6064145E476F5665A2341080A4600C7C5064165F1ED0E4F5A23418E75442D88C506419691C3CA355A23411E95C8D04EC5064150CF230A085A2341BE08AD7D7CC406410A0D8449DA5923413CD4D017DCC406415E7BCDAE96592341CEF2BB3858C30641E7185832825923419A91E9EC83C3064178E0923A215923419E5F53E863C406410BE7CBDB575923413067250CE5C506419813C2C18B5923414E3E0E0A7CC70641200996E09E5923419AA85F5807C806410CB53AAEB2592341A8FD58E4B8C8064138EC5C75D35923417C51A59134CA0641ACE13094E659234194F16BC8AACB0641906FFE9C6959234168AE704167CC064116ACC082765823415E287A33E0CD06414B61EE0037582341F665D59B37CE0641ACA1997804582341DE5DEF1BCBCE064155F83FE3EB5723415E2913B62ACF064143EBCDA07E5723418E3A78384ECF06419083C2B37357234150BC67AA33D00641E545674B1C572341C29CE3066DD00641D71FAA061F572341BA665AC296D10641760DA253BB562341A2F422F49ED10641B57FD921B3562341B2B13BC946D0064164ACD4DE61562341A643F73A05D0064193B950CFC45523414A8545E312D00641B6336946AE5523415CC05AEAE9CF064195ACDE8C575523410202A992F7CF06419586261FD5542341F84D231CF2CF064196DA8151C15423411A74E060EFCF0641D54CB91FB95423415AD9A5EC79CF0641F5593039A15423412AC8406A56CF06417B36BE2C9F542341E0DBEB4DFACF0641A74728863D5423419C8F71C4FFCF06419AC921A618542341D62766D7F4CF064117AE904208542341E2C2A04B6AD0064117AE90420854234160116136E5D00641EEE30FD9E85323415CC1F36C34D10641EEE30FD9E8532341587186A383D10641540782E5EA5323411426A59CD3D20641910C1856E1532341849D682DCCD3064143FA0FA37D532341E0F261B97DD40641CF043C846A532341D457274508D40641E3ACF2E842532341ACFA4739EAD30641A53ABB1A4B532341DA8DB089DED206410C5E2D274D5323417A0195360CD20641B6CD19BD4953234192097BB678D106417E31374119532341BEB6C78B47D10641AD646B9FFE5223415ADA3E6FC4D006413602F622EA522341E0DBEB4DFACF06413602F622EA5223415AD9A5EC79CF0641587C0E9AD35223418EA330048FCE0641C2607D36C3522341CA3A8C9439CD0641C5CD1E94C45223414CBFD5C38ACC064187AF42F8B852234134B656C1D3CB0641B6A7614FC7522341DA8D531B56CB064197EE4568CB522341846F7C56C5CA0641788985B3BB52234194C3DC5F2CCA0641CD4B2A4B6452234112A84BFC1BCA0641D7E27B2D195223412093F33942CA0641E43ACA9FBB512341F6E5A66473CA0641C3EE54ED3B512341C8BBF6DFBFCA0641BE0B8E580751234132655075D8CA0641C5E1E2AACE502341B680E1D8E8CA064122484B6799502341123F9330DBCA0641FEAB68EB68502341A695399BC2CA0641AA1767182A502341DAF60BE796CA064131CE3C9EA54F23419E7762D631CA064161F4FEB91D4F23419C90ADD8C1C90641DBF1B8589D4E23411CC5893E62C90641B8FD8C41454E2341E47C02F51DC9064166BDE6A0F24D2341D05A38F0D6C80641E70A0932A84D23413E54FF4EA0C80641E10EFC715E4D23417A6957117AC80641FD061BC96C4D2341AECBC2DF98C90641D6FD96EF3A4D234148F0D24560CA06412129EAA42E4D2341A2C7CF9FE2C906412D2DDDE4E44C2341E02D2EAEB7CA0641C9057D6FA74C2341AA7CEE9832CB06418604DA3E674C2341900AB7CA3ACB0641F255EA38584C234132655075D8CA06418A193201414C2341B86796D658CB06414E68F7C2364C2341D4C082A2C0CB0641BC0D63EF134C2341E8E24CA707CC064109A65702094C2341D4C082A2C0CB0641B1FCFD6CF04B234104D2E724E4CB0641B8D252BFB74B2341F8CDF4E42DCC064139CC191E814B2341EEB0B6A2E7CC0641D7115B06454B2341F4E7D86908CD0641AD47DA9C254B23413E6B75BA23CD0641B15C325FFF4A234190A2978144CD06416D0734FCD24A23413067827A6DCD064180424903AA4A234140522AB893CD0641FB0D7274844A234192894C7FB4CD064179463C43604A234116A5DDE2C4CD06414156FE94434A2341AAFB834DACCD06412B343490FC492341AE4BF1165DCD06414F02A839D2492341E2ACC36231CD06419C9A9C4CC7492341849EA4418ECD06415E7CC0B0BB492341769AB101D8CD0641268C82029F492341620F2F3150CE0641FCC101997F49234106BBCE27E9CE0641CEE2286D86492341724BDDBA71CF06418C5B99DCB4492341D0F04310D4CF0641A96CFE5ED849234154A31CA8A3D006413D1BEE64E7492341B87FA5C426D10641DFEF9AAFF3492341CC38B7FD2CD20641EA000032174A2341888384A8F1D20641B80CCF43444A2341EEC8C590B5D206418FBC617A934A234146A0C2EA37D2064133FEAF22A14A234170E456F4C5D206419C3A685AB84A234126F801D869D30641C604E9C3D74A2341A08D9C2DF3D4064159B3D8C9E64A2341861CFEE145D60641B3C9D3BC004B23413C30A9C5E9D60641CD2E99488B4A234182CD299BDFD70641C3974766D64A234122C13C7FD1DA06417C814C73BC4A234140978CFA1DDB0641D09B3AA68C4A2341126DDC756ADB064197ABFCF76F4A234174F85E46F2DA064122F13DE0334A2341C2B21D5E2EDB064122772A40C5492341A00C32E26CD70641E986EC91A8492341182337837CD606415D02AD104D49234112D637D322D306418FF6DDFE1F4923415EA8A86AA4D10641998D2FE1D44823413464146116D10641FBCDDA58A248234116250C1A89D1064199131C41664823419E77BF44BAD10641CA074D2F39482341ECE07710FBD00641DD42623610482341ECE07710FBD006418B1B02C1D2472341D2D891908ED106410AA827C29A47234188EC3C7432D206417A0E907E6547234112D637D322D306414AC215F56A472341E4AB874E6FD30641EBEE0BDB9E472341DA259140E8D406414F166C50DC472341B697B4B2F4D606412C48F8A6064823417279C99178D806413D556AE973482341CE4EF154EEDC0641A13DCCC519482341FEC9A7259DDD064104262EA2BF472341A6F2AACB1ADE0641A26B6F8A8347234146E48BAA77DE06413C9C58B06D4723418CEAC44BAEDE064112D2D7464E472341A489F2FFD9DE06419AC7AB65614723419A6CB4BD93DF0641277A8EAB26472341B08E7EC2DADF06410BD6CA86044723412AF689AFE5DF0641BAAE6A11C74623418264CE3D27E0064147E739B71D46234192A01F59C0D90641919879CCA24523414AB4CA3C64DA0641FB7CE868924523416E2AF54A12DA0641E245C6A1714523417461171233DA0641BAE8E6955345234100312EEC48DA064182F8A8E73645234150EBEC0385DA064159A83B1E8645234176E0ACC6ACDC0641BB62FA35C2452341DE8A9FDE0FDE064195ADD18E7C452341807C80BD6CDE064178615705824523417279260001E00641DE306EDF974523416425C6F699E006413F71195765452341FC62215FF1E00641B0D781133045234162BC0D2B59E106419F442371314523410AE510D1D6E10641C212971A074523419CEB49720DE20641D44DAC21DE44234100C8D28E90E20641646D30C5A4442341A671408094E00641FE9D19EB8E442341DA3BCB97A9DF0641B51A7D9A734423415252D038B9DE064161867BC734442341C0E2DECB41DF06414ABCFA5D1544234108667B1C5DDF06413D3EF47DF04323417C96644247DF0641719FC6C9C4432341D404A9D088DF064184DADBD09B4323416C420439E0DF064179C9764E78432341146B07DF5DE00641F8559C4F404323412824191864E1064132B37B5B5E432341B20D147754E20641D58728A66A4323410C36171DD2E20641E3ADE5EA67432341402E319D65E30641E92FDF0A4343234188B1CDED80E306411D91B15617432341BC12A03955E30641C37AB663FD422341C249C20076E30641B554F91E00432341EE8D560A04E406419C1DD757DF4223414C33BD5F66E40641DEA466E8B042234146FC9A9845E40641D49301668D4223412007DBD51DE20641AC713761464223414097E968A6E20641E461750F6342234194B659B081E4064150B38509544223419A84C3AB61E50641C019EEC51E42234150986E8F05E60641697094300642234176775169F4E4064115DC925DC7412341EC249E3EC3E4064181B38FB749412341B8C3CBF2EEE40641AC25C78541412341129BC84C71E40641AC25C78541412341C880E4C796E3064149C351092D41234192CE0B30C7E20641FF3FB5B811412341B20D147754E20641B6BC1868F6402341F4C246CC8FE106418DF297FED6402341961DE0762DE1064146DC9C0BBD40234182FB1572E6E00641B9DD49EAF23F234144E6BDAF0CE10641EB576738573F2341844C1CBEE1E1064182A19B60D13E23417EAC412B80E20641E174A57A9D3E2341101C3398F7E10641BE2C1E31593E2341844C1CBEE1E106419C0661EC5B3E2341C880E4C796E306415D1A167EF53D2341402E319D65E3064197FDE1E9A43D2341643BA3DFD2E306414A65EDD6AF3D2341D802D4397CE40641D0ED1F98C13D2341F892E2CC04E50641C96B2678E63D2341F8292A01C4E50641E50FEA9C083E2341148316CD2BE60641950A542C123E2341467B304DBFE606411082216B003E234162D41C1927E7064112EFC2C8013E2341B025236522E80641B73011710F3E2341D43295A78FE80641FE460C64293E2341D6839BF38AE90641EDB3ADC12A3E23415E04DE863AEB0641EF204F1F2C3E2341D89978DCC3EC064155F065F9413E2341EAD52666E5ED0641218F93AD6D3E2341ACEE5D0C8AEF06414148AF94693E2341A2D11FCA43F00641E7F69E9A783E23417CF23CF054F10641085871E64C3E234178A368A9EEF206415F87B7DBF63D2341AE554141BEF3064189513845163E2341D8301D7F0BF50641950A542C123E2341126059C6BFF506415B725F191D3E23418A5EACE789F60641DE8DF07C2D3E234148A979924EF7064119EBCF884B3E23417CF2995EDDF80641CAE53918553E2341B0EAB3DE70F906417FBAE662613E23416481FB1230FA0641723CE0823C3E2341F05012ED45FA06413A4CA2D41F3E23410EF9D2FF13F9064112EFC2C8013E234168D0CF5996F806419C8C4D4CED3D2341BA70AAECF7F7064133509514D63D23416202665EB6F706419590408CA33D2341045DFF0854F706413DE7E6F68A3D2341CAC40AF65EF70641AE4D4FB3553D2341E89A5A71ABF70641E1AE21FF293D2341229C0750E1F60641A9BEE3500D3D2341D8C764B3CAF5064149ACDB9DA93C234146C12B1294F50641011CCD0A213C23417A22FE5D68F506412FFBA5361A3C23415A4CAEE21BF50641CBD345C1DC3B2341D8301D7F0BF5064149606BC2A43B23419E98286C16F50641A78BBE77983B2341901639FA30F40641D56A97A3913B2341008D6308DFF306416075C3847E3B234194FC547556F30641967E4C352B3B234134EE3554B3F306413AC09ADD383B234194E4A2F510F5064106E5B4F1F53A2341706E78E762F50641A42AF6D9B93A2341F489094B73F506418D9B8A77713A23410C92EFCADFF406410D9551D63A3A23416469EC2462F40641A7C53AFC243A23417E43433C50F206413F8982C40D3A2341BCC153CA6AF10641A9F3DDC08E3923410EF975918BF1064104B28F18813923416A21793709F206417C42A859FF3823411AFE01548CF20641EB005AB1F1382341C02605FA09F30641AC140F438B382341B8727F8304F30641C8E6752C173823413457EE1FF4F20641BB686F4CF237234100F61BD41FF306410C16BC21C13723418EC532AE35F306418BA2E12289372341B68A31034AF10641634502176B3723413A0F7B329BF00641F36486BA31372341566635F96DEE064105A09BC108372341283C8574BAEE06412EF0088BB936234118E8246B53EF064117619D28713623410A94C461ECEF0641AA95798E113623410077861FA6F00641E385B73C2E3623414EC88C6BA1F10641023FD3232A362341780C21752FF20641AA95798E11362341780C21752FF2064137485CD4D6352341104A7CDD86F206412FA498AFB43523414A79B8243BF30641E09E023FBE352341D262B3832BF40641C767E0779D352341D2F9FAB7EAF406417EE4432782352341C20E537AC4F406414861A7D6663523412C3AB0DDADF30641D1FE315A523523415E32CA5D41F40641EE4AACE34C3523415A4CAEE21BF50641E339476129352341BCD730B3A3F40641498F4A9BD0342341DC7FF1C571F306415E370100A934234168B8C06BC8F20641CE9D69BC7334234164EA5670E8F10641A26647F55234234178A368A9EEF20641F580352823342341C8C6DF8C6BF20641E8022F48FE332341F0B96D4AFEF10641B012F199E13323416A21793709F20641A76E2D75BF33234144AB4E295BF206417722B3EBC4332341F487D745DEF2064186487030C2332341684F08A087F30641032DDFCCB133234110E1C31146F30641CE51F9E06E3323412AD1F7116DF40641CE51F9E06E332341D8301D7F0BF506418C5056B02E3323415A4CAEE21BF506414D640B42C8322341ECE92EB811F606416936722B54322341EE3A35040DF70641F0665B513E3223412EA19312E2F706410080A653CE31234168D0CF5996F80641ADEBA4808F312341F857734653F6064174FB66D272312341BAF114387EF506410830433813312341AE554141BEF30641BE32934789302341A4CF4A3337F5064132AE53C62D302341366DCB082DF60641D408ED70CB2F2341BAD962B838F70641F1DA535A572F2341D6C996B85FF80641D1A724D3EC2E23412ECF227B60F90641BDB3FD920F2E2341A2E7592105FB0641A9BFD652322D2341922A414C5DFC0641C6C67C27CD2C23410AFA3A18EAFC0641C6C67C27CD2C23413C29745225FD0641FDA541E7C22C23412EED24937FFE0641FDF70158952C2341046DBABCC600074100C7D5C73E2C234110A6B2A48A01074107C1FCC5EC2B2341F6306BFD20020741C86231B1042C23411A6C563B000307414AA69A87342C234106DA605F510407413BD1ED15392C2341F8E51263F5040741FC9B82393A2C2341F472BE11A70507418904669C1C2C2341105803337D060741006B56A9E32B23411697D41C930707418DFC9944AF2B234110F92C3D400807410E92C38BB12B2341FA0AB84236090741C806B292A92B234108A02F49550A074189A8E67DC12B2341EAFF9413E70A0741C86231B1042C2341E419EC704A0C074182855F472A2C2341F67D37E7120D074182339FD6572C2341C4627C08E90D0741C5419DD0882C2341D622479D0C0F07417B3978D8A92C2341B2888569F00F0741C91A30EEBA2C2341F6EADD899D1007413CB24C8BD82C2341D67B6FE48511074105AA2793F92C2341CCB274762E120741BB4F422A482D2341DECEBE29AD130741887270C06D2D2341B8D87DD735140741FE0B80B3A62D2341E2B110F5671407418551DCDFF12D2341BC5F50849514074176010FC53A2E2341D88C9668B5140741C113F36AA22E23419EBFB54E27150741B29AC517022F2341A44688FB8615074174EA3992472F2341A4A2071AE2150741398E61D37A2F2341DE27E7702616074178710C3FA72F2341CAACC6C76A1607417848AC06BE2F2341C0874C3BB8160741BF81FD8EF32F2341B293FE3E5C170741712525D026302341D4726A5EE01707412F73A6F450302341AC51D67D641807412BF692F5793023418EB13B48F61807412FF8854B95302341B4BBFAF57E190741B1644F5AAE302341886F1387FE1907412FA6C5DAC2302341BA9E4CC1391A0741B93FD5CDFB302341BE251F6E991A0741342D98872231234198D35EFDC61A074138B46A3482312341A2E10357861B0741741A02A1D7312341AA932992EA1B0741EFB504EA2B322341A29902943C1C07416DA5BAF96D322341C41CEF94651C0741ECBDD04199322341807295B16E1C074133F721CACE322341AE1AFC3E4A1C0741ECF0EF270B332341C41CEF94651C07412CFDFACB2033234188216415F11E0741A23A8BA0FE322341A023576B0C1F0741668233C3D632234190770A32FA1E0741279F8857AA32234188216415F11E07412B1C9C5681322341B2FAF632231F07412A6E5CC753322341A44EAAF9101F074165CA3486203223417AD196FA391F07412A12DDA8F83123419CB0021ABE1F074135E596C4D8312341A462285522200741789715A0AE31234174EBED579D200741F2D698CAA731234198CA597721210741746CC211AA312341727899064F210741746CC211AA3123416EA9C596A5210741298DFD51B431234194570526D3210741350EF7FCC13123416ADAF126FC210741EB05D204E3312341A45FD17D4022074174C8413005322341B0E0CA284E220741B080990D2D3223418238649B72220741754D2187493223417AE2BD7E692207417524C14E603223418A328B99202207412E704F1D6F3223416ADAF126FC210741B0DC182C88322341988258B4D721074166D4F333A9322341988258B4D721074166AB93FBBF322341988258B4D7210741E8175D0AD93223418607380B1C220741B138984AE3322341680B1EB752220741A9B991F5F032234174E89680BB220741B10F3812FA32234166F448845F23074133A56159FC322341A6CFCEF7AC230741A2112B681533234166AC47C115240741B1BD77A127332341A03127185A2407416B0906703633234186606052952407416BE0A5374D33234182918CE2EB24074130AD2DB1693323419299583A59250741E279B52A86332341801E38919D25074125B1135DA03323418CFBB05A062607416F3E18ACC3332341A2A12492C62507412134005EC9332341681C453B822507412D8C99D0ED33234186185F8F4B250741250D937BFB33234162221E3DD42507411E652CEE1F3423415E534ACD2A2607416C46E403313423419C037DB2732607415D48D7594C34234190DE0226C1260741A8D5DBA86F34234184A2B3661B280741DFDD00A14E3423419AA4A6BC36280741E7E1E64C853423415A7EC8AEBD2A07412A19457F9F342341464852F1692C0741A42F6871AF34234150B27669842D0741A5060839C63423417A8B0987B62D07412B9E24D6E33423416ADFBC4DA42D0741E8EBA5FA0D3523413CDBD6A16D2D074127F8B09E2335234156AC9D67322D0741E54532C34D3523414E56F74A292D0741588B8EEF983523415A7B71D7DB2C0741DD4B0BC59F35234154DDC9F7882D0741E1765E53A435234144E97BFB2C2E0741DA20B8369B35234178743454C32E07415F0A95448B352341405F5277EB2F0741E91EC5E07F35234160136B086B300741A6BE06767C3523415CA016B71C31074157DD4E606B3523414A81752CBC3107411CFC964A5A352341660A3B2F373207419E91C0915C352341469BCC891F3307415F85B5ED46352341406D222439350741A9647AAD3C3523411EE7DE4B2E37074163B0087C4B352341141EE4DDD6370741A93B1A7553352341141EE4DDD6370741A912BA3C6A3523411849376CDB37074167899B997D35234122CA3017E93707419E3F00218A3523415824BDDF283807411C8176A19E3523410C803CFE833807415FE1340CA2352341305FA81D0839074197979993AE35234148BD1A927E390741192DC3DAB0352341121B8D06F53907419EED3FB0B73523412223595E623A0741E57851A9BF352341142F0B62063B07415C64210DCB352341343FA311E13B07419B998CE9C9352341104962BF693C074124855C4DD535234132CC4EC0923C07419F9B7F3FE5352341084F3BC1BB3C07419B47CC78F735234100F994A4B23C0741155EEF6A073623410424E832B73C07419BF50B08253623410C7A8E4FC03C0741A77605B332362341227C81A5DB3C074160C293814136234104806751123D07419878F8084E3623413E0547A8563D07419CA34B97523623412C8A26FF9A3D074116E3CEC14B36234122C12B91433E0741A32252EC4436234136F44A77B53E0741DBD8B67351362341047D107A303F07419878F8084E362341105A8943993F0741E22E5D905A36234106918ED54140074164C486D75C36234106ED0DF49C4007411A0E2250503623412276D3F617410741D382105748362341FAB0BE34F741074125B87B334736234106EAB61CBB420741E257BDC843362341E41EC95848430741160C2FFA343623412656CEEAF04307411D62D5163E3623411CD5D43FE343074125B87B3347362341FC7C3BCDBE430741609933495836234108FE3478CC430741984F98D0643623411E0028CEE743074116910E5179362341222B7B5CEC430741559D19F58E362341147F2E23DA430741E3B33CE79E362341EA011B2403440741DB343692AC36234114372D609044074195A92499A4362341E0F01EF361450741D8E082CBBE3623411AD27D68014607411E6C94C4C6362341F2B0E987854607411E6C94C4C6362341DC66F56E2047074117ED8D6FD4362341DCC2748D7B47074161CC522FCA362341EC26C003444807411E6C94C4C6362341080C05251A49074117ED8D6FD43623410C93D7D179490741A0D85DD3DF362341ECC7E90D074A0741226E871AE236234100B307312F4B0741564B5984BC362341F04B65E3844C07416549662EA136234108AAD757FB4C0741263D5B8A8B362341FA11097AFA4D07419C518B2680362341D2A873D6344F074159C86C8393362341BA02009F744F0741E38ADCAEB5362341F8B23284BD4F07419580C460BB362341FCDD8512C24F0741D8B72293D5362341EA06E64AAB4F07419D84AA0CF2362341BE2D532D794F074113471A3814372341ECD5B9BA544F07411F9FB3AA38372341C46F7BEE704E0741DC1595074C372341E63A69B2E34D0741A10B7DB951372341E2B39605844D0741572CB8F95B372341C2FF7D74044D0741D142DBEB6B3723410A79ABC7A44C0741E0EE27257E372341F6458CE1324C07411CF93F7378372341CC6CF9C3004C07419D8E69BA7A372341E63DC089C54B0741A1B9BC487F372341D635F431584B07411026865798372341DAA84883A64A07419E3CA949A8372341E8401761A749074110FD251FAF372341F26591ED594907419E134911BF3723410CDBD894C34807419ABF954AD1372341F8A7B9AE5148074115D6B83CE137234106F886C9084807418FECDB2EF1372341DC1EF4ABD6470741DDCD934402382341D46CCE707247074150B77052F2372341FEE9E16F494707419A963512E83723411065021905470741500931C3C4372341EE3D953637470741D91D615FB9372341FE45618EA4470741D142DBEB6B3723410640888C524707419638C39D71372341FC31E33293460741107846C86A3723411803AAF857460741D142DBEB6B3723411AD27D680146074114A399566F3723410ACAB11094450741D56D2E7A70372341E0949FD4064507419A63162C7637234108B633B5824407419638C39D71372341205CA7EC4244074114A399566F372341EE2C6EB20744074153D804336E3723411CD5D43FE3430741920D700F6D372341F851E83EBA430741920D700F6D3723410EF85B767A43074153D804336E372341EC746F7551430741D9988108753723410646363B1643074153AFA4FA843723411EECA972D64207415B054B178E372341F63D6AE3A8420741E0C5C7EC94372341143A843772420741D51B6E099E372341F2B6973649420741CE9C67B4AB37234114DE041917420741182A6C03CF37234132DA1E6DE041074115D6B83CE137234120037FA5C9410741DDF6F37CEB372341F8543F169C410741DDF6F37CEB37234110FBB24D5C4107415F8C1DC4ED372341F89C40D9E540074150B77052F23723411E93812B5D4007418FECDB2EF1372341EE8E9B7F264007411C2C5F59EA372341F688C27DD43F074150B77052F237234104D98F988B3F074115AD5804F837234114295DB3423F074115AD5804F8372341FCCAEA3ECC3E074115AD5804F83723411EF257219A3E074115AD5804F83723411A6B85743A3E07419EC188A0EC37234112B95F39D63D0741D6A04D60E237234132844DFD483D07415FB57DFCD637234104806751123D07411C55BF91D337234114D0346CC93C0741D29E5A0AC73723412A76A8A3893C07415BB38AA6BB37234144476F694E3C0741142879ADB33723411E992FDA203C07415BDCEADEA437234144EBEF4AF33B07414F3291FBAD3723414AE51649A13B0741CE73077CC23723414EB4EAB84A3B07419ABF954AD13723412E00D227CB3A0741D9F40027D0372341247FD87CBD3A0741182A6C03CF37234146A6455F8B3A074192924F66B13723412EA45209703A074120FB32C99337234154F6127A423A0741960F6365883723410CC5E6E9EB39074118CEECE473372341566967CB90390741107846C86A37234156B1688EDA380741D9C1E1405E372341427E49A8683807411F7653724F3723413EF776FB08380741D9C1E1405E3723414C474416C03707411F4DF33966372341364551C0A43707411F2493017D3723413C3F78BE523707415B054B178E3723414C8F45D9093707411451D9E59C3723411E8B5F2DD336074157883718B73723411635B910CA360741182A6C03CF372341280C59D8E036074150B77052F23723415A3B92121C3707410D05F2761C382341221232DA32370741CEA62662343823413062FFF4E9360741901FFB14633823415E0A6682C53607418CCB474E753823415E0A6682C53607418CA2E7158C38234152E5EBF5123707410EE650ECBB3823414CEBC4F76437074198D12050C738234150BA98670E370741DB087F82E13823411A600C9FCE360741592195CA0C3923412485862B81360741D0E304F62E3923413A2BFA624136074192E1B8FFA139234156FCC028063607415383EDEAB93923413600A7D43C3607411481A1F42C3A234136A427B6E1350741CECC2FC33B3A2341321D55098235074115DD2013883A23415C9A68085935074188743DB0A53A234160C5BB965D35074103BE7F88273B234148C3C840423507414A203149463B234148C3C84042350741C1B9403C7F3B234148C3C840423507418686C8B59B3B234166BFE2940B35074147847CBF0E3C234162948F06073507414FDA22DC173C2341528CC3AE99340741CE77187B873C234168D6B7C7FE3307418B175A10843C234126F8DA7CCF350741C6F81126953C23412A232E0BD4350741C621725E7E3C2341501618866937074184A212691A3D23411EE7DE4B2E370741FB8DE2CC253D23415C5267450F360741C702D1D31D3D23414284F7562C34074102E488E92E3D23415EB494122E320741B8B203B9663D23416EBC606A9B320741F795AE24933D23415EB494122E3207410317A8CFA03D2341422BCF0FB3310741C0B6E9649D3D234132C78399EA30074108751A44173E23417077B67E33310741342F65775A3E23414A25F60D613107413406053F713E23415875C32818310741FDFDDF46923E23415875C328183107413CB82A7AD53E2341682110622A310741B3513A6D0E3F2341469E236101310741B72ACD8A403F23412CCD5C9B3C310741804B08CB4A3F2341687D8F8085310741FE8C7E4B5F3F2341527B9C2A6A310741BF57136F603F2341544A709A1331074180F9475A783F23414C984A5FAF3007413AF315B8B43F23413696570994300741364DA280F43F2341421751B4A1300741FF1B1D502C402341649A3DB5CA300741ECF2BC1743402341320F855C3430074134888DBED34023414A284DE5422F0741741978B92D412341682467390C2F0741EADBE7E44F41234174A560E4192F074136C56B52CE4123414C8723DB7F2D0741F714E0CC134223418823D864B72C074106CA1ED959422341085D828D5E2C0741FD9198C1B342234118AF2EAC272C074155388AB44D452341C4ED3B55722A07410088CD5EE04423412A13E8DC402607413C64C119B1452341D090022FD622074156B3240364462341D090022FD62207418F25B47066472341CAA498F47C1E07413D6B2CB8254923416E109D84EA1A0741C7A879DFB04923418672D6B1841907415E09F38A8B4A2341F253AA343310074177E426C49C4D234106CF448349110741454DCB8FAB4F2341FA26B34D10120741DABE7A3CCE512341FA26B34D101207414CA39917D35323419CBD2EC121110741BA271F08DD53234172F73B636E180741657762B26F532341C6BDF915F92007412A160946B55323417CCF0FD82021074186152985D5542341AC8637CC022507412F76A230B0552341B45940E5DF260741DFAAE476275623418C630B48B32407412D0C3EE3E15523411A7FEC6CAE22074115273F47FD54234134B6AEB6A41E074132E0067E7E55234134B6AEB6A41E074149C5051A635623415CACE353D1200741DE36B5C685582341A69ACD91A9200741C473222D315A2341685475890A20074190612CAA295B234114938232551E07411A9F79D1B45B2341405E40ECDD1D07418E7262AB715C23418E33C9083A1B074121EEDCBA675C2341B23D946B0D19074121EEDCBA675C23415E7CA11458170741AE958E2FC15C2341921A68E7BD18074100DCE637605D23416E109D84EA1A074158F607DB9B5D2341921F3343931F0741E2335502275E234138A218F1FD2207418EFE32FBCF5E23419CF706B845280741752A6A60335F234138D25A30772C0741255FACA6AA5F2341C6F206B147310741C770C268D25F23412E2F945613340741743BA0617B602341085040D7E3380741E80E893B38612341248CCD7CAF3B07415F4CD662C3612341E82C145394380741228118A93A62234162CD5A29793507419A39001FDC632341ACBB446751350741EFE9BC7449642341907FB7C185320741B5772D07476323417C041D736F310741D59A598B9663234134EBBB51F32E07419E1EFFBAC064234134EBBB51F32E07416053410138652341E61533359731074129D7E63062662341907FB7C185320741F0F02713BE672341A6CFDA2CF83007410CAAEF493F6823411AB4F907FD3207414BF04752DE68234150395FB9E63107414986E30410692341540EE8D5422F0741F550C1FDB8692341CAD9A58FCB2E07414A017E53266A234138D25A30772C0741F935C0999D6A23410434945D112B0741C13ECB7AB16A2341629D18EAFF2B0741A5009E92466B234138D25A30772C0741A77B38E15C6C234152091D7A6D28074170FFDD10876D2341705C8B3D36320741157B58207D6D2341E82C145394380741A2220A95D66D234114FD9C68F23E0741F0612373FD6E234110BA1FFAA73F0741278B3E8075702341562A944F153D074119EC270CC070234118E43B47763C07412981731DA27223410E11332E993A07411592A91EEA732341F0F6118B5D3A0741AEE9A70841752341F0ED06AA493A0741CBA26F3FC2752341064735F6CF380741F9DF4C86DD7623410A25C9F33F36074159C5BB0232772341C036DFB567360741870299494D78234136F9918EDC350741D4E707C6A178234178268975FF33074134CD7642F6782341227EF73FC6340741B8A9DADD367923415EEFC62B093807417BDE1C24AE7923415EEFC62B0938074129BDD212497A23412E1439B184380741546B3D155C7A23411AC2CF44E63907416385EED7277B23411AC2CF44E63907418E1A9A34977B234130124A3E043D07410EECEA6D487C234178E21F763A3D074183B5505B637E23419C7AD052FB3C07416B295315CB7E2341EC9AEDED463C07415B5B32E3E37E2341CCFA1A026B3C07415699C447257F234146FB44BF293A07413B2740A2547F2341564CEDD0B5360741372F62B16F7F2341B8E0A18448350741542A2A657A7F2341D4014841F432074135863895277F2341D074E69DF2310741451FFB8F9D7E2341D074E69DF2310741267B09C04A7E234114F3B3CFCD310741A4DA7C8C417E23413098D721B82F07414E0CE9C0617E2341B60711E26C2E0741A400A12AB97E234138827977FE2D07415D1718963E7F234156B4FE6CEA2C07412CBF6E02DB7F23413CDFB929432B07412BE592A0528023413C4729B1642907414A898470A5802341D671E46DBD2707418BEC5CD9E5802341204DF251DD2407418BEC5CD9E58023410478AD0E3623074181FF6EA82181234102BB2A7A771E07412244EDAB7D81234162DE1BFE3C1C074162CDE9B2358223410880DAB3DD19074112F772EDF6822341ACB929E25C190741A974275E06842341ACB929E25C190741FE8E0366D58423414CFEA7E5B81907418627AD9F7F8523414CFEA7E5B819074167CF030C1C8623414CFEA7E5B819074126DE977D428723418A62B2D09017074185E561B6D587234148D9B5C9D81607411C3DF2886D882341EA85A3545615074194F0908BB288234108B8284A421407419416B5292A892341EE7A747F791407417B6AE05F7889234150C3571F1F150741E143A300358A2341708D6D8DE9150741620A54D2B58A2341EE1205F857160741623078702D8B2341D2D5502D8F16074181D46940808B23412AA730D4EC170741C23742A9C08B23416A302DDBA4180741F9870843C58B2341447C75179419074130D8CEDCC98B2341E84D55BEF11A0741EAC821AAD78B2341849D02972A1C07410847EFDBB28B2341E87D76AFAE1E07410847EFDBB28B23415E196CC4D62007410847EFDBB28B23414669199D0F220741C7093B11EA8B2341669B9E92FB20074149AAC744F38B2341404F56560C2007414F7CC0AC1C8C234106488C1D791F0741C15D6647388C2341280773B6661F0741213F0CE2538C2341E87D76AFAE1E074190DF98155D8C2341666B7DA13E1D07414FA2E44A948C2341E8E5E536D01C0741D142717E9D8C2341A6F479A8F61D074186F2AAE4988C2341208540E8411F0741D142717E9D8C23416A906FBD1E200741AE838AE5AF8C2341620E3DEFF91F0741C755834DD98C23418040C2E4E51E07415E87EF81F98C234106488C1D791F07415E87EF81F98C2341E093D459682007415E87EF81F98C23419EA268CB8E2107415E87EF81F98C23413AF215A4C7220741679A0151358D2341E6AD97A06B220741FECB6D85558D23414669199D0F2207413F2F46EE958D2341E02B65D24622074130705F55A88D2341DC3694A723230741C7A1CB89C88D2341C0F9DFDC5A230741866417BFFF8D23419E3AF9436D2307410805A4F2088E23415C498DB5932407413F556A8C0D8E23417A13A3235E25074136687C5B498E2341DE5B86C30326074117EAAE296E8E23417EA004C75F2607413F7B8E2A858E2341DE5B86C303260741956F4694DC8E23415CE11D2E7226074186B05FFBEE8E2341D671E46DBD2707410D23E596218F23417E38953F3E280741A45451CB418F23415884DD7B2D290741F47610CD6F8F2341980DDA82E5290741D6F8429B948F2341004B8E4DAE290741045C1B04D58F23417A43C4141B290741A4A0990731902341BEC19146F6280741E503727071902341B83F5F78D128074103A86340C4902341BEC19146F62807418B1AE9DBF69023413C4729B1642907416C9C1BAA1B912341B83F5F78D1280741128D6E77299123413ABAC70D63280741A4ECE1432091234158EC4C034F270741DB3CA8DD249123415CE11D2E72260741E54FBAAC609123411EE582CABB260741227279AE8E912341186350FC96260741CCC9098126922341FA983A8ECC250741590E88848292234160D6EE58952507412BF7F75731932341DEC3F54A25240741364DC5F66A932341086306504C230741AB9BE5111F94234146395CC7E8210741C668E6F401952341820FB23E85200741D57716AC9E952341AC954F579B1F07416510CA18C4952341647EBB22471F0741C63B0CE5F9952341B8304234631F0741D69AF4FA1C9623410AFD9BEA751F0741CF13B0B536962341449310E7F81F07414B39CD7457962341D4DB0BF59720074117B8AD3C86962341B6F060B949210741AC640F418D962341E8D10F340E220741E9BDD2499B962341B696AC99392307414111714594962341A62C2196BC23074193DDCAFBA69623418641765A6E2407412203E8BAC79623417E8CB0D8AF2407419E28057AE896234122256445D524074141C1B8E60D97234114A4440D04250741D66D1AEB1497234100548CAE7D250741D0E6D5A52E972341840195DF54260741FA3F99AE3C972341AE2D7ED85A27074137995CB74A972341405CA64103280741B14BE3C866972341208BCEAAAB28074198C49E83809723415E07700238290741F9EFE04FB697234190E81E7DFC290741F4DB32B8D497234174E3A09CB72A07416A7A0B320F982341F890A9CD8E2B0741280D9A911F9823412E5885A35C2C0741280D9A911F98234104D2E78A462D0741D12C92432B982341A0B5D575AD2D07413258D40F61982341D29684F0712E074184242EC673982341029206102D2F07412D4426787F9823413673B58AF12F074142B7BC2584982341C4BBB09890300741562A53D388982341C0EC1772DB3007410E369DEDB2982341DC97E13210320741DB271463E6982341162E562F93320741D61366CB049923416045EA63E732074128E0BF8117992341DC3D2D1300340741E6724EE1279923414E9B7DE5503507411EB863525499234174E139834D3607413D76347E9A99234156F68E47FF36074109F51446C9992341F0D97C3266370741C273F50DF8992341380BE40BB13707411954FD5BEC992341CA390C75593807418F428E34AD9923418C63B6FDBC390741E5229682A19923416E780BC26E3A074137EFEF38B49923415A285363E83A074109F51446C999234146D89A04623B0741F06DD000E3992341E0BB88EFC83B0741423A2AB7F59923413288E2A5DB3B0741A8791A1B0D9A2341826E0F01E53B0741EF1D18A25C9A2341ACF4AC19FB3A0741A3884AD2A99A23416E780BC26E3A0741894AAF2CF99A2341C80BCB6D043A0741C93CBD174E9B2341C88D2AE6A2390741C9178288A59B234162AAC68D303907418FAC8FCBE89B2341C834C5EDE93807410339FE26119C234162CF011DD9380741094D646FED9C2341C834C5EDE938074110860547729D2341E23C64D5043907413C87BDC4A99D2341141E583208390741D6688DE0C89D23411421F61CA4360741BCF41F7DD59D2341148CE8D9603607415DE651A90E9E2341AEE06DDB3B360741C9B0D84A309E2341C6FF797E383607416392A8664F9E2341FA8349F24536074170B26C87839E2341AE3D92C431360741B6279268AE9E2341AE3D92C4313607413DF3D087079F234194A0E599D3350741B07F3FE32F9F23417ADEFDDFCC3507410388DECA4A9F2341FA4B6098F8350741500D66BC8F9F23412E730B2310360741C399D417B89F23417A5C9E672E360741038CE2020DA023411421F61CA43607416AE9E2AA1EA02341AE9359D24E390741908CBEC128A02341AE032C86E9390741A3CB8E8559A02341941C093D3A3A0741AB59BE1A85A023410A524398783A07413D6E7DF3E0A023414C61EE46E43A0741C0E411424AA12341F2B920730D3B074169F541FBB1A123412E7BC149303B07411023E09BC2A123410A524398783A0741F7D4D5C379A12341481E9D92E039074163163F024FA12341081AAB07BA380741F7D4D5C379A1234134A7A5D8443807419831970F97A12341528DD2D5F83707417F1C4767D6A123410A25642BFF3707417F1C4767D6A123419C44DC27A03707417F1C4767D6A12341F8F6621FBC360741D8EEA8C6C5A123412C2103703D360741BDF6C605AEA12341B8F27094953507411F96769A9CA1234130806B6520350741990603847EA1234150669862D43407412BE2072D52A123415A08520CBB340741B31B532C3FA123419C22B6DE6B340741481E5D4137A12341D04C562FED33074110EA256C3AA1234128AB2D556B3307411E8850F62CA12341ECE98C7E48330741D02C14B50BA12341DCF9C8FC18330741B138C113E8A0234126B1D24EC032074130A5BEDDD5A0234128B6E678B0320741EA41645DCCA02341F69CA445C931074168AE6127BAA0234196B285BDEE3007417C1D6906A0A023417AD711E47F300741AC67E4BEF4A023417CE2CA07C52F0741927D28A24CA12341524F2B3DE530074136CBA1AA30A22341EACD0B2F692F0741A9C0795650A22341CEF29755FA2E07414721CAC161A22341FCA6628BA92B07413B9C7EFF23A223414EB72FD9DE2A07410D0A01D40DA223410206CB808C2A0741764FF931D7A123410EB33D4EB82907413A8E585BB4A12341BCB3CE1D1D290741246753EF8FA123414C8A506C65280741C86DEC237CA1234194F86310B4270741C86DEC237CA12341AED97CE3772707412938304483A123412EB5818C4B2707419831970F97A1234142F9F4DF18270741CB94F18FA0A1234110DA0DB3DC2607411F96769A9CA12341D86C1CAE57260741746C671980A12341AA58EEA460250741F6FF694F92A12341BC536B4AD5240741B42979D0AEA12341AEB7569A43240741642465A6BEA12341A6205614A2230741035A2186B7A12341DA4AF664232307418F6449DA97A1234182B99AD8D6210741AD750A6364A123413E61F97B1221074131FAC4553DA223416C484818901F0741FBDE6C48F5A12341A6DC0982391D0741035A2186B7A12341D8FBF0AE751D0741C86DEC237CA12341B69FEE96EF1A07412A0D9CB86AA1234146BA5269A01A0741E1823CCC3CA12341D28BC08DF81907416BC740EF6EA02341B44530BDFC150741F8A6D4B736A02341DAC25D405216074184DC90972FA02341A8A376131616074103498E611DA023410EF8B6B41815074141230E00F59F23416246C18C611507411C5EDE09DE9F2341768A34E02E1507418F4590118E9F2341A460255F12150741734DAE50769F234108AAACDCCF140741E55FF4E33E9F23410CFE5BAE6D140741DF80F1EADB9E2341CAB07375EE12074167BA3CEAC89E23414EE027F05F120741CE2AC9D3AA9E23414EEBE013A511074116A7021C699E2341022FC3970D1207418B46B2B0579E2341286EB3904F110741F7B2AF7A459E2341B2346891621107412BEB756F369E23419659F4B7F310074107FBB1ED069E23413CB226E41C11074153735C16D19D23413CB226E41C11074162D8CC703B9D2341022FC3970D1207416C7A861A229D23417873C7BA3F1107414101E8B6C09C2341A43EFF15DE1107418C351F8CBD9C23414CB34883E60F07415AE0EAAF239D2341F41634D3540F0741E9111870289D23417EDDE8D3670F07412EA0067C4A9D2341F65F2A81AD0F0741A195DE276A9D23413426DF81C00F074184841D9F9D9D23411A946156AA0F0741CD0E7D8BCB9D2341DED2C07F870F0741E731F3D7FB9D234160F7BBD6B30F07412CC0E1E31D9E2341FA643EAB9D0F0741744A41D04B9E2341CEE2FCFD570F074181A4F806719E234122ED2452380F0741D3FBA5289E9E2341322C847B150F0741AB3A05527B9E234120F3C94B8D0E07415C0A5D9C729E2341A870889E470E07414FB0A5654D9E2341D2F86E45E20D074159525F0F349E2341DC9A28EFC80D07413191BE38119E234142EF6890CB0C0741AE28508E179E23414C91223AB20C0741B3F92CE30A9E2341741909E14C0C07418F34FDECF39D234186148686C10B074190096961DB9D23416A3912AD520B07412BB2BB3FAE9D23413C6EDA51B40A074110BAD97E969D234102B8F29ED6090741C25E9D3D759D23410A6051421209074129CF2927579D2341309F413B54080741BBAA2ED02A9D234104D409E0B5070741A25C24F8E19C23416A284A81B80607413A25523E889D23413A141C78C1050741740361FC539D23418C24E9C5F6040741B9C79CB7D39C2341BA3817CFED05074150747EB59A9C234126ECBF65D303074124C592A2DB9C23415A1660B654030741D0B5E7F36F9C2341504122A69F010741657F37D9DF9B23418AF709597D02074138312D01979B2341F6AAB2EF62000741FF804F66F19B23418EEF7EA9C8FF06412BAFB0DAF89B2341C06B00A197FF0641B450AA62DB9B23416868C6E3F6FE0641B3939D72A09B2341A4B5E9D47FFD064166B448CB5A9B234190EC914E12FB0641572256402D9B2341645CFDF6A5F90641DF0643D8D49A234142B927E5E3F706418DFCD3CB819A2341B65AE24137F60641C6506B374C9A23414A89F73856F50641B7BE78AC1E9A2341CEFFD65B2BF506417446FC2AF99923415276B67E00F506410692C1E8C09923419AA4CB751FF40641D55C387760992341E0BC65F547F206413205674EF5982341A84BDF9745F006414EAF3284DA9823416C03156C8FEF0641D6931F1C8298234114053474C1EC0641C7012D9154982341F4559122EBEB06414C3519A4649823414865981FA0EB06419E3F88B0B798234104300FAE3FEB0641A9636DC61299234132A3B41374EA0641763AF0BF55992341AE2CD5F09EEA06418F33BB70A39923419A5E24A55EEA064165B409A0CB9923413C84A6190AEB064190F0C760DE9923410037832881EC06414AC74A5A219A2341A45C059D2CED06413CAF71AF699A2341042BB6E86CED06413E298B8FDF9A234174D3E4BF01ED064114AAD9BE079B2341446C0C9AE1EC06413B788A0A489B234188A1950B42ED064158DF6230689B23413C7F4D5437ED0641C168830D939B2341446C0C9AE1EC064104E1FF8EB89B234120E6257A57ED064164C05436FE9B2341641BAFEBB7ED06411430FF09219C23412CC71780EDED0641F88533D43B9C23413C7F4D5437ED0641CE068203649C2341C0F52C770CED0641DD98748E919C2341042BB6E86CED06418D081F62B49C234148603F5ACDED0641899A11EDE19C2341F472801423EE06412B35D625129D23418C95C8CB2DEE0641EA367384629D23418C95C8CB2DEE0641B2E2DB18989D234118F96634ADED064188632A48C09D234188A1950B42ED064138D3D41BE39D2341641BAFEBB7ED064188203738FB9D2341D8B7108338EE0641D96D9954139E234138A8098683EE0641F6D4717A339E23415441316063EE0641A11902E9489E23412CC71780EDED06415F5E92575E9E2341CCD61E7DA2ED064143B4C621799E2341CCD61E7DA2ED0641CD12CD99969E23419C6F465782ED0641108B491BBC9E234120E6257A57ED064179146AF8E69E2341042BB6E86CED0641967B421E079F234188A1950B42ED064133EBECF1299F2341583ABDE521ED06411C6C3B21529F2341583ABDE521ED0641772076638A9F234120E6257A57ED064127902037AD9F2341E8918E0E8DED0641A3194114D89F2341504DFE9F77ED0641D8BCD7FA0AA02341641BAFEBB7ED0641CAE7F15F18A02341C4E95F37F8ED06414146F8D735A023415C2EF0A50DEE0641FF8A88464BA02341641BAFEBB7ED064109F2606C6BA02341641BAFEBB7ED064177A69BAEA3A0234194828711D8ED0641F32FBC8BCEA023412CC71780EDED064136A8380DF4A023412CC71780EDED0641915C734F2CA12341C4E95F37F8ED0641D4D4EFD051A12341C4E95F37F8ED064184449AA474A12341C4E95F37F8ED064192D68C2FA2A1234124DA583A43EE06419C3D6555C2A12341A457ACD759EF06415A82F5C3D7A12341FC5AE694FAEF06410AF29F97FAA1234170F7472C7BF00641D29D082C30A2234138A3B0C0B0F00641D35A151C6BA22341004F1955E6F00641D417220CA6A223414484A2C646F106419CC38AA0DBA2234128EB7AEC66F10641C4F11547F0A22341EC5E3AD876F00641625266B201A323419816D5F982EF06412A57E90C8DA3234166084CEAE0ED06417F2DDA8B70A32341607C048884EC064110429964CCA32341EE582BD021EB0641F25B6C6718A423414E4E037C41EB0641ED8A8F1225A423418C1A5D76A9EA0641BA2735921BA42341FE594D6FEBE90641F377B8AFF7A423413084EDBF6CE90641BC4381DAFAA4234124CCC1CEFBEA06415E75AE9AFFA42341629276CF0EEB0641840F4A05FEA4234174C077DB51EC06415FFBB3A5C7A42341E0172C0CDFEE06415FFBB3A5C7A42341644DEA46B9EF0641680BF50DE0A42341C6D1B45554F00641D254DE2EDDA42341D20A355D06F10641B5D50E22D3A423415640F397E0F10641A8E7B070D7A423419C01007B05F306411F1FF842D0A42341020311FF8BF40641DAA1891CB2A42341E45D74BD5AF506412C4AC07988A42341CA17FD06D0F606419EE054885AA423415A863B495CF80641ED19FD403FA42341A89292336AF90641959C8E1A21A423412C3940F921FA0641E4D536D305A42341F4BE1B8C43FC0641E744C577F7A32341E4C3EEDCA1FD0641224364910BA42341CA7D772617FF0641F0888BE530A42341DA333EA3B4000741E83BE0F75BA423417E8BDF94AB0107417436BD4498A4234116C8216935020741659C6669EEA423418CC45F9C5D0207411FA7841E43A523410250AE44A80207413DE9E9A590A52341F89374B2E1020741531B0EC5C5A523415C892E4C5A0307411C8318D007A6234112E853D7000407417D10C85E3EA623414A8E019DB80407415AB3DB0851A62341AE12CCAB53050741C38D36855CA6234130488AE62D060741A39FD8D360A62341889F2BD82407074156D5BEBF6DA6234162AF448F0A080741A0304A2F6FA62341688BB08F9C09074176C31C7169A62341E29345ADD20A0741C38D36855CA6234152C27F4EFD0B07413046AE4A4BA623418A682D14B50C07413046AE4A4BA62341A05DE7AD2D0D0741F2D8808C45A6234144B5889F240E0741EAC83F242DA62341E89B3A063E0F0741CFB8FEBB14A62341768D32D3DE0F074104E2650CE1A52341669205243D110741F28D5E368FA52341AED0587C4D1307416FA3C2516BA52341A891655F7214074176F06D3F40A5234180A17E16581507417BCE8A8823A5234144AA13348E160741C62916F824A52341146FE2E38A1707412E04717430A5234120A862EB3C1807414914B2DC48A52341FAB77BA222190741CDFE4DC16CA52341D2C79459081A07411F6A1A9986A52341DE001561BA1A0741127CBCE78AA52341245132B9011C07418AB303BA83A52341B2422A86A21C074147A5233857A52341B81E9686341E0741B8A1F5C318A52341E0C9169D4A200741D88F537514A523412C5927126D20074148B759DFF4A42341DAF22D8BB12107418A68E163CDA42341001883AC4023074102A02836C6A42341789AECD4EF230741A5DE5F49D5A42341263DD8CDCF240741A0004300F2A423419474F7EE9525074103FD80331AA523414CD31C7A3C260741F13006393BA523418E3504D2BA260741DAECAB7268A52341460519E83E270741983B24EE8FA52341FC6C23F380270741F8C8D37CC6A52341A818F46BFC2707415956830BFDA5234154C4C4E47728074172F735CF23A623418299FCADBF2807417BA139BA4CA62341CCB71D980429074193A829FB62A6234118D63E82492907411802548478A62341665C6A77D0290741635DDFF379A62341869C6E18322A0741BEAF193C79A6234168D9B0ECBB2A074199E39E419AA6234120C7E6EC842B0741CF032112CBA623415E1D775AF52A0741760E3FC71FA72341BA36C5F3DB290741B1CF735B77A7234116DF2302E528074193D8302AE0A72341488B44DDC5270741E5CB89DD6CA8234138D57D60282607418635F5CE9AA823417E05694AA42507412D401384EFA82341D0627D51C4240741B83AF0D02BA92341C4B80DBF342407419A43AD9F94A923410CCBD7BE6B23074166DDDBC90BAA234134BBBE07862207417AA071444FAA23417CEBA9F1012207418E6307BF92AA234190D40CA16C2107412F90082B04AB23416C35E37464200741AE9C87C644AB23415E8B73E2D41F0741948361DE90AB2341D0997B15341F0741A6D768B4E2AB2341A23E1857651E07417C2DD17020AC2341366F0341E11D0741BCCC224E5BAC2341F49B2C5E851D0741D08FB8C89EAC2341A032C16C571D0741311D6857D5AC2341FE5766F04B1D0741ADBA584E24AD2341F40C1CE9621D0741B7C1B436A1AD2341CA2EFF9F7F1D07414991C94C25AE234128C593AE511D0741DE47E02B28AE2341EC50E2569C1D0741FB88B88139AE2341508B20FDA31E0741E67DDD9849AE23418A6D1B61931E0741F62EC2695FAE23418835EC03971E0741077C3E6973AE2341F4AEA177B01E07414DF5F3DC8CAE2341F0489A76D81E07411548EB509CAE234180A10C5FE31E07410063B367AFAE2341EAE29275001F0741FEAF2F67C3AE23419A86E22D491F0741B1EB3A09E5AE23419620DB2C711F0741BFB7E7F00DAF2341FAFB5942B61F074115B0CD4C3CAF234188EEC429E91F0741B4D4EC1C70AF2341405E23E4E11F0741E5517ED5AEAF2341006261438E1F0741CE870E03D5AF2341E2168473501F07411501C476EEAF2341F0489A76D81E074100EAD7A400B02341F814A978881E0741E9511CBB27B023414C9F31641B1E074180A618FF2CB02341DC4B544E101E0741AFBFDB454AB023419CFBE1ABD21D0741745F4FB96DB0234182160CDD6C1D0741807878A0AAB023412835746DB31C07418C5FED9EE6B02341A84647E52C1C07411952588619B123416CB08C45B11B07415B3352105AB12341C6D84B8F181B074141D12654A7B12341F4831706BA1A0741143D47AFF3B123418C706993781A07412024BCAD2FB2234104E405AD1D1A074165CF250A4AB223412AFBF17E0B1A0741BE7A8F6664B223415440B6F4D4190741CA93B84DA1B22341C84D4B0DA21907411743AA31C5B223412ED0598C87190741CD48193AD6B22341CCA2E148FF180741E7088EF5A4B22341A6EC27F90D180741EFC82DD88FB22341E05A93EC4C170741014998C481B22341647F8D08611707413352D6905CB223413C361A468D170741DCED503017B22341A4ECD1AAD5170741EEED2509FBB123412611CCC6E91707419D52FFCCCFB12341D47E8FF309180741EFE43BA0AFB1234102C8AE524E18074133EE796C8AB12341E410CEB19218074156EE231E52B1234146354943FB180741FD925DFF3BB123413CECFEBC9A18074168EEF8F635B12341E21078635A180741712E2EED2EB1234158A3890F1E180741385C66D51DB123414C11A19FCD1707415865CFC814B123413836C4F754170741E44969C713B12341F8C87F55E0160741A3B701CD17B12341C636C20CAC1607413E25C5F937B12341EE7F35CF7F16074115DC261048B12341E836419757160741B8891F3361B123413AC97D6A37160741D0D2E8436DB123410A37C021031607412AAE447691B12341FCA4D7B1B215074119AE6F9DADB123414E371485921507416BC92BEDE6B123411A5CB8526E150741F3B6842D15B223410ECACFE21D150741D9F60F7246B223416E81AE9830140741FA7F0E794BB2234150CACDF774140741EC767A5E38B223416212F12C0B160741AA647D502EB22341E05A93EC4C1707413352D6905CB2234132EDCFBF2C170741516429ED9EB2234154ED4E4AD816074129FF7C3B8FB32341F41245909A150741A55AED0B6DB32341CEA5D3DB60140741FF35493E91B32341345D5E2EE413074153C8B0388DB3234122CBC92123130741935A183389B32341001566206A12074110361E1775B32341C839B49F0D120741E9632BD847B323415A3935156212074160F63C840BB323417014680B1313074161ED521BC0B22341905E021FB1110741FD5A416FFCB22341E483F8647310074157B6078E12B323411EF26358B20F0741362D09870DB32341546079FDB80E07413C76FDBE35B32341AE851BE0EB0D07416C8825F45BB32341F4856F437B0D0741F02CB5237EB323412CF4DA36BA0C074194DAAD4697B3234182CFB5F3890C0741ADA30C6BB1B3234140627151150C07410F3F0880C0B323410CD05DBAA80B0741705A6E81C1B32341CC621918340B074147913A84C3B32341BA873C70BB0A07410EBF726CB2B32341B03EF2E95A0A07414048464C9BB323419A1A7758F209074158910F5DA7B32341E26369A571090741705A6E81C1B32341261B1F1F11090741EEB50979BBB323414C6492E1E4080741DC359F8CC9B32341C0F64D3F70080741359165ABDFB32341C0F64D3F70080741862C8CE70AB42341F61B1B49BF0707412B5A1A1E32B423415AD34F4D0A070741AFFEA94D54B42341EE658A35410607416AF56B8179B42341F0F843A823050741A3C733998AB4234154B078AC6E040741BE87D37B75B42341681E0FC7C9030741176304877DB423412AFA680E4503074183BECAA593B423418868A9DA6702074125F5171EEAB42341FCFA6438F30107414B47754909B523411C45FF4B91000741B1594730F7B423417AB33F18B4FF06415135F7C5AAB42341DEFD2D8FE1FD0641943E0A6B69B42341DA47F3C99BFC0641347E414C0BB52341C22322EAFAFB06418519688836B523410624764D8AFB0641B52B90BD5CB52341DCDAAC3C7EFB0641930FD84375B62341A2FFA46DE9FA06410534FD86A5B623415A496C934CFA0641B7EA89C4D1B623415000220DECF906419CAA7FF5F4B623413CDCA67B83F90641BBBCD25137B72341CEDB27F1D7F90641AE8E4606B9B72341ACDBA8662CFA064120B36B49E9B72341D4241C2900FA06419E0E0741E3B723413CDCA67B83F90641E30E5BA472B723411EB87F4DAAF80641E6059C6243B72341826FB451F5F706418933FF714EB72341CCB8A69E74F70641462AECCC8FB72341C46FB2664CF7064161C56857F3B723411A727DA8E3F30641E17BA13190B823414CBA1F6825F506417D69FA71BEB82341D2DE6FD271F506416229F0A2E1B823411296CFFDD8F406414BE02692D5B823410697A0006BF3064192BB82C4F9B823412EE013C33EF306413FA9B0DD0BB9234174E06726CEF20641C33132450EBA23418A717F938CF4064111D617C368BA2341C64C876221F50641E90C0FED86BA23414A043BF117F406411C8DF86324BA23418ABB9A1C7FF306413C1FE1D374BA23413050A231F6EF0641ADC3700397BA23414807D73541EF0641EDDE577AECBA2341882BD33CFEEF06414443DDDA31BB2341C452153AACEB0641E0B0CB2E6EBB2341B4E7C600EBE706410DCCB2A5C3BB2341D00EE0C125E406419739A1F9FFBB234110EC5C8419E106416F7098231EBC2341DEA3BAC4D7DF0641BF8B294C3BBC2341C8C887CE26DF06418442B68967BC2341A85BC2B65DDE064161C276C491BC234192808FC0ACDD064147020209C3BC2341EAA5DB54A7DC06419254340DC6BC2341F8CA7D37DADB06412D428D4DF4BC234116825ED895DB064130577F3402BD234110CCF63489DB0641E0F8198B20BD234110396AA06DDB064189F26C6A32BD2341DEB1B78F59DB0641781D8EC14BBD2341D421DF3844DB06417824F9C25FBD23410C022E8B19DB06417A36D46D62BD2341069E15DABEDA0641695A8AC367BD234192D6E47709DA064162FC3DC57FBD2341A0927D74D9D90641565DF01CA1BD2341A4A2911444D906415340A5C8AFBD2341046F3EB17ED8064151235A74BEBD23417A875CA19ED70641458F7C75CEBD23418E6FB54329D7064147A8C221E5BD2341C4335890AED606413080072405BE2341E8F3F53459D606411FA0B8D12FBE2341F6AF8E3129D606411954477E4ABE23410024BB82EED50641076D8D2A61BE23414278362689D50641F8A9892C7DBE23415EF0671F29D50641FBD4AA8396BE2341A044E3C2C3D40641E06BEEDBBFBE2341F49C630E39D40641E5B35A87CABE23410885BCB0C3D30641CC67E933E5BE23410CB17C567ED30641C1DA763609BF23411C6D15534ED30641B97C2A3821BF2341760D024ACED206417CA89D8A2ABF2341B098DE3C53D2064159AEAC8947BF2341AAD1DEFC9FD106411D650EA057BF2341E23F4AF0DED0064156B76BCB76BF2341161BA62203D1064113AE5826B8BF234178893C3D5ED00641F96D4E57DBBF234196896579D1CF06416A12DE86FDBF23410EAF309877CE0641D5ED0E9205C0234144D4FDA1C6CD064161523EA412C02341006763B119CD0641C56DCFCC2FC02341EC8B8609A1CC06419BA49BCF31C023418867B52900CC0641EBBF2CF84EC02341F267DE6573CB064198AD5A1161C023416E43E4495FCB06414EDBBD206CC02341321F3E91DACA064178A4F11D6AC023417C68862C92CA0641FBC8EB397EC02341CA44883A2CC906417EEDE55592C0234120D71A5C44C9064155A4476CA2C023417E455B2867C80641CE08777EAFC02341A48ECEEA3AC80641B7BFAD6DA3C023411C21E096FEC70641D8C84188B6C023414021B56FE2C70641FF1A9FB3D5C0234174FC10A206C8064117E4FDD7EFC02341808EF91157C8064147F6250D16C12341DC69806B97C806418048833835C12341D6208C336FC80641EC23B4433DC123419E45DAB212C806418908231B20C12341BCFCBA53CEC706417AFF8E000DC12341BCFCBA53CEC706411ADB3E96C0C023415AD83FC265C706417C763AABCFC0234144FD0CCCB4C60641F65AFFD0EAC02341ACB4971E38C60641C35196DDF3C0234174D9E59DDBC5064191C8C2FD0AC12341BE22D8EA5AC50641C25A80463FC1234142DA8B7951C4064157FFE44E45C123412CB610E8E8C306413776E64740C123411ADB334070C30641E0EC3D8F73C1234192B6E3D523C306419F5AD69477C123413492BE92F3C206415E48D9866DC123418624FB65D3C206411276116F5CC12341C6DB5A913AC20641A81A767762C12341A025A14149C106415508A49074C1234116B8B2ED0CC106417591A29779C12341E2259F56A0C00641C8A3747E67C1234112027828C7BF0641AE636AAF8AC12341C84BE9FFF1BE0641D82C9EAC88C12341E64B123C65BE064102F6D1A986C12341724CBA0284BD064102F6D1A986C123419ADF9E9C82BC0641EF7567BD94C123419A7202C12CBB06417314AE47C5C1234194413333CDBA0641988AEB51D0C123414C105C8FE8B90641B0DCA3F0D0C12341563E8FC2DBB90641E8B21E85DDC12341080A5C8FD4B80641C99699191FC223419694999927B90641637F14AE1FC22341B093EB5128B90641B0EF285C23C22341B044E17AFAB8064166B865614FC22341A2007B1833B9064163F529E367C223419406E384D9B80641BDD085158CC22341142B8752B5B806414BB54A3BA7C22341EE2AB279D1B80641507EA95FC1C2234122502935E8B70641DFD919309FC223412E2C2D2E2BB706412FF5AA58BCC22341F6507BADCEB60641FEEB6C8CE1C22341C408D9ED8CB50641B9E22EC006C32341E69B11EB1AB40641E1F5285C37C323410E3B0AD7FDB106410A04D7A353C323419E4CB81E8DB00641E593C2F555C32341680852B86EB00641AE80EB5156C32341A49A703D66B0064120EA51B86EC3234182C1CCCC20AE0641C248E1FA5BC32341E0FAFFFFE5AD064196FA28DC7CC32341C2558FC2A7AC0641C91B856B7DC32341A6B6703DA2AC06413C84142E7EC32341620785EB91AC064170EE5138A2C32341744A66667EA906411F3A3333B4C3234198DFFFFF29A906419C969999B5C3234152F6A37023A906415EB647E1A4C3234106445C8FF0A80641BF5E66E6A8C32341D49847E16EA8064130696666DAC323414A6CC2F586A80641563E0A57CFC32341E4E0285C65A806417319AE47B6C323415AF3AD4719A8064138F028DCDAC323413A3185EBD9A606413850C6A6EFC32341B445F44E2AA60641373C0AD7FBC323410A10295CC3A50641411BAE4707C423416C3D0AD779A50641F1AB703D15C4234148ACF52820A50641FBF8FF7F32C4234110F07A14B8A4064115FAFF7F65C42341A2F17A1400A50641D8EF51B86AC42341FEA2C2F50EA50641DBB51E858AC423414A240AD769A506410EDB7A94AFC4234162478FC2D3A5064198D2A370EDC423413A93703D7EA6064123F351B8FDC42341620F0000ACA6064134773D0A1CC52341942EB81E01A70641906E3D8A3BC5234142B21E8559A70641F915AE4743C52341301033336FA70641299D70BD4CC523417E768FC289A706419D1885EBA2C52341D6921E8567A80641033B0AD7EEC52341DACE47E12AA90641624EE17AF4C523418A17295C39A90641DCD97A1419C62341DAB21E8597A90641710BAEC724C62341B4AB9999B5A9064128608F4229C6234130D91E85CDA9064174588FC26FC623411213D7A36EAA0641DB50B89ED4C623415870C2F56CAB0641727B617E27C723416610B567ACA90641B38D5E8C31C72341C634DAAADCA90641C4961DCE60C72341D07D24313DAA06419F9648F57CC72341407D261CE6AA064112571114DBC62341B2560B7002AE064130205C8FDAC62341FAEFA3708DAE0641EAC3CCCCCCC623416E9D1E8587AE064108EF51B86FC62341FCDD285C5FAE064148D5CC4C07C6234198B51E858DB006410F693D0AE5C52341022ED7A344B1064138CECCCC58C5234134513D0A4FB4064145FCFFFF51C5234146C851B874B406417492C2F53CC52341ACCE1E85E9B40641C51885EBA8C5234180E9FFFFAFB50641EB0BAE47B0C52341024BE17AC2B50641614DE601F3C523412EFCEA926AB606413473C98DC2C523416074CFED6CB80641B90E6F5499C523412C9973BB48B80641512A7F0762C523417099C71ED8B70641C63CFB9F17C52341DA99F05A4BB70641A82AA843D5C42341CE0708EBFAB60641FA35D9EECEC42341D829AB5824B7064155E8106677C4234198C9F6D4A2B90641878D9B1C00C42341E605383426BD06417726DEE3BEC3234150D746EBFFBE064139BEF98505C32341EC1743B552C4064194BD75DEC0C2234174EAB63D82C60641AAC9DCA379C22341C822832D9DC80641C9FDCE52D6C223418257185A2DC90641E7E33625B9C22341C6F30D3D32CA0641BA309ADCBAC2234170C371274FCB0641937031FDADC22341C25D9D67A8CB064140FD2BD5A2C223417A5E210FEDCB06415D964FC672C22341989213BE49CC0641D03BBBA60CC22341C25D9D67A8CB06414FC8D454F0C1234102600A8887CC0641207BAF49CCC1234144FCFF6A8CCD0641BD3A75ABA5C12341B864A61C68CE0641DB212379EFC12341C0CCC826FFCE0641652180FBBBC12341200328F63AD006414D2D069763C12341FC9A24C292CF06419779C6D031C123413E9D91E271D00641A6933F2860C123419A3968EF87D10641B412EAC101C123418271B0375ED3064142B836CCACC02341103C976389D20641531EAE0987C023410271EEE33BD30641C3DD92414FC02341904071A447D40641682B5BCAA6C0234102DC01B6F6D406418FEBC3A9B3C0234108DD28DB6ED50641F71DECB564C023416AAD106DD0D6064162EA9C843BC0234140E286C371D706417F83C0750BC02341D47E1F24AAD806416A7613B5EBBF234112E7038263D90641E1C2B418CBBF2341DAEA591BDDDA06417E35369991BF23410EBCA67E94DC0641059C50549FBF23412EF0982DF1DC06415DB5450489BF2341B457F9E365DD064176A8796D7ABF23419EBEB61CA7DD0641E6675EA542BF234194271F22A5DE0641B8677D7B31BF2341C8F45398C0DE06415D67BB270FBF23416A5C957846DF0641755AEF9000BF2341562A4E96A6DF06419A80CFADE7BE234140910BCFE7DF064166407639D2BE2341E02B370F41E006411F4D61A6CFBE2341B22C9CE096E0064140CD513BD8BE23418AFB9AF95DE106411F4D61A6CFBE2341FCC9B8E813E20641054D807CBEBE2341D064A67C8FE2064150E684979FBE234156CC063304E30641B57F6ADC91BE2341E267786EC4E306419B7F89B280BE2341A036965D7AE40641740C65B486BE2341D86A6936E8E4064155D9B80091BE23412C05957641E50641F4E5C2437DBE234160D2C9EC5CE5064192A588A556BE23419438037E59E506414325B7E63CBE2341AA6BCE073EE50641EABE7D5540BE23413E044F7BDAE4064117721A9E3EBE23416C03EAA984E40641964B782D35BE234196CE7353E3E306412925D6BC2BBE2341C6679744B3E3064174BEDAD70CBE2341B034CCBACEE30641B4E355239EBD234116B9B5B670DB0641900974EC62BD23416686CB569DDB06415595FCB725BD23413AD68E18E9DB06415F030C9427BD2341EE957C9A24DC06416B9B51CA28BD23413E799FA063DC06415F030C9427BD234140E334652ADD0641100BB08421BD23418E0B4413D4DD0641CEAA99AB1CBD23418298CF2BD0DE06418B4A83D217BD23419A7DA5FA35DF0641C21254751BBD234108A24E1792DF0641E5DA24181FBD23415C68942310E00641100BB08421BD2341BCAF3394A1E00641C21254751BBD2341EE79DF316DE10641CEAA99AB1CBD2341B60205B91BE2064148EA6CF912BD2341F06AE7B4BBE206418FB08AD3EFBC2341D251704C48E30641CCF54E49B9BC2341CC3AACACFBE3064100BC6C2396BC2341446721ECF2E406418EFB3F718CBC234152521015CDE50641A62BCBDD8EBC234162202244E6E606419A9385A78DBC23419C88044086E70641967AE60C79BC234136B113EE2FE806419EF98CA865BC2341D435D3E390E8064139E891FE4ABC23413CFECBB835E9064180AEAFD827BC23410687F13FE4E906415AE42B6DFDBB234168B1B3B6B4EA064140B2ED37D4BB2341E0DD28F6ABEB064105D17DFABBBB234154277B2F64EC06410E502496A8BB234186F126CD2FED0641A40E9E7F8BBB2341180372DB8CEE0641061EE6607FBB2341E46EBA687AEF064112B62B9780BB2341721670B210F00641815DB9AE75BB2341729DE27098F006410F9D8CFC6BBB2341960312A411F1064123B478CE59BB23410EA9142581F106419DF34B1C50BB2341BE4C64DDC9F1064186C3C0AF4DBB23414273C0C24CF206417A2B7B794CBB234140FA3281D4F20641B523D78852BB2341FE01FFA36FF30641E05362F554BB23416C26A8C0CBF306419DF34B1C50BB2341ECF0535E97F406419DF34B1C50BB23417E7B2CAE6CF50641E05362F554BB234190493EDD85F6064171ACD4DD5FBB23414257235A95F706413BE4033B5CBB2341C8E71404DFF806412F4CBE045BBB234172DE35E1A1FA0641477C49715DBB2341B0B0ADA108FC0641477C49715DBB234112DB6F18D9FC0641ECEBA72B56BB2341E6E4EE039BFD06412F4CBE045BBB2341A2732DE5BDFE06415B9335434BBB234168C8B1D25E0007411101E1341DBB2341781D36C0FF010741EE4FFC6307BB234142A65B47AE0207412A7ED407E3BA234100AE276A49030741F71B0B66B7BA23412E95B001D60307413CE075776DBA2341267EEC618904074122AE374244BA2341CAA0E2B5BE0407412A2DDEDD30BA23412A610F68C80407416772A253FAB92341068252F3D60407411DE04D45CCB923419E23EFE2F8040741EA7D84A3A0B9234164C9F1636805074161A4B85682B92341882F2197E10507411B2B03E368B9234130BCACAFDD06074186B9F15F49B923412C0F7ED4570807419AD0DD3137B923412015972ECC0807411D8F571B1AB923415ED92972230907417C850062F9B82341A61E161A8E0907412FDA0CB9B6B82341CA84454D070A07415F878BF87EB8234186A9EE69630A0741FFDB974F3CB8234122B5201E4C0B07415ED240961BB82341BEC052D2340C074123F1D05803B8234192CAD1BDF60C0741B2479078E7B72341D015D7BFD50D0741FD264DEDD8B72341C8FE1220890E0741D95E7C4AD5B723411CC5582C070F0741C345DDAFC0B723417A936A5B20100741744D81A0BAB72341229983B594100741CBC4834BADB7234104077F0BA91107413A6C1163A2B72341048EF1C9301207412ABB2C928CB72341AC930A24A5120741FC71028B75B723419618CA1906130741F85863F060B72341741C30AB5313074104F1A82662B723415EA1EFA0B41307413BB979C965B72341CC4C0B7C98140741A1E160456EB72341DA37FAA472150741D8A931E871B72341A2C01F2C2116074104F1A82662B72341F40DD8F62617074100D8098C4DB723413E53C49E911707418396837530B72341F8776DBBED170741E6A5CB5624B7234106DCE92540180741EE2472F210B723410ABF0C2C7F18074159B3606FF1B623415AA22F32BE18074166980E0CB6B62341DEC88B174119074154AF6981B0B623418C50F89E4B190741E284C81481B62341E08AA5B7D11907412D1ECD2F62B623414E8CAD065B1A07417EF7499547B62341B859A4D0981A07412937008C29B62341EE596624BB1A0741A183A1EF08B62341A6F4728E251B07416750141202B62341005D3816F01B0741E776B6820BB6234174C5DEC7CB1C074123F64146BEB523412EFA73F45B1D07412B83FE71D5B5234180652A444A1F0741FD821D48C4B5234102997975731F0741FC35D966B1B52341A467B63A1820074184E93703D2B52341F09E5B05BB2107411A1D8734FBB52341126DD6763D220741751D49881DB62341F0A273F256230741DD50B78F35B623413CD600D05D230741C350D66524B62341A47482A93025074184EA7DFE38B623410A0E68EE22250741A46A6E9341B62341B8AAE1786C260741C0B7939E65B62341B8AAE1786C260741E13784336EB6234156450DB9C52607410B5198B946B6234118E14048A82707413BEB01A67DB62341CCB667EC1D2B0741B484E7EA6FB6234170B8318FC92B07413BEB01A67DB623418A56B3689C2D07411E52DEB4ADB62341C88B0AE94E2E07414C52BFDEBEB62341248E58333F2F074101B9BAC3DDB62341A6C1A764682F0741EF05FFA4F0B62341B48C50E4B52E07415B6D7E3154B723415EBE131F112E07417807E81D8BB72341E4298CC2213007410255CF7CD1B72341F2F84C2F0B3107413F22E51CFEB7234186FCE07462320741973BDACCE7B7234180CCE7DCB2330741B7BC105D57B8234172FD2670C9320741BAB91E0577B82341D67EC2F5E23307419F9E999986B82341F4A2703DCE3307414F6166E687B82341B2F2FFFFC53507411F03000084B823416C4FB81EFF350741CFFCFF7F8AB82341443D3333BB370741FEDC7A9493B823411C3085EB79390741509E703D94B823419C5C8FC2D73907417D78142E96B82341F44D0AD7EF3A0741EC08D72372B823419639E17A3A3D0741C3D4A37067B82341A0FC51B8E83D07417289EBD127B823410E929999FB400741A7410AD70DB82341EE97703DD4420741792A5C8FFFB72341C81785EB854407418245E1FAEFB723416614AE474B450741C20BD7A36CB8234166A647E1404507419D9C9919D7B8234186CAF5282C450741BFEA51B8F9B82341FEB047E12445074136C9CCCC83B92341AE498FC2074507412D5D8FC201BA2341F4C8A370E34407419DCCCC4C82BA2341A41EAE47D1440741DE5B8FC2F9BA2341F26614AEA74407411FB41E056CBB2341CC9D47E1AC440741290DD7A302BC2341121D5C8F884407413E87EB511BBC2341528F703D404207419F2E5C0F33BC2341E8933D0A9D420741FE4FE17A40BC234102FAD6A30C4307412FD6A3F048BC2341E2903D0A53430741D880EBD1B0BC234188FA51B8B246074155B51E85D3BC2341B651B81E5F4807414605D7A3D1BC23410AEC7A148848074123A7703DDBBC234172125C8F104A07410B6F66E6DFBC23413CD9285CCF4A07419A295C0FF8BC23414ABC1E857F4A07419B305C8F48BD2341B6A29999654A07411350B81E65BD2341B6A29999654A07418D13AE47DBBD234122753D0AC34A074147A5476105BE234122F0285CD94A074149BEF52843BE2341A691EB517A4A074119B01E8567BE2341F48399994B4A0741BCBAF5289ABE2341F48399994B4A0741A77314AEDDBE2341FE9314AE174A0741271DAE47F7BE234112A6F528224A0741014DE1FA35BF23410E8B99999D490741988014AE69BF2341B4EC7A142049074139F228DCF0BF234186325C8FAC4707417A7B142E25C02341880A52B8444707414183EB5148C02341CC27D7A340470741DE6A6666B5C023410CEDD6A372450741FB0CD7A301C123418A8314AEA744074119AE476155C12341ECC047E116440741DC93EBD152C223415AA8B81E63430741481A5C8F5AC22341CCE31E85B543074186C447E15DC223419E681E850B4407411988C2F574C223418477B81EA544074135F1FF7F8BC22341F07D3D0AF544074199893D0A99C22341521300002E4507417F0FD723CFC2234140ACEB51C84507414D4E8FC2E3C2234128063333E74507417E78C275F4C22341D8973333FF4507417CB099195BC3234196427B14AC460741050B856BA2C32341D0ABF528244707414BAD9919A6C32341E2EAFFFF2947074124A7C2F5B8C32341867A703D48470741ABC647E1C9C32341D02F295C85470741C0E8A3F0CCC32341DE57EB5190470741FC1085EBF5C32341CE6C3D0A07480741AE4D0AD708C42341F2A47A143048074148AFF5281CC42341B0913D0A61480741EA8AC2F550C4234160CBC2F5F64807413E32E17A9CC42341EA25EB5162480741229C47E183C42341966E33338B47074173EFA3709EC4234154C614AE97460741106C3D0AB0C42341FC18D7A3F6450741790A0080C7C42341E44E99997D45074137263333ECC42341C45DE17AF64407416110AEC745C52341B83CC2F51846074186CF7A94DAC523413C2C14AEC5450741B9C51E053CC6234190758FC25B45074164AE9919C9C62341A6E9E07A26450741A3D2F5A808C7234190EECCCC0E450741A3C8CC4C21C72341D2340AD7EB4407412F44E17AD4C62341BE93B81E0D44074177AB1E85E6C62341C48A6666FA410741A2FBEE79F2C623412EB58476D1410741930919EC7AC72341FA1751AEFF3F0741D404295C8DC723410E33C2F5C03F07415B6614AEA0C723417677EB51AC3F0741F3AB47E1BCC72341F8A351B8DA3F0741E73F5C8FF0C7234142B414AE853F0741C4C0476142C8234122171F853D3F07419B3FE17A9EC8234130BD99999F3C0741837C142E06C92341BA1B7B144E3B074191D6A0F817C92341908CD361F63A07415B663D8A52C92341AEAB14AED53907416E5F3D8A94C92341DC506666963807419507D72394C923413E8F3D0A67380741E3470AD7CCC92341FEA647E18A36074158C2CC4C32CA234128D8FFFF2B3607415F1F5C8F7CCA23411646295CC3340741057EEB51AFCA234172D8703DB2330741BFC0A3F004CB2341FCF07A147E3207417CFBD62330CB2341FE7247E1163107419AE07A1415CB23418E1033330330074180E8A3F0CDCA2341E2783D0A7D2E074116A0999987CA234192540000022D0741D8DF51B814CA2341F051B81EED2B07412197C275FDC923411AAFF528842B0741C0C6F5281CCA2341406D3D0A3D290741276D66E62DCA23418C4BB81E7F280741686E3D8A4FCA2341765C0AD7EB26074129A7476178CA23413CD8285C41250741BE2D5C8FBECA23412E0AD7A3D8230741C2FAFF7FFDCA234106A6EB51942207411D8CEBD139CB2341C88C703D5A210741AFE47A1462CB23410437AE477B200741585F8FC26BCB23411CFEFFFFE91E0741537D142E6CCB23416CC2703DD81E0741CAA1999972CB23411C86703D7A1D07416884EB51EACB23416CEA285C091E0741EC628F4229CC2341C09AEB516A1E0741F041E1FAA2CC2341F40ED7A30C1F074111C4F528F5CC2341887F14AE7F1F074177F8FFFF6CCD23413E9614AEB31E074112DCA370CFCD234162423333211E0741C1B81E85DBCD2341821B5C8F0A1E07412E7DEBD133CE2341CA6DB81E8D1D0741B489EB5134CE23413CBF47E1061E07418D12AEC738CE2341EC7F9999DB1E07415E6A666647CE2341E26A14AEFD1E07412EE07A9453CE23414ABAF5281E1F07411147E1FA53CE234190BD1E855D1F07412319856B56CE2341A6D451B8941F0741B18EC27567CE234190AA47E1D81F074133F8FFFF7ECE2341AA919999232007412CB047618ACE2341563485EB3B200741FC3C0A5795CE234178BCF5284C2007419280EB51A2CE23418CAEC2F5842007418984EBD1A8CE2341FCD7285CBB2007419C568F42ABCE2341A4B6CCCC02210741AF1985EBA1CE2341DEA4703D64210741C4A7703D9CCE2341B0433333A52107417FAE47E19FCE23419ABD703DEE21074193343333A7CE2341EAD51E850B22074148F35138B6CE234122390AD7232207410DB91E05C4CE2341B6007B143422074186636666D1CE23418073666666220741EFB247E1F1CE2341F428D7A352230741F7BDF528F7CE23419C4F0AD7A3230741DA245C8FF7CE2341442EAE47EB230741BF56B89EFBCE2341D86214AE032407417C11D72304CF2341F0F5FFFF012407414C9E99190FCF23411A12D7A3F623074138AD47E11ACF2341D06D8FC2F1230741D0D2CC4C2ACF234164FEAD47052407419F40E17A43CF2341784C3333392407415416AE4751CF2341B012AE475724074111BA1E055BCF234118628FC277240741EB2485EB61CF2341A239E17AA8240741E046E1FA65CF234106B9A370B5240741B0D3A3F070CF2341EA0052B8B824074151F528DC79CF23414C8014AEC52407413345E17A7BCF234118D27A14F6240741462E33B37CCF23418A5F8FC26D2507416D7714AE7ACF2341FA6BB81E1D26074152A970BD7ECF234182E751B8522607413D1B856B84CF2341C27614AE79260741F00EAEC78FCF2341D098C2F59E260741B79F703DA1CF23418A0052B8DC26074139E47A14A7CF23414A3CE17A2A27074176F728DCAFCF2341F29814AE732707411E245C0FBECF2341187AEB51A0270741F06466E6CDCF234182C9CCCCC02707419086EBD1D6CF2341E003295C032807417DC3F528E0CF2341846614AE832807413154B89EF1CF2341D8E7A370E32807418C8BC2F509D0234168335C8F2C29074155B91E8521D023415CC21E855329074112743D0A2AD02341D89314AE5F290741EB13AE472DD02341845B666676290741F5C3F5A82BD02341F27A6666AA290741125D8F422BD023418E5D14AECF290741E0350A5731D023413052B81EDB290741AA8214AE3AD0234172A5C2F5D22907418A2D333343D023416CD5A370BF2907418CCACC4C49D023410A56E17AB2290741534CE1FA4ED02341549E703DBC290741340EAE4756D023410636E17AE6290741FD2C5C0F62D0234164703D0A292A074118215C8F68D02341303FE17A562A0741D6E37A1464D023414431AE478F2A0741F493C27562D02341F6C81E85B92A0741E9B51E8566D023410E3C0AD7EB2A0741779A991980D02341EEE0285C512B0741299D703D97D023414C1B85EB932B0741E7578FC29FD0234152EBA370A72B07416C94C2F5ADD0234162F6FFFF9B2B07413C3833B3B7D0234122FFAD479F2B0741432C3333BED02341CC45E17ABC2B07410B979919C5D02341A635E17A0A2C0741D32F5C8FC9D02341BC8366663E2C0741C06C66E6D2D02341B8636666722C07418FE27A14DFD02341C68514AE972C0741BC5A8F4207D12341A62A3333FD2C074183BDF5281BD123413CC87A14582D074136C8CC4C25D1234196BD703DD02D0741408FC27522D12341FAEC51B8242E074183D4A3F019D123419C9F1E855D2E07418D84EB5118D12341FA7DC2F5A42E0741AA1D85EB17D123412EA4703D6A2F07418CD0A37013D12341BCEF285CB32F0741D0E07A940ED12341A09947E1E82F0741C619856B11D1234110B8F52818300741550600001ED12341FA04AE474D3107417AAA47E122D12341089214AEEF3107415D285C0F22D12341A2330AD715320741790DAEC71CD123417EE751B834320741C602D7A312D12341C6AEC2F544320741E4BA1E0504D12341E836333355320741142E5C0FF9D02341BE1A5C8F603207416945E1FAF2D02341DCC5F5287C3207411C2A5C8FF2D02341A8F051B8A43207411EDEA370F7D0234110403333C5320741D1D1CCCC02D12341BC0785EBDB320741663B0A571AD12341C4D7A370EF3207411005D7A32ED1234124FBAD4701330741E091999939D12341D66DB81E2D330741C6608FC243D1234154D4CCCC843307418267666647D1234108ADF528AE33074104E851B85DD12341BC23AE47A5330741BBD5A370C1D12341323333331B340741A7A0999909D223410CF3A37083320741A207D723A8D223413C3085EB07300741A16C3D0AF2D22341049B703DFA2E0741550EAE475FD3234122305C8F582D07413C9940D2D3D32341D253A37EAB2E07413D9940D84FD4234184FE4D61E22F07414799404C95D42341AAFE4D59E43007413D9940C0DAD423417EFE4DD9213207414B99407AFDD4234136A9F8331D3307413C9940A865D52341B6FE4DF9943007419FEE95A13CD6234186FE4D19FE3307413B99408C71D62341C0FE4D2975340741E643EB26CED62341D453A3FEDE340741F443EBEAEBD6234188FE4D0902360741429940D8CAD62341B8FE4D79C8360741F643EBFEE1D623412AA9F8239C370741B0CACCCCC9D6234180A299990D3907418F50B89E7BD623418E6C14AEED390741FF1A85EBFBD5234134D47A14363B07411988EBD19ED52341825AB81E1B3C0741A302000048D5234100AE703D683D0741F6598F426BD52341AC7E14AE8D3D074176E07A1469D52341A6696666AA3D0741265C8FC263D5234130DAA370CB3D07412CA6703DFFD42341160F00007E410741146E3D8AAAD42341FC53E17ACA4407419799991976D423410CA947E1DC460741ABC2F5A83CD423419A98EB515A4707413A80EB5102D42341F01052B8C84707410647E1FA3AD423413AB6F528A2470741AF275C8F3FD42341824D3D0A9F4707410143E1FA3DD423414452E17A704B0741AECFA3F03DD423415E446666844B0741AA80142E08D42341844DE17A4E4B074176C3CC4CB7D323418A6414AE274B0741BCB21E85EAD22341A6F4D6A3584B0741D5DC7A14E1D22341C6BF47E1504B0741B19A99196BD223415A1BD7A3F04A074105AF47E158D223411CE77A14C04A074196763D0A17D22341B033E17A104A07410ED7A370E0D123415C54B81EFB490741DAB9F5281AD22341A6EFD6A3944B0741AFB51E0557D22341A2C851B8444D0741FED2A370C4D2234130D4CCCC004E0741A18BC2F5B1D323415AD6CCCC504F0741E4F8285C49D42341DC1B0AD70D500741378AC2F5D0D42341B6E051B8B65007412E53B81E32D523418A5EE17A30510741E3D87A946FD523414AFBA3707D510741AEE97A14CAD52341A0435C8FF65107414774142E31D623416860E17A80520741E513AE47D8D623414CB2703DFC530741BB6B3D0A57D723415C60EB51945507411FEE77A4BDD72341B4EE2865E05507418E7177C723D82341F81B2941BB550741227621F6ABD823413E0E2BB522540741FAA7CB000FD92341C8682B6DD8530741B57ACB2434D92341C8682B6DD8530741AE71208581D923417A91811A2B530741D0BE742C5ADA2341DCE22D75D0510741B5CE1E12D9DA23413E982EE53B510741F20BC9D332DB2341E651D9832F510741F7C7C8896ADB2341AA9384B6B3500741DE241E5964DB23412C44DBF7964F0741EBE9C8AE4EDB23418E9587523C4E0741689873964BDB234104008932134D0741A6BCC8D273DB234118B589A27E4C074101591D7B0BDC234168163725454A0741C9119AFA1DDC2341D45725F3A5490741829992545BDC2341028F5385A24807412F9C10DB01DD234146D076BECC46074166B874BC50DD234140057462F345074162E14BCB73DD23414C8AEE358A450741A8A9D0A0A6DD2341846348153D4507411D13342BBFDD23416E3CA2F4EF4407416131C9FAE3DD234174F086A12B44074196A33DD624DE2341B654EE1EF7420741482D671E38DE2341CA87BAD4474207410963B15A2FDE2341F01097848A410741482D671E38DE2341CC6A095B284107418B4BFCED5CDE2341DEC019551A410741CDBFA1B773DE2341E66E6B37D4400741C86BC2AB57DE2341F6CA0EFC474007410B0DA1603DDE234112A699C9D03F074192CC14E547DE23411E2B149D673F07410C8A577B7CDE234148858673053F07417B72A20EAADE23416289E84FB13E0741C3E416EAEADE2341325EE052B83E0741B28E06F0F8DE23414C62422F643E0741FC2DB4B608DF234176BCB405023E0741F302ACB90FDF2341521627DC9F3D074167BC8C7398DF23414691AC08093E0741166F8DCACEDF234158E12938793E0741902CD06003E02341488B193E873E0741BF9AE25F98E0234126D9657F213F07418878EBB3C7E0234128D3D2B49F3F0741B7EC907DDEE02341F2F3E50A6B400741C742A177D0E02341F4E7BF7567410741C3EEC16BB4E02341B46014B4FA410741083A9026A8E02341E48589E6714207413D2F4EE7A9E02341BA2B1710D44207414D081643D6E02341260F03578C4307410F454A2615E12341089A7B8ECD430741F0CFC25D56E12341C4BC9B7054430741ED9BD49E82E12341EE72FED6744207412252B3DCB5E123414AD29430B1410741B8F25E17F0E123412C5D0D68F241074105B6E89F3AE223414AD29430B14107412E1E83896BE22341D6DA5E7D094107413C458469B1E2234194FD7E5F9040074119C35156DBE22341D0E78DF00D400741627930940EE323415C617ADF783F07416B9386293DE32341FA0E13F9403F07419908CC5D85E32341FA0E13F9403F0741CAB1FF50A1E32341BEB3E1C5B03F074131DD655793E3234130AB177958400741036820234BE323419AF04FEC8B410741F6401F4305E3234130C1009700430741F13374F8EDE22341D6F0479BB1430741D1E52FA4EBE22341FA58A0F06B44074160A07308CBE223419E6A2C394245074164D461C79EE22341449A733DF3450741EF81FAE066E22341A45DFDC53D46074151A0B59C41E223418877535B6C4607412911D83E54E22341981C2228DC4607419A5694DA74E22341981C2228DC460741D5191E63BFE22341E6ABFF85C9460741EC26C9ADD6E223412A89DFA342470741882F5166B8E22341CE29494A064807413738D91E9AE2234156E40886F84807415FC7B67C87E22341BC9A639B3E4A07415FC7B67C87E22341E202BCF0F84A07417F15FBD089E22341066B1446B34B07419A5694DA74E223414C1D0A354D4D0741BDD8C6ED4AE22341CEFAE101EC4F074100A93D5523E223410497E6810351074170153D6500E223411C2F86DB6E52074170153D6500E22341222257686A530741BCFF096207E223414E7D804A205507414D930A522AE22341F21DEAF0E3550741E233B68C64E22341F08E0C93F655074114B6A60BC4E22341D4A8622825560741B6A4969A00E32341648642469E560741AE63FD9015E32341A8F2FFC104570741545F986A69E32341706CE45F955807410D8276B879E32341BA3C950A0A5A0741545F986A69E323410E306697055B074174ADDCBE6BE3234166D0CF3DC95B0741CAB1FF50A1E32341D8C705F1705C0741635F56D6F2E3234108E25B869F5C0741B62F8BA954E42341DE2BF91F7F5D074197BA03E195E42341D2EA1D821D5E07410C0D6BC7CDE42341266DCC6C065F074151B69EBAE9E42341CA0D3613CA5F07419DA06BB7F0E42341C05B38D3556007417D522763EEE42341C64E096051610741F6D87C08FAE423413A463F13F961074163EA4AE546E523411842DAEC4C620741A3933C44ECE52341403910A0F4620741465BE95E6CE6234182871260806307416782EA3EB2E62341526DBCCA516307410E7E851806E72341BE7121F1FD620741B54574C7FCE62341D016F0BD6D63074174D02E93B4E62341D8989EA8566407415E6894A983E623410842D29B72640741619C826857E62341887AE3EC7B64074114D9F8DF0CE62341AC535EE448650741C3E18098EEE52341809DFB7D286607415CB61A92FCE5234144B3ECECAA6607413834E87E26E6234126CD4282D966074181EAC6BC59E62341C2EBFD3DB4660741FF7DC7AC7CE62341B2462F7144660741DBFB9499A6E62341B2462F7144660741F73C2EA391E62341D6AE87C6FE6607413A0DA50A6AE623418E839D971F680741C9C7E86E49E62341B2EBF5ECD9680741E83C703708E62341086EA4D7C2690741529CC4FCCDE52341CA839546456A0741B5BA7FB8A8E523414A4B84F53B6A0741D42F078167E523411E0644312E6B0741357505B1FEE42341B8F4AF977D6C07417438D1CDBFE423413E209275826D07416F2B2683A8E42341C44B7453876E07410B34AE3B8AE4234184D287641C6F074114419B1A18E423413CA79D353D700741C67D1192CDE32341FEBC8EA4BF700741BD63BBFC9EE32341629ED3E8E47007418BE1CA7D3FE32341CEA2380F917007413D1E41F5F4E22341FEBC8EA4BF7007417CE10C12B6E22341F40A91644B710741C2E5713862E2234198ABFA0A0F720741B4BE70581CE223412A18B88675720741B3E5B3CCD8E123417A36734250720741D25A3B9597E1234198ABFA0A0F720741ED9BD49E82E123416802C717F3710741101E07B258E12341D695099C8C7107419BCB9FCB20E123414E8010DC2F7307411C5FE24FBAE0234160CAA5243576074144EEBFADA7E0234142551E5C767607416FA42214C8DF2341CA542EFE2A7207413815874A51DF23415CAB025CE96F074193741DA48DDE2341948C5742C36B07414DE5C36E8DDD2341F6230F8FBD6607416C5A4B374CDD234170F82CB1B8650741CF7806F326DD23413A01EFAC3667074159269F0CEFDC2341C47ADB9BA1660741EDED8DBBE5DC2341C2EBFD3DB46607413D0C4977C0DC2341B2462F7144660741789B26D5ADDC23414642CA4A9866074172B5BEFE52DC23413EC01B60AF650741D4FABC2EEADB2341BA2317E097640741CAE06699BBDB2341822CD9DB15660741822A885B88DB2341F0303E02C2650741E955EE617ADB23415283A5E8F9650741E87C31D636DB23413E4FF9BD9C650741895EB8AED2DA23414A90D45BFE640741EED7A49D3DDA23410E617564BE6A07410333D6D0CDD923418890CC0A24670741869FD5E0AAD92341E26085067366074122A85D998CD923415283A5E8F9650741B66F4C4883D923410265EA2C1F66074139DC4B5860D923413872114F496707418CFA48A8B1D82341DCCD2A8F4A6D0741AB6FD07070D823418CC558F117700741A07CBD4FFED72341C86A171CD37407415CD3895CE2D72341803F2DEDF375074153B933C7B3D7234152FAEC28E676074101E9FEF351D72341503BC0756D78074144B9755B2AD72341503BC0756D7807411F5E86BC10D723419ECA9DD35A7807415AED631AFED623412E375B4FC178074116443027E2D62341B6F11A8BB37907410D2ADA91B3D62341503BC0756D780741113785DCCAD62341189FBBF5557707413185C930CDD62341F23663A09B760741C980A69E97D6234140C640FE8876074198D772AB7BD6234160CAA52435760741C473FB5380D62341A866B2F526750741081D2F479CD623415673E1682B740741235EC85087D623411296014BB273074142D34F1946D623413ABD8653E572074145073ED819D623415CC1EB7991720741AD32A4DE0BD6234138E87082C4710741F91C71DB12D62341F27BB3065E7107414F21946D48D623417443A2B5547107414F21946D48D623410AFE6942217007412792B60F5BD62341B67BBB57386F0741074472BB58D62341742DB997AC6E074196FEB51F38D62341F4F4A746A36E0741D18D937D25D62341742DB997AC6E0741B13F4F2923D6234100A7A586176E07418DE45F8A09D6234100A7A586176E0741A825F993F4D52341F4F4A746A36E07413CEDE742EBD52341E8B3CCA8416F0741572E814CD6D52341ACC9BD17C46F07414021D601BFD523413E367B932A7007412AB93B188ED52341E2D6E439EE700741BCA76D3B41D523412425E7F979710741AA73C110E4D42341AA50C9D77E72074115D315D6A9D4234100625520557307419F80AEEF71D4234118E40B5C1872074113FA584A66D4234144294C20267107410FEDADFF4ED4234192B8297E137107417618140641D423416C50D1285970074101C6AC1F09D423412A02CF68CD6F074104FA9ADEDCD32341FA589B75B16F0741236F22A79BD323410AFE694221700741D277AA5F7DD323410C8D47A00E700741CD6AFF1466D323417891ACC6BA6F07419CC1CB214AD32341665D009C5D6F07412AA352FAE5D22341DAE313ADF26F074171A7B72092D22341506A27BE87700741AC36957E7FD223413E367B932A700741B4772E886AD223412873F10AE06F0741688D618B63D223412873F10AE06F0741A31C3FE950D223418CC558F117700741E243EB5E3BD22341F853A37CA770074190EE953C37D223412AA9F8E7C670074199EE95AD3ED223418EFE4D0D0971074198EE95A343D22341A4FE4D31767107413F99401A33D22341E653A36AAE7107414999409F30D22341F653A33E43720741E643EBA1DAD123412CA9F8D7CA720741014B6A73B6D12341B684076786720741574ECCBF88D12341BAF60CDD83720741A46D232060D12341A4A58FED46720741389A5C7745D1234192AFB5D2BD7107418E9DBEC317D12341A245A51B4E7107415FD2993CEDD02341E678FCD09C710741C90DE6B0C9D023415877CBAAB37107419C933E19DCD023412411D1CA9F7207414528AA9EE5D023419A9807BCFD7207411E79CDC85DD02341B472ECC28173074150657AD648D02341209FCB54A2720741B5C68EA603D023417251B0B137720741A5A019E8C2CF234104CA2D4B637307413049D85FE1CF234180235484B774074166DFC7A871CF23413E674942AB750741CE91596869CF2341A86AAB8E7D750741F210947212CF2341345AC110627607419312C598FBCE2341227B4997227607415198709EABCE2341CA2DE27E417707416568289891CE23417AED0298A97707419654D5A57CCE234196D902433277074182ECA27758CE23418A6C903FF0760741930358B63FCE234166973EAB27760741F0017A2DF4CD23419267FDCC34770741314CD9BEC7CD23410806965FDC77074178C1408197CD2341026B13A49078074116A23CBE5DCD23417809AC36387907415EB6519D5ACD23410EEDE8DA9D7907417E2486773BCD2341AA4B70CE427A0741794A4ED319CD234106E25F17D379074101A28F5BFBCC2341608FB101AD7907416E96DE8AD6CC23412657C7D9A279074161296C8794CC2341B6A180303B7A0741B473CB1868CC23414A1070CFDC78074104D53286C0CB23417A6EDD05767B07418CA366BC1FCC2341ACF929CE2F7D07414A2912C2CFCB234156ECA19CE67D074180577C3F9ECB23413E72A7675B7E07419333E8F91FCB2341F8C74D11657C0741E16766BDB9CA2341CC5C76ECFA7D0741796E2A565ECA2341BE5435B8F67F07415E0B38FD57CA234174865B475C8007417473178EDECA2341C89D71732F82074134B2C54E8DCA234126C20FD14B8307414561485F50CA2341CE8B0A5AB484074198132DBCE5C923415E0488F3DF85074141F225BA8EC92341620FF2A6E9850741A200AA985BC9234164B590CAB48A07419D54241657C923413C64535A498F0741C828E942C2C823418494B413CB8E07410F39C2BFD7C7234176D459EB828E074101E54742DCC723410EE686E215890741BB21864F45C5234102657D17088D0741A591F7819FC5234150831C7B1793074193459F13BFC523415212EC2C1F960741B231CA6D7BC52341ECF13933F4970741D0B1141DEBC423418001E9F24A990741D4A9F20DD0C4234122D1F2DAE99A0741D55D9A9FEFC4234182403A50859D0741BD1DF5C737C52341B44F54B1FC9F0741A0E571FF9AC52341DE6EB230AAA207417F69B8D738C62341CECD8BCA50A70741617D8D7D7CC623410ACD610D92A9074171CD76736AC6234190CC3750D3AB074183ADEE36FEC52341220C48C9ABAC0741CBB9362C06C52341F45B9C60BAAD0741027A26B32DC42341864B2E85C5AF07413F9A434E79C32341A2AA31DC2AB207412B527C67A6C32341F409A0D4B0B50741FF35F05368C423415408B7FB53BB0741E8F1B9F4A2C42341A6B7A348A7BD0741BF1964402AC52341AC1612412DC10741E8F1B9F4A2C42341FAA5E1F234C40741255E2FFECEC32341E0647DFFDEC7074163C61380EDC22341DED32F169BCB074168BEF170D2C22341B2B2535FB1CF0741488AFF2F43C3234124021398E0D10741F9896AD163C423413821DCB8AED50741B07D22DC5BC52341CEBF5A2A0DDA07415F811E058AC6234172CEB56FE6DF07412DB90C6F47C7234142DD3A727EE307411C215C9286C72341DCBC887853E507410F39C2BFD7C72341205C9C4891E80741CF4647A440C823411ABB9E3A47E90741ED623F248CC823419E4DF3BEB9E90741259144FB1CC92341EEB16A6902EA074192C98D3297C9234154FEDB61AFE907411B72438603CA23410262A39844E907415B4248274FCA2341709F029613E907419C42FBCC81CA234106A867971AE80741AA1629D4A0CA2341E0F0605980E7074102DC362B0ECB2341805EA5263FE607411D3D69BC4CCB23417AF9CA0371E50741DE6020148FCB23413E05FDB089E40741D442FF41A0CB234180FE5BAE4EE40741AE043698C4CB23410024E9B9A5E30741EF4B12BBF6CB23418828FD0E9FE20741234D4B5015CC23414C3076BB0CE20741A43F6EE835CC2341EC27366257E10741ADE9711552CC2341C6528AC488E00741AB5B8709D4CC2341E63D924361E107418B2795C844CD2341EC0D318ADFE107416EEF1100A8CD23418A0D9C2B00E307415F0B09B506CE2341985CC60550E60741140352470CCF23413CBB9F9FF6EA0741E7E6C533CECF2341786AF78D6AEE0741B962EAFC50D02341EED9D361E5EF07418B92B657F3D02341C44945943FF00741AACD18060ED22341549F8CA198ED074167A8A6B853D2234124C9BABB8DEE0741367F49D158D2234176CD4F989FEE07418F2F5E69BFD22341CA0B673369EF07411D3AB87D1FD32341C42F249B05F007418B54129288D32341741535D1DAEF074191F4858150D423417C0C2625F8F1074199333E28CDD42341983B41F800F60741123C9D3126D523419ACA6F58ACF70741123C9D3126D5234124E36B3579F40741E7F6A55376D523417C0C2625F8F10741D1C8ABBFABD5234108B4506270F00741916CB79716D6234142FF867753EF074120A310353AD62341D0A6B1B4CBED074160FF045DCFD523410AF2E7C9AEEC0741A79AB12BE1D52341EAF5062FBCEA0741A683B4E1FBD52341960AE4A67BE907416627C0B966D62341B2E8678117E80741B601252FF5D62341960AE4A67BE90741A0D32A9B2AD723412074777CB5EB0741D140DDD571D72341D0A6B1B4CBED0741EE9692C6D3D7234142FF867753EF07417DCDEB63F7D7234120C50E7522F1074183F5A6C08ED8234158D2AD22C7F30741D2B80EEC37D92341CC2A83E54EF507419A9BD26A1FDA2341CC2A83E54EF5074143FAE664DADA23415A61DC8272F50741EF86F5F25FDB234196AC129855F40741BD1943B818DB234104E78A9A86F2074105B5EF862ADB2341B6575C3ADBF007417CA651469EDB234198EAA9FF93F00741283360D423DC23415A10458A05F007413D4A5D1E09DC23410496F3A119ED0741CC80B6BB2CDC23412074777CB5EB074184E509ED1ADC2341AE1BA2B92DEA074170CE0CA335DC2341CAF92594C9E80741E7BF6E62A9DC2341B47796E1C2E90741BC7A7784F9DC23417CBB8E2C8BEC07417D1E835C64DD23412203A6DC60ED0741F73DDFAFA2DD2341B0AAD019D9EB0741D9D02C755BDD2341960AE4A67BE907417D1E835C64DD234192EC86E624E60741F73DDFAFA2DD2341905D588679E40741127D97561FDE23415ADFE73880E30741D320A32E8ADE2341ECE2069E8DE107418B85F65F78DE23415C1D7FA0BEDF0741CCF8E7D1F2DD234158FF21E067DC074129AB91EAE9DD23410085D0F77BD907411ABC4FFD9BDE23413CD0060D5FD80741371205EEFDDE234104C3675FBAD50741B01A64F756DF2341ECB1A94C08D507416FA77285DCDF2341023439FF0ED40741A01425C023E02341AC481677CED207414CA1334EA9E023411E12BDD9AAD207410B2E42DC2EE123411E12BDD9AAD20741B092950D1DE123415AEC214F39D30741864D9E2F6DE1234172FDDF61EBD30741A9CB0E7D66E223413A41D8ACB3D60741FF55FD38C6E123410085D0F77BD90741785E5C421FE22341E4A64C1DE0DA0741613062AE54E2234158FF21E067DC0741785E5C421FE22341269F0E53C5DE0741B7BA506AB4E12341E4F7E3154DE00741AF7B98C337E123415850B9D8D4E1074161B830988EE0234142CE2926CEE20741E8AFD18E35E0234196B94CAE0EE407410506877F97E0234198487B0EBAE5074169F7E83E0BE123417ADBC8D372E50741FF55FD38C6E12341CC37BDFB07E50741BDE20BC74BE2234124F0A54B32E407417E86179FB6E22341AECA0AC1C0E40741A9CB0E7D66E223413E9092BE8FE60741FD3E00EFE0E12341608C735982E807418436A1E587E1234126D06BA44AEB0741AF7B98C337E12341745F9A04F6EC0741864D9E2F6DE123415881162A5AEE07415B08A751BDE1234176EEC864A1EE0741FF55FD38C6E1234108B4506270F00741E0E84AFE7EE123410A437FC21BF2074185B67166F4E123415EBF3CB38CF3074144400E9C3CE22341E4FADBC294F30741FFC255D257E22341127B7B8987F4074179CF267464E2234120FE13758CF507419DDB742759E22341222CE7EE7AF607413CEDAC817AE22341903E8916B0F60741BC27C7E4FFE22341F8E0E3554EF707417C6F69CF15E323412A2FC4DDF2F607419DDCD8DA3BE32341021728FF53F607419623654346E3234192D248C91EF607415242F34D61E32341A47C1F6797F50741B66BCD2383E32341BEF2846987F50741B3588627CBE3234100DDCACD71F507412DCF275BDBE323411E23195F5DF50741866A4EEB18E42341AC5B203910F50741946153B13DE42341B2E7D4197BF407413B28088846E42341861CD4C540F407414AC0FC6C54E42341EC15A268E4F30741A0CF5FEC44E4234192FB53E521F30741153651A72AE42341DE4BB64C01F307413FA8FAD7E6E3234144BFB60835F30741A9E0B275E6E3234144E1038532F3074101318D64BBE32341EE0FB9C722F20741C65A11EEA2E3234158273E08C6F0074124DC303FB1E3234148D57F3CBAEF07419AC09C94B3E32341B091C8898BEF07415002A6CFA5E32341B0A7119C29EF0741781CA2125DE3234182668E1514EE0741C60A3ECE31E3234186EF64AC93ED07417B13CEF196E22341C424BBAD63EC07414F2AB45AEBE2234192BE73D9FCEA074126FE3FFCB8E2234110BBCC586AEA074148727E0856E223416EE2D4849EE90741A8C0DCF587E22341DA89803717E907413EBF07A89AE2234128E606B4F6E8074142E762B9F9E223417C763EC956E80741D93E77E956E32341E8B5DB34DEE7074105AED14684E32341FE1FDC7CA5E70741426066E6A9E3234188260AD769E70741AF5C66E6C0E323415AA57A14BCE70741010F0080E1E3234106D41E8521E8074194E0A3702FE42341104585EB13E90741E725856B7FE42341B44F14AE03EA07411791EBD1C6E423418A81B81E11EB07414D653D8A23E523411A310AD733EB074182E828DC73E52341D8F4FFFF49EB074192783D8AC3E52341900452B83CEB074183CFCC4CECE5234180A61E85C5EB0741300DAEC700E62341928C3D0A07EC07413FA2703D1CE62341347A66661CEC074122C8F52834E62341A06DEB511EEC074170DAA3F085E62341D68B14AE43EB0741774CE17ACFE623410EE7CCCCF2EA07414E1E856BEBE6234158C647E112EB074181EE51B804E723417E518FC229EB0741F918AEC71DE7234182450AD70BEB0741A1A747E14CE723410A42E17A20EB0741A616AE4773E723417ADE7A14F4EA0741D518AEC7A7E72341B6315C8F94EA0741FF46E1FAF2E72341683FB81E2BEA0741CDC8CC4C0DE8234150BACCCC0AEA07417F1E85EB50E82341F45E666688E90741FBB91E0553E823413898EB5184E9074156DF7A147EE82341E2B31E85D3EA0741473733336CE823411E873D0A85EB07412D22856B63E82341A8C6A3709BEB07414AA5703D54E82341E2FFAD47B1EB07416FF1285CF9E72341D0E3285C3FEC07410E4CB81E74E723411EE8CCCC42ED074185702C2F5EE72341BE60D74D59ED07414C68695518E72341243C0594CAED0741B841FA2EC2E623419EFD77CAD0EE07414583A15CAAE6234150D8DC351DEF07412DC456D5AEE623410623C6FC87EF074183DF898EC1E62341E478668C0FF0074141B15517DFE6234132E193F261F007415E1CAC41EDE623413A6B6E148BF00741CB1BC95ADDE62341C0D53B37E7F00741AA325967D5E6234180BCA44815F10741B9D4BECEDCE6234174A91FEFA7F107418112521BE0E6234160F19CCAD4F1074148B0BB67EAE62341869499685BF20741C227E43D20E72341A23D2E65E3F10741206FBB874BE72341C0D2A358B4F107412FBEB07858E72341A83CD3F7A6F10741BB56EAEDB7E723416C9EA04C7BF10741B2BD8A41CAE723416A760BF71CF107415DB703FED2E723418CB31175F1F007412823DE1F0DE82341E8A68E13C4F007413376FFBC5AE823413A98BCC078F0074199D37546A1E823415E143E8E8AF00741F0C97E9BC8E823417C9BD07F8CF007413A28DED50AE92341E23DE8FD8EF00741A1F8A5898CE92341C2646E1AC5F00741469B1B5793E923416A9CC556C8F00741B341E6EE2AEA23416AD6F3A119F10741AF7CAD10E7E92341442212A852EF0741CA18F3CFD4E923413C70256988EE07414494AAF9FCE92341A861FCF8DAED0741321134E51EEA2341AA50A5F64CED074134D7FC2E35EA234134FA2A7EF6EC0741C64F7CF73BEA2341C4F8525AC3EC0741C057244D2BEA2341E063A4C1FBEB0741B8F1C5951DEA234142BA8F9059EB0741DB541F8E1CEA2341F08A32988CEA0741EAF8285C55EA2341A038333385EA0741F5B447E1C3EA234184A747E160EA074144400A570DEB23418255B81E0BEA07413A44E1FA46EB2341986966666EE90741202485EB53EB23411645E17A16E80741DA4C5A446EEB2341A05C7DF933E50741C9D30FD17AEB23418A0EA1DB07E40741A678DC6486EB2341C6C6D70966E307418723D3069AEB23413A33BC7D4EE207414206F81EA8EB2341DE1A8DA948E20741347C4981E8EB2341769B63B834E20741A2E5F74D08EC23415858497829E20741547F03D154EC23415A2D0C13B5E2074165A1B63D57EC2341CCB935E0B2E20741E3F4417E71EC234104C3AE1D9DE20741C100034DB1EC2341BE1CD0FB68E207412C2AF42DBAEC2341028AA19162E207413549F4BAD2EC2341FE618A0ECBE00741B786FEA7CEEC2341FA62E81744DF07410F4380F3DDEC2341960F322F8FDE0741C02085EB0FED2341ACF5285CB3DE0741250D6DDF3CED23417C0D1C1BAEDE07417EEF513875ED23410CB71E85A7DE074103AF393F72ED23410443ED5965DF0741D6951FB15CED23419C2A485270E0074152CD767A58ED2341046D4094E2E107413F3058B456ED23410E39317ADEE207418697A3406CED23410257BA96D5E3074121A0A8597AED2341F41CBB4C7AE40741DAD4C05D9FED2341E49BD77CA8E40741903052C1CCED23415805D908DFE4074128126C67EBED2341225F591705E50741F033D36DE4ED2341E0AE813D8CE50741CD9F4591D2ED2341EE36AAE2A7E50741EE8AF14B97ED2341F49C1F1104E60741302324877EED2341985FB84A2BE60741E4C8D7B956ED2341D00795B3DDE607411DBF4F162EED2341603AE0F594E70741D19C43EE18ED234174535E70F5E7074120813A3A10ED23410AB1D5001CE80741595C02DBE3EC2341C2CD414CABE8074155D4B253FDEC2341A6CAD35C76E90741D91FF46013ED23417E4AF6DA25EA0741D217A94718ED2341505FBB0C1AEA07413A489C1344ED2341DC841C68A3E907414B7131D56DED2341A6843A7A31E9074195459FDF6FED2341FAD8AAC32CE907411554EA2BA3ED2341202FD844C8E807419261D9E1CBED2341008B2FD378E8074126537AF612EE2341560DC1F376E807410562CBA28EEE234184C8E6C2E7E807415FB3E578CCEE2341805F052B20E90741EFF7E8B2C6EE23410C3DBDC235E90741B05FA9C7B5EE234186977F9576E9074117A783F243EE2341AE20DBC293E907411D80E6CC29EE23419E13ECB29AE9074181BF6D4CECED2341020EC7C116EA07412C69EFD4A5ED23410E6E0794A5EA07410622A2E988ED2341FE708D1BE0EA0741496A734AE5ED234130766D8914EB0741749C2C2929EE234166498A4D12EB07416F628CA641EE23418076CB9712EB07419C60022987EE23416CE1679A0BEB0741BE12E62CB5EE234134D0C5F05AEB0741CC87CABFECEE23417864523EB5EB0741ECA41FC3FFEE234192C098FDD9EB07414754B87034EF2341A40E7B5340EC074160EA18396FEF2341B4B174FE9AEC07410CA61CB27EEF23410692D82527ED0741AE447A3587EF2341FE41E049C6ED0741700E51416AEF2341C07C10993EEE074132BD490156EF23419E96535890EE0741CEBCCCB0D3EE2341EC959B0F06EE0741AD3723B8CBEE2341BE8236BFFDED0741C802763423EE234164B308857BED074128D2553E94ED23417E2EDC7B0DED074196310B2783ED23418297C6D99FED07419496B99578ED234178669D1F24EE0741837B39D38BED23415ABBF39B61EE07410CEA6540AFED23412028A7258DEE07419AE9D0B515EE234166EA4C25F4EE0741DAFD83BE7FEE23414672A37E60EF07411AAF8FDBBAEE23419C081415C5EF0741E35B4008BEEE2341A60F3462CAEF0741791F450EE1EE23410AC9453084EF0741B1BBAC5BE6EE2341960ED86D78EF0741ADE6EFFAE7EE2341CA7CFB2376EF0741EEA8017D0CEF234134DCACF3EBEF07418A8E6EABF9EE23415EFB286C8FF007418244E5D3FFEE234120EE5B09EEF007415DAA495043EF23414A64B1ADCCF107412422BD604AEF2341A60C4AB8E3F10741122D06BF86EF2341369392E279F20741B3A24164ABEF2341C4BB796731F20741E46872C235F023415C6E389762F10741BDC75C113DF0234144DAF70E57F10741A35774726EF023419C50D6133BF2074133288C2F62F023416C024D0D76F3074148795B4D5AF02341A42D2EED0BF40741D464BCA377F02341D4EC1FAC40F407412B522E31A9F02341140E094E9AF40741E99A2B7DCAF02341663823AFBAF30741BAFBC97210F123413CFDB4E256F40741AB3FE0A32BF12341E219D4299FF407410AE76D0D60F12341441ACB8D2AF50741CF09898B95F12341C0F07F0F39F60741162C62D49AF1234100D9319E68F6074164432E30B7F123413A9DA78260F70741714BFBAFFAF123411E2D135159F70741C5AB7FDF22F22341329B26FA53F70741CCBD9317B4F22341D45AA16964F70741243E7D82FFF223413AEC83F36CF70741BC02C5AC8EF22341FE57CCEDFCF80741E48371C17AF223412214069858F907414C46457857F22341ACA0B4AAFCF90741C388AD5DA7F223415C884335DFFA0741E37F1D82D3F223412AE1126D53FB07415AB2D26638F3234194DA3C6C5DFC0741BD90640709F3234130B80F8A07FD0741B68837D994F22341D890EAE8AAFE074148530D6E94F2234102B88155ADFE0741804E0C3FA7F2234148D80BF25EFF0741DD84E09CC4F223411C6D8F2472000841E6B264A2C6F22341A258A297E10008414C01A34EC8F2234180BF6F9649010841AA70F5E8A8F22341C04DC41771020841D98F084297F223413A73FBA1190308419FF2723BA1F2234140F36ADE930308417B5B5E4B72F22341C0DDF55255050841086A04C03FF22341DEFDC9FC3206084124E07C3BDFF12341022D0197D807084142B23570BCF123411212B25C700808418A16534AF8F12341364E775015090841BD9E6B7008F22341ECE38928410908418B3F9DE8BEF123411A6E74E8100B0841F7B7DF22B3F123410689DC315C0B08417A91B6E599F12341EEB9362A1B0D0841E9CB31A47AF12341F8248E254B0F084108A82CA959F12341244C4EB2E11008415CF52B1E7CF123414A497AC406120841B7FB508789F123417878A091EF110841584D27A3BAF123414E9D1B90A3110841FDFBF38FFFF12341661F93C97C0F0841F511F1B470F22341EE172B7FBD0F0841752AA3FDF9F22341BEEF7FAC130F08413234395AB9F323414A3C7290EB0E0841694F1F3AE3F32341661E9D5F680E084112A0BB17B1F32341E2A52C27B80D08416FF3E18806F323415685C808EA0D08417094646F99F22341543E70D5A40D084163DD01C5AEF22341F220AA700F0C08418E7236AEC3F223411A4B078CD10B08412C029A9301F32341A27D88B71C0B0841E8A392F31AF32341784AEEC2100B0841CFA06E9479F3234130A3FD93E70A084154576A868EF32341AAC5E797DD0A0841113BA0B4BFF3234106657490C00A084136E65189C4F32341E07FE1A3BE0A08412B1EAEACEAF32341244635B62F0B0841B7203399FFF32341DA7457BCD20B08412EBE20E557F42341C4B6AE54D50B084113CD74BB58F42341626C897BD00B0841196EBE5079F42341A29C2B6FE40A0841E190137C83F423414C18F3F7980A0841E2F4AB7ABCF4234198AB89A4610A084142B721CFD3F423417211FBF0040B0841F8309401F8F423413615FF72160C084167EC06B003F523419C315E0D820C0841F2A647E119F52341D89B66669C0D0841910B0000ECF42341A4DF47E1A20E084137D87A14C9F4234186EE7A14AE0F0841832E0A57B9F42341065AEB515210084122C2F5A8A0F42341F8BBC2F5681108415E2185EB93F42341143DE17A12120841A00FD7A385F42341CC030000961208416E7F3D0AB6F4234182B8CCCCFC1208417946E1FAD4F4234138EEF528621308413D310A57E3F4234190AA7A14D8130841A27EEBD100F5234188E447E142140841E7613D0AACF4234198CB47E1C0150841DDB247E1ACF423418010295C23160841A853E17AB5F423411C5EEB519616084184F928DC0AF52341B05BEB51FC1608411A49E17A37F523411270666658170841B7CEF52844F52341D4B1F5287A170841A0BB1E855DF52341863B85EBF117084180F2285C74F523418E5A6666AE180841ED86142E19F5234182B2CCCC9A1A084104E4A37001F523416C123333931B0841DA2F0AD706F523414EE951B8301C08416B05AE47AAF4234150BE47E1701D0841D3390AD765F4234108839999A71E08412350B81E61F42341245A3D0A191F0841FC2D33B35DF423416807AE47811F084133AD1E854DF423411EEAAD4707200841641A5C0F58F42341769947E1AE200841590429DC5FF423414A978FC2F32008417C9199196BF42341B8AA14AE9B21084106598FC2A0F42341ECAD1E85FD21084152B61E8509F52341E211D7A3B02108419F1E85EB4BF52341EE2B6666EC1F0841FFDCA3F06AF52341AC0C00005C1F08415FAD70BDA7F523415C3F3D0A571E0841C2F25138B8F52341EE74E17A061E08415E06D723C6F52341EAD3F528761D0841F32A85EBDFF523415679EB51E21C0841F40ED723F2F523417CB07A145C1C08410EED5138FEF52341B8FDA370E71B0841E1CDCC4C34F623415A841E85311B0841FF79EBD166F62341A094703DD21A0841EB0AD72395F6234106C4A3704D1A0841B50B0080BFF6234110C47A14A8190841DA5A8F4225F7234166FAFFFF7719084191C9F5A82EF723415A528FC215190841556F3D8A38F723415A528FC215190841A1E951B828F72341D2889999EB19084125CDA3700BF72341FC3F5C8FEC1A0841BAF528DCB6F623419A9F14AE411C08416D13D72356F7234180D8CCCCEA1C0841E1608FC286F7234130BCA370E71B0841E6E45138D9F72341147C703D6E1B0841B7420A5759F8234160D4285C1F1B084194FCFFFFA6F82341DCA6EB51D01A08413FC01E05E0F823411642B81EF71A0841690BD7A308F923419A1ED7A3741A0841D781142E44F92341EAA61E85D9190841E62385EB68F9234182CD285C0B1A08416BFAFFFF9AF92341ACC7A370131B08412ADEA370B2F923416A9F14AE911A08413613AEC7CAF92341DA18D7A34E1A08412687C889DAF92341E273DC97E8190841AE7F16BB04FA2341BC2D0EA7571A0841E77899AD15FA2341F8C0BF99831A08419F627E892FFB2341E44DC5FB4F1F084156293FDE2EFB2341C076F1D3AD1F08419461F5BC2CFB23419EFBF7A5D8200841470AF2B32CFB2341B41D6696DD20084144BD4AF12AFB23410016E98BD42108412FA32BC810FB2341D8FE8AC416220841E8B30ECF19FB23410457DFD46B220841607C59FD32FB2341825512FA5B230841655F12304CFB23412CB51FA74924084101B08FC0E1FB2341A62B160D0D230841C3DD9BB0E1FB2341F2C99E3CA52208419E93FE20E2FB2341DCCDCE9486210841991E5936ECFB234184C76B78472108411D8AB3E6FAFB2341360792B2ED20084199A2B43A27FC2341E6710319D5200841FAF1B91349FC2341CA228CB7C220084167F99B6D88FC234152B2B2408E220841112F765CA4FC23410A7F1037A52208417EA30573A4FC2341E054FDDD9822084149200658A6FC23412C62A7ED1E210841EFFA206BC3FC234162F0CA36CE200841CACDB5D4DCFC2341AEBC0A5446220841507134B3DFFC2341EA089B76AE22084152F0D2CDE5FC234158E3E4B78323084144B0877E0BFD2341FE5C9AB7F923084150A48F331BFD2341A4F7D1782A2408413B9BF58D27FD234174FB9E76A724084139B665AB28FD2341BC1DE2F2B324084108F15C7C37FD2341624B3EE0D12508418656965241FD23418EC22E57B52508410BFEFE9944FD2341D2162AD4AB250841CEEDC0BBA8FD234124FB136F7824084168AA3E3DCFFD2341D029EFFC4324084107D402CFF9FD2341DE4EA79708240841863AE05141FE23410A9A9577FF230841A64C9CAF43FE2341C22622873D2408411F6403CB49FE234140B3FCEFD9240841A215978A56FE2341B65695D28F250841411758B358FE2341720609ACB225084184080CE77BFE2341D8E3DEF8A326084167C7DE17A6FE23411C57A5372D2608412D15F78940FF23414442941C782408417DC070CE7EFF2341065FC856C82308412CC6ACBE5AFF23413E9CE83217230841AD14E2D35DFF2341362991C88022084138A6495461FF23413848C3F1E7210841975A13EBEAFF23412E6DC963332008419F8DDC97ECFF23412099F3B129200841F12C3609180024411C3A9C733C1F08416FD2C62117002441AE78D6426A1E084125AF9CD0E0FF23412C0A5BD79B1D08411ED6BBB7DFFF234168B4CDE28C1D08413D2E3B3CD7FF23411EEA6E1B241D084105F70C00D1FF2341C42287D4D11C0841909AFE20C4FF23417CFBF93A2D1C0841A9F6E21CE7FF234142512FE49B1A084127E4F03207002441F614A7909F1A0841241738E7220024419E9824A4D61A0841EC794BC6270024419E57E7EF961A08414F756BA43F00244150540DB8641908413CDB8DB6600024415AC278F1161908417FAC18CD78002441EAA22E62DE180841F0ACE475B8002441BA7C704885180841447534D1C8002441A698AA953B190841A6C6DCEBDF00244192C0C68BFC1908412DA918B9FC002441FAA748A6EA1A0841B08B4C1836012441DA9C99D2961B084141944406620124412238B444261C0841837554055A01244194E7F9F2CA1C0841057E64E776012441606C798DE51D08419504A2F298012441249C15F40F1D084125602B39C20124410220517DC91B084146F9E7A8C2012441C66DA998C41B084196E783CFD901244130F4C0C9BE1A084157E3F18CDD01244186F9A3FFCC190841F43AAEBB5F0224414A72603B231C08412FBF6014D5022441B657F96CC01A0841509E69E2EF0224415A9279AEE41B08413091D3E16B0224414AA9DD3DF41C0841EC9B24D474022441BE286D098C1D0841CFFE804176022441E43AB0EAA41D084167D64FE781022441DE7302DA4B1E08416A2D64B21603244118F48EA2451D084142D19466050324417C4395ECFA1B0841D80AED28AE03244106A97D6FAB1B0841BB37B156BD03244182D2DF82951C084199E043A946032441943FBC29F21C08417E4B62364F0324410E3FFF10511D0841BC44DA64610324413608694C201E0841D9FA277C3F032441186D75E9721E0841269C00F07C0324412A0F2CF92C200841847FAEE2810324417C6BA89D522008417E8CCA53840324416802F9F34D200841F5F04967BF032441F454A136D41F0841C3B4D7E2C303244120C87ED7CA1F084145694BCBF4032441E6A956B5631F0841F9B70CE07C042441986365C5E02208417B6179B67D042441E67391ECDB220841CAB94D669D042441F01FDE7E37220841AB8B0150AE052441F221A577CC210841F912B27BA90524412450E616B72008418FE45B2EA30524415A1CB164571F084115FE35FCA105244118D087681E1F08412A0B758DC10524415AA2697EFA1E08414B28940DDD05244184A3A64D6E1E0841723C7DF797052441C0C4521DCD1D0841625431BF8F052441E8323A22781D084155182C898105244160750D25E71C08411AE8DD5974052441F68344B2571B0841CDEE4C58710524419A71B850031B0841CB2E0A3CD2042441B4C4FE90181B08414E7FB1B9D3042441F8B5356A601B08416F2A5BFED50424414A27F7ABE31B084126C7B4BA4704244112010BDEFA1B0841CEDB0111450424414610D0B73E1B0841718A76963F04244172DB91CCA3190841F9BC1D4EB00424417AA7C50E3F1908412EBF0D8201052441FE9F22D4F61808414E5E2FB2FD042441EE18F76C4A1908415C42027FF004244108C12B425B1A0841C1387F66580524410833FCE22B1A08413159B86878052441DE950E025B190841170AC8D680052441B0085421231908413D0651116F052441FCCA09181B18084159B0BD11B5052441561E6B7C05180841ABDE9A24AC0524414E94E5376B170841DBE6C159AA0524417072475A4D170841E9084779B5062441C6A93C93E51508415CDEBF54B2062441EABBCA65831608410846F425C00624417E98D27EDB1608415FFB7210CD062441C456C77809170841BD840E1BEF06244160C6950784170841BC067A0D0E0724411E60E58DB6170841EBD9B8D218072441FAABC947671808412116609577072441346B5424F4170841C033931B8D072441A41B0E8CD117084152739017B4072441C0AFF74D93170841B2B7F8F9C7072441062BEA767517084172947D11EB0724415E07398BCD1708417650DB49F707244112EC9A9CEC17084122EAEAD549082441F84BB54E1719084116145DE662082441CA78853B6E190841DE65118FAC08244152F21DF2681A08412A1A55F416092441E4A5E10EB41B08413FC2CEA224092441DEE9B411E71B0841E22F0F0B690924411E151C20E61C084165E9E53B6C0924411A691AF7E81C0841E68046D3CF09244140A79361521D08415163613A240A24418478A9BCF51B08417470380B6C092441CC0A88630E1B084135B6104D490924414ABA66C2BD1A0841BE62F102E5082441AAC3FC36D619084176E8FFE97C0824414ABB12339A1808417CB1CD8B590824416628F1C8301808418251F8A01E082441BCA6A3FA7C17084183A8EC9DE70724417C548BAD47170841791EB124FF0724415E9D21DE461608416C55E8B039082441743B2E04A81508416BB321CB4B08244182BA28B0A2150841670B64AA7B082441B2B7146F941508411421D019820824416C8947B4921508419677C134D508244142238C8D591508417C330182E0082441E22E43F8501508416662BFE837092441A28C4EC5F014084108A9569441092441E2656C18B4140841E741ACC05D092441087B8EEA02140841E566E8329109244144AF7BCC8A13084107BC44BCCE0924411A16D1CE421308416F47A718DC092441F253690C331308415ADB435F590A24418C71D095661308414E7ABBB3990C2441DCB0D50F4C11084142DAE8C7BD0C2441B8F0E588241208413DE20AD7D80C244156F0502A451308412F46C9720A0D2441E6DFE24E501508411012D7317B0D2441601F5E6949170841F832F825C10D244196C7634A7D1B08411DF7241BF50D24419A01A085FE1D08415BC39938FE0D244142F5C4A17D1E0841BD8749530C0E2441A038DDD3531F08416AEC63E1150E244162AC76EB6622084100365669100E2441209490566723084125E99739FD0D244108AEF7E6A8240841CDB114BF770E2441326BB691DF250841BA1DF569C40E2441E2FA1AA2C6270841959D1611D80F2441FA84B485262B08410D492F34D70F244188E7ED75F72A084147A5DEA4C90F24410EE6F51F532808413A9FFCF8CA0F2441BAECD1262D270841E538E86BE40F2441C46DA529A826084139B51E2ECF0F24417A8733A0FD250841CA396E04850F24414C84B97A4A25084119487A8E770F24416AB3CA998A240841A463AB69960F24415EC643465A240841A64BA056AC0F24416C851CBE37240841A9489D383F1024411E468FA087250841A92DBAFF9C102441C8A9BBFF4126084142F9B1E88B102441983BEA363D25084146A9C8F29D102441F078520165200841387006A0B51024414055CE9BCA1E08412CB57B89C61024415A91E2EB741E08412015A99DEA1024418C7D0D46311E084107262C466C1124417E2993C8351E08417E9AD82B4013244138F9310FB41E08418C874210481324415A250241281E08417C9E69B34D1324419EF1A45E781D08418D057A4C41132441B0D11C220C1D08419BD25BF4DC122441427A3BDAC11A0841ACBB3451D71224416612ECB6821A0841973DFD14DE122441949A58750D1A08419BED131FF0122441942E78CAC01908419C860386FC122441BCBE069866190841A09999A1F4122441EC3E5147D61808419C6B4B5BE91224411EBF9BF6451808419758B53FF11224411A831C057B1708419360D74E0C1324414A0367B4EA16084179D86A90811324416AA339A0C616084166444B3BCE132441D4938AE06F15084153B02BE61A142441F063BE85CD14084131CC229B7914244102443649611408411298305AEA142441B2D39A5948160841CB8757DDD41524412AD4C41607140841BCA34E9233162441B09449FC0D120841AB0B9EB572162441CA647DA16B110841B7AB70A14E1624414215290A5D1008413F4CC17A09162441C877C309320F0841924210467D162441E4C62A42CF0D0841B6F46ED2B116244142B4BBC82F0D084122F422E2D516244148001589DE0D08418F11009A4F1724417600E58E0D110841CE28CACC8C172441BCDB9E2B9A11084111DDED05BF17244144BE084C5D110841A059112399172441E2E014A2B90F084141836035F9172441DCFAF26E3A0F0841DA1CF7D2781824413EA5BCB1D20E08418336E489BA182441281175A73E0E0841EB94630CDE182441D280EAC3EE0D08414C00B6A5531924410C15E8A3160D0841B2E55C8D52192441387CA3AE070D0841E98C643A4019244192BD5E42180C08412C756A5A791924411CA646113F0C08413A4D358CDD192441886F3889B10B08418289C74B1E1A24417ECF5642FD0A084160385E16231A24411CB601EAC90A084185B28C66491A24417CA7A19F31090841DB1C2F67421A24414019C88A6D08084179F67495B11A24419AA9DD033A0008410FBACBE6271C24411A0BF4F0BAFA0741BBDBB852F01E2441D4D077C9D6EE0741F3241E086A1F24411825779E46EC0741A3519A5D9220244112F301733DE607416A20AF1D31212441126D8D72C4E20741BB612D536922244150FDD69CDFDF07410565A5E871232441B62C419C68DB07417EB9597428242441D0B1875348D80741CA2A9D55932424413E8834C373D607416B6CAB23D02524414221AA2B9FD107418929770FA5262441B4F72EB4A8CE0741BD3D777DA72624415810E2F726CE07418D44B304B22624413877375882CD0741A6F1D9B3E526244146BA1F94CACC07414EE95CACFC262441A2EE86C7AFCC07413FE853B2AE272441641618D4FAC90741E1365DFBED2724416213DE2639CB07413A91EF66D72824414666081237C807417CACDF8301292441E0352CD95CC7074149E8BAC481292441346A2CFA6EC507419F6434C71D2A24419C4AE3BD93C20741D3DD2BC9FC2A24415E5B0FA8BFBE0741B765A4D33E2B2441AACC5A1673BE074110A2B79A4F2C244172B3AEC83EB90741C4306C2C9C2C24418C397F40CFB707410120721DCA2C24417E63F0655CB707416D083C87ED2C244190B5C0BCDAB7074186B56236212D24416CA0D4A02AB70741CA0FB094882D24413AB1679D29B50741AC476B1BEC2D24411A1E022B00B307417D9E26BB6A2E2441F6F5FD5A39B10741CF1020A1A92E244134F481B4CBB0074167274D3D382F24416EFC97A9E1AE07419AC0F7DCDC2F2441BA69F10AB7AD07417312C8335B302441620FA4AC4FAD0741DFFA919D7E302441E64192D9C5AC0741EC91C336B43024416AD2585FAEAB074136770BA01A312441C8EB686396A90741B65586FB4431244182BD98041FA907418DB3ED90CE3124419209B1594DA70741D4EDB827CD3224410CB7330B0BA60741062853E86E332441D8DE2B2A29A50741F197CE2CB23324417ABDD23BD8A40741DFF8E6BBB5332441646775A828A40741D96DECB0B633244136FC2D3BEFA307419F1ECDE6373424413CD255038FA207412FEA65B3523424414E7E0CA6A1A107413655AD208C3424411050A97336A1074161A3C3F0BC342441F823BF473AA10741267457C403352441F436325D7BA10741FFC5271B823524417293F8C151A2074141E11738AC3524419C82FEB27FA20741AEC9E1A1CF352441BA320E7543A407416AD5CFC600362441C6736E5951A50741D1ACB004C735244128D0AA21C6A507419A48A51E9835244190ED13455FA607414001CBD57135244110376794F4A607416E1A42EC2C352441F0B421176FA70741911DC4ECE9342441B21965832EA8074178709D3DB63424410874B2E195A80741BA0A51D7A8342441423947AD36A907417EFB9748B5342441C8EB686396A90741075CE9A796342441A66923E610AA074183A645F179342441A66923E610AA074117BE7B875634244100B1FD2E37AA074176B0037941342441204AA8CEDBAA07418FBC3A07783424416E4E9ADBB9AB0741B2EA3627103324415AF6FABA3AB10741F1458D7FC5322441BC008AB6BFAF0741D1CE0E8455322441F658C5208BB107413CAEBC4D2C30244158444373CDBB07415805DA942F2F24410AFD9C98A0BF0741EB076B13302E2441E84ED5CA71C307410EBF277F6A2C24412AAD9F44E1C9074187C029B8362C24413EA7456CB6CA0741BE24359E652C2441CCD99AABFFCB0741F089497EE22B2441320E69F1B7CD0741D77D12F0AB2B24418AC29C9BB3CC074128F91BE6262B244180125BFE95CE07412DA4C98EEB2A244126CF72C24DCF0741FC6BA8D4B82A2441543ABA2F87CF0741FBEA6B51812A24419842373770CF0741F47F24E4472A244176BCFFAC0CCF0741BD1B19FE182A2441607DA26BCFCE074190FB6A03882924415E8043EC53CF07413F4412943B2924415AA9BA4550D2074151D3646926292441FC5CA2F021D4074144575829C7282441A6D43F4648D60741E4B1472948282441843C0F9CEBD907414B7B65F01028244188FB21825CDA0741B17B28095A2724411461A471D2DB0741BCCC743E15272441A69DEEC67DDB0741FC3B661EA626244136C2839C64DD0741134FACB331262441608C2972CADF0741644DF068AD252441C6C77C7245E20741696036FE38252441CE30431D19E30741EB69D9C8FE24244170E42AC8EAE407414B55D7E8EE2424412CEB1AF3FBE60741DCC20C7EFB23244134971B1E8CE90741FF269F4842232441AAC39773B4EA07415025E3FDBD222441900EB973B2EB0741F6BDD89D6E22244132DA559E48EB07417BAF01F31B212441E428791FF7F307412D42FBB2FB20244104A4952E7AF4074100B64F21D420244142505C2298F40741742C3674862024419002FB5C1EF50741D16CC25232202441DA7684C7A8F50741F645C3640220244136B7BED897F60741A1B41D95DB1F2441E2FDE1D096F70741013C56332D2024417854E4AF87F70741040EA7040E2024419C4322AF2AF90741657C881B951F2441B4C1D01A69F90741346EB6D6931F24418E727DF915FA074112816215911F2441A4F45B598DFB07411B177D8DDD1F24412E1C10F471FE0741D35C01AFDE1F24412C9B17F97BFE074136BE4E525C2024415E5B931C38FD0741895C062E7F2024419C0D48E389FE0741B3752461861F2441D0B469E264000841138F931C351F2441CCBB3696FA01084145B7F250AC1F2441F23A03915B010841E09DB737392024416E3BA1C783000841E3ABF4CC81202441E0422BA6EBFF0741F02F0421AA202441A6AC55F965FF07415F23EA33F2202441EE2DD09DDCFE07414698C66A5321244120F60863C4FD07412BD6F177792124414229B98563FD07417B7CCEBD202224415EFA8515C6FC07416040BA6D7622244174AA9C1FD8FC074148001596BE22244174AA9C1FD8FC07412BC891CD212324419E3A2BED7DFC0741A3674D6176232441AA355550A3FC0741F2414667BC2324418067F36967FD07417FCF703ED62324410C35AB58F7FD074198360ABF2C242441741DFFEFDEFD07419DEB41924D24244160EC5634C6FE0741CD0302721F2424417C1B27693D000841DCE688E24C24244136058B506A00084104534A4264242441640A127CF1FF0741EF562043852424414484AB8BE6FF0741EF54E95F9F2424417826C46F51000841A68F2E0FAF242441CC48323B5E010841BEB6C445192524419C5E6DDFE301084153ED08CC5D25244112C6E75ACF0208415370BE7F7425244162BBEA0855030841B4B667F981252441A6CA883FA303084187882421B225244118005CD6DC030841D077ECBBD925244162957ADAC90408415A96D14145262441A4FFE4D440050841A51CBEAC3126244158A05C63A1050841E77C95810F262441EA43CB5F4A06084117230FD64326244100F41CF8DA060841F3322D2273262441DCD5ACA188070841C1A987F189262441A44986406C0808412FCA3DD99B262441F6C46268C8090841C0B57675AC26244176CC7A03C40A0841CE9F0887BE262441F4A1CD90D30B08417E2A63A4DA2624419C7AC713750C08418F1FD7B723272441BA5467F5160D08419E0A8AF78927244112AF2C3BBB0C08413154F5C9B827244120E041D7620C0841C1B5D1F0EE272441C2ECD87CFC0B084170C04EA04E282441B88EA224EA0B084111705B88C3282441B24AE463820C08410D8CDE81C7282441966BD0CD870C08418E66EC341329244168C009BA420D084105C388BB532924417C52CF661B0D08416CEFA4009B292441A04802856B0D08412031A398992924411626574CF30D0841266DC74197292441427F15672F0F084156629B90B1292441E44037247F0F084102904B63132A24416EE7AADF4B0E0841D861AE365D2A2441AEE73764E50D084137699042952A2441A402DADCFA0D0841BE4069044E2B2441DCB7FB2EA10F084188FA2563502B2441BEAF7368A60F084103EC4F73672B24414EE5EF54C40F08417D1D3A39182C2441C4ED6CA4C110084144931505042C2441BEA3BE650911084151C62603EF2B24410AF4826F87110841811F26AC122C2441A6E9E6FCC611084150407F21BD2C24416875987C21130841F90108FCF92C2441FACE584CA4130841B14497CF1D2D2441A08CFE3F97130841360D080EBE2D24415CE416B758130841BD91A539492E2441C09FFE247914084117AB49617C2E2441E6DC2452CE1408417364BC97BC2E24417810EB02D1140841A032D894F22E24418E7082EB801408411B7428A93B2F24419054ADF7121408417CDA36BA742F2441C01EE3EC0A1408417279D0E89D2F2441D4926E81571408419D86CCD9B82F244148FFC894BD140841163E1571E12F2441400C12918F1508414BB8B89AFD2F24413CFF0E51F3150841DD0303EF40302441CCE400BF02160841301FF13DAF3024411C7A661FA3150841F465CF92D83024414273B692A5150841B62CE3D1F0302441187D371FC61508416C3B314733312441B8A11D62B6160841EFC29A9B5D31244152F3076A1C1708412A597AC59B312441049F507563170841DDD9F00DD1312441207A32F6FB180841B65A675606322441D2257B01431908417BDBDD9E3B322441F8CFD67B1F190841425216BFA1322441E8285523181A08411BA8BA44C5322441C4024A13461B0841585F2E0946332441EE84ADECE51B084194F50D338433244118B359D1CC1C08415A6C4653EA332441CA5EA2DC131D08410B22CD86003424416C63698F531E08416F58CA024C3424415CBCE7364C1F0841E68EC77E9734244196E5CC68F31E0841983A108ADE342441D0BAFAA5E11E0841728676E732352441B06CF7F4D22008414DF370DFC9352441A49D7DFB8E2208414F2B5BEC7F362441FAD1DD23202508412B8E17BC473724418C2F237E582708418EEFE6FAA43724411A09186E862808418FE5A8D2D5372441CCB46079CD280841CA85C624E3372441480FCCB1302A084106FB11B4DE372441EC97E3CE7A2C08417C107B95E73724416CCA5666A12E0841E69C945BE9372441784DDF4C412F0841A9E2ED37FC372441DE02E77EE42E08415FB3032224382441EECE7FC2B42E084147DF303E5D382441089F57095A2F0841ED139B896E38244194EAFD77692F084165515A8096382441266B88F88C2F0841641BCE05933824412CA61160E52E08417E23865B913824411675ABF9952E084191A8A764D738244192A38A07DB2D08411B6BE0E61F392441EA0E6C7F532D0841FE7FE72D82392441901DD52E492D0841AE332AB69A3924417C9E9A04532D0841E3C495E3A23924412E0E2A7F552D0841F4134B75B33924415CB9AD0D5C2D0841757E3F56FE3924417C4CD397232C0841B764EB840E3A24411E121E6C222C0841642CBFC2AC3A2441E05DD15FE12B0841BF75009DEE3A2441CA4F543B60240841C0DAB973A93B2441E295361CEA200841337D9BBDD63B24411CA09529B31F0841016C6639E83B2441224A848B4D1F0841BB47D15BC33B24414AE8BDE90D1D084192D907EECC3B24410AB668AAC41B0841E590393E9E3C2441D256244BE81308411C5E2FCE7C3924411E16E825FB0C0841F8315F9C083A2441D0861874F30908417A19CFB1F83B2441E4A5E194C10D084137B90C3FF53C244166D51891840F0841BB300B228B3E244162057A4A060F08418A56DC23733F244158BAC277790E0841C56FC1E3DE3F244144F5F0EF2F0E084111CC839FE13F244192DD62273A0E084109997B890C402441E8460FFEDF0E08415BDD326009402441400758930E0F0841ACCFBB5105402441966DE868490F0841011E18FCE63F244178091C8211110841AF2F82A3D43F2441E466EF5F161308419871469ED13F2441F8337F94671308419EF28DB92E4024418A069C0D0C1408410AE0CFF34040244120A578E92B1408419E4702BA78402441AE81A0739A140841DB8E5811A3402441B6B1D02EEC140841B131EABD0A41244192FC1B8BB4150841D5C8CEA3D840244142E5051689170841A0850E5EC74024410E2F47242A180841B14FC550C1402441A20993A498180841F10ACDE6B1402441180B11FCB71908413AE06328E2402441F62EE274B71A08412CE37B03CE40244104F8F9F5951B0841508F18D95C412441FCE5F827D61B0841E0C36B5BA0412441842171B91A1E084188FE1A77DF412441C0884F25F520084189EBA640394224419E557E5DB61D08415BD22F2A7E422441CEB144C28C1E08419F2C7D88E54224418240F953D91E0841D2C527288A432441C26E5C86441F0841B9ED86597B44244186D791FFE120084120CC923BD74424418ED30605D721084155A49A1CB9452441DCDBEA1E932308410509DE88784624411C0A4E51FE23084168FA5C8015472441481FA17F8126084150CE725419472441A46A6DD5852708418AD26461F747244182E8275800280841A53F25D59F482441F8D72D492E280841A77E8216DD482441125EFEC0BE260841E7AE5E4FB7492441A0D3D4297D25084109876630994A24413E8C93CE83230841ACA8C160104C2441D61E0536351F0841B7933C57334D24412866786C881D084119465E0D934D2441BE480F49EF1C0841A626E3F55D4E2441AE6E8E619E1B08413B1E66EE744E244100B60198F1190841B73D48187D4F2441B6F490B4881608410A6E24515750244194724B3703170841D2FE51E912512441DC4CFEF9AD14084153F45BDBBA502441E6F84D8AED11084188781A5FAF502441689C8725171108415FDFD6D1DD512441A8CAEA5782110841E554144D6F5224413EFDA6A99E140841022DC193A9502441D09CC65C661C08418C327EA7C25024416E886B57201D084153E48C94FD502441FCFE3FB2D01E084196BD88012F5124417AE323AE3A2008417B1AB8FE36512441F4293F8274200841A5FEDA323E512441BEF553131C2208413A2A32523D51244156ED0EDB252208412ADC441A12512441046A816EB823084109DBE7F30251244120539B6B48240841844731FDB35024415026BAF4112608414CA54D46AE502441FE3960B5E92508410A987E487B502441208A7E977A2408410E32E98B4A502441FCF2B9861F230841BBF349A037502441981445035B230841B826320805502441A2D36F73FA230841112B20493A5024416EDA6486B12508418808BB962D502441862DB694D2250841284B293FDD4F24411E9C422FAC2608417E311E74A34F24411ED11D4648270841CD8E1F3ABB4F2441F802C88ADA270841CCA18FF7C54F24419E8CEE1E1C280841878AB1F4365024415E4EB0D90A2908414587F98C375024411A40021D262908412B51485B3B502441F65024E0132A08412114C85827502441B6BBDE65402A08413246CD8D8A4F2441362D6D189B2B08419FDD1A3F674F2441BA4FDFDC5C2A0841E9DEB2D4454F24414A314EB12D290841DFFF64EC224F244180F78882EF270841DFA41149204F244162E706F1D8270841DC48A1E20F4F2441E81BFEE70528084151056D5EF24E24419C1E5A59562808417DA16FD4DE4E24411A469322452808413C6D3C3E8C4E2441C8E3563602280841F21C12F30A4E24411E7C549F422908412CC733CFFB4D2441FC5CA35368290841CD9ACA69E54D24410C5782E4F328084129568B57004E24413459E45CB327084164F36375FF4D2441CCB3DE3B89270841E5819C0AFB4D24412434C396B6260841652B03C1CB4D24419C8B5BAF0D260841210CFD6C734D2441762C2AE3D224084171C5CBA9604D2441C07D835590240841306C4AC6204D2441661BE2DE9F2508416A865158214D2441061C2DE42726084102614AA9224D2441FADDBA9D552708417814645A114D2441EEB38136C5270841B7F57C00F04C2441A8B9F075F626084146BD52B5ED4C24412463B259E72608418B848B57AA4C244134018BC4A826084127914D75884C2441540DE1738926084183E308EC704C2441E48E82C57D2708413C49D3C4764C24417AD0D1BA942708413A609C1FA54C24413EB91FD14E280841E06805A0BF4C2441D85B8863B72808410BB5C665834C2441EEBA42DAED2808415E13646FFE4B2441F60342266329084142CCC128E14B2441A2FBE8C8FD29084143A779C3CF4B2441E6CA67710F2A08415A9CB5BEBC4B244192D52B60232A0841B20C7F8D994B244192A5D1A4462A0841FE3D4E926F4B2441046119EBD62B0841D962C78C5F4B2441E87CFFB1702C08410FBC2D49864B244196256B0CC82D0841B0AD4C359A4B24413CE5EFF8792E08415B8E32B7B14B2441123DEF17992F084133FE3F14B24B2441560AD6149E2F0841427E8162D24B2441B0BABD082B310841C720108F784C24412850DB3CCC3808414DF7CD6E9A4C244142E165D75539084140770C7DAC4C24417E2957F9E73908410964D5CEA84C2441C0E96FF5303A0841C925E1F9F14C2441FAF6D200423D0841CA5F5B7C234D2441C81C1F13CE3F08410D1ECE672B4E24410CFAC405F83E084190160FA1AF4E2441208C16E26D3F0841DE3842352A4F2441449446E3C53E0841EBA4D666694F24415AB5EFF0E83F0841F3AE2D3EA44F24410A53242B7D420841E7C1ED85A44F244150FF8165E442084135E6DF9E2950244108BA09A751440841D780B90999502441E26469E3E645084170A0E0BE3B512441C221D926E4470841B1A3FDA8D4512441BEFD7CC83249084142F118864A522441B6A08357C24A08418D3202BB3C532441AE755AF2194A0841462A869BDA532441C2BA9308BD490841139F4F7562542441FC69B3F0144B084170E0E8AE0955244100B3C708F94A0841B58429DA04562441C0601FAF8C4A0841C32B99B94F562441D8C399626C4A0841F3DA5D2AD456244198D924B7C94A08413EDBDD2B1B572441C4DABFC0FB4A084171CF2C8D71582441E2E6F36F424B08419482B770D55A2441FA69569A984A0841FC313462AD5B2441DAC9F864A94A0841002774E4665C2441787C7C9D4249084161CEC881275D24412459E4E27747084110110027F95D2441FE09417191460841B5D4960ED05E2441861CE81C2944084164E179B8AA5F2441C476DDDFAA4108419882458390602441AAAFAA3DF73C084138E9A97AE16024411857351C303B084129DC0A75C26124410270E51EA03808414090AE03E7622441B436A5625D390841192E991AD06324412675B87ACE3A0841F1FE3F510C64244156D833196B3B0841FEB694669564244100F32BA9CF3C084113334578866524415809690AD43E0841A118566BF1652441E20D3C66024108417129A72932662441A6B2924BBF420841EF366378316624417A2806D02D460841D66AFCA5AD662441405544361D470841A9B3B0DF3A672441A0708E41034808412A33BA2AD167244172910B4B6A4708419129D81E516824410C4F6384BF4408416993D53C73692441DA4884E0C748084135CFFE35906A2441B8489790334B08410A86A2656D6B244162026ED2ED4C0841A0C059344D6C2441DE9F6B0AA54E0841AFA281EC2B6D24410035F53ED84F08417BC82DBD196D2441CE973F688E530841C2D82D6AFD6C24413CA6F7230959084171498DFF1E6D24419AF2EB976A5B0841CADA00B4B66C244188F59642E65A0841BE66706F4D6C2441B24F7DB43D5A08415D0A3357BA6B24418C2CADFC9A5908415481F704596B2441E2263153045B08412871439C306B244132C6A2335A5B0841DC3F1287F66A24410836D104D75B08414FDB6C14B06A244124304A5D1F5E08412405A32CD26A2441DCBF748F155F0841B93B5477456B24416E1431B031610841D6322FC4AB6B2441E20B8B040D62084114CC1241166C2441A471F77D06630841595FEDF7DD6B24419EDDF9FB196508419C0BD1C2E46B24417E3810C5366508411966BB9DF66B244144A247E8136508410996EA860C6C244100E98E54E66408410B4964781F6C2441D46C90D5B6640841E459A9F8406C24416C631B7C526408414CC530D64E6C24417A68E2D22C6408412EDA1FA1726C24417442A2C5F46308411870FEAF826C2441725AE822EC6308410A552E90A96C2441DC20BA0FE263084123AC0B76D16C24413C8D3ADED46308413997D066F26C244166D104F5C26308410A5B839A076D2441642EDA13C2630841	45593	Beskid Niski	PLB180002	PL.ZIPOP.1393.N2K.PLB180002.B
2	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	45479	Ostoja Witnicko-Dębniańska	PLB320015	PL.ZIPOP.1393.N2K.PLB320015.B
3	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	45478	Lasy Puszczy nad Drawą	PLB320016	PL.ZIPOP.1393.N2K.PLB320016.B
4	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	45480	Puszcza Barlinecka	PLB080001	PL.ZIPOP.1393.N2K.PLB080001.B
5	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